/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.global.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class GlobalUtil {
    public static String getVersion() {
        return "1.8.5";
    }

    public static String getFileExtension(String filePath) {
        String extension = "";
        String fn = new File(filePath).getName();
        if (fn.contains(".")) {
            String ext = filePath.substring(filePath.lastIndexOf(".") + 1).toLowerCase().trim();
            try {
                extension = ext;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return extension;
    }

    public static List<String> getFiles(String directory, String ext) {
        ArrayList<String> fileNames = new ArrayList<String>();
        try {
            File f = new File(directory);
            boolean flag = f.isDirectory();
            if (flag) {
                File[] fs = f.listFiles();
                for (int i = 0; i < fs.length; ++i) {
                    if (!fs[i].isDirectory()) {
                        String filename = fs[i].getAbsolutePath();
                        if (!filename.endsWith(ext.trim())) continue;
                        fileNames.add(filename);
                        continue;
                    }
                    fileNames.addAll(GlobalUtil.getFiles(fs[i].getAbsolutePath(), ext));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileNames;
    }

    public static List<String> getSubDirectories(String directory) {
        File[] fs;
        ArrayList<String> subDirs = new ArrayList<String>();
        File f = new File(directory);
        for (File f1 : fs = f.listFiles()) {
            if (!f1.isDirectory()) continue;
            subDirs.add(f1.getPath());
        }
        return subDirs;
    }

    public static List<String> getClassNames(String jarFileName) throws FileNotFoundException, IOException {
        ArrayList<String> classNames = new ArrayList<String>();
        ZipInputStream zip = new ZipInputStream(new FileInputStream(jarFileName));
        ZipEntry entry = zip.getNextEntry();
        while (entry != null) {
            if (entry.getName().endsWith(".class") && !entry.isDirectory()) {
                StringBuilder className = new StringBuilder();
                for (String part : entry.getName().split("/")) {
                    if (className.length() != 0) {
                        className.append(".");
                    }
                    className.append(part);
                    if (!part.endsWith(".class")) continue;
                    className.setLength(className.length() - ".class".length());
                }
                classNames.add(className.toString());
            }
            entry = zip.getNextEntry();
        }
        return classNames;
    }

    public static String getPluginClassName(String jarFileName) {
        String pluginClassName = null;
        try {
            List<String> classNames = GlobalUtil.getClassNames(jarFileName);
            URL url = new URL("file:" + jarFileName);
            URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{url});
            for (String name : classNames) {
                Class<?> clazz = urlClassLoader.loadClass(name);
                if (!GlobalUtil.isInterface(clazz, "org.meteoinfo.plugin.IPlugin")) continue;
                pluginClassName = name;
                break;
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(GlobalUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(GlobalUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(GlobalUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        return pluginClassName;
    }

    public static List<Class> getClassesInPackage(String packageName) {
        ArrayList<Class> classes = new ArrayList<Class>();
        String packageNameSlashed = "/" + packageName.replace(".", "/");
        URL directoryURL = Thread.currentThread().getContextClassLoader().getResource(packageNameSlashed);
        if (directoryURL == null) {
            System.out.println("Could not retrieve URL resource: " + packageNameSlashed);
            return classes;
        }
        String directoryString = directoryURL.getFile();
        if (directoryString == null) {
            System.out.println("Could not find directory for URL resource: " + packageNameSlashed);
            return classes;
        }
        File directory = new File(directoryString);
        if (directory.exists()) {
            String[] files;
            for (String fileName : files = directory.list()) {
                if (!fileName.endsWith(".class")) continue;
                fileName = fileName.substring(0, fileName.length() - 6);
                try {
                    classes.add(Class.forName(packageName + "." + fileName));
                }
                catch (ClassNotFoundException e) {
                    System.out.println(packageName + "." + fileName + " does not appear to be a valid class.");
                }
            }
        } else {
            System.out.println(packageName + " does not appear to exist as a valid package on the file system.");
        }
        return classes;
    }

    public static List<String> getFilesInPackage(String packageName) {
        ArrayList<String> fns = new ArrayList<String>();
        String packageNameSlashed = packageName.replace(".", "/");
        URL directoryURL = Thread.currentThread().getContextClassLoader().getResource(packageNameSlashed);
        if (directoryURL == null) {
            System.out.println("Could not retrieve URL resource: " + packageNameSlashed);
            return fns;
        }
        String directoryString = directoryURL.getFile();
        if (directoryString == null) {
            System.out.println("Could not find directory for URL resource: " + packageNameSlashed);
            return fns;
        }
        File directory = new File(directoryString);
        if (directory.exists()) {
            String[] files;
            for (String fileName : files = directory.list()) {
                fns.add(fileName);
            }
        } else {
            System.out.println(packageName + " does not appear to exist as a valid package on the file system.");
        }
        return fns;
    }

    public static boolean isInterface(Class c, String szInterface) {
        Class<?>[] face = c.getInterfaces();
        int j = face.length;
        for (int i = 0; i < j; ++i) {
            if (face[i].getName().equals(szInterface)) {
                return true;
            }
            Class<?>[] face1 = face[i].getInterfaces();
            for (int x = 0; x < face1.length; ++x) {
                if (face1[x].getName().equals(szInterface)) {
                    return true;
                }
                if (!GlobalUtil.isInterface(face1[x], szInterface)) continue;
                return true;
            }
        }
        if (null != c.getSuperclass()) {
            return GlobalUtil.isInterface(c.getSuperclass(), szInterface);
        }
        return false;
    }

    public static String getPathRoot(File aFile) {
        File path = aFile.getParentFile();
        String pathRoot = path.toString();
        while (path != null) {
            if ((path = path.getParentFile()) == null) continue;
            pathRoot = path.toString();
        }
        return pathRoot;
    }

    public static String getRelativePath(String fileName, String projFile) throws IOException {
        String projPathRoot;
        String RelativePath = "";
        File aFile = new File(fileName);
        File pFile = new File(projFile);
        fileName = aFile.getCanonicalPath();
        String layerPathRoot = GlobalUtil.getPathRoot(aFile);
        if (!layerPathRoot.equalsIgnoreCase(projPathRoot = GlobalUtil.getPathRoot(pFile))) {
            RelativePath = fileName;
        } else {
            ArrayList<String> aList = new ArrayList<String>();
            aList.add(fileName);
            do {
                aList.add("");
                File tempFile = new File((String)aList.get(aList.size() - 2));
                if (!tempFile.exists() || tempFile.getParent() == null) break;
                aList.set(aList.size() - 1, tempFile.getParent());
            } while (!"".equals(aList.get(aList.size() - 1)));
            ArrayList<String> bList = new ArrayList<String>();
            bList.add(pFile.getCanonicalPath());
            do {
                bList.add("");
                File tempFile = new File((String)bList.get(bList.size() - 2));
                if (tempFile.getParent() == null) break;
                bList.set(bList.size() - 1, tempFile.getParent());
            } while (!"".equals(bList.get(bList.size() - 1)));
            boolean ifExist = false;
            for (int i = 0; i < aList.size(); ++i) {
                for (int j = 0; j < bList.size(); ++j) {
                    if (!((String)aList.get(i)).equals(bList.get(j))) continue;
                    for (int k = 1; k < j; ++k) {
                        RelativePath = RelativePath + ".." + File.separator;
                    }
                    int offSet = ((String)aList.get(i)).endsWith(File.separator) ? 0 : 1;
                    RelativePath = RelativePath + fileName.substring(((String)aList.get(i)).length() + offSet);
                    ifExist = true;
                    break;
                }
                if (ifExist) break;
            }
        }
        if ("".equals(RelativePath)) {
            RelativePath = fileName;
        }
        return RelativePath;
    }

    public static BufferedImage imageToBufferedImage(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return bufferedImage;
    }

    public static Image makeColorTransparent(BufferedImage im, final Color color) {
        RGBImageFilter filter = new RGBImageFilter(){
            public int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
            }

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    public static String getAppPath(Class cls) {
        URL url;
        String realPath;
        int pos;
        if (cls == null) {
            throw new IllegalArgumentException("The parameter can not be null!");
        }
        ClassLoader loader = cls.getClassLoader();
        String clsName = cls.getName() + ".class";
        Package pack = cls.getPackage();
        String path = "";
        if (pack != null) {
            String packName = pack.getName();
            if (packName.startsWith("java.") || packName.startsWith("javax.")) {
                throw new IllegalArgumentException("Dont use Java system class!");
            }
            clsName = clsName.substring(packName.length() + 1);
            if (!packName.contains(".")) {
                path = packName + "/";
            } else {
                int start = 0;
                int end = packName.indexOf(".");
                while (end != -1) {
                    path = path + packName.substring(start, end) + "/";
                    start = end + 1;
                    end = packName.indexOf(".", start);
                }
                path = path + packName.substring(start) + "/";
            }
        }
        if ((pos = (realPath = (url = loader.getResource(path + clsName)).getPath()).indexOf("file:")) > -1) {
            realPath = realPath.substring(pos + 5);
        }
        if ((realPath = realPath.substring(0, (pos = realPath.indexOf(path + clsName)) - 1)).endsWith("!")) {
            realPath = realPath.substring(0, realPath.lastIndexOf("/"));
        }
        try {
            realPath = URLDecoder.decode(realPath, "utf-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return realPath;
    }

    public static String padLeft(String str, int length, char ch) {
        for (int i = str.length(); i < length; ++i) {
            str = ch + str;
        }
        return str;
    }

    public static String padRight(String str, int length, char ch) {
        for (int i = str.length(); i < length; ++i) {
            str = str + ch;
        }
        return str;
    }

    public static Object deepCopy(Object oldObj) throws Exception {
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(oldObj);
            oos.flush();
            ByteArrayInputStream bin = new ByteArrayInputStream(bos.toByteArray());
            ois = new ObjectInputStream(bin);
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            System.out.println("Exception in ObjectCloner = " + e);
            throw e;
        }
        finally {
            oos.close();
            ois.close();
        }
    }

    public static BufferedImage deepCopy(BufferedImage bi) {
        ColorModel cm = bi.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = bi.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    public static String getDefaultFontName() {
        String fn;
        String[] fontnames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        List<String> fns = Arrays.asList(fontnames);
        if (!fns.contains(fn = "\u5b8b\u4f53")) {
            fn = "Arial";
        }
        if (!fns.contains(fn)) {
            fn = fontnames[0];
        }
        return fn;
    }

    public static String getDelimiter(String line) {
        String separator = null;
        if (line.contains(",")) {
            separator = ",";
        } else if (line.contains(";")) {
            separator = ";";
        }
        return separator;
    }

    public static String getDelimiter(File file) throws FileNotFoundException, IOException {
        BufferedReader sr = new BufferedReader(new FileReader(file));
        String line = sr.readLine();
        sr.close();
        return GlobalUtil.getDelimiter(line);
    }

    public static String[] split(String line, String separator) {
        if (separator == null || separator.equals(" ")) {
            return line.split("\\s+");
        }
        String[] strs = line.split(separator);
        ArrayList<String> r = new ArrayList<String>();
        for (String s : strs) {
            r.add(s.trim());
        }
        strs = r.toArray(new String[1]);
        return strs;
    }

    public static String capitalize(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        char[] charArray = str.toCharArray();
        charArray[0] = Character.toUpperCase(charArray[0]);
        return new String(charArray);
    }
}

