/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.global.util;

public final class MercatorUtils {
    private MercatorUtils() {
    }

    public static int longToX(double longitudeDegrees, double radius) {
        double longitude = Math.toRadians(longitudeDegrees);
        return (int)(radius * longitude);
    }

    public static int latToY(double latitudeDegrees, double radius) {
        double latitude = Math.toRadians(latitudeDegrees);
        double y = radius / 2.0 * Math.log((1.0 + Math.sin(latitude)) / (1.0 - Math.sin(latitude)));
        return (int)y;
    }

    public static double xToLong(int x, double radius) {
        double longRadians = (double)x / radius;
        double longDegrees = Math.toDegrees(longRadians);
        int rotations = (int)Math.floor((longDegrees + 180.0) / 360.0);
        double longitude = longDegrees - (double)(rotations * 360);
        return longitude;
    }

    public static double yToLat(int y, double radius) {
        double latitude = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-1.0 * (double)y / radius));
        return Math.toDegrees(latitude);
    }
}

