/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.io.EncodingDetect;
import org.meteoinfo.io.FileCharsetDetector;

public class IOUtil {
    public static String getFileChart(String filePath) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(filePath));
        int p = (bin.read() << 8) + bin.read();
        bin.close();
        String code = null;
        switch (p) {
            case 61371: {
                code = "UTF-8";
                break;
            }
            case 65534: {
                code = "Unicode";
                break;
            }
            case 65279: {
                code = "UTF-16BE";
                break;
            }
            default: {
                code = "GBK";
            }
        }
        return code;
    }

    public static String guessFileEncoding(String filePath) throws IOException {
        FileCharsetDetector fcd = new FileCharsetDetector();
        String encoding = fcd.guestFileEncoding(filePath);
        return encoding;
    }

    public static String encodingDetect(String filePath) {
        return IOUtil.encodingDetect(new File(filePath));
    }

    public static String encodingDetect(File file) {
        EncodingDetect detect = new EncodingDetect();
        int encodingNumber = detect.detectEncoding(file);
        String name = EncodingDetect.javaname[encodingNumber];
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encodingDetectShp(String shpfilepath) {
        String dbffilepath;
        File dbfFile;
        String cpgfilepath = shpfilepath.replaceFirst(shpfilepath.substring(shpfilepath.lastIndexOf(".")), ".cpg");
        File cpgFile = new File(cpgfilepath);
        if (cpgFile.exists()) {
            BufferedReader sr = null;
            try {
                sr = new BufferedReader(new FileReader(cpgFile));
                String ec = sr.readLine().trim();
                sr.close();
                String string = ec;
                return string;
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    if (sr != null) {
                        sr.close();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        if (!(dbfFile = new File(dbffilepath = shpfilepath.replace(shpfilepath.substring(shpfilepath.lastIndexOf(".")), ".dbf"))).exists()) {
            dbffilepath = dbffilepath.replace(".dbf", ".DBF");
            dbfFile = new File(dbffilepath);
        }
        if (!dbfFile.exists()) {
            System.out.println(".dbf file not exists!");
            return null;
        }
        return IOUtil.encodingDetect(dbfFile);
    }
}

