/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.layer;

import org.meteoinfo.global.Extent;
import org.meteoinfo.layer.LayerDrawType;
import org.meteoinfo.layer.LayerTypes;
import org.meteoinfo.layer.VisibleScale;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.info.ProjectionInfo;
import org.meteoinfo.shape.ShapeTypes;

public class MapLayer
implements Cloneable {
    private LayerTypes _layerType;
    private ShapeTypes _shapeType;
    private int _handle;
    private String _layerName = "layer";
    private String _fileName = "";
    private ProjectionInfo _projInfo;
    private Extent _extent;
    private boolean _visible;
    private LayerDrawType _layerDrawType;
    private boolean _isMaskout;
    private LegendScheme _legendScheme;
    private boolean _expanded;
    private int _transparencyPerc;
    private String _tag;
    private VisibleScale _visibleScale;

    public MapLayer() {
        this._projInfo = KnownCoordinateSystems.geographic.world.WGS1984;
        this._handle = -1;
        this._extent = new Extent();
        this._visible = true;
        this._isMaskout = false;
        this._expanded = false;
        this._transparencyPerc = 0;
        this._layerDrawType = LayerDrawType.Map;
        this._tag = "";
        this._visibleScale = new VisibleScale();
    }

    public LayerTypes getLayerType() {
        return this._layerType;
    }

    public void setLayerType(LayerTypes lt) {
        this._layerType = lt;
    }

    public ShapeTypes getShapeType() {
        return this._shapeType;
    }

    public void setShapeType(ShapeTypes st) {
        this._shapeType = st;
    }

    public LayerDrawType getLayerDrawType() {
        return this._layerDrawType;
    }

    public void setLayerDrawType(LayerDrawType ldt) {
        this._layerDrawType = ldt;
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String fn) {
        this._fileName = fn;
    }

    public int getHandle() {
        return this._handle;
    }

    public void setHandle(int handle) {
        this._handle = handle;
    }

    public String getLayerName() {
        return this._layerName;
    }

    public void setLayerName(String lName) {
        this._layerName = lName;
    }

    public Extent getExtent() {
        return this._extent;
    }

    public void setExtent(Extent extent) {
        this._extent = extent;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void setVisible(boolean isTrue) {
        this._visible = isTrue;
    }

    public LegendScheme getLegendScheme() {
        return this._legendScheme;
    }

    public boolean isMaskout() {
        return this._isMaskout;
    }

    public void setMaskout(boolean istrue) {
        this._isMaskout = istrue;
    }

    public void setLegendScheme(LegendScheme ls) {
        this._legendScheme = ls;
    }

    public int getTransparency() {
        return this._transparencyPerc;
    }

    public void setTransparency(int trans) {
        this._transparencyPerc = trans;
    }

    public boolean isExpanded() {
        return this._expanded;
    }

    public void setExpanded(boolean istrue) {
        this._expanded = istrue;
    }

    public ProjectionInfo getProjInfo() {
        return this._projInfo;
    }

    public void setProjInfo(ProjectionInfo projInfo) {
        this._projInfo = projInfo;
    }

    public String getTag() {
        return this._tag;
    }

    public void setTag(String value) {
        this._tag = value;
    }

    public VisibleScale getVisibleScale() {
        return this._visibleScale;
    }

    public void setVisibleScale(VisibleScale value) {
        this._visibleScale = value;
    }

    public boolean hasLegendScheme() {
        return this._legendScheme != null;
    }

    public Object clone() throws CloneNotSupportedException {
        MapLayer aLayer = (MapLayer)super.clone();
        if (this._legendScheme != null) {
            aLayer._legendScheme = (LegendScheme)this._legendScheme.clone();
        }
        return aLayer;
    }

    public String toString() {
        return this.getLayerName();
    }

    public String getLayerInfo() {
        String str = "Layer name: " + this.getLayerName();
        str = str + System.getProperty("line.separator") + "Layer file: " + this.getFileName();
        str = str + System.getProperty("line.separator") + "Layer type: " + (Object)((Object)this.getLayerType());
        str = str + System.getProperty("line.separator") + "Shape type: " + (Object)((Object)this.getShapeType());
        return str;
    }

    public void saveFile() {
    }

    public void saveFile(String fileName) {
    }
}

