/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.layout;

import com.l2fprod.common.beans.BaseBeanInfo;
import com.l2fprod.common.beans.ExtendedPropertyDescriptor;
import com.l2fprod.common.beans.editor.ComboBoxPropertyEditor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.drawing.Draw;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.PointF;
import org.meteoinfo.global.event.IMapViewUpdatedListener;
import org.meteoinfo.global.event.MapViewUpdatedEvent;
import org.meteoinfo.layer.LayerDrawType;
import org.meteoinfo.layer.LayerTypes;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.layout.ElementType;
import org.meteoinfo.layout.LayerUpdateTypes;
import org.meteoinfo.layout.LayoutElement;
import org.meteoinfo.layout.LayoutMap;
import org.meteoinfo.layout.LegendStyles;
import org.meteoinfo.layout.MapLayout;
import org.meteoinfo.layout.ResizeAbility;
import org.meteoinfo.legend.ChartBreak;
import org.meteoinfo.legend.ChartTypes;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.LegendType;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.legend.PolylineBreak;
import org.meteoinfo.shape.ShapeTypes;

public class LayoutLegend
extends LayoutElement {
    private MapLayout _mapLayout;
    private static LayoutMap _layoutMap;
    private MapLayer _legendLayer;
    private boolean forceDrawOutline;
    private boolean _isAntiAlias;
    private LayerUpdateTypes _layerUpdateType;
    private LegendStyles _legendStyle;
    private String _title;
    private Font _font;
    private Font _titleFont;
    private boolean _drawNeatLine;
    private Color _neatLineColor;
    private float _neatLineSize;
    private float _breakSpace;
    private float _topSpace;
    private float _leftSpace;
    private float _vBarWidth;
    private float _hBarHeight;
    private int _columnNum = 1;
    private boolean drawChartBreaks = true;
    private boolean drawPieLabel = false;

    public LayoutLegend(MapLayout mapLayout, LayoutMap layoutMap) {
        this.setElementType(ElementType.LayoutLegend);
        this.setResizeAbility(ResizeAbility.ResizeAll);
        this._mapLayout = mapLayout;
        _layoutMap = layoutMap;
        _layoutMap.addMapViewUpdatedListener(new IMapViewUpdatedListener(){

            @Override
            public void mapViewUpdatedEvent(MapViewUpdatedEvent event) {
                LayoutLegend.this.onMapViewUpdated(event);
            }
        });
        this._isAntiAlias = true;
        this.forceDrawOutline = true;
        this._layerUpdateType = LayerUpdateTypes.FirstMeteoLayer;
        this._legendStyle = LegendStyles.Normal;
        this._title = "";
        this._drawNeatLine = false;
        this._neatLineColor = Color.black;
        this._neatLineSize = 1.0f;
        this._breakSpace = 3.0f;
        this._topSpace = 5.0f;
        this._leftSpace = 5.0f;
        this._vBarWidth = 10.0f;
        this._hBarHeight = 10.0f;
        this._font = new Font("\u5b8b\u4f53", 0, 12);
        this._titleFont = new Font("Arial", 0, 12);
    }

    public void onMapViewUpdated(MapViewUpdatedEvent e) {
        if (_layoutMap.getMapFrame().getMapView().getLayerNum() == 0) {
            return;
        }
        block0 : switch (this._layerUpdateType) {
            case FirstExpandedLayer: {
                for (int i = 0; i < _layoutMap.getMapFrame().getMapView().getLayerNum(); ++i) {
                    MapLayer aLayer = (MapLayer)_layoutMap.getMapFrame().getMapView().getLayers().get(_layoutMap.getMapFrame().getMapView().getLayerNum() - 1 - i);
                    if (!aLayer.hasLegendScheme() || !aLayer.isVisible() || !aLayer.isExpanded() || aLayer.getLegendScheme().getLegendType() == LegendType.SingleSymbol) continue;
                    this.setVisible(true);
                    this.setLegendLayer(aLayer);
                    break block0;
                }
                break;
            }
            case FirstMeteoLayer: {
                for (int i = 0; i < _layoutMap.getMapFrame().getMapView().getLayerNum(); ++i) {
                    MapLayer aLayer = (MapLayer)_layoutMap.getMapFrame().getMapView().getLayers().get(_layoutMap.getMapFrame().getMapView().getLayerNum() - 1 - i);
                    if (!aLayer.hasLegendScheme() || !aLayer.isVisible() || aLayer.getLayerDrawType() == LayerDrawType.Map || aLayer.getLegendScheme().getLegendType() == LegendType.SingleSymbol) continue;
                    this.setVisible(true);
                    this.setLegendLayer(aLayer);
                    break block0;
                }
                break;
            }
            case LastAddedLayer: {
                if (!_layoutMap.getMapFrame().getMapView().getLastAddedLayer().hasLegendScheme()) break;
                this.setVisible(true);
                this.setLegendLayer(_layoutMap.getMapFrame().getMapView().getLastAddedLayer());
            }
        }
        this.updateLegendSize();
    }

    public LayoutMap getLayoutMap() {
        return _layoutMap;
    }

    public MapLayer getLegendLayer() {
        return this._legendLayer;
    }

    public void setLegendLayer(MapLayer layer) {
        if (layer == null) {
            return;
        }
        this._legendLayer = layer;
        String aStr = this._legendLayer.getLayerName();
        if (aStr.contains("_")) {
            aStr = aStr.split("_")[1];
        }
        this._title = aStr;
        this.updateLegendSize();
    }

    public String getLayerName() {
        if (this._legendLayer != null) {
            return this._legendLayer.getLayerName();
        }
        return "";
    }

    public void setLayerName(String name) {
        MapLayer aLayer = _layoutMap.getMapFrame().getMapView().getLayer(name);
        if (aLayer != null) {
            this._legendLayer = aLayer;
        }
    }

    public boolean isForceDrawOutline() {
        return this.forceDrawOutline;
    }

    public void setForceDrawOutline(boolean value) {
        this.forceDrawOutline = value;
    }

    public LayerUpdateTypes getLayerUpdateType() {
        return this._layerUpdateType;
    }

    public void setLayerUpdateType(LayerUpdateTypes type) {
        this._layerUpdateType = type;
    }

    public LegendStyles getLegendStyle() {
        return this._legendStyle;
    }

    public void setLegendStyle(LegendStyles style) {
        this._legendStyle = style;
        if (this.isVisible()) {
            this.updateLegendSize();
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
        this.updateLegendSize();
    }

    public boolean isDrawNeatLine() {
        return this._drawNeatLine;
    }

    public void setDrawNeatLine(boolean istrue) {
        this._drawNeatLine = istrue;
    }

    public Color getNeatLineColor() {
        return this._neatLineColor;
    }

    public void setNeatLineColor(Color color) {
        this._neatLineColor = color;
    }

    public float getNeatLineSize() {
        return this._neatLineSize;
    }

    public void setNeatLineSize(float size) {
        this._neatLineSize = size;
    }

    public Font getFont() {
        return this._font;
    }

    public void setFont(Font font) {
        this._font = font;
        this._titleFont = new Font(this._font.getFontName(), 0, this._font.getSize() + 2);
        this.updateLegendSize();
    }

    public int getColumnNumber() {
        return this._columnNum;
    }

    public void setColumnNumber(int value) {
        this._columnNum = value;
    }

    public boolean isDrawChartBreaks() {
        return this.drawChartBreaks;
    }

    public void setDrawChartBreaks(boolean value) {
        this.drawChartBreaks = value;
    }

    public boolean isDrawPieLabel() {
        return this.drawPieLabel;
    }

    public void setDrawPieLabel(boolean value) {
        this.drawPieLabel = value;
    }

    public void paintGraphics(Graphics2D g, PointF pageLocation, float zoom) {
        if (this._legendLayer == null) {
            return;
        }
        if (this._legendLayer.getLayerType() == LayerTypes.ImageLayer) {
            return;
        }
        AffineTransform oldMatrix = g.getTransform();
        PointF aP = this.pageToScreen(this.getLeft(), this.getTop(), pageLocation, zoom);
        g.translate(aP.X, aP.Y);
        g.scale(zoom, zoom);
        if (this._isAntiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.isDrawBackColor()) {
            g.setColor(this.getBackColor());
            g.fill(new Rectangle2D.Float(0.0f, 0.0f, (float)this.getWidth() * zoom, (float)this.getHeight() * zoom));
        }
        int gap = this.getTickGap(g);
        switch (this._legendStyle) {
            case Bar_Horizontal: {
                if (gap > 1) {
                    this.drawHorizontalBarLegend_Ex(g, zoom);
                    break;
                }
                this.drawHorizontalBarLegend(g, zoom);
                break;
            }
            case Bar_Vertical: {
                if (gap > 1) {
                    this.drawVerticalBarLegend_Ex(g, zoom);
                    break;
                }
                this.drawVerticalBarLegend(g, zoom);
                break;
            }
            case Normal: {
                this.drawNormalLegend(g, zoom);
            }
        }
        if (this._drawNeatLine) {
            Rectangle2D.Float mapRect = new Rectangle2D.Float(this._neatLineSize - 1.0f, this._neatLineSize - 1.0f, ((float)this.getWidth() - this._neatLineSize) * zoom, ((float)this.getHeight() - this._neatLineSize) * zoom);
            g.setColor(this._neatLineColor);
            g.setStroke(new BasicStroke(this._neatLineSize));
            g.draw(mapRect);
        }
        g.setTransform(oldMatrix);
    }

    private void drawChartLegend(Graphics2D g, float zoom, PointF aPoint, boolean drawBreaks) {
        VectorLayer aLayer = (VectorLayer)this._legendLayer;
        ChartBreak aCB = ((ChartBreak)aLayer.getChartPoints().get(0).getLegend()).getSampleChartBreak();
        aPoint.X = 5.0f;
        aPoint.Y += (float)aCB.getHeight();
        switch (aCB.getChartType()) {
            case BarChart: {
                Draw.drawBarChartSymbol(aPoint, aCB, g, true);
                break;
            }
            case PieChart: {
                if (this.drawChartBreaks) {
                    Draw.drawPieChartSymbol(aPoint, aCB, g, null);
                } else {
                    ArrayList<String> rStrs = new ArrayList<String>();
                    for (int i = 0; i < aCB.getItemNum(); ++i) {
                        rStrs.add(aCB.getLegendScheme().getLegendBreaks().get(i).getCaption());
                    }
                    Draw.drawPieChartSymbol(aPoint, aCB, g, rStrs);
                }
                aPoint.Y += (float)aCB.getHeight();
            }
        }
        aPoint.Y += this._breakSpace;
        if (drawBreaks) {
            LegendScheme aLS = aCB.getLegendScheme();
            this.drawNormalLegend(g, zoom, aLS, aPoint, false);
        }
    }

    private void drawNormalLegend(Graphics2D g, float zoom) {
        boolean drawChart = false;
        if (this._legendLayer.getLayerType() == LayerTypes.VectorLayer && ((VectorLayer)this._legendLayer).getChartSet().isDrawCharts()) {
            drawChart = true;
        }
        PointF aP = new PointF(0.0f, 0.0f);
        LegendScheme aLS = this._legendLayer.getLegendScheme();
        this.drawNormalLegend(g, zoom, aLS, aP, true);
        float height = (float)this.getBreakHeight(g) * zoom;
        aP.Y += height + this._breakSpace;
        if (drawChart) {
            this.drawChartLegend(g, zoom, aP, this.drawChartBreaks);
        }
    }

    private void drawNormalLegend(Graphics2D g, float zoom, LegendScheme aLS, PointF aP, boolean drawTitle) {
        int i;
        Dimension aSF;
        String caption = "";
        float leftSpace = this._leftSpace * zoom;
        float topSpace = this._topSpace * zoom;
        float breakSpace = this._breakSpace * zoom;
        float height = (float)this.getBreakHeight(g) * zoom;
        float width = height * 2.0f;
        float colWidth = this.getBreakHeight(g) * 2 + this.getLabelWidth(g) + 10;
        if (drawTitle) {
            Font tFont = new Font(this._titleFont.getFontName(), this._titleFont.getStyle(), (int)((float)this._titleFont.getSize() * zoom));
            String Title = this._title;
            aP.X = leftSpace;
            aP.Y = leftSpace;
            FontMetrics metrics = g.getFontMetrics(tFont);
            aSF = new Dimension(metrics.stringWidth(Title), metrics.getHeight());
            float titleHeight = aSF.height;
            g.setColor(this.getForeColor());
            g.setFont(tFont);
            g.drawString(this._title, aP.X, aP.Y + (float)(aSF.height * 3 / 4));
            aP.Y += titleHeight + breakSpace - height / 2.0f;
        }
        int[] rowNums = new int[this._columnNum];
        int ave = aLS.getVisibleBreakNum() / this._columnNum;
        int num = 0;
        for (i = 1; i < this._columnNum; ++i) {
            rowNums[i] = ave;
            num += ave;
        }
        rowNums[0] = aLS.getVisibleBreakNum() - num;
        Font lFont = new Font(this.getFont().getFontName(), this.getFont().getStyle(), (int)((float)this.getFont().getSize() * zoom));
        float sX = aP.X;
        float sY = aP.Y;
        i = 0;
        for (int col = 0; col < this._columnNum; ++col) {
            aP.X = width / 2.0f + leftSpace + (float)col * colWidth;
            aP.Y = sY;
            for (int row = 0; row < rowNums[col]; ++row) {
                if (!aLS.getLegendBreaks().get(i).isDrawShape()) {
                    ++i;
                    --row;
                    continue;
                }
                aP.Y += height + breakSpace;
                switch (aLS.getShapeType()) {
                    case Point: {
                        PointBreak aPB = (PointBreak)((PointBreak)aLS.getLegendBreaks().get(i)).clone();
                        caption = aPB.getCaption();
                        aPB.setSize(aPB.getSize() * zoom);
                        Draw.drawPoint((PointF)aP.clone(), aPB, g);
                        break;
                    }
                    case Polyline: 
                    case PolylineZ: {
                        PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(i);
                        caption = aPLB.getCaption();
                        Draw.drawPolylineSymbol((PointF)aP.clone(), width, height, aPLB, g);
                        break;
                    }
                    case Polygon: {
                        PolygonBreak aPGB = (PolygonBreak)aLS.getLegendBreaks().get(i);
                        caption = aPGB.getCaption();
                        if (this.forceDrawOutline) {
                            aPGB = (PolygonBreak)aPGB.clone();
                            aPGB.setDrawOutline(true);
                        }
                        Draw.drawPolygonSymbol((PointF)aP.clone(), width, height, aPGB, g);
                        break;
                    }
                    case Image: {
                        ColorBreak aCB = aLS.getLegendBreaks().get(i);
                        caption = aCB.getCaption();
                        Draw.drawPolygonSymbol((PointF)aP.clone(), aCB.getColor(), Color.black, width, height, true, true, g);
                    }
                }
                PointF sP = new PointF(0.0f, 0.0f);
                sP.X = aP.X + width / 2.0f;
                sP.Y = aP.Y;
                FontMetrics metrics = g.getFontMetrics(lFont);
                aSF = new Dimension(metrics.stringWidth(caption), metrics.getHeight());
                g.setColor(this.getForeColor());
                g.setFont(lFont);
                g.drawString(caption, sP.X + 5.0f, sP.Y + (float)(aSF.height / 4));
                ++i;
            }
        }
    }

    private int getTickGap(Graphics2D g) {
        int nn;
        int n = this._legendLayer.getLegendScheme().getBreakNum();
        if (this.getLegendStyle() == LegendStyles.Bar_Horizontal) {
            double len = this.getWidth();
            int labLen = this.getLabelWidth(g);
            nn = (int)(len * 0.8 / (double)labLen);
        } else {
            double len = this.getHeight();
            FontMetrics metrics = g.getFontMetrics(this._font);
            nn = (int)(len / (double)metrics.getHeight());
        }
        if (nn == 0) {
            nn = 1;
        }
        return n / nn + 1;
    }

    private void drawVerticalBarLegend(Graphics2D g, float zoom) {
        LegendScheme aLS = this._legendLayer.getLegendScheme();
        PointF aP = new PointF(0.0f, 0.0f);
        PointF sP = new PointF(0.0f, 0.0f);
        boolean DrawShape = true;
        boolean DrawFill = true;
        boolean DrawOutline = true;
        Color FillColor = Color.red;
        Color OutlineColor = this.getForeColor();
        String caption = "";
        int bNum = aLS.getBreakNum();
        if (aLS.getLegendBreaks().get(bNum - 1).isNoData()) {
            --bNum;
        }
        this._vBarWidth = this.getWidth() - this.getLabelWidth(g) - 5;
        float width = this._vBarWidth * zoom;
        float height = (float)(this.getHeight() - 5) * zoom / (float)bNum;
        Font lFont = new Font(this.getFont().getFontName(), this.getFont().getStyle(), (int)((float)this.getFont().getSize() * zoom));
        boolean order = true;
        if (aLS.getBreakNum() > 1) {
            try {
                double v1 = Double.parseDouble(aLS.getLegendBreaks().get(0).getEndValue().toString());
                double v2 = Double.parseDouble(aLS.getLegendBreaks().get(1).getEndValue().toString());
                if (v2 < v1) {
                    order = false;
                }
            }
            catch (Exception v1) {
                // empty catch block
            }
        }
        for (int i = 0; i < bNum; ++i) {
            Dimension aSF;
            int idx = order ? bNum - i - 1 : i;
            switch (aLS.getShapeType()) {
                case Point: {
                    PointBreak aPB = (PointBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPB.isDrawShape();
                    DrawFill = aPB.isDrawFill();
                    FillColor = aPB.getColor();
                    if (aLS.getLegendType() == LegendType.UniqueValue) {
                        caption = aPB.getCaption();
                        break;
                    }
                    if (!order) {
                        caption = DataConvert.removeTailingZeros(aPB.getEndValue().toString());
                        break;
                    }
                    caption = DataConvert.removeTailingZeros(aPB.getStartValue().toString());
                    break;
                }
                case Polyline: 
                case PolylineZ: {
                    PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPLB.getDrawPolyline();
                    FillColor = aPLB.getColor();
                    if (aLS.getLegendType() == LegendType.UniqueValue) {
                        caption = aPLB.getCaption();
                        break;
                    }
                    if (!order) {
                        caption = DataConvert.removeTailingZeros(aPLB.getEndValue().toString());
                        break;
                    }
                    caption = DataConvert.removeTailingZeros(aPLB.getStartValue().toString());
                    break;
                }
                case Polygon: {
                    PolygonBreak aPGB = (PolygonBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPGB.isDrawShape();
                    DrawFill = aPGB.isDrawFill();
                    FillColor = aPGB.getColor();
                    if (aLS.getLegendType() == LegendType.UniqueValue) {
                        caption = aPGB.getCaption();
                        break;
                    }
                    if (!order) {
                        caption = DataConvert.removeTailingZeros(aPGB.getEndValue().toString());
                        break;
                    }
                    caption = DataConvert.removeTailingZeros(aPGB.getStartValue().toString());
                    break;
                }
                case Image: {
                    ColorBreak aCB = aLS.getLegendBreaks().get(idx);
                    DrawShape = true;
                    DrawFill = true;
                    FillColor = aCB.getColor();
                    caption = aLS.getLegendType() == LegendType.UniqueValue ? aCB.getCaption() : (!order ? DataConvert.removeTailingZeros(aCB.getEndValue().toString()) : DataConvert.removeTailingZeros(aCB.getStartValue().toString()));
                }
            }
            aP.X = width / 2.0f;
            aP.Y = (float)i * height + height / 2.0f;
            if (aLS.getLegendType() == LegendType.UniqueValue) {
                if (DrawShape) {
                    if (aLS.getShapeType() == ShapeTypes.Polygon) {
                        PolygonBreak aPGB = (PolygonBreak)aLS.getLegendBreaks().get(idx).clone();
                        aPGB.setDrawOutline(true);
                        aPGB.setOutlineColor(Color.black);
                        Draw.drawPolygonSymbol((PointF)aP.clone(), width, height, aPGB, g);
                    } else {
                        Draw.drawPolygonSymbol((PointF)aP.clone(), FillColor, OutlineColor, width, height, DrawFill, DrawOutline, g);
                    }
                }
                sP.X = aP.X + width / 2.0f + 5.0f;
                sP.Y = aP.Y;
                FontMetrics metrics = g.getFontMetrics(lFont);
                aSF = new Dimension(metrics.stringWidth(caption), metrics.getHeight());
                g.setColor(this.getForeColor());
                g.setFont(lFont);
                g.drawString(caption, sP.X, sP.Y + (float)(aSF.height / 2));
                continue;
            }
            if (DrawShape) {
                PolygonBreak aPGB;
                if (i == 0) {
                    PointF[] Points = new PointF[4];
                    Points[0] = new PointF();
                    Points[0].X = aP.X;
                    Points[0].Y = 0.0f;
                    Points[1] = new PointF();
                    Points[1].X = 0.0f;
                    Points[1].Y = height;
                    Points[2] = new PointF();
                    Points[2].X = width;
                    Points[2].Y = height;
                    Points[3] = new PointF();
                    Points[3].X = aP.X;
                    Points[3].Y = 0.0f;
                    if (aLS.getShapeType() == ShapeTypes.Polygon) {
                        aPGB = (PolygonBreak)aLS.getLegendBreaks().get(idx).clone();
                        aPGB.setDrawOutline(true);
                        aPGB.setOutlineColor(Color.black);
                        Draw.drawPolygon(Points, aPGB, g);
                    } else {
                        Draw.drawPolygon(Points, FillColor, OutlineColor, DrawFill, DrawOutline, g);
                    }
                } else if (i == bNum - 1) {
                    PointF[] Points = new PointF[4];
                    Points[0] = new PointF();
                    Points[0].X = 0.0f;
                    Points[0].Y = (float)i * height;
                    Points[1] = new PointF();
                    Points[1].X = width;
                    Points[1].Y = (float)i * height;
                    Points[2] = new PointF();
                    Points[2].X = aP.X;
                    Points[2].Y = (float)i * height + height;
                    Points[3] = new PointF();
                    Points[3].X = 0.0f;
                    Points[3].Y = (float)i * height;
                    if (aLS.getShapeType() == ShapeTypes.Polygon) {
                        aPGB = (PolygonBreak)aLS.getLegendBreaks().get(idx).clone();
                        aPGB.setDrawOutline(true);
                        aPGB.setOutlineColor(Color.black);
                        Draw.drawPolygon(Points, aPGB, g);
                    } else {
                        Draw.drawPolygon(Points, FillColor, OutlineColor, DrawFill, DrawOutline, g);
                    }
                } else if (aLS.getShapeType() == ShapeTypes.Polygon) {
                    PolygonBreak aPGB2 = (PolygonBreak)aLS.getLegendBreaks().get(idx).clone();
                    aPGB2.setDrawOutline(true);
                    aPGB2.setOutlineColor(Color.black);
                    Draw.drawPolygonSymbol((PointF)aP.clone(), width, height, aPGB2, g);
                } else {
                    Draw.drawPolygonSymbol((PointF)aP.clone(), FillColor, OutlineColor, width, height, DrawFill, DrawOutline, g);
                }
            }
            sP.X = aP.X + width / 2.0f + 5.0f;
            sP.Y = aP.Y + height / 2.0f;
            if (i >= bNum - 1) continue;
            FontMetrics metrics = g.getFontMetrics(lFont);
            aSF = new Dimension(metrics.stringWidth(caption), metrics.getHeight());
            g.setColor(this.getForeColor());
            g.setFont(lFont);
            g.drawString(caption, sP.X, sP.Y + (float)(aSF.height / 2));
        }
    }

    private void drawVerticalBarLegend_Ex(Graphics2D g, float zoom) {
        LegendScheme aLS = this._legendLayer.getLegendScheme();
        PointF aP = new PointF(0.0f, 0.0f);
        PointF sP = new PointF(0.0f, 0.0f);
        boolean DrawShape = true;
        boolean DrawFill = true;
        boolean DrawOutline = false;
        Color FillColor = Color.red;
        Color OutlineColor = this.getForeColor();
        int bNum = aLS.getBreakNum();
        if (aLS.getLegendBreaks().get(bNum - 1).isNoData()) {
            --bNum;
        }
        int tickGap = this.getTickGap(g);
        ArrayList<Integer> labelIdxs = new ArrayList<Integer>();
        int sIdx = bNum % tickGap / 2;
        int labNum = bNum - 1;
        if (aLS.getLegendType() == LegendType.UniqueValue) {
            ++labNum;
        }
        while (sIdx < labNum) {
            labelIdxs.add(sIdx);
            sIdx += tickGap;
        }
        float width = this._vBarWidth = (float)(this.getWidth() - this.getLabelWidth(g) - 5);
        float height = this._hBarHeight = (float)this.getHeight() / (float)bNum;
        boolean order = true;
        if (aLS.getBreakNum() > 1) {
            try {
                double v1 = Double.parseDouble(aLS.getLegendBreaks().get(0).getEndValue().toString());
                double v2 = Double.parseDouble(aLS.getLegendBreaks().get(1).getEndValue().toString());
                if (v2 < v1) {
                    order = false;
                }
            }
            catch (Exception v1) {
                // empty catch block
            }
        }
        for (int i = 0; i < bNum; ++i) {
            PolygonBreak aPGB;
            int idx = order ? bNum - i - 1 : i;
            switch (aLS.getShapeType()) {
                case Point: {
                    PointBreak aPB = (PointBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPB.isDrawShape();
                    DrawFill = aPB.isDrawFill();
                    FillColor = aPB.getColor();
                    break;
                }
                case Polyline: 
                case PolylineZ: {
                    PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPLB.getDrawPolyline();
                    FillColor = aPLB.getColor();
                    break;
                }
                case Polygon: {
                    PolygonBreak aPGB2 = (PolygonBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPGB2.isDrawShape();
                    DrawFill = aPGB2.isDrawFill();
                    FillColor = aPGB2.getColor();
                    break;
                }
                case Image: {
                    ColorBreak aCB = aLS.getLegendBreaks().get(idx);
                    DrawShape = true;
                    DrawFill = true;
                    FillColor = aCB.getColor();
                }
            }
            aP.X = width / 2.0f;
            aP.Y = (float)i * height + height / 2.0f;
            if (aLS.getLegendType() == LegendType.UniqueValue) {
                if (!DrawShape) continue;
                if (aLS.getShapeType() == ShapeTypes.Polygon) {
                    PolygonBreak aPGB3 = (PolygonBreak)aLS.getLegendBreaks().get(idx).clone();
                    aPGB3.setDrawOutline(DrawOutline);
                    aPGB3.setOutlineColor(Color.black);
                    Draw.drawPolygonSymbol((PointF)aP.clone(), width, height, aPGB3, g);
                    continue;
                }
                Draw.drawPolygonSymbol((PointF)aP.clone(), FillColor, OutlineColor, width, height, DrawFill, DrawOutline, g);
                continue;
            }
            if (!DrawShape) continue;
            if (i == 0) {
                PointF[] Points = new PointF[4];
                Points[0] = new PointF();
                Points[0].X = aP.X;
                Points[0].Y = 0.0f;
                Points[1] = new PointF();
                Points[1].X = 0.0f;
                Points[1].Y = height;
                Points[2] = new PointF();
                Points[2].X = width;
                Points[2].Y = height;
                Points[3] = new PointF();
                Points[3].X = aP.X;
                Points[3].Y = 0.0f;
                if (aLS.getShapeType() == ShapeTypes.Polygon) {
                    aPGB = (PolygonBreak)aLS.getLegendBreaks().get(idx).clone();
                    aPGB.setDrawOutline(DrawOutline);
                    aPGB.setOutlineColor(Color.black);
                    Draw.drawPolygon(Points, aPGB, g);
                    continue;
                }
                Draw.drawPolygon(Points, FillColor, OutlineColor, DrawFill, DrawOutline, g);
                continue;
            }
            if (i == bNum - 1) {
                PointF[] Points = new PointF[4];
                Points[0] = new PointF();
                Points[0].X = 0.0f;
                Points[0].Y = (float)i * height;
                Points[1] = new PointF();
                Points[1].X = width;
                Points[1].Y = (float)i * height;
                Points[2] = new PointF();
                Points[2].X = aP.X;
                Points[2].Y = (float)i * height + height;
                Points[3] = new PointF();
                Points[3].X = 0.0f;
                Points[3].Y = (float)i * height;
                if (aLS.getShapeType() == ShapeTypes.Polygon) {
                    aPGB = (PolygonBreak)aLS.getLegendBreaks().get(idx).clone();
                    aPGB.setDrawOutline(DrawOutline);
                    aPGB.setOutlineColor(Color.black);
                    Draw.drawPolygon(Points, aPGB, g);
                    continue;
                }
                Draw.drawPolygon(Points, FillColor, OutlineColor, DrawFill, DrawOutline, g);
                continue;
            }
            if (aLS.getShapeType() == ShapeTypes.Polygon) {
                PolygonBreak aPGB4 = (PolygonBreak)aLS.getLegendBreaks().get(idx).clone();
                aPGB4.setDrawOutline(DrawOutline);
                aPGB4.setOutlineColor(Color.black);
                Draw.drawPolygonSymbol((PointF)aP.clone(), width, height, aPGB4, g);
                continue;
            }
            Draw.drawPolygonSymbol((PointF)aP.clone(), FillColor, OutlineColor, width, height, DrawFill, DrawOutline, g);
        }
        g.setColor(Color.black);
        if (aLS.getLegendType() == LegendType.UniqueValue) {
            g.draw(new Rectangle2D.Float(0.0f, 0.0f, this._vBarWidth, this._hBarHeight * (float)bNum));
        } else {
            Polygon p = new Polygon();
            p.addPoint((int)(width / 2.0f), 0);
            p.addPoint(0, (int)height);
            p.addPoint(0, (int)(height * (float)(bNum - 1)));
            p.addPoint((int)(width / 2.0f), (int)(height * (float)bNum));
            p.addPoint((int)width, (int)(height * (float)(bNum - 1)));
            p.addPoint((int)width, (int)height);
            g.drawPolygon(p);
        }
        aP.Y = (float)this.getHeight() + this._hBarHeight / 2.0f;
        int labLen = (int)(this._vBarWidth / 3.0f);
        if (labLen < 5) {
            labLen = 5;
            if (this._vBarWidth < 5.0f) {
                labLen = (int)this._vBarWidth;
            }
        }
        for (int i = 0; i < bNum; ++i) {
            Dimension aSF;
            FontMetrics metrics;
            int idx = order ? i : bNum - i - 1;
            ColorBreak cb = aLS.getLegendBreaks().get(idx);
            String caption = aLS.getLegendType() == LegendType.UniqueValue ? cb.getCaption() : DataConvert.removeTailingZeros(cb.getEndValue().toString());
            aP.X = this._vBarWidth / 2.0f;
            aP.Y -= this._hBarHeight;
            if (aLS.getLegendType() == LegendType.UniqueValue) {
                if (!labelIdxs.contains(idx)) continue;
                sP.X = aP.X + this._vBarWidth / 2.0f + 5.0f;
                sP.Y = aP.Y;
                metrics = g.getFontMetrics(this._font);
                aSF = new Dimension(metrics.stringWidth(caption), metrics.getHeight());
                g.setColor(Color.black);
                g.setFont(this._font);
                Draw.drawString(g, caption, sP.X, sP.Y + (float)(aSF.height / 4));
                continue;
            }
            if (!labelIdxs.contains(idx)) continue;
            sP.X = aP.X + this._vBarWidth / 2.0f;
            sP.Y = aP.Y - this._hBarHeight / 2.0f;
            g.draw(new Line2D.Float(sP.X - (float)labLen, sP.Y, sP.X, sP.Y));
            sP.X += 5.0f;
            if (i >= bNum - 1) continue;
            metrics = g.getFontMetrics(this._font);
            aSF = new Dimension(metrics.stringWidth(caption), metrics.getHeight());
            g.setFont(this._font);
            Draw.drawString(g, caption, sP.X, sP.Y + (float)(aSF.height / 4));
        }
    }

    private void drawHorizontalBarLegend(Graphics2D g, float zoom) {
        LegendScheme aLS = this._legendLayer.getLegendScheme();
        PointF aP = new PointF(0.0f, 0.0f);
        PointF sP = new PointF(0.0f, 0.0f);
        boolean DrawShape = true;
        boolean DrawFill = true;
        boolean DrawOutline = true;
        Color FillColor = Color.red;
        Color OutlineColor = this.getForeColor();
        String caption = "";
        int bNum = aLS.getBreakNum();
        if (aLS.getLegendBreaks().get(bNum - 1).isNoData()) {
            --bNum;
        }
        Font lFont = new Font(this.getFont().getFontName(), this.getFont().getStyle(), (int)((float)this.getFont().getSize() * zoom));
        FontMetrics metrics = g.getFontMetrics(lFont);
        this._vBarWidth = this.getHeight() - metrics.getHeight() - 5;
        float width = (float)(this.getWidth() - 5) * zoom / (float)bNum;
        float height = this._vBarWidth * zoom;
        for (int i = 0; i < bNum; ++i) {
            Dimension aSF;
            PolygonBreak aPGB;
            switch (aLS.getShapeType()) {
                case Point: {
                    PointBreak aPB = (PointBreak)aLS.getLegendBreaks().get(i);
                    DrawShape = aPB.isDrawShape();
                    DrawFill = aPB.isDrawFill();
                    FillColor = aPB.getColor();
                    if (aLS.getLegendType() == LegendType.UniqueValue) {
                        caption = aPB.getCaption();
                        break;
                    }
                    caption = DataConvert.removeTailingZeros(aPB.getEndValue().toString());
                    break;
                }
                case Polyline: 
                case PolylineZ: {
                    PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(i);
                    DrawShape = aPLB.getDrawPolyline();
                    FillColor = aPLB.getColor();
                    if (aLS.getLegendType() == LegendType.UniqueValue) {
                        caption = aPLB.getCaption();
                        break;
                    }
                    caption = DataConvert.removeTailingZeros(aPLB.getEndValue().toString());
                    break;
                }
                case Polygon: {
                    PolygonBreak aPGB2 = (PolygonBreak)aLS.getLegendBreaks().get(i);
                    DrawShape = aPGB2.isDrawShape();
                    DrawFill = aPGB2.isDrawFill();
                    FillColor = aPGB2.getColor();
                    if (aLS.getLegendType() == LegendType.UniqueValue) {
                        caption = aPGB2.getCaption();
                        break;
                    }
                    caption = DataConvert.removeTailingZeros(aPGB2.getEndValue().toString());
                    break;
                }
                case Image: {
                    ColorBreak aCB = aLS.getLegendBreaks().get(i);
                    DrawShape = true;
                    DrawFill = true;
                    FillColor = aCB.getColor();
                    caption = aLS.getLegendType() == LegendType.UniqueValue ? aCB.getCaption() : DataConvert.removeTailingZeros(aCB.getEndValue().toString());
                }
            }
            aP.X = (float)i * width + width / 2.0f;
            aP.Y = height / 2.0f;
            if (aLS.getLegendType() == LegendType.UniqueValue) {
                if (DrawShape) {
                    if (aLS.getShapeType() == ShapeTypes.Polygon) {
                        aPGB = (PolygonBreak)aLS.getLegendBreaks().get(i).clone();
                        aPGB.setDrawOutline(true);
                        aPGB.setOutlineColor(Color.black);
                        Draw.drawPolygonSymbol((PointF)aP.clone(), width, height, aPGB, g);
                    } else {
                        Draw.drawPolygonSymbol((PointF)aP.clone(), FillColor, OutlineColor, width, height, DrawFill, DrawOutline, g);
                    }
                }
                sP.X = aP.X;
                sP.Y = aP.Y + height / 2.0f;
                aSF = new Dimension(metrics.stringWidth(caption), metrics.getHeight());
                g.setColor(this.getForeColor());
                g.setFont(lFont);
                g.drawString(caption, sP.X - (float)(aSF.width / 2), sP.Y + (float)aSF.height);
                continue;
            }
            if (DrawShape) {
                PolygonBreak aPGB3;
                PointF[] Points;
                if (i == 0) {
                    Points = new PointF[4];
                    Points[0] = new PointF();
                    Points[0].X = 0.0f;
                    Points[0].Y = aP.Y;
                    Points[1] = new PointF();
                    Points[1].X = width;
                    Points[1].Y = 0.0f;
                    Points[2] = new PointF();
                    Points[2].X = width;
                    Points[2].Y = height;
                    Points[3] = new PointF();
                    Points[3].X = 0.0f;
                    Points[3].Y = aP.Y;
                    if (aLS.getShapeType() == ShapeTypes.Polygon) {
                        aPGB3 = (PolygonBreak)aLS.getLegendBreaks().get(i).clone();
                        aPGB3.setDrawOutline(true);
                        aPGB3.setOutlineColor(Color.black);
                        Draw.drawPolygon(Points, aPGB3, g);
                    } else {
                        Draw.drawPolygon(Points, FillColor, OutlineColor, DrawFill, DrawOutline, g);
                    }
                } else if (i == bNum - 1) {
                    Points = new PointF[4];
                    Points[0] = new PointF();
                    Points[0].X = (float)i * width;
                    Points[0].Y = height;
                    Points[1] = new PointF();
                    Points[1].X = (float)i * width;
                    Points[1].Y = 0.0f;
                    Points[2] = new PointF();
                    Points[2].X = (float)i * width + width;
                    Points[2].Y = aP.Y;
                    Points[3] = new PointF();
                    Points[3].X = (float)i * width;
                    Points[3].Y = height;
                    if (aLS.getShapeType() == ShapeTypes.Polygon) {
                        aPGB3 = (PolygonBreak)aLS.getLegendBreaks().get(i).clone();
                        aPGB3.setDrawOutline(true);
                        aPGB3.setOutlineColor(Color.black);
                        Draw.drawPolygon(Points, aPGB3, g);
                    } else {
                        Draw.drawPolygon(Points, FillColor, OutlineColor, DrawFill, DrawOutline, g);
                    }
                } else if (aLS.getShapeType() == ShapeTypes.Polygon) {
                    aPGB = (PolygonBreak)aLS.getLegendBreaks().get(i).clone();
                    aPGB.setDrawOutline(true);
                    aPGB.setOutlineColor(Color.black);
                    Draw.drawPolygonSymbol((PointF)aP.clone(), width, height, aPGB, g);
                } else {
                    Draw.drawPolygonSymbol((PointF)aP.clone(), FillColor, OutlineColor, width, height, DrawFill, DrawOutline, g);
                }
            }
            sP.X = aP.X + width / 2.0f;
            sP.Y = aP.Y + height / 2.0f;
            if (i >= bNum - 1) continue;
            aSF = new Dimension(metrics.stringWidth(caption), metrics.getHeight());
            g.setColor(this.getForeColor());
            g.setFont(lFont);
            g.drawString(caption, sP.X - (float)(aSF.width / 2), sP.Y + (float)aSF.height);
        }
    }

    private void drawHorizontalBarLegend_Ex(Graphics2D g, float zoom) {
        LegendScheme aLS = this._legendLayer.getLegendScheme();
        PointF aP = new PointF(0.0f, 0.0f);
        PointF sP = new PointF(0.0f, 0.0f);
        boolean DrawShape = true;
        boolean DrawFill = true;
        boolean DrawOutline = false;
        Color FillColor = Color.red;
        Color OutlineColor = this.getForeColor();
        String caption = "";
        int bNum = aLS.getBreakNum();
        if (aLS.getLegendBreaks().get(bNum - 1).isNoData()) {
            --bNum;
        }
        int tickGap = this.getTickGap(g);
        ArrayList<Integer> labelIdxs = new ArrayList<Integer>();
        int sIdx = bNum % tickGap / 2;
        int labNum = bNum - 1;
        if (aLS.getLegendType() == LegendType.UniqueValue) {
            ++labNum;
        }
        while (sIdx < labNum) {
            labelIdxs.add(sIdx);
            sIdx += tickGap;
        }
        Font lFont = new Font(this.getFont().getFontName(), this.getFont().getStyle(), (int)((float)this.getFont().getSize() * zoom));
        FontMetrics metrics = g.getFontMetrics(lFont);
        this._vBarWidth = this.getHeight() - metrics.getHeight() - 5;
        float width = this.getWidth() / bNum;
        float height = this._vBarWidth;
        for (int i = 0; i < bNum; ++i) {
            PolygonBreak aPGB;
            PointF[] Points;
            PolygonBreak aPGB2;
            switch (aLS.getShapeType()) {
                case Point: {
                    PointBreak aPB = (PointBreak)aLS.getLegendBreaks().get(i);
                    DrawShape = aPB.isDrawShape();
                    DrawFill = aPB.isDrawFill();
                    FillColor = aPB.getColor();
                    break;
                }
                case Polyline: 
                case PolylineZ: {
                    PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(i);
                    DrawShape = aPLB.getDrawPolyline();
                    FillColor = aPLB.getColor();
                    break;
                }
                case Polygon: {
                    PolygonBreak aPGB3 = (PolygonBreak)aLS.getLegendBreaks().get(i);
                    DrawShape = aPGB3.isDrawShape();
                    DrawFill = aPGB3.isDrawFill();
                    FillColor = aPGB3.getColor();
                    break;
                }
                case Image: {
                    ColorBreak aCB = aLS.getLegendBreaks().get(i);
                    DrawShape = true;
                    DrawFill = true;
                    FillColor = aCB.getColor();
                }
            }
            aP.X = (float)i * width + width / 2.0f;
            aP.Y = height / 2.0f;
            if (aLS.getLegendType() == LegendType.UniqueValue) {
                if (!DrawShape) continue;
                if (aLS.getShapeType() == ShapeTypes.Polygon) {
                    aPGB2 = (PolygonBreak)aLS.getLegendBreaks().get(i).clone();
                    aPGB2.setDrawOutline(DrawOutline);
                    aPGB2.setOutlineColor(Color.black);
                    Draw.drawPolygonSymbol((PointF)aP.clone(), width, height, aPGB2, g);
                    continue;
                }
                Draw.drawPolygonSymbol((PointF)aP.clone(), FillColor, OutlineColor, width, height, DrawFill, DrawOutline, g);
                continue;
            }
            if (!DrawShape) continue;
            if (i == 0) {
                Points = new PointF[4];
                Points[0] = new PointF();
                Points[0].X = 0.0f;
                Points[0].Y = aP.Y;
                Points[1] = new PointF();
                Points[1].X = width;
                Points[1].Y = 0.0f;
                Points[2] = new PointF();
                Points[2].X = width;
                Points[2].Y = height;
                Points[3] = new PointF();
                Points[3].X = 0.0f;
                Points[3].Y = aP.Y;
                if (aLS.getShapeType() == ShapeTypes.Polygon) {
                    aPGB = (PolygonBreak)aLS.getLegendBreaks().get(i).clone();
                    aPGB.setDrawOutline(DrawOutline);
                    aPGB.setOutlineColor(Color.black);
                    Draw.drawPolygon(Points, aPGB, g);
                    continue;
                }
                Draw.drawPolygon(Points, FillColor, OutlineColor, DrawFill, DrawOutline, g);
                continue;
            }
            if (i == bNum - 1) {
                Points = new PointF[4];
                Points[0] = new PointF();
                Points[0].X = (float)i * width;
                Points[0].Y = height;
                Points[1] = new PointF();
                Points[1].X = (float)i * width;
                Points[1].Y = 0.0f;
                Points[2] = new PointF();
                Points[2].X = (float)i * width + width;
                Points[2].Y = aP.Y;
                Points[3] = new PointF();
                Points[3].X = (float)i * width;
                Points[3].Y = height;
                if (aLS.getShapeType() == ShapeTypes.Polygon) {
                    aPGB = (PolygonBreak)aLS.getLegendBreaks().get(i).clone();
                    aPGB.setDrawOutline(DrawOutline);
                    aPGB.setOutlineColor(Color.black);
                    Draw.drawPolygon(Points, aPGB, g);
                    continue;
                }
                Draw.drawPolygon(Points, FillColor, OutlineColor, DrawFill, DrawOutline, g);
                continue;
            }
            if (aLS.getShapeType() == ShapeTypes.Polygon) {
                aPGB2 = (PolygonBreak)aLS.getLegendBreaks().get(i).clone();
                aPGB2.setDrawOutline(DrawOutline);
                aPGB2.setOutlineColor(Color.black);
                Draw.drawPolygonSymbol((PointF)aP.clone(), width, height, aPGB2, g);
                continue;
            }
            Draw.drawPolygonSymbol((PointF)aP.clone(), FillColor, OutlineColor, width, height, DrawFill, DrawOutline, g);
        }
        g.setColor(Color.black);
        if (aLS.getLegendType() == LegendType.UniqueValue) {
            g.draw(new Rectangle2D.Float(0.0f, 0.0f, width * (float)bNum, height));
        } else {
            float extendw = width;
            Polygon p = new Polygon();
            p.addPoint((int)(width - extendw), (int)(height / 2.0f));
            p.addPoint((int)width, 0);
            p.addPoint((int)(width * (float)(bNum - 1)), 0);
            p.addPoint((int)(width * (float)(bNum - 1) + extendw), (int)(height / 2.0f));
            p.addPoint((int)(width * (float)(bNum - 1)), (int)height);
            p.addPoint((int)width, (int)height);
            g.drawPolygon(p);
        }
        aP.X = -this._vBarWidth / 2.0f;
        int labLen = (int)(this._hBarHeight / 3.0f);
        if (labLen < 5) {
            labLen = 5;
            if (this._hBarHeight < 5.0f) {
                labLen = (int)this._hBarHeight;
            }
        }
        for (int i = 0; i < bNum; ++i) {
            Dimension aSF;
            int idx = i;
            ColorBreak cb = aLS.getLegendBreaks().get(idx);
            caption = aLS.getLegendType() == LegendType.UniqueValue ? cb.getCaption() : DataConvert.removeTailingZeros(cb.getEndValue().toString());
            aP.X += width;
            aP.Y = height / 2.0f;
            if (aLS.getLegendType() == LegendType.UniqueValue) {
                if (!labelIdxs.contains(idx)) continue;
                sP.X = aP.X;
                sP.Y = aP.Y + height / 2.0f + 5.0f;
                metrics = g.getFontMetrics(this._font);
                aSF = new Dimension(metrics.stringWidth(caption), metrics.getHeight());
                g.setColor(Color.black);
                g.setFont(this._font);
                Draw.drawString(g, caption, sP.X - (float)(aSF.width / 2), sP.Y + (float)(aSF.height * 3 / 4));
                continue;
            }
            if (!labelIdxs.contains(idx)) continue;
            sP.X = aP.X + this._vBarWidth / 2.0f;
            sP.Y = aP.Y + height / 2.0f;
            g.draw(new Line2D.Float(sP.X, sP.Y, sP.X, sP.Y - (float)labLen));
            sP.Y += 5.0f;
            if (i >= bNum - 1) continue;
            metrics = g.getFontMetrics(this._font);
            aSF = new Dimension(metrics.stringWidth(caption), metrics.getHeight());
            g.setFont(this._font);
            Draw.drawString(g, caption, sP.X - (float)(aSF.width / 2), sP.Y + (float)(aSF.height * 3 / 4));
        }
    }

    private int getLabelWidth(Graphics2D g) {
        ChartBreak aCB;
        LegendScheme aLS = this._legendLayer.getLegendScheme();
        float width = 0.0f;
        String caption = "";
        int bNum = aLS.getBreakNum();
        FontMetrics metrics = g.getFontMetrics(this._font);
        if (this._legendStyle == LegendStyles.Normal) {
            Dimension aSF = new Dimension(metrics.stringWidth(this._title), metrics.getHeight());
            width = aSF.width;
        } else if (aLS.getLegendBreaks().get(bNum - 1).isNoData()) {
            --bNum;
        }
        for (int i = 0; i < bNum; ++i) {
            float labwidth;
            switch (aLS.getShapeType()) {
                case Point: {
                    PointBreak aPB = (PointBreak)aLS.getLegendBreaks().get(i);
                    if (aLS.getLegendType() == LegendType.GraduatedColor && this._legendStyle != LegendStyles.Normal) {
                        caption = DataConvert.removeTailingZeros(aPB.getEndValue().toString());
                        break;
                    }
                    caption = aPB.getCaption();
                    break;
                }
                case Polyline: {
                    PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(i);
                    if (aLS.getLegendType() == LegendType.GraduatedColor && this._legendStyle != LegendStyles.Normal) {
                        caption = DataConvert.removeTailingZeros(aPLB.getEndValue().toString());
                        break;
                    }
                    caption = aPLB.getCaption();
                    break;
                }
                case Polygon: {
                    PolygonBreak aPGB = (PolygonBreak)aLS.getLegendBreaks().get(i);
                    if (aLS.getLegendType() == LegendType.GraduatedColor && this._legendStyle != LegendStyles.Normal) {
                        caption = DataConvert.removeTailingZeros(aPGB.getEndValue().toString());
                        break;
                    }
                    caption = aPGB.getCaption();
                    break;
                }
                case Image: {
                    ColorBreak aCB2 = aLS.getLegendBreaks().get(i);
                    caption = aLS.getLegendType() == LegendType.GraduatedColor && this._legendStyle != LegendStyles.Normal ? DataConvert.removeTailingZeros(aCB2.getEndValue().toString()) : aCB2.getCaption();
                }
            }
            boolean isValid = true;
            switch (aLS.getLegendType()) {
                case GraduatedColor: {
                    if (this._legendStyle == LegendStyles.Normal || i != bNum - 1) break;
                    isValid = false;
                }
            }
            if (!isValid || !(width < (labwidth = (float)metrics.stringWidth(caption)))) continue;
            width = labwidth;
        }
        if (this._legendStyle == LegendStyles.Normal && this._legendLayer.getLayerType() == LayerTypes.VectorLayer && ((VectorLayer)this._legendLayer).getChartSet().isDrawCharts() && (aCB = ((ChartBreak)((VectorLayer)this._legendLayer).getChartPoints().get(0).getLegend()).getSampleChartBreak()).getChartType() == ChartTypes.BarChart) {
            LegendScheme ls = aCB.getLegendScheme();
            for (ColorBreak cb : ls.getLegendBreaks()) {
                float labwidth = metrics.stringWidth(cb.getCaption());
                if (!(width < labwidth)) continue;
                width = metrics.stringWidth(cb.getCaption());
            }
        }
        return (int)width;
    }

    private int getBreakHeight(Graphics2D g) {
        String title = this._title;
        if ("".equals(title.trim())) {
            title = "Temp";
        }
        FontMetrics metrics = g.getFontMetrics(this._font);
        Dimension aSF = new Dimension(metrics.stringWidth(title), metrics.getHeight());
        return aSF.height;
    }

    private int getTitleHeight(Graphics2D g) {
        FontMetrics metrics = g.getFontMetrics(this._titleFont);
        Dimension aSF = new Dimension(metrics.stringWidth(this._title), metrics.getHeight());
        return aSF.height;
    }

    public void updateLegendSize() {
        if (this._legendStyle != LegendStyles.Normal) {
            return;
        }
        if (this._legendLayer != null) {
            if (this._legendLayer.getLegendScheme() == null) {
                return;
            }
            BufferedImage image = new BufferedImage(this._mapLayout.getPageBounds().width, this._mapLayout.getPageBounds().height, 2);
            Graphics2D g = image.createGraphics();
            int bNum = this._legendLayer.getLegendScheme().getBreakNum();
            if (this._legendLayer.getLegendScheme().getLegendBreaks().get(bNum - 1).isNoData()) {
                --bNum;
            }
            int w = this.getWidth();
            int h = this.getHeight();
            switch (this._legendStyle) {
                case Bar_Vertical: {
                    int nw = 10 + this.getLabelWidth(g) + 5;
                    int nh = bNum * 20;
                    if (nw > w) {
                        this.setWidth(nw);
                    }
                    if (nh <= h) break;
                    this.setHeight(bNum * 20);
                    break;
                }
                case Bar_Horizontal: {
                    int nw = bNum * 30;
                    int nh = 30;
                    if (nw > w) {
                        this.setWidth(nw);
                    }
                    if (nh <= h) break;
                    this.setHeight(bNum * 20);
                    break;
                }
                case Normal: {
                    VectorLayer aLayer;
                    int aHeight = this.getBreakHeight(g);
                    int colWidth = aHeight * 2 + this.getLabelWidth(g) + 15;
                    this.setWidth(colWidth * this._columnNum);
                    int[] rowNums = new int[this._columnNum];
                    int ave = this._legendLayer.getLegendScheme().getVisibleBreakNum() / this._columnNum;
                    int num = 0;
                    for (int i = 1; i < this._columnNum; ++i) {
                        rowNums[i] = ave;
                        num += ave;
                    }
                    rowNums[0] = this._legendLayer.getLegendScheme().getVisibleBreakNum() - num;
                    this.setHeight((int)((float)rowNums[0] * ((float)aHeight + this._breakSpace) + (float)this.getTitleHeight(g) + this._breakSpace * 2.0f + (float)(aHeight / 2) + 5.0f));
                    if (this._legendLayer.getLayerType() != LayerTypes.VectorLayer || !(aLayer = (VectorLayer)this._legendLayer).getChartSet().isDrawCharts()) break;
                    ChartBreak aCB = ((ChartBreak)aLayer.getChartPoints().get(0).getLegend()).getSampleChartBreak();
                    this.setHeight(this.getHeight() + (int)(this._breakSpace * 2.0f + (float)aCB.getHeight() + (float)aCB.getLegendScheme().getBreakNum() * ((float)aHeight + this._breakSpace) + (float)(aHeight / 2) + 5.0f));
                }
            }
        }
    }

    @Override
    public void paint(Graphics2D g) {
    }

    @Override
    public void paintOnLayout(Graphics2D g, PointF pageLocation, float zoom) {
        if (this.isVisible()) {
            this.paintGraphics(g, pageLocation, zoom);
        }
    }

    @Override
    public void moveUpdate() {
    }

    @Override
    public void resizeUpdate() {
    }

    public static List<String> getLayerNames() {
        ArrayList<String> layerNames = new ArrayList<String>();
        for (MapLayer aLayer : _layoutMap.getMapFrame().getMapView().getLayers()) {
            if (aLayer.getLayerType() != LayerTypes.VectorLayer && aLayer.getLayerType() != LayerTypes.RasterLayer) continue;
            layerNames.add(aLayer.getLayerName());
        }
        return layerNames;
    }

    public static class LegendStyleEditor
    extends ComboBoxPropertyEditor {
        public LegendStyleEditor() {
            LegendStyles[] styles = LegendStyles.values();
            Object[] values = new String[styles.length];
            int i = 0;
            for (LegendStyles s : styles) {
                values[i] = s.toString();
                ++i;
            }
            this.setAvailableValues(values);
        }
    }

    public static class LayerUpdateTypeEditor
    extends ComboBoxPropertyEditor {
        public LayerUpdateTypeEditor() {
            LayerUpdateTypes[] lutypes = LayerUpdateTypes.values();
            Object[] types = new String[lutypes.length];
            int i = 0;
            for (LayerUpdateTypes type : lutypes) {
                types[i] = type.toString();
                ++i;
            }
            this.setAvailableValues(types);
        }
    }

    public static class LayerNameEditor
    extends ComboBoxPropertyEditor {
        public LayerNameEditor() {
            Object[] names = LayoutLegend.getLayerNames().toArray(new String[0]);
            this.setAvailableValues(names);
        }
    }

    public static class LayoutLegendBeanBeanInfo
    extends BaseBeanInfo {
        public LayoutLegendBeanBeanInfo() {
            super(LayoutLegendBean.class);
            ExtendedPropertyDescriptor e = this.addProperty("layerName");
            e.setCategory("General").setPropertyEditorClass(LayerNameEditor.class);
            e.setDisplayName("Layer Name");
            e.setShortDescription("The name of the layer of this legend");
            e = this.addProperty("layerUpdateType");
            e.setCategory("General").setDisplayName("Layer Update Type");
            e.setPropertyEditorClass(LayerUpdateTypeEditor.class);
            e = this.addProperty("legendStyle");
            e.setCategory("General").setDisplayName("Legend Style");
            e.setPropertyEditorClass(LegendStyleEditor.class);
            this.addProperty("title").setCategory("General").setDisplayName("Title");
            this.addProperty("font").setCategory("General").setDisplayName("Font");
            this.addProperty("drawBackColor").setCategory("General").setDisplayName("Draw Background");
            this.addProperty("backColor").setCategory("General").setDisplayName("Background");
            this.addProperty("foreColor").setCategory("General").setDisplayName("Foreground");
            this.addProperty("columnNumber").setCategory("General").setDisplayName("Column Number");
            this.addProperty("forceDrawOutline").setCategory("General").setDisplayName("Force Draw Outline");
            this.addProperty("drawNeatLine").setCategory("Neat Line").setDisplayName("Draw Neat Line");
            this.addProperty("neatLineColor").setCategory("Neat Line").setDisplayName("Neat Line Color");
            this.addProperty("neatLineSize").setCategory("Neat Line").setDisplayName("Neat Line Size");
            this.addProperty("drawChartBreaks").setCategory("Chart").setDisplayName("Draw Chart Breaks");
            this.addProperty("left").setCategory("Location").setDisplayName("Left");
            this.addProperty("top").setCategory("Location").setDisplayName("Top");
            this.addProperty("width").setCategory("Location").setDisplayName("Width");
            this.addProperty("height").setCategory("Location").setDisplayName("Height");
        }
    }

    public class LayoutLegendBean {
        LayoutLegendBean() {
        }

        public LayoutMap getLayoutMap() {
            return _layoutMap;
        }

        public MapLayer getLegendLayer() {
            return LayoutLegend.this._legendLayer;
        }

        public void setLegendLayer(MapLayer layer) {
            LayoutLegend.this._legendLayer = layer;
            String aStr = LayoutLegend.this._legendLayer.getLayerName();
            if (aStr.contains("_")) {
                aStr = aStr.split("_")[1];
            }
            LayoutLegend.this._title = aStr;
            LayoutLegend.this.updateLegendSize();
        }

        public String getLayerName() {
            if (LayoutLegend.this._legendLayer != null) {
                return LayoutLegend.this._legendLayer.getLayerName();
            }
            return null;
        }

        public void setLayerName(String name) {
            MapLayer aLayer = _layoutMap.getMapFrame().getMapView().getLayer(name);
            if (aLayer != null) {
                this.setLegendLayer(aLayer);
            }
        }

        public boolean isForceDrawOutline() {
            return LayoutLegend.this.forceDrawOutline;
        }

        public void setForceDrawOutline(boolean value) {
            LayoutLegend.this.forceDrawOutline = value;
        }

        public String getLayerUpdateType() {
            return LayoutLegend.this._layerUpdateType.toString();
        }

        public void setLayerUpdateType(String typeStr) {
            LayoutLegend.this._layerUpdateType = LayerUpdateTypes.valueOf(typeStr);
        }

        public String getLegendStyle() {
            return LayoutLegend.this._legendStyle.toString();
        }

        public void setLegendStyle(String style) {
            LayoutLegend.this._legendStyle = LegendStyles.valueOf(style);
            if (LayoutLegend.this.isVisible()) {
                LayoutLegend.this.updateLegendSize();
            }
        }

        public String getTitle() {
            return LayoutLegend.this._title;
        }

        public void setTitle(String title) {
            LayoutLegend.this._title = title;
            LayoutLegend.this.updateLegendSize();
        }

        public boolean isDrawNeatLine() {
            return LayoutLegend.this._drawNeatLine;
        }

        public void setDrawNeatLine(boolean istrue) {
            LayoutLegend.this._drawNeatLine = istrue;
        }

        public Color getNeatLineColor() {
            return LayoutLegend.this._neatLineColor;
        }

        public void setNeatLineColor(Color color) {
            LayoutLegend.this._neatLineColor = color;
        }

        public float getNeatLineSize() {
            return LayoutLegend.this._neatLineSize;
        }

        public void setNeatLineSize(float size) {
            LayoutLegend.this._neatLineSize = size;
        }

        public Font getFont() {
            return LayoutLegend.this._font;
        }

        public void setFont(Font font) {
            LayoutLegend.this._font = font;
            LayoutLegend.this._titleFont = new Font(LayoutLegend.this._font.getFontName(), 0, LayoutLegend.this._font.getSize() + 2);
            LayoutLegend.this.updateLegendSize();
        }

        public int getColumnNumber() {
            return LayoutLegend.this._columnNum;
        }

        public void setColumnNumber(int value) {
            LayoutLegend.this._columnNum = value;
            if (LayoutLegend.this.isVisible()) {
                LayoutLegend.this.updateLegendSize();
            }
        }

        public boolean isDrawChartBreaks() {
            return LayoutLegend.this.drawChartBreaks;
        }

        public void setDrawChartBreaks(boolean value) {
            LayoutLegend.this.drawChartBreaks = value;
        }

        public boolean isDrawBackColor() {
            return LayoutLegend.this.isDrawBackColor();
        }

        public void setDrawBackColor(boolean value) {
            LayoutLegend.this.setDrawBackColor(value);
        }

        public Color getBackColor() {
            return LayoutLegend.this.getBackColor();
        }

        public void setBackColor(Color c) {
            LayoutLegend.this.setBackColor(c);
        }

        public Color getForeColor() {
            return LayoutLegend.this.getForeColor();
        }

        public void setForeColor(Color c) {
            LayoutLegend.this.setForeColor(c);
        }

        public int getLeft() {
            return LayoutLegend.this.getLeft();
        }

        public void setLeft(int left) {
            LayoutLegend.this.setLeft(left);
        }

        public int getTop() {
            return LayoutLegend.this.getTop();
        }

        public void setTop(int top) {
            LayoutLegend.this.setTop(top);
        }

        public int getWidth() {
            return LayoutLegend.this.getWidth();
        }

        public void setWidth(int value) {
            LayoutLegend.this.setWidth(value);
        }

        public int getHeight() {
            return LayoutLegend.this.getHeight();
        }

        public void setHeight(int value) {
            LayoutLegend.this.setHeight(value);
        }

        public float getBarWidth() {
            return LayoutLegend.this._vBarWidth;
        }

        public void setBarWidth(float value) {
            LayoutLegend.this._vBarWidth = value;
        }
    }
}

