/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.layout;

import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableModel;
import javax.swing.undo.UndoableEdit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.meteoinfo.data.mapdata.webmap.IWebMapPanel;
import org.meteoinfo.data.mapdata.webmap.TileLoadListener;
import org.meteoinfo.drawing.Draw;
import org.meteoinfo.geoprocess.GeoComputation;
import org.meteoinfo.global.FrmMeasurement;
import org.meteoinfo.global.FrmProperty;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointF;
import org.meteoinfo.global.colors.ColorUtil;
import org.meteoinfo.global.event.ActiveMapFrameChangedEvent;
import org.meteoinfo.global.event.ElementSelectedEvent;
import org.meteoinfo.global.event.IActiveMapFrameChangedListener;
import org.meteoinfo.global.event.IElementSelectedListener;
import org.meteoinfo.global.event.IMapFramesUpdatedListener;
import org.meteoinfo.global.event.IMapViewUpdatedListener;
import org.meteoinfo.global.event.IUndoEditListener;
import org.meteoinfo.global.event.IZoomChangedListener;
import org.meteoinfo.global.event.MapFramesUpdatedEvent;
import org.meteoinfo.global.event.MapViewUpdatedEvent;
import org.meteoinfo.global.event.UndoEditEvent;
import org.meteoinfo.global.event.ZoomChangedEvent;
import org.meteoinfo.global.util.GlobalUtil;
import org.meteoinfo.image.ImageUtil;
import org.meteoinfo.layer.LayerTypes;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.layer.RasterLayer;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.layer.WebMapLayer;
import org.meteoinfo.layout.Edge;
import org.meteoinfo.layout.ElementType;
import org.meteoinfo.layout.LayerUpdateTypes;
import org.meteoinfo.layout.LayoutChart;
import org.meteoinfo.layout.LayoutElement;
import org.meteoinfo.layout.LayoutGraphic;
import org.meteoinfo.layout.LayoutLegend;
import org.meteoinfo.layout.LayoutMap;
import org.meteoinfo.layout.LayoutNorthArrow;
import org.meteoinfo.layout.LayoutScaleBar;
import org.meteoinfo.layout.LegendStyles;
import org.meteoinfo.layout.MapLayoutUndoRedo;
import org.meteoinfo.layout.MouseMode;
import org.meteoinfo.layout.PaperSize;
import org.meteoinfo.layout.ScaleBarType;
import org.meteoinfo.legend.BreakTypes;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.FrmLabelSymbolSet;
import org.meteoinfo.legend.FrmPointSymbolSet;
import org.meteoinfo.legend.FrmPolygonSymbolSet;
import org.meteoinfo.legend.FrmPolylineSymbolSet;
import org.meteoinfo.legend.GridLabelPosition;
import org.meteoinfo.legend.LabelBreak;
import org.meteoinfo.legend.LineStyles;
import org.meteoinfo.legend.MapFrame;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.legend.PolylineBreak;
import org.meteoinfo.legend.VectorBreak;
import org.meteoinfo.map.FrmIdentifer;
import org.meteoinfo.map.FrmIdentiferGrid;
import org.meteoinfo.map.MapView;
import org.meteoinfo.shape.CircleShape;
import org.meteoinfo.shape.CurveLineShape;
import org.meteoinfo.shape.CurvePolygonShape;
import org.meteoinfo.shape.EllipseShape;
import org.meteoinfo.shape.Graphic;
import org.meteoinfo.shape.PointShape;
import org.meteoinfo.shape.PolygonShape;
import org.meteoinfo.shape.PolylineShape;
import org.meteoinfo.shape.RectangleShape;
import org.meteoinfo.shape.Shape;
import org.meteoinfo.shape.ShapeTypes;
import org.meteoinfo.shape.WindArrow;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import wcontour.Contour;
import wcontour.global.PointD;

public class MapLayout
extends JPanel
implements IWebMapPanel {
    private EventListenerList _listeners = new EventListenerList();
    private final TileLoadListener tileLoadListener = new TileLoadListener(this);
    private FrmIdentifer _frmIdentifer = null;
    private FrmIdentiferGrid _frmIdentiferGrid = null;
    private FrmMeasurement _frmMeasure = null;
    private JScrollBar _vScrollBar;
    private JScrollBar _hScrollBar;
    private boolean _lockViewUpdate = false;
    private List<MapFrame> _mapFrames = new ArrayList<MapFrame>();
    private List<LayoutElement> _layoutElements = new ArrayList<LayoutElement>();
    private LayoutMap _currentLayoutMap;
    private BufferedImage _layoutBitmap = new BufferedImage(10, 10, 2);
    private BufferedImage _tempImage = null;
    private boolean _antiAlias = false;
    private FrmLabelSymbolSet _frmLabelSymbolSet = null;
    private FrmPointSymbolSet _frmPointSymbolSet = null;
    private FrmPolylineSymbolSet _frmPolylineSymbolSet = null;
    private FrmPolygonSymbolSet _frmPolygonSymbolSet = null;
    private java.awt.Rectangle _pageBounds;
    private Color _pageForeColor = Color.black;
    private Color _pageBackColor = Color.white;
    private PaperSize _paperSize = new PaperSize();
    private List<PaperSize> _paperSizeList = new ArrayList<PaperSize>();
    private boolean _isLandscape;
    private float _zoom = 1.0f;
    private PointF _pageLocation = new PointF(0.0f, 0.0f);
    private PointBreak _defPointBreak = new PointBreak();
    private LabelBreak _defLabelBreak = new LabelBreak();
    private PolylineBreak _defPolylineBreak = new PolylineBreak();
    private PolygonBreak _defPolygonBreak = new PolygonBreak();
    private int _xShift = 0;
    private int _yShift = 0;
    private MouseMode _mouseMode = MouseMode.Default;
    private List<LayoutElement> _selectedElements = new ArrayList<LayoutElement>();
    private java.awt.Rectangle _selectedRectangle = new java.awt.Rectangle();
    private Point _mouseDownPos = new Point(0, 0);
    private Point _mouseLastPos = new Point(0, 0);
    private Point _mouseDownPoint = new Point(0, 0);
    private Edge _resizeSelectedEdge = Edge.None;
    private boolean _startNewGraphic = true;
    private List<PointF> _graphicPoints = new ArrayList<PointF>();
    private List<org.meteoinfo.global.PointD> _editingVertices = new ArrayList<org.meteoinfo.global.PointD>();
    private int _editingVerticeIndex;
    private boolean _dragMode = false;

    public MapLayout() {
        this.setLayout(new BorderLayout());
        this.initComponents();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MapLayout.this.onComponentResized(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    MapLayout.this.onMouseClicked(e);
                }
                catch (CloneNotSupportedException ex) {
                    Logger.getLogger(MapLayout.class.getName()).log(Level.SEVERE, null, ex);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MapLayout.this.onMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                try {
                    MapLayout.this.onMouseReleased(e);
                }
                catch (CloneNotSupportedException ex) {
                    Logger.getLogger(MapLayout.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                MapLayout.this.onMouseMoved(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                MapLayout.this.onMouseDragged(e);
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                MapLayout.this.onKeyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.setBackground(Color.lightGray);
        this.setForeground(Color.black);
        PaperSize aPS = new PaperSize("A4", 827, 1169);
        this._paperSizeList.add(aPS);
        aPS = new PaperSize("Letter", 850, 1100);
        this._paperSizeList.add(aPS);
        aPS = new PaperSize("A5", 583, 827);
        this._paperSizeList.add(aPS);
        aPS = new PaperSize("Custom", 500, 750);
        this._paperSizeList.add(aPS);
        this._isLandscape = true;
        this._pageBounds = new java.awt.Rectangle();
        this._pageBounds.x = 0;
        this._pageBounds.y = 0;
        this._pageBounds.width = 730;
        this._pageBounds.height = 480;
        this._zoom = 1.0f;
        this.setPaperSize(aPS);
        MapFrame aMF = new MapFrame();
        aMF.setActive(true);
        aMF.setLayoutBounds(new java.awt.Rectangle(40, 36, 606, 420));
        this._mapFrames.add(aMF);
        LayoutMap layoutMap = new LayoutMap(aMF, this.tileLoadListener);
        this.addElement(layoutMap);
        this._defPointBreak.setSize(10.0f);
        this._defLabelBreak.setText("Text");
        this._defLabelBreak.setFont(new Font(GlobalUtil.getDefaultFontName(), 0, 12));
        this._defPolylineBreak.setColor(Color.red);
        this._defPolylineBreak.setWidth(2.0f);
        this._defPolygonBreak.setColor(new Color(104, 255, 104, 125));
    }

    private void initComponents() {
        this._vScrollBar = new JScrollBar(1);
        this._vScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                MapLayout.this.onScrollValueChanged(e);
            }
        });
        this.add((Component)this._vScrollBar, "East");
        this._hScrollBar = new JScrollBar(0);
        this._hScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                MapLayout.this.onScrollValueChanged(e);
            }
        });
        this.add((Component)this._hScrollBar, "South");
        this._vScrollBar.setLocation(this.getWidth() - this._vScrollBar.getWidth(), 0);
        if (this._hScrollBar.isVisible()) {
            this._vScrollBar.setSize(21, this.getHeight() - 21);
        } else {
            this._vScrollBar.setSize(21, this.getHeight());
        }
        this._hScrollBar.setLocation(0, this.getHeight() - this._hScrollBar.getHeight());
        if (this._vScrollBar.isVisible()) {
            this._hScrollBar.setSize(this.getWidth() - 21, 21);
        } else {
            this._hScrollBar.setSize(this.getWidth(), 21);
        }
    }

    public void addMapFramesUpdatedListener(IMapFramesUpdatedListener listener) {
        this._listeners.add(IMapFramesUpdatedListener.class, listener);
    }

    public void removeMapFramesUpdatedListener(IMapFramesUpdatedListener listener) {
        this._listeners.remove(IMapFramesUpdatedListener.class, listener);
    }

    public void fireMapFramesUpdatedEvent() {
        this.fireMapFramesUpdatedEvent(new MapFramesUpdatedEvent(this));
    }

    private void fireMapFramesUpdatedEvent(MapFramesUpdatedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IMapFramesUpdatedListener.class) continue;
            ((IMapFramesUpdatedListener)listeners[i + 1]).mapFramesUpdatedEvent(event);
        }
    }

    public void addActiveMapFrameChangedListener(IActiveMapFrameChangedListener listener) {
        this._listeners.add(IActiveMapFrameChangedListener.class, listener);
    }

    public void removeActiveMapFrameChangedListener(IActiveMapFrameChangedListener listener) {
        this._listeners.remove(IActiveMapFrameChangedListener.class, listener);
    }

    public void fireActiveMapFrameChangedEvent() {
        this.fireActiveMapFrameChangedEvent(new ActiveMapFrameChangedEvent(this));
    }

    private void fireActiveMapFrameChangedEvent(ActiveMapFrameChangedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IActiveMapFrameChangedListener.class) continue;
            ((IActiveMapFrameChangedListener)listeners[i + 1]).activeMapFrameChangedEvent(event);
        }
    }

    public void addElementSelectedListener(IElementSelectedListener listener) {
        this._listeners.add(IElementSelectedListener.class, listener);
    }

    public void removeElementSelectedListener(IElementSelectedListener listener) {
        this._listeners.remove(IElementSelectedListener.class, listener);
    }

    public void fireElementSelectedEvent() {
        this.fireElementSelectedEvent(new ElementSelectedEvent(this));
    }

    private void fireElementSelectedEvent(ElementSelectedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IElementSelectedListener.class) continue;
            ((IElementSelectedListener)listeners[i + 1]).elementSelectedEvent(event);
        }
    }

    public void addZoomChangedListener(IZoomChangedListener listener) {
        this._listeners.add(IZoomChangedListener.class, listener);
    }

    public void removeZoomChangedListener(IZoomChangedListener listener) {
        this._listeners.remove(IZoomChangedListener.class, listener);
    }

    public void fireZoomChangedEvent() {
        this.fireZoomChangedEvent(new ZoomChangedEvent(this));
    }

    private void fireZoomChangedEvent(ZoomChangedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IZoomChangedListener.class) continue;
            ((IZoomChangedListener)listeners[i + 1]).zoomChangedEvent(event);
        }
    }

    public void addUndoEditListener(IUndoEditListener listener) {
        this._listeners.add(IUndoEditListener.class, listener);
    }

    public void removeUndoEditListener(IUndoEditListener listener) {
        this._listeners.remove(IUndoEditListener.class, listener);
    }

    public void fireUndoEditEvent(UndoableEdit undoEdit) {
        this.fireUndoEditEvent(new UndoEditEvent(this), undoEdit);
    }

    private void fireUndoEditEvent(UndoEditEvent event, UndoableEdit undoEdit) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IUndoEditListener.class) continue;
            ((IUndoEditListener)listeners[i + 1]).undoEditEvent(event, undoEdit);
        }
    }

    public void onScrollValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this._vScrollBar) {
            int y = -e.getValue();
            if (y == 1) {
                y = 0;
            }
            this._pageLocation.Y = y;
        }
        if (e.getSource() == this._hScrollBar) {
            int x = -e.getValue();
            if (x == 1) {
                x = 0;
            }
            this._pageLocation.X = x;
        }
        this.paintGraphics();
    }

    void onComponentResized(ComponentEvent e) {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            this._vScrollBar.setLocation(this.getWidth() - this._vScrollBar.getWidth(), 0);
            if (this._hScrollBar.isVisible()) {
                this._vScrollBar.setSize(this._vScrollBar.getWidth(), this.getHeight() - this._vScrollBar.getWidth());
            } else {
                this._vScrollBar.setSize(this._vScrollBar.getWidth(), this.getHeight());
            }
            this._hScrollBar.setLocation(0, this.getHeight() - this._hScrollBar.getHeight());
            if (this._vScrollBar.isVisible()) {
                this._hScrollBar.setSize(this.getWidth() - this._hScrollBar.getHeight(), this._hScrollBar.getHeight());
            } else {
                this._hScrollBar.setSize(this.getWidth(), this._hScrollBar.getHeight());
            }
            this.paintGraphics();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void onMousePressed(MouseEvent e) {
        block31: {
            block30: {
                if (e.getButton() != 1) break block30;
                Point pageP = this.screenToPage(e.getX(), e.getY());
                Graphics2D g = (Graphics2D)this.getGraphics();
                LayoutMap aLM = this.getLayoutMap(pageP);
                if (aLM != null) {
                    this._currentLayoutMap = aLM;
                }
                block0 : switch (this._mouseMode) {
                    case Map_Pan: {
                        java.awt.Rectangle mapRect = this.pageToScreen(this._currentLayoutMap.getBounds());
                        this._tempImage = new BufferedImage(mapRect.width - 2, mapRect.height - 2, 2);
                        Graphics2D tg = this._tempImage.createGraphics();
                        tg.setColor(this._currentLayoutMap.getMapFrame().getMapView().getBackground());
                        tg.fill(mapRect);
                        tg.drawImage((Image)this._layoutBitmap, -mapRect.x - 1, -mapRect.y - 1, this);
                        tg.dispose();
                        break;
                    }
                    case Select: {
                        List<LayoutElement> tempGraphics = this.selectElements(pageP, this._selectedElements, 3);
                        if (tempGraphics.size() > 0) {
                            this._selectedRectangle = (java.awt.Rectangle)this._selectedElements.get(0).getBounds().clone();
                            this._selectedRectangle = this.pageToScreen(this._selectedRectangle);
                            if (this._resizeSelectedEdge == Edge.None) {
                                this._mouseMode = MouseMode.MoveSelection;
                                break;
                            }
                            this._mouseMode = MouseMode.ResizeSelected;
                            break;
                        }
                        this._mouseMode = MouseMode.CreateSelection;
                        break;
                    }
                    case New_Point: {
                        PointShape aPS = new PointShape();
                        aPS.setPoint(new org.meteoinfo.global.PointD(pageP.x, pageP.y));
                        Graphic aGraphic = new Graphic(aPS, (PointBreak)this._defPointBreak.clone());
                        LayoutGraphic aLayoutGraphic = new LayoutGraphic(aGraphic, this);
                        this.addElement(aLayoutGraphic);
                        this.paintGraphics();
                        MapLayoutUndoRedo mapLayoutUndoRedo = new MapLayoutUndoRedo();
                        Objects.requireNonNull(mapLayoutUndoRedo);
                        MapLayoutUndoRedo.AddElementEdit edit = new MapLayoutUndoRedo.AddElementEdit(mapLayoutUndoRedo, this, aLayoutGraphic);
                        this.fireUndoEditEvent(edit);
                        break;
                    }
                    case New_Label: {
                        PointShape aPS = new PointShape();
                        aPS.setPoint(new org.meteoinfo.global.PointD(pageP.x, pageP.y));
                        Graphic aGraphic = new Graphic(aPS, (LabelBreak)this._defLabelBreak.clone());
                        LayoutGraphic aLayoutGraphic = new LayoutGraphic(aGraphic, this);
                        this.addElement(aLayoutGraphic);
                        this.paintGraphics();
                        MapLayoutUndoRedo mapLayoutUndoRedo = new MapLayoutUndoRedo();
                        Objects.requireNonNull(mapLayoutUndoRedo);
                        MapLayoutUndoRedo.AddElementEdit edit = new MapLayoutUndoRedo.AddElementEdit(mapLayoutUndoRedo, this, aLayoutGraphic);
                        this.fireUndoEditEvent(edit);
                        break;
                    }
                    case New_Polyline: 
                    case New_Polygon: 
                    case New_Curve: 
                    case New_CurvePolygon: 
                    case New_Freehand: 
                    case Map_SelectFeatures_Polygon: 
                    case Map_SelectFeatures_Lasso: {
                        if (this._startNewGraphic) {
                            this._graphicPoints = new ArrayList<PointF>();
                            this._startNewGraphic = false;
                        }
                        this._graphicPoints.add(new PointF(e.getX(), e.getY()));
                        break;
                    }
                    case EditVertices: {
                        if (this._selectedElements.size() <= 0) break;
                        this._editingVerticeIndex = this.selectEditVertices(pageP, ((LayoutGraphic)this._selectedElements.get(0)).getGraphic().getShape(), this._editingVertices);
                        if (this._editingVerticeIndex < 0) break;
                        this._mouseMode = MouseMode.InEditingVertices;
                        break;
                    }
                    case Map_Measurement: {
                        if (this._frmMeasure == null || !this._frmMeasure.isVisible()) break;
                        switch (this._frmMeasure.getMeasureType()) {
                            case Length: 
                            case Area: {
                                if (this._startNewGraphic) {
                                    this._graphicPoints = new ArrayList<PointF>();
                                    this._startNewGraphic = false;
                                }
                                this._frmMeasure.setPreviousValue(this._frmMeasure.getTotalValue());
                                this._graphicPoints.add(new PointF(e.getX(), e.getY()));
                                break block0;
                            }
                            case Feature: {
                                VectorLayer aLayer;
                                MapLayer aMLayer = this._currentLayoutMap.getMapFrame().getMapView().getSelectedLayer();
                                if (aMLayer == null || aMLayer.getLayerType() != LayerTypes.VectorLayer || (aLayer = (VectorLayer)aMLayer).getShapeType() == ShapeTypes.Point) break block0;
                                PointF mapP = this.pageToScreen(this._currentLayoutMap.getLeft(), this._currentLayoutMap.getTop());
                                PointF aPoint = new PointF((float)e.getX() - mapP.X, (float)e.getY() - mapP.Y);
                                List<Integer> selectedShapes = this._currentLayoutMap.getMapFrame().getMapView().selectShapes(aLayer, aPoint);
                                if (selectedShapes.size() <= 0) break block0;
                                int shapeIdx = selectedShapes.get(0);
                                Shape aShape = aLayer.getShapes().get(shapeIdx);
                                aLayer.setIdentiferShape(shapeIdx);
                                this._currentLayoutMap.getMapFrame().getMapView().setDrawIdentiferShape(true);
                                this.repaint();
                                double value = 0.0;
                                switch (aShape.getShapeType()) {
                                    case Polyline: 
                                    case PolylineZ: {
                                        this._frmMeasure.setArea(false);
                                        if (this._currentLayoutMap.getMapFrame().getMapView().getProjection().isLonLatMap()) {
                                            value = GeoComputation.getDistance(((PolylineShape)aShape).getPoints(), true);
                                            break;
                                        }
                                        value = ((PolylineShape)aShape).getLength();
                                        value *= this._currentLayoutMap.getMapFrame().getMapView().getProjection().getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres();
                                        break;
                                    }
                                    case Polygon: 
                                    case PolygonM: 
                                    case PolygonZ: {
                                        this._frmMeasure.setArea(true);
                                        value = this._currentLayoutMap.getMapFrame().getMapView().getProjection().isLonLatMap() ? ((PolygonShape)aShape).getSphericalArea() : ((PolygonShape)aShape).getArea();
                                        value *= this._currentLayoutMap.getMapFrame().getMapView().getProjection().getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres() * this._currentLayoutMap.getMapFrame().getMapView().getProjection().getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres();
                                        break;
                                    }
                                }
                                this._frmMeasure.setCurrentValue(value);
                            }
                        }
                    }
                }
                break block31;
            }
            if (e.getButton() == 3) {
                switch (this._mouseMode) {
                    case Map_Measurement: {
                        if (!this._frmMeasure.isVisible()) break;
                        switch (this._frmMeasure.getMeasureType()) {
                            case Length: 
                            case Area: {
                                this._startNewGraphic = true;
                                this._frmMeasure.setTotalValue(0.0);
                            }
                        }
                        break;
                    }
                }
            }
        }
        this._mouseDownPoint.x = e.getX();
        this._mouseDownPoint.y = e.getY();
        this._mouseLastPos = new Point(this._mouseDownPoint.x, this._mouseDownPoint.y);
    }

    void onMouseDragged(MouseEvent e) {
        this._dragMode = true;
        int deltaX = e.getX() - this._mouseLastPos.x;
        int deltaY = e.getY() - this._mouseLastPos.y;
        this._mouseLastPos.x = e.getX();
        this._mouseLastPos.y = e.getY();
        Point pageP = this.screenToPage(e.getX(), e.getY());
        Graphics2D g = (Graphics2D)this.getGraphics();
        this._vScrollBar.setCursor(Cursor.getDefaultCursor());
        this._hScrollBar.setCursor(Cursor.getDefaultCursor());
        switch (this._mouseMode) {
            case Map_ZoomIn: {
                if (!this.isInLayoutMaps(pageP)) break;
                this.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/zoom_in_32x32x32.png")), new Point(8, 8), "Zoom In"));
                this.repaint();
                break;
            }
            case Map_Pan: {
                if (!this.isInLayoutMaps(pageP)) break;
                this.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/Pan_Open_32x32x32.png")), new Point(8, 8), "Pan"));
                java.awt.Rectangle mapRect = this.pageToScreen(this._currentLayoutMap.getBounds());
                g.setClip(mapRect);
                Color aColor = this._currentLayoutMap.getMapFrame().getBackColor();
                if (aColor.getAlpha() == 255) {
                    aColor = Color.white;
                }
                g.setColor(aColor);
                int aX = e.getX() - this._mouseDownPoint.x;
                int aY = e.getY() - this._mouseDownPoint.y;
                aX = (int)((float)aX / this._zoom);
                aY = (int)((float)aY / this._zoom);
                if (aX > 0) {
                    if (mapRect.x >= 0) {
                        g.fillRect(mapRect.x, mapRect.y, aX, mapRect.height);
                    } else {
                        g.fillRect(0, mapRect.y, aX, mapRect.height);
                    }
                } else if (mapRect.x <= this.getWidth()) {
                    g.fillRect(mapRect.x + mapRect.width + aX, mapRect.y, Math.abs(aX), mapRect.height);
                } else {
                    g.fillRect(this.getWidth() + aX, mapRect.y, Math.abs(aX), mapRect.height);
                }
                if (aY > 0) {
                    if (mapRect.y >= 0) {
                        g.fillRect(mapRect.x, mapRect.y, mapRect.width, aY);
                    } else {
                        g.fillRect(mapRect.x, 0, mapRect.width, aY);
                    }
                } else if (mapRect.y + mapRect.height <= this.getX() + this.getHeight()) {
                    g.fillRect(mapRect.x, mapRect.y + mapRect.height + aY, mapRect.width, Math.abs(aY));
                } else {
                    g.fillRect(mapRect.x, this.getY() + this.getHeight() + aY, mapRect.width, Math.abs(aY));
                }
                int startX = mapRect.x + aX;
                int startY = mapRect.y + aY;
                AffineTransformOp aop = new AffineTransformOp(new AffineTransform(), 2);
                g.drawImage(this._tempImage, aop, startX, startY);
                g.setColor(this.getForeground());
                g.draw(mapRect);
                break;
            }
            case Map_SelectFeatures_Rectangle: {
                this.repaint();
                break;
            }
            case MoveSelection: {
                this.setCursor(Cursor.getPredefinedCursor(13));
                this.repaint();
                break;
            }
            case ResizeSelected: {
                LayoutElement oElement = this._selectedElements.get(0);
                block9 : switch (oElement.getResizeAbility()) {
                    case SameWidthHeight: {
                        switch (this._resizeSelectedEdge) {
                            case TopLeft: {
                                this._selectedRectangle.x += deltaX;
                                this._selectedRectangle.y += deltaX;
                                this._selectedRectangle.width -= deltaX;
                                this._selectedRectangle.height -= deltaX;
                                break;
                            }
                            case BottomRight: {
                                this._selectedRectangle.width += deltaX;
                                this._selectedRectangle.height += deltaX;
                                break;
                            }
                            case TopRight: {
                                this._selectedRectangle.y += deltaY;
                                this._selectedRectangle.width -= deltaY;
                                this._selectedRectangle.height -= deltaY;
                                break;
                            }
                            case BottomLeft: {
                                this._selectedRectangle.x += deltaX;
                                this._selectedRectangle.width -= deltaX;
                                this._selectedRectangle.height -= deltaX;
                            }
                        }
                        break;
                    }
                    case ResizeAll: {
                        switch (this._resizeSelectedEdge) {
                            case TopLeft: {
                                this._selectedRectangle.x += deltaX;
                                this._selectedRectangle.y += deltaY;
                                this._selectedRectangle.width -= deltaX;
                                this._selectedRectangle.height -= deltaY;
                                break block9;
                            }
                            case BottomRight: {
                                this._selectedRectangle.width += deltaX;
                                this._selectedRectangle.height += deltaY;
                                break block9;
                            }
                            case Top: {
                                this._selectedRectangle.y += deltaY;
                                this._selectedRectangle.height -= deltaY;
                                break block9;
                            }
                            case Bottom: {
                                this._selectedRectangle.height += deltaY;
                                break block9;
                            }
                            case TopRight: {
                                this._selectedRectangle.y += deltaY;
                                this._selectedRectangle.width += deltaX;
                                this._selectedRectangle.height -= deltaY;
                                break block9;
                            }
                            case BottomLeft: {
                                this._selectedRectangle.x += deltaX;
                                this._selectedRectangle.width -= deltaX;
                                this._selectedRectangle.height += deltaY;
                                break block9;
                            }
                            case Left: {
                                this._selectedRectangle.x += deltaX;
                                this._selectedRectangle.width -= deltaX;
                                break block9;
                            }
                            case Right: {
                                this._selectedRectangle.width += deltaX;
                            }
                        }
                    }
                }
                this.repaint();
                break;
            }
            case New_Freehand: 
            case Map_SelectFeatures_Polygon: 
            case Map_SelectFeatures_Lasso: 
            case New_Rectangle: 
            case New_Ellipse: 
            case New_Circle: 
            case Map_SelectFeatures_Circle: {
                this.repaint();
                break;
            }
            case InEditingVertices: {
                this.repaint();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void onMouseMoved(MouseEvent e) {
        this._mouseLastPos.x = e.getX();
        this._mouseLastPos.y = e.getY();
        Point pageP = this.screenToPage(e.getX(), e.getY());
        Graphics2D g = (Graphics2D)this.getGraphics();
        this._vScrollBar.setCursor(Cursor.getDefaultCursor());
        this._hScrollBar.setCursor(Cursor.getDefaultCursor());
        block0 : switch (this._mouseMode) {
            case Map_ZoomIn: {
                if (!this.isInLayoutMaps(pageP)) return;
                this.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/zoom_in_32x32x32.png")), new Point(8, 8), "Zoom In"));
                return;
            }
            case Map_ZoomOut: {
                if (!this.isInLayoutMaps(pageP)) return;
                this.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/zoom_out_32x32x32.png")), new Point(8, 8), "Zoom Out"));
                return;
            }
            case Map_Pan: {
                if (!this.isInLayoutMaps(pageP)) return;
                this.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/Pan_Open_32x32x32.png")), new Point(8, 8), "Pan"));
                return;
            }
            case Map_Identifer: {
                if (!this.isInLayoutMaps(pageP)) return;
                this.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/identifer_32x32x32.png")), new Point(8, 8), "Identifer"));
                return;
            }
            case Map_SelectFeatures_Rectangle: {
                if (!this.isInLayoutMaps(pageP)) return;
                this.setCursor(Cursor.getPredefinedCursor(1));
                return;
            }
            case Select: {
                if (this._selectedElements.size() > 0) {
                    List<LayoutElement> tempElements = this.selectElements(pageP, this._selectedElements, 3);
                    if (tempElements.size() > 0) {
                        java.awt.Rectangle aRect = (java.awt.Rectangle)this._selectedElements.get(0).getBounds().clone();
                        this._resizeSelectedEdge = MapLayout.intersectElementEdge(aRect, new PointF(pageP.x, pageP.y), 3.0f);
                        switch (this._selectedElements.get(0).getResizeAbility()) {
                            case SameWidthHeight: {
                                switch (this._resizeSelectedEdge) {
                                    case TopLeft: 
                                    case BottomRight: {
                                        this.setCursor(Cursor.getPredefinedCursor(6));
                                        return;
                                    }
                                    case TopRight: 
                                    case BottomLeft: {
                                        this.setCursor(Cursor.getPredefinedCursor(7));
                                        return;
                                    }
                                }
                                this.setCursor(Cursor.getPredefinedCursor(13));
                                return;
                            }
                            case ResizeAll: {
                                switch (this._resizeSelectedEdge) {
                                    case TopLeft: 
                                    case BottomRight: {
                                        this.setCursor(Cursor.getPredefinedCursor(6));
                                        return;
                                    }
                                    case Top: 
                                    case Bottom: {
                                        this.setCursor(Cursor.getPredefinedCursor(8));
                                        return;
                                    }
                                    case TopRight: 
                                    case BottomLeft: {
                                        this.setCursor(Cursor.getPredefinedCursor(7));
                                        return;
                                    }
                                    case Left: 
                                    case Right: {
                                        this.setCursor(Cursor.getPredefinedCursor(11));
                                        return;
                                    }
                                    case None: {
                                        this.setCursor(Cursor.getPredefinedCursor(13));
                                    }
                                }
                                return;
                            }
                        }
                        this.setCursor(Cursor.getPredefinedCursor(13));
                        return;
                    }
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            case MoveSelection: {
                return;
            }
            case ResizeSelected: {
                return;
            }
            case New_Polyline: 
            case New_Polygon: 
            case New_Curve: 
            case New_CurvePolygon: 
            case Map_SelectFeatures_Polygon: {
                if (this._startNewGraphic) return;
                this.repaint();
                return;
            }
            case EditVertices: {
                if (this._selectedElements.size() <= 0) return;
                this._editingVerticeIndex = this.selectEditVertices(pageP, ((LayoutGraphic)this._selectedElements.get(0)).getGraphic().getShape(), this._editingVertices);
                if (this._editingVerticeIndex < 0) return;
                this.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/VertexEdit_32x32x32.png")), new Point(8, 8), "Vertices edit"));
                return;
            }
            case Map_Measurement: {
                if (this.isInLayoutMaps(pageP)) {
                    this.setCursor(Cursor.getPredefinedCursor(1));
                }
                if (this._frmMeasure == null || !this._frmMeasure.isVisible()) return;
                switch (this._frmMeasure.getMeasureType()) {
                    case Length: 
                    case Area: {
                        if (this._startNewGraphic) return;
                        this.repaint();
                        PointF[] fpoints = this._graphicPoints.toArray(new PointF[this._graphicPoints.size()]);
                        PointF[] points = new PointF[fpoints.length + 1];
                        System.arraycopy(fpoints, 0, points, 0, fpoints.length);
                        points[this._graphicPoints.size()] = new PointF(e.getX(), e.getY());
                        PointF mapP = this.pageToScreen(this._currentLayoutMap.getLeft(), this._currentLayoutMap.getTop());
                        PointF aPoint = new PointF((float)e.getX() - mapP.X, (float)e.getY() - mapP.Y);
                        float[] pXY = this._currentLayoutMap.getMapFrame().getMapView().screenToProj(aPoint.X, aPoint.Y);
                        if (this._frmMeasure.getMeasureType() == FrmMeasurement.MeasureTypes.Length) {
                            double dist;
                            aPoint = new PointF((float)this._mouseDownPoint.x - mapP.X, (float)this._mouseDownPoint.y - mapP.Y);
                            float[] pPXY = this._currentLayoutMap.getMapFrame().getMapView().screenToProj(aPoint.X, aPoint.Y);
                            double dx = Math.abs(pXY[0] - pPXY[0]);
                            double dy = Math.abs(pXY[1] - pPXY[1]);
                            if (this._currentLayoutMap.getMapFrame().getMapView().getProjection().isLonLatMap()) {
                                double y = (pXY[1] + pPXY[1]) / 2.0f;
                                double factor = Math.cos(y * Math.PI / 180.0);
                                dist = Math.sqrt((dx *= factor) * dx + dy * dy);
                                dist *= 111319.5;
                            } else {
                                dist = Math.sqrt(dx * dx + dy * dy);
                                dist *= this._currentLayoutMap.getMapFrame().getMapView().getProjection().getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres();
                            }
                            this._frmMeasure.setCurrentValue(dist);
                            break block0;
                        }
                        ArrayList<org.meteoinfo.global.PointD> mPoints = new ArrayList<org.meteoinfo.global.PointD>();
                        for (int i = 0; i < points.length; ++i) {
                            aPoint = new PointF(points[i].X - mapP.X, points[i].Y - mapP.Y);
                            pXY = this._currentLayoutMap.getMapFrame().getMapView().screenToProj(aPoint.X, aPoint.Y);
                            mPoints.add(new org.meteoinfo.global.PointD(pXY[0], pXY[1]));
                        }
                        double area = GeoComputation.getArea(mPoints);
                        area = this._currentLayoutMap.getMapFrame().getMapView().getProjection().isLonLatMap() ? area * 111319.5 * 111319.5 : (area *= this._currentLayoutMap.getMapFrame().getMapView().getProjection().getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres() * this._currentLayoutMap.getMapFrame().getMapView().getProjection().getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres());
                        this._frmMeasure.setCurrentValue(area);
                    }
                }
            }
        }
    }

    void onMouseReleased(MouseEvent e) throws CloneNotSupportedException {
        this._dragMode = false;
        Point pageP = this.screenToPage(e.getX(), e.getY());
        switch (this._mouseMode) {
            case Map_ZoomIn: {
                double ZoomF;
                double MinX = Math.min(e.getX(), this._mouseDownPoint.x);
                double MinY = Math.min(e.getY(), this._mouseDownPoint.y);
                double MaxX = Math.max(e.getX(), this._mouseDownPoint.x);
                double MaxY = Math.max(e.getY(), this._mouseDownPoint.y);
                if (MaxX - MinX < 5.0) {
                    ZoomF = e.getButton() == 1 ? 0.75 : 1.5;
                    MinX = (double)pageP.x - (double)(this._currentLayoutMap.getWidth() / 2) * ZoomF;
                    MaxX = (double)pageP.x + (double)(this._currentLayoutMap.getWidth() / 2) * ZoomF;
                    MinY = (double)pageP.y - (double)(this._currentLayoutMap.getHeight() / 2) * ZoomF;
                    MaxY = (double)pageP.y + (double)(this._currentLayoutMap.getHeight() / 2) * ZoomF;
                } else {
                    PointF minP = this.screenToPage((float)MinX, (float)MinY);
                    PointF maxP = this.screenToPage((float)MaxX, (float)MaxY);
                    MinX = minP.X;
                    MinY = minP.Y;
                    MaxX = maxP.X;
                    MaxY = maxP.Y;
                }
                MinX -= (double)this._currentLayoutMap.getLeft();
                MinY -= (double)this._currentLayoutMap.getTop();
                MaxX -= (double)this._currentLayoutMap.getLeft();
                MaxY -= (double)this._currentLayoutMap.getTop();
                if (!(MaxX - MinX > 0.001)) break;
                this._currentLayoutMap.getMapFrame().getMapView().zoomToExtentScreen(MinX, MaxX, MinY, MaxY, this._zoom);
                break;
            }
            case Map_ZoomOut: {
                double ZoomF = e.getButton() == 1 ? 1.5 : 0.75;
                double MinX = (double)pageP.x - (double)(this._currentLayoutMap.getWidth() / 2) * ZoomF;
                double MaxX = (double)pageP.x + (double)(this._currentLayoutMap.getWidth() / 2) * ZoomF;
                double MinY = (double)pageP.y - (double)(this._currentLayoutMap.getHeight() / 2) * ZoomF;
                double MaxY = (double)pageP.y + (double)(this._currentLayoutMap.getHeight() / 2) * ZoomF;
                MinX -= (double)this._currentLayoutMap.getLeft();
                MinY -= (double)this._currentLayoutMap.getTop();
                MaxX -= (double)this._currentLayoutMap.getLeft();
                MaxY -= (double)this._currentLayoutMap.getTop();
                if (!(MaxX - MinX > 0.001)) break;
                this._currentLayoutMap.getMapFrame().getMapView().zoomToExtentScreen(MinX, MaxX, MinY, MaxY, this._zoom);
                break;
            }
            case Map_Pan: {
                if (e.getButton() != 1) break;
                int deltaX = e.getX() - this._mouseDownPoint.x;
                int deltaY = e.getY() - this._mouseDownPoint.y;
                deltaX = (int)((float)deltaX / this._zoom);
                deltaY = (int)((float)deltaY / this._zoom);
                double MinX = -deltaX;
                double MinY = -deltaY;
                double MaxX = this._currentLayoutMap.getWidth() - deltaX;
                double MaxY = this._currentLayoutMap.getHeight() - deltaY;
                this._currentLayoutMap.getMapFrame().getMapView().zoomToExtentScreen(MinX, MaxX, MinY, MaxY, this._zoom);
            }
        }
        if (e.getButton() == 1) {
            switch (this._mouseMode) {
                case Map_SelectFeatures_Rectangle: {
                    if (this._currentLayoutMap.getMapFrame().getMapView().getSelectedLayerHandle() < 0) {
                        return;
                    }
                    MapLayer aMLayer = this._currentLayoutMap.getMapFrame().getMapView().getSelectedLayer();
                    if (aMLayer == null) {
                        return;
                    }
                    if (aMLayer.getLayerType() != LayerTypes.VectorLayer) {
                        return;
                    }
                    VectorLayer aLayer = (VectorLayer)aMLayer;
                    PointF mapP = this.pageToScreen(this._currentLayoutMap.getLeft(), this._currentLayoutMap.getTop());
                    Point aPoint = new Point(e.getX() - (int)mapP.X, e.getY() - (int)mapP.Y);
                    Point bPoint = new Point(this._mouseDownPoint.x - (int)mapP.X, this._mouseDownPoint.y - (int)mapP.Y);
                    int minx = Math.min(bPoint.x, aPoint.x);
                    int miny = Math.min(bPoint.y, aPoint.y);
                    int width = Math.abs(aPoint.x - bPoint.x);
                    int height = Math.abs(aPoint.y - bPoint.y);
                    Rectangle2D.Float rect = new Rectangle2D.Float(minx, miny, width, height);
                    List<Integer> selectedShapes = this._currentLayoutMap.getMapFrame().getMapView().selectShapes(aLayer, rect);
                    if (!e.isControlDown() && !e.isShiftDown()) {
                        aLayer.clearSelectedShapes();
                    }
                    if (selectedShapes.size() > 0) {
                        for (int shapeIdx : selectedShapes) {
                            Shape shape;
                            shape.setSelected(!(shape = aLayer.getShapes().get(shapeIdx)).isSelected());
                        }
                        this._currentLayoutMap.getMapFrame().getMapView().fireShapeSelectedEvent();
                    }
                    this.paintGraphics();
                    break;
                }
                case CreateSelection: {
                    for (LayoutElement aElement : this._selectedElements) {
                        aElement.setSelected(false);
                    }
                    this._selectedElements.clear();
                    if (Math.abs(e.getX() - this._mouseDownPoint.x) > 2 || Math.abs(e.getY() - this._mouseDownPoint.y) > 2) {
                        this.paintGraphics();
                        return;
                    }
                    this._selectedElements = this.selectElements(pageP, this._layoutElements, 0);
                    if (this._selectedElements.size() > 0) {
                        for (int i = 0; i < this._selectedElements.size() - 1; ++i) {
                            this._selectedElements.remove(this._selectedElements.size() - 1);
                        }
                        this._selectedElements.get(0).setSelected(true);
                        if (this._selectedElements.get(0).getElementType() == ElementType.LayoutMap) {
                            this.setActiveMapFrame(((LayoutMap)this._selectedElements.get(0)).getMapFrame());
                        }
                    }
                    this.fireElementSelectedEvent();
                    this._mouseMode = MouseMode.Select;
                    this.paintGraphics();
                    break;
                }
                case MoveSelection: {
                    if (Math.abs(e.getX() - this._mouseDownPoint.x) < 2 && Math.abs(e.getY() - this._mouseDownPoint.y) < 2) {
                        LayoutElement aElement = this._selectedElements.get(0);
                        this._selectedElements = this.selectElements(pageP, this._layoutElements, 0);
                        if (this._selectedElements.size() > 1) {
                            aElement.setSelected(false);
                            int idx = this._selectedElements.indexOf(aElement);
                            idx = idx == 0 ? this._selectedElements.size() - 1 : --idx;
                            if (idx < 0) {
                                idx = 0;
                            }
                            aElement = this._selectedElements.get(idx);
                            this._selectedElements.clear();
                            this._selectedElements.add(aElement);
                            this._selectedElements.get(0).setSelected(true);
                            if (this._selectedElements.get(0).getElementType() == ElementType.LayoutMap) {
                                this.setActiveMapFrame(((LayoutMap)this._selectedElements.get(0)).getMapFrame());
                            }
                        }
                        this.fireElementSelectedEvent();
                    } else {
                        int deltaX = (int)((float)(e.getX() - this._mouseDownPoint.x) / this._zoom);
                        int deltaY = (int)((float)(e.getY() - this._mouseDownPoint.y) / this._zoom);
                        for (LayoutElement aElement : this._selectedElements) {
                            aElement.setLeft(aElement.getLeft() + deltaX);
                            aElement.setTop(aElement.getTop() + deltaY);
                            aElement.moveUpdate();
                        }
                        MapLayoutUndoRedo mapLayoutUndoRedo = new MapLayoutUndoRedo();
                        Objects.requireNonNull(mapLayoutUndoRedo);
                        MapLayoutUndoRedo.MoveElementsEdit edit = new MapLayoutUndoRedo.MoveElementsEdit(mapLayoutUndoRedo, this, this._selectedElements, deltaX, deltaY);
                        this.fireUndoEditEvent(edit);
                    }
                    this._mouseMode = MouseMode.Select;
                    this.paintGraphics();
                    break;
                }
                case ResizeSelected: {
                    this._mouseMode = MouseMode.Select;
                    LayoutElement oElement = this._selectedElements.get(0);
                    if (this._selectedRectangle.width < 3) {
                        this._selectedRectangle.width = 3;
                    }
                    if (this._selectedRectangle.height < 3) {
                        this._selectedRectangle.height = 3;
                    }
                    MapLayoutUndoRedo mapLayoutUndoRedo = new MapLayoutUndoRedo();
                    Objects.requireNonNull(mapLayoutUndoRedo);
                    MapLayoutUndoRedo.ResizeElementEdit edit = new MapLayoutUndoRedo.ResizeElementEdit(mapLayoutUndoRedo, this, oElement, this._selectedRectangle);
                    this.fireUndoEditEvent(edit);
                    PointF minP = this.screenToPage((float)this._selectedRectangle.x, (float)this._selectedRectangle.y);
                    PointF maxP = this.screenToPage((float)this._selectedRectangle.x + (float)this._selectedRectangle.width, (float)(this._selectedRectangle.y + this._selectedRectangle.height));
                    oElement.setLeft((int)minP.X);
                    oElement.setTop((int)minP.Y);
                    oElement.setWidth((int)(maxP.X - minP.X));
                    oElement.setHeight((int)(maxP.Y - minP.Y));
                    oElement.resizeUpdate();
                    this.paintGraphics();
                    break;
                }
                case New_Rectangle: 
                case New_Ellipse: {
                    if (e.getButton() != 1) break;
                    if (e.getX() - this._mouseDownPoint.x < 2 || e.getY() - this._mouseDownPoint.y < 2) {
                        return;
                    }
                    this._startNewGraphic = true;
                    this._graphicPoints = new ArrayList<PointF>();
                    this._graphicPoints.add(new PointF(this._mouseDownPoint.x, this._mouseDownPoint.y));
                    this._graphicPoints.add(new PointF(this._mouseDownPoint.x, e.getY()));
                    this._graphicPoints.add(new PointF(e.getX(), e.getY()));
                    this._graphicPoints.add(new PointF(e.getX(), this._mouseDownPoint.y));
                    ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
                    for (PointF cPoint : this._graphicPoints) {
                        PointF dPoint = this.screenToPage(cPoint.X, cPoint.Y);
                        points.add(new org.meteoinfo.global.PointD(dPoint.X, dPoint.Y));
                    }
                    Graphic aGraphic = null;
                    switch (this._mouseMode) {
                        case New_Rectangle: {
                            RectangleShape aPGS = new RectangleShape();
                            points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                            aPGS.setPoints(points);
                            aGraphic = new Graphic(aPGS, (PolygonBreak)this._defPolygonBreak.clone());
                            break;
                        }
                        case New_Ellipse: {
                            EllipseShape aES = new EllipseShape();
                            aES.setPoints(points);
                            aGraphic = new Graphic(aES, (PolygonBreak)this._defPolygonBreak.clone());
                        }
                    }
                    if (aGraphic != null) {
                        LayoutGraphic lg = new LayoutGraphic(aGraphic, this);
                        this.addElement(lg);
                        this.paintGraphics();
                        MapLayoutUndoRedo mapLayoutUndoRedo = new MapLayoutUndoRedo();
                        Objects.requireNonNull(mapLayoutUndoRedo);
                        MapLayoutUndoRedo.AddElementEdit edit = new MapLayoutUndoRedo.AddElementEdit(mapLayoutUndoRedo, this, lg);
                        this.fireUndoEditEvent(edit);
                        break;
                    }
                    this.repaint();
                    break;
                }
                case New_Freehand: {
                    if (e.getButton() != 1) break;
                    this._startNewGraphic = true;
                    if (this._graphicPoints.size() < 2) break;
                    ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
                    for (PointF cPoint : this._graphicPoints) {
                        PointF dPoint = this.screenToPage(cPoint.X, cPoint.Y);
                        points.add(new org.meteoinfo.global.PointD(dPoint.X, dPoint.Y));
                    }
                    PolylineShape aPLS = new PolylineShape();
                    aPLS.setPoints(points);
                    Graphic aGraphic = new Graphic(aPLS, (PolylineBreak)this._defPolylineBreak.clone());
                    LayoutGraphic lg = new LayoutGraphic(aGraphic, this);
                    this.addElement(lg);
                    this.paintGraphics();
                    MapLayoutUndoRedo mapLayoutUndoRedo = new MapLayoutUndoRedo();
                    Objects.requireNonNull(mapLayoutUndoRedo);
                    MapLayoutUndoRedo.AddElementEdit edit = new MapLayoutUndoRedo.AddElementEdit(mapLayoutUndoRedo, this, lg);
                    this.fireUndoEditEvent(edit);
                    break;
                }
                case New_Circle: {
                    if (e.getButton() != 1) break;
                    if (e.getX() - this._mouseDownPoint.x < 2 || e.getY() - this._mouseDownPoint.y < 2) {
                        return;
                    }
                    float radius = (float)Math.sqrt(Math.pow(e.getX() - this._mouseDownPoint.x, 2.0) + Math.pow(e.getY() - this._mouseDownPoint.y, 2.0));
                    this._startNewGraphic = true;
                    this._graphicPoints = new ArrayList<PointF>();
                    this._graphicPoints.add(new PointF((float)this._mouseDownPoint.x - radius, this._mouseDownPoint.y));
                    this._graphicPoints.add(new PointF(this._mouseDownPoint.x, (float)this._mouseDownPoint.y - radius));
                    this._graphicPoints.add(new PointF((float)this._mouseDownPoint.x + radius, this._mouseDownPoint.y));
                    this._graphicPoints.add(new PointF(this._mouseDownPoint.x, (float)this._mouseDownPoint.y + radius));
                    ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
                    for (PointF cPoint : this._graphicPoints) {
                        PointF dPoint = this.screenToPage(cPoint.X, cPoint.Y);
                        points.add(new org.meteoinfo.global.PointD(dPoint.X, dPoint.Y));
                    }
                    CircleShape aPGS = new CircleShape();
                    aPGS.setPoints(points);
                    Graphic aGraphic = new Graphic(aPGS, (PolygonBreak)this._defPolygonBreak.clone());
                    LayoutGraphic lg = new LayoutGraphic(aGraphic, this);
                    this.addElement(lg);
                    this.paintGraphics();
                    MapLayoutUndoRedo mapLayoutUndoRedo = new MapLayoutUndoRedo();
                    Objects.requireNonNull(mapLayoutUndoRedo);
                    MapLayoutUndoRedo.AddElementEdit edit = new MapLayoutUndoRedo.AddElementEdit(mapLayoutUndoRedo, this, lg);
                    this.fireUndoEditEvent(edit);
                    break;
                }
                case InEditingVertices: {
                    LayoutGraphic lg = (LayoutGraphic)this._selectedElements.get(0);
                    MapLayoutUndoRedo mapLayoutUndoRedo = new MapLayoutUndoRedo();
                    Objects.requireNonNull(mapLayoutUndoRedo);
                    MapLayoutUndoRedo.MoveGraphicVerticeEdit edit = new MapLayoutUndoRedo.MoveGraphicVerticeEdit(mapLayoutUndoRedo, this, lg, this._editingVerticeIndex, pageP.x, pageP.y);
                    this.fireUndoEditEvent(edit);
                    lg.verticeEditUpdate(this._editingVerticeIndex, pageP.x, pageP.y);
                    this._mouseMode = MouseMode.EditVertices;
                    this.paintGraphics();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void onMouseClicked(MouseEvent e) throws CloneNotSupportedException {
        int clickTimes = e.getClickCount();
        if (clickTimes == 1) {
            Point pageP = this.screenToPage(e.getX(), e.getY());
            if (e.getButton() == 1) {
                switch (this._mouseMode) {
                    case Map_Identifer: {
                        MapLayer aMLayer = this._currentLayoutMap.getMapFrame().getMapView().getSelectedLayer();
                        if (aMLayer == null) {
                            return;
                        }
                        if (aMLayer.getLayerType() == LayerTypes.ImageLayer) {
                            return;
                        }
                        PointF mapP = this.pageToScreen(this._currentLayoutMap.getLeft(), this._currentLayoutMap.getTop());
                        PointF aPoint = new PointF((float)e.getX() - mapP.X, (float)e.getY() - mapP.Y);
                        if (aMLayer.getLayerType() == LayerTypes.VectorLayer) {
                            VectorLayer aLayer = (VectorLayer)aMLayer;
                            List<Integer> selectedShapes = this._currentLayoutMap.getMapFrame().getMapView().selectShapes(aLayer, aPoint);
                            if (selectedShapes.size() <= 0) return;
                            if (this._frmIdentifer == null) {
                                this._frmIdentifer = new FrmIdentifer((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false, this._currentLayoutMap.getMapFrame().getMapView());
                                this._frmIdentifer.addWindowListener(new WindowAdapter(){

                                    @Override
                                    public void windowClosed(WindowEvent e) {
                                        MapLayout.this._currentLayoutMap.getMapFrame().getMapView().setDrawIdentiferShape(false);
                                        MapLayout.this.repaint();
                                    }
                                });
                            }
                            this._frmIdentifer.setMapView(this._currentLayoutMap.getMapFrame().getMapView());
                            Object[] colNames = new String[]{"Field", "Value"};
                            int shapeIdx = selectedShapes.get(0);
                            aLayer.setIdentiferShape(shapeIdx);
                            this._currentLayoutMap.getMapFrame().getMapView().setDrawIdentiferShape(true);
                            Object[][] tData = new Object[aLayer.getFieldNumber() + 1][2];
                            String fieldStr = "Index";
                            String valueStr = String.valueOf(shapeIdx);
                            tData[0][0] = fieldStr;
                            tData[0][1] = valueStr;
                            if (aLayer.getShapeNum() > 0) {
                                for (int i = 0; i < aLayer.getFieldNumber(); ++i) {
                                    fieldStr = aLayer.getFieldName(i);
                                    valueStr = aLayer.getCellValue(i, shapeIdx).toString();
                                    tData[i + 1][0] = fieldStr;
                                    tData[i + 1][1] = valueStr;
                                }
                            }
                            DefaultTableModel dtm = new DefaultTableModel(tData, colNames){

                                @Override
                                public boolean isCellEditable(int row, int column) {
                                    return false;
                                }
                            };
                            this._frmIdentifer.getTable().setModel(dtm);
                            this._frmIdentifer.repaint();
                            if (!this._frmIdentifer.isVisible()) {
                                this._frmIdentifer.setLocation(e.getX(), e.getY());
                                this._frmIdentifer.setVisible(true);
                            }
                            this.repaint();
                            return;
                        }
                        if (aMLayer.getLayerType() != LayerTypes.RasterLayer) return;
                        RasterLayer aRLayer = (RasterLayer)aMLayer;
                        int[] ijIdx = this._currentLayoutMap.getMapFrame().getMapView().selectGridCell(aRLayer, aPoint);
                        if (ijIdx == null) return;
                        int iIdx = ijIdx[0];
                        int jIdx = ijIdx[1];
                        double aValue = aRLayer.getCellValue(iIdx, jIdx);
                        if (this._frmIdentiferGrid == null) {
                            this._frmIdentiferGrid = new FrmIdentiferGrid((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false);
                        }
                        this._frmIdentiferGrid.setIIndex(iIdx);
                        this._frmIdentiferGrid.setJIndex(jIdx);
                        this._frmIdentiferGrid.setCellValue(aValue);
                        if (this._frmIdentiferGrid.isVisible()) return;
                        this._frmIdentiferGrid.setLocationRelativeTo(this);
                        this._frmIdentiferGrid.setVisible(true);
                    }
                }
                return;
            } else {
                if (e.getButton() != 3 || this._mouseMode != MouseMode.Select) return;
                if (this._selectedElements.isEmpty()) {
                    return;
                }
                JPopupMenu jPopupMenu_Element = new JPopupMenu();
                JMenu jMenu_Order = new JMenu("Order");
                jPopupMenu_Element.add(jMenu_Order);
                JMenuItem jMenuItem_BTF = new JMenuItem("Bring to Front");
                jMenuItem_BTF.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MapLayout.this.onBringToFrontClick(e);
                    }
                });
                jMenu_Order.add(jMenuItem_BTF);
                JMenuItem jMenuItem_STB = new JMenuItem("Send to Back");
                jMenuItem_STB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MapLayout.this.onSendToBackClick(e);
                    }
                });
                jMenu_Order.add(jMenuItem_STB);
                JMenuItem jMenuItem_BF = new JMenuItem("Bring Forward");
                jMenuItem_BF.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MapLayout.this.onBringForwardClick(e);
                    }
                });
                jMenu_Order.add(jMenuItem_BF);
                JMenuItem jMenuItem_SB = new JMenuItem("Send Backward");
                jMenuItem_SB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MapLayout.this.onSendBackwardClick(e);
                    }
                });
                jMenu_Order.add(jMenuItem_SB);
                jPopupMenu_Element.add(new JSeparator());
                JMenuItem jMenuItem_Remove = new JMenuItem("Remove");
                jMenuItem_Remove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MapLayout.this.onRemoveElementClick(e);
                    }
                });
                jPopupMenu_Element.add(jMenuItem_Remove);
                switch (this._mouseMode) {
                    case Select: 
                    case MoveSelection: 
                    case ResizeSelected: {
                        Graphic aGraphic;
                        LayoutElement aElement;
                        if (this._selectedElements.size() <= 0 || !MIMath.pointInRectangle(pageP, (aElement = this._selectedElements.get(0)).getBounds()) || aElement.getElementType() != ElementType.LayoutGraphic || (aGraphic = ((LayoutGraphic)aElement).getGraphic()).getLegend().getBreakType() != BreakTypes.PolylineBreak && aGraphic.getLegend().getBreakType() != BreakTypes.PolygonBreak) break;
                        JMenuItem jMenuItem_Reverse = new JMenuItem("Reverse");
                        jMenuItem_Reverse.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                MapLayout.this.onReverseGraphicClick(e);
                            }
                        });
                        jPopupMenu_Element.add(jMenuItem_Reverse);
                        if (aGraphic.getShape().getShapeType() == ShapeTypes.Polyline || aGraphic.getShape().getShapeType() == ShapeTypes.Polygon) {
                            jPopupMenu_Element.add(new JSeparator());
                            JMenuItem jMenuItem_Smooth = new JMenuItem("Smooth Graphic");
                            jMenuItem_Smooth.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MapLayout.this.onGraphicSmoothClick(e);
                                }
                            });
                            jPopupMenu_Element.add(jMenuItem_Smooth);
                        }
                        if (aGraphic.getShape().getShapeType() != ShapeTypes.Ellipse) break;
                        JMenuItem jMenuItem_Angle = new JMenuItem("Set Angle");
                        jMenuItem_Angle.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                MapLayout.this.onGraphicAngleClick(e);
                            }
                        });
                        jPopupMenu_Element.add(jMenuItem_Angle);
                    }
                }
                jPopupMenu_Element.show(this, e.getX(), e.getY());
            }
            return;
        } else {
            if (clickTimes != 2) return;
            Point pageP = this.screenToPage(e.getX(), e.getY());
            switch (this._mouseMode) {
                case Select: 
                case MoveSelection: 
                case ResizeSelected: {
                    if (this._selectedElements.isEmpty()) {
                        return;
                    }
                    LayoutElement aElement = this._selectedElements.get(0);
                    this._selectedElements = this.selectElements(pageP, this._layoutElements, 0);
                    if (this._selectedElements.size() > 1) {
                        aElement.setSelected(false);
                        int idx = this._selectedElements.indexOf(aElement);
                        if ((idx += 2) > this._selectedElements.size() - 1) {
                            idx -= this._selectedElements.size();
                        }
                        aElement = this._selectedElements.get(idx);
                        this._selectedElements.clear();
                        this._selectedElements.add(aElement);
                        this._selectedElements.get(0).setSelected(true);
                    }
                    this.paintGraphics();
                    if (aElement.getElementType() == ElementType.LayoutGraphic) {
                        Graphic aGraphic = ((LayoutGraphic)aElement).getGraphic();
                        this.showSymbolSetForm(aGraphic);
                    } else {
                        FrmProperty aFrmProperty = new FrmProperty((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), true, false);
                        Object object = aElement;
                        switch (aElement.getElementType()) {
                            case LayoutLegend: {
                                object = (LayoutLegend)aElement.new LayoutLegend.LayoutLegendBean();
                                break;
                            }
                            case LayoutMap: {
                                object = (LayoutMap)aElement.new LayoutMap.LayoutMapBean();
                                break;
                            }
                            case LayoutNorthArraw: {
                                object = (LayoutNorthArrow)aElement.new LayoutNorthArrow.LayoutNorthArrowBean();
                                break;
                            }
                            case LayoutScaleBar: {
                                object = new LayoutScaleBar.LayoutScaleBarBean((LayoutScaleBar)aElement);
                            }
                        }
                        aFrmProperty.setObject(object);
                        aFrmProperty.setParent(this);
                        aFrmProperty.setLocationRelativeTo(this);
                        aFrmProperty.setVisible(true);
                    }
                    this.setMouseMode(MouseMode.Select);
                    this.fireElementSelectedEvent();
                    return;
                }
                case New_Polyline: 
                case New_Polygon: 
                case New_Curve: 
                case New_CurvePolygon: 
                case New_Freehand: 
                case Map_SelectFeatures_Polygon: {
                    if (this._startNewGraphic) return;
                    this._startNewGraphic = true;
                    this._graphicPoints.remove(this._graphicPoints.size() - 1);
                    if (this._mouseMode == MouseMode.Map_SelectFeatures_Polygon) {
                        PointF mapP = this.pageToScreen(this._currentLayoutMap.getLeft(), this._currentLayoutMap.getTop());
                        ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
                        MapView currentMapView = this._currentLayoutMap.getMapFrame().getMapView();
                        for (PointF aPoint : this._graphicPoints) {
                            float[] pXY = currentMapView.screenToProj(aPoint.X - mapP.X, aPoint.Y - mapP.Y);
                            points.add(new org.meteoinfo.global.PointD(pXY[0], pXY[1]));
                        }
                        MapLayer aMLayer = this._currentLayoutMap.getMapFrame().getMapView().getSelectedLayer();
                        if (aMLayer == null) {
                            return;
                        }
                        if (aMLayer.getLayerType() != LayerTypes.VectorLayer) {
                            return;
                        }
                        PolygonShape aPGS = new PolygonShape();
                        points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                        aPGS.setPoints(points);
                        VectorLayer aLayer = (VectorLayer)aMLayer;
                        if (!e.isControlDown() && !e.isShiftDown()) {
                            aLayer.clearSelectedShapes();
                        }
                        aLayer.selectShapes(aPGS);
                        this._currentLayoutMap.getMapFrame().getMapView().fireShapeSelectedEvent();
                        return;
                    }
                    ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
                    for (PointF aPoint : this._graphicPoints) {
                        PointF bPoint = this.screenToPage(aPoint.X, aPoint.Y);
                        points.add(new org.meteoinfo.global.PointD(bPoint.X, bPoint.Y));
                    }
                    Graphic aGraphic = null;
                    switch (this._mouseMode) {
                        case New_Polyline: 
                        case New_Freehand: {
                            PolylineShape aPLS = new PolylineShape();
                            aPLS.setPoints(points);
                            aGraphic = new Graphic(aPLS, (PolylineBreak)this._defPolylineBreak.clone());
                            break;
                        }
                        case New_Polygon: {
                            if (points.size() <= 2) break;
                            PolygonShape aPGS = new PolygonShape();
                            points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                            aPGS.setPoints(points);
                            aGraphic = new Graphic(aPGS, (PolygonBreak)this._defPolygonBreak.clone());
                            break;
                        }
                        case New_Curve: {
                            CurveLineShape aCLS = new CurveLineShape();
                            aCLS.setPoints(points);
                            aGraphic = new Graphic(aCLS, (PolylineBreak)this._defPolylineBreak.clone());
                            break;
                        }
                        case New_CurvePolygon: {
                            if (points.size() <= 2) break;
                            CurvePolygonShape aCPS = new CurvePolygonShape();
                            points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                            aCPS.setPoints(points);
                            aGraphic = new Graphic(aCPS, (PolygonBreak)this._defPolygonBreak.clone());
                        }
                    }
                    if (aGraphic != null) {
                        LayoutGraphic lg = new LayoutGraphic(aGraphic, this);
                        this.addElement(lg);
                        this.paintGraphics();
                        MapLayoutUndoRedo mapLayoutUndoRedo = new MapLayoutUndoRedo();
                        Objects.requireNonNull(mapLayoutUndoRedo);
                        MapLayoutUndoRedo.AddElementEdit edit = new MapLayoutUndoRedo.AddElementEdit(mapLayoutUndoRedo, this, lg);
                        this.fireUndoEditEvent(edit);
                        return;
                    }
                    this.repaint();
                }
            }
        }
    }

    private void onRemoveElementClick(ActionEvent e) {
        this.onRemoveElementClick();
    }

    private void onBringToFrontClick(ActionEvent e) {
        LayoutElement aLE = this._selectedElements.get(0);
        int idx = this._layoutElements.indexOf(aLE);
        if (idx < this._layoutElements.size() - 1) {
            this._layoutElements.remove(aLE);
            this._layoutElements.add(aLE);
            this.paintGraphics();
        }
    }

    private void onSendToBackClick(ActionEvent e) {
        LayoutElement aLE = this._selectedElements.get(0);
        int idx = this._layoutElements.indexOf(aLE);
        if (idx > 0) {
            this._layoutElements.remove(aLE);
            this._layoutElements.add(0, aLE);
            this.paintGraphics();
        }
    }

    private void onBringForwardClick(ActionEvent e) {
        LayoutElement aLE = this._selectedElements.get(0);
        int idx = this._layoutElements.indexOf(aLE);
        if (idx < this._layoutElements.size() - 1) {
            this._layoutElements.remove(aLE);
            this._layoutElements.add(idx + 1, aLE);
            this.paintGraphics();
        }
    }

    private void onSendBackwardClick(ActionEvent e) {
        LayoutElement aLE = this._selectedElements.get(0);
        int idx = this._layoutElements.indexOf(aLE);
        if (idx > 0) {
            this._layoutElements.remove(aLE);
            this._layoutElements.add(idx - 1, aLE);
            this.paintGraphics();
        }
    }

    private void onReverseGraphicClick(ActionEvent e) {
        LayoutElement aElement = this._selectedElements.get(0);
        Graphic aGraphic = ((LayoutGraphic)aElement).getGraphic();
        List<? extends org.meteoinfo.global.PointD> points = aGraphic.getShape().getPoints();
        Collections.reverse(points);
        aGraphic.getShape().setPoints(points);
        this.paintGraphics();
    }

    private void onGraphicSmoothClick(ActionEvent e) {
        LayoutElement aElement = this._selectedElements.get(0);
        Graphic aGraphic = ((LayoutGraphic)aElement).getGraphic();
        List pointList = new ArrayList<Object>();
        ArrayList<org.meteoinfo.global.PointD> newPoints = new ArrayList<org.meteoinfo.global.PointD>();
        for (org.meteoinfo.global.PointD pointD : aGraphic.getShape().getPoints()) {
            pointList.add(new PointD(pointD.X, pointD.Y));
        }
        if (aGraphic.getShape().getShapeType() == ShapeTypes.Polygon) {
            pointList.add(pointList.get(0));
        }
        pointList = Contour.smoothPoints(pointList);
        for (PointD pointD : pointList) {
            newPoints.add(new org.meteoinfo.global.PointD(pointD.X, pointD.Y));
        }
        aGraphic.getShape().setPoints(newPoints);
        ((LayoutGraphic)aElement).updateControlSize();
        this.paintGraphics();
    }

    private void onGraphicAngleClick(ActionEvent e) {
        LayoutElement aElement = this._selectedElements.get(0);
        Graphic aGraphic = ((LayoutGraphic)aElement).getGraphic();
        EllipseShape es = (EllipseShape)aGraphic.getShape();
        String angleStr = JOptionPane.showInputDialog(this, "Ellipse angle:", Float.valueOf(es.getAngle()));
        if (angleStr != null) {
            es.setAngle(Float.parseFloat(angleStr));
            this.paintGraphics();
        }
    }

    private void showSymbolSetForm(ColorBreak aCB) {
        switch (aCB.getBreakType()) {
            case PointBreak: {
                PointBreak aPB = (PointBreak)aCB;
                if (this._frmPointSymbolSet == null) {
                    this._frmPointSymbolSet = new FrmPointSymbolSet((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false, (Object)this);
                    this._frmPointSymbolSet.setLocationRelativeTo(this);
                    this._frmPointSymbolSet.setVisible(true);
                }
                this._frmPointSymbolSet.setPointBreak(aPB);
                this._frmPointSymbolSet.setVisible(true);
                break;
            }
            case LabelBreak: {
                LabelBreak aLB = (LabelBreak)aCB;
                if (this._frmLabelSymbolSet == null) {
                    this._frmLabelSymbolSet = new FrmLabelSymbolSet((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false, this);
                    this._frmLabelSymbolSet.setLocationRelativeTo(this);
                    this._frmLabelSymbolSet.setVisible(true);
                }
                this._frmLabelSymbolSet.setLabelBreak(aLB);
                this._frmLabelSymbolSet.setVisible(true);
                break;
            }
            case PolylineBreak: {
                PolylineBreak aPLB = (PolylineBreak)aCB;
                if (this._frmPolylineSymbolSet == null) {
                    this._frmPolylineSymbolSet = new FrmPolylineSymbolSet((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false, (Object)this);
                    this._frmPolylineSymbolSet.setLocationRelativeTo(this);
                    this._frmPolylineSymbolSet.setVisible(true);
                }
                this._frmPolylineSymbolSet.setPolylineBreak(aPLB);
                this._frmPolylineSymbolSet.setVisible(true);
                break;
            }
            case PolygonBreak: {
                PolygonBreak aPGB = (PolygonBreak)aCB;
                if (this._frmPolygonSymbolSet == null) {
                    this._frmPolygonSymbolSet = new FrmPolygonSymbolSet((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false, (Object)this);
                    this._frmPolygonSymbolSet.setLocationRelativeTo(this);
                    this._frmPolygonSymbolSet.setVisible(true);
                }
                this._frmPolygonSymbolSet.setPolygonBreak(aPGB);
                this._frmPolygonSymbolSet.setVisible(true);
            }
        }
    }

    private void showSymbolSetForm(Graphic graphic) {
        Shape shape = graphic.getShape();
        ColorBreak aCB = graphic.getLegend();
        switch (aCB.getBreakType()) {
            case PointBreak: {
                PointBreak aPB = (PointBreak)aCB;
                if (this._frmPointSymbolSet == null) {
                    this._frmPointSymbolSet = new FrmPointSymbolSet((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false, (Object)this);
                    this._frmPointSymbolSet.setLocationRelativeTo(this);
                    this._frmPointSymbolSet.setVisible(true);
                }
                this._frmPointSymbolSet.setPointBreak(aPB);
                this._frmPointSymbolSet.setVisible(true);
                break;
            }
            case LabelBreak: {
                LabelBreak aLB = (LabelBreak)aCB;
                if (this._frmLabelSymbolSet == null) {
                    this._frmLabelSymbolSet = new FrmLabelSymbolSet((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false, this);
                    this._frmLabelSymbolSet.setLocationRelativeTo(this);
                    this._frmLabelSymbolSet.setVisible(true);
                }
                this._frmLabelSymbolSet.setLabelBreak(aLB);
                this._frmLabelSymbolSet.setVisible(true);
                break;
            }
            case PolylineBreak: {
                PolylineBreak aPLB = (PolylineBreak)aCB;
                if (this._frmPolylineSymbolSet == null) {
                    this._frmPolylineSymbolSet = new FrmPolylineSymbolSet((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false, (Object)this);
                    this._frmPolylineSymbolSet.setLocationRelativeTo(this);
                    this._frmPolylineSymbolSet.setVisible(true);
                }
                this._frmPolylineSymbolSet.setPolylineBreak(aPLB);
                this._frmPolylineSymbolSet.setVisible(true);
                break;
            }
            case PolygonBreak: {
                PolygonBreak aPGB = (PolygonBreak)aCB;
                if (this._frmPolygonSymbolSet == null) {
                    this._frmPolygonSymbolSet = new FrmPolygonSymbolSet((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false, (Object)this);
                    this._frmPolygonSymbolSet.setLocationRelativeTo(this);
                    this._frmPolygonSymbolSet.setVisible(true);
                }
                this._frmPolygonSymbolSet.setPolygonBreak(aPGB);
                this._frmPolygonSymbolSet.setVisible(true);
                break;
            }
            case VectorBreak: {
                WindArrow wa = (WindArrow)shape;
                Object[] lens = new Object[]{5, 10, 15, 20, 25, 30};
                Object lenObj = JOptionPane.showInputDialog((JFrame)SwingUtilities.getWindowAncestor(this), "Select wind speed:", "Selection", -1, null, lens, (int)wa.length);
                if (lenObj == null) break;
                wa.length = Integer.parseInt(lenObj.toString());
                this.paintGraphics();
            }
        }
    }

    void onKeyPressed(KeyEvent e) {
        if (this._mouseMode == MouseMode.Select) {
            switch (e.getKeyCode()) {
                case 127: {
                    this.onRemoveElementClick();
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    int x = 0;
                    int y = 0;
                    int d = 5;
                    if (e.isControlDown()) {
                        d = 1;
                    }
                    switch (e.getKeyCode()) {
                        case 37: {
                            x = -d;
                            break;
                        }
                        case 39: {
                            x = d;
                            break;
                        }
                        case 38: {
                            y = -d;
                            break;
                        }
                        case 40: {
                            y = d;
                        }
                    }
                    for (int i = 0; i < this._layoutElements.size(); ++i) {
                        LayoutElement aElement = this._layoutElements.get(i);
                        if (!aElement.isSelected()) continue;
                        if (x != 0) {
                            aElement.setLeft(aElement.getLeft() + x);
                        }
                        if (y != 0) {
                            aElement.setTop(aElement.getTop() + y);
                        }
                        aElement.moveUpdate();
                    }
                    this.paintGraphics();
                }
            }
        }
    }

    private void onRemoveElementClick() {
        MapLayoutUndoRedo mapLayoutUndoRedo = new MapLayoutUndoRedo();
        Objects.requireNonNull(mapLayoutUndoRedo);
        MapLayoutUndoRedo.RemoveElementsEdit edit = new MapLayoutUndoRedo.RemoveElementsEdit(mapLayoutUndoRedo, this, this._selectedElements);
        this.fireUndoEditEvent(edit);
        for (LayoutElement element : this._selectedElements) {
            this.removeElement(element);
        }
        this._selectedElements.clear();
        this._startNewGraphic = true;
        this.paintGraphics();
    }

    public boolean isLockViewUpdate() {
        return this._lockViewUpdate;
    }

    public void setLockViewUpdate(boolean istrue) {
        this._lockViewUpdate = istrue;
    }

    public List<MapFrame> getMapFrames() {
        return this._mapFrames;
    }

    public void setMapFrames(List<MapFrame> mfs) {
        this._mapFrames = mfs;
        this._mapFrames = new ArrayList<MapFrame>();
        for (MapFrame mf : mfs) {
            boolean isInsert = false;
            for (int i = 0; i < this._mapFrames.size(); ++i) {
                MapFrame amf = this._mapFrames.get(i);
                if (mf.getOrder() >= amf.getOrder()) continue;
                this._mapFrames.add(i, mf);
                isInsert = true;
                break;
            }
            if (isInsert) continue;
            this._mapFrames.add(mf);
        }
    }

    public MapFrame getActiveMapFrame() {
        for (MapFrame mf : this._mapFrames) {
            if (!mf.isActive()) continue;
            return mf;
        }
        return null;
    }

    public LayoutMap getActiveLayoutMap() {
        LayoutMap aLM = null;
        for (LayoutMap lm : this.getLayoutMaps()) {
            if (!lm.getMapFrame().isActive()) continue;
            aLM = lm;
            break;
        }
        return aLM;
    }

    public boolean isLandscape() {
        return this._isLandscape;
    }

    public void setLandscape(boolean istrue) {
        this._isLandscape = istrue;
        Rectangle2D.Float aRect = this.paperToScreen(new Rectangle2D.Float(0.0f, 0.0f, this.getPaperWidth(), this.getPaperHeight()));
        this._pageBounds.width = (int)aRect.width;
        this._pageBounds.height = (int)aRect.height;
    }

    public MouseMode getMouseMode() {
        return this._mouseMode;
    }

    public void setMouseMode(MouseMode mm) {
        this._mouseMode = mm;
        switch (this._mouseMode) {
            case New_Point: 
            case New_Label: 
            case New_Polyline: 
            case New_Polygon: 
            case New_Curve: 
            case New_CurvePolygon: 
            case New_Freehand: 
            case New_Rectangle: 
            case New_Ellipse: 
            case New_Circle: {
                this.setCursor(Cursor.getPredefinedCursor(1));
                break;
            }
            case Map_Measurement: {
                this.setCursor(Cursor.getPredefinedCursor(1));
                break;
            }
            case Map_SelectFeatures_Polygon: 
            case Map_SelectFeatures_Lasso: 
            case Map_SelectFeatures_Rectangle: 
            case Map_SelectFeatures_Circle: {
                this.setCursor(Cursor.getPredefinedCursor(1));
                this._tempImage = GlobalUtil.deepCopy(this._layoutBitmap);
            }
        }
    }

    public boolean isAntiAlias() {
        return this._antiAlias;
    }

    public void setAntiAlias(boolean istrue) {
        this._antiAlias = istrue;
    }

    public Color getPageForeColor() {
        return this._pageForeColor;
    }

    public void setPageForeColor(Color c) {
        this._pageForeColor = c;
    }

    public Color getPageBackColor() {
        return this._pageBackColor;
    }

    public void setPageBackColor(Color c) {
        this._pageBackColor = c;
        if (c == Color.black) {
            this._pageForeColor = Color.white;
        } else if (c == Color.white) {
            this._pageForeColor = Color.black;
        }
    }

    public PaperSize getPaperSize() {
        return this._paperSize;
    }

    public void setPaperSize(PaperSize ps) {
        this._paperSize = ps;
        Rectangle2D.Float aRect = this.paperToScreen(new Rectangle2D.Float(0.0f, 0.0f, this.getPaperWidth(), this.getPaperHeight()));
        this._pageBounds.width = (int)aRect.width;
        this._pageBounds.height = (int)aRect.height;
    }

    public void setPaperSize(int width, int height) {
        PaperSize ps = new PaperSize("Custom", width, height);
        this.setPaperSize(ps);
    }

    private int getPaperWidth() {
        if (this._isLandscape) {
            return this._paperSize.getHeight();
        }
        return this._paperSize.getWidth();
    }

    private int getPaperHeight() {
        if (this._isLandscape) {
            return this._paperSize.getWidth();
        }
        return this._paperSize.getHeight();
    }

    public List<LayoutMap> getLayoutMaps() {
        ArrayList<LayoutMap> layoutMaps = new ArrayList<LayoutMap>();
        for (LayoutElement aLE : this._layoutElements) {
            if (aLE.getElementType() != ElementType.LayoutMap) continue;
            layoutMaps.add((LayoutMap)aLE);
        }
        return layoutMaps;
    }

    public List<LayoutElement> getSelectedElements() {
        return this._selectedElements;
    }

    public java.awt.Rectangle getPageBounds() {
        return this._pageBounds;
    }

    public void setPageBounds(java.awt.Rectangle pb) {
        this._pageBounds = pb;
    }

    public PointF getPageLocation() {
        return this._pageLocation;
    }

    public void setPageLocation(PointF p) {
        this._pageLocation = p;
    }

    public float getZoom() {
        return this._zoom;
    }

    public void setZoom(float zoom) {
        this._zoom = zoom;
        this.fireZoomChangedEvent();
    }

    public PointBreak getDefPointBreak() {
        return this._defPointBreak;
    }

    public void setDefPointBreak(PointBreak pb) {
        this._defPointBreak = pb;
    }

    public LabelBreak getDefLabelBreak() {
        return this._defLabelBreak;
    }

    public void setDefLabelBreak(LabelBreak lb) {
        this._defLabelBreak = lb;
    }

    public PolylineBreak getDefPolylineBreak() {
        return this._defPolylineBreak;
    }

    public void setDefPolylineBreak(PolylineBreak pb) {
        this._defPolylineBreak = pb;
    }

    public PolygonBreak getDefPolygonBreak() {
        return this._defPolygonBreak;
    }

    public void setDefPolygonBreak(PolygonBreak pb) {
        this._defPolygonBreak = pb;
    }

    public FrmMeasurement getMeasurementForm() {
        return this._frmMeasure;
    }

    public void setMeasurementForm(FrmMeasurement form) {
        this._frmMeasure = form;
    }

    public BufferedImage getViewImage() {
        BufferedImage aImage = new BufferedImage(this._pageBounds.width, this._pageBounds.height, 2);
        Graphics2D g = aImage.createGraphics();
        this.paintGraphics(g);
        return aImage;
    }

    @Override
    public int getWebMapZoom() {
        WebMapLayer layer = this.getActiveMapFrame().getMapView().getWebMapLayer();
        if (layer != null) {
            return layer.getZoom();
        }
        return 0;
    }

    @Override
    public void reDraw() {
        this.paintGraphics();
    }

    @Override
    public void paintComponent(Graphics g) {
        MapLayer aLayer;
        int selLayerHandle;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.getBackground());
        g2.clearRect(0, 0, this.getWidth(), this.getHeight());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        AffineTransform mx = new AffineTransform();
        mx.translate(this._xShift, this._yShift);
        AffineTransformOp aop = new AffineTransformOp(mx, 2);
        g2.drawImage(this._layoutBitmap, aop, 0, 0);
        if (this._dragMode) {
            java.awt.Rectangle rect = new java.awt.Rectangle();
            float[] dash1 = new float[]{2.0f};
            switch (this._mouseMode) {
                case Map_ZoomIn: {
                    rect.width = Math.abs(this._mouseLastPos.x - this._mouseDownPoint.x);
                    rect.height = Math.abs(this._mouseLastPos.y - this._mouseDownPoint.y);
                    rect.x = Math.min(this._mouseLastPos.x, this._mouseDownPoint.x);
                    rect.y = Math.min(this._mouseLastPos.y, this._mouseDownPoint.y);
                    g2.setColor(Color.black);
                    g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f));
                    g2.draw(rect);
                    break;
                }
                case MoveSelection: {
                    rect.x = this._selectedRectangle.x + this._mouseLastPos.x - this._mouseDownPoint.x;
                    rect.y = this._selectedRectangle.y + this._mouseLastPos.y - this._mouseDownPoint.y;
                    rect.width = this._selectedRectangle.width;
                    rect.height = this._selectedRectangle.height;
                    g2.setColor(Color.red);
                    g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f));
                    g2.draw(rect);
                    break;
                }
                case ResizeSelected: {
                    g2.setColor(Color.red);
                    g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f));
                    g2.draw(this._selectedRectangle);
                    break;
                }
                case Map_SelectFeatures_Rectangle: 
                case New_Rectangle: 
                case New_Ellipse: 
                case CreateSelection: {
                    int sx = Math.min(this._mouseDownPoint.x, this._mouseLastPos.x);
                    int sy = Math.min(this._mouseDownPoint.y, this._mouseLastPos.y);
                    g2.setColor(this.getForeground());
                    g2.draw(new java.awt.Rectangle(sx, sy, Math.abs(this._mouseLastPos.x - this._mouseDownPoint.x), Math.abs(this._mouseLastPos.y - this._mouseDownPoint.y)));
                    break;
                }
                case New_Freehand: 
                case Map_SelectFeatures_Lasso: {
                    ArrayList<PointF> points = new ArrayList<PointF>(this._graphicPoints);
                    points.add(new PointF(this._mouseLastPos.x, this._mouseLastPos.y));
                    g2.setColor(this.getForeground());
                    this._graphicPoints.add(new PointF(this._mouseLastPos.x, this._mouseLastPos.y));
                    Draw.drawPolyline(points, g2);
                    break;
                }
                case New_Circle: 
                case Map_SelectFeatures_Circle: {
                    int radius = (int)Math.sqrt(Math.pow(this._mouseLastPos.x - this._mouseDownPoint.x, 2.0) + Math.pow(this._mouseLastPos.y - this._mouseDownPoint.y, 2.0));
                    g2.setColor(this.getForeground());
                    g2.drawLine(this._mouseDownPoint.x, this._mouseDownPoint.y, this._mouseLastPos.x, this._mouseLastPos.y);
                    g2.drawOval(this._mouseDownPoint.x - radius, this._mouseDownPoint.y - radius, radius * 2, radius * 2);
                    break;
                }
                case InEditingVertices: {
                    PointF p1 = this.pageToScreen((float)this._editingVertices.get((int)1).X, (float)this._editingVertices.get((int)1).Y);
                    PointF p2 = this.pageToScreen((float)this._editingVertices.get((int)2).X, (float)this._editingVertices.get((int)2).Y);
                    g2.setColor(Color.black);
                    g2.drawLine((int)p1.X, (int)p1.Y, this._mouseLastPos.x, this._mouseLastPos.y);
                    if (this._editingVertices.size() == 3) {
                        g2.drawLine((int)p2.X, (int)p2.Y, this._mouseLastPos.x, this._mouseLastPos.y);
                    }
                    java.awt.Rectangle nRect = new java.awt.Rectangle(this._mouseLastPos.x - 3, this._mouseLastPos.y - 3, 6, 6);
                    g2.setColor(Color.cyan);
                    g2.fill(nRect);
                    g2.setColor(Color.black);
                    g2.draw(nRect);
                }
            }
        }
        switch (this._mouseMode) {
            case New_Polyline: 
            case New_Polygon: 
            case New_Curve: 
            case New_CurvePolygon: 
            case Map_SelectFeatures_Polygon: {
                if (this._startNewGraphic) break;
                ArrayList<PointF> points = new ArrayList<PointF>(this._graphicPoints);
                points.add(new PointF(this._mouseLastPos.x, this._mouseLastPos.y));
                g2.setColor(this.getForeground());
                switch (this._mouseMode) {
                    case New_Polyline: {
                        Draw.drawPolyline(points, g2);
                        break;
                    }
                    case New_Polygon: {
                        points.add((PointF)points.get(0));
                        Draw.drawPolyline(points, g2);
                        break;
                    }
                    case New_Curve: {
                        Draw.drawCurveLine(points, g2);
                        break;
                    }
                    case New_CurvePolygon: {
                        points.add((PointF)points.get(0));
                        Draw.drawCurveLine(points, g2);
                    }
                }
                break;
            }
            case Map_Measurement: {
                if (this._startNewGraphic) break;
                PointF[] fpoints = this._graphicPoints.toArray(new PointF[this._graphicPoints.size()]);
                PointF[] points = new PointF[fpoints.length + 1];
                System.arraycopy(fpoints, 0, points, 0, fpoints.length);
                points[this._graphicPoints.size()] = new PointF(this._mouseLastPos.x, this._mouseLastPos.y);
                if (this._frmMeasure.getMeasureType() == FrmMeasurement.MeasureTypes.Length) {
                    g2.setColor(Color.red);
                    g2.setStroke(new BasicStroke(2.0f));
                    Draw.drawPolyline(points, g2);
                    break;
                }
                PointF[] ppoints = new PointF[points.length + 1];
                System.arraycopy(points, 0, ppoints, 0, points.length);
                ppoints[ppoints.length - 1] = this._graphicPoints.get(0);
                Color aColor = new Color(Color.blue.getRed(), Color.blue.getGreen(), Color.blue.getBlue(), 100);
                g2.setColor(aColor);
                PolygonBreak aPB = new PolygonBreak();
                aPB.setColor(aColor);
                Draw.drawPolygon(ppoints, aPB, g2);
                g2.setColor(Color.red);
                Draw.drawPolyline(ppoints, g2);
            }
        }
        if (this._currentLayoutMap != null && this._currentLayoutMap.getMapFrame().getMapView().isDrawIdentiferShape() && (selLayerHandle = this._currentLayoutMap.getMapFrame().getMapView().getSelectedLayerHandle()) >= 0 && (aLayer = this._currentLayoutMap.getMapFrame().getMapView().getLayerByHandle(selLayerHandle)).getLayerType() == LayerTypes.VectorLayer) {
            VectorLayer vLayer = (VectorLayer)aLayer;
            java.awt.Rectangle rect = this.getElementViewExtent(this._currentLayoutMap);
            this._currentLayoutMap.getMapFrame().getMapView().drawIdShape(g2, vLayer.getShapes().get(vLayer.getIdentiferShape()), rect);
        }
    }

    public void paintGraphics() {
        if (this._lockViewUpdate) {
            return;
        }
        if (this.getWidth() < 10 || this.getHeight() < 10) {
            return;
        }
        if (this._pageBounds.width < 2 || this._pageBounds.height < 2) {
            return;
        }
        this._layoutBitmap = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D g = this._layoutBitmap.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int pageHeight = (int)((float)this._pageBounds.height * this._zoom);
        int pageWidth = (int)((float)this._pageBounds.width * this._zoom);
        if (pageHeight > this.getHeight()) {
            int sHeight = pageHeight - this.getHeight() + 40;
            this._vScrollBar.setMinimum(0);
            this._vScrollBar.setMaximum(pageHeight);
            this._vScrollBar.setVisibleAmount(pageHeight - sHeight);
            this._vScrollBar.setUnitIncrement(pageHeight / 10);
            this._vScrollBar.setBlockIncrement(pageHeight / 5);
            if (this._vScrollBar.getWidth() == 0) {
                this._vScrollBar.setSize(21, this._vScrollBar.getHeight());
            }
            if (!this._vScrollBar.isVisible()) {
                this._vScrollBar.setValue(0);
                this._vScrollBar.setVisible(true);
            }
        } else {
            this._pageBounds.y = 0;
            this._pageLocation.Y = 0.0f;
            this._vScrollBar.setVisible(false);
        }
        if (pageWidth > this.getWidth()) {
            int sWidth = pageWidth - this.getWidth() + 40;
            this._hScrollBar.setMinimum(0);
            this._hScrollBar.setMaximum(pageWidth);
            this._hScrollBar.setVisibleAmount(pageWidth - sWidth);
            this._hScrollBar.setUnitIncrement(pageWidth / 10);
            this._hScrollBar.setBlockIncrement(pageWidth / 5);
            if (this._hScrollBar.getHeight() == 0) {
                this._hScrollBar.setSize(this._hScrollBar.getWidth(), 21);
            }
            if (!this._hScrollBar.isVisible()) {
                this._hScrollBar.setValue(0);
                this._hScrollBar.setVisible(true);
            }
        } else {
            this._pageBounds.x = 0;
            this._pageLocation.X = 0.0f;
            this._hScrollBar.setVisible(false);
        }
        Rectangle2D.Float aRect = this.pageToScreen(this._pageBounds.x, this._pageBounds.y, this._pageBounds.width, this._pageBounds.height);
        g.setColor(this._pageBackColor);
        g.fill(aRect);
        this.paintGraphicsOnLayout(g);
        g.dispose();
        this.repaint();
    }

    public void paintGraphicsOnLayout(Graphics2D g) {
        for (LayoutElement aElement : this._layoutElements) {
            if (!aElement.isVisible()) continue;
            aElement.paintOnLayout(g, this._pageLocation, this._zoom);
        }
        for (LayoutElement aElement : this._layoutElements) {
            if (!aElement.isVisible() || !aElement.isSelected()) continue;
            if (this._mouseMode == MouseMode.EditVertices) {
                LayoutGraphic aLG = (LayoutGraphic)aElement;
                List<org.meteoinfo.global.PointD> points = aLG.getGraphic().getShape().getPoints();
                this.drawSelectedVertices(g, points);
                continue;
            }
            float[] dashPattern = new float[]{2.0f, 1.0f};
            java.awt.Rectangle aRect = this.pageToScreen(aElement.getBounds());
            g.setColor(Color.cyan);
            g.setStroke(new BasicStroke(1.0f, 1, 0, 10.0f, dashPattern, 0.0f));
            g.draw(aRect);
            switch (aElement.getResizeAbility()) {
                case SameWidthHeight: {
                    this.drawSelectedConers(g, aElement);
                    break;
                }
                case ResizeAll: {
                    this.drawSelectedConers(g, aElement);
                    this.drawSelectedEdgeCenters(g, aElement);
                }
            }
        }
    }

    public void paintGraphics(Graphics2D g) {
        g.setColor(this._pageBackColor);
        g.fillRect(0, 0, this._pageBounds.width, this._pageBounds.height);
        for (LayoutElement aElement : this._layoutElements) {
            if (!aElement.isVisible()) continue;
            aElement.paintOnLayout(g, new PointF(0.0f, 0.0f), 1.0f);
        }
    }

    private void drawSelectedConers(Graphics2D g, LayoutElement aElement) {
        java.awt.Rectangle elementRect = this.pageToScreen(aElement.getBounds());
        int size = 6;
        java.awt.Rectangle rect = new java.awt.Rectangle(elementRect.x - size / 2, elementRect.y - size / 2, size, size);
        g.setColor(Color.cyan);
        g.fill(rect);
        g.setColor(Color.black);
        g.draw(rect);
        rect.y = elementRect.y + elementRect.height - size / 2;
        g.setColor(Color.cyan);
        g.fill(rect);
        g.setColor(Color.black);
        g.draw(rect);
        rect.x = elementRect.x + elementRect.width - size / 2;
        g.setColor(Color.cyan);
        g.fill(rect);
        g.setColor(Color.black);
        g.draw(rect);
        rect.y = elementRect.y - size / 2;
        g.setColor(Color.cyan);
        g.fill(rect);
        g.setColor(Color.black);
        g.draw(rect);
    }

    private void drawSelectedEdgeCenters(Graphics2D g, LayoutElement aElement) {
        java.awt.Rectangle elementRect = this.pageToScreen(aElement.getBounds());
        int size = 6;
        java.awt.Rectangle rect = new java.awt.Rectangle(elementRect.x + elementRect.width / 2 - size / 2, elementRect.y - size / 2, size, size);
        g.setColor(Color.cyan);
        g.fill(rect);
        g.setColor(Color.black);
        g.draw(rect);
        rect.y = elementRect.y + elementRect.height - size / 2;
        g.setColor(Color.cyan);
        g.fill(rect);
        g.setColor(Color.black);
        g.draw(rect);
        rect.x = elementRect.x - size / 2;
        rect.y = elementRect.y + elementRect.height / 2 - size / 2;
        g.setColor(Color.cyan);
        g.fill(rect);
        g.setColor(Color.black);
        g.draw(rect);
        rect.x = elementRect.x + elementRect.width - size / 2;
        g.setColor(Color.cyan);
        g.fill(rect);
        g.setColor(Color.black);
        g.draw(rect);
    }

    private void drawSelectedVertices(Graphics2D g, List<org.meteoinfo.global.PointD> points) {
        int size = 6;
        java.awt.Rectangle rect = new java.awt.Rectangle(0, 0, size, size);
        for (org.meteoinfo.global.PointD aPoint : points) {
            PointF aP = this.pageToScreen((float)aPoint.X, (float)aPoint.Y);
            rect.x = (int)aP.X - size / 2;
            rect.y = (int)aP.Y - size / 2;
            g.setColor(Color.cyan);
            g.fill(rect);
            g.setColor(Color.black);
            g.draw(rect);
        }
    }

    public void exportToPicture(String aFile) throws FileNotFoundException, PrintException, IOException {
        if (aFile.endsWith(".ps")) {
            DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            String mimeType = "application/postscript";
            StreamPrintServiceFactory[] factories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(flavor, mimeType);
            FileOutputStream out = new FileOutputStream(aFile);
            if (factories.length > 0) {
                StreamPrintService service = factories[0].getPrintService(out);
                SimpleDoc doc = new SimpleDoc(new Printable(){

                    @Override
                    public int print(Graphics g, PageFormat pf, int page) {
                        if (page >= 1) {
                            return 1;
                        }
                        double sf1 = pf.getImageableWidth() / (double)(((MapLayout)MapLayout.this)._pageBounds.width + 1);
                        double sf2 = pf.getImageableHeight() / (double)(((MapLayout)MapLayout.this)._pageBounds.height + 1);
                        double s = Math.min(sf1, sf2);
                        Graphics2D g2 = (Graphics2D)g;
                        g2.translate((pf.getWidth() - pf.getImageableWidth()) / 2.0, (pf.getHeight() - pf.getImageableHeight()) / 2.0);
                        g2.scale(s, s);
                        MapLayout.this.paintGraphics(g2);
                        return 0;
                    }
                }, flavor, null);
                DocPrintJob job = service.createPrintJob();
                HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
                job.print(doc, attributes);
                out.close();
            }
        } else if (aFile.endsWith(".eps")) {
            int width = this.getPaperWidth();
            int height = this.getPaperHeight();
            Properties p = new Properties();
            p.setProperty("PageSize", "A5");
            PSGraphics2D g = new PSGraphics2D(new File(aFile), new Dimension(width, height));
            g.startExport();
            this.paintGraphics((Graphics2D)g);
            g.endExport();
            g.dispose();
        } else if (aFile.endsWith(".pdf")) {
            int width = this.getPaperWidth();
            int height = this.getPaperHeight();
            try {
                Document document = new Document(new Rectangle((float)width, (float)height));
                PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(aFile));
                document.open();
                PdfContentByte cb = writer.getDirectContent();
                PdfTemplate pdfTemp = cb.createTemplate((float)width, (float)height);
                PdfGraphics2D g2 = new PdfGraphics2D((PdfContentByte)pdfTemp, (float)width, (float)height, true);
                this.paintGraphics((Graphics2D)g2);
                g2.dispose();
                cb.addTemplate(pdfTemp, 0.0f, 0.0f);
                document.close();
            }
            catch (DocumentException | FileNotFoundException e) {
                e.printStackTrace();
            }
        } else if (aFile.endsWith(".emf")) {
            int width = this.getPaperWidth();
            int height = this.getPaperHeight();
            EMFGraphics2D g = new EMFGraphics2D(new File(aFile), new Dimension(width, height));
            g.startExport();
            this.paintGraphics((Graphics2D)g);
            g.endExport();
            g.dispose();
        } else {
            String extension = aFile.substring(aFile.lastIndexOf(46) + 1);
            BufferedImage aImage = extension.equalsIgnoreCase("bmp") ? new BufferedImage(this._pageBounds.width, this._pageBounds.height, 1) : new BufferedImage(this._pageBounds.width, this._pageBounds.height, 2);
            Graphics2D g = aImage.createGraphics();
            this.paintGraphics(g);
            if (extension.equalsIgnoreCase("jpg")) {
                BufferedImage newImage = new BufferedImage(aImage.getWidth(), aImage.getHeight(), 1);
                newImage.createGraphics().drawImage(aImage, 0, 0, Color.BLACK, null);
                ImageIO.write((RenderedImage)newImage, extension, new File(aFile));
            } else {
                ImageIO.write((RenderedImage)aImage, extension, new File(aFile));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToPicture(String fileName, Integer dpi) throws FileNotFoundException, PrintException, IOException {
        if (dpi == null) {
            this.exportToPicture(fileName);
        } else {
            File output = new File(fileName);
            output.delete();
            int width = this._pageBounds.width;
            int height = this._pageBounds.height;
            String formatName = fileName.substring(fileName.lastIndexOf(46) + 1);
            if (formatName.equals("jpg")) {
                formatName = "jpeg";
                this.saveImage_Jpeg(fileName, width, height, dpi);
                return;
            }
            double scaleFactor = (double)dpi.intValue() / 72.0;
            BufferedImage image = new BufferedImage((int)((double)width * scaleFactor), (int)((double)height * scaleFactor), 1);
            Graphics2D g = image.createGraphics();
            AffineTransform at = g.getTransform();
            at.scale(scaleFactor, scaleFactor);
            g.setTransform(at);
            this.paintGraphics(g);
            Iterator<ImageWriter> iw = ImageIO.getImageWritersByFormatName(formatName);
            while (iw.hasNext()) {
                ImageWriter writer = iw.next();
                ImageWriteParam writeParam = writer.getDefaultWriteParam();
                ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
                IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
                if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
                ImageUtil.setDPI(metadata, dpi.intValue());
                try (ImageOutputStream stream = ImageIO.createImageOutputStream(output);){
                    writer.setOutput(stream);
                    writer.write(metadata, new IIOImage(image, null, metadata), writeParam);
                    break;
                }
            }
            g.dispose();
        }
    }

    private boolean saveImage_Jpeg(String file, int width, int height, int dpi) {
        double scaleFactor = (double)dpi / 72.0;
        BufferedImage bufferedImage = new BufferedImage((int)((double)width * scaleFactor), (int)((double)height * scaleFactor), 1);
        Graphics2D g = bufferedImage.createGraphics();
        AffineTransform at = g.getTransform();
        at.scale(scaleFactor, scaleFactor);
        g.setTransform(at);
        this.paintGraphics(g);
        try {
            ImageWriter imageWriter = ImageIO.getImageWritersBySuffix("jpeg").next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(new File(file));
            imageWriter.setOutput(ios);
            JPEGImageWriteParam jpegParams = (JPEGImageWriteParam)imageWriter.getDefaultWriteParam();
            jpegParams.setCompressionMode(2);
            jpegParams.setCompressionQuality(0.85f);
            IIOMetadata data = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(bufferedImage), jpegParams);
            Element tree = (Element)data.getAsTree("javax_imageio_jpeg_image_1.0");
            Element jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
            jfif.setAttribute("Xdensity", Integer.toString(dpi));
            jfif.setAttribute("Ydensity", Integer.toString(dpi));
            jfif.setAttribute("resUnits", "1");
            data.setFromTree("javax_imageio_jpeg_image_1.0", tree);
            imageWriter.write(null, new IIOImage(bufferedImage, null, data), jpegParams);
            ios.close();
            imageWriter.dispose();
        }
        catch (Exception e) {
            return false;
        }
        g.dispose();
        return true;
    }

    public Point screenToPage(int screenX, int screenY) {
        float x = ((float)screenX - this._pageLocation.X) / this._zoom;
        float y = ((float)screenY - this._pageLocation.Y) / this._zoom;
        return new Point((int)x, (int)y);
    }

    public PointF screenToPage(float screenX, float screenY) {
        float x = (screenX - this._pageLocation.X) / this._zoom;
        float y = (screenY - this._pageLocation.Y) / this._zoom;
        return new PointF(x, y);
    }

    private PointF pageToScreen(float pageX, float pageY) {
        float x = pageX * this._zoom + this._pageLocation.X;
        float y = pageY * this._zoom + this._pageLocation.Y;
        return new PointF(x, y);
    }

    private Rectangle2D.Float pageToScreen(float pageX, float pageY, float pageW, float pageH) {
        PointF screenTL = this.pageToScreen(pageX, pageY);
        PointF screenBR = this.pageToScreen(pageX + pageW, pageY + pageH);
        return new Rectangle2D.Float(screenTL.X, screenTL.Y, screenBR.X - screenTL.X, screenBR.Y - screenTL.Y);
    }

    private java.awt.Rectangle pageToScreen(java.awt.Rectangle rect) {
        PointF screenTL = this.pageToScreen(rect.x, rect.y);
        PointF screenBR = this.pageToScreen(rect.x + rect.width, rect.y + rect.height);
        return new java.awt.Rectangle((int)screenTL.X, (int)screenTL.Y, (int)(screenBR.X - screenTL.X), (int)(screenBR.Y - screenTL.Y));
    }

    private Rectangle2D.Float paperToScreen(Rectangle2D.Float paper) {
        return this.paperToScreen(paper.x, paper.y, paper.width, paper.height);
    }

    private Rectangle2D.Float paperToScreen(float paperX, float paperY, float paperW, float paperH) {
        PointF screenTL = this.paperToScreen(paperX, paperY);
        PointF screenBR = this.paperToScreen(paperX + paperW, paperY + paperH);
        return new Rectangle2D.Float(screenTL.X, screenTL.Y, screenBR.X - screenTL.X, screenBR.Y - screenTL.Y);
    }

    private PointF paperToScreen(float paperX, float paperY) {
        float screenX = paperX / 100.0f * 96.0f * this._zoom + this._pageLocation.X;
        float screenY = paperY / 100.0f * 96.0f * this._zoom + this._pageLocation.Y;
        return new PointF(screenX, screenY);
    }

    public void updateMapFrameOrder() {
        List<LayoutMap> lms = this.getLayoutMaps();
        for (int i = 0; i < lms.size(); ++i) {
            lms.get(i).getMapFrame().setOrder(i);
        }
    }

    public void updateMapFrames(List<MapFrame> mapFrames) {
        Object aLM;
        boolean isNew;
        for (MapFrame mf : mapFrames) {
            isNew = true;
            for (MapFrame aMF : this._mapFrames) {
                if (mf != aMF) continue;
                isNew = false;
                break;
            }
            if (!isNew) continue;
            aLM = new LayoutMap(mf, this.tileLoadListener);
            this.addElement((LayoutElement)aLM);
        }
        for (int i = 0; i < this._mapFrames.size(); ++i) {
            MapFrame mf;
            mf = this._mapFrames.get(i);
            isNew = true;
            aLM = mapFrames.iterator();
            while (aLM.hasNext()) {
                MapFrame aMF;
                aMF = (MapFrame)aLM.next();
                if (mf != aMF) continue;
                isNew = false;
                break;
            }
            if (!isNew || (aLM = this.getLayoutMap(mf)) == null) continue;
            this.removeElement((LayoutElement)aLM);
            --i;
        }
        this.setMapFrames(mapFrames);
    }

    public void addElement(LayoutElement aElement) {
        this._layoutElements.add(aElement);
        if (aElement.getElementType() == ElementType.LayoutMap) {
            LayoutMap aLM = (LayoutMap)aElement;
            aLM.addMapViewUpdatedListener(new IMapViewUpdatedListener(){

                @Override
                public void mapViewUpdatedEvent(MapViewUpdatedEvent event) {
                    MapLayout.this.paintGraphics();
                }
            });
            if (aLM.getMapFrame().isActive()) {
                this._currentLayoutMap = aLM;
            }
        }
    }

    public void removeElement(LayoutElement aElement) {
        switch (aElement.getElementType()) {
            case LayoutMap: {
                if (this.getLayoutMaps().size() == 1) {
                    JOptionPane.showMessageDialog(this, "There is at least one layout map!");
                    return;
                }
                LayoutMap aLM = (LayoutMap)aElement;
                block8: for (int i = 0; i < this._layoutElements.size(); ++i) {
                    LayoutElement aLE = this._layoutElements.get(i);
                    switch (aLE.getElementType()) {
                        case LayoutLegend: {
                            if (((LayoutLegend)aLE).getLayoutMap() != aLM) continue block8;
                            this._layoutElements.remove(aLE);
                            --i;
                            continue block8;
                        }
                        case LayoutScaleBar: {
                            if (((LayoutScaleBar)aLE).getLayoutMap() != aLM) continue block8;
                            this._layoutElements.remove(aLE);
                            --i;
                            continue block8;
                        }
                        case LayoutNorthArraw: {
                            if (((LayoutNorthArrow)aLE).getLayoutMap() != aLM) continue block8;
                            this._layoutElements.remove(aLE);
                            --i;
                        }
                    }
                }
                this._mapFrames.remove(aLM.getMapFrame());
                this._layoutElements.remove(aElement);
                if (this._mapFrames.size() > 0) {
                    this.setActiveMapFrame(this._mapFrames.get(0));
                }
                this.fireMapFramesUpdatedEvent();
                break;
            }
            default: {
                this._layoutElements.remove(aElement);
            }
        }
    }

    public LayoutGraphic addText(String text, int x, int y) {
        return this.addText(text, x, y, this._defLabelBreak.getFont().getFontName(), this._defLabelBreak.getFont().getSize());
    }

    public LayoutGraphic addText(String text, int x, int y, float fontSize) {
        return this.addText(text, x, y, this._defLabelBreak.getFont().getName(), fontSize);
    }

    public LayoutGraphic addText(String text, int x, int y, String fontName, float fontSize) {
        PointShape aPS = new PointShape();
        aPS.setPoint(new org.meteoinfo.global.PointD(x, y));
        LabelBreak aLB = (LabelBreak)this._defLabelBreak.clone();
        aLB.setText(text);
        aLB.setFont(new Font(fontName, 0, (int)fontSize));
        Graphic aGraphic = new Graphic(aPS, aLB);
        LayoutGraphic aLayoutGraphic = new LayoutGraphic(aGraphic, this);
        this.addElement(aLayoutGraphic);
        return aLayoutGraphic;
    }

    public LayoutGraphic addWindArrow(int left, int top) {
        WindArrow aWindArraw = new WindArrow();
        aWindArraw.angle = 270.0;
        aWindArraw.length = 20.0f;
        VectorBreak aVB = new VectorBreak();
        aVB.setColor(Color.black);
        LayoutGraphic wag = new LayoutGraphic(new Graphic(aWindArraw, aVB), this, this.getActiveLayoutMap());
        wag.setLeft(left);
        wag.setTop(top);
        this.addElement(wag);
        return wag;
    }

    public LayoutLegend addLegend(int left, int top) {
        LayoutMap aLM = this.getActiveLayoutMap();
        LayoutLegend aLL = new LayoutLegend(this, aLM);
        aLL.setLeft(left);
        aLL.setTop(top);
        if (aLM.getMapFrame().getMapView().getLayerNum() > 0) {
            for (MapLayer aLayer : aLM.getMapFrame().getMapView().getLayers()) {
                if (aLayer.getLayerType() == LayerTypes.ImageLayer) continue;
                aLL.setLegendLayer(aLayer);
            }
        }
        this.addElement(aLL);
        return aLL;
    }

    public LayoutScaleBar addScaleBar(int left, int top) {
        LayoutMap aLM = this.getActiveLayoutMap();
        LayoutScaleBar aLSB = new LayoutScaleBar(aLM);
        aLSB.setLeft(left);
        aLSB.setTop(top);
        this.addElement(aLSB);
        return aLSB;
    }

    public LayoutNorthArrow addNorthArrow(int left, int top) {
        LayoutMap aLM = this.getActiveLayoutMap();
        LayoutNorthArrow aLNA = new LayoutNorthArrow(aLM);
        aLNA.setLeft(left);
        aLNA.setTop(top);
        this.addElement(aLNA);
        return aLNA;
    }

    public LayoutChart addChart(int left, int top) {
        LayoutChart chart = new LayoutChart();
        chart.setLeft(left);
        chart.setTop(top);
        this.addElement(chart);
        return chart;
    }

    public List<LayoutGraphic> getLayoutGraphics() {
        ArrayList<LayoutGraphic> graphics = new ArrayList<LayoutGraphic>();
        for (LayoutElement aLE : this._layoutElements) {
            if (aLE.getElementType() != ElementType.LayoutGraphic) continue;
            graphics.add((LayoutGraphic)aLE);
        }
        return graphics;
    }

    public List<LayoutGraphic> getTexts() {
        ArrayList<LayoutGraphic> texts = new ArrayList<LayoutGraphic>();
        List<LayoutGraphic> graphics = this.getLayoutGraphics();
        for (LayoutGraphic aLG : graphics) {
            if (aLG.getGraphic().getLegend().getBreakType() != BreakTypes.LabelBreak) continue;
            texts.add(aLG);
        }
        return texts;
    }

    public LayoutGraphic getText(String text) {
        List<LayoutGraphic> texts = this.getTexts();
        for (LayoutGraphic aLG : texts) {
            if (!((LabelBreak)aLG.getGraphic().getLegend()).getText().equals(text)) continue;
            return aLG;
        }
        return null;
    }

    public List<LayoutLegend> getLegends() {
        ArrayList<LayoutLegend> legends = new ArrayList<LayoutLegend>();
        for (LayoutElement aLE : this._layoutElements) {
            if (aLE.getElementType() != ElementType.LayoutLegend) continue;
            legends.add((LayoutLegend)aLE);
        }
        return legends;
    }

    public void setActiveMapFrame(MapFrame mapFrame) {
        for (MapFrame mf : this._mapFrames) {
            mf.setActive(false);
        }
        mapFrame.setActive(true);
        this.fireActiveMapFrameChangedEvent();
    }

    private LayoutMap getLayoutMap(MapFrame mapFrame) {
        LayoutMap aLM = null;
        for (LayoutMap lm : this.getLayoutMaps()) {
            if (lm.getMapFrame() != mapFrame) continue;
            aLM = lm;
            break;
        }
        return aLM;
    }

    private LayoutMap getLayoutMap(Point aPoint) {
        for (int i = this.getLayoutMaps().size() - 1; i >= 0; --i) {
            LayoutMap aLM = this.getLayoutMaps().get(i);
            if (!MIMath.pointInRectangle(aPoint, aLM.getBounds())) continue;
            return aLM;
        }
        return null;
    }

    private int getLayoutMapIndex(LayoutMap aLM) {
        return this.getLayoutMaps().indexOf(aLM);
    }

    public boolean hasLegendElement() {
        for (LayoutElement aLE : this._layoutElements) {
            if (aLE.getElementType() != ElementType.LayoutLegend) continue;
            return true;
        }
        return false;
    }

    private List<LayoutElement> selectElements(Point aPoint, List<LayoutElement> baseElements, int limit) {
        ArrayList<LayoutElement> selectedElements = new ArrayList<LayoutElement>();
        for (int i = baseElements.size() - 1; i >= 0; --i) {
            LayoutElement element = baseElements.get(i);
            if (!element.isVisible()) continue;
            java.awt.Rectangle rect = (java.awt.Rectangle)element.getBounds().clone();
            if (rect.width < 5) {
                rect.width = 5;
                rect.x = (int)((double)rect.x - 2.5);
            }
            if (rect.height < 5) {
                rect.height = 5;
                rect.y = (int)((double)rect.y - 2.5);
            }
            rect.width += limit;
            rect.height += limit;
            if (!MIMath.pointInRectangle(aPoint, rect)) continue;
            selectedElements.add(element);
        }
        return selectedElements;
    }

    private java.awt.Rectangle getElementViewExtent(LayoutElement aLE) {
        PointF aP = aLE.pageToScreen(aLE.getLeft(), aLE.getTop(), this._pageLocation, this._zoom);
        java.awt.Rectangle rect = new java.awt.Rectangle((int)aP.X, (int)aP.Y, (int)((float)aLE.getWidth() * this._zoom), (int)((float)aLE.getHeight() * this._zoom));
        return rect;
    }

    private int selectEditVertices(Point aPoint, Shape aShape, List<org.meteoinfo.global.PointD> vertices) {
        List<? extends org.meteoinfo.global.PointD> points = aShape.getPoints();
        int buffer = 4;
        java.awt.Rectangle rect = new java.awt.Rectangle(aPoint.x - buffer / 2, aPoint.y - buffer / 2, buffer, buffer);
        vertices.clear();
        int vIdx = -1;
        for (int i = 0; i < points.size(); ++i) {
            if (!MIMath.pointInRectangle(points.get(i), rect)) continue;
            vIdx = i;
            vertices.add(points.get(i));
            switch (aShape.getShapeType()) {
                case Polyline: 
                case CurveLine: {
                    if (i == 0) {
                        vertices.add(points.get(i + 1));
                        break;
                    }
                    if (i == points.size() - 1) {
                        vertices.add(points.get(i - 1));
                        break;
                    }
                    vertices.add(points.get(i - 1));
                    vertices.add(points.get(i + 1));
                    break;
                }
                default: {
                    if (i == 0) {
                        vertices.add(points.get(i + 1));
                        org.meteoinfo.global.PointD aPD = points.get(points.size() - 1);
                        if (aPD.X == points.get((int)i).X && aPD.Y == points.get((int)i).Y) {
                            vertices.add(points.get(points.size() - 2));
                            break;
                        }
                        vertices.add(aPD);
                        break;
                    }
                    if (i == points.size() - 1) {
                        vertices.add(points.get(i - 1));
                        org.meteoinfo.global.PointD aPD = points.get(0);
                        if (aPD.X == points.get((int)i).X && aPD.Y == points.get((int)i).Y) {
                            vertices.add(points.get(1));
                            break;
                        }
                        vertices.add(points.get(0));
                        break;
                    }
                    vertices.add(points.get(i - 1));
                    vertices.add(points.get(i + 1));
                    break;
                }
            }
            break;
        }
        return vIdx;
    }

    private boolean isInLayoutMaps(Point aPoint) {
        for (LayoutMap aLM : this.getLayoutMaps()) {
            if (!MIMath.pointInRectangle(aPoint, aLM.getBounds())) continue;
            return true;
        }
        return false;
    }

    private static Edge intersectElementEdge(java.awt.Rectangle screen, PointF pt, float limit) {
        Rectangle2D.Float ptRect = new Rectangle2D.Float(pt.X - limit, pt.Y - limit, 2.0f * limit, 2.0f * limit);
        if (pt.X >= (float)screen.x - limit && pt.X <= (float)screen.x + limit && pt.Y >= (float)screen.y - limit && pt.Y <= (float)screen.y + limit) {
            return Edge.TopLeft;
        }
        if (pt.X >= (float)(screen.x + screen.width) - limit && pt.X <= (float)(screen.x + screen.width) + limit && pt.Y >= (float)screen.y - limit && pt.Y <= (float)screen.y + limit) {
            return Edge.TopRight;
        }
        if (pt.X >= (float)(screen.x + screen.width) - limit && pt.X <= (float)(screen.x + screen.width) + limit && pt.Y >= (float)(screen.y + screen.height) - limit && pt.Y <= (float)(screen.y + screen.height) + limit) {
            return Edge.BottomRight;
        }
        if (pt.X >= (float)screen.x - limit && pt.X <= (float)screen.x + limit && pt.Y >= (float)(screen.y + screen.height) - limit && pt.Y <= (float)(screen.y + screen.height) + limit) {
            return Edge.BottomLeft;
        }
        if (ptRect.intersects(new Rectangle2D.Float(screen.x, screen.y, screen.width, 1.0f))) {
            return Edge.Top;
        }
        if (ptRect.intersects(new Rectangle2D.Float(screen.x, screen.y, 1.0f, screen.height))) {
            return Edge.Left;
        }
        if (ptRect.intersects(new Rectangle2D.Float(screen.x, screen.y + screen.height, screen.width, 1.0f))) {
            return Edge.Bottom;
        }
        if (ptRect.intersects(new Rectangle2D.Float(screen.x + screen.width, screen.y, 1.0f, screen.height))) {
            return Edge.Right;
        }
        return Edge.None;
    }

    private void updatePageSet() {
        Rectangle2D.Float aRect = this.paperToScreen(new Rectangle2D.Float(0.0f, 0.0f, this.getPaperWidth(), this.getPaperHeight()));
        this._pageBounds.width = (int)aRect.width;
        this._pageBounds.height = (int)aRect.height;
    }

    public void showMeasurementForm() {
        if (this._frmMeasure == null) {
            this._frmMeasure = new FrmMeasurement((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false);
            this._frmMeasure.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    MapLayout.this._currentLayoutMap.getMapFrame().getMapView().setDrawIdentiferShape(false);
                    MapLayout.this.repaint();
                }
            });
            this._frmMeasure.setLocationRelativeTo(this);
            this._frmMeasure.setVisible(true);
        } else if (!this._frmMeasure.isVisible()) {
            this._frmMeasure.setVisible(true);
        }
    }

    public void exportProjectXML(org.w3c.dom.Document m_Doc, Element parent) {
        this.exportLayout(m_Doc, parent);
    }

    private void exportLayout(org.w3c.dom.Document m_Doc, Element parent) {
        Element layout = m_Doc.createElement("Layout");
        Attr BackColor = m_Doc.createAttribute("BackColor");
        Attr ForeColor = m_Doc.createAttribute("ForeColor");
        Attr SmoothingMode = m_Doc.createAttribute("SmoothingMode");
        Attr PaperSizeName = m_Doc.createAttribute("PaperSizeName");
        Attr PaperSizeWidth = m_Doc.createAttribute("PaperSizeWidth");
        Attr PaperSizeHeight = m_Doc.createAttribute("PaperSizeHeight");
        Attr Landscape = m_Doc.createAttribute("Landscape");
        BackColor.setValue(ColorUtil.toHexEncoding(this._pageBackColor));
        ForeColor.setValue(ColorUtil.toHexEncoding(this._pageForeColor));
        SmoothingMode.setValue(String.valueOf(this._antiAlias));
        PaperSizeName.setValue(this._paperSize.getName());
        PaperSizeWidth.setValue(String.valueOf(this._paperSize.getWidth()));
        PaperSizeHeight.setValue(String.valueOf(this._paperSize.getHeight()));
        Landscape.setValue(String.valueOf(this._isLandscape));
        layout.setAttributeNode(BackColor);
        layout.setAttributeNode(ForeColor);
        layout.setAttributeNode(SmoothingMode);
        layout.setAttributeNode(PaperSizeName);
        layout.setAttributeNode(PaperSizeWidth);
        layout.setAttributeNode(PaperSizeHeight);
        layout.setAttributeNode(Landscape);
        parent.appendChild(layout);
        this.addLayoutElements(m_Doc, layout);
    }

    private void addLayoutElements(org.w3c.dom.Document doc, Element parent) {
        Element layoutElements = doc.createElement("LayoutElements");
        for (LayoutElement aElement : this._layoutElements) {
            switch (aElement.getElementType()) {
                case LayoutMap: {
                    this.addLayoutMapElement(doc, layoutElements, (LayoutMap)aElement);
                    break;
                }
                case LayoutIllustration: {
                    break;
                }
                case LayoutLegend: {
                    this.addLayoutLegendElement(doc, layoutElements, (LayoutLegend)aElement);
                    break;
                }
                case LayoutGraphic: {
                    this.addLayoutGraphicElement(doc, layoutElements, (LayoutGraphic)aElement);
                    break;
                }
                case LayoutScaleBar: {
                    this.addLayoutScaleBarElement(doc, layoutElements, (LayoutScaleBar)aElement);
                    break;
                }
                case LayoutNorthArraw: {
                    this.addLayoutNorthArrowElement(doc, layoutElements, (LayoutNorthArrow)aElement);
                }
            }
        }
        parent.appendChild(layoutElements);
    }

    private void addLayoutMapElement(org.w3c.dom.Document m_Doc, Element parent, LayoutMap aMap) {
        Element layoutMap = m_Doc.createElement("LayoutMap");
        Attr elementType = m_Doc.createAttribute("ElementType");
        Attr left = m_Doc.createAttribute("Left");
        Attr top = m_Doc.createAttribute("Top");
        Attr width = m_Doc.createAttribute("Width");
        Attr height = m_Doc.createAttribute("Height");
        Attr DrawMapNeatLine = m_Doc.createAttribute("DrawNeatLine");
        Attr MapNeatLineColor = m_Doc.createAttribute("NeatLineColor");
        Attr MapNeatLineSize = m_Doc.createAttribute("NeatLineSize");
        Attr GridLineColor = m_Doc.createAttribute("GridLineColor");
        Attr GridLineSize = m_Doc.createAttribute("GridLineSize");
        Attr GridLineStyle = m_Doc.createAttribute("GridLineStyle");
        Attr DrawGridLine = m_Doc.createAttribute("DrawGridLine");
        Attr DrawGridLabel = m_Doc.createAttribute("DrawGridLabel");
        Attr GridFontName = m_Doc.createAttribute("GridFontName");
        Attr GridFontSize = m_Doc.createAttribute("GridFontSize");
        Attr GridXDelt = m_Doc.createAttribute("GridXDelt");
        Attr GridYDelt = m_Doc.createAttribute("GridYDelt");
        Attr GridXOrigin = m_Doc.createAttribute("GridXOrigin");
        Attr GridYOrigin = m_Doc.createAttribute("GridYOrigin");
        Attr gridLabelPosition = m_Doc.createAttribute("GridLabelPosition");
        Attr drawDegreeSymbol = m_Doc.createAttribute("DrawDegreeSymbol");
        Attr drawBackColor = m_Doc.createAttribute("DrawBackColor");
        elementType.setValue(aMap.getElementType().toString());
        left.setValue(String.valueOf(aMap.getLeft()));
        top.setValue(String.valueOf(aMap.getTop()));
        width.setValue(String.valueOf(aMap.getWidth()));
        height.setValue(String.valueOf(aMap.getHeight()));
        DrawMapNeatLine.setValue(String.valueOf(aMap.isDrawNeatLine()));
        MapNeatLineColor.setValue(ColorUtil.toHexEncoding(aMap.getNeatLineColor()));
        MapNeatLineSize.setValue(String.valueOf(aMap.getNeatLineSize()));
        GridLineColor.setValue(ColorUtil.toHexEncoding(aMap.getGridLineColor()));
        GridLineSize.setValue(String.valueOf(aMap.getGridLineSize()));
        GridLineStyle.setValue(aMap.getGridLineStyle().toString());
        DrawGridLine.setValue(String.valueOf(aMap.isDrawGridLine()));
        DrawGridLabel.setValue(String.valueOf(aMap.isDrawGridLabel()));
        GridFontName.setValue(aMap.getGridFont().getFontName());
        GridFontSize.setValue(String.valueOf(aMap.getGridFont().getSize()));
        GridXDelt.setValue(String.valueOf(aMap.getGridXDelt()));
        GridYDelt.setValue(String.valueOf(aMap.getGridYDelt()));
        GridXOrigin.setValue(String.valueOf(aMap.getGridXOrigin()));
        GridYOrigin.setValue(String.valueOf(aMap.getGridYOrigin()));
        gridLabelPosition.setValue(aMap.getGridLabelPosition().toString());
        drawDegreeSymbol.setValue(String.valueOf(aMap.isDrawDegreeSymbol()));
        drawBackColor.setValue(String.valueOf(aMap.isDrawBackColor()));
        layoutMap.setAttributeNode(elementType);
        layoutMap.setAttributeNode(left);
        layoutMap.setAttributeNode(top);
        layoutMap.setAttributeNode(width);
        layoutMap.setAttributeNode(height);
        layoutMap.setAttributeNode(DrawMapNeatLine);
        layoutMap.setAttributeNode(MapNeatLineColor);
        layoutMap.setAttributeNode(MapNeatLineSize);
        layoutMap.setAttributeNode(GridLineColor);
        layoutMap.setAttributeNode(GridLineSize);
        layoutMap.setAttributeNode(GridLineStyle);
        layoutMap.setAttributeNode(DrawGridLine);
        layoutMap.setAttributeNode(DrawGridLabel);
        layoutMap.setAttributeNode(GridFontName);
        layoutMap.setAttributeNode(GridFontSize);
        layoutMap.setAttributeNode(GridXDelt);
        layoutMap.setAttributeNode(GridYDelt);
        layoutMap.setAttributeNode(GridXOrigin);
        layoutMap.setAttributeNode(GridYOrigin);
        layoutMap.setAttributeNode(gridLabelPosition);
        layoutMap.setAttributeNode(drawDegreeSymbol);
        layoutMap.setAttributeNode(drawBackColor);
        parent.appendChild(layoutMap);
    }

    private void addLayoutLegendElement(org.w3c.dom.Document doc, Element parent, LayoutLegend aLegend) {
        Element Legend = doc.createElement("LayoutLegend");
        Attr elementType = doc.createAttribute("ElementType");
        Attr layoutMapIndex = doc.createAttribute("LayoutMapIndex");
        Attr legendLayer = doc.createAttribute("LegendLayer");
        Attr LegendStyle = doc.createAttribute("LegendStyle");
        Attr layerUpdateType = doc.createAttribute("LayerUpdateType");
        Attr BackColor = doc.createAttribute("BackColor");
        Attr DrawNeatLine = doc.createAttribute("DrawNeatLine");
        Attr NeatLineColor = doc.createAttribute("NeatLineColor");
        Attr NeatLineSize = doc.createAttribute("NeatLineSize");
        Attr drawChartBreaks = doc.createAttribute("DrawChartBreaks");
        Attr Left = doc.createAttribute("Left");
        Attr Top = doc.createAttribute("Top");
        Attr Width = doc.createAttribute("Width");
        Attr Height = doc.createAttribute("Height");
        Attr FontName = doc.createAttribute("FontName");
        Attr FontSize = doc.createAttribute("FontSize");
        Attr colNum = doc.createAttribute("ColumnNumber");
        Attr drawBackColor = doc.createAttribute("DrawBackColor");
        Attr forceDrawOutline = doc.createAttribute("ForceDrawOutline");
        elementType.setValue(aLegend.getElementType().toString());
        layoutMapIndex.setValue(String.valueOf(this.getLayoutMapIndex(aLegend.getLayoutMap())));
        legendLayer.setValue(aLegend.getLayerName());
        LegendStyle.setValue(aLegend.getLegendStyle().toString());
        layerUpdateType.setValue(aLegend.getLayerUpdateType().toString());
        BackColor.setValue(ColorUtil.toHexEncoding(aLegend.getBackColor()));
        DrawNeatLine.setValue(String.valueOf(aLegend.isDrawNeatLine()));
        NeatLineColor.setValue(ColorUtil.toHexEncoding(aLegend.getNeatLineColor()));
        NeatLineSize.setValue(String.valueOf(aLegend.getNeatLineSize()));
        drawChartBreaks.setValue(String.valueOf(aLegend.isDrawChartBreaks()));
        Left.setValue(String.valueOf(aLegend.getLeft()));
        Top.setValue(String.valueOf(aLegend.getTop()));
        Width.setValue(String.valueOf(aLegend.getWidth()));
        Height.setValue(String.valueOf(aLegend.getHeight()));
        FontName.setValue(aLegend.getFont().getFontName());
        FontSize.setValue(String.valueOf(aLegend.getFont().getSize()));
        colNum.setValue(String.valueOf(aLegend.getColumnNumber()));
        drawBackColor.setValue(String.valueOf(aLegend.isDrawBackColor()));
        forceDrawOutline.setValue(String.valueOf(aLegend.isForceDrawOutline()));
        Legend.setAttributeNode(elementType);
        Legend.setAttributeNode(layoutMapIndex);
        Legend.setAttributeNode(legendLayer);
        Legend.setAttributeNode(LegendStyle);
        Legend.setAttributeNode(layerUpdateType);
        Legend.setAttributeNode(BackColor);
        Legend.setAttributeNode(DrawNeatLine);
        Legend.setAttributeNode(NeatLineColor);
        Legend.setAttributeNode(NeatLineSize);
        Legend.setAttributeNode(drawChartBreaks);
        Legend.setAttributeNode(Left);
        Legend.setAttributeNode(Top);
        Legend.setAttributeNode(Width);
        Legend.setAttributeNode(Height);
        Legend.setAttributeNode(FontName);
        Legend.setAttributeNode(FontSize);
        Legend.setAttributeNode(colNum);
        Legend.setAttributeNode(drawBackColor);
        Legend.setAttributeNode(forceDrawOutline);
        parent.appendChild(Legend);
    }

    private void addLayoutScaleBarElement(org.w3c.dom.Document doc, Element parent, LayoutScaleBar aScaleBar) {
        Element scaleBar = doc.createElement("LayoutScaleBar");
        Attr elementType = doc.createAttribute("ElementType");
        Attr layoutMapIndex = doc.createAttribute("LayoutMapIndex");
        Attr scaleBarType = doc.createAttribute("ScaleBarType");
        Attr BackColor = doc.createAttribute("BackColor");
        Attr foreColor = doc.createAttribute("ForeColor");
        Attr DrawNeatLine = doc.createAttribute("DrawNeatLine");
        Attr NeatLineColor = doc.createAttribute("NeatLineColor");
        Attr NeatLineSize = doc.createAttribute("NeatLineSize");
        Attr Left = doc.createAttribute("Left");
        Attr Top = doc.createAttribute("Top");
        Attr Width = doc.createAttribute("Width");
        Attr Height = doc.createAttribute("Height");
        Attr FontName = doc.createAttribute("FontName");
        Attr FontSize = doc.createAttribute("FontSize");
        Attr drawScaleText = doc.createAttribute("DrawScaleText");
        Attr drawBackColor = doc.createAttribute("DrawBackColor");
        elementType.setValue(aScaleBar.getElementType().toString());
        layoutMapIndex.setValue(String.valueOf(this.getLayoutMapIndex(aScaleBar.getLayoutMap())));
        scaleBarType.setValue(aScaleBar.getScaleBarType().toString());
        BackColor.setValue(ColorUtil.toHexEncoding(aScaleBar.getBackColor()));
        foreColor.setValue(ColorUtil.toHexEncoding(aScaleBar.getForeColor()));
        DrawNeatLine.setValue(String.valueOf(aScaleBar.isDrawNeatLine()));
        NeatLineColor.setValue(ColorUtil.toHexEncoding(aScaleBar.getNeatLineColor()));
        NeatLineSize.setValue(String.valueOf(aScaleBar.getNeatLineSize()));
        Left.setValue(String.valueOf(aScaleBar.getLeft()));
        Top.setValue(String.valueOf(aScaleBar.getTop()));
        Width.setValue(String.valueOf(aScaleBar.getWidth()));
        Height.setValue(String.valueOf(aScaleBar.getHeight()));
        FontName.setValue(aScaleBar.getFont().getFontName());
        FontSize.setValue(String.valueOf(aScaleBar.getFont().getSize()));
        drawScaleText.setValue(String.valueOf(aScaleBar.isDrawScaleText()));
        drawBackColor.setValue(String.valueOf(aScaleBar.isDrawBackColor()));
        scaleBar.setAttributeNode(elementType);
        scaleBar.setAttributeNode(layoutMapIndex);
        scaleBar.setAttributeNode(scaleBarType);
        scaleBar.setAttributeNode(BackColor);
        scaleBar.setAttributeNode(foreColor);
        scaleBar.setAttributeNode(DrawNeatLine);
        scaleBar.setAttributeNode(NeatLineColor);
        scaleBar.setAttributeNode(NeatLineSize);
        scaleBar.setAttributeNode(Left);
        scaleBar.setAttributeNode(Top);
        scaleBar.setAttributeNode(Width);
        scaleBar.setAttributeNode(Height);
        scaleBar.setAttributeNode(FontName);
        scaleBar.setAttributeNode(FontSize);
        scaleBar.setAttributeNode(drawScaleText);
        scaleBar.setAttributeNode(drawBackColor);
        parent.appendChild(scaleBar);
    }

    private void addLayoutNorthArrowElement(org.w3c.dom.Document doc, Element parent, LayoutNorthArrow aNorthArrow) {
        Element northArrow = doc.createElement("LayoutNorthArrow");
        Attr elementType = doc.createAttribute("ElementType");
        Attr layoutMapIndex = doc.createAttribute("LayoutMapIndex");
        Attr BackColor = doc.createAttribute("BackColor");
        Attr foreColor = doc.createAttribute("ForeColor");
        Attr DrawNeatLine = doc.createAttribute("DrawNeatLine");
        Attr NeatLineColor = doc.createAttribute("NeatLineColor");
        Attr NeatLineSize = doc.createAttribute("NeatLineSize");
        Attr Left = doc.createAttribute("Left");
        Attr Top = doc.createAttribute("Top");
        Attr Width = doc.createAttribute("Width");
        Attr Height = doc.createAttribute("Height");
        Attr angle = doc.createAttribute("Angle");
        Attr drawBackColor = doc.createAttribute("DrawBackColor");
        elementType.setValue(aNorthArrow.getElementType().toString());
        layoutMapIndex.setValue(String.valueOf(this.getLayoutMapIndex(aNorthArrow.getLayoutMap())));
        BackColor.setValue(ColorUtil.toHexEncoding(aNorthArrow.getBackColor()));
        foreColor.setValue(ColorUtil.toHexEncoding(aNorthArrow.getForeColor()));
        DrawNeatLine.setValue(String.valueOf(aNorthArrow.isDrawNeatLine()));
        NeatLineColor.setValue(ColorUtil.toHexEncoding(aNorthArrow.getNeatLineColor()));
        NeatLineSize.setValue(String.valueOf(aNorthArrow.getNeatLineSize()));
        Left.setValue(String.valueOf(aNorthArrow.getLeft()));
        Top.setValue(String.valueOf(aNorthArrow.getTop()));
        Width.setValue(String.valueOf(aNorthArrow.getWidth()));
        Height.setValue(String.valueOf(aNorthArrow.getHeight()));
        angle.setValue(String.valueOf(aNorthArrow.getAngle()));
        drawBackColor.setValue(String.valueOf(aNorthArrow.isDrawBackColor()));
        northArrow.setAttributeNode(elementType);
        northArrow.setAttributeNode(layoutMapIndex);
        northArrow.setAttributeNode(BackColor);
        northArrow.setAttributeNode(foreColor);
        northArrow.setAttributeNode(DrawNeatLine);
        northArrow.setAttributeNode(NeatLineColor);
        northArrow.setAttributeNode(NeatLineSize);
        northArrow.setAttributeNode(Left);
        northArrow.setAttributeNode(Top);
        northArrow.setAttributeNode(Width);
        northArrow.setAttributeNode(Height);
        northArrow.setAttributeNode(angle);
        northArrow.setAttributeNode(drawBackColor);
        parent.appendChild(northArrow);
    }

    private void addLayoutGraphicElement(org.w3c.dom.Document doc, Element parent, LayoutGraphic aLayoutGraphic) {
        Element layoutGraphic = doc.createElement("LayoutGraphic");
        Attr elementType = doc.createAttribute("ElementType");
        Attr isTitle = doc.createAttribute("IsTitle");
        Attr left = doc.createAttribute("Left");
        Attr top = doc.createAttribute("Top");
        Attr width = doc.createAttribute("Width");
        Attr height = doc.createAttribute("Height");
        elementType.setValue(aLayoutGraphic.getElementType().toString());
        isTitle.setValue(String.valueOf(aLayoutGraphic.isTitle()));
        left.setValue(String.valueOf(aLayoutGraphic.getLeft()));
        top.setValue(String.valueOf(aLayoutGraphic.getTop()));
        width.setValue(String.valueOf(aLayoutGraphic.getWidth()));
        height.setValue(String.valueOf(aLayoutGraphic.getHeight()));
        layoutGraphic.setAttributeNode(elementType);
        layoutGraphic.setAttributeNode(isTitle);
        layoutGraphic.setAttributeNode(left);
        layoutGraphic.setAttributeNode(top);
        layoutGraphic.setAttributeNode(width);
        layoutGraphic.setAttributeNode(height);
        Graphic aGraphic = aLayoutGraphic.getGraphic();
        aGraphic.exportToXML(doc, layoutGraphic);
        parent.appendChild(layoutGraphic);
    }

    public void loadProjectFile(String aFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        org.w3c.dom.Document doc = db.parse(aFile);
        Element root = doc.getDocumentElement();
        Properties property = System.getProperties();
        String path = System.getProperty("user.dir");
        property.setProperty("user.dir", new File(aFile).getAbsolutePath());
        ArrayList<MapFrame> mfs = new ArrayList<MapFrame>();
        Element mapFrames = (Element)root.getElementsByTagName("MapFrames").item(0);
        if (mapFrames == null) {
            MapFrame mf = new MapFrame();
            mf.importProjectXML(root);
            mf.setActive(true);
            mfs.add(mf);
        } else {
            NodeList mfNodes = mapFrames.getElementsByTagName("MapFrame");
            for (int i = 0; i < mfNodes.getLength(); ++i) {
                Node mapFrame = mfNodes.item(i);
                MapFrame mf = new MapFrame();
                mf.importProjectXML((Element)mapFrame);
                mfs.add(mf);
            }
        }
        this.setMapFrames(mfs);
        this.importProjectXML(root);
        property.setProperty("user.dir", path);
    }

    public void importProjectXML(Element parent) {
        this.loadLayout(parent);
    }

    private void loadLayout(Element parent) {
        Node layout = parent.getElementsByTagName("Layout").item(0);
        try {
            this._pageBackColor = ColorUtil.parseToColor(layout.getAttributes().getNamedItem("BackColor").getNodeValue());
            this._pageForeColor = ColorUtil.parseToColor(layout.getAttributes().getNamedItem("ForeColor").getNodeValue());
            this.setAntiAlias(Boolean.parseBoolean(layout.getAttributes().getNamedItem("SmoothingMode").getNodeValue()));
            this._paperSize.setName(layout.getAttributes().getNamedItem("PaperSizeName").getNodeValue());
            this._paperSize.setWidth(Integer.parseInt(layout.getAttributes().getNamedItem("PaperSizeWidth").getNodeValue()));
            this._paperSize.setHeight(Integer.parseInt(layout.getAttributes().getNamedItem("PaperSizeHeight").getNodeValue()));
            this._isLandscape = Boolean.parseBoolean(layout.getAttributes().getNamedItem("Landscape").getNodeValue());
            this.updatePageSet();
            this.loadLayoutElements((Element)layout);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadLayoutElements(Element parent) {
        Node elementNode;
        int i;
        this._layoutElements.clear();
        this._selectedElements.clear();
        Node layoutElements = parent.getElementsByTagName("LayoutElements").item(0);
        NodeList layoutNodes = ((Element)layoutElements).getElementsByTagName("LayoutMap");
        for (i = 0; i < layoutNodes.getLength(); ++i) {
            elementNode = layoutNodes.item(i);
            MapFrame aMF = this._mapFrames.size() > i ? this._mapFrames.get(i) : new MapFrame();
            LayoutMap aLM = new LayoutMap(aMF, this.tileLoadListener);
            this.loadLayoutMapElement(elementNode, aLM);
            this.addElement(aLM);
        }
        block8: for (i = 0; i < layoutElements.getChildNodes().getLength(); ++i) {
            elementNode = layoutElements.getChildNodes().item(i);
            if (elementNode.getNodeType() != 1) continue;
            ElementType aType = ElementType.valueOf(elementNode.getAttributes().getNamedItem("ElementType").getNodeValue());
            switch (aType) {
                case LayoutIllustration: {
                    continue block8;
                }
                case LayoutLegend: {
                    LayoutLegend aLL = this.loadLayoutLegendElement(elementNode);
                    this.addElement(aLL);
                    continue block8;
                }
                case LayoutGraphic: {
                    LayoutGraphic aLG = this.loadLayoutGraphicElement(elementNode);
                    if (aLG.getGraphic().getShape().getShapeType() == ShapeTypes.WindArraw) {
                        ((WindArrow)aLG.getGraphic().getShape()).angle = 270.0;
                    }
                    this.addElement(aLG);
                    continue block8;
                }
                case LayoutScaleBar: {
                    LayoutScaleBar aLSB = this.loadLayoutScaleBarElement(elementNode);
                    if (aLSB == null) continue block8;
                    this.addElement(aLSB);
                    continue block8;
                }
                case LayoutNorthArraw: {
                    LayoutNorthArrow aLNA = this.loadLayoutNorthArrowElement(elementNode);
                    if (aLNA == null) continue block8;
                    this.addElement(aLNA);
                }
            }
        }
    }

    private void loadLayoutMapElement(Node layoutMap, LayoutMap aLM) {
        try {
            aLM.setLeft(Integer.parseInt(layoutMap.getAttributes().getNamedItem("Left").getNodeValue()));
            aLM.setTop(Integer.parseInt(layoutMap.getAttributes().getNamedItem("Top").getNodeValue()));
            aLM.setWidth(Integer.parseInt(layoutMap.getAttributes().getNamedItem("Width").getNodeValue()));
            aLM.setHeight(Integer.parseInt(layoutMap.getAttributes().getNamedItem("Height").getNodeValue()));
            aLM.setDrawNeatLine(Boolean.parseBoolean(layoutMap.getAttributes().getNamedItem("DrawNeatLine").getNodeValue()));
            aLM.setNeatLineColor(ColorUtil.parseToColor(layoutMap.getAttributes().getNamedItem("NeatLineColor").getNodeValue()));
            aLM.setNeatLineSize(Float.parseFloat(layoutMap.getAttributes().getNamedItem("NeatLineSize").getNodeValue()));
            aLM.setGridLineColor(ColorUtil.parseToColor(layoutMap.getAttributes().getNamedItem("GridLineColor").getNodeValue()));
            aLM.setGridLineSize(Float.parseFloat(layoutMap.getAttributes().getNamedItem("GridLineSize").getNodeValue()));
            aLM.setGridLineStyle(LineStyles.valueOf(layoutMap.getAttributes().getNamedItem("GridLineStyle").getNodeValue()));
            aLM.setDrawGridLine(Boolean.parseBoolean(layoutMap.getAttributes().getNamedItem("DrawGridLine").getNodeValue()));
            aLM.setDrawGridLabel(Boolean.parseBoolean(layoutMap.getAttributes().getNamedItem("DrawGridLabel").getNodeValue()));
            String fontName = layoutMap.getAttributes().getNamedItem("GridFontName").getNodeValue();
            float fontSize = Float.parseFloat(layoutMap.getAttributes().getNamedItem("GridFontSize").getNodeValue());
            aLM.setGridFont(new Font(fontName, 0, (int)fontSize));
            aLM.setGridXDelt(Double.parseDouble(layoutMap.getAttributes().getNamedItem("GridXDelt").getNodeValue()));
            aLM.setGridYDelt(Double.parseDouble(layoutMap.getAttributes().getNamedItem("GridYDelt").getNodeValue()));
            aLM.setGridXOrigin(Float.parseFloat(layoutMap.getAttributes().getNamedItem("GridXOrigin").getNodeValue()));
            aLM.setGridYOrigin(Float.parseFloat(layoutMap.getAttributes().getNamedItem("GridYOrigin").getNodeValue()));
            aLM.setGridLabelPosition(GridLabelPosition.valueOf(layoutMap.getAttributes().getNamedItem("GridLabelPosition").getNodeValue()));
            aLM.setDrawDegreeSymbol(Boolean.parseBoolean(layoutMap.getAttributes().getNamedItem("DrawDegreeSymbol").getNodeValue()));
            aLM.setDrawBackColor(Boolean.parseBoolean(layoutMap.getAttributes().getNamedItem("DrawBackColor").getNodeValue()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private LayoutLegend loadLayoutLegendElement(Node layoutLegend) {
        LayoutLegend aLL = null;
        try {
            int layoutMapIdx = Integer.parseInt(layoutLegend.getAttributes().getNamedItem("LayoutMapIndex").getNodeValue());
            String legendLayerName = layoutLegend.getAttributes().getNamedItem("LegendLayer").getNodeValue();
            LayoutMap aLM = this.getLayoutMaps().get(layoutMapIdx);
            MapLayer legendLayer = aLM.getMapFrame().getMapView().getLayer(legendLayerName);
            aLL = new LayoutLegend(this, aLM);
            aLL.setLegendLayer(legendLayer);
        }
        catch (Exception e) {
            aLL = new LayoutLegend(this, this.getLayoutMaps().get(0));
            aLL.setLegendLayer((MapLayer)aLL.getLayoutMap().getMapFrame().getMapView().getLayers().get(0));
        }
        try {
            aLL.setLegendStyle(LegendStyles.valueOf(layoutLegend.getAttributes().getNamedItem("LegendStyle").getNodeValue()));
            aLL.setBackColor(ColorUtil.parseToColor(layoutLegend.getAttributes().getNamedItem("BackColor").getNodeValue()));
            aLL.setDrawNeatLine(Boolean.parseBoolean(layoutLegend.getAttributes().getNamedItem("DrawNeatLine").getNodeValue()));
            aLL.setNeatLineColor(ColorUtil.parseToColor(layoutLegend.getAttributes().getNamedItem("NeatLineColor").getNodeValue()));
            aLL.setNeatLineSize(Float.parseFloat(layoutLegend.getAttributes().getNamedItem("NeatLineSize").getNodeValue()));
            aLL.setLeft(Integer.parseInt(layoutLegend.getAttributes().getNamedItem("Left").getNodeValue()));
            aLL.setTop(Integer.parseInt(layoutLegend.getAttributes().getNamedItem("Top").getNodeValue()));
            aLL.setWidth(Integer.parseInt(layoutLegend.getAttributes().getNamedItem("Width").getNodeValue()));
            aLL.setHeight(Integer.parseInt(layoutLegend.getAttributes().getNamedItem("Height").getNodeValue()));
            String fontName = layoutLegend.getAttributes().getNamedItem("FontName").getNodeValue();
            float fontSize = Float.parseFloat(layoutLegend.getAttributes().getNamedItem("FontSize").getNodeValue());
            aLL.setFont(new Font(fontName, 0, (int)fontSize));
            aLL.setLayerUpdateType(LayerUpdateTypes.valueOf(layoutLegend.getAttributes().getNamedItem("LayerUpdateType").getNodeValue()));
            aLL.setColumnNumber(Integer.parseInt(layoutLegend.getAttributes().getNamedItem("ColumnNumber").getNodeValue()));
            aLL.setDrawBackColor(Boolean.parseBoolean(layoutLegend.getAttributes().getNamedItem("DrawBackColor").getNodeValue()));
            aLL.setDrawChartBreaks(Boolean.parseBoolean(layoutLegend.getAttributes().getNamedItem("DrawChartBreaks").getNodeValue()));
            aLL.setForceDrawOutline(Boolean.parseBoolean(layoutLegend.getAttributes().getNamedItem("ForceDrawOutline").getNodeValue()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return aLL;
    }

    private LayoutScaleBar loadLayoutScaleBarElement(Node layoutScaleBar) {
        LayoutScaleBar aLSB = null;
        try {
            int layoutMapIdx = Integer.parseInt(layoutScaleBar.getAttributes().getNamedItem("LayoutMapIndex").getNodeValue());
            LayoutMap aLM = this.getLayoutMaps().get(layoutMapIdx);
            aLSB = new LayoutScaleBar(aLM);
        }
        catch (Exception e) {
            aLSB = new LayoutScaleBar(this.getLayoutMaps().get(0));
        }
        try {
            aLSB.setScaleBarType(ScaleBarType.valueOf(layoutScaleBar.getAttributes().getNamedItem("ScaleBarType").getNodeValue()));
            aLSB.setBackColor(ColorUtil.parseToColor(layoutScaleBar.getAttributes().getNamedItem("BackColor").getNodeValue()));
            aLSB.setForeColor(ColorUtil.parseToColor(layoutScaleBar.getAttributes().getNamedItem("ForeColor").getNodeValue()));
            aLSB.setDrawNeatLine(Boolean.parseBoolean(layoutScaleBar.getAttributes().getNamedItem("DrawNeatLine").getNodeValue()));
            aLSB.setNeatLineColor(ColorUtil.parseToColor(layoutScaleBar.getAttributes().getNamedItem("NeatLineColor").getNodeValue()));
            aLSB.setNeatLineSize(Float.parseFloat(layoutScaleBar.getAttributes().getNamedItem("NeatLineSize").getNodeValue()));
            aLSB.setLeft(Integer.parseInt(layoutScaleBar.getAttributes().getNamedItem("Left").getNodeValue()));
            aLSB.setTop(Integer.parseInt(layoutScaleBar.getAttributes().getNamedItem("Top").getNodeValue()));
            aLSB.setWidth(Integer.parseInt(layoutScaleBar.getAttributes().getNamedItem("Width").getNodeValue()));
            aLSB.setHeight(Integer.parseInt(layoutScaleBar.getAttributes().getNamedItem("Height").getNodeValue()));
            String fontName = layoutScaleBar.getAttributes().getNamedItem("FontName").getNodeValue();
            float fontSize = Float.parseFloat(layoutScaleBar.getAttributes().getNamedItem("FontSize").getNodeValue());
            aLSB.setFont(new Font(fontName, 0, (int)fontSize));
            aLSB.setDrawScaleText(Boolean.parseBoolean(layoutScaleBar.getAttributes().getNamedItem("DrawScaleText").getNodeValue()));
            aLSB.setDrawBackColor(Boolean.parseBoolean(layoutScaleBar.getAttributes().getNamedItem("DrawBackColor").getNodeValue()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return aLSB;
    }

    private LayoutNorthArrow loadLayoutNorthArrowElement(Node layoutNorthArrow) {
        LayoutNorthArrow aLNA = null;
        try {
            int layoutMapIdx = Integer.parseInt(layoutNorthArrow.getAttributes().getNamedItem("LayoutMapIndex").getNodeValue());
            LayoutMap aLM = this.getLayoutMaps().get(layoutMapIdx);
            aLNA = new LayoutNorthArrow(aLM);
        }
        catch (Exception e) {
            aLNA = new LayoutNorthArrow(this.getLayoutMaps().get(0));
        }
        try {
            aLNA.setBackColor(ColorUtil.parseToColor(layoutNorthArrow.getAttributes().getNamedItem("BackColor").getNodeValue()));
            aLNA.setForeColor(ColorUtil.parseToColor(layoutNorthArrow.getAttributes().getNamedItem("ForeColor").getNodeValue()));
            aLNA.setDrawNeatLine(Boolean.parseBoolean(layoutNorthArrow.getAttributes().getNamedItem("DrawNeatLine").getNodeValue()));
            aLNA.setNeatLineColor(ColorUtil.parseToColor(layoutNorthArrow.getAttributes().getNamedItem("NeatLineColor").getNodeValue()));
            aLNA.setNeatLineSize(Float.parseFloat(layoutNorthArrow.getAttributes().getNamedItem("NeatLineSize").getNodeValue()));
            aLNA.setLeft(Integer.parseInt(layoutNorthArrow.getAttributes().getNamedItem("Left").getNodeValue()));
            aLNA.setTop(Integer.parseInt(layoutNorthArrow.getAttributes().getNamedItem("Top").getNodeValue()));
            aLNA.setWidth(Integer.parseInt(layoutNorthArrow.getAttributes().getNamedItem("Width").getNodeValue()));
            aLNA.setHeight(Integer.parseInt(layoutNorthArrow.getAttributes().getNamedItem("Height").getNodeValue()));
            aLNA.setAngle(Float.parseFloat(layoutNorthArrow.getAttributes().getNamedItem("Angle").getNodeValue()));
            aLNA.setDrawBackColor(Boolean.parseBoolean(layoutNorthArrow.getAttributes().getNamedItem("DrawBackColor").getNodeValue()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return aLNA;
    }

    private LayoutGraphic loadLayoutGraphicElement(Node layoutGraphic) {
        Graphic aGraphic = new Graphic();
        Node graphicNode = ((Element)layoutGraphic).getElementsByTagName("Graphic").item(0);
        aGraphic.importFromXML((Element)graphicNode);
        LayoutGraphic aLG = aGraphic.getShape().getShapeType() == ShapeTypes.WindArraw ? new LayoutGraphic(aGraphic, this, this.getActiveLayoutMap()) : new LayoutGraphic(aGraphic, this);
        aLG.setIsTitle(Boolean.parseBoolean(layoutGraphic.getAttributes().getNamedItem("IsTitle").getNodeValue()));
        return aLG;
    }
}

