/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.layout;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import org.meteoinfo.global.PointF;
import org.meteoinfo.layout.LayoutElement;
import org.meteoinfo.layout.LayoutGraphic;
import org.meteoinfo.layout.MapLayout;

public class MapLayoutUndoRedo {

    class ResizeElementEdit
    extends AbstractUndoableEdit {
        MapLayout mapLayout;
        LayoutElement element;
        Rectangle oldRect;
        Rectangle newRect;

        public ResizeElementEdit(MapLayout mapLayout, LayoutElement element, Rectangle newRect) {
            this.mapLayout = mapLayout;
            this.element = element;
            this.newRect = (Rectangle)newRect.clone();
            this.oldRect = (Rectangle)element.getBounds().clone();
        }

        @Override
        public String getPresentationName() {
            return "Resize a Layout Element";
        }

        @Override
        public void undo() {
            super.undo();
            PointF minP = this.mapLayout.screenToPage((float)this.oldRect.x, (float)this.oldRect.y);
            PointF maxP = this.mapLayout.screenToPage((float)this.oldRect.x + (float)this.oldRect.width, (float)(this.oldRect.y + this.oldRect.height));
            this.element.setLeft((int)minP.X);
            this.element.setTop((int)minP.Y);
            this.element.setWidth((int)(maxP.X - minP.X));
            this.element.setHeight((int)(maxP.Y - minP.Y));
            this.element.resizeUpdate();
            this.mapLayout.paintGraphics();
        }

        @Override
        public void redo() {
            super.redo();
            PointF minP = this.mapLayout.screenToPage((float)this.newRect.x, (float)this.newRect.y);
            PointF maxP = this.mapLayout.screenToPage((float)this.newRect.x + (float)this.newRect.width, (float)(this.newRect.y + this.newRect.height));
            this.element.setLeft((int)minP.X);
            this.element.setTop((int)minP.Y);
            this.element.setWidth((int)(maxP.X - minP.X));
            this.element.setHeight((int)(maxP.Y - minP.Y));
            this.element.resizeUpdate();
            this.mapLayout.paintGraphics();
        }
    }

    class MoveGraphicVerticeEdit
    extends AbstractUndoableEdit {
        MapLayout mapLayout;
        LayoutGraphic lg;
        int verticeIdx;
        double newX;
        double newY;
        double oldX;
        double oldY;

        public MoveGraphicVerticeEdit(MapLayout mapLayout, LayoutGraphic lg, int vIdx, double newX, double newY) {
            this.mapLayout = mapLayout;
            this.lg = lg;
            this.verticeIdx = vIdx;
            this.newX = newX;
            this.newY = newY;
            this.oldX = lg.getGraphic().getShape().getPoints().get((int)vIdx).X;
            this.oldY = lg.getGraphic().getShape().getPoints().get((int)vIdx).Y;
        }

        @Override
        public String getPresentationName() {
            return "Move Grahic vertice";
        }

        @Override
        public void undo() {
            super.undo();
            this.lg.verticeEditUpdate(this.verticeIdx, this.oldX, this.oldY);
            this.mapLayout.paintGraphics();
        }

        @Override
        public void redo() {
            super.redo();
            this.lg.verticeEditUpdate(this.verticeIdx, this.newX, this.newY);
            this.mapLayout.paintGraphics();
        }
    }

    class MoveElementsEdit
    extends AbstractUndoableEdit {
        MapLayout mapLayout;
        List<LayoutElement> elements;
        int deltaX;
        int deltaY;

        public MoveElementsEdit(MapLayout mapLayout, List<LayoutElement> elements, int deltaX, int deltaY) {
            this.mapLayout = mapLayout;
            this.elements = new ArrayList<LayoutElement>(elements);
            this.deltaX = deltaX;
            this.deltaY = deltaY;
        }

        @Override
        public String getPresentationName() {
            return "Move a Layout Element";
        }

        @Override
        public void undo() {
            super.undo();
            for (LayoutElement element : this.elements) {
                element.setLeft(element.getLeft() - this.deltaX);
                element.setTop(element.getTop() - this.deltaY);
                element.moveUpdate();
            }
            this.mapLayout.paintGraphics();
        }

        @Override
        public void redo() {
            super.redo();
            for (LayoutElement element : this.elements) {
                element.setLeft(element.getLeft() + this.deltaX);
                element.setTop(element.getTop() + this.deltaY);
                element.moveUpdate();
            }
            this.mapLayout.paintGraphics();
        }
    }

    class MoveElementEdit
    extends AbstractUndoableEdit {
        MapLayout mapLayout;
        LayoutElement element;
        int deltaX;
        int deltaY;

        public MoveElementEdit(MapLayout mapLayout, LayoutElement element, int deltaX, int deltaY) {
            this.mapLayout = mapLayout;
            this.element = element;
            this.deltaX = deltaX;
            this.deltaY = deltaY;
        }

        @Override
        public String getPresentationName() {
            return "Move a Layout Element";
        }

        @Override
        public void undo() {
            super.undo();
            this.element.setLeft(this.element.getLeft() - this.deltaX);
            this.element.setTop(this.element.getTop() - this.deltaY);
            this.element.moveUpdate();
            this.mapLayout.paintGraphics();
        }

        @Override
        public void redo() {
            super.redo();
            this.element.setLeft(this.element.getLeft() + this.deltaX);
            this.element.setTop(this.element.getTop() + this.deltaY);
            this.element.moveUpdate();
            this.mapLayout.paintGraphics();
        }
    }

    public class RemoveElementsEdit
    extends AbstractUndoableEdit {
        MapLayout mapLayout;
        List<LayoutElement> elements;

        public RemoveElementsEdit(MapLayout mapLayout, List<LayoutElement> elements) {
            this.mapLayout = mapLayout;
            this.elements = new ArrayList<LayoutElement>(elements);
        }

        @Override
        public String getPresentationName() {
            return "Remove Layout Elements";
        }

        @Override
        public void undo() {
            super.undo();
            for (LayoutElement element : this.elements) {
                this.mapLayout.addElement(element);
            }
            this.mapLayout.paintGraphics();
        }

        @Override
        public void redo() {
            super.redo();
            for (LayoutElement element : this.elements) {
                this.mapLayout.removeElement(element);
            }
            this.mapLayout.paintGraphics();
        }
    }

    public class RemoveElementEdit
    extends AbstractUndoableEdit {
        MapLayout mapLayout;
        LayoutElement element;

        public RemoveElementEdit(MapLayout mapLayout, LayoutElement element) {
            this.mapLayout = mapLayout;
            this.element = element;
        }

        @Override
        public String getPresentationName() {
            return "Remove a Layout Element";
        }

        @Override
        public void undo() {
            super.undo();
            this.mapLayout.addElement(this.element);
            this.mapLayout.paintGraphics();
        }

        @Override
        public void redo() {
            super.redo();
            this.mapLayout.removeElement(this.element);
            this.mapLayout.paintGraphics();
        }
    }

    public class AddElementEdit
    extends AbstractUndoableEdit {
        MapLayout mapLayout;
        LayoutElement element;

        public AddElementEdit(MapLayout mapLayout, LayoutElement element) {
            this.mapLayout = mapLayout;
            this.element = element;
        }

        @Override
        public String getPresentationName() {
            return "Add a Layout Element";
        }

        @Override
        public void undo() {
            super.undo();
            this.mapLayout.removeElement(this.element);
            this.mapLayout.paintGraphics();
        }

        @Override
        public void redo() {
            super.redo();
            this.mapLayout.addElement(this.element);
            this.mapLayout.paintGraphics();
        }
    }
}

