/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.legend;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.meteoinfo.global.event.ISelectedCellChangedListener;
import org.meteoinfo.global.event.SelectedCellChangedEvent;
import org.meteoinfo.global.util.FontUtil;
import org.meteoinfo.global.util.GlobalUtil;
import org.meteoinfo.layout.MapLayout;
import org.meteoinfo.legend.LegendView;
import org.meteoinfo.legend.MapFrame;
import org.meteoinfo.legend.MarkerType;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.legend.PointStyle;
import org.meteoinfo.legend.SymbolControl;
import org.meteoinfo.map.MapView;

public class FrmPointSymbolSet
extends JDialog {
    private Object _parent = null;
    private PointBreak _pointBreak = null;
    private boolean isLoading = false;
    private String[] _imagePaths = null;
    private MarkerType _markerType = MarkerType.Simple;
    private JButton jButton_Apply;
    private JButton jButton_OK;
    private JCheckBox jCheckBox_DrawFill;
    private JCheckBox jCheckBox_DrawOutline;
    private JCheckBox jCheckBox_DrawShape;
    private JComboBox jComboBox_FontFamily;
    private JComboBox jComboBox_MarkerType;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel_Color;
    private JLabel jLabel_FillColor;
    private JLabel jLabel_FontFamily;
    private JLabel jLabel_OutlineColor;
    private JLabel jLabel_OutlineSize;
    private JPanel jPanel_Outline;
    private JSpinner jSpinner_Angle;
    private JSpinner jSpinner_OutlineSize;
    private JSpinner jSpinner_Size;
    private SymbolControl symbolControl1;

    public FrmPointSymbolSet(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("Point Symbol Set");
    }

    public FrmPointSymbolSet(Dialog parent, boolean modal, Object tparent) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("Point Symbol Set");
        if (tparent.getClass() == LegendView.class) {
            this.jButton_Apply.setVisible(false);
            this.jButton_OK.setVisible(false);
            this.setPreferredSize(new Dimension(this.getWidth(), this.getHeight() - 40));
        }
        this.symbolControl1.addSelectedCellChangedListener(new ISelectedCellChangedListener(){

            @Override
            public void selectedCellChangedEvent(SelectedCellChangedEvent event) {
                FrmPointSymbolSet.this.onSelectedCellChanged(event);
            }
        });
        this._parent = tparent;
    }

    public FrmPointSymbolSet(Frame parent, boolean modal, Object tparent) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("Point Symbol Set");
        if (tparent.getClass() == LegendView.class) {
            this.jButton_Apply.setVisible(false);
            this.jButton_OK.setVisible(false);
            this.setPreferredSize(new Dimension(this.getWidth(), this.getHeight() - 40));
        }
        this.symbolControl1.addSelectedCellChangedListener(new ISelectedCellChangedListener(){

            @Override
            public void selectedCellChangedEvent(SelectedCellChangedEvent event) {
                FrmPointSymbolSet.this.onSelectedCellChanged(event);
            }
        });
        this._parent = tparent;
    }

    private void onSelectedCellChanged(SelectedCellChangedEvent event) {
        if (this.isLoading) {
            return;
        }
        this._pointBreak.setMarkerType(this._markerType);
        switch (this._markerType) {
            case Character: {
                this._pointBreak.setCharIndex(this.symbolControl1.getSelectedCell());
                break;
            }
            case Image: {
                this._pointBreak.setImagePath(this._imagePaths[this.symbolControl1.getSelectedCell()]);
                break;
            }
            case Simple: {
                this._pointBreak.setStyle(PointStyle.values()[this.symbolControl1.getSelectedCell()]);
            }
        }
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_MarkerType(this._markerType);
            if (this._pointBreak.getMarkerType() == MarkerType.Image) {
                ((LegendView)this._parent).setLegendBreak_Image(this._imagePaths[this.symbolControl1.getSelectedCell()]);
            } else {
                ((LegendView)this._parent).setLegendBreak_MarkerIndex(this.symbolControl1.getSelectedCell());
            }
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBox_MarkerType = new JComboBox();
        this.jLabel_FontFamily = new JLabel();
        this.jComboBox_FontFamily = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jSpinner_Size = new JSpinner();
        this.jLabel_FillColor = new JLabel();
        this.jLabel_Color = new JLabel();
        this.jCheckBox_DrawShape = new JCheckBox();
        this.jCheckBox_DrawFill = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.jSpinner_Angle = new JSpinner();
        this.jPanel_Outline = new JPanel();
        this.jLabel7 = new JLabel();
        this.jLabel_OutlineColor = new JLabel();
        this.jCheckBox_DrawOutline = new JCheckBox();
        this.jLabel_OutlineSize = new JLabel();
        this.jSpinner_OutlineSize = new JSpinner();
        this.jButton_OK = new JButton();
        this.jButton_Apply = new JButton();
        this.symbolControl1 = new SymbolControl();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Marker Type:");
        this.jComboBox_MarkerType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_MarkerType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPointSymbolSet.this.jComboBox_MarkerTypeActionPerformed(evt);
            }
        });
        this.jLabel_FontFamily.setText("Font Family:");
        this.jComboBox_FontFamily.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_FontFamily.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPointSymbolSet.this.jComboBox_FontFamilyActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Size:");
        this.jSpinner_Size.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(100.0f), Float.valueOf(0.5f)));
        this.jSpinner_Size.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmPointSymbolSet.this.jSpinner_SizeStateChanged(evt);
            }
        });
        this.jLabel_FillColor.setText("Fill Color:");
        this.jLabel_Color.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel_Color.setOpaque(true);
        this.jLabel_Color.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmPointSymbolSet.this.jLabel_ColorMouseClicked(evt);
            }
        });
        this.jCheckBox_DrawShape.setText("Draw Shape");
        this.jCheckBox_DrawShape.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPointSymbolSet.this.jCheckBox_DrawShapeActionPerformed(evt);
            }
        });
        this.jCheckBox_DrawFill.setText("Draw Fill");
        this.jCheckBox_DrawFill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPointSymbolSet.this.jCheckBox_DrawFillActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Angle:");
        this.jSpinner_Angle.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(360.0f), Float.valueOf(0.5f)));
        this.jSpinner_Angle.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmPointSymbolSet.this.jSpinner_AngleStateChanged(evt);
            }
        });
        this.jPanel_Outline.setBorder(BorderFactory.createTitledBorder("Outline"));
        this.jPanel_Outline.setToolTipText("Outline");
        this.jPanel_Outline.setName("Outline");
        this.jLabel7.setText("Color:");
        this.jLabel_OutlineColor.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel_OutlineColor.setOpaque(true);
        this.jLabel_OutlineColor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmPointSymbolSet.this.jLabel_OutlineColorMouseClicked(evt);
            }
        });
        this.jCheckBox_DrawOutline.setText("Draw");
        this.jCheckBox_DrawOutline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPointSymbolSet.this.jCheckBox_DrawOutlineActionPerformed(evt);
            }
        });
        this.jLabel_OutlineSize.setText("Size:");
        this.jSpinner_OutlineSize.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(100.0f), Float.valueOf(0.5f)));
        this.jSpinner_OutlineSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmPointSymbolSet.this.jSpinner_OutlineSizeStateChanged(evt);
            }
        });
        GroupLayout jPanel_OutlineLayout = new GroupLayout(this.jPanel_Outline);
        this.jPanel_Outline.setLayout(jPanel_OutlineLayout);
        jPanel_OutlineLayout.setHorizontalGroup(jPanel_OutlineLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_OutlineLayout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBox_DrawOutline).addGap(18, 18, 18).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel_OutlineColor, -2, 48, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel_OutlineSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner_OutlineSize, -2, 51, -2).addContainerGap()));
        jPanel_OutlineLayout.setVerticalGroup(jPanel_OutlineLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_OutlineLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_OutlineLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel_OutlineLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_OutlineSize).addComponent(this.jSpinner_OutlineSize, -2, -1, -2)).addComponent(this.jLabel_OutlineColor, -2, 19, -2).addGroup(jPanel_OutlineLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jCheckBox_DrawOutline))).addContainerGap(11, Short.MAX_VALUE)));
        this.jButton_OK.setText("OK");
        this.jButton_OK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPointSymbolSet.this.jButton_OKActionPerformed(evt);
            }
        });
        this.jButton_Apply.setText("Apply");
        this.jButton_Apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPointSymbolSet.this.jButton_ApplyActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(28, 28, 28).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel_FontFamily).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBox_MarkerType, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox_FontFamily, -2, 156, -2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel_Outline, -1, -1, Short.MAX_VALUE).addComponent(this.symbolControl1, -1, -1, Short.MAX_VALUE)))).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner_Size, -2, 60, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner_Angle, -2, 60, -2).addGap(34, 34, 34).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox_DrawShape).addComponent(this.jCheckBox_DrawFill).addGroup(layout.createSequentialGroup().addComponent(this.jLabel_FillColor).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel_Color, -2, 59, -2))))).addContainerGap(24, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButton_OK, -2, 71, -2).addGap(58, 58, 58).addComponent(this.jButton_Apply, -2, 81, -2).addGap(46, 46, 46)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox_MarkerType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_FontFamily).addComponent(this.jComboBox_FontFamily, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.symbolControl1, -2, 156, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBox_DrawShape).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox_DrawFill).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_FillColor).addComponent(this.jLabel_Color, -2, 19, -2))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jSpinner_Angle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jSpinner_Size, -2, -1, -2)).addGap(4, 4, 4))).addComponent(this.jPanel_Outline, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_OK).addComponent(this.jButton_Apply)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jSpinner_SizeStateChanged(ChangeEvent evt) {
        if (this.isLoading) {
            return;
        }
        float size = Float.parseFloat(this.jSpinner_Size.getValue().toString());
        this._pointBreak.setSize(size);
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_Size(size);
        }
    }

    private void jLabel_ColorMouseClicked(MouseEvent evt) {
        Color aColor = JColorChooser.showDialog(this.rootPane, null, this.jLabel_Color.getBackground());
        this.jLabel_Color.setBackground(aColor);
        this._pointBreak.setColor(aColor);
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_Color(aColor);
        }
    }

    private void jCheckBox_DrawShapeActionPerformed(ActionEvent evt) {
        if (this.isLoading) {
            return;
        }
        this._pointBreak.setDrawShape(this.jCheckBox_DrawShape.isSelected());
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_DrawShape(this.jCheckBox_DrawShape.isSelected());
        }
    }

    private void jCheckBox_DrawFillActionPerformed(ActionEvent evt) {
        if (this.isLoading) {
            return;
        }
        this._pointBreak.setDrawFill(this.jCheckBox_DrawFill.isSelected());
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_DrawFill(this.jCheckBox_DrawFill.isSelected());
        }
    }

    private void jSpinner_AngleStateChanged(ChangeEvent evt) {
        if (this.isLoading) {
            return;
        }
        float angle = Float.parseFloat(this.jSpinner_Angle.getValue().toString());
        this._pointBreak.setAngle(angle);
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_Angle(angle);
        }
    }

    private void jLabel_OutlineColorMouseClicked(MouseEvent evt) {
        Color aColor = JColorChooser.showDialog(this.rootPane, null, this.jLabel_OutlineColor.getBackground());
        this.jLabel_OutlineColor.setBackground(aColor);
        this._pointBreak.setOutlineColor(aColor);
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_OutlineColor(aColor);
        }
    }

    private void jCheckBox_DrawOutlineActionPerformed(ActionEvent evt) {
        if (this.isLoading) {
            return;
        }
        this._pointBreak.setDrawOutline(this.jCheckBox_DrawOutline.isSelected());
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_DrawOutline(this.jCheckBox_DrawOutline.isSelected());
        }
    }

    private void jComboBox_MarkerTypeActionPerformed(ActionEvent evt) {
        if (this.jComboBox_MarkerType.getItemCount() == 0) {
            return;
        }
        switch (MarkerType.valueOf(this.jComboBox_MarkerType.getSelectedItem().toString())) {
            case Simple: {
                this.updateSimpleTab();
                this._markerType = MarkerType.Simple;
                break;
            }
            case Character: {
                this.updateCharacterTab();
                this._markerType = MarkerType.Character;
                break;
            }
            case Image: {
                this.updateImageTab();
                this._markerType = MarkerType.Image;
            }
        }
    }

    private void jComboBox_FontFamilyActionPerformed(ActionEvent evt) {
        if (this.jComboBox_FontFamily.getItemCount() == 0) {
            return;
        }
        Font aFont = new Font(this.jComboBox_FontFamily.getSelectedItem().toString(), 0, 10);
        this.symbolControl1.setFont(aFont);
        this.symbolControl1.setSelectedCell(this._pointBreak.getCharIndex());
        this.symbolControl1.repaint();
        this._pointBreak.setFontName(aFont.getFontName());
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_FontName(aFont.getFontName());
        }
    }

    private void jButton_ApplyActionPerformed(ActionEvent evt) {
        if (this._parent.getClass() == MapView.class) {
            ((MapView)this._parent).paintLayers();
        } else if (this._parent.getClass() == MapLayout.class) {
            ((MapLayout)this._parent).paintGraphics();
        }
    }

    private void jButton_OKActionPerformed(ActionEvent evt) {
        if (this._parent.getClass() == MapView.class) {
            ((MapView)this._parent).setDefPointBreak(this._pointBreak);
            ((MapView)this._parent).paintLayers();
        } else if (this._parent.getClass() == MapLayout.class) {
            ((MapLayout)this._parent).setDefPointBreak(this._pointBreak);
            ((MapLayout)this._parent).paintGraphics();
        }
        this.dispose();
    }

    private void jSpinner_OutlineSizeStateChanged(ChangeEvent evt) {
        if (this.isLoading) {
            return;
        }
        float size = Float.parseFloat(this.jSpinner_OutlineSize.getValue().toString());
        this._pointBreak.setOutlineSize(size);
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_OutlineSize(size);
        }
    }

    public void setPointBreak(PointBreak pb) {
        this._pointBreak = pb;
        this.updateProperties();
    }

    private void updateProperties() {
        this.isLoading = true;
        this.jLabel_Color.setBackground(this._pointBreak.getColor());
        this.jSpinner_Size.setValue(Float.valueOf(this._pointBreak.getSize()));
        this.jCheckBox_DrawOutline.setSelected(this._pointBreak.isDrawOutline());
        this.jLabel_OutlineColor.setBackground(this._pointBreak.getOutlineColor());
        this.jSpinner_OutlineSize.setValue(Float.valueOf(this._pointBreak.getOutlineSize()));
        this.jCheckBox_DrawShape.setSelected(this._pointBreak.isDrawShape());
        this.jCheckBox_DrawFill.setSelected(this._pointBreak.isDrawFill());
        this.jSpinner_Angle.setValue(Float.valueOf(this._pointBreak.getAngle()));
        this.jComboBox_MarkerType.removeAllItems();
        for (MarkerType t : MarkerType.values()) {
            this.jComboBox_MarkerType.addItem(t.toString());
        }
        this.jComboBox_MarkerType.setSelectedItem(this._pointBreak.getMarkerType().toString());
        this.isLoading = false;
    }

    private void updateSimpleTab() {
        this.symbolControl1.setMarkerType(MarkerType.Simple);
        this.symbolControl1.setSymbolNumber(PointStyle.values().length);
        this.jLabel_FontFamily.setEnabled(false);
        this.jComboBox_FontFamily.removeAllItems();
        this.jComboBox_FontFamily.setEditable(false);
        this.jPanel_Outline.setEnabled(true);
        this.jSpinner_OutlineSize.setEnabled(true);
        this.jLabel_FillColor.setEnabled(true);
        this.jLabel_Color.setEnabled(true);
        this.jCheckBox_DrawFill.setEnabled(true);
    }

    private void updateCharacterTab() {
        this.symbolControl1.setMarkerType(MarkerType.Character);
        this.symbolControl1.setSymbolNumber(256);
        this.jLabel_FontFamily.setEnabled(true);
        this.jComboBox_FontFamily.setEditable(true);
        this.jPanel_Outline.setEnabled(false);
        this.jSpinner_OutlineSize.setEnabled(false);
        this.jLabel_FillColor.setEnabled(true);
        this.jLabel_Color.setEnabled(true);
        this.jCheckBox_DrawFill.setEnabled(false);
        this.jComboBox_FontFamily.removeAllItems();
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fonts = gEnv.getAvailableFontFamilyNames();
        Font weatherFont = FontUtil.getWeatherFont();
        if (weatherFont != null) {
            this.jComboBox_FontFamily.addItem(weatherFont.getFontName());
        }
        for (String ff : fonts) {
            this.jComboBox_FontFamily.addItem(ff);
        }
        this.jComboBox_FontFamily.setSelectedItem(this._pointBreak.getFontName());
    }

    private void updateImageTab() {
        this.symbolControl1.setMarkerType(MarkerType.Image);
        this.jLabel_FontFamily.setEnabled(false);
        this.jComboBox_FontFamily.removeAllItems();
        this.jComboBox_FontFamily.setEditable(false);
        this.jPanel_Outline.setEnabled(false);
        this.jSpinner_OutlineSize.setEnabled(false);
        this.jLabel_FillColor.setEnabled(false);
        this.jLabel_Color.setEnabled(false);
        this.jCheckBox_DrawFill.setEnabled(false);
        if (this._imagePaths == null) {
            String fn = GlobalUtil.getAppPath(MapFrame.class);
            String path = (fn = fn.substring(0, fn.lastIndexOf("/"))) + File.separator + "image";
            File pathDir = new File(path);
            if (!pathDir.isDirectory()) {
                return;
            }
            File[] files = pathDir.listFiles();
            this._imagePaths = new String[files.length];
            ArrayList<Image> imageList = new ArrayList<Image>();
            int i = 0;
            for (File aFile : files) {
                this._imagePaths[i] = aFile.getAbsolutePath();
                try {
                    imageList.add(ImageIO.read(aFile));
                }
                catch (IOException ex) {
                    Logger.getLogger(FrmPointSymbolSet.class.getName()).log(Level.SEVERE, null, ex);
                }
                ++i;
            }
            this.symbolControl1.setIamgeList(imageList);
        } else {
            this.symbolControl1.setSymbolNumber(this._imagePaths.length);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmPointSymbolSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmPointSymbolSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmPointSymbolSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmPointSymbolSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmPointSymbolSet dialog = new FrmPointSymbolSet((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

