/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.legend;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.layer.LayerTypes;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.legend.ChartBreak;
import org.meteoinfo.legend.Constants;
import org.meteoinfo.legend.ItemNode;
import org.meteoinfo.legend.LegendNode;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.MapFrame;
import org.meteoinfo.legend.NodeTypes;
import org.meteoinfo.shape.ShapeTypes;

public class LayerNode
extends ItemNode {
    private MapLayer _mapLayer = null;
    private int _groupHandle = -1;
    private final List<LegendNode> _legendNodes = new ArrayList<LegendNode>();
    private MapFrame _mapFrame = null;
    private boolean editing = false;

    public LayerNode(MapLayer aLayer) {
        this._mapLayer = aLayer;
        this.setText(aLayer.getLayerName());
        this.setChecked(aLayer.isVisible());
        this.setNodeType(NodeTypes.LayerNode);
    }

    public MapFrame getMapFrame() {
        return this._mapFrame;
    }

    public void setMapFrame(MapFrame mf) {
        this._mapFrame = mf;
    }

    public int getLayerHandle() {
        return this._mapLayer.getHandle();
    }

    public MapLayer getMapLayer() {
        return this._mapLayer;
    }

    public void setMapLayer(MapLayer layer) {
        this._mapLayer = layer;
    }

    public LegendScheme getLegendScheme() {
        return this._mapLayer.getLegendScheme();
    }

    public ShapeTypes getShapeType() {
        return this._mapLayer.getShapeType();
    }

    public List<LegendNode> getLegendNodes() {
        return this._legendNodes;
    }

    public int getGroupHandle() {
        return this._groupHandle;
    }

    public void setGroupHandle(int handle) {
        this._groupHandle = handle;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean value) {
        this.editing = value;
        if (this._mapLayer.getLayerType() == LayerTypes.VectorLayer) {
            ((VectorLayer)this._mapLayer).setEditing(value);
        }
    }

    public void update() {
        this.setText(this._mapLayer.getLayerName());
        this.setChecked(this._mapLayer.isVisible());
        this.updateLegendScheme(this._mapLayer.getLegendScheme());
    }

    public void updateLegendScheme(LegendScheme aLS) {
        if (aLS == null) {
            this._legendNodes.clear();
            return;
        }
        switch (this._mapLayer.getLayerType()) {
            case VectorLayer: 
            case RasterLayer: {
                VectorLayer aLayer;
                this._legendNodes.clear();
                for (int i = 0; i < aLS.getBreakNum(); ++i) {
                    if (!aLS.getLegendBreaks().get(i).isDrawShape()) continue;
                    LegendNode aTN = new LegendNode();
                    aTN.setShapeType(this.getShapeType());
                    aTN.setLegendBreak(aLS.getLegendBreaks().get(i));
                    this._legendNodes.add(aTN);
                }
                if (this._mapLayer.getLayerType() != LayerTypes.VectorLayer || !(aLayer = (VectorLayer)this._mapLayer).getChartSet().isDrawCharts() || aLayer.getChartPoints().size() <= 0) break;
                LegendNode aLN = new LegendNode();
                aLN.setShapeType(ShapeTypes.Polygon);
                ChartBreak aCB = ((ChartBreak)aLayer.getChartPoints().get(0).getLegend()).getSampleChartBreak();
                aLN.setLegendBreak(aCB);
                aLN.setHeight(((ChartBreak)aLN.getLegendBreak()).getHeight() + 10);
                this._legendNodes.add(aLN);
                for (int i = 0; i < aLayer.getChartSet().getLegendScheme().getBreakNum(); ++i) {
                    aLN = new LegendNode();
                    aLN.setShapeType(ShapeTypes.Polygon);
                    aLN.setLegendBreak(aLayer.getChartSet().getLegendScheme().getLegendBreaks().get(i));
                    this._legendNodes.add(aLN);
                }
                break;
            }
        }
    }

    @Override
    public int getDrawHeight() {
        if (this.isExpanded()) {
            return this.getExpandedHeight();
        }
        return this.getHeight();
    }

    @Override
    public int getExpandedHeight() {
        int height = this.getHeight();
        for (LegendNode legNode : this._legendNodes) {
            height += legNode.getHeight() + Constants.ITEM_PAD;
        }
        return height;
    }

    public Object clone() throws CloneNotSupportedException {
        LayerNode aLN = new LayerNode((MapLayer)this._mapLayer.clone());
        if (this.isExpanded()) {
            aLN.expand();
        }
        if (this._legendNodes.size() > 0) {
            for (LegendNode aLegNode : this._legendNodes) {
                aLN.getLegendNodes().add((LegendNode)aLegNode.clone());
            }
        }
        return aLN;
    }
}

