/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.astro;

public class Sun2000 {
    double T;
    double DL = 0.0;
    double DR = 0.0;
    double DB = 0.0;
    double[] C3 = new double[9];
    double[] S3 = new double[9];
    double[] C = new double[9];
    double[] S = new double[9];
    double u = 0.0;
    double v = 0.0;

    public double[] run(double t2000) {
        double[] rr;
        int i;
        double P2 = 8.0 * Math.atan(1.0);
        this.T = t2000;
        double M2 = P2 * Sun2000.dfrac(0.1387306 + 162.5485917 * this.T);
        double M3 = P2 * Sun2000.dfrac(0.9931266 + 99.9973604 * this.T);
        double M4 = P2 * Sun2000.dfrac(0.054325 + 53.1666028 * this.T);
        double M5 = P2 * Sun2000.dfrac(0.055175 + 8.4293972 * this.T);
        double M6 = P2 * Sun2000.dfrac(0.88165 + 3.3938722 * this.T);
        double D = P2 * Sun2000.dfrac(0.8274 + 1236.8531 * this.T);
        double A = P2 * Sun2000.dfrac(0.3749 + 1325.5524 * this.T);
        double UU = P2 * Sun2000.dfrac(0.2591 + 1342.2278 * this.T);
        this.C3[1] = 1.0;
        this.C3[2] = Math.cos(M3);
        this.C3[0] = this.C3[2];
        this.S3[1] = 0.0;
        this.S3[2] = Math.sin(M3);
        this.S3[0] = -this.S3[2];
        for (i = 2; i <= 7; ++i) {
            rr = this.addThe(this.C3[i], this.S3[i], this.C3[2], this.S3[2]);
            this.C3[i + 1] = rr[0];
            this.S3[i + 1] = rr[1];
        }
        this.C[8] = 1.0;
        this.S[8] = 0.0;
        this.S[7] = -Math.sin(M2);
        for (i = 7; i >= 3; --i) {
            rr = this.addThe(this.C[i], this.S[i], this.C[7], this.S[7]);
            this.C[i - 1] = rr[0];
            this.S[i - 1] = rr[1];
        }
        this.term(1, 0, 0, -0.22, 6892.76, -16707.37, -0.54, 0.0, 0.0);
        this.term(1, -2, 0, -1.66, 0.62, 0.16, 0.28, 0.0, 0.0);
        this.term(2, -2, 0, 1.96, 0.57, -1.32, 4.55, 0.0, 0.01);
        this.term(2, -3, 0, 0.4, 0.15, -0.17, 0.46, 0.0, 0.0);
        this.term(2, -4, 0, 0.53, 0.26, 0.09, -0.22, 0.0, 0.0);
        this.term(3, -3, 0, 0.05, 0.12, -0.35, 0.15, 0.0, 0.0);
        this.term(3, -4, 0, -0.13, -0.48, 1.06, -0.29, 0.01, 0.0);
        this.term(3, -5, 0, -0.04, -0.2, 0.2, -0.04, 0.0, 0.0);
        this.term(4, -4, 0, 0.0, -0.03, 0.1, 0.04, 0.0, 0.0);
        this.term(4, -5, 0, 0.05, -0.07, 0.2, 0.14, 0.0, 0.0);
        this.term(4, -6, 0, -0.1, 0.11, -0.23, -0.22, 0.0, 0.0);
        this.term(5, -7, 0, -0.05, 0.0, 0.01, -0.14, 0.0, 0.0);
        this.term(5, -8, 0, 0.05, 0.01, -0.02, 0.1, 0.0, 0.0);
        this.C[7] = Math.cos(M4);
        this.S[7] = -Math.sin(M4);
        for (i = 7; i >= 1; --i) {
            rr = this.addThe(this.C[i], this.S[i], this.C[7], this.S[7]);
            this.C[i - 1] = rr[0];
            this.S[i - 1] = rr[1];
        }
        this.term(1, -1, 0, -0.22, 0.17, -0.21, -0.27, 0.0, 0.0);
        this.term(1, -2, 0, -1.66, 0.62, 0.16, 0.28, 0.0, 0.0);
        this.term(2, -2, 0, 1.96, 0.57, -1.32, 4.55, 0.0, 0.01);
        this.term(2, -3, 0, 0.4, 0.15, -0.17, 0.46, 0.0, 0.0);
        this.term(2, -4, 0, 0.53, 0.26, 0.09, -0.22, 0.0, 0.0);
        this.term(3, -3, 0, 0.05, 0.12, -0.35, 0.15, 0.0, 0.0);
        this.term(3, -4, 0, -0.13, -0.48, 1.06, -0.29, 0.01, 0.0);
        this.term(3, -5, 0, -0.04, -0.2, 0.2, -0.04, 0.0, 0.0);
        this.term(4, -4, 0, 0.0, -0.03, 0.1, 0.04, 0.0, 0.0);
        this.term(4, -5, 0, 0.05, -0.07, 0.2, 0.14, 0.0, 0.0);
        this.term(4, -6, 0, -0.1, 0.11, -0.23, -0.22, 0.0, 0.0);
        this.term(5, -7, 0, -0.05, 0.0, 0.01, -0.14, 0.0, 0.0);
        this.term(5, -8, 0, 0.05, 0.01, -0.02, 0.1, 0.0, 0.0);
        this.C[7] = Math.cos(M5);
        this.S[7] = -Math.sin(M5);
        for (i = 7; i >= 5; --i) {
            rr = this.addThe(this.C[i], this.S[i], this.C[7], this.S[7]);
            this.C[i - 1] = rr[0];
            this.S[i - 1] = rr[1];
        }
        this.term(1, -1, 0, 0.01, 0.07, 0.18, -0.02, 0.0, -0.02);
        this.term(0, -1, 0, -0.31, 2.58, 0.52, 0.34, 0.02, 0.0);
        this.term(1, -1, 0, -7.21, -0.06, 0.13, -16.27, 0.0, -0.02);
        this.term(1, -2, 0, -0.54, -1.52, 3.09, -1.12, 0.01, -0.17);
        this.term(1, -3, 0, -0.03, -0.21, 0.38, -0.06, 0.0, -0.02);
        this.term(2, -1, 0, -0.16, 0.05, -0.18, -0.31, 0.01, 0.0);
        this.term(2, -2, 0, 0.14, -2.73, 9.23, 0.48, 0.0, 0.0);
        this.term(2, -3, 0, 0.07, -0.55, 1.83, 0.25, 0.01, 0.0);
        this.term(2, -4, 0, 0.02, -0.08, 0.25, 0.06, 0.0, 0.0);
        this.term(3, -2, 0, 0.01, -0.07, 0.16, 0.04, 0.0, 0.0);
        this.term(3, -3, 0, -0.16, -0.03, 0.08, -0.64, 0.0, 0.0);
        this.term(3, -4, 0, -0.04, -0.01, 0.03, -0.17, 0.0, 0.0);
        this.C[7] = Math.cos(M6);
        this.S[7] = -Math.sin(M6);
        rr = this.addThe(this.C[7], this.S[7], this.C[7], this.S[7]);
        this.C[6] = rr[0];
        this.S[6] = rr[0];
        this.term(0, -1, 0, 0.0, 0.32, 0.01, 0.0, 0.0, 0.0);
        this.term(1, -1, 0, -0.08, -0.41, 0.97, -0.18, 0.0, -0.01);
        this.term(1, -2, 0, 0.04, 0.1, -0.23, 0.1, 0.0, 0.0);
        this.term(2, -2, 0, 0.04, 0.1, -0.35, 0.13, 0.0, 0.0);
        this.DL = this.DL + 6.45 * Math.sin(D) - 0.42 * Math.sin(D - A) + 0.18 * Math.sin(D + A) + 0.17 * Math.sin(D - M3) - 0.06 * Math.sin(D + M3);
        this.DR = this.DR + 30.76 * Math.cos(D) - 3.06 * Math.cos(D - A) + 0.85 * Math.cos(D + A) - 0.58 * Math.cos(D + M3) + 0.57 * Math.cos(D - M3);
        this.DB += 0.576 * Math.sin(UU);
        this.DL = this.DL + 6.4 * Math.sin(P2 * (0.6983 + 0.0561 * this.T)) + 1.87 * Math.sin(P2 * (0.5764 + 0.4174 * this.T)) + 0.27 * Math.sin(P2 * (0.4189 + 0.3306 * this.T)) + 0.2 * Math.sin(P2 * (0.3581 + 2.4814 * this.T));
        double L = 360.0 * Sun2000.dfrac(0.7859453 + M3 / P2 + ((6191.2 + 1.1 * this.T) * this.T + this.DL) / 1296000.0);
        double R = 1.0001398 - 7.0E-7 * this.T + this.DR * 1.0E-6;
        double B = this.DB / 3600.0;
        return new double[]{B, L, R};
    }

    private static double dfrac(double x) {
        double df = x % 1.0;
        return df;
    }

    private double[] addThe(double C1, double S1, double C2, double S2) {
        double C = C1 * C2 - S1 * S2;
        double S = S1 * C2 + C1 * S2;
        return new double[]{C, S};
    }

    private void term(int i1, int i, int it, double DLC, double DLS, double DRC, double DRS, double DBC, double DBS) {
        ++i1;
        i += 8;
        if (it == 0) {
            double[] rr = this.addThe(this.C3[i1], this.S3[i1], this.C[i], this.S[i]);
            this.u = rr[0];
            this.v = rr[1];
        } else {
            this.u *= this.T;
            this.v *= this.T;
        }
        this.DL = this.DL + DLC * this.u + DLS * this.v;
        this.DR = this.DR + DRC * this.u + DRS * this.v;
        this.DB = this.DB + DBC * this.u + DBS * this.v;
    }
}

