/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.linalg;

import java.util.List;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresBuilder;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math3.fitting.leastsquares.LevenbergMarquardtOptimizer;
import org.apache.commons.math3.fitting.leastsquares.MultivariateJacobianFunction;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.apache.commons.math3.util.Pair;
import org.ejml.data.Complex_F64;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleEVD;
import org.ejml.simple.SimpleMatrix;
import org.ejml.simple.SimpleSVD;
import org.meteoinfo.data.ArrayUtil;
import org.meteoinfo.math.Complex;
import ucar.ma2.Array;
import ucar.ma2.DataType;

public class LinalgUtil {
    public static Array solve(Array a, Array b) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])b.getShape());
        double[][] aa = (double[][])ArrayUtil.copyToNDJavaArray(a);
        Array2DRowRealMatrix coefficients = new Array2DRowRealMatrix(aa, false);
        DecompositionSolver solver = new LUDecomposition((RealMatrix)coefficients).getSolver();
        double[] bb = (double[])ArrayUtil.copyToNDJavaArray(b);
        ArrayRealVector constants = new ArrayRealVector(bb, false);
        RealVector solution = solver.solve((RealVector)constants);
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, solution.getEntry(i));
            ++i;
        }
        return r;
    }

    public static Array cholesky(Array a) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])a.getShape());
        double[][] aa = (double[][])ArrayUtil.copyToNDJavaArray(a);
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(aa, false);
        CholeskyDecomposition decomposition = new CholeskyDecomposition((RealMatrix)matrix);
        RealMatrix L = decomposition.getL();
        int n = L.getColumnDimension();
        int m = L.getRowDimension();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                r.setDouble(i * n + j, L.getEntry(i, j));
            }
        }
        return r;
    }

    public static Array[] lu(Array a) {
        Array Pa = Array.factory((DataType)DataType.DOUBLE, (int[])a.getShape());
        Array La = Array.factory((DataType)DataType.DOUBLE, (int[])a.getShape());
        Array Ua = Array.factory((DataType)DataType.DOUBLE, (int[])a.getShape());
        double[][] aa = (double[][])ArrayUtil.copyToNDJavaArray(a);
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(aa, false);
        LUDecomposition decomposition = new LUDecomposition((RealMatrix)matrix);
        RealMatrix P = decomposition.getP();
        RealMatrix L = decomposition.getL();
        RealMatrix U = decomposition.getU();
        int n = L.getColumnDimension();
        int m = L.getRowDimension();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                Pa.setDouble(i * n + j, P.getEntry(i, j));
                La.setDouble(i * n + j, L.getEntry(i, j));
                Ua.setDouble(i * n + j, U.getEntry(i, j));
            }
        }
        return new Array[]{Pa, La, Ua};
    }

    public static Array[] qr(Array a) {
        int j;
        int i;
        int m = a.getShape()[0];
        int n = a.getShape()[1];
        Array Qa = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{m, m});
        Array Ra = Array.factory((DataType)DataType.DOUBLE, (int[])a.getShape());
        double[][] aa = (double[][])ArrayUtil.copyToNDJavaArray(a);
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(aa, false);
        QRDecomposition decomposition = new QRDecomposition((RealMatrix)matrix);
        RealMatrix Q = decomposition.getQ();
        RealMatrix R = decomposition.getR();
        for (i = 0; i < m; ++i) {
            for (j = 0; j < m; ++j) {
                Qa.setDouble(i * m + j, Q.getEntry(i, j));
            }
        }
        for (i = 0; i < m; ++i) {
            for (j = 0; j < n; ++j) {
                Ra.setDouble(i * n + j, R.getEntry(i, j));
            }
        }
        return new Array[]{Qa, Ra};
    }

    public static Array[] svd(Array a) {
        int j;
        int i;
        int m = a.getShape()[0];
        int n = a.getShape()[1];
        int k = Math.min(m, n);
        Array Ua = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{m, k});
        Array Va = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{k, n});
        Array Sa = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{k});
        double[][] aa = (double[][])ArrayUtil.copyToNDJavaArray(a);
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(aa, false);
        SingularValueDecomposition decomposition = new SingularValueDecomposition((RealMatrix)matrix);
        RealMatrix U = decomposition.getU();
        RealMatrix V = decomposition.getVT();
        double[] sv = decomposition.getSingularValues();
        for (i = 0; i < m; ++i) {
            for (j = 0; j < k; ++j) {
                Ua.setDouble(i * k + j, U.getEntry(i, j));
            }
        }
        for (i = 0; i < k; ++i) {
            for (j = 0; j < n; ++j) {
                Va.setDouble(i * n + j, V.getEntry(i, j));
            }
        }
        for (i = 0; i < k; ++i) {
            Sa.setDouble(i, sv[i]);
        }
        return new Array[]{Ua, Sa, Va};
    }

    public static Array[] svd_EJML(Array a) {
        int j;
        int i;
        int m = a.getShape()[0];
        int n = a.getShape()[1];
        int k = Math.min(m, n);
        double[][] aa = (double[][])ArrayUtil.copyToNDJavaArray(a);
        SimpleMatrix M = new SimpleMatrix(aa);
        SimpleSVD svd = M.svd(false);
        Array Ua = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{m, m});
        Array Va = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n, n});
        Array Sa = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{k});
        SimpleBase U = svd.getU();
        SimpleBase V = svd.getV();
        for (i = 0; i < m; ++i) {
            for (j = 0; j < m; ++j) {
                Ua.setDouble(i * m + j, U.get(i, j));
            }
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                Va.setDouble(j * n + i, V.get(i, j));
            }
        }
        for (i = 0; i < k; ++i) {
            Sa.setDouble(i, svd.getSingleValue(i));
        }
        return new Array[]{Ua, Sa, Va};
    }

    public static Array[] eigen_bak(Array a) {
        Array Wa;
        int m = a.getShape()[0];
        Array Va = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{m, m});
        double[][] aa = (double[][])ArrayUtil.copyToNDJavaArray(a);
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(aa, false);
        EigenDecomposition decomposition = new EigenDecomposition((RealMatrix)matrix);
        if (decomposition.hasComplexEigenvalues()) {
            Wa = Array.factory((DataType)DataType.OBJECT, (int[])new int[]{m});
            double[] rev = decomposition.getRealEigenvalues();
            double[] iev = decomposition.getImagEigenvalues();
            for (int i = 0; i < m; ++i) {
                Wa.setObject(i, (Object)new Complex(rev[i], iev[i]));
                RealVector v = decomposition.getEigenvector(i);
                for (int j = 0; j < v.getDimension(); ++j) {
                    Va.setDouble(j * m + i, v.getEntry(j));
                }
            }
        } else {
            RealMatrix V = decomposition.getV();
            RealMatrix D = decomposition.getD();
            Wa = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{m});
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < m; ++j) {
                    Va.setDouble(i * m + (m - j - 1), V.getEntry(i, j));
                    if (i != j) continue;
                    Wa.setDouble(m - i - 1, D.getEntry(i, j));
                }
            }
        }
        return new Array[]{Wa, Va};
    }

    public static Array[] eigen(Array a) {
        Array Wa;
        int m = a.getShape()[0];
        Array Va = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{m, m});
        double[][] aa = (double[][])ArrayUtil.copyToNDJavaArray(a);
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(aa, false);
        EigenDecomposition decomposition = new EigenDecomposition((RealMatrix)matrix);
        double[] rev = decomposition.getRealEigenvalues();
        double[] iev = decomposition.getImagEigenvalues();
        if (decomposition.hasComplexEigenvalues()) {
            Wa = Array.factory((DataType)DataType.OBJECT, (int[])new int[]{m});
            for (int i = 0; i < m; ++i) {
                Wa.setObject(i, (Object)new Complex(rev[i], iev[i]));
                RealVector v = decomposition.getEigenvector(i);
                for (int j = 0; j < v.getDimension(); ++j) {
                    Va.setDouble(j * m + i, v.getEntry(j));
                }
            }
        } else {
            Wa = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{m});
            for (int i = 0; i < m; ++i) {
                Wa.setDouble(i, rev[m - i - 1]);
                RealVector v = decomposition.getEigenvector(m - i - 1);
                for (int j = 0; j < v.getDimension(); ++j) {
                    Va.setDouble(j * m + i, v.getEntry(j));
                }
            }
        }
        return new Array[]{Wa, Va};
    }

    public static Array[] eigen_EJML(Array a) {
        int m = a.getShape()[0];
        Array Va = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{m, m});
        double[][] aa = (double[][])ArrayUtil.copyToNDJavaArray(a);
        SimpleMatrix M = new SimpleMatrix(aa);
        SimpleEVD evd = M.eig();
        List evs = evd.getEigenvalues();
        boolean isComplex = evd.getEigenVector(0) == null;
        Array Wa = isComplex ? Array.factory((DataType)DataType.OBJECT, (int[])new int[]{m}) : Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{m});
        for (int i = 0; i < m; ++i) {
            if (isComplex) {
                Wa.setObject(i, (Object)new Complex(((Complex_F64)evs.get((int)i)).real, ((Complex_F64)evs.get((int)i)).imaginary));
                continue;
            }
            Wa.setDouble(i, ((Complex_F64)evs.get((int)(m - i - 1))).real);
            SimpleBase v = evd.getEigenVector(m - i - 1);
            for (int j = 0; j < v.getNumElements(); ++j) {
                Va.setDouble(j * m + i, v.get(j));
            }
        }
        return new Array[]{Wa, Va};
    }

    public static Array inv(Array a) {
        double[][] aa = (double[][])ArrayUtil.copyToNDJavaArray(a);
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(aa, false);
        RealMatrix invm = MatrixUtils.inverse((RealMatrix)matrix);
        if (invm == null) {
            return null;
        }
        int m = invm.getRowDimension();
        int n = invm.getColumnDimension();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{m, n});
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                r.setDouble(i * n + j, invm.getEntry(i, j));
            }
        }
        return r;
    }

    public static Array lstsq(Array a, Array b) {
        final double[][] aa = (double[][])ArrayUtil.copyToNDJavaArray(a);
        final double[] bb = (double[])ArrayUtil.copyToNDJavaArray(b);
        MultivariateJacobianFunction function = new MultivariateJacobianFunction(){

            public Pair<RealVector, RealMatrix> value(RealVector point) {
                ArrayRealVector value = new ArrayRealVector(bb.length);
                Array2DRowRealMatrix jacobian = new Array2DRowRealMatrix(aa, false);
                for (int i = 0; i < bb.length; ++i) {
                }
                return new Pair((Object)value, (Object)jacobian);
            }
        };
        LeastSquaresProblem problem = new LeastSquaresBuilder().model(function).target(bb).lazyEvaluation(false).maxEvaluations(1000).maxIterations(1000).build();
        LeastSquaresOptimizer.Optimum optimum = new LevenbergMarquardtOptimizer().optimize(problem);
        RealVector r = optimum.getPoint();
        int n = r.getDimension();
        Array x = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
        for (int i = 0; i < n; ++i) {
            x.setDouble(i, r.getEntry(i));
        }
        return x;
    }

    public static void getCofactor(double[][] mat, double[][] temp, int p, int q, int n) {
        int i = 0;
        int j = 0;
        for (int row = 0; row < n; ++row) {
            for (int col = 0; col < n; ++col) {
                if (row == p || col == q) continue;
                temp[i][j++] = mat[row][col];
                if (j != n - 1) continue;
                j = 0;
                ++i;
            }
        }
    }

    public static double determinantOfMatrix(double[][] mat, int n, int N) {
        int D = 0;
        if (n == 1) {
            return mat[0][0];
        }
        double[][] temp = new double[N][N];
        int sign = 1;
        for (int f = 0; f < n; ++f) {
            LinalgUtil.getCofactor(mat, temp, 0, f, n);
            D = (int)((double)D + (double)sign * mat[0][f] * LinalgUtil.determinantOfMatrix(temp, n - 1, N));
            sign = -sign;
        }
        return D;
    }

    public static double determinantOfMatrix(Array mat) {
        int n = mat.getShape()[0];
        double[][] a = (double[][])ArrayUtil.copyToNDJavaArray(mat);
        return LinalgUtil.determinantOfMatrix(a, n, n);
    }
}

