/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.stats.kde;

import java.util.List;
import org.apache.commons.math3.util.FastMath;
import org.meteoinfo.math.stats.kde.BallTree;
import org.meteoinfo.math.stats.kde.Event;
import org.meteoinfo.math.stats.kde.Helpers;
import org.meteoinfo.math.stats.kde.kdtree.KDTree;

public class KDE {
    private static final String NAME = "KDE";
    private BallTree ballTree;
    private int numPoints;

    public static KDE trainFixedKDE(List<Event> data, double h) {
        for (Event e : data) {
            e.setH(h);
        }
        return new KDE(data);
    }

    public static KDE trainAdaptiveKDE(List<Event> data, int K) {
        return KDE.trainAdaptiveKDE(data, 1.0, K);
    }

    public static KDE trainAdaptiveKDE(List<Event> data, double h0, int K) {
        String funcName = "trainAdaptiveKDE";
        KDTree kdTree = new KDTree(2);
        for (Event e : data) {
            KDE.insertPoint(kdTree, e.getPoint());
        }
        for (Event e : data) {
            Object[] objectnn = kdTree.nearest(e.getPoint(), K + 1);
            double[] lastnn = (double[])objectnn[objectnn.length - 1];
            double h = h0 * Helpers.euclidianDistance(e.getPoint(), lastnn);
            e.setH(h);
        }
        return new KDE(data);
    }

    private static void insertPoint(KDTree tree, double[] point) {
        double[] tempPont = new double[point.length];
        System.arraycopy(point, 0, tempPont, 0, point.length);
        while (tree.search(tempPont) != null) {
            tempPont[0] = point[0] + (double)Helpers.nextInt(100000) * 1.0E-15;
            tempPont[1] = point[1] + (double)Helpers.nextInt(100000) * 1.0E-15;
        }
        tree.insert(tempPont, point);
    }

    private KDE(List<Event> hTrainedData) {
        this.ballTree = new BallTree(hTrainedData, 200);
        this.numPoints = hTrainedData.size();
    }

    public double logPdf(Event e) {
        List<Double> logValues = this.ballTree.logPdfRecurse(e);
        double sum = Helpers.logSumExp(logValues);
        return sum - FastMath.log((double)this.numPoints);
    }

    private static String className() {
        return NAME;
    }

    public static void main(String ... args) throws Exception {
    }
}

