/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection;

import org.meteoinfo.global.PointD;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.info.ProjectionInfo;
import org.meteoinfo.projection.proj4j.CoordinateTransform;
import org.meteoinfo.projection.proj4j.CoordinateTransformFactory;
import org.meteoinfo.projection.proj4j.ProjCoordinate;

public class Reproject {
    private static final CoordinateTransformFactory ctFactory = new CoordinateTransformFactory();

    public static PointD reprojectPoint(double x, double y, ProjectionInfo source, ProjectionInfo dest) {
        double[][] points = new double[][]{{x, y}};
        Reproject.reprojectPoints(points, source, dest, 0, points.length);
        PointD rPoint = new PointD(points[0][0], points[0][1]);
        return rPoint;
    }

    public static PointD reprojectPoint(PointD point, ProjectionInfo source, ProjectionInfo dest) {
        return Reproject.reprojectPoint(point.X, point.Y, source, dest);
    }

    public static void reprojectPoints(double[][] points, ProjectionInfo source, ProjectionInfo dest) {
        Reproject.reprojectPoints(points, source, dest, 0, points.length);
    }

    public static void reprojectPoints(double[][] points, ProjectionInfo source, ProjectionInfo dest, int startIndex, int numPoints) {
        int i;
        CoordinateTransform trans = ctFactory.createTransform(source.getCoordinateReferenceSystem(), dest.getCoordinateReferenceSystem());
        if (source.getProjectionName() == ProjectionNames.LongLat) {
            for (i = startIndex; i < startIndex + numPoints && i < points.length; ++i) {
                if (points[i][0] > 180.0) {
                    double[] dArray = points[i];
                    dArray[0] = dArray[0] - 360.0;
                    continue;
                }
                if (!(points[i][0] < -180.0)) continue;
                double[] dArray = points[i];
                dArray[0] = dArray[0] + 360.0;
            }
        }
        for (i = startIndex; i < startIndex + numPoints && i < points.length; ++i) {
            ProjCoordinate p1 = new ProjCoordinate(points[i][0], points[i][1]);
            ProjCoordinate p2 = new ProjCoordinate();
            trans.transform(p1, p2);
            points[i][0] = p2.x;
            points[i][1] = p2.y;
        }
    }
}

