/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.info;

import java.util.ArrayList;
import org.meteoinfo.global.PointD;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.ProjectionUtil;
import org.meteoinfo.projection.info.ProjectionInfo;
import org.meteoinfo.projection.proj4j.CoordinateReferenceSystem;
import org.meteoinfo.shape.PolygonShape;

public class Albers
extends ProjectionInfo {
    public Albers(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    @Override
    public ProjectionNames getProjectionName() {
        return ProjectionNames.Albers_Equal_Area;
    }

    @Override
    void updateBoundary() {
        double lon;
        double epsilon = 1.0E-10;
        double cenLon = this.getCenterLon();
        double minLon = cenLon - 180.0 + epsilon;
        double maxLon = cenLon + 180.0 - epsilon;
        double minLat = -90.0;
        double maxLat = 90.0;
        ArrayList<PointD> points = new ArrayList<PointD>();
        double lat = minLat;
        for (lon = minLon; lon < maxLon; lon += 1.0) {
            points.add(new PointD(lon, lat));
        }
        lon = maxLon;
        while (lat < maxLat) {
            points.add(new PointD(lon, lat));
            lat += 1.0;
        }
        lat = maxLat;
        while (lon > minLon) {
            points.add(new PointD(lon, lat));
            lon -= 1.0;
        }
        lon = minLon;
        while (lat > minLat) {
            points.add(new PointD(lon, lat));
            lat -= 1.0;
        }
        lat = minLat;
        points.add(new PointD(lon, lat));
        PolygonShape ps = new PolygonShape();
        ps.setPoints(points);
        this.boundary = ProjectionUtil.projectPolygonShape(ps, KnownCoordinateSystems.geographic.world.WGS1984, this);
    }
}

