/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.proj4j;

import org.meteoinfo.projection.proj4j.datum.Datum;
import org.meteoinfo.projection.proj4j.proj.LongLatProjection;
import org.meteoinfo.projection.proj4j.proj.Projection;
import org.meteoinfo.projection.proj4j.units.Units;

public class CoordinateReferenceSystem {
    public static final CoordinateReferenceSystem CS_GEO = new CoordinateReferenceSystem("CS_GEO", null, null, null);
    private String name;
    private String[] params;
    private Datum datum;
    private Projection proj;

    public CoordinateReferenceSystem(String name, String[] params, Datum datum, Projection proj) {
        this.name = name;
        this.params = params;
        this.datum = datum;
        this.proj = proj;
        if (name == null) {
            String projName = "null-proj";
            if (proj != null) {
                projName = proj.getName();
            }
            this.name = projName + "-CS";
        }
    }

    public String getName() {
        return this.name;
    }

    public String[] getParameters() {
        return this.params;
    }

    public Datum getDatum() {
        return this.datum;
    }

    public Projection getProjection() {
        return this.proj;
    }

    public String getParameterString() {
        if (this.params == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.params.length; ++i) {
            buf.append(this.params[i]);
            buf.append(" ");
        }
        return buf.toString();
    }

    public String toEsriString() {
        String result = "";
        String geoName = "GCS_WGS_1984";
        if (this.proj.getProj4Name().equals("longlat")) {
            result = "GEOGCS[\"" + geoName + "\"," + this.datum.toEsriString() + ",PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]]";
            return result;
        }
        String name = "Custom";
        result = "PROJCS[\"" + name + "\",GEOGCS[\"" + geoName + "\"," + this.datum.toEsriString() + ",PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]], ";
        if (this.proj != null) {
            result = result + "PROJECTION[\"" + this.proj.getName() + "\"],";
        }
        result = result + "PARAMETER[\"False_Easting\"," + String.valueOf(this.proj.getFalseEasting()) + "],";
        result = result + "PARAMETER[\"False_Northing\"," + String.valueOf(this.proj.getFalseNorthing()) + "],";
        result = result + "PARAMETER[\"Central_Meridian\"," + String.valueOf(this.proj.getProjectionLongitudeDegrees()) + "],";
        result = result + "PARAMETER[\"Standard_Parallel_1\"," + String.valueOf(this.proj.getProjectionLatitude1Degrees()) + "],";
        result = result + "PARAMETER[\"Standard_Parallel_2\"," + String.valueOf(this.proj.getProjectionLatitude2Degrees()) + "],";
        result = result + "PARAMETER[\"Scale_Factor\"," + String.valueOf(this.proj.getScaleFactor()) + "],";
        result = result + "PARAMETER[\"Latitude_Of_Origin\"," + String.valueOf(this.proj.getProjectionLatitudeDegrees()) + "],";
        result = result + "UNIT[\"Meter\",1.0]]";
        return result;
    }

    public CoordinateReferenceSystem createGeographic() {
        Datum datum = this.getDatum();
        LongLatProjection geoProj = new LongLatProjection();
        geoProj.setEllipsoid(this.getProjection().getEllipsoid());
        geoProj.setUnits(Units.DEGREES);
        ((Projection)geoProj).initialize();
        return new CoordinateReferenceSystem("GEO-" + datum.getCode(), null, datum, geoProj);
    }

    public String toString() {
        return this.name;
    }
}

