/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.proj4j.proj;

import org.meteoinfo.projection.proj4j.ProjCoordinate;
import org.meteoinfo.projection.proj4j.proj.ConicProjection;
import org.meteoinfo.projection.proj4j.util.ProjectionMath;

public class SineTangentSeriesProjection
extends ConicProjection {
    private double C_x;
    private double C_y;
    private double C_p;
    private boolean tan_mode;

    protected SineTangentSeriesProjection(double p, double q, boolean mode) {
        this.es = 0.0;
        this.C_x = q / p;
        this.C_y = p;
        this.C_p = 1.0 / q;
        this.tan_mode = mode;
        this.initialize();
    }

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate xy) {
        xy.x = this.C_x * lplam * Math.cos(lpphi);
        xy.y = this.C_y;
        double c = Math.cos(lpphi *= this.C_p);
        if (this.tan_mode) {
            xy.x *= c * c;
            xy.y *= Math.tan(lpphi);
        } else {
            xy.x /= c;
            xy.y *= Math.sin(lpphi);
        }
        return xy;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate lp) {
        lp.y = this.tan_mode ? Math.atan(xyy) : ProjectionMath.asin(xyy /= this.C_y);
        double c = Math.cos(lp.y);
        lp.y /= this.C_p;
        lp.x = xyx / (this.C_x * Math.cos(lp.y));
        lp.x = this.tan_mode ? (lp.x /= c * c) : (lp.x *= c);
        return lp;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }
}

