/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.script;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.mapdata.MapDataManage;
import org.meteoinfo.data.meteodata.DrawMeteoData;
import org.meteoinfo.data.meteodata.DrawType2D;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.layout.MapLayout;
import org.meteoinfo.legend.MapFrame;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.map.MapView;
import org.meteoinfo.script.MapForm;

public class MeteoInfoMap {
    private boolean batchMode;
    private MapLayout mapLayout;
    private DrawType2D drawType2D;
    private String startUpPath;

    public MeteoInfoMap(String path) {
        this.startUpPath = path;
        this.batchMode = true;
        this.mapLayout = new MapLayout();
        this.drawType2D = DrawType2D.Contour;
        String fn = "D:/Temp/map/country1.shp";
        if (new File(fn).exists()) {
            try {
                MapLayer layer = MapDataManage.loadLayer(fn);
                PolygonBreak pgb = (PolygonBreak)layer.getLegendScheme().getLegendBreaks().get(0);
                pgb.setDrawFill(false);
                MapFrame mapFrame = this.mapLayout.getActiveMapFrame();
                MapView mapView = mapFrame.getMapView();
                mapView.setLockViewUpdate(true);
                mapFrame.addLayer(layer);
                mapFrame.setGridXDelt(60.0);
                mapFrame.setGridYDelt(30.0);
                this.mapLayout.getActiveLayoutMap().zoomToExtentLonLatEx(mapView.getLayersWholeExtent());
                mapView.setLockViewUpdate(false);
            }
            catch (Exception ex) {
                Logger.getLogger(MeteoInfoMap.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void display(GridData gdata) {
        VectorLayer layer = DrawMeteoData.createContourLayer(gdata, "meteo_layer", "data");
        if (this.mapLayout == null) {
            this.mapLayout = new MapLayout();
        }
        MapFrame mapFrame = this.mapLayout.getActiveMapFrame();
        MapView mapView = mapFrame.getMapView();
        mapView.setLockViewUpdate(true);
        mapFrame.addLayer(layer);
        this.mapLayout.getActiveLayoutMap().zoomToExtentLonLatEx(mapView.getMeteoLayersExtent());
        mapView.setLockViewUpdate(false);
        this.mapLayout.paintGraphics();
    }

    public void show() {
        MapForm frame = new MapForm(this.mapLayout);
        frame.setSize(750, 540);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }
}

