/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.script;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.chart.ChartPanel;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.plot.XY1DPlot;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.mapdata.MapDataManage;
import org.meteoinfo.data.meteodata.DimensionSet;
import org.meteoinfo.data.meteodata.DrawMeteoData;
import org.meteoinfo.data.meteodata.DrawType2D;
import org.meteoinfo.data.meteodata.MeteoDataInfo;
import org.meteoinfo.data.meteodata.PlotDimension;
import org.meteoinfo.global.Extent;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.layout.MapLayout;
import org.meteoinfo.legend.LineStyles;
import org.meteoinfo.legend.MapFrame;
import org.meteoinfo.legend.PointStyle;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.map.MapView;
import org.meteoinfo.script.ChartForm;
import org.meteoinfo.script.MapForm;

public class MeteoInfoScript {
    private boolean batchMode;
    private List<MeteoDataInfo> dataInfoList;
    private MeteoDataInfo currentDataInfo;
    private MapLayout mapLayout;
    private ChartPanel chartPanel;
    private DrawType2D drawType2D;
    private PlotDimension plotDimension;
    private String startUpPath;
    private boolean isMap;
    private DimensionSet dimensionSet;

    public MeteoInfoScript(String path) {
        this.startUpPath = path;
        this.batchMode = true;
        this.mapLayout = new MapLayout();
        this.chartPanel = new ChartPanel(null);
        this.dataInfoList = new ArrayList<MeteoDataInfo>();
        this.drawType2D = DrawType2D.Contour;
        this.plotDimension = PlotDimension.Lat_Lon;
        this.isMap = true;
        String fn = "D:/Temp/map/country1.shp";
        if (new File(fn).exists()) {
            try {
                MapLayer layer = MapDataManage.loadLayer(fn);
                PolygonBreak pgb = (PolygonBreak)layer.getLegendScheme().getLegendBreaks().get(0);
                pgb.setDrawFill(false);
                MapFrame mapFrame = this.mapLayout.getActiveMapFrame();
                MapView mapView = mapFrame.getMapView();
                mapView.setLockViewUpdate(true);
                mapFrame.addLayer(layer);
                mapFrame.setGridXDelt(60.0);
                mapFrame.setGridYDelt(30.0);
                this.mapLayout.getActiveLayoutMap().zoomToExtentLonLatEx(mapView.getLayersWholeExtent());
                mapView.setLockViewUpdate(false);
            }
            catch (Exception ex) {
                Logger.getLogger(MeteoInfoScript.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void addMeteoData(MeteoDataInfo aDataInfo) {
        this.dataInfoList.add(aDataInfo);
        this.currentDataInfo = aDataInfo;
    }

    public MeteoDataInfo openGrADSData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openGrADSData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openARLData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openARLData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openASCIIGridData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openASCIIGridData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openSurferGridData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openSurferGridData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openHYSPLITConcData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openHYSPLITConcData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openHYSPITPartData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openHYSPLITPartData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openHYSPLITTrajData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openHYSPLITTrajData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openNetCDFData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openNetCDFData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openLonLatData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openLonLatData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openMICAPSData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openMICAPSData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openMM5Data(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openMM5Data(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public MeteoDataInfo openMM5IMData(String fileName) {
        MeteoDataInfo aDataInfo = new MeteoDataInfo();
        aDataInfo.openMM5IMData(fileName);
        this.addMeteoData(aDataInfo);
        return aDataInfo;
    }

    public void setPlotDimension(String pdStr) {
        PlotDimension pd = null;
        if (pdStr.equalsIgnoreCase("lat_lon")) {
            pd = PlotDimension.Lat_Lon;
        }
        if (pd != null) {
            this.currentDataInfo.setDimensionSet(pd);
        }
    }

    public void title(String title) {
        if (this.isMap) {
            this.mapLayout.addText(title, 280, 20, 16.0f);
            this.mapLayout.paintGraphics();
        } else {
            this.chartPanel.getChart().setTitle(new ChartText(title));
            this.chartPanel.paintGraphics();
        }
    }

    public void display(String varName) {
        if (!this.isMap) {
            this.map();
        }
        if (this.currentDataInfo.isGridData()) {
            GridData gdata = this.currentDataInfo.getGridData(varName);
            VectorLayer layer = DrawMeteoData.createContourLayer(gdata, varName, varName);
            if (this.mapLayout == null) {
                this.mapLayout = new MapLayout();
            }
            MapFrame mapFrame = this.mapLayout.getActiveMapFrame();
            MapView mapView = mapFrame.getMapView();
            mapView.setLockViewUpdate(true);
            mapFrame.addLayer(layer);
            this.mapLayout.getActiveLayoutMap().zoomToExtentLonLatEx(mapView.getMeteoLayersExtent());
            mapView.setLockViewUpdate(false);
            this.mapLayout.paintGraphics();
        }
    }

    private LineStyles getLineStyle(String style) {
        LineStyles ls = null;
        if (style.contains("--")) {
            ls = LineStyles.DASH;
        } else if (style.contains(":")) {
            ls = LineStyles.DOT;
        } else if (style.contains("-.")) {
            ls = LineStyles.DASHDOT;
        } else if (style.contains("-")) {
            ls = LineStyles.SOLID;
        }
        return ls;
    }

    private PointStyle getPointStyle(String style) {
        PointStyle ps = null;
        if (style.contains("o")) {
            ps = PointStyle.Circle;
        } else if (style.contains("D")) {
            ps = PointStyle.Diamond;
        } else if (style.contains("+")) {
            ps = PointStyle.Plus;
        } else if (style.contains("s")) {
            ps = PointStyle.Square;
        } else if (style.contains("*")) {
            ps = PointStyle.StarLines;
        } else if (style.contains("^")) {
            ps = PointStyle.UpTriangle;
        } else if (style.contains("x")) {
            ps = PointStyle.XCross;
        }
        return ps;
    }

    private Color getColor(String style) {
        if (style.contains("r")) {
            return Color.red;
        }
        if (style.contains("k")) {
            return Color.black;
        }
        if (style.contains("b")) {
            return Color.blue;
        }
        if (style.contains("g")) {
            return Color.green;
        }
        if (style.contains("w")) {
            return Color.white;
        }
        return null;
    }

    private int getSymbolInterval(int n) {
        int v = 20;
        int i = n < v ? 1 : n / v;
        return i;
    }

    public void axis(List<Number> limits) {
        if (limits.size() == 4) {
            double xmin = Double.parseDouble(limits.get(0).toString());
            double xmax = Double.parseDouble(limits.get(1).toString());
            double ymin = Double.parseDouble(limits.get(2).toString());
            double ymax = Double.parseDouble(limits.get(3).toString());
            XY1DPlot plot = (XY1DPlot)this.chartPanel.getChart().getPlot();
            plot.setDrawExtent(new Extent(xmin, xmax, ymin, ymax));
            this.chartPanel.paintGraphics();
        }
    }

    public void ylabel(String label) {
        XY1DPlot plot = (XY1DPlot)this.chartPanel.getChart().getPlot();
        plot.getYAxis().setLabel(label);
        plot.getYAxis().setDrawLabel(true);
        this.chartPanel.paintGraphics();
    }

    public void xlabel(String label) {
        XY1DPlot plot = (XY1DPlot)this.chartPanel.getChart().getPlot();
        plot.getXAxis().setLabel(label);
        plot.getXAxis().setDrawLabel(true);
        this.chartPanel.paintGraphics();
    }

    public void showfigure() {
        ChartForm form = new ChartForm(this.chartPanel);
        form.setSize(600, 500);
        form.setLocationRelativeTo(null);
        form.setDefaultCloseOperation(2);
        form.setVisible(true);
        this.chartPanel.paintGraphics();
    }

    public void show() {
        if (this.isMap) {
            this.showmap();
        } else {
            this.showfigure();
        }
    }

    public void show(int i) {
        if (i == 0) {
            this.showmap();
        } else {
            this.showfigure();
        }
    }

    public void map() {
        this.isMap = true;
        System.out.println("Switch to map mode");
    }

    public void figure() {
        this.isMap = false;
        System.out.println("Switch to figure mode");
    }

    public void showmap() {
        MapForm frame = new MapForm(this.mapLayout);
        frame.setSize(750, 540);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }

    public List<Double> linespace(double min, double max, int n) {
        ArrayList<Double> values = new ArrayList<Double>();
        double delta = (max - min) / (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            values.add(min + delta * (double)i);
        }
        return values;
    }

    public List<Double> sin(List<Double> values) {
        ArrayList<Double> rvalues = new ArrayList<Double>();
        for (Double v : values) {
            rvalues.add(Math.sin(v));
        }
        return rvalues;
    }
}

