/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.shape;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.meteoinfo.geoprocess.GeoComputation;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointD;
import org.meteoinfo.layer.LabelSet;
import org.meteoinfo.legend.BreakTypes;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.LabelBreak;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.shape.Graphic;
import org.meteoinfo.shape.PointShape;
import org.meteoinfo.shape.PolygonShape;
import org.meteoinfo.shape.PolylineShape;
import org.meteoinfo.shape.Shape;
import org.meteoinfo.shape.ShapeTypes;

public class GraphicCollection
extends Graphic
implements Iterator {
    List<Graphic> graphics = new ArrayList<Graphic>();
    private Extent _extent = new Extent();
    private boolean singleLegend = true;
    private int index = 0;
    private LabelSet labelSet = new LabelSet();
    private List<Graphic> labelPoints = new ArrayList<Graphic>();
    private LegendScheme legendScheme;
    private ColorBreak legendBreak;

    @Override
    public List<Graphic> getGraphics() {
        return this.graphics;
    }

    public void setGraphics(List<Graphic> value) {
        this.graphics = value;
    }

    @Override
    public Extent getExtent() {
        return this._extent;
    }

    @Override
    public void setExtent(Extent value) {
        this._extent = value;
    }

    @Override
    public boolean isSingleLegend() {
        return this.singleLegend;
    }

    public void setSingleLegend(boolean value) {
        this.singleLegend = value;
    }

    public LabelSet getLabelSet() {
        return this.labelSet;
    }

    public void setLabelSet(LabelSet ls) {
        this.labelSet = ls;
    }

    public List<Graphic> getLabelPoints() {
        return this.labelPoints;
    }

    public void setLabelPoints(List<Graphic> lps) {
        this.labelPoints = lps;
    }

    public LegendScheme getLegendScheme() {
        return this.legendScheme;
    }

    public void setLegendScheme(LegendScheme value) {
        this.legendScheme = value;
    }

    public ColorBreak getLegendBreak() {
        return this.legendBreak;
    }

    public void setLegendBreak(ColorBreak value) {
        this.legendBreak = value;
    }

    public boolean is3D() {
        return false;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    public void updateExtent() {
        int i = 0;
        for (Graphic g : this.graphics) {
            Extent extent = g instanceof GraphicCollection ? g.getExtent() : g.getShape().getExtent();
            this._extent = i == 0 ? extent : MIMath.getLagerExtent(this._extent, extent);
            ++i;
        }
    }

    public boolean add(Graphic aGraphic) {
        boolean istrue = this.graphics.add(aGraphic);
        this._extent = this.graphics.size() == 1 ? aGraphic.getExtent() : MIMath.getLagerExtent(this._extent, aGraphic.getExtent());
        return istrue;
    }

    public void add(int index, Graphic aGraphic) {
        this.graphics.add(index, aGraphic);
        this._extent = this.graphics.size() == 1 ? aGraphic.getShape().getExtent() : MIMath.getLagerExtent(this._extent, aGraphic.getShape().getExtent());
    }

    public Graphic get(int idx) {
        return this.graphics.get(idx);
    }

    public int indexOf(Graphic g) {
        return this.graphics.indexOf(g);
    }

    public boolean contains(Graphic g) {
        return this.graphics.contains(g);
    }

    public int size() {
        return this.graphics.size();
    }

    public boolean isEmpty() {
        return this.graphics.isEmpty();
    }

    @Override
    public int getNumGraphics() {
        return this.size();
    }

    @Override
    public Graphic getGraphicN(int idx) {
        return this.get(idx);
    }

    public boolean remove(Graphic aGraphic) {
        boolean istrue = this.graphics.remove(aGraphic);
        this.updateExtent();
        return istrue;
    }

    public Graphic remove(int index) {
        Graphic ag = this.graphics.remove(index);
        this.updateExtent();
        return ag;
    }

    public void clear() {
        this.graphics.clear();
    }

    public void addAll(List<Graphic> gs) {
        this.graphics.addAll(gs);
    }

    public void join(Graphic graphic) {
        if (graphic.isCollection()) {
            this._extent = this.isEmpty() ? graphic.getExtent() : MIMath.getLagerExtent(this._extent, graphic.getExtent());
            for (int i = 0; i < graphic.getNumGraphics(); ++i) {
                this.graphics.add(graphic.getGraphicN(i));
            }
        } else {
            this.add(graphic);
        }
    }

    public void removeAll(List<Graphic> gs) {
        this.graphics.removeAll(gs);
    }

    @Override
    public ColorBreak getLegend() {
        if (this.legendBreak != null) {
            return this.legendBreak;
        }
        return this.graphics.get(0).getLegend();
    }

    public GraphicCollection selectGraphics(Extent aExtent) {
        GraphicCollection selectedGraphics = new GraphicCollection();
        PointD aPoint = new PointD();
        aPoint.X = (aExtent.minX + aExtent.maxX) / 2.0;
        aPoint.Y = (aExtent.minY + aExtent.maxY) / 2.0;
        for (Graphic aGraphic : this.graphics) {
            block0 : switch (aGraphic.getShape().getShapeType()) {
                case Point: {
                    PointShape aPS = (PointShape)aGraphic.getShape();
                    if (!MIMath.pointInExtent(aPS.getPoint(), aExtent)) break;
                    selectedGraphics.add(aGraphic);
                    break;
                }
                case Polyline: 
                case PolylineZ: {
                    PolylineShape aPLS = (PolylineShape)aGraphic.getShape();
                    if (!MIMath.isExtentCross(aExtent, aPLS.getExtent()).booleanValue()) break;
                    for (int j = 0; j < aPLS.getPoints().size(); ++j) {
                        aPoint = aPLS.getPoints().get(j);
                        if (!MIMath.pointInExtent(aPoint, aExtent)) continue;
                        selectedGraphics.add(aGraphic);
                        break block0;
                    }
                    break;
                }
                case Polygon: 
                case Rectangle: {
                    PolygonShape aPGS = (PolygonShape)aGraphic.getShape();
                    if (aPGS.getPartNum() <= 1) {
                        if (!GeoComputation.pointInPolygon(aPGS.getPoints(), aPoint)) break;
                        selectedGraphics.add(aGraphic);
                        break;
                    }
                    for (int p = 0; p < aPGS.getPartNum(); ++p) {
                        int pp;
                        ArrayList<PointD> pList = new ArrayList<PointD>();
                        if (p == aPGS.getPartNum() - 1) {
                            for (pp = aPGS.parts[p]; pp < aPGS.getPointNum(); ++pp) {
                                pList.add(aPGS.getPoints().get(pp));
                            }
                        } else {
                            for (pp = aPGS.parts[p]; pp < aPGS.parts[p + 1]; ++pp) {
                                pList.add(aPGS.getPoints().get(pp));
                            }
                        }
                        if (!GeoComputation.pointInPolygon(pList, aPoint)) continue;
                        selectedGraphics.add(aGraphic);
                        break block0;
                    }
                    break;
                }
            }
        }
        return selectedGraphics;
    }

    @Override
    public boolean hasNext() {
        return this.index <= this.size() - 1;
    }

    public Object next() {
        if (this.index >= this.size()) {
            throw new NoSuchElementException();
        }
        return this.get(this.index++);
    }

    public void addLabels() {
        this.addLabelsByColor();
        this.labelSet.setDrawLabels(true);
    }

    public List<Shape> getShapes() {
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        for (Graphic g : this.graphics) {
            shapes.add(g.getShape());
        }
        return shapes;
    }

    public ShapeTypes getShapeType() {
        return this.graphics.get(0).getShape().getShapeType();
    }

    private double getMinValue() {
        double min = Double.MAX_VALUE;
        for (Graphic graphic : this.graphics) {
            Shape shape = graphic.getShape();
            if (!(min > shape.getValue())) continue;
            min = shape.getValue();
        }
        return min;
    }

    private void addLabelsByColor() {
        if (this.labelSet.isAutoDecimal()) {
            double min = this.getMinValue();
            this.labelSet.setDecimalDigits(MIMath.getDecimalNum(min));
        }
        String dFormat = "%1$." + String.valueOf(this.labelSet.getDecimalDigits()) + "f";
        for (Graphic graphic : this.graphics) {
            ColorBreak cb = graphic.getLegend();
            Shape shape = graphic.getShape();
            PointShape aPS = new PointShape();
            switch (shape.getShapeType()) {
                case Point: 
                case PointM: 
                case PointZ: {
                    aPS.setPoint((PointD)((PointShape)shape).getPoint().clone());
                    break;
                }
                case Polyline: 
                case PolylineZ: 
                case PolylineM: {
                    int pIdx = ((PolylineShape)shape).getPoints().size() / 2;
                    aPS.setPoint((PointD)((PolylineShape)shape).getPoints().get(pIdx - 1).clone());
                    break;
                }
                case Polygon: 
                case PolygonM: {
                    Extent aExtent = shape.getExtent();
                    PointD aPoint = new PointD();
                    aPoint.X = (aExtent.minX + aExtent.maxX) / 2.0;
                    aPoint.Y = (aExtent.minY + aExtent.maxY) / 2.0;
                    aPS.setPoint(aPoint);
                }
            }
            LabelBreak aLP = new LabelBreak();
            aLP.setText(String.format(dFormat, shape.getValue()));
            if (this.labelSet.isColorByLegend()) {
                aLP.setColor(cb.getColor());
            } else {
                aLP.setColor(this.labelSet.getLabelColor());
            }
            aLP.setFont(this.labelSet.getLabelFont());
            aLP.setAlignType(this.labelSet.getLabelAlignType());
            aLP.setYShift(this.labelSet.getYOffset());
            aLP.setXShift(this.labelSet.getXOffset());
            Graphic aGraphic = new Graphic(aPS, aLP);
            this.addLabel(aGraphic);
        }
    }

    public void addLabel(Graphic aLP) {
        this.labelPoints.add(aLP);
    }

    public void addLabelsContourDynamic(Extent sExtent) {
        if (this.labelSet.isAutoDecimal()) {
            double min = this.getMinValue();
            this.labelSet.setDecimalDigits(MIMath.getDecimalNum(min));
        }
        String dFormat = "%1$." + String.valueOf(this.labelSet.getDecimalDigits()) + "f";
        for (Graphic graphic : this.graphics) {
            Shape shape = graphic.getShape();
            ColorBreak cb = graphic.getLegend();
            PolylineShape aPLS = (PolylineShape)shape;
            Extent IExtent = aPLS.getExtent();
            if (!(IExtent.maxX - IExtent.minX > (sExtent.maxX - sExtent.minX) / 10.0) && !(IExtent.maxY - IExtent.minY > (sExtent.maxY - sExtent.minY) / 10.0)) continue;
            LabelBreak aLP = new LabelBreak();
            int pIdx = aPLS.getPoints().size() / 2;
            PointShape aPS = new PointShape();
            aPS.setPoint(aPLS.getPoints().get(pIdx - 1));
            String text = String.format(dFormat, aPLS.getValue());
            aLP.setText(text);
            aLP.setFont(this.labelSet.getLabelFont());
            aLP.setAlignType(this.labelSet.getLabelAlignType());
            aLP.setYShift(this.labelSet.getYOffset());
            aLP.setColor(cb.getColor());
            Graphic aGraphic = new Graphic(aPS, aLP);
            this.addLabel(aGraphic);
        }
        this.labelSet.setDrawLabels(true);
    }

    public float getArrowZoom() {
        if (this.getLegend().getBreakType() == BreakTypes.PointBreak) {
            float size = ((PointBreak)this.getLegend()).getSize();
            return size / 10.0f;
        }
        return 1.0f;
    }

    public GraphicCollection clip(List<PolygonShape> clipPolys) {
        GraphicCollection cgraphics = new GraphicCollection();
        for (PolygonShape aPGS : clipPolys) {
            for (int i = 0; i < this.graphics.size(); ++i) {
                Shape bShape = this.graphics.get(i).getShape();
                Shape clipShape = bShape.intersection(aPGS);
                if (clipShape == null) continue;
                cgraphics.add(new Graphic(clipShape, this.graphics.get(i).getLegend()));
            }
        }
        cgraphics.setSingleLegend(this.singleLegend);
        cgraphics.setLegendScheme((LegendScheme)this.getLegendScheme().clone());
        return cgraphics;
    }
}

