/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.shape;

import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.Geometry;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.shape.PointM;
import org.meteoinfo.shape.PointZ;
import org.meteoinfo.shape.PolygonShape;
import org.meteoinfo.shape.ShapeTypes;

public class PolygonMShape
extends PolygonShape {
    public PolygonMShape() {
    }

    public PolygonMShape(Geometry geometry) {
        Coordinate[] cs = geometry.getCoordinates();
        ArrayList<PointZ> points = new ArrayList<PointZ>();
        for (Coordinate c1 : cs) {
            CoordinateXYM c = (CoordinateXYM)c1;
            points.add(new PointZ(c.x, c.y, c.getZ(), c.getM()));
        }
        this.setPoints(points);
    }

    @Override
    public ShapeTypes getShapeType() {
        return ShapeTypes.PolygonM;
    }

    public double[] getMArray() {
        double[] mArray = new double[this.getPoints().size()];
        for (int i = 0; i < this.getPoints().size(); ++i) {
            mArray[i] = ((PointM)this.getPoints().get((int)i)).M;
        }
        return mArray;
    }

    public double[] getMRange() {
        return MIMath.arrayMinMax(this.getMArray());
    }
}

