/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.table;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.DataTypes;
import org.meteoinfo.table.DataTable;

public class DataColumn {
    private boolean readOnly;
    private DataTable table;
    private String columnName;
    private String captionName;
    private int columnIndex;
    private DataTypes dataType;
    private String format;
    private boolean joined = false;

    public DataColumn() {
        this("default1");
    }

    public DataColumn(DataTypes dataType) {
        this("default1", dataType);
    }

    public DataColumn(String columnName) {
        this(columnName, DataTypes.Integer);
    }

    public DataColumn(String columnName, DataTypes dataType) {
        this.dataType = dataType;
        this.columnName = columnName;
        if (this.dataType == DataTypes.Date) {
            this.format = "YYYYMMddHH";
        }
    }

    public DataColumn(String columnName, DataTypes dataType, String format) {
        this.dataType = dataType;
        this.columnName = columnName;
        this.format = format;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getCaptionName() {
        return this.captionName;
    }

    public void setCaptionName(String captionName) {
        this.captionName = captionName;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String value) {
        this.format = value;
    }

    public boolean isJoined() {
        return this.joined;
    }

    public void setJoined(boolean value) {
        this.joined = value;
    }

    public DataTable getTable() {
        return this.table;
    }

    public void setTable(DataTable table) {
        this.table = table;
    }

    public void setDataType(DataTypes dataType) {
        this.dataType = dataType;
        if (dataType == DataTypes.Date) {
            this.format = "YYYYMMddHH";
        }
    }

    public DataTypes getDataType() {
        return this.dataType;
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public String getDataTypeName() {
        return this.dataType.toString();
    }

    public Object convertTo(Object value) {
        if (value == null) {
            switch (this.dataType) {
                case Integer: {
                    return Integer.MIN_VALUE;
                }
                case Float: {
                    return Float.valueOf(Float.NaN);
                }
                case Double: {
                    return Double.NaN;
                }
                case Boolean: {
                    return false;
                }
                case String: {
                    return "";
                }
            }
            return value;
        }
        switch (this.dataType) {
            case Integer: {
                if (value instanceof Integer) break;
                String vStr = value.toString();
                if (vStr.isEmpty()) {
                    return Integer.MIN_VALUE;
                }
                return Integer.valueOf(vStr);
            }
            case Double: {
                if (value instanceof Double) break;
                String vStr = value.toString();
                if (vStr.isEmpty() || vStr.equalsIgnoreCase("nan")) {
                    return Double.NaN;
                }
                return Double.valueOf(vStr);
            }
            case Float: {
                if (value instanceof Float) break;
                String vStr = value.toString();
                if (vStr.isEmpty() || vStr.equalsIgnoreCase("nan")) {
                    return Float.valueOf(Float.NaN);
                }
                try {
                    float v = Float.valueOf(vStr).floatValue();
                    return Float.valueOf(v);
                }
                catch (Exception e) {
                    return Float.valueOf(Float.NaN);
                }
            }
            case Boolean: {
                if (value instanceof Boolean) break;
                String vStr = value.toString();
                if (vStr.isEmpty()) {
                    return false;
                }
                return Boolean.valueOf(vStr);
            }
            case Date: {
                if (value instanceof Date) break;
                String vStr = value.toString();
                if (vStr.isEmpty()) {
                    return null;
                }
                SimpleDateFormat dformat = new SimpleDateFormat(this.format);
                try {
                    return dformat.parse(vStr);
                }
                catch (ParseException ex) {
                    Logger.getLogger(DataColumn.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return value;
    }

    public String toString() {
        return this.columnName;
    }

    public Object clone() {
        DataColumn col = new DataColumn();
        col.captionName = this.captionName;
        col.columnIndex = this.columnIndex;
        col.columnName = this.columnName;
        col.dataType = this.dataType;
        col.readOnly = this.readOnly;
        col.format = this.format;
        return col;
    }
}

