/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.table;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.meteoinfo.table.Convert;

public class SQLExpression {
    private final String expression;
    private final int exp_len;
    private final char[] exp_array;
    private final ArrayList<String> token_list;
    private boolean is_flushed;
    private char c;
    private StringBuffer sb;
    private int cur_token_index;
    private final int token_count;

    public SQLExpression(String SQLExpression2) {
        this.expression = SQLExpression2;
        this.exp_len = SQLExpression2.length();
        this.exp_array = SQLExpression2.toCharArray();
        this.token_list = new ArrayList();
        this.is_flushed = true;
        this.cur_token_index = -1;
        this.sb = new StringBuffer();
        this.initTokenList();
        this.token_count = this.token_list.size();
    }

    private void flush() {
        if (this.is_flushed) {
            return;
        }
        String token = this.sb.toString();
        if (token.startsWith("\"")) {
            token = token.substring(1);
        }
        if (token.endsWith("\"")) {
            token = token.substring(0, token.length() - 1);
        }
        this.token_list.add(token);
        this.sb = new StringBuffer();
        this.is_flushed = true;
    }

    private void collect() {
        this.sb.append(this.c);
        this.is_flushed = false;
    }

    private boolean nextToken() {
        if (this.cur_token_index < this.token_count - 1) {
            ++this.cur_token_index;
            return true;
        }
        return false;
    }

    private String currentToken() {
        return this.token_list.get(this.cur_token_index);
    }

    private void initTokenList() {
        block9: for (int i = 0; i < this.exp_len; ++i) {
            this.c = this.exp_array[i];
            if (Character.isWhitespace(this.c) && (this.sb.length() <= 0 || !this.sb.substring(0, 1).equals("\""))) {
                this.flush();
                continue;
            }
            switch (this.c) {
                case '<': {
                    this.flush();
                    if (i + 1 < this.exp_len && this.exp_array[i + 1] == '=') {
                        this.token_list.add("<=");
                        ++i;
                        continue block9;
                    }
                    if (i + 1 < this.exp_len && this.exp_array[i + 1] == '>') {
                        this.token_list.add("<>");
                        ++i;
                        continue block9;
                    }
                    this.token_list.add("<");
                    continue block9;
                }
                case '>': {
                    this.flush();
                    if (i + 1 < this.exp_len && this.exp_array[i + 1] == '=') {
                        this.token_list.add(">=");
                        ++i;
                        continue block9;
                    }
                    this.token_list.add(">");
                    continue block9;
                }
                case '(': {
                    this.flush();
                    this.token_list.add("(");
                    continue block9;
                }
                case ')': {
                    this.flush();
                    this.token_list.add(")");
                    continue block9;
                }
                case '=': {
                    if (i + 1 < this.exp_len && this.exp_array[i + 1] == '=') {
                        this.flush();
                        ++i;
                        continue block9;
                    }
                    this.collect();
                    continue block9;
                }
                case '!': {
                    if (i + 1 < this.exp_len && this.exp_array[i + 1] == '=') {
                        this.flush();
                        this.token_list.add("!=");
                        ++i;
                        continue block9;
                    }
                    this.collect();
                    continue block9;
                }
                case '\"': {
                    if (this.sb.length() > 0 && this.sb.substring(0, 1).equals("\"")) {
                        this.flush();
                        continue block9;
                    }
                    this.collect();
                    continue block9;
                }
                default: {
                    this.collect();
                }
            }
        }
        this.flush();
    }

    public boolean eval(Map dr) {
        this.nextToken();
        boolean result = this.doAndOr(dr);
        this.cur_token_index = -1;
        return result;
    }

    private boolean doAndOr(Map dr) {
        String op;
        boolean result = this.doNot(dr);
        while ((op = this.currentToken()).equalsIgnoreCase("and") || op.equalsIgnoreCase("or")) {
            boolean result_right;
            this.nextToken();
            if (op.equalsIgnoreCase("and")) {
                result_right = this.doNot(dr);
                result = result && result_right;
                continue;
            }
            result_right = this.doNot(dr);
            result = result || result_right;
        }
        return result;
    }

    private boolean doNot(Map dr) {
        String op = this.currentToken();
        if (op.equalsIgnoreCase("not")) {
            this.nextToken();
        }
        boolean result = this.doBrackets(dr);
        if (op.equalsIgnoreCase("not")) {
            return !result;
        }
        return result;
    }

    private boolean doBrackets(Map dr) {
        boolean result;
        if (this.currentToken().equals("(")) {
            this.nextToken();
            result = this.doAndOr(dr);
            this.nextToken();
        } else {
            result = this.doCompare(dr);
        }
        return result;
    }

    private boolean doCompare(Map dr) {
        Object field = dr.get(this.currentToken().toLowerCase());
        this.nextToken();
        String opt = this.currentToken();
        this.nextToken();
        String value = this.currentToken();
        this.nextToken();
        switch (opt) {
            case "like": {
                return SQLExpression.isLike(field, value);
            }
            case ">": {
                return SQLExpression.isGreat(field, value);
            }
            case "<": {
                return SQLExpression.isLess(field, value);
            }
            case "=": {
                return SQLExpression.isEquals(field, value);
            }
            case ">=": {
                return SQLExpression.isGreatEquals(field, value);
            }
            case "<=": {
                return SQLExpression.isLessEquals(field, value);
            }
            case "<>": {
                return SQLExpression.isNotEquals(field, value);
            }
        }
        return false;
    }

    private static boolean isLike(Object field, String value) {
        int len = value.length();
        if (value.startsWith("'%") && value.endsWith("%'")) {
            return Convert.toString(field).contains(value.substring(2, len - 2));
        }
        if (value.startsWith("'%")) {
            return Convert.toString(field).endsWith(value.substring(2, len - 1));
        }
        if (value.endsWith("%'")) {
            return Convert.toString(field).startsWith(value.substring(1, len - 2));
        }
        return Convert.toString(field).equals(value.substring(1, len - 1));
    }

    private static boolean isLess(Object field, String value) {
        if (field instanceof Number) {
            return Convert.toFloat(field) < Convert.toFloat(value);
        }
        if (field instanceof Date) {
            return ((Date)field).before(Convert.toDate(value));
        }
        return Convert.toString(field).compareTo(value.substring(1, value.length() - 1)) < 0;
    }

    private static boolean isGreat(Object field, String value) {
        if (field instanceof Number) {
            return Convert.toFloat(field) > Convert.toFloat(value);
        }
        if (field instanceof Date) {
            return ((Date)field).after(Convert.toDate(value));
        }
        return Convert.toString(field).compareTo(value.substring(1, value.length() - 1)) > 0;
    }

    private static boolean isEquals(Object field, String value) {
        if (value.equals("null")) {
            return field == null;
        }
        if (field instanceof Number) {
            return Convert.toFloat(field) == Convert.toFloat(value);
        }
        if (field instanceof Boolean) {
            return Convert.toBool(field) == Convert.toBool(value);
        }
        if (field instanceof Date) {
            return ((Date)field).equals(Convert.toDate(value));
        }
        return Convert.toString(field).equals(value);
    }

    private static boolean isNotEquals(Object field, String value) {
        if (value.equals("null")) {
            return field != null;
        }
        if (field instanceof Number) {
            return Convert.toFloat(field) != Convert.toFloat(value);
        }
        if (field instanceof Boolean) {
            return Convert.toBool(field) != Convert.toBool(value);
        }
        if (field instanceof Date) {
            return !((Date)field).equals(Convert.toDate(value));
        }
        return !Convert.toString(field).equals(value);
    }

    private static boolean isLessEquals(Object field, String value) {
        if (field instanceof Number) {
            return Convert.toFloat(field) <= Convert.toFloat(value);
        }
        if (field instanceof Date) {
            return ((Date)field).before(Convert.toDate(value)) || ((Date)field).equals(Convert.toDate(value));
        }
        return Convert.toString(field).compareTo(value.substring(1, value.length() - 1)) <= 0;
    }

    private static boolean isGreatEquals(Object field, String value) {
        if (field instanceof Number) {
            return Convert.toFloat(field) >= Convert.toFloat(value);
        }
        if (field instanceof Date) {
            return ((Date)field).after(Convert.toDate(value)) || ((Date)field).equals(Convert.toDate(value));
        }
        return Convert.toString(field).compareTo(value.substring(1, value.length() - 1)) >= 0;
    }
}

