/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import javax.swing.event.EventListenerList;
import org.meteoinfo.global.PointF;
import org.meteoinfo.global.event.ILocationChangedListener;
import org.meteoinfo.global.event.ISizeChangedListener;
import org.meteoinfo.global.event.LocationChangedEvent;
import org.meteoinfo.global.event.SizeChangedEvent;
import org.meteoinfo.layout.ResizeAbility;

public abstract class ChartElement {
    private final EventListenerList _listeners = new EventListenerList();
    protected float x;
    protected float y;
    protected float width;
    protected float height;
    protected Color _foreColor = Color.black;
    protected Color _backColor = Color.white;
    private boolean _selected = false;
    private ResizeAbility _resizeAbility = ResizeAbility.None;
    private boolean _visible = true;
    private boolean drawBackColor = false;

    public void addLocationChangedListener(ILocationChangedListener listener) {
        this._listeners.add(ILocationChangedListener.class, listener);
    }

    public void removeLocationChangedListener(ILocationChangedListener listener) {
        this._listeners.remove(ILocationChangedListener.class, listener);
    }

    public void fireLocationChangedEvent() {
        this.fireLocationChangedEvent(new LocationChangedEvent(this));
    }

    private void fireLocationChangedEvent(LocationChangedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ILocationChangedListener.class) continue;
            ((ILocationChangedListener)listeners[i + 1]).locationChangedEvent(event);
        }
    }

    public void addSizeChangedListener(ISizeChangedListener listener) {
        this._listeners.add(ISizeChangedListener.class, listener);
    }

    public void removeSizeChangedListener(ISizeChangedListener listener) {
        this._listeners.remove(ISizeChangedListener.class, listener);
    }

    public void fireSizeChangedEvent() {
        this.fireSizeChangedEvent(new SizeChangedEvent(this));
    }

    private void fireSizeChangedEvent(SizeChangedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ISizeChangedListener.class) continue;
            ((ISizeChangedListener)listeners[i + 1]).sizeChangedEvent(event);
        }
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void setVisible(boolean istrue) {
        this._visible = istrue;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float left) {
        this.x = left;
        this.fireLocationChangedEvent();
    }

    public float getY() {
        return this.y;
    }

    public void setY(float top) {
        this.y = top;
        this.fireLocationChangedEvent();
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
        this.fireSizeChangedEvent();
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
        this.fireSizeChangedEvent();
    }

    public float getRight() {
        return this.x + this.width;
    }

    public float getBottom() {
        return this.y + this.height;
    }

    public Rectangle2D.Float getBounds() {
        return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
    }

    public Color getForeground() {
        return this._foreColor;
    }

    public void setForeground(Color color) {
        this._foreColor = color;
    }

    public Color getBackground() {
        return this._backColor;
    }

    public void setBackground(Color color) {
        this._backColor = color;
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean istrue) {
        this._selected = istrue;
    }

    public ResizeAbility getResizeAbility() {
        return this._resizeAbility;
    }

    public void setResizeAbility(ResizeAbility ra) {
        this._resizeAbility = ra;
    }

    public boolean isDrawBackColor() {
        return this.drawBackColor;
    }

    public void setDrawBackColor(boolean value) {
        this.drawBackColor = value;
    }

    public abstract void moveUpdate();

    public abstract void resizeUpdate();

    public PointF pageToScreen(float pageX, float pageY, PointF pageLocation, float zoom) {
        float x = pageX * zoom + pageLocation.X;
        float y = pageY * zoom + pageLocation.Y;
        return new PointF(x, y);
    }
}

