/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart;

import com.l2fprod.common.beans.BaseBeanInfo;
import com.l2fprod.common.beans.ExtendedPropertyDescriptor;
import com.l2fprod.common.beans.editor.ComboBoxPropertyEditor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.LegendPosition;
import org.meteoinfo.chart.plot.PlotOrientation;
import org.meteoinfo.chart.plot.XAlign;
import org.meteoinfo.chart.plot.YAlign;
import org.meteoinfo.drawing.Draw;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.PointF;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.LegendType;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.legend.PolylineBreak;

public class ChartLegend {
    protected LegendScheme legendScheme;
    private LegendPosition position;
    protected float shrink;
    protected int aspect;
    private boolean colorBar;
    protected float x;
    protected float y;
    protected PlotOrientation orientation;
    protected Color background;
    protected boolean drawBackground;
    protected int width;
    protected int height;
    protected int legendWidth;
    protected int legendHeight;
    protected ChartText label;
    protected String labelLocation;
    protected Font tickLabelFont;
    protected Color tickLabelColor;
    protected float tickLabelAngle;
    protected boolean drawNeatLine;
    protected Color neatLineColor;
    protected float neatLineSize;
    private float breakSpace;
    private float topSpace;
    private float leftSpace;
    protected double _vBarWidth;
    protected double _hBarHeight;
    private int rowColNum = 1;
    private boolean autoRowColNum = true;
    private Dimension symbolDimension;
    protected boolean extendRect;
    protected boolean autoExtendFrac;
    protected boolean drawMinLabel;
    protected boolean drawMaxLabel;
    protected float xshift;
    protected float yshift;

    public ChartLegend(LegendScheme ls) {
        this.legendScheme = ls;
        this.colorBar = false;
        this.position = LegendPosition.LOWER_CENTER_OUTSIDE;
        this.orientation = PlotOrientation.HORIZONTAL;
        this.shrink = 1.0f;
        this.aspect = 20;
        this.background = Color.white;
        this.drawBackground = false;
        this.drawNeatLine = true;
        this.neatLineColor = Color.black;
        this.neatLineSize = 1.0f;
        this.breakSpace = 3.0f;
        this.topSpace = 5.0f;
        this.leftSpace = 5.0f;
        this._vBarWidth = 10.0;
        this._hBarHeight = 10.0;
        this.labelLocation = "out";
        this.tickLabelFont = new Font("Arial", 0, 14);
        this.tickLabelColor = Color.black;
        this.tickLabelAngle = 0.0f;
        this.symbolDimension = new Dimension(16, 10);
        this.extendRect = true;
        this.autoExtendFrac = false;
        this.drawMinLabel = false;
        this.drawMaxLabel = false;
        this.xshift = 0.0f;
        this.yshift = 0.0f;
    }

    public LegendScheme getLegendScheme() {
        return this.legendScheme;
    }

    public void setLegendScheme(LegendScheme value) {
        this.legendScheme = value;
    }

    public boolean isColorbar() {
        return this.colorBar;
    }

    public void setColorbar(boolean value) {
        this.colorBar = value;
    }

    public LegendPosition getPosition() {
        return this.position;
    }

    public void setPosition(LegendPosition value) {
        this.position = value;
    }

    public float getShrink() {
        return this.shrink;
    }

    public void setShrink(float value) {
        this.shrink = value;
    }

    public int getAspect() {
        return this.aspect;
    }

    public void setAspect(int value) {
        this.aspect = value;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float value) {
        this.x = value;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float value) {
        this.y = value;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int value) {
        this.width = value;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int value) {
        this.height = value;
    }

    public int getLegendWidth() {
        return this.legendWidth;
    }

    public void setLegendWidth(int value) {
        this.legendWidth = value;
    }

    public int getLegendHeight() {
        return this.legendHeight;
    }

    public void setLegendHeight(int value) {
        this.legendHeight = value;
    }

    public PlotOrientation getPlotOrientation() {
        return this.orientation;
    }

    public void setPlotOrientation(PlotOrientation value) {
        this.orientation = value;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color value) {
        this.background = value;
    }

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean value) {
        this.drawBackground = value;
    }

    public boolean isDrawNeatLine() {
        return this.drawNeatLine;
    }

    public void setDrawNeatLine(boolean istrue) {
        this.drawNeatLine = istrue;
    }

    public Color getNeatLineColor() {
        return this.neatLineColor;
    }

    public void setNeatLineColor(Color color) {
        this.neatLineColor = color;
    }

    public float getNeatLineSize() {
        return this.neatLineSize;
    }

    public void setNeatLineSize(float size) {
        this.neatLineSize = size;
    }

    public ChartText getLabel() {
        return this.label;
    }

    public void setLabel(ChartText value) {
        this.label = value;
    }

    public Font getLabelFont() {
        return this.label.getFont();
    }

    public void setLabelFont(Font value) {
        this.label.setFont(value);
    }

    public Color getLabelColor() {
        return this.label.getColor();
    }

    public void setLabelColor(Color value) {
        this.label.setColor(value);
    }

    public String getLabelLocation() {
        return this.labelLocation;
    }

    public void setLabelLocation(String value) {
        this.labelLocation = value;
    }

    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    public void setTickLabelFont(Font font) {
        this.tickLabelFont = font;
    }

    public Color getTickLabelColor() {
        return this.tickLabelColor;
    }

    public void setTickLabelColor(Color value) {
        this.tickLabelColor = value;
    }

    public float getTickLabelAngle() {
        return this.tickLabelAngle;
    }

    public void setTickLabelAngle(float value) {
        this.tickLabelAngle = value;
    }

    public int getColumnNumber() {
        return this.rowColNum;
    }

    public void setColumnNumber(int value) {
        this.rowColNum = value;
    }

    public boolean isAutoRowColNum() {
        return this.autoRowColNum;
    }

    public void setAutoRowColNum(boolean value) {
        this.autoRowColNum = value;
    }

    public Dimension getSymbolDimension() {
        return this.symbolDimension;
    }

    public void setSymbolDimension(Dimension value) {
        this.symbolDimension = value;
    }

    public void setSymbolWidth(int value) {
        this.symbolDimension.width = value;
    }

    public void setSymbolHeight(int value) {
        this.symbolDimension.height = value;
    }

    public void setSymbolScale(float value) {
        double w = this.symbolDimension.getWidth() * (double)value;
        double h = this.symbolDimension.getHeight() * (double)value;
        this.symbolDimension.setSize(w, h);
    }

    public boolean isExtendRect() {
        return this.extendRect;
    }

    public void setExtendRect(boolean value) {
        this.extendRect = value;
    }

    public boolean isAutoExtendFrac() {
        return this.autoExtendFrac;
    }

    public void setAutoExtendFrac(boolean value) {
        this.autoExtendFrac = value;
    }

    public void setTickCaptions(List<String> value) {
        for (int i = 0; i < this.legendScheme.getBreakNum() && i < value.size(); ++i) {
            this.legendScheme.getLegendBreaks().get(i).setCaption(value.get(i));
        }
    }

    public boolean isDrawMinLabel() {
        return this.drawMinLabel;
    }

    public void setDrawMinLabel(boolean value) {
        this.drawMinLabel = value;
    }

    public boolean isDrawMaxLabel() {
        return this.drawMaxLabel;
    }

    public void setDrawMaxLabel(boolean value) {
        this.drawMaxLabel = value;
    }

    public float getXShift() {
        return this.xshift;
    }

    public void setXShift(float value) {
        this.xshift = value;
    }

    public float getYShift() {
        return this.yshift;
    }

    public void setYShift(float value) {
        this.yshift = value;
    }

    public void draw(Graphics2D g, PointF point) {
        AffineTransform oldMatrix = g.getTransform();
        g.translate(point.X + this.xshift, point.Y + this.yshift);
        if (this.drawBackground) {
            g.setColor(this.background);
            g.fill(new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height));
        }
        g.setStroke(new BasicStroke(1.0f));
        switch (this.orientation) {
            case HORIZONTAL: {
                this.drawHorizontalLegend(g, this.legendScheme);
                break;
            }
            case VERTICAL: {
                this.drawVerticalLegend(g, this.legendScheme);
            }
        }
        if (this.drawNeatLine) {
            Rectangle2D.Float mapRect = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
            g.setColor(this.neatLineColor);
            g.setStroke(new BasicStroke(this.neatLineSize));
            g.draw(mapRect);
        }
        g.setTransform(oldMatrix);
    }

    private void drawVerticalLegend(Graphics2D g, LegendScheme aLS) {
        int i;
        float breakHeight = this.getBreakHeight(g);
        float symbolHeight = this.symbolDimension.height;
        float symbolWidth = this.symbolDimension.width;
        float colWidth = symbolWidth + (float)this.getMaxLabelWidth(g) + 10.0f;
        int[] rowNums = new int[this.rowColNum];
        int ave = aLS.getVisibleBreakNum() / this.rowColNum;
        if (ave * this.rowColNum < aLS.getBreakNum()) {
            ++ave;
        }
        int num = 0;
        for (i = 1; i < this.rowColNum; ++i) {
            rowNums[i] = ave;
            num += ave;
        }
        rowNums[0] = aLS.getVisibleBreakNum() - num;
        float y0 = 0.0f;
        if (this.label != null) {
            float x0 = (float)((double)this.width / 2.0);
            this.label.draw(g, x0, y0 += this.breakSpace * 2.0f);
            y0 += (float)this.label.getDimension((Graphics2D)g).height + this.breakSpace * 2.0f;
        }
        i = 0;
        for (int col = 0; col < this.rowColNum; ++col) {
            float x = symbolWidth / 2.0f + this.leftSpace + (float)col * colWidth;
            float y = y0 + breakHeight / 2.0f + this.breakSpace * 2.0f;
            for (int row = 0; row < rowNums[col]; ++row) {
                ColorBreak cb;
                if (!aLS.getLegendBreaks().get(i).isDrawShape() || !(cb = aLS.getLegendBreaks().get(i)).isDrawShape()) continue;
                String caption = aLS.getLegendBreaks().get(i).getCaption();
                if (cb instanceof PointBreak) {
                    PointBreak aPB = (PointBreak)cb.clone();
                    aPB.setSize(((PointBreak)cb).getSize() * (symbolHeight / 10.0f));
                    Draw.drawPoint(new PointF(x, y), aPB, g);
                } else if (cb instanceof PolylineBreak) {
                    PolylineBreak aPLB = (PolylineBreak)cb;
                    Draw.drawPolylineSymbol_S(new PointF(x, y), symbolWidth, symbolHeight, aPLB, g);
                } else if (cb instanceof PolygonBreak) {
                    Draw.drawPolygonSymbol(new PointF(x, y), symbolWidth, symbolHeight, (PolygonBreak)cb, g);
                } else {
                    PolygonBreak pgb = new PolygonBreak();
                    pgb.setColor(cb.getColor());
                    pgb.setOutlineColor(Color.black);
                    Draw.drawPolygonSymbol(new PointF(x, y), symbolWidth, symbolHeight, pgb, g);
                }
                PointF sP = new PointF(0.0f, 0.0f);
                sP.X = x + symbolWidth / 2.0f;
                sP.Y = y;
                g.setColor(this.tickLabelColor);
                g.setFont(this.tickLabelFont);
                Draw.drawString(g, sP.X + 5.0f, sP.Y, caption, XAlign.LEFT, YAlign.CENTER, true);
                y += breakHeight + this.breakSpace;
                ++i;
            }
        }
    }

    private void drawHorizontalLegend(Graphics2D g, LegendScheme aLS) {
        int i;
        float breakHeight = this.getBreakHeight(g);
        float symbolHeight = this.symbolDimension.height;
        float symbolWidth = this.symbolDimension.width;
        int[] colNums = new int[this.rowColNum];
        int ave = aLS.getVisibleBreakNum() / this.rowColNum;
        if (ave * this.rowColNum < aLS.getBreakNum()) {
            ++ave;
        }
        int num = 0;
        for (i = 0; i < this.rowColNum - 1; ++i) {
            colNums[i] = ave;
            num += ave;
        }
        colNums[this.rowColNum - 1] = aLS.getVisibleBreakNum() - num;
        float y = this.breakSpace + breakHeight / 2.0f;
        i = 0;
        for (int row = 0; row < this.rowColNum; ++row) {
            float x = this.symbolDimension.width / 2 + 5;
            for (int col = 0; col < colNums[row] && i < aLS.getBreakNum(); ++col) {
                ColorBreak cb = aLS.getLegendBreaks().get(i);
                if (!cb.isDrawShape()) continue;
                String caption = aLS.getLegendBreaks().get(i).getCaption();
                if (cb instanceof PointBreak) {
                    PointBreak aPB = (PointBreak)cb;
                    Draw.drawPoint(new PointF(x, y), aPB, g);
                } else if (cb instanceof PolylineBreak) {
                    PolylineBreak aPLB = (PolylineBreak)cb;
                    Draw.drawPolylineSymbol_S(new PointF(x, y), symbolWidth, symbolHeight, aPLB, g);
                } else if (cb instanceof PolygonBreak) {
                    Draw.drawPolygonSymbol(new PointF(x, y), symbolWidth, symbolHeight, (PolygonBreak)cb, g);
                }
                PointF sP = new PointF(0.0f, 0.0f);
                sP.X = x + symbolWidth / 2.0f;
                sP.Y = y;
                g.setColor(this.tickLabelColor);
                g.setFont(this.tickLabelFont);
                Draw.drawString(g, sP.X + 5.0f, sP.Y, caption, XAlign.LEFT, YAlign.CENTER, true);
                Dimension dim = Draw.getStringDimension(caption, g);
                x += (float)(this.symbolDimension.width + dim.width + 15);
                ++i;
            }
            y += breakHeight + this.breakSpace * 2.0f;
        }
    }

    private int getMaxLabelWidth(Graphics2D g) {
        int bNum = this.legendScheme.getBreakNum();
        int labWidth = 0;
        g.setFont(this.tickLabelFont);
        for (int i = 0; i < bNum; ++i) {
            String caption = this.legendScheme.getLegendBreaks().get(i).getCaption();
            boolean isValid = true;
            if (!isValid) continue;
            Dimension aSF = Draw.getStringDimension(caption, this.tickLabelAngle, g);
            int labwidth = aSF.width;
            if (labWidth >= labwidth) continue;
            labWidth = labwidth;
        }
        return labWidth;
    }

    private int getBreakHeight(Graphics2D g) {
        g.setFont(this.tickLabelFont);
        Dimension dim = Draw.getStringDimension(this.legendScheme.getLegendBreak(0).getCaption(), g);
        return Math.max(dim.height, this.symbolDimension.height);
    }

    public Dimension getLegendDimension(Graphics2D g, Dimension limitDim) {
        block39: {
            block40: {
                if (this.legendScheme == null) break block39;
                if (!this.colorBar) break block40;
                block0 : switch (this.orientation) {
                    case VERTICAL: {
                        this.width = (int)((float)this.getTickWidth(g) + (float)limitDim.height * this.shrink / (float)this.aspect + 5.0f);
                        if (this.label != null) {
                            g.setFont(this.label.getFont());
                            this.width += Draw.getStringDimension((String)this.label.getText(), (Graphics2D)g).height + 5;
                            break;
                        }
                        break block39;
                    }
                    default: {
                        g.setFont(this.tickLabelFont);
                        this.height = (int)((float)Draw.getStringDimension((String)"test", (Graphics2D)g).height + (float)limitDim.width * this.shrink / (float)this.aspect + 5.0f);
                        if (this.label != null) {
                            g.setFont(this.label.getFont());
                            Dimension dim = Draw.getStringDimension(this.label.getText(), g);
                            switch (this.labelLocation) {
                                case "top": 
                                case "right": {
                                    this.width += dim.width + 10;
                                    break block0;
                                }
                            }
                            this.height += Draw.getStringDimension((String)this.label.getText(), (Graphics2D)g).height + 5;
                            break;
                        }
                        break block39;
                    }
                }
                break block39;
            }
            int breakHeight = this.getBreakHeight(g);
            int titleHeight = 0;
            int titleWidth = 0;
            if (this.label != null) {
                Dimension dim = this.label.getDimension(g);
                titleHeight = dim.height + (int)(this.breakSpace * 4.0f);
                titleWidth = dim.width;
            }
            switch (this.orientation) {
                case VERTICAL: {
                    if (this.autoRowColNum) {
                        int tHeight = (int)((float)this.legendScheme.getBreakNum() * ((float)breakHeight + this.breakSpace) + this.breakSpace * 2.0f + (float)(breakHeight / 2) + 5.0f);
                        this.rowColNum = 1;
                        if (tHeight > limitDim.height * 10 / 8) {
                            this.rowColNum = tHeight / (limitDim.height * 10 / 8) + 1;
                            if (this.rowColNum == 1) {
                                this.rowColNum = 2;
                            } else {
                                int n = this.legendScheme.getBreakNum() / this.rowColNum;
                                int m = this.legendScheme.getBreakNum() % this.rowColNum;
                                if (m != 0) {
                                    this.rowColNum = m <= n ? ++this.rowColNum : (this.rowColNum += 2);
                                } else if (this.rowColNum * (limitDim.width * 8 / 10) < tHeight) {
                                    ++this.rowColNum;
                                }
                            }
                        }
                    }
                    int colWidth = this.symbolDimension.width + this.getMaxLabelWidth(g) + 15;
                    this.width = colWidth * this.rowColNum;
                    int[] rowNums = new int[this.rowColNum];
                    int ave = this.legendScheme.getBreakNum() / this.rowColNum;
                    if (ave * this.rowColNum < this.legendScheme.getBreakNum()) {
                        ++ave;
                    }
                    int num = 0;
                    for (int i = 0; i < this.rowColNum - 1; ++i) {
                        rowNums[i] = ave;
                        num += ave;
                    }
                    rowNums[this.rowColNum - 1] = this.legendScheme.getBreakNum() - num;
                    this.height = (int)((float)rowNums[0] * ((float)breakHeight + this.breakSpace) + this.breakSpace * 3.0f);
                    break;
                }
                case HORIZONTAL: {
                    if (this.autoRowColNum) {
                        int breakWidth = this.symbolDimension.width + this.getMaxLabelWidth(g) + 15;
                        int tWidth = breakWidth * this.legendScheme.getBreakNum();
                        this.rowColNum = 1;
                        if (tWidth > limitDim.width * 8 / 10) {
                            this.rowColNum = tWidth / (limitDim.width * 8 / 10);
                            if (this.rowColNum == 1) {
                                this.rowColNum = 2;
                            } else {
                                int n = this.legendScheme.getBreakNum() / this.rowColNum;
                                int m = this.legendScheme.getBreakNum() % this.rowColNum;
                                if (m != 0) {
                                    this.rowColNum = m <= n ? ++this.rowColNum : (this.rowColNum += 2);
                                } else if (this.rowColNum * (limitDim.width * 8 / 10) < tWidth) {
                                    ++this.rowColNum;
                                }
                            }
                        }
                    }
                    this.height = (int)((float)breakHeight + this.breakSpace * 2.0f) * this.rowColNum;
                    int ave = this.legendScheme.getBreakNum() / this.rowColNum;
                    if (ave * this.rowColNum < this.legendScheme.getBreakNum()) {
                        ++ave;
                    }
                    int num = 0;
                    int maxWidth = 0;
                    int tempWidth = 0;
                    for (int i = 0; i < this.legendScheme.getBreakNum(); ++i) {
                        if (num < ave) {
                            tempWidth += this.symbolDimension.width + 15 + Draw.getStringDimension((String)this.legendScheme.getLegendBreaks().get((int)i).getCaption(), (Graphics2D)g).width;
                            ++num;
                            continue;
                        }
                        if (maxWidth < tempWidth) {
                            maxWidth = tempWidth;
                        }
                        tempWidth = Draw.getStringDimension((String)this.legendScheme.getLegendBreaks().get((int)i).getCaption(), (Graphics2D)g).width;
                        num = 1;
                    }
                    if (maxWidth < tempWidth) {
                        maxWidth = tempWidth;
                    }
                    if (maxWidth > limitDim.width) {
                        maxWidth = limitDim.width * 8 / 10;
                    }
                    this.width = maxWidth;
                }
            }
            this.height += titleHeight;
            this.width = Math.max(this.width, titleWidth);
        }
        return new Dimension(this.width, this.height);
    }

    protected int getTickWidth(Graphics2D g) {
        float rwidth = 0.0f;
        String caption = "";
        int bNum = this.legendScheme.getBreakNum();
        g.setFont(this.tickLabelFont);
        if (this.legendScheme.getLegendBreaks().get(bNum - 1).isNoData()) {
            --bNum;
        }
        for (int i = 0; i < bNum; ++i) {
            float labwidth;
            switch (this.legendScheme.getShapeType()) {
                case Point: {
                    PointBreak aPB = (PointBreak)this.legendScheme.getLegendBreaks().get(i);
                    if (this.legendScheme.getLegendType() == LegendType.GraduatedColor) {
                        caption = DataConvert.removeTailingZeros(aPB.getEndValue().toString());
                        break;
                    }
                    caption = aPB.getCaption();
                    break;
                }
                case Polyline: {
                    PolylineBreak aPLB = (PolylineBreak)this.legendScheme.getLegendBreaks().get(i);
                    if (this.legendScheme.getLegendType() == LegendType.GraduatedColor) {
                        caption = DataConvert.removeTailingZeros(aPLB.getEndValue().toString());
                        break;
                    }
                    caption = aPLB.getCaption();
                    break;
                }
                case Polygon: {
                    PolygonBreak aPGB = (PolygonBreak)this.legendScheme.getLegendBreaks().get(i);
                    if (this.legendScheme.getLegendType() == LegendType.GraduatedColor) {
                        caption = DataConvert.removeTailingZeros(aPGB.getEndValue().toString());
                        break;
                    }
                    caption = aPGB.getCaption();
                    break;
                }
                case Image: {
                    ColorBreak aCB = this.legendScheme.getLegendBreaks().get(i);
                    caption = this.legendScheme.getLegendType() == LegendType.GraduatedColor ? DataConvert.removeTailingZeros(aCB.getEndValue().toString()) : aCB.getCaption();
                }
            }
            boolean isValid = true;
            switch (this.legendScheme.getLegendType()) {
                case GraduatedColor: {
                    if (i != bNum - 1) break;
                    isValid = false;
                }
            }
            if (!isValid || !(rwidth < (labwidth = (float)Draw.getStringDimension(caption, this.tickLabelAngle, g).getWidth()))) continue;
            rwidth = labwidth;
        }
        return (int)rwidth;
    }

    protected int getTickHeight(Graphics2D g) {
        float rheight = 0.0f;
        String caption = "";
        int bNum = this.legendScheme.getBreakNum();
        g.setFont(this.tickLabelFont);
        if (this.legendScheme.getLegendBreaks().get(bNum - 1).isNoData()) {
            --bNum;
        }
        for (int i = 0; i < bNum; ++i) {
            float labheight;
            switch (this.legendScheme.getShapeType()) {
                case Point: {
                    PointBreak aPB = (PointBreak)this.legendScheme.getLegendBreaks().get(i);
                    if (this.legendScheme.getLegendType() == LegendType.GraduatedColor) {
                        caption = DataConvert.removeTailingZeros(aPB.getEndValue().toString());
                        break;
                    }
                    caption = aPB.getCaption();
                    break;
                }
                case Polyline: {
                    PolylineBreak aPLB = (PolylineBreak)this.legendScheme.getLegendBreaks().get(i);
                    if (this.legendScheme.getLegendType() == LegendType.GraduatedColor) {
                        caption = DataConvert.removeTailingZeros(aPLB.getEndValue().toString());
                        break;
                    }
                    caption = aPLB.getCaption();
                    break;
                }
                case Polygon: {
                    PolygonBreak aPGB = (PolygonBreak)this.legendScheme.getLegendBreaks().get(i);
                    if (this.legendScheme.getLegendType() == LegendType.GraduatedColor) {
                        caption = DataConvert.removeTailingZeros(aPGB.getEndValue().toString());
                        break;
                    }
                    caption = aPGB.getCaption();
                    break;
                }
                case Image: {
                    ColorBreak aCB = this.legendScheme.getLegendBreaks().get(i);
                    caption = this.legendScheme.getLegendType() == LegendType.GraduatedColor ? DataConvert.removeTailingZeros(aCB.getEndValue().toString()) : aCB.getCaption();
                }
            }
            boolean isValid = true;
            switch (this.legendScheme.getLegendType()) {
                case GraduatedColor: {
                    if (i != bNum - 1) break;
                    isValid = false;
                }
            }
            if (!isValid || !(rheight < (labheight = (float)Draw.getStringDimension(caption, 90.0f - Math.abs(this.tickLabelAngle), g).getWidth()))) continue;
            rheight = labheight;
        }
        return (int)rheight;
    }

    protected int getTickGap(Graphics2D g) {
        int nn;
        if (this.tickLabelAngle != 0.0f) {
            return 1;
        }
        int n = this.legendScheme.getBreakNum();
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            double len = this.width;
            int labLen = this.getTickWidth(g);
            nn = (int)(len * 0.8 / (double)labLen);
        } else {
            double len = this.height;
            FontMetrics metrics = g.getFontMetrics(this.tickLabelFont);
            nn = (int)(len / (double)metrics.getHeight());
        }
        if (nn == 0) {
            nn = 1;
        }
        return n / nn + 1;
    }

    public static class PlotOrientationEditor
    extends ComboBoxPropertyEditor {
        public PlotOrientationEditor() {
            PlotOrientation[] orientations = PlotOrientation.values();
            Object[] types = new String[orientations.length];
            int i = 0;
            for (PlotOrientation type : orientations) {
                types[i] = type.toString();
                ++i;
            }
            this.setAvailableValues(types);
        }
    }

    public static class LayoutLegendBeanBeanInfo
    extends BaseBeanInfo {
        public LayoutLegendBeanBeanInfo() {
            super(LayoutLegendBean.class);
            ExtendedPropertyDescriptor e = this.addProperty("plotOrientation");
            e.setCategory("General").setDisplayName("Plot orientation");
            e.setPropertyEditorClass(PlotOrientationEditor.class);
            this.addProperty("tickFont").setCategory("General").setDisplayName("Tick Font");
            this.addProperty("drawBackground").setCategory("General").setDisplayName("Draw Background");
            this.addProperty("background").setCategory("General").setDisplayName("Background");
            this.addProperty("columnNumber").setCategory("General").setDisplayName("Column Number");
            this.addProperty("drawNeatLine").setCategory("Neat Line").setDisplayName("Draw Neat Line");
            this.addProperty("neatLineColor").setCategory("Neat Line").setDisplayName("Neat Line Color");
            this.addProperty("neatLineSize").setCategory("Neat Line").setDisplayName("Neat Line Size");
        }
    }

    public class LayoutLegendBean {
        LayoutLegendBean() {
        }

        public boolean isDrawNeatLine() {
            return ChartLegend.this.drawNeatLine;
        }

        public void setDrawNeatLine(boolean istrue) {
            ChartLegend.this.drawNeatLine = istrue;
        }

        public Color getNeatLineColor() {
            return ChartLegend.this.neatLineColor;
        }

        public void setNeatLineColor(Color color) {
            ChartLegend.this.neatLineColor = color;
        }

        public float getNeatLineSize() {
            return ChartLegend.this.neatLineSize;
        }

        public void setNeatLineSize(float size) {
            ChartLegend.this.neatLineSize = size;
        }

        public Font getTickLabelFont() {
            return ChartLegend.this.tickLabelFont;
        }

        public void setTickLabelFont(Font font) {
            ChartLegend.this.tickLabelFont = font;
        }

        public int getColumnNumber() {
            return ChartLegend.this.rowColNum;
        }

        public void setColumnNumber(int value) {
            ChartLegend.this.rowColNum = value;
        }

        public boolean isDrawBackground() {
            return ChartLegend.this.drawBackground;
        }

        public void setDrawBackground(boolean value) {
            ChartLegend.this.drawBackground = value;
        }

        public Color getBackground() {
            return ChartLegend.this.background;
        }

        public void setBackground(Color c) {
            ChartLegend.this.background = c;
        }
    }
}

