/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.meteoinfo.drawing.Draw;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.PointF;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.legend.ArrowBreak;
import org.meteoinfo.shape.GraphicCollection;
import org.meteoinfo.shape.WindArrow;

public class ChartWindArrow {
    private final WindArrow windArrow = new WindArrow();
    private ArrowBreak arrowBreak;
    private Font font;
    private Color labelColor;
    private float x;
    private float y;
    private String label;
    private int labelSep;
    private Object layer;
    private Color background;
    private boolean drawBackground;
    private boolean drawNeatline;
    private Color neatLineColor;
    private float neatLineSize;

    public ChartWindArrow() {
        this.windArrow.angle = 270.0;
        this.windArrow.length = 20.0f;
        this.arrowBreak = new ArrowBreak();
        this.font = new Font("Arial", 0, 12);
        this.labelColor = Color.black;
        this.labelSep = 5;
        this.background = Color.white;
        this.drawBackground = false;
        this.drawNeatline = false;
        this.neatLineColor = Color.black;
        this.neatLineSize = 1.0f;
    }

    public WindArrow getWindArrow() {
        return this.windArrow;
    }

    public ArrowBreak getArrowBreak() {
        return this.arrowBreak;
    }

    public void setArrowBreak(ArrowBreak value) {
        this.arrowBreak = value;
    }

    public float getLength() {
        return this.windArrow.length;
    }

    public void setLength(float value) {
        this.windArrow.length = value;
        this.label = String.valueOf(value);
        this.label = DataConvert.removeTailingZeros(this.label);
    }

    public double getAngle() {
        return this.windArrow.angle;
    }

    public void setAngle(double value) {
        this.windArrow.angle = value;
    }

    public Object getLayer() {
        return this.layer;
    }

    public void setLayer(Object value) {
        this.layer = value;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font value) {
        this.font = value;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color value) {
        this.labelColor = value;
    }

    public int getLabelSep() {
        return this.labelSep;
    }

    public void setLabelSep(int value) {
        this.labelSep = value;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float value) {
        this.x = value;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float value) {
        this.y = value;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color value) {
        this.background = value;
    }

    public boolean isFill() {
        return this.drawBackground;
    }

    public void setFill(boolean value) {
        this.drawBackground = value;
    }

    public boolean isDrawNeatline() {
        return this.drawNeatline;
    }

    public void setDrawNeatline(boolean value) {
        this.drawNeatline = value;
    }

    public Color getNeatlineColor() {
        return this.neatLineColor;
    }

    public void setNeatlineColor(Color value) {
        this.neatLineColor = value;
    }

    public float getNeatlineSize() {
        return this.neatLineSize;
    }

    public void setNeatlineSize(float value) {
        this.neatLineSize = value;
    }

    public void draw(Graphics2D g, float x, float y) {
        Object rendering = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float zoom = 1.0f;
        if (this.layer != null) {
            if (this.layer instanceof VectorLayer) {
                zoom = ((VectorLayer)this.layer).getDrawingZoom();
            } else if (this.layer instanceof GraphicCollection) {
                zoom = ((GraphicCollection)this.layer).getArrowZoom();
            }
        }
        g.setFont(this.font);
        Dimension dim = Draw.getStringDimension(this.label, g);
        if (this.drawBackground || this.drawNeatline) {
            Rectangle2D rect = Draw.getArrawBorder(new PointF(x, y), this.windArrow, g, zoom);
            double gap = 5.0;
            double width = Math.max(rect.getWidth(), dim.getWidth());
            rect.setRect(rect.getX() - gap, rect.getY() - gap - 2.0, width + gap * 2.0, rect.getHeight() + (double)dim.height + (double)this.labelSep + gap + 2.0);
            if (this.drawBackground) {
                g.setColor(this.background);
                g.fill(rect);
            }
            if (this.drawNeatline) {
                g.setColor(this.neatLineColor);
                g.draw(rect);
            }
        }
        Draw.drawArraw(new PointF(x, y), this.windArrow, this.arrowBreak, g, (double)zoom);
        g.setColor(this.labelColor);
        Draw.drawString(g, this.label, x, y + (float)dim.height + (float)this.labelSep);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rendering);
    }
}

