/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.meteoinfo.chart.ChartLegend;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.ChartText3D;
import org.meteoinfo.chart.LegendPosition;
import org.meteoinfo.chart.Margin;
import org.meteoinfo.chart.axis.Axis;
import org.meteoinfo.chart.plot.Plot;
import org.meteoinfo.chart.plot.PlotOrientation;
import org.meteoinfo.chart.plot.PlotType;
import org.meteoinfo.chart.plot.XAlign;
import org.meteoinfo.chart.plot.YAlign;
import org.meteoinfo.chart.plot3d.GraphicCollection3D;
import org.meteoinfo.chart.plot3d.Projector;
import org.meteoinfo.data.DataMath;
import org.meteoinfo.data.Dataset;
import org.meteoinfo.drawing.Draw;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.Extent3D;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointD;
import org.meteoinfo.global.PointF;
import org.meteoinfo.legend.BreakTypes;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.ColorBreakCollection;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.legend.PolylineBreak;
import org.meteoinfo.math.sort.QuickSort;
import org.meteoinfo.shape.Graphic;
import org.meteoinfo.shape.ImageShape;
import org.meteoinfo.shape.PointZ;
import org.meteoinfo.shape.PointZShape;
import org.meteoinfo.shape.PolygonZ;
import org.meteoinfo.shape.PolygonZShape;
import org.meteoinfo.shape.Polyline;
import org.meteoinfo.shape.PolylineZShape;
import org.meteoinfo.shape.ShapeTypes;
import org.meteoinfo.shape.WindArrow3D;

public class Plot3D
extends Plot {
    private final GraphicCollection3D graphics;
    private Extent3D extent;
    private ChartText title;
    private List<ChartLegend> legends;
    private final Axis xAxis;
    private final Axis yAxis;
    private final Axis zAxis;
    private final Projector projector;
    private int prevwidth;
    private int prevheight;
    private Rectangle graphBounds;
    private boolean isBoxed;
    private boolean isMesh;
    private boolean isScaleBox;
    private boolean isDisplayXY;
    private boolean isDisplayZ;
    private boolean isDisplayGrids;
    private boolean drawBoundingBox;
    private boolean hideOnDrag;
    private float xmin;
    private float xmax;
    private float ymin;
    private float ymax;
    private float zmin;
    private float zmax;
    private Color boxColor = Color.getHSBColor(0.0f, 0.0f, 0.95f);
    private Color lineboxColor = Color.getHSBColor(0.0f, 0.0f, 0.8f);
    private int factor_x;
    private int factor_y;
    private int t_x;
    private int t_y;
    private int t_z;
    private Point projection;
    float xfactor;
    float yfactor;
    float zfactor;

    public Plot3D() {
        this.legends = new ArrayList<ChartLegend>();
        this.xAxis = new Axis();
        this.xAxis.setLabel("X");
        this.xAxis.setTickLength(8);
        this.yAxis = new Axis();
        this.yAxis.setLabel("Y");
        this.yAxis.setTickLength(8);
        this.zAxis = new Axis();
        this.zAxis.setLabel("Z");
        this.zAxis.setTickLength(8);
        this.projector = new Projector();
        this.projector.setDistance(10000.0f);
        this.projector.set2DScaling(15.0f);
        this.projector.setRotationAngle(225.0f);
        this.projector.setElevationAngle(30.0f);
        this.graphics = new GraphicCollection3D();
        this.hideOnDrag = false;
        this.isBoxed = true;
        this.isDisplayGrids = true;
        this.isDisplayXY = true;
        this.isDisplayZ = true;
        this.drawBoundingBox = false;
    }

    public Projector getProjector() {
        return this.projector;
    }

    public ChartText getTitle() {
        return this.title;
    }

    public void setTitle(ChartText value) {
        this.title = value;
    }

    public void setTitle(String text) {
        if (this.title == null) {
            this.title = new ChartText(text);
        } else {
            this.title.setText(text);
        }
    }

    public List<ChartLegend> getLegends() {
        return this.legends;
    }

    public ChartLegend getLegend(int idx) {
        if (this.legends.isEmpty()) {
            return null;
        }
        return this.legends.get(idx);
    }

    public ChartLegend getLegend() {
        if (this.legends.isEmpty()) {
            return null;
        }
        return this.legends.get(this.legends.size() - 1);
    }

    public void setLegend(ChartLegend value) {
        this.legends.clear();
        this.legends.add(value);
    }

    public void setLegends(List<ChartLegend> value) {
        this.legends = value;
    }

    public Axis getXAxis() {
        return this.xAxis;
    }

    public Axis getYAxis() {
        return this.yAxis;
    }

    public Axis getZAxis() {
        return this.zAxis;
    }

    public float getXMin() {
        return this.xmin;
    }

    public void setXMin(float value) {
        this.xmin = value;
        this.updateExtent();
        this.xAxis.setMinMaxValue(this.xmin, this.xmax);
    }

    public float getXMax() {
        return this.xmax;
    }

    public void setXMax(float value) {
        this.xmax = value;
        this.updateExtent();
        this.xAxis.setMinMaxValue(this.xmin, this.xmax);
    }

    public void setXMinMax(float min, float max) {
        this.xmin = min;
        this.xmax = max;
        this.updateExtent();
        this.xAxis.setMinMaxValue(min, max);
    }

    public float getYMin() {
        return this.ymin;
    }

    public void setYMin(float value) {
        this.ymin = value;
        this.updateExtent();
        this.yAxis.setMinMaxValue(this.ymin, this.ymax);
    }

    public float getYMax() {
        return this.ymax;
    }

    public void setYMax(float value) {
        this.ymax = value;
        this.updateExtent();
        this.yAxis.setMinMaxValue(this.ymin, this.ymax);
    }

    public void setYMinMax(float min, float max) {
        this.ymin = min;
        this.ymax = max;
        this.updateExtent();
        this.yAxis.setMinMaxValue(min, max);
    }

    public float getZMin() {
        return this.zmin;
    }

    public void setZMin(float value) {
        this.zmin = value;
        this.updateExtent();
        this.zAxis.setMinMaxValue(this.zmin, this.zmax);
    }

    public float getZMax() {
        return this.zmax;
    }

    public void setZMax(float value) {
        this.zmax = value;
        this.updateExtent();
        this.zAxis.setMinMaxValue(this.zmin, this.zmax);
    }

    public void setZMinMax(float min, float max) {
        this.zmin = min;
        this.zmax = max;
        this.updateExtent();
        this.zAxis.setMinMaxValue(min, max);
    }

    public void setDisplayXY(boolean value) {
        this.isDisplayXY = value;
    }

    public void setDisplayZ(boolean value) {
        this.isDisplayZ = value;
    }

    public void setDisplayGrids(boolean value) {
        this.isDisplayGrids = value;
    }

    public void setBoxed(boolean value) {
        this.isBoxed = value;
    }

    public void setMesh(boolean value) {
        this.isMesh = value;
    }

    public boolean getDrawBoundingBox() {
        return this.drawBoundingBox;
    }

    public void setDrawBoundingBox(boolean value) {
        this.drawBoundingBox = value;
    }

    public Extent3D getExtent() {
        return this.extent;
    }

    public void setExtent(Extent3D value) {
        this.extent = value;
        this.xmin = (float)this.extent.minX;
        this.xmax = (float)this.extent.maxX;
        this.ymin = (float)this.extent.minY;
        this.ymax = (float)this.extent.maxY;
        this.zmin = (float)this.extent.minZ;
        this.zmax = (float)this.extent.maxZ;
        this.xAxis.setMinMaxValue(this.xmin, this.xmax);
        this.yAxis.setMinMaxValue(this.ymin, this.ymax);
        this.zAxis.setMinMaxValue(this.zmin, this.zmax);
        this.projector.setZRange(this.zmin, this.zmax);
    }

    private void updateExtent() {
        this.extent = new Extent3D(this.xmin, this.xmax, this.ymin, this.ymax, this.zmin, this.zmax);
    }

    public void setAxisTickFont(Font font) {
        this.xAxis.setTickLabelFont(font);
        this.yAxis.setTickLabelFont(font);
        this.zAxis.setTickLabelFont(font);
    }

    public void addGraphic(Graphic g) {
        this.graphics.add(g);
        Extent ex = this.graphics.getExtent();
        if (!ex.is3D()) {
            ex = ex.to3D();
        }
        this.setExtent((Extent3D)ex);
    }

    public void destroyImage() {
        this.repaint();
    }

    private void repaint() {
    }

    public void addLegend(ChartLegend legend) {
        this.legends.add(legend);
    }

    public void removeLegend(ChartLegend legend) {
        this.legends.remove(legend);
    }

    public void removeLegend(int idx) {
        this.legends.remove(idx);
    }

    @Override
    public Rectangle2D getOuterPositionArea(Rectangle2D area) {
        Rectangle2D rect = this.getOuterPosition();
        double x = area.getWidth() * rect.getX() + area.getX();
        double y = area.getHeight() * (1.0 - rect.getHeight() - rect.getY()) + area.getY();
        double w = area.getWidth() * rect.getWidth();
        double h = area.getHeight() * rect.getHeight();
        return new Rectangle2D.Double(x, y, w, h);
    }

    @Override
    public Dataset getDataset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDataset(Dataset dataset) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PlotType getPlotType() {
        return PlotType.XYZ;
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D area) {
        this.setGraphArea(this.getPositionArea());
        float y = this.drawTitle(g2, this.getGraphArea());
        Rectangle parea = this.getPositionArea(area).getBounds();
        if (parea.width != this.prevwidth || parea.height != this.prevheight) {
            this.prevwidth = parea.width;
            this.prevheight = parea.height;
        }
        this.projector.setProjectionArea(parea);
        this.xfactor = 20.0f / (this.xmax - this.xmin);
        this.yfactor = 20.0f / (this.ymax - this.ymin);
        this.zfactor = 20.0f / (this.zmax - this.zmin);
        this.graphBounds = this.projector.getBounds();
        this.drawBoxGridsTicksLabels(g2);
        Polygon border = this.getBorder();
        Rectangle oldClip = g2.getClipBounds();
        g2.setClip(border);
        this.drawAllGraphics(g2);
        g2.setClip(oldClip);
        if (this.drawBoundingBox) {
            this.drawBoundingBox(g2);
        }
        this.drawLegend(g2, area, this.graphBounds, y);
    }

    float drawTitle(Graphics2D g, Rectangle2D graphArea) {
        float y = (float)graphArea.getY();
        if (this.title != null) {
            float x = (float)(graphArea.getX() + graphArea.getWidth() / 2.0);
            this.title.draw(g, x, y -= 8.0f);
            g.setFont(new Font("Arial", 0, 14));
        }
        return y;
    }

    private void drawAllGraphics(Graphics2D g2) {
        for (int m = 0; m < this.graphics.getNumGraphics(); ++m) {
            Graphic graphic = this.graphics.get(m);
            if (graphic instanceof GraphicCollection3D && ((GraphicCollection3D)graphic).isFixZ()) {
                this.drawGraphics_FixZ(g2, graphic);
                continue;
            }
            this.drawGrahpics(g2, graphic);
        }
    }

    private void drawGrahic(Graphics2D g, Graphic graphic) {
        org.meteoinfo.shape.Shape shape = graphic.getGraphicN(0).getShape();
        switch (shape.getShapeType()) {
            case Point: 
            case PointZ: {
                this.drawPoint(g, graphic);
                break;
            }
            case TEXT: {
                this.drawText((ChartText3D)shape, g);
                break;
            }
            case Polyline: 
            case PolylineZ: {
                this.drawLineString(g, graphic);
                break;
            }
            case Polygon: 
            case PolygonZ: {
                this.drawPolygonShape(g, graphic);
                break;
            }
            case WindArraw: {
                this.drawWindArrow(g, graphic);
                break;
            }
        }
    }

    private void drawGraphics_FixZ(Graphics2D g, Graphic graphic) {
        float zValue = (float)((GraphicCollection3D)graphic).getZValue();
        String zdir = ((GraphicCollection3D)graphic).getZDir();
        Polygon polygon = new Polygon();
        ArrayList<Point> points = new ArrayList<Point>();
        switch (zdir) {
            case "x": {
                zValue = (zValue - this.xmin) * this.xfactor - 10.0f;
                Point p = this.projector.project(zValue, -10.0f, -10.0f);
                points.add(p);
                p = this.projector.project(zValue, -10.0f, 10.0f);
                points.add(p);
                p = this.projector.project(zValue, 10.0f, 10.0f);
                points.add(p);
                p = this.projector.project(zValue, 10.0f, -10.0f);
                points.add(p);
                break;
            }
            case "y": {
                zValue = (zValue - this.ymin) * this.yfactor - 10.0f;
                Point p = this.projector.project(-10.0f, zValue, -10.0f);
                points.add(p);
                p = this.projector.project(-10.0f, zValue, 10.0f);
                points.add(p);
                p = this.projector.project(10.0f, zValue, 10.0f);
                points.add(p);
                p = this.projector.project(10.0f, zValue, -10.0f);
                points.add(p);
                break;
            }
            case "xy": {
                List<Number> sePoint = ((GraphicCollection3D)graphic).getSEPoint();
                if (sePoint == null || sePoint.size() <= 3) break;
                float sx = sePoint.get(0).floatValue();
                float sy = sePoint.get(1).floatValue();
                float ex = sePoint.get(2).floatValue();
                float ey = sePoint.get(3).floatValue();
                sx = (sx - this.xmin) * this.xfactor - 10.0f;
                ex = (ex - this.xmin) * this.xfactor - 10.0f;
                sy = (sy - this.ymin) * this.yfactor - 10.0f;
                ey = (ey - this.ymin) * this.yfactor - 10.0f;
                Point p = this.projector.project(sx, sy, -10.0f);
                points.add(p);
                p = this.projector.project(sx, sy, 10.0f);
                points.add(p);
                p = this.projector.project(ex, ey, 10.0f);
                points.add(p);
                p = this.projector.project(ex, ey, -10.0f);
                points.add(p);
                break;
            }
            case "z": {
                zValue = (zValue - this.zmin) * this.zfactor - 10.0f;
                Point p = this.projector.project(-10.0f, -10.0f, zValue);
                points.add(p);
                p = this.projector.project(-10.0f, 10.0f, zValue);
                points.add(p);
                p = this.projector.project(10.0f, 10.0f, zValue);
                points.add(p);
                p = this.projector.project(10.0f, -10.0f, zValue);
                points.add(p);
            }
        }
        Shape oldRegion = g.getClip();
        if (points.size() > 3) {
            for (Point pp : points) {
                polygon.addPoint(pp.x, pp.y);
            }
            g.setClip(polygon);
        }
        for (int i = 0; i < graphic.getNumGraphics(); ++i) {
            Graphic gg = graphic.getGraphicN(i);
            if (gg.getShape().getShapeType() == ShapeTypes.Image) {
                this.drawImage(g, gg, zdir, (float)((GraphicCollection3D)graphic).getZValue());
                continue;
            }
            this.drawGrahic(g, gg);
        }
        if (points.size() > 3) {
            g.setClip(oldRegion);
        }
    }

    private void drawGrahpics(Graphics2D g, Graphic graphic) {
        if (graphic.getNumGraphics() == 1) {
            Graphic gg = graphic.getGraphicN(0);
            this.drawGrahic(g, gg);
        } else {
            double d;
            PointZ p;
            org.meteoinfo.shape.Shape shape;
            Graphic gg;
            int i;
            int n = graphic.getNumGraphics();
            double[] dds = new double[n];
            int[] order = new int[n];
            float angle = this.projector.getRotationAngle();
            boolean xdir = true;
            if (angle < 45.0f || angle > 135.0f && angle < 225.0f || angle > 315.0f) {
                xdir = false;
            }
            if (xdir) {
                for (i = 0; i < n; ++i) {
                    gg = graphic.getGraphicN(i);
                    shape = gg.getShape();
                    p = (PointZ)shape.getPoints().get(0);
                    dds[i] = d = p.X * (double)this.projector.getSinRotationAngle();
                    order[i] = i;
                }
            } else {
                for (i = 0; i < graphic.getNumGraphics(); ++i) {
                    gg = graphic.getGraphicN(i);
                    shape = gg.getShape();
                    p = (PointZ)shape.getPoints().get(0);
                    dds[i] = d = p.Y * (double)this.projector.getCosRotationAngle();
                    order[i] = i;
                }
            }
            QuickSort.sort(dds, order);
            for (int i2 : order) {
                Graphic gg2 = graphic.getGraphicN(i2);
                this.drawGrahic(g, gg2);
            }
        }
    }

    private void drawGrahpics_bak(Graphics2D g, Graphic graphic) {
        if (graphic.getNumGraphics() == 1) {
            Graphic gg = graphic.getGraphicN(0);
            this.drawGrahic(g, gg);
        } else {
            int j;
            boolean isIn;
            double d;
            PointZ p;
            org.meteoinfo.shape.Shape shape;
            Graphic gg;
            int i;
            ArrayList<Double> dds = new ArrayList<Double>();
            ArrayList<Integer> order = new ArrayList<Integer>();
            float angle = this.projector.getRotationAngle();
            boolean xdir = true;
            if (angle < 45.0f || angle > 135.0f && angle < 225.0f || angle > 315.0f) {
                xdir = false;
            }
            if (xdir) {
                for (i = 0; i < graphic.getNumGraphics(); ++i) {
                    gg = graphic.getGraphicN(i);
                    shape = gg.getShape();
                    p = (PointZ)shape.getPoints().get(0);
                    d = p.X * (double)this.projector.getSinRotationAngle();
                    isIn = false;
                    for (j = 0; j < dds.size(); ++j) {
                        if (!(d < (Double)dds.get(j))) continue;
                        dds.add(j, d);
                        order.add(j, i);
                        isIn = true;
                        break;
                    }
                    if (isIn) continue;
                    dds.add(d);
                    order.add(i);
                }
            } else {
                for (i = 0; i < graphic.getNumGraphics(); ++i) {
                    gg = graphic.getGraphicN(i);
                    shape = gg.getShape();
                    p = (PointZ)shape.getPoints().get(0);
                    d = p.Y * (double)this.projector.getCosRotationAngle();
                    isIn = false;
                    for (j = 0; j < dds.size(); ++j) {
                        if (!(d < (Double)dds.get(j))) continue;
                        dds.add(j, d);
                        order.add(j, i);
                        isIn = true;
                        break;
                    }
                    if (isIn) continue;
                    dds.add(d);
                    order.add(i);
                }
            }
            Iterator iterator = order.iterator();
            while (iterator.hasNext()) {
                int i2 = (Integer)iterator.next();
                Graphic gg2 = graphic.getGraphicN(i2);
                this.drawGrahic(g, gg2);
            }
        }
    }

    private void drawPoints(Graphics2D g, Graphic graphic) {
        if (graphic.getNumGraphics() == 1) {
            Graphic gg = graphic.getGraphicN(0);
            this.drawPoint(g, gg);
        } else {
            int j;
            boolean isIn;
            double d;
            PointZ p;
            PointZShape shape;
            Graphic gg;
            int i;
            ArrayList<Double> dds = new ArrayList<Double>();
            ArrayList<Integer> order = new ArrayList<Integer>();
            float angle = this.projector.getRotationAngle();
            boolean xdir = true;
            if (angle < 45.0f || angle > 135.0f && angle < 225.0f || angle > 315.0f) {
                xdir = false;
            }
            if (xdir) {
                for (i = 0; i < graphic.getNumGraphics(); ++i) {
                    gg = graphic.getGraphicN(i);
                    shape = (PointZShape)gg.getShape();
                    p = (PointZ)shape.getPoint();
                    d = p.X * (double)this.projector.getSinRotationAngle();
                    isIn = false;
                    for (j = 0; j < dds.size(); ++j) {
                        if (!(d < (Double)dds.get(j))) continue;
                        dds.add(j, d);
                        order.add(j, i);
                        isIn = true;
                        break;
                    }
                    if (isIn) continue;
                    dds.add(d);
                    order.add(i);
                }
            } else {
                for (i = 0; i < graphic.getNumGraphics(); ++i) {
                    gg = graphic.getGraphicN(i);
                    shape = (PointZShape)gg.getShape();
                    p = (PointZ)shape.getPoint();
                    d = p.Y * (double)this.projector.getCosRotationAngle();
                    isIn = false;
                    for (j = 0; j < dds.size(); ++j) {
                        if (!(d < (Double)dds.get(j))) continue;
                        dds.add(j, d);
                        order.add(j, i);
                        isIn = true;
                        break;
                    }
                    if (isIn) continue;
                    dds.add(d);
                    order.add(i);
                }
            }
            Iterator iterator = order.iterator();
            while (iterator.hasNext()) {
                int i2 = (Integer)iterator.next();
                Graphic gg2 = graphic.getGraphicN(i2);
                this.drawPoint(g, gg2);
            }
        }
    }

    public Point project(float x, float y, float z) {
        return this.projector.project((x - this.xmin) * this.xfactor - 10.0f, (y - this.ymin) * this.yfactor - 10.0f, (z - this.zmin) * this.zfactor - 10.0f);
    }

    void drawText(ChartText3D text, Graphics2D g) {
        Point p = this.project((float)text.getX(), (float)text.getY(), (float)text.getZ());
        float x = p.x;
        float y = p.y;
        this.drawText(g, text, x, y);
    }

    private void drawText(Graphics2D g, ChartText3D text, float x, float y) {
        AffineTransform tempTrans = g.getTransform();
        AffineTransform myTrans = (AffineTransform)tempTrans.clone();
        myTrans.translate(x, y);
        if (text.getZDir() != null) {
            text.updateAngle(this.projector);
            float angle = text.getAngle() + 90.0f;
            myTrans.rotate((double)(-angle) * Math.PI / 180.0);
        }
        g.setTransform(myTrans);
        g.setFont(text.getFont());
        g.setColor(text.getColor());
        x = 0.0f;
        y = 0.0f;
        switch (text.getYAlign()) {
            case TOP: {
                y += (float)g.getFontMetrics(g.getFont()).getAscent();
                break;
            }
            case CENTER: {
                y += (float)(g.getFontMetrics(g.getFont()).getAscent() / 2);
            }
        }
        String s = text.getText();
        Dimension labSize = Draw.getStringDimension(s, g);
        switch (text.getXAlign()) {
            case RIGHT: {
                x -= (float)labSize.width;
                break;
            }
            case CENTER: {
                x -= (float)(labSize.width / 2);
            }
        }
        Draw.drawString(g, s, x, y);
        g.setTransform(tempTrans);
    }

    private void drawPoint(Graphics2D g, Graphic graphic) {
        if (this.extent.intersects(graphic.getExtent())) {
            PointZShape shape = (PointZShape)graphic.getShape();
            PointBreak pb = (PointBreak)graphic.getLegend();
            PointZ p = (PointZ)shape.getPoint();
            PointZ pp = new PointZ((p.X - (double)this.xmin) * (double)this.xfactor - 10.0, (p.Y - (double)this.ymin) * (double)this.yfactor - 10.0, (p.Z - (double)this.zmin) * (double)this.zfactor - 10.0);
            this.projection = this.projector.project((float)pp.X, (float)pp.Y, (float)pp.Z);
            PointF pf = new PointF(this.projection.x, this.projection.y);
            Draw.drawPoint(pf, pb, g);
        }
    }

    private void drawLineStrings(Graphics2D g, Graphic graphic) {
        if (graphic.getNumGraphics() == 1) {
            Graphic gg = graphic.getGraphicN(0);
            this.drawLineString(g, gg);
        } else {
            int j;
            boolean isIn;
            double d;
            PointZ p;
            org.meteoinfo.shape.Shape shape;
            Graphic gg;
            int i;
            ArrayList<Double> dds = new ArrayList<Double>();
            ArrayList<Integer> order = new ArrayList<Integer>();
            float angle = this.projector.getRotationAngle();
            boolean xdir = true;
            if (angle < 45.0f || angle > 135.0f && angle < 225.0f || angle > 315.0f) {
                xdir = false;
            }
            if (xdir) {
                for (i = 0; i < graphic.getNumGraphics(); ++i) {
                    gg = graphic.getGraphicN(i);
                    shape = gg.getShape();
                    p = (PointZ)shape.getPoints().get(0);
                    d = p.X * (double)this.projector.getSinRotationAngle();
                    isIn = false;
                    for (j = 0; j < dds.size(); ++j) {
                        if (!(d < (Double)dds.get(j))) continue;
                        dds.add(j, d);
                        order.add(j, i);
                        isIn = true;
                        break;
                    }
                    if (isIn) continue;
                    dds.add(d);
                    order.add(i);
                }
            } else {
                for (i = 0; i < graphic.getNumGraphics(); ++i) {
                    gg = graphic.getGraphicN(i);
                    shape = gg.getShape();
                    p = (PointZ)shape.getPoints().get(0);
                    d = p.Y * (double)this.projector.getCosRotationAngle();
                    isIn = false;
                    for (j = 0; j < dds.size(); ++j) {
                        if (!(d < (Double)dds.get(j))) continue;
                        dds.add(j, d);
                        order.add(j, i);
                        isIn = true;
                        break;
                    }
                    if (isIn) continue;
                    dds.add(d);
                    order.add(i);
                }
            }
            Iterator iterator = order.iterator();
            while (iterator.hasNext()) {
                int i2 = (Integer)iterator.next();
                Graphic gg2 = graphic.getGraphicN(i2);
                this.drawLineString(g, gg2);
            }
        }
    }

    private void drawLineString(Graphics2D g, Graphic graphic) {
        if (this.extent.intersects(graphic.getExtent())) {
            PolylineZShape shape = (PolylineZShape)graphic.getShape();
            ColorBreak pb = graphic.getLegend();
            for (Polyline polyline : shape.getPolylines()) {
                List<? extends PointD> ps = polyline.getPointList();
                PointF[] points = new PointF[ps.size()];
                for (int i = 0; i < ps.size(); ++i) {
                    PointZ p = (PointZ)ps.get(i);
                    PointZ pp = new PointZ((p.X - (double)this.xmin) * (double)this.xfactor - 10.0, (p.Y - (double)this.ymin) * (double)this.yfactor - 10.0, (p.Z - (double)this.zmin) * (double)this.zfactor - 10.0);
                    this.projection = this.projector.project((float)pp.X, (float)pp.Y, (float)pp.Z);
                    points[i] = new PointF(this.projection.x, this.projection.y);
                }
                if (pb.getBreakType() == BreakTypes.ColorBreakCollection) {
                    Draw.drawPolyline(points, (ColorBreakCollection)pb, g);
                    continue;
                }
                Draw.drawPolyline(points, (PolylineBreak)pb, g);
            }
        }
    }

    private void drawPolygons(Graphics2D g, Graphic graphic) {
        int j;
        boolean isIn;
        double d;
        PointZ p;
        org.meteoinfo.shape.Shape shape;
        Graphic gg;
        int i;
        ArrayList<Double> dds = new ArrayList<Double>();
        ArrayList<Integer> order = new ArrayList<Integer>();
        float angle = this.projector.getRotationAngle();
        boolean xdir = true;
        if (angle < 45.0f || angle > 135.0f && angle < 225.0f || angle > 315.0f) {
            xdir = false;
        }
        if (xdir) {
            for (i = 0; i < graphic.getNumGraphics(); ++i) {
                gg = graphic.getGraphicN(i);
                shape = gg.getShape();
                p = (PointZ)shape.getPoints().get(0);
                d = p.X * (double)this.projector.getSinRotationAngle();
                isIn = false;
                for (j = 0; j < dds.size(); ++j) {
                    if (!(d < (Double)dds.get(j))) continue;
                    dds.add(j, d);
                    order.add(j, i);
                    isIn = true;
                    break;
                }
                if (isIn) continue;
                dds.add(d);
                order.add(i);
            }
        } else {
            for (i = 0; i < graphic.getNumGraphics(); ++i) {
                gg = graphic.getGraphicN(i);
                shape = gg.getShape();
                p = (PointZ)shape.getPoints().get(0);
                d = p.Y * (double)this.projector.getCosRotationAngle();
                isIn = false;
                for (j = 0; j < dds.size(); ++j) {
                    if (!(d < (Double)dds.get(j))) continue;
                    dds.add(j, d);
                    order.add(j, i);
                    isIn = true;
                    break;
                }
                if (isIn) continue;
                dds.add(d);
                order.add(i);
            }
        }
        Iterator iterator = order.iterator();
        while (iterator.hasNext()) {
            int i2 = (Integer)iterator.next();
            Graphic gg2 = graphic.getGraphicN(i2);
            this.drawPolygonShape(g, gg2);
        }
    }

    private void drawPolygonShape(Graphics2D g, Graphic graphic) {
        if (this.extent.intersects(graphic.getExtent())) {
            PolygonZShape shape = (PolygonZShape)graphic.getShape();
            PolygonBreak pb = (PolygonBreak)graphic.getLegend();
            for (PolygonZ polygonZ : shape.getPolygons()) {
                this.drawPolygon(g, polygonZ, pb);
            }
        }
    }

    private List<PointF> drawPolygon(Graphics2D g, PolygonZ aPG, PolygonBreak aPGB) {
        PointZ pp;
        PointZ p;
        int len = aPG.getOutLine().size();
        GeneralPath path = new GeneralPath(0, len);
        ArrayList<PointF> rPoints = new ArrayList<PointF>();
        for (int i = 0; i < aPG.getOutLine().size(); ++i) {
            p = (PointZ)aPG.getOutLine().get(i);
            pp = new PointZ((p.X - (double)this.xmin) * (double)this.xfactor - 10.0, (p.Y - (double)this.ymin) * (double)this.yfactor - 10.0, (p.Z - (double)this.zmin) * (double)this.zfactor - 10.0);
            this.projection = this.projector.project((float)pp.X, (float)pp.Y, (float)pp.Z);
            if (i == 0) {
                path.moveTo(this.projection.x, this.projection.y);
            } else {
                path.lineTo(this.projection.x, this.projection.y);
            }
            rPoints.add(new PointF(this.projection.x, this.projection.y));
        }
        if (aPG.hasHole()) {
            for (int h = 0; h < aPG.getHoleLines().size(); ++h) {
                List<? extends PointD> newPList = aPG.getHoleLines().get(h);
                for (int j = 0; j < newPList.size(); ++j) {
                    p = (PointZ)newPList.get(j);
                    pp = new PointZ((p.X - (double)this.xmin) * (double)this.xfactor - 10.0, (p.Y - (double)this.ymin) * (double)this.yfactor - 10.0, (p.Z - (double)this.zmin) * (double)this.zfactor - 10.0);
                    this.projection = this.projector.project((float)pp.X, (float)pp.Y, (float)pp.Z);
                    if (j == 0) {
                        path.moveTo(this.projection.x, this.projection.y);
                        continue;
                    }
                    path.lineTo(this.projection.x, this.projection.y);
                }
            }
        }
        path.closePath();
        if (aPGB.isDrawFill()) {
            Color aColor = aPGB.getColor();
            if (aPGB.isUsingHatchStyle()) {
                int size = aPGB.getStyleSize();
                BufferedImage bi = Draw.getHatchImage(aPGB.getStyle(), size, aPGB.getColor(), aPGB.getBackColor());
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, size, size);
                g.setPaint(new TexturePaint(bi, rect));
                g.fill(path);
            } else {
                g.setColor(aColor);
                g.fill(path);
            }
        }
        if (aPGB.isDrawOutline()) {
            BasicStroke pen = new BasicStroke(aPGB.getOutlineSize());
            g.setStroke(pen);
            g.setColor(aPGB.getOutlineColor());
            g.draw(path);
        }
        return rPoints;
    }

    private void drawImage(Graphics2D g, Graphic igraphic, String zdir, float zValue) {
        ImageShape ishape = (ImageShape)igraphic.getShape();
        BufferedImage image = ishape.getImage();
        Extent3D ext = (Extent3D)ishape.getExtent();
        AffineTransform transform = new AffineTransform();
        transform.setToIdentity();
        switch (zdir) {
            case "x": {
                double angle;
                zValue = (zValue - this.xmin) * this.xfactor - 10.0f;
                float miny = ((float)ext.minY - this.ymin) * this.yfactor - 10.0f;
                float maxy = ((float)ext.maxY - this.ymin) * this.yfactor - 10.0f;
                float minz = ((float)ext.minZ - this.zmin) * this.zfactor - 10.0f;
                float maxz = ((float)ext.maxZ - this.zmin) * this.zfactor - 10.0f;
                Point p1 = this.projector.project(zValue, miny, maxz);
                Point p2 = this.projector.project(zValue, maxy, maxz);
                Point p3 = this.projector.project(zValue, maxy, minz);
                Point p4 = this.projector.project(zValue, miny, minz);
                double xscale = (double)Math.abs(p2.x - p1.x) / (double)image.getWidth();
                double yscale = (double)Math.abs(p1.y - p4.y) / (double)image.getHeight();
                double xtran = p1.x;
                double ytran = p1.y;
                if (p2.x > p1.x) {
                    angle = MIMath.cartesianToPolar(p2.x - p1.x, p1.y - p2.y)[0];
                } else {
                    angle = MIMath.cartesianToPolar(p1.x - p2.x, p2.y - p1.y)[0];
                    xscale = -xscale;
                }
                angle = -angle;
                transform.setTransform(Math.cos(angle), Math.sin(angle), 0.0, 1.0, xtran, ytran);
                transform.scale(xscale / Math.cos(angle), yscale);
                break;
            }
            case "y": {
                double angle;
                zValue = (zValue - this.ymin) * this.yfactor - 10.0f;
                float minx = ((float)ext.minX - this.xmin) * this.xfactor - 10.0f;
                float maxx = ((float)ext.maxX - this.xmin) * this.xfactor - 10.0f;
                float minz = ((float)ext.minZ - this.zmin) * this.zfactor - 10.0f;
                float maxz = ((float)ext.maxZ - this.zmin) * this.zfactor - 10.0f;
                Point p1 = this.projector.project(minx, zValue, maxz);
                Point p2 = this.projector.project(maxx, zValue, maxz);
                Point p3 = this.projector.project(maxx, zValue, minz);
                Point p4 = this.projector.project(minx, zValue, minz);
                double xscale = (double)Math.abs(p2.x - p1.x) / (double)image.getWidth();
                double yscale = (double)Math.abs(p1.y - p4.y) / (double)image.getHeight();
                double xtran = p1.x;
                double ytran = p1.y;
                if (p2.x > p1.x) {
                    angle = MIMath.cartesianToPolar(p2.x - p1.x, p1.y - p2.y)[0];
                } else {
                    angle = MIMath.cartesianToPolar(p1.x - p2.x, p2.y - p1.y)[0];
                    xscale = -xscale;
                }
                angle = -angle;
                transform.setTransform(Math.cos(angle), Math.sin(angle), 0.0, 1.0, xtran, ytran);
                transform.scale(xscale / Math.cos(angle), yscale);
                break;
            }
            case "xy": {
                double angle;
                float miny = ((float)ext.minY - this.ymin) * this.yfactor - 10.0f;
                float maxy = ((float)ext.maxY - this.ymin) * this.yfactor - 10.0f;
                float minx = ((float)ext.minX - this.xmin) * this.xfactor - 10.0f;
                float maxx = ((float)ext.maxX - this.xmin) * this.xfactor - 10.0f;
                float minz = ((float)ext.minZ - this.zmin) * this.zfactor - 10.0f;
                float maxz = ((float)ext.maxZ - this.zmin) * this.zfactor - 10.0f;
                Point p1 = this.projector.project(minx, miny, maxz);
                Point p2 = this.projector.project(maxx, maxy, maxz);
                Point p3 = this.projector.project(maxx, maxy, minz);
                Point p4 = this.projector.project(minx, miny, minz);
                double xscale = (double)Math.abs(p2.x - p1.x) / (double)image.getWidth();
                double yscale = (double)Math.abs(p1.y - p4.y) / (double)image.getHeight();
                double xtran = p1.x;
                double ytran = p1.y;
                if (p2.x > p1.x) {
                    angle = MIMath.cartesianToPolar(p2.x - p1.x, p1.y - p2.y)[0];
                } else {
                    angle = MIMath.cartesianToPolar(p1.x - p2.x, p2.y - p1.y)[0];
                    xscale = -xscale;
                }
                angle = -angle;
                transform.setTransform(Math.cos(angle), Math.sin(angle), 0.0, 1.0, xtran, ytran);
                transform.scale(xscale / Math.cos(angle), yscale);
                break;
            }
            case "z": {
                zValue = (zValue - this.zmin) * this.zfactor - 10.0f;
                float minx = ((float)ext.minX - this.xmin) * this.xfactor - 10.0f;
                float maxx = ((float)ext.maxX - this.xmin) * this.xfactor - 10.0f;
                float miny = ((float)ext.minY - this.ymin) * this.yfactor - 10.0f;
                float maxy = ((float)ext.maxY - this.ymin) * this.yfactor - 10.0f;
                Point p1 = this.projector.project(minx, maxy, zValue);
                Point p2 = this.projector.project(maxx, maxy, zValue);
                Point p3 = this.projector.project(maxx, miny, zValue);
                Point p4 = this.projector.project(minx, miny, zValue);
                double xscale = (double)Math.abs(p2.x - p1.x) / (double)image.getWidth();
                double yscale = (double)Math.abs(p1.y - p4.y) / (double)image.getHeight();
                double xtran = p1.x;
                double ytran = p1.y;
                double angle = MIMath.cartesianToPolar(p2.x - p1.x, p1.y - p2.y)[0];
                double angle_y = MIMath.cartesianToPolar(p4.x - p1.x, p4.y - p1.y)[0];
                if (p2.x < p1.x) {
                    xscale = -xscale;
                    yscale = -yscale;
                }
                angle = -angle;
                angle_y = 1.5707963267948966 - angle_y;
                angle_y = -angle_y;
                transform.setTransform(Math.cos(angle), Math.sin(angle), -Math.sin(angle_y), Math.cos(angle_y), xtran, ytran);
                transform.scale(xscale / Math.cos(angle), yscale / Math.cos(angle_y));
            }
        }
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, ishape.getInterpolation());
        g.drawImage(image, transform, null);
    }

    private void drawWindArrow(Graphics2D g, Graphic graphic) {
        if (this.extent.intersects(graphic.getExtent())) {
            WindArrow3D shape = (WindArrow3D)graphic.getShape();
            PointBreak pb = (PointBreak)graphic.getLegend();
            PointZ p = (PointZ)shape.getPoint();
            PointZ pp = new PointZ((p.X - (double)this.xmin) * (double)this.xfactor - 10.0, (p.Y - (double)this.ymin) * (double)this.yfactor - 10.0, (p.Z - (double)this.zmin) * (double)this.zfactor - 10.0);
            this.projection = this.projector.project((float)pp.X, (float)pp.Y, (float)pp.Z);
            PointF pf = new PointF(this.projection.x, this.projection.y);
            p = shape.getEndPoint();
            pp = new PointZ((p.X - (double)this.xmin) * (double)this.xfactor - 10.0, (p.Y - (double)this.ymin) * (double)this.yfactor - 10.0, (p.Z - (double)this.zmin) * (double)this.zfactor - 10.0);
            this.projection = this.projector.project((float)pp.X, (float)pp.Y, (float)pp.Z);
            PointF epf = new PointF(this.projection.x, this.projection.y);
            PointF[] points = new PointF[]{pf, epf};
            Draw.drawArrow(points, pb, 4, g);
        }
    }

    private void drawBase(Graphics g, int[] x, int[] y) {
        Point p = this.projector.project(-10.0f, -10.0f, -10.0f);
        x[0] = p.x;
        y[0] = p.y;
        p = this.projector.project(-10.0f, 10.0f, -10.0f);
        x[1] = p.x;
        y[1] = p.y;
        p = this.projector.project(10.0f, 10.0f, -10.0f);
        x[2] = p.x;
        y[2] = p.y;
        p = this.projector.project(10.0f, -10.0f, -10.0f);
        x[3] = p.x;
        y[3] = p.y;
        x[4] = x[0];
        y[4] = y[0];
        g.setColor(this.boxColor);
        g.fillPolygon(x, y, 4);
        g.setColor(this.lineboxColor);
        g.drawPolygon(x, y, 5);
    }

    private void outString(Graphics g, int x, int y, String s, XAlign x_align, YAlign y_align) {
        switch (y_align) {
            case TOP: {
                y += g.getFontMetrics(g.getFont()).getAscent();
                break;
            }
            case CENTER: {
                y += g.getFontMetrics(g.getFont()).getAscent() / 2;
            }
        }
        switch (x_align) {
            case LEFT: {
                g.drawString(s, x, y);
                break;
            }
            case RIGHT: {
                g.drawString(s, x - g.getFontMetrics(g.getFont()).stringWidth(s), y);
                break;
            }
            case CENTER: {
                g.drawString(s, x - g.getFontMetrics(g.getFont()).stringWidth(s) / 2, y);
            }
        }
    }

    private void outString(Graphics2D g, int x, int y, String s, XAlign x_align, YAlign y_align, float angle) {
        AffineTransform tempTrans = g.getTransform();
        AffineTransform myTrans = (AffineTransform)tempTrans.clone();
        myTrans.translate(x, y);
        myTrans.rotate((double)(-angle) * Math.PI / 180.0);
        g.setTransform(myTrans);
        x = 0;
        y = 0;
        switch (y_align) {
            case TOP: {
                y += g.getFontMetrics(g.getFont()).getAscent();
                break;
            }
            case CENTER: {
                y += g.getFontMetrics(g.getFont()).getAscent() / 2;
            }
        }
        Dimension labSize = Draw.getStringDimension(s, g);
        switch (x_align) {
            case RIGHT: {
                x -= labSize.width;
                break;
            }
            case CENTER: {
                x -= labSize.width / 2;
            }
        }
        Draw.drawString(g, s, x, y);
        g.setTransform(tempTrans);
    }

    private void outString_bak(Graphics2D g, int x, int y, String s, XAlign x_align, YAlign y_align, float angle) {
        switch (y_align) {
            case TOP: {
                y += g.getFontMetrics(g.getFont()).getAscent();
                break;
            }
            case CENTER: {
                y += g.getFontMetrics(g.getFont()).getAscent() / 2;
            }
        }
        Dimension labSize = Draw.getStringDimension(s, g);
        switch (x_align) {
            case RIGHT: {
                x -= labSize.width;
                break;
            }
            case CENTER: {
                x -= labSize.width / 2;
            }
        }
        AffineTransform tempTrans = g.getTransform();
        AffineTransform myTrans = (AffineTransform)tempTrans.clone();
        myTrans.translate(x, y);
        myTrans.rotate((double)(-angle) * Math.PI / 180.0);
        g.setTransform(myTrans);
        x = 0;
        y = 0;
        Draw.drawString(g, s, x, y);
        g.setTransform(tempTrans);
    }

    private void setAxesScale() {
        float divisor;
        int longest;
        if (!this.isScaleBox) {
            this.projector.setScaling(1.0f);
            this.t_z = 4;
            this.t_y = 4;
            this.t_x = 4;
            return;
        }
        float scale_x = this.xmax - this.xmin;
        float scale_y = this.ymax - this.ymin;
        float scale_z = this.zmax - this.zmin;
        if (scale_x < scale_y) {
            if (scale_y < scale_z) {
                longest = 3;
                divisor = scale_z;
            } else {
                longest = 2;
                divisor = scale_y;
            }
        } else if (scale_x < scale_z) {
            longest = 3;
            divisor = scale_z;
        } else {
            longest = 1;
            divisor = scale_x;
        }
        scale_y /= divisor;
        scale_z /= divisor;
        if ((scale_x /= divisor) < 0.2f || scale_y < 0.2f && scale_z < 0.2f) {
            switch (longest) {
                case 1: {
                    if (scale_y < scale_z) {
                        scale_y /= scale_z;
                        scale_z = 1.0f;
                        break;
                    }
                    scale_z /= scale_y;
                    scale_y = 1.0f;
                    break;
                }
                case 2: {
                    if (scale_x < scale_z) {
                        scale_x /= scale_z;
                        scale_z = 1.0f;
                        break;
                    }
                    scale_z /= scale_x;
                    scale_x = 1.0f;
                    break;
                }
                case 3: {
                    if (scale_y < scale_x) {
                        scale_y /= scale_x;
                        scale_x = 1.0f;
                        break;
                    }
                    scale_x /= scale_y;
                    scale_y = 1.0f;
                }
            }
        }
        if (scale_x < 0.2f) {
            scale_x = 1.0f;
        }
        this.projector.setXScaling(scale_x);
        if (scale_y < 0.2f) {
            scale_y = 1.0f;
        }
        this.projector.setYScaling(scale_y);
        if (scale_z < 0.2f) {
            scale_z = 1.0f;
        }
        this.projector.setZScaling(scale_z);
        this.t_x = scale_x < 0.5f ? 8 : 4;
        this.t_y = scale_y < 0.5f ? 8 : 4;
        this.t_z = scale_z < 0.5f ? 8 : 4;
    }

    private void outFloat(Graphics g, int x, int y, float f, XAlign x_align, YAlign y_align) {
        String s = this.format(f);
        this.outString(g, x, y, s, x_align, y_align);
    }

    private String format(float f) {
        return String.format("%.3G", Float.valueOf(f));
    }

    private void drawAxes(Graphics2D g) {
        int[] x = new int[5];
        int[] y = new int[5];
        this.drawBase(g, x, y);
        this.projection = this.projector.project(0.0f, 0.0f, -10.0f);
        x[0] = this.projection.x;
        y[0] = this.projection.y;
        this.projection = this.projector.project(10.5f, 0.0f, -10.0f);
        g.drawLine(x[0], y[0], this.projection.x, this.projection.y);
        if (this.projection.x < x[0]) {
            this.outString(g, (int)(1.05 * (double)(this.projection.x - x[0])) + x[0], (int)(1.05 * (double)(this.projection.y - y[0])) + y[0], "x", XAlign.RIGHT, YAlign.TOP);
        } else {
            this.outString(g, (int)(1.05 * (double)(this.projection.x - x[0])) + x[0], (int)(1.05 * (double)(this.projection.y - y[0])) + y[0], "x", XAlign.LEFT, YAlign.TOP);
        }
        this.projection = this.projector.project(0.0f, 11.5f, -10.0f);
        g.drawLine(x[0], y[0], this.projection.x, this.projection.y);
        if (this.projection.x < x[0]) {
            this.outString(g, (int)(1.05 * (double)(this.projection.x - x[0])) + x[0], (int)(1.05 * (double)(this.projection.y - y[0])) + y[0], "y", XAlign.RIGHT, YAlign.TOP);
        } else {
            this.outString(g, (int)(1.05 * (double)(this.projection.x - x[0])) + x[0], (int)(1.05 * (double)(this.projection.y - y[0])) + y[0], "y", XAlign.LEFT, YAlign.TOP);
        }
        this.projection = this.projector.project(0.0f, 0.0f, 10.5f);
        g.drawLine(x[0], y[0], this.projection.x, this.projection.y);
        this.outString(g, (int)(1.05 * (double)(this.projection.x - x[0])) + x[0], (int)(1.05 * (double)(this.projection.y - y[0])) + y[0], "z", XAlign.CENTER, YAlign.CENTER);
    }

    private int getLabelGap(Graphics2D g, List<ChartText> labels, double len) {
        int n = labels.size();
        FontMetrics metrics = g.getFontMetrics();
        int nn = (int)(len / (double)metrics.getHeight());
        if (nn == 0) {
            nn = 1;
        }
        return n / nn + 1;
    }

    private Polygon getBorder() {
        Polygon polygon = new Polygon();
        float elevation = this.projector.getElevationAngle();
        float rotation = this.projector.getRotationAngle();
        if (elevation == 0.0f && (rotation > 90.0f && rotation < 180.0f || rotation > 270.0f && rotation < 360.0f)) {
            Rectangle rect = this.projector.getBounds();
            polygon.addPoint(rect.x, rect.y);
            polygon.addPoint(rect.x, rect.y + rect.height);
            polygon.addPoint(rect.x + rect.width, rect.y + rect.height);
            polygon.addPoint(rect.x + rect.width, rect.y);
        } else {
            Point p = this.projector.project(this.factor_x * 10, -this.factor_y * 10, -10.0f);
            polygon.addPoint(p.x, p.y);
            p = this.projector.project(this.factor_x * 10, -this.factor_y * 10, 10.0f);
            polygon.addPoint(p.x, p.y);
            p = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, 10.0f);
            polygon.addPoint(p.x, p.y);
            p = this.projector.project(-this.factor_x * 10, this.factor_y * 10, 10.0f);
            polygon.addPoint(p.x, p.y);
            p = this.projector.project(-this.factor_x * 10, this.factor_y * 10, -10.0f);
            polygon.addPoint(p.x, p.y);
            p = this.projector.project(this.factor_x * 10, this.factor_y * 10, -10.0f);
            polygon.addPoint(p.x, p.y);
        }
        return polygon;
    }

    private void drawBoxGridsTicksLabels(Graphics2D g) {
        Point tickpos;
        float vi;
        String s;
        float v;
        int skip;
        int[] x = new int[5];
        int[] y = new int[5];
        if (this.projector == null) {
            return;
        }
        this.factor_y = 1;
        this.factor_x = 1;
        this.projection = this.projector.project(0.0f, 0.0f, -10.0f);
        x[0] = this.projection.x;
        this.projection = this.projector.project(10.5f, 0.0f, -10.0f);
        boolean y_left = this.projection.x > x[0];
        int i = this.projection.y;
        this.projection = this.projector.project(-10.5f, 0.0f, -10.0f);
        if (this.projection.y > i) {
            this.factor_x = -1;
            y_left = this.projection.x > x[0];
        }
        this.projection = this.projector.project(0.0f, 10.5f, -10.0f);
        boolean x_left = this.projection.x > x[0];
        i = this.projection.y;
        this.projection = this.projector.project(0.0f, -10.5f, -10.0f);
        if (this.projection.y > i) {
            this.factor_y = -1;
            x_left = this.projection.x > x[0];
        }
        this.setAxesScale();
        this.drawBase(g, x, y);
        if (this.isBoxed) {
            this.projection = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, -10.0f);
            x[0] = this.projection.x;
            y[0] = this.projection.y;
            this.projection = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, 10.0f);
            x[1] = this.projection.x;
            y[1] = this.projection.y;
            this.projection = this.projector.project(this.factor_x * 10, -this.factor_y * 10, 10.0f);
            x[2] = this.projection.x;
            y[2] = this.projection.y;
            this.projection = this.projector.project(this.factor_x * 10, -this.factor_y * 10, -10.0f);
            x[3] = this.projection.x;
            y[3] = this.projection.y;
            x[4] = x[0];
            y[4] = y[0];
            g.setColor(this.boxColor);
            g.fillPolygon(x, y, 4);
            g.setColor(this.lineboxColor);
            g.drawPolygon(x, y, 5);
            this.projection = this.projector.project(-this.factor_x * 10, this.factor_y * 10, 10.0f);
            x[2] = this.projection.x;
            y[2] = this.projection.y;
            this.projection = this.projector.project(-this.factor_x * 10, this.factor_y * 10, -10.0f);
            x[3] = this.projection.x;
            y[3] = this.projection.y;
            x[4] = x[0];
            y[4] = y[0];
            g.setColor(this.boxColor);
            g.fillPolygon(x, y, 4);
            g.setColor(this.lineboxColor);
            g.drawPolygon(x, y, 5);
        } else if (this.isDisplayZ) {
            this.projection = this.projector.project(this.factor_x * 10, -this.factor_y * 10, -10.0f);
            x[0] = this.projection.x;
            y[0] = this.projection.y;
            this.projection = this.projector.project(this.factor_x * 10, -this.factor_y * 10, 10.0f);
            g.drawLine(x[0], y[0], this.projection.x, this.projection.y);
            this.projection = this.projector.project(-this.factor_x * 10, this.factor_y * 10, -10.0f);
            x[0] = this.projection.x;
            y[0] = this.projection.y;
            this.projection = this.projector.project(-this.factor_x * 10, this.factor_y * 10, 10.0f);
            g.drawLine(x[0], y[0], this.projection.x, this.projection.y);
        }
        if (this.isDisplayXY) {
            Dimension dim;
            String label;
            int w;
            float angle;
            this.projection = this.projector.project(-10.0f, this.factor_y * 10, -10.0f);
            x[0] = this.projection.x;
            y[0] = this.projection.y;
            this.projection = this.projector.project(10.0f, this.factor_y * 10, -10.0f);
            g.setColor(this.xAxis.getLineColor());
            g.drawLine(x[0], y[0], this.projection.x, this.projection.y);
            double[] value = this.projection.x > x[0] ? DataMath.getDSFromUV(this.projection.x - x[0], this.projection.y - y[0]) : DataMath.getDSFromUV(x[0] - this.projection.x, y[0] - this.projection.y);
            float xangle = (float)value[0];
            float xlen = (float)value[1];
            this.projection = this.projector.project(this.factor_x * 10, -10.0f, -10.0f);
            x[0] = this.projection.x;
            y[0] = this.projection.y;
            this.projection = this.projector.project(this.factor_x * 10, 10.0f, -10.0f);
            g.setColor(this.yAxis.getLineColor());
            g.drawLine(x[0], y[0], this.projection.x, this.projection.y);
            value = this.projection.x > x[0] ? DataMath.getDSFromUV(this.projection.x - x[0], this.projection.y - y[0]) : DataMath.getDSFromUV(x[0] - this.projection.x, y[0] - this.projection.y);
            float yangle = (float)value[0];
            float ylen = (float)value[1];
            if (x_left) {
                angle = yangle;
            } else {
                angle = yangle + 180.0f;
                if (angle > 360.0f) {
                    angle -= 360.0f;
                }
            }
            g.setFont(this.xAxis.getTickLabelFont());
            this.xAxis.updateTickLabels();
            List<ChartText> tlabs = this.xAxis.getTickLabels();
            skip = this.getLabelGap(g, tlabs, Math.abs(xlen));
            int strWidth = 0;
            for (i = 0; i < this.xAxis.getTickValues().length; i += skip) {
                v = (float)this.xAxis.getTickValues()[i];
                if (i == tlabs.size()) break;
                s = tlabs.get(i).getText();
                if (v < this.xmin || v > this.xmax) continue;
                vi = (v - this.xmin) * this.xfactor - 10.0f;
                tickpos = this.projector.project(vi, this.factor_y * 10, -10.0f);
                if (this.isDisplayGrids && v != this.xmin && v != this.xmax) {
                    this.projection = this.projector.project(vi, -this.factor_y * 10, -10.0f);
                    g.setColor(this.lineboxColor);
                    g.drawLine(this.projection.x, this.projection.y, tickpos.x, tickpos.y);
                    if (this.isDisplayZ && this.isBoxed) {
                        x[0] = this.projection.x;
                        y[0] = this.projection.y;
                        this.projection = this.projector.project(vi, -this.factor_y * 10, 10.0f);
                        g.drawLine(x[0], y[0], this.projection.x, this.projection.y);
                    }
                }
                value = DataMath.getEndPoint(tickpos.x, tickpos.y, angle, this.xAxis.getTickLength());
                g.setColor(this.xAxis.getLineColor());
                g.drawLine(tickpos.x, tickpos.y, (int)value[0], (int)value[1]);
                value = DataMath.getEndPoint(tickpos.x, tickpos.y, angle, this.xAxis.getTickLength() + 5);
                tickpos = new Point((int)value[0], (int)value[1]);
                if (x_left) {
                    this.outString(g, tickpos.x, tickpos.y, s, XAlign.LEFT, YAlign.TOP);
                } else {
                    this.outString(g, tickpos.x, tickpos.y, s, XAlign.RIGHT, YAlign.TOP);
                }
                w = g.getFontMetrics().stringWidth(s);
                if (strWidth >= w) continue;
                strWidth = w;
            }
            if ((label = this.xAxis.getLabel().getText()) != null) {
                g.setFont(this.xAxis.getLabelFont());
                g.setColor(this.xAxis.getLabelColor());
                tickpos = this.projector.project(0.0f, (float)this.factor_y * 10.0f, -10.0f);
                dim = Draw.getStringDimension(label, g);
                strWidth = (int)Math.abs((double)strWidth * Math.sin(Math.toRadians(angle)));
                value = DataMath.getEndPoint(tickpos.x, tickpos.y, angle, this.xAxis.getTickLength() + strWidth + dim.height + 5);
                tickpos.x = (int)value[0];
                tickpos.y = (int)value[1];
                if (this.projector.getElevationAngle() < 10.0f) {
                    tickpos.y += g.getFontMetrics().getHeight();
                }
                if (x_left) {
                    this.outString(g, tickpos.x, tickpos.y, label, XAlign.CENTER, YAlign.TOP, xangle + 90.0f);
                } else {
                    this.outString(g, tickpos.x, tickpos.y, label, XAlign.CENTER, YAlign.TOP, xangle + 90.0f);
                }
            }
            if (y_left) {
                angle = xangle;
            } else {
                angle = xangle + 180.0f;
                if (angle > 360.0f) {
                    angle -= 360.0f;
                }
            }
            g.setFont(this.yAxis.getTickLabelFont());
            this.yAxis.updateTickLabels();
            tlabs = this.yAxis.getTickLabels();
            skip = this.getLabelGap(g, tlabs, Math.abs(ylen));
            strWidth = 0;
            for (i = 0; i < this.yAxis.getTickValues().length; i += skip) {
                v = (float)this.yAxis.getTickValues()[i];
                s = tlabs.get(i).getText();
                if (v < this.ymin || v > this.ymax) continue;
                vi = (v - this.ymin) * this.yfactor - 10.0f;
                tickpos = this.projector.project(this.factor_x * 10, vi, -10.0f);
                if (this.isDisplayGrids && v != this.ymin && v != this.ymax) {
                    this.projection = this.projector.project(-this.factor_x * 10, vi, -10.0f);
                    g.setColor(this.lineboxColor);
                    g.drawLine(this.projection.x, this.projection.y, tickpos.x, tickpos.y);
                    if (this.isDisplayZ && this.isBoxed) {
                        x[0] = this.projection.x;
                        y[0] = this.projection.y;
                        this.projection = this.projector.project(-this.factor_x * 10, vi, 10.0f);
                        g.drawLine(x[0], y[0], this.projection.x, this.projection.y);
                    }
                }
                value = DataMath.getEndPoint(tickpos.x, tickpos.y, angle, this.xAxis.getTickLength());
                g.setColor(this.yAxis.getLineColor());
                g.drawLine(tickpos.x, tickpos.y, (int)value[0], (int)value[1]);
                value = DataMath.getEndPoint(tickpos.x, tickpos.y, angle, this.xAxis.getTickLength() + 5);
                tickpos = new Point((int)value[0], (int)value[1]);
                if (y_left) {
                    this.outString(g, tickpos.x, tickpos.y, s, XAlign.LEFT, YAlign.TOP);
                } else {
                    this.outString(g, tickpos.x, tickpos.y, s, XAlign.RIGHT, YAlign.TOP);
                }
                w = g.getFontMetrics().stringWidth(s);
                if (strWidth >= w) continue;
                strWidth = w;
            }
            label = this.yAxis.getLabel().getText();
            if (label != null) {
                g.setFont(this.yAxis.getLabelFont());
                g.setColor(this.yAxis.getLabelColor());
                tickpos = this.projector.project((float)this.factor_x * 10.0f, 0.0f, -10.0f);
                dim = Draw.getStringDimension(label, g);
                strWidth = (int)Math.abs((double)strWidth * Math.sin(Math.toRadians(angle)));
                value = DataMath.getEndPoint(tickpos.x, tickpos.y, angle, this.yAxis.getTickLength() + strWidth + dim.height + 5);
                tickpos.x = (int)value[0];
                tickpos.y = (int)value[1];
                if (this.projector.getElevationAngle() < 10.0f) {
                    tickpos.y += g.getFontMetrics().getHeight();
                }
                if (y_left) {
                    this.outString(g, tickpos.x, tickpos.y, label, XAlign.CENTER, YAlign.TOP, yangle + 90.0f);
                } else {
                    this.outString(g, tickpos.x, tickpos.y, label, XAlign.CENTER, YAlign.TOP, yangle + 90.0f);
                }
            }
        }
        if (this.isDisplayZ) {
            float lf = 1.0f;
            if (y_left) {
                lf = -1.0f;
            }
            this.projection = this.projector.project((float)(this.factor_x * 10) * lf, (float)(-this.factor_y * 10) * lf, -10.0f);
            x[0] = this.projection.x;
            y[0] = this.projection.y;
            this.projection = this.projector.project((float)(this.factor_x * 10) * lf, (float)(-this.factor_y * 10) * lf, 10.0f);
            g.setFont(this.zAxis.getTickLabelFont());
            g.setColor(this.zAxis.getLineColor());
            g.drawLine(x[0], y[0], this.projection.x, this.projection.y);
            this.zAxis.updateTickLabels();
            List<ChartText> tlabs = this.zAxis.getTickLabels();
            int len = Math.abs(y[0] - this.projection.y);
            skip = this.getLabelGap(g, tlabs, len);
            int strWidth = 0;
            for (i = 0; i < this.zAxis.getTickValues().length; i += skip) {
                v = (float)this.zAxis.getTickValues()[i];
                s = tlabs.get(i).getText();
                if (v < this.zmin || v > this.zmax) continue;
                vi = (v - this.zmin) * this.zfactor - 10.0f;
                tickpos = this.projector.project((float)(this.factor_x * 10) * lf, (float)(-this.factor_y * 10) * lf, vi);
                if (this.isDisplayGrids && this.isBoxed && v != this.zmin && v != this.zmax) {
                    this.projection = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, vi);
                    g.setColor(this.lineboxColor);
                    g.drawLine(this.projection.x, this.projection.y, tickpos.x, tickpos.y);
                    x[0] = this.projection.x;
                    y[0] = this.projection.y;
                    this.projection = this.projector.project((float)(-this.factor_x * 10) * lf, (float)(this.factor_y * 10) * lf, vi);
                    g.drawLine(x[0], y[0], this.projection.x, this.projection.y);
                }
                g.setColor(this.zAxis.getLineColor());
                g.drawLine(tickpos.x, tickpos.y, tickpos.x - this.zAxis.getTickLength(), tickpos.y);
                this.outString(g, tickpos.x - this.zAxis.getTickLength() - 5, tickpos.y, s, XAlign.RIGHT, YAlign.CENTER);
                int w = g.getFontMetrics().stringWidth(s);
                if (strWidth >= w) continue;
                strWidth = w;
            }
            String label = this.zAxis.getLabel().getText();
            if (label != null) {
                Dimension dim = Draw.getStringDimension(label, g);
                tickpos = this.projector.project((float)(this.factor_x * 10) * lf, (float)(-this.factor_y * 10) * lf, 0.0f);
                tickpos.x = tickpos.x - this.xAxis.getTickLength() - 15 - strWidth - dim.height;
                g.setFont(this.zAxis.getLabelFont());
                g.setColor(this.zAxis.getLabelColor());
                Draw.drawString(g, tickpos.x, tickpos.y, label, XAlign.LEFT, YAlign.CENTER, 90.0f, this.zAxis.getLabel().isUseExternalFont());
            }
        }
    }

    private void drawBoundingBox(Graphics2D g2) {
        Point startingpoint = this.projector.project(this.factor_x * 10, this.factor_y * 10, 10.0f);
        g2.setColor(this.lineboxColor);
        this.projection = this.projector.project(-this.factor_x * 10, this.factor_y * 10, 10.0f);
        g2.drawLine(startingpoint.x, startingpoint.y, this.projection.x, this.projection.y);
        this.projection = this.projector.project(this.factor_x * 10, -this.factor_y * 10, 10.0f);
        g2.drawLine(startingpoint.x, startingpoint.y, this.projection.x, this.projection.y);
        this.projection = this.projector.project(this.factor_x * 10, this.factor_y * 10, -10.0f);
        g2.drawLine(startingpoint.x, startingpoint.y, this.projection.x, this.projection.y);
    }

    @Override
    public Margin getTightInset(Graphics2D g, Rectangle2D positionArea) {
        int left = 2;
        int bottom = 2;
        int right = 2;
        int top = 5;
        int space = 2;
        if (this.title != null) {
            top += this.title.getTrueDimension((Graphics2D)g).height + 10;
        }
        if (!this.legends.isEmpty()) {
            ChartLegend legend = this.getLegend();
            Dimension dim = legend.getLegendDimension(g, new Dimension((int)positionArea.getWidth(), (int)positionArea.getHeight()));
            switch (legend.getPosition()) {
                case UPPER_CENTER_OUTSIDE: {
                    top += dim.height + 10;
                    break;
                }
                case LOWER_CENTER_OUTSIDE: {
                    bottom = (int)((float)bottom + ((float)dim.height + legend.getYShift() + 10.0f));
                    break;
                }
                case LEFT_OUTSIDE: {
                    left += dim.width + 10;
                    break;
                }
                case RIGHT_OUTSIDE: {
                    right = (int)((float)right + ((float)dim.width + legend.getXShift() + 10.0f));
                }
            }
        }
        return new Margin(left, right, top, bottom);
    }

    void drawLegend(Graphics2D g, Rectangle2D area, Rectangle2D graphArea, float y) {
        if (!this.legends.isEmpty()) {
            Object rendering = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (ChartLegend legend : this.legends) {
                if (legend.isColorbar()) {
                    if (legend.getPlotOrientation() == PlotOrientation.VERTICAL) {
                        legend.setHeight((int)(graphArea.getHeight() * (double)legend.getShrink()));
                    } else {
                        legend.setWidth((int)(graphArea.getWidth() * (double)legend.getShrink()));
                    }
                }
                if (legend.getPosition() == LegendPosition.CUSTOM) {
                    legend.getLegendDimension(g, new Dimension((int)area.getWidth(), (int)area.getHeight()));
                    float x = (float)(area.getWidth() * (double)legend.getX());
                    y = (float)(area.getHeight() * (1.0 - (double)this.getLegend().getHeight() / area.getHeight() - (double)this.getLegend().getY()));
                    legend.draw(g, new PointF(x, y));
                    continue;
                }
                this.drawLegendScheme(legend, g, graphArea, y);
            }
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rendering);
        }
    }

    void drawLegendScheme(ChartLegend legend, Graphics2D g, Rectangle2D area, float y) {
        g.setStroke(new BasicStroke(1.0f));
        g.setFont(legend.getTickLabelFont());
        Dimension dim = legend.getLegendDimension(g, new Dimension((int)area.getWidth(), (int)area.getHeight()));
        float x = 0.0f;
        switch (legend.getPosition()) {
            case UPPER_CENTER_OUTSIDE: {
                x = (float)(area.getX() + area.getWidth() / 2.0 - (double)(dim.width / 2));
                y += 5.0f;
                break;
            }
            case LOWER_CENTER_OUTSIDE: {
                x = (float)(area.getX() + area.getWidth() / 2.0 - (double)(dim.width / 2));
                y = (float)(area.getY() + area.getHeight() + 10.0);
                break;
            }
            case LEFT_OUTSIDE: {
                x = 10.0f;
                y = (float)area.getHeight() / 2.0f - (float)(dim.height / 2);
                break;
            }
            case RIGHT_OUTSIDE: {
                x = (float)area.getX() + (float)area.getWidth() + 10.0f + 40.0f;
                y = (float)area.getY() + (float)area.getHeight() / 2.0f - (float)(dim.height / 2);
                break;
            }
            case UPPER_CENTER: {
                x = (float)(area.getX() + area.getWidth() / 2.0 - (double)(dim.width / 2));
                y = (float)area.getY() + 10.0f;
                break;
            }
            case UPPER_RIGHT: {
                x = (float)(area.getX() + area.getWidth()) - (float)dim.width - 10.0f;
                y = (float)area.getY() + 10.0f;
                break;
            }
            case LOWER_CENTER: {
                x = (float)(area.getX() + area.getWidth() / 2.0 - (double)(dim.width / 2));
                y = (float)(area.getY() + area.getHeight()) - (float)dim.height - 10.0f;
                break;
            }
            case LOWER_RIGHT: {
                x = (float)(area.getX() + area.getWidth()) - (float)dim.width - 10.0f;
                y = (float)(area.getY() + area.getHeight()) - (float)dim.height - 10.0f;
                break;
            }
            case UPPER_LEFT: {
                x = (float)area.getX() + 10.0f;
                y = (float)area.getY() + 10.0f;
                break;
            }
            case LOWER_LEFT: {
                x = (float)area.getX() + 10.0f;
                y = (float)(area.getY() + area.getHeight()) - (float)dim.height - 10.0f;
            }
        }
        legend.draw(g, new PointF(x, y));
    }
}

