/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.StationTableData;
import org.meteoinfo.data.meteodata.GridDataSetting;
import org.meteoinfo.geoprocess.GeoComputation;
import org.meteoinfo.geoprocess.analysis.ResampleMethods;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointD;
import org.meteoinfo.global.util.BigDecimalUtil;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Dimension;
import org.meteoinfo.ndarray.DimensionType;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionUtil;
import org.meteoinfo.projection.Reproject;
import org.meteoinfo.projection.info.ProjectionInfo;
import org.meteoinfo.shape.PolygonShape;
import org.meteoinfo.shape.ShapeTypes;

public class GridData {
    public double[][] data;
    public double[] xArray;
    public double[] yArray;
    public double missingValue;
    public ProjectionInfo projInfo = null;
    public String fieldName = "Data";
    private boolean _xStag = false;
    private boolean _yStag = false;

    public GridData() {
        this.missingValue = -9999.0;
    }

    public GridData(GridData aGridData) {
        this.projInfo = aGridData.projInfo;
        this.xArray = (double[])aGridData.xArray.clone();
        this.yArray = (double[])aGridData.yArray.clone();
        this.missingValue = aGridData.missingValue;
        this.data = new double[this.yArray.length][this.xArray.length];
    }

    public GridData(double xStart, double xDelt, int xNum, double yStart, double yDelt, int yNum) {
        int i;
        this.xArray = new double[xNum];
        this.yArray = new double[yNum];
        for (i = 0; i < xNum; ++i) {
            this.xArray[i] = BigDecimalUtil.add(xStart, BigDecimalUtil.mul(xDelt, (double)i));
        }
        for (i = 0; i < yNum; ++i) {
            this.yArray[i] = BigDecimalUtil.add(yStart, BigDecimalUtil.mul(yDelt, (double)i));
        }
        this.missingValue = -9999.0;
        this.data = new double[yNum][xNum];
    }

    public GridData(Array array, List<Number> xdata, List<Number> ydata, double missingValue, ProjectionInfo projInfo) {
        int i;
        int yn = ydata.size();
        int xn = xdata.size();
        this.data = new double[yn][xn];
        IndexIterator iter = array.getIndexIterator();
        int idx = 0;
        while (iter.hasNext()) {
            double val = iter.getDoubleNext();
            this.data[idx / xn][idx % xn] = java.lang.Double.isNaN(val) ? missingValue : val;
            ++idx;
        }
        this.xArray = new double[xn];
        this.yArray = new double[yn];
        for (i = 0; i < xn; ++i) {
            this.xArray[i] = xdata.get(i).doubleValue();
        }
        for (i = 0; i < yn; ++i) {
            this.yArray[i] = ydata.get(i).doubleValue();
        }
        this.missingValue = missingValue;
        this.projInfo = projInfo;
    }

    public GridData(Array array, Array xdata, Array ydata) {
        this(array, xdata, ydata, -9999.0);
    }

    public GridData(Array array, Array xdata, Array ydata, Number missingValue) {
        int i;
        int yn = (int)ydata.getSize();
        int xn = (int)xdata.getSize();
        this.data = new double[yn][xn];
        IndexIterator iter = array.getIndexIterator();
        int idx = 0;
        while (iter.hasNext()) {
            double val = iter.getDoubleNext();
            this.data[idx / xn][idx % xn] = java.lang.Double.isNaN(val) ? missingValue.doubleValue() : val;
            ++idx;
        }
        this.xArray = new double[xn];
        this.yArray = new double[yn];
        for (i = 0; i < xn; ++i) {
            this.xArray[i] = xdata.getDouble(i);
        }
        for (i = 0; i < yn; ++i) {
            this.yArray[i] = ydata.getDouble(i);
        }
        this.missingValue = missingValue.doubleValue();
        this.projInfo = KnownCoordinateSystems.geographic.world.WGS1984;
    }

    public int getXNum() {
        return this.xArray.length;
    }

    public int getYNum() {
        return this.yArray.length;
    }

    public double getXDelt() {
        return this.xArray[1] - this.xArray[0];
    }

    public double getYDelt() {
        return this.yArray[1] - this.yArray[0];
    }

    public Extent getExtent() {
        Extent extent = new Extent();
        extent.minX = this.xArray[0];
        extent.maxX = this.xArray[this.xArray.length - 1];
        extent.minY = this.yArray[0];
        extent.maxY = this.yArray[this.yArray.length - 1];
        return extent;
    }

    public boolean isGlobal() {
        boolean isGlobal = false;
        if (MIMath.doubleEquals(this.xArray[this.getXNum() - 1] + this.getXDelt() - this.xArray[0], 360.0)) {
            isGlobal = true;
        }
        return isGlobal;
    }

    public boolean isXStagger() {
        return this._xStag;
    }

    public void setXStagger(boolean value) {
        this._xStag = value;
    }

    public boolean isYStagger() {
        return this._yStag;
    }

    public void setYStagger(boolean value) {
        this._yStag = value;
    }

    public Number getValue(int i, int j) {
        return this.data[i][j];
    }

    public double getDoubleValue(int i, int j) {
        return this.data[i][j];
    }

    public GridData add(GridData bGrid) {
        int xNum = this.getXNum();
        int yNum = this.getYNum();
        GridData cGrid = new GridData(this);
        for (int i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                cGrid.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) || MIMath.doubleEquals(bGrid.data[i][j], bGrid.missingValue) ? this.missingValue : this.data[i][j] + bGrid.data[i][j];
            }
        }
        return cGrid;
    }

    public GridData add(double value) {
        int xNum = this.getXNum();
        int yNum = this.getYNum();
        GridData cGrid = new GridData(this);
        for (int i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                cGrid.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) ? this.missingValue : this.data[i][j] + value;
            }
        }
        return cGrid;
    }

    public GridData sub(GridData bGrid) {
        int xNum = this.getXNum();
        int yNum = this.getYNum();
        GridData cGrid = new GridData(this);
        for (int i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                cGrid.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) || MIMath.doubleEquals(bGrid.data[i][j], bGrid.missingValue) ? this.missingValue : this.data[i][j] - bGrid.data[i][j];
            }
        }
        return cGrid;
    }

    public GridData sub(double value) {
        int xNum = this.getXNum();
        int yNum = this.getYNum();
        GridData cGrid = new GridData(this);
        for (int i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                cGrid.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) ? this.missingValue : this.data[i][j] - value;
            }
        }
        return cGrid;
    }

    public GridData mul(GridData bGrid) {
        int xNum = this.getXNum();
        int yNum = this.getYNum();
        GridData cGrid = new GridData(this);
        for (int i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                cGrid.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) || MIMath.doubleEquals(bGrid.data[i][j], bGrid.missingValue) ? this.missingValue : this.data[i][j] * bGrid.data[i][j];
            }
        }
        return cGrid;
    }

    public GridData mul(double value) {
        int xNum = this.getXNum();
        int yNum = this.getYNum();
        GridData cGrid = new GridData(this);
        for (int i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                cGrid.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) ? this.missingValue : this.data[i][j] * value;
            }
        }
        return cGrid;
    }

    public GridData div(GridData bGrid) {
        int xNum = this.getXNum();
        int yNum = this.getYNum();
        GridData cGrid = new GridData(this);
        for (int i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                cGrid.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) || MIMath.doubleEquals(bGrid.data[i][j], bGrid.missingValue) ? this.missingValue : (bGrid.data[i][j] == 0.0 ? this.missingValue : this.data[i][j] / bGrid.data[i][j]);
            }
        }
        return cGrid;
    }

    public GridData div(double value) {
        int xNum = this.getXNum();
        int yNum = this.getYNum();
        GridData cGrid = new GridData(this);
        for (int i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                cGrid.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) ? this.missingValue : this.data[i][j] / value;
            }
        }
        return cGrid;
    }

    public void regrid(GridData gridData) {
        for (int i = 0; i < gridData.getYNum(); ++i) {
            for (int j = 0; j < gridData.getXNum(); ++j) {
                gridData.data[i][j] = this.toStation(gridData.xArray[j], gridData.yArray[i]);
            }
        }
    }

    public double toStation(double x, double y) {
        double iValue = this.missingValue;
        if (x < this.xArray[0] || x > this.xArray[this.getXNum() - 1] || y < this.yArray[0] || y > this.yArray[this.getYNum() - 1]) {
            return iValue;
        }
        double DX = this.getXDelt();
        double DY = this.getYDelt();
        int xIdx = 0;
        int yIdx = 0;
        xIdx = (int)((x - this.xArray[0]) / DX);
        yIdx = (int)((y - this.yArray[0]) / DY);
        if (xIdx == this.getXNum() - 1) {
            xIdx = this.getXNum() - 2;
        }
        if (yIdx == this.getYNum() - 1) {
            yIdx = this.getYNum() - 2;
        }
        int i1 = yIdx;
        int j1 = xIdx;
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        double a = this.data[i1][j1];
        double b = this.data[i1][j2];
        double c = this.data[i2][j1];
        double d = this.data[i2][j2];
        ArrayList<java.lang.Double> dList = new ArrayList<java.lang.Double>();
        if (!MIMath.doubleEquals(a, this.missingValue)) {
            dList.add(a);
        }
        if (!MIMath.doubleEquals(b, this.missingValue)) {
            dList.add(b);
        }
        if (!MIMath.doubleEquals(c, this.missingValue)) {
            dList.add(c);
        }
        if (!MIMath.doubleEquals(d, this.missingValue)) {
            dList.add(d);
        }
        if (dList.isEmpty()) {
            return iValue;
        }
        if (dList.size() == 1) {
            iValue = (java.lang.Double)dList.get(0);
        } else if (dList.size() <= 3) {
            double aSum = 0.0;
            Iterator iterator = dList.iterator();
            while (iterator.hasNext()) {
                double dd = (java.lang.Double)iterator.next();
                aSum += dd;
            }
            iValue = aSum / (double)dList.size();
        } else {
            double x1val = a + (c - a) * (y - this.yArray[i1]) / DY;
            double x2val = b + (d - b) * (y - this.yArray[i1]) / DY;
            iValue = x1val + (x2val - x1val) * (x - this.xArray[j1]) / DX;
        }
        return iValue;
    }

    public List<java.lang.Double> toStation(List<Number> xlist, List<Number> ylist) {
        ArrayList<java.lang.Double> r = new ArrayList<java.lang.Double>();
        for (int i = 0; i < xlist.size(); ++i) {
            double x = xlist.get(i).doubleValue();
            double y = ylist.get(i).doubleValue();
            double v = this.toStation(x, y);
            r.add(v);
        }
        return r;
    }

    public StationData toStation(StationData stData) {
        StationData nstData = new StationData(stData);
        nstData.missingValue = this.missingValue;
        if (this.projInfo.equals(stData.projInfo)) {
            for (int i = 0; i < nstData.getStNum(); ++i) {
                nstData.setValue(i, this.toStation(nstData.getX(i), nstData.getY(i)));
            }
        } else {
            nstData = this.project(this.projInfo, stData.projInfo, stData, ResampleMethods.Bilinear);
        }
        return nstData;
    }

    public void toStation(StationTableData stData) {
        int lonIdx = stData.getLonIndex();
        int latIdx = stData.getLatIndex();
        try {
            stData.addColumn(this.fieldName, DataType.FLOAT);
        }
        catch (Exception ex) {
            Logger.getLogger(GridData.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.projInfo.equals(stData.getProjectionInfo())) {
            for (int i = 0; i < stData.getRowCount(); ++i) {
                double x = java.lang.Double.parseDouble(stData.getValue(i, lonIdx).toString());
                double y = java.lang.Double.parseDouble(stData.getValue(i, latIdx).toString());
                stData.setValue(i, this.fieldName, (Object)this.toStation(x, y));
            }
        } else {
            int i;
            StationData sdata = new StationData();
            for (i = 0; i < stData.getRowCount(); ++i) {
                double x = java.lang.Double.parseDouble(stData.getValue(i, lonIdx).toString());
                double y = java.lang.Double.parseDouble(stData.getValue(i, latIdx).toString());
                sdata.addData("S_" + String.valueOf(i), x, y, 0.0);
            }
            sdata = this.project(this.projInfo, sdata.projInfo, sdata, ResampleMethods.Bilinear);
            for (i = 0; i < stData.getRowCount(); ++i) {
                stData.setValue(i, this.fieldName, (Object)sdata.getValue(i));
            }
        }
    }

    public void toStation(String inFile, String outFile) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        if (!new File(inFile).exists()) {
            return;
        }
        BufferedReader sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), "utf-8"));
        BufferedWriter sw = new BufferedWriter(new FileWriter(new File(outFile)));
        String aLine = sr.readLine();
        aLine = aLine + ",data";
        sw.write(aLine);
        sw.newLine();
        aLine = sr.readLine();
        while (aLine != null) {
            double y;
            String[] dArray = (aLine = aLine.trim()).split(",");
            if (dArray.length < 3) continue;
            String stId = dArray[0].trim();
            double x = java.lang.Double.parseDouble(dArray[1].trim());
            double value = this.toStation(x, y = java.lang.Double.parseDouble(dArray[2].trim()));
            if (!java.lang.Double.isNaN(value)) {
                aLine = aLine + "," + String.valueOf(value);
                sw.write(aLine);
                sw.newLine();
            }
            aLine = sr.readLine();
        }
        sr.close();
        sw.close();
    }

    public GridData setValue(GridData bGrid) {
        Extent bExtent;
        Extent aExtent = this.getExtent();
        if (!MIMath.isExtentCross(aExtent, bExtent = bGrid.getExtent()).booleanValue()) {
            return this;
        }
        int xNum = this.getXNum();
        int yNum = this.getYNum();
        double axdelt = this.getXDelt();
        double aydelt = this.getYDelt();
        int sXidx = 0;
        int eXidx = xNum - 1;
        int sYidx = 0;
        int eYidx = yNum - 1;
        if (aExtent.minX < bExtent.minX) {
            sXidx = (int)((bExtent.minX - aExtent.minX) / axdelt);
        }
        if (aExtent.maxX > bExtent.maxX) {
            eXidx = (int)((bExtent.maxX - aExtent.minX) / axdelt);
        }
        if (aExtent.minY < bExtent.minY) {
            sYidx = (int)((bExtent.minY - aExtent.minY) / aydelt);
        }
        if (aExtent.maxY > bExtent.maxY) {
            eYidx = (int)((bExtent.maxY - aExtent.minY) / aydelt);
        }
        GridData cGrid = (GridData)this.clone();
        double bxdelt = bGrid.getXDelt();
        double bydelt = bGrid.getYDelt();
        for (int i = sYidx; i <= eYidx; ++i) {
            for (int j = sXidx; j <= eXidx; ++j) {
                int yidx;
                int xidx = (int)((this.xArray[j] - bGrid.xArray[0]) / bxdelt);
                if (xidx < 0 || xidx >= bGrid.getXNum() || (yidx = (int)((this.yArray[i] - bGrid.yArray[0]) / bydelt)) < 0 || yidx >= bGrid.getYNum()) continue;
                cGrid.data[i][j] = bGrid.data[yidx][xidx];
            }
        }
        return cGrid;
    }

    public GridData setValue(GridData bGrid, boolean useMissingData) {
        Extent bExtent;
        Extent aExtent = this.getExtent();
        if (!MIMath.isExtentCross(aExtent, bExtent = bGrid.getExtent()).booleanValue()) {
            return this;
        }
        int xNum = this.getXNum();
        int yNum = this.getYNum();
        double axdelt = this.getXDelt();
        double aydelt = this.getYDelt();
        int sXidx = 0;
        int eXidx = xNum - 1;
        int sYidx = 0;
        int eYidx = yNum - 1;
        if (aExtent.minX < bExtent.minX) {
            sXidx = (int)((bExtent.minX - aExtent.minX) / axdelt);
        }
        if (aExtent.maxX > bExtent.maxX) {
            eXidx = (int)((bExtent.maxX - aExtent.minX) / axdelt);
        }
        if (aExtent.minY < bExtent.minY) {
            sYidx = (int)((bExtent.minY - aExtent.minY) / aydelt);
        }
        if (aExtent.maxY > bExtent.maxY) {
            eYidx = (int)((bExtent.maxY - aExtent.minY) / aydelt);
        }
        GridData cGrid = (GridData)this.clone();
        double bxdelt = bGrid.getXDelt();
        double bydelt = bGrid.getYDelt();
        for (int i = sYidx; i <= eYidx; ++i) {
            for (int j = sXidx; j <= eXidx; ++j) {
                int yidx;
                int xidx = (int)((this.xArray[j] - bGrid.xArray[0]) / bxdelt);
                if (xidx < 0 || xidx >= bGrid.getXNum() || (yidx = (int)((this.yArray[i] - bGrid.yArray[0]) / bydelt)) < 0 || yidx >= bGrid.getYNum() || useMissingData && MIMath.doubleEquals(bGrid.data[yidx][xidx], bGrid.missingValue)) continue;
                cGrid.data[i][j] = bGrid.data[yidx][xidx];
            }
        }
        return cGrid;
    }

    public GridData setValue(double aValue) {
        int xNum = this.getXNum();
        int yNum = this.getYNum();
        GridData cGrid = new GridData(this);
        for (int i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                cGrid.data[i][j] = aValue;
            }
        }
        return cGrid;
    }

    public void replaceValue(double aValue, double bValue) {
        for (int i = 0; i < this.getYNum(); ++i) {
            for (int j = 0; j < this.getXNum(); ++j) {
                if (this.data[i][j] != aValue) continue;
                this.data[i][j] = bValue;
            }
        }
    }

    public void replaceValue(double aValue, double bValue, boolean bigger) {
        for (int i = 0; i < this.getYNum(); ++i) {
            for (int j = 0; j < this.getXNum(); ++j) {
                if (bigger) {
                    if (!(this.data[i][j] > aValue)) continue;
                    this.data[i][j] = bValue;
                    continue;
                }
                if (!(this.data[i][j] < aValue)) continue;
                this.data[i][j] = bValue;
            }
        }
    }

    public GridData merge(GridData bGrid) {
        int xNum = this.getXNum();
        int yNum = this.getYNum();
        GridData cGrid = (GridData)this.clone();
        for (int i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                if (!MIMath.doubleEquals(this.data[i][j], this.missingValue) || MIMath.doubleEquals(bGrid.data[i][j], bGrid.missingValue)) continue;
                cGrid.data[i][j] = bGrid.data[i][j];
            }
        }
        return cGrid;
    }

    public GridData max(GridData bGrid) {
        int xNum = this.getXNum();
        int yNum = this.getYNum();
        GridData cGrid = new GridData(this);
        for (int i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                cGrid.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) || MIMath.doubleEquals(bGrid.data[i][j], bGrid.missingValue) ? this.missingValue : Math.max(this.data[i][j], bGrid.data[i][j]);
            }
        }
        return cGrid;
    }

    public GridData min(GridData bGrid) {
        int xNum = this.getXNum();
        int yNum = this.getYNum();
        GridData cGrid = new GridData(this);
        for (int i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                cGrid.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) || MIMath.doubleEquals(bGrid.data[i][j], bGrid.missingValue) ? this.missingValue : Math.min(this.data[i][j], bGrid.data[i][j]);
            }
        }
        return cGrid;
    }

    public double sum() {
        double sum = 0.0;
        for (int i = 0; i < this.getYNum(); ++i) {
            for (int j = 0; j < this.getXNum(); ++j) {
                if (MIMath.doubleEquals(this.data[i][j], this.missingValue)) continue;
                sum += this.data[i][j];
            }
        }
        return sum;
    }

    public double average() {
        double ave = 0.0;
        int vdNum = 0;
        for (int i = 0; i < this.getYNum(); ++i) {
            for (int j = 0; j < this.getXNum(); ++j) {
                if (MIMath.doubleEquals(this.data[i][j], this.missingValue)) continue;
                ave += this.data[i][j];
                ++vdNum;
            }
        }
        return ave /= (double)vdNum;
    }

    public double[] average(GridData bGrid, double[] tValues) {
        int k;
        int vn = tValues.length;
        int n = vn + 1;
        double[] aves = new double[n];
        int[] vdNum = new int[n];
        for (int i = 0; i < this.getYNum(); ++i) {
            for (int j = 0; j < this.getXNum(); ++j) {
                double v = this.data[i][j];
                double bv = bGrid.data[i][j];
                if (MIMath.doubleEquals(v, this.missingValue) || MIMath.doubleEquals(bv, bGrid.missingValue)) continue;
                if (bv >= tValues[vn - 1]) {
                    k = vn;
                } else {
                    for (k = 0; k < vn && !(bv < tValues[k]); ++k) {
                    }
                }
                int n2 = k;
                aves[n2] = aves[n2] + v;
                int n3 = k;
                vdNum[n3] = vdNum[n3] + 1;
            }
        }
        for (k = 0; k < n; ++k) {
            aves[k] = vdNum[k] > 0 ? aves[k] / (double)vdNum[k] : this.missingValue;
        }
        return aves;
    }

    public double[] statistics() {
        double theMean = this.average();
        double theSumSqDev = 0.0;
        int vdNum = 0;
        for (int i = 0; i < this.getYNum(); ++i) {
            for (int j = 0; j < this.getXNum(); ++j) {
                if (MIMath.doubleEquals(this.data[i][j], this.missingValue)) continue;
                double theValue = this.data[i][j];
                double theSqDev = (theValue - theMean) * (theValue - theMean);
                theSumSqDev = theSqDev + theSumSqDev;
                ++vdNum;
            }
        }
        double theVariance = theSumSqDev / (double)(vdNum - 1);
        double theStdDev = Math.sqrt(theVariance);
        double sem = theStdDev / Math.sqrt(vdNum);
        return new double[]{theMean, theStdDev, sem};
    }

    public GridData abs() {
        GridData gridData = new GridData(this);
        for (int i = 0; i < gridData.getYNum(); ++i) {
            for (int j = 0; j < gridData.getXNum(); ++j) {
                gridData.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) ? this.missingValue : Math.abs(this.data[i][j]);
            }
        }
        return gridData;
    }

    public GridData acos() {
        GridData gridData = new GridData(this);
        for (int i = 0; i < gridData.getYNum(); ++i) {
            for (int j = 0; j < gridData.getXNum(); ++j) {
                gridData.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) ? this.missingValue : Math.acos(this.data[i][j]);
            }
        }
        return gridData;
    }

    public GridData asin() {
        GridData gridData = new GridData(this);
        for (int i = 0; i < gridData.getYNum(); ++i) {
            for (int j = 0; j < gridData.getXNum(); ++j) {
                gridData.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) ? this.missingValue : Math.asin(this.data[i][j]);
            }
        }
        return gridData;
    }

    public GridData atan() {
        GridData gridData = new GridData(this);
        for (int i = 0; i < gridData.getYNum(); ++i) {
            for (int j = 0; j < gridData.getXNum(); ++j) {
                gridData.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) ? this.missingValue : Math.atan(this.data[i][j]);
            }
        }
        return gridData;
    }

    public GridData cos() {
        GridData gridData = new GridData(this);
        for (int i = 0; i < gridData.getYNum(); ++i) {
            for (int j = 0; j < gridData.getXNum(); ++j) {
                gridData.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) ? this.missingValue : Math.cos(this.data[i][j]);
            }
        }
        return gridData;
    }

    public GridData sin() {
        GridData gridData = new GridData(this);
        for (int i = 0; i < gridData.getYNum(); ++i) {
            for (int j = 0; j < gridData.getXNum(); ++j) {
                gridData.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) ? this.missingValue : Math.sin(this.data[i][j]);
            }
        }
        return gridData;
    }

    public GridData tan() {
        GridData gridData = new GridData(this);
        for (int i = 0; i < gridData.getYNum(); ++i) {
            for (int j = 0; j < gridData.getXNum(); ++j) {
                gridData.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) ? this.missingValue : Math.abs(this.data[i][j]);
            }
        }
        return gridData;
    }

    public GridData exp() {
        GridData gridData = new GridData(this);
        for (int i = 0; i < gridData.getYNum(); ++i) {
            for (int j = 0; j < gridData.getXNum(); ++j) {
                gridData.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) ? this.missingValue : Math.exp(this.data[i][j]);
            }
        }
        return gridData;
    }

    public GridData pow(double p) {
        GridData gridData = new GridData(this);
        for (int i = 0; i < gridData.getYNum(); ++i) {
            for (int j = 0; j < gridData.getXNum(); ++j) {
                gridData.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) ? this.missingValue : Math.pow(this.data[i][j], p);
            }
        }
        return gridData;
    }

    public GridData sqrt() {
        GridData gridData = new GridData(this);
        for (int i = 0; i < gridData.getYNum(); ++i) {
            for (int j = 0; j < gridData.getXNum(); ++j) {
                gridData.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) ? this.missingValue : Math.sqrt(this.data[i][j]);
            }
        }
        return gridData;
    }

    public GridData log() {
        GridData gridData = new GridData(this);
        for (int i = 0; i < gridData.getYNum(); ++i) {
            for (int j = 0; j < gridData.getXNum(); ++j) {
                gridData.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) ? this.missingValue : Math.log(this.data[i][j]);
            }
        }
        return gridData;
    }

    public GridData log10() {
        GridData gridData = new GridData(this);
        for (int i = 0; i < gridData.getYNum(); ++i) {
            for (int j = 0; j < gridData.getXNum(); ++j) {
                gridData.data[i][j] = MIMath.doubleEquals(this.data[i][j], this.missingValue) ? this.missingValue : Math.abs(this.data[i][j]);
            }
        }
        return gridData;
    }

    public void extendToGlobal() {
        int i;
        int yNum = this.getYNum();
        int xNum = this.getXNum();
        double[][] newGriddata = new double[yNum][xNum + 1];
        double[] newX = new double[xNum + 1];
        for (i = 0; i < xNum; ++i) {
            newX[i] = this.xArray[i];
        }
        newX[xNum] = newX[xNum - 1] + this.getXDelt();
        for (i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                newGriddata[i][j] = this.data[i][j];
            }
            newGriddata[i][xNum] = newGriddata[i][0];
        }
        this.data = newGriddata;
        this.xArray = newX;
    }

    public Array getArray() {
        int yn = this.getYNum();
        int xn = this.getXNum();
        int[] shape = new int[]{yn, xn};
        Array r = Array.factory(DataType.DOUBLE, shape);
        for (int i = 0; i < yn; ++i) {
            for (int j = 0; j < xn; ++j) {
                r.setDouble(i * xn + j, this.data[i][j]);
            }
        }
        return r;
    }

    public List<Dimension> getDimensions() {
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        Dimension ydim = new Dimension(DimensionType.Y);
        ydim.setValues(this.yArray);
        dims.add(ydim);
        Dimension xdim = new Dimension(DimensionType.X);
        xdim.setValues(this.xArray);
        dims.add(xdim);
        return dims;
    }

    public GridData extract(Extent extent) {
        return this.extract(extent.minX, extent.maxX, extent.minY, extent.maxY);
    }

    public GridData extract(double sX, double eX, double sY, double eY) {
        int i;
        if (eX <= sX || eY <= sY) {
            return null;
        }
        int xNum = this.getXNum();
        int yNum = this.getYNum();
        if (sX >= this.xArray[xNum - 2] || sY >= this.yArray[yNum - 2]) {
            return null;
        }
        GridData aGridData = new GridData();
        aGridData.projInfo = this.projInfo;
        aGridData.missingValue = this.missingValue;
        int sXidx = 0;
        int eXidx = xNum - 1;
        int sYidx = 0;
        int eYidx = yNum - 1;
        if (sX <= this.xArray[0]) {
            sXidx = 0;
        } else {
            for (i = 0; i < xNum; ++i) {
                if (!(sX <= this.xArray[i])) continue;
                sXidx = i;
                break;
            }
        }
        if (eX >= this.xArray[xNum - 1]) {
            eXidx = xNum - 1;
        } else {
            for (i = sXidx; i < xNum; ++i) {
                if (MIMath.doubleEquals(eX, this.xArray[i])) {
                    eXidx = i;
                    break;
                }
                if (!(eX < this.xArray[i])) continue;
                eXidx = i - 1;
                break;
            }
        }
        if (sY <= this.yArray[0]) {
            sYidx = 0;
        } else {
            for (i = 0; i < yNum; ++i) {
                if (!(sY <= this.yArray[i])) continue;
                sYidx = i;
                break;
            }
        }
        if (eY >= this.yArray[yNum - 1]) {
            eYidx = yNum - 1;
        } else {
            for (i = sYidx; i < yNum; ++i) {
                if (MIMath.doubleEquals(eY, this.yArray[i])) {
                    eYidx = i;
                    break;
                }
                if (!(eY < this.yArray[i])) continue;
                eYidx = i - 1;
                break;
            }
        }
        int newXNum = eXidx - sXidx + 1;
        double[] newX = new double[newXNum];
        for (i = sXidx; i <= eXidx; ++i) {
            newX[i - sXidx] = this.xArray[i];
        }
        int newYNum = eYidx - sYidx + 1;
        double[] newY = new double[newYNum];
        for (i = sYidx; i <= eYidx; ++i) {
            newY[i - sYidx] = this.yArray[i];
        }
        aGridData.xArray = newX;
        aGridData.yArray = newY;
        double[][] newData = new double[newYNum][newXNum];
        for (i = sYidx; i <= eYidx; ++i) {
            for (int j = sXidx; j <= eXidx; ++j) {
                newData[i - sYidx][j - sXidx] = this.data[i][j];
            }
        }
        aGridData.data = newData;
        return aGridData;
    }

    public GridData extract(int sXIdx, int sYIdx, int xNum, int yNum) {
        int i;
        GridData aGridData = new GridData();
        aGridData.projInfo = this.projInfo;
        aGridData.missingValue = this.missingValue;
        int eXIdx = sXIdx + xNum - 1;
        int eYIdx = sYIdx + yNum - 1;
        double[] newX = new double[xNum];
        for (i = sXIdx; i <= eXIdx; ++i) {
            newX[i - sXIdx] = this.xArray[i];
        }
        double[] newY = new double[yNum];
        for (i = sYIdx; i <= eYIdx; ++i) {
            newY[i - sYIdx] = this.yArray[i];
        }
        aGridData.xArray = newX;
        aGridData.yArray = newY;
        double[][] newData = new double[yNum][xNum];
        for (i = sYIdx; i <= eYIdx; ++i) {
            for (int j = sXIdx; j <= eXIdx; ++j) {
                newData[i - sYIdx][j - sXIdx] = this.data[i][j];
            }
        }
        aGridData.data = newData;
        return aGridData;
    }

    public GridData extract(int sXIdx, int eXIdx, int xstep, int sYIdx, int eYIdx, int ystep) {
        int i;
        GridData aGridData = new GridData();
        aGridData.projInfo = this.projInfo;
        aGridData.missingValue = this.missingValue;
        int xNum = (eXIdx - sXIdx) / xstep;
        int yNum = (eYIdx - sYIdx) / ystep;
        double[] newX = new double[xNum];
        int idx = 0;
        for (i = sXIdx; i < eXIdx; i += xstep) {
            newX[idx] = this.xArray[i];
            ++idx;
        }
        double[] newY = new double[yNum];
        idx = 0;
        for (i = sYIdx; i < eYIdx; i += ystep) {
            newY[idx] = this.yArray[i];
            ++idx;
        }
        aGridData.xArray = newX;
        aGridData.yArray = newY;
        double[][] newData = new double[yNum][xNum];
        int yidx = 0;
        for (i = sYIdx; i < eYIdx; i += ystep) {
            int xidx = 0;
            for (int j = sXIdx; j < eXIdx; j += xstep) {
                newData[yidx][xidx] = this.data[i][j];
                ++xidx;
            }
            ++yidx;
        }
        aGridData.data = newData;
        return aGridData;
    }

    public void setMissingValue(double value, boolean isBigger) {
        int xnum = this.getXNum();
        int ynum = this.getYNum();
        for (int i = 0; i < ynum; ++i) {
            for (int j = 0; j < xnum; ++j) {
                if (isBigger) {
                    if (!(this.data[i][j] > value)) continue;
                    this.data[i][j] = this.missingValue;
                    continue;
                }
                if (!(this.data[i][j] < value)) continue;
                this.data[i][j] = this.missingValue;
            }
        }
    }

    public GridData skip(int skipI, int skipJ) {
        int idxJ;
        int j;
        int idxI;
        int i;
        int yNum = (this.getYNum() + skipI - 1) / skipI;
        int xNum = (this.getXNum() + skipJ - 1) / skipJ;
        GridData gdata = new GridData();
        gdata.missingValue = this.missingValue;
        gdata.xArray = new double[xNum];
        gdata.yArray = new double[yNum];
        gdata.data = new double[yNum][xNum];
        for (i = 0; i < yNum; ++i) {
            idxI = i * skipI;
            gdata.yArray[i] = this.yArray[idxI];
        }
        for (j = 0; j < xNum; ++j) {
            idxJ = j * skipJ;
            gdata.xArray[j] = this.xArray[idxJ];
        }
        for (i = 0; i < yNum; ++i) {
            idxI = i * skipI;
            for (j = 0; j < xNum; ++j) {
                idxJ = j * skipJ;
                gdata.data[i][j] = this.data[idxI][idxJ];
            }
        }
        return gdata;
    }

    public double getValue(double x, double y) {
        double iValue = this.missingValue;
        int xnum = this.getXNum();
        int ynum = this.getYNum();
        if (x < this.xArray[0] || x > this.xArray[xnum - 1] || y < this.yArray[0] || y > this.yArray[ynum - 1]) {
            return iValue;
        }
        int xIdx = 0;
        int yIdx = 0;
        xIdx = (int)((x - this.xArray[0]) / this.getXDelt());
        yIdx = (int)((y - this.yArray[0]) / this.getYDelt());
        if (xIdx == xnum - 1) {
            xIdx = xnum - 2;
        }
        if (yIdx == ynum - 1) {
            yIdx = ynum - 2;
        }
        int i1 = yIdx;
        int j1 = xIdx;
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        if (x - this.xArray[j1] < this.xArray[j2] - x) {
            xIdx = j1;
            yIdx = y - this.yArray[i1] < this.yArray[i2] - y ? i1 : i2;
        } else {
            xIdx = j2;
            yIdx = y - this.yArray[i1] < this.yArray[i2] - y ? i1 : i2;
        }
        iValue = this.data[yIdx][xIdx];
        return iValue;
    }

    public double toStation_Gaussian(double x, double y) {
        double iValue = this.missingValue;
        double xmin = this.getXMin();
        double xmax = this.getXMax();
        double ymin = this.getYMin();
        double ymax = this.getYMax();
        if (x < xmin || x > xmax || y < ymin || y > ymax) {
            return iValue;
        }
        double xdelta = this.getXDelt();
        int xIdx = (int)((x - xmin) / xdelta);
        int yIdx = 0;
        int xnum = this.getXNum();
        int ynum = this.getYNum();
        if (xIdx == xnum - 1) {
            xIdx = xnum - 2;
        }
        for (int i = 0; i < ynum - 1; ++i) {
            if (!(y >= this.yArray[i]) || !(y <= this.yArray[i + 1])) continue;
            yIdx = i;
            break;
        }
        if (yIdx == ynum - 1) {
            yIdx = ynum - 2;
        }
        int i1 = yIdx;
        int j1 = xIdx;
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        double a = this.data[i1][j1];
        double b = this.data[i1][j2];
        double c = this.data[i2][j1];
        double d = this.data[i2][j2];
        ArrayList<java.lang.Double> dList = new ArrayList<java.lang.Double>();
        if (a != this.missingValue) {
            dList.add(a);
        }
        if (b != this.missingValue) {
            dList.add(b);
        }
        if (c != this.missingValue) {
            dList.add(c);
        }
        if (d != this.missingValue) {
            dList.add(d);
        }
        if (dList.isEmpty()) {
            return iValue;
        }
        if (dList.size() == 1) {
            iValue = (java.lang.Double)dList.get(0);
        } else if (dList.size() <= 3) {
            double aSum = 0.0;
            Iterator iterator = dList.iterator();
            while (iterator.hasNext()) {
                double dd = (java.lang.Double)iterator.next();
                aSum += dd;
            }
            iValue = aSum / (double)dList.size();
        } else {
            double ydelta = this.yArray[i2] - this.yArray[i1];
            double x1val = a + (c - a) * (y - this.yArray[i1]) / ydelta;
            double x2val = b + (d - b) * (y - this.yArray[i1]) / ydelta;
            iValue = x1val + (x2val - x1val) * (x - this.xArray[j1]) / xdelta;
        }
        return iValue;
    }

    public void gassianToLatLon() {
        double ymin = this.getYMin();
        double ymax = this.getYMax();
        int xnum = this.getXNum();
        int ynum = this.getYNum();
        double delta = (ymax - ymin) / (double)(ynum - 1);
        double[] newY = new double[ynum];
        for (int i = 0; i < ynum; ++i) {
            newY[i] = ymin + (double)i * delta;
        }
        double[][] newData = new double[ynum][xnum];
        for (int i = 0; i < ynum; ++i) {
            for (int j = 0; j < xnum; ++j) {
                newData[i][j] = this.toStation_Gaussian(this.xArray[j], newY[i]);
            }
        }
        this.yArray = newY;
        this.data = newData;
    }

    public void GassianToLatLon_Simple() {
        double ymin = this.getYMin();
        double ymax = this.getYMax();
        int ynum = this.getYNum();
        double delta = (ymax - ymin) / (double)(ynum - 1);
        double[] newY = new double[ynum];
        for (int i = 0; i < ynum; ++i) {
            newY[i] = ymin + (double)i * delta;
        }
        this.yArray = newY;
    }

    public double getXMin() {
        return this.xArray[0];
    }

    public double getXMax() {
        return this.xArray[this.xArray.length - 1];
    }

    public double getYMin() {
        return this.yArray[0];
    }

    public double getYMax() {
        return this.yArray[this.yArray.length - 1];
    }

    public double getBorderXMin() {
        return this.getXMin() - this.getXDelt() / 2.0;
    }

    public double getBorderXMax() {
        return this.getXMax() + this.getXDelt() / 2.0;
    }

    public double getBorderYMin() {
        return this.getYMin() - this.getYDelt() / 2.0;
    }

    public double getBorderYMax() {
        return this.getYMax() + this.getYDelt() / 2.0;
    }

    public int[] getIJIndex(double x, double y) {
        int xidx = -1;
        int yidx = -1;
        if (x >= this.getBorderXMin() && x <= this.getBorderXMax() && y >= this.getBorderYMin() && y <= this.getBorderYMax()) {
            xidx = (int)((x - this.getBorderXMin()) / this.getXDelt());
            yidx = (int)((y - this.getBorderYMin()) / this.getYDelt());
        }
        if (xidx >= this.getXNum() || yidx >= this.getYNum()) {
            xidx = -1;
            yidx = -1;
        }
        return new int[]{xidx, yidx};
    }

    public void saveAsSurferASCIIFile(String aFile) {
        try {
            BufferedWriter sw = new BufferedWriter(new FileWriter(new File(aFile)));
            sw.write("DSAA");
            sw.newLine();
            sw.write(String.valueOf(this.getXNum()) + " " + String.valueOf(this.getYNum()));
            sw.newLine();
            sw.write(String.valueOf(this.xArray[0]) + " " + String.valueOf(this.xArray[this.xArray.length - 1]));
            sw.newLine();
            sw.write(String.valueOf(this.yArray[0]) + " " + String.valueOf(this.yArray[this.yArray.length - 1]));
            sw.newLine();
            double[] maxmin = new double[2];
            this.getMaxMinValue(maxmin);
            sw.write(String.valueOf(maxmin[1]) + " " + String.valueOf(maxmin[0]));
            String aLine = "";
            for (int i = 0; i < this.getYNum(); ++i) {
                for (int j = 0; j < this.getXNum(); ++j) {
                    double value = MIMath.doubleEquals(this.data[i][j], this.missingValue) ? -9999.0 : this.data[i][j];
                    aLine = j == 0 ? String.valueOf(value) : aLine + " " + String.valueOf(value);
                }
                sw.newLine();
                sw.write(aLine);
            }
            sw.flush();
            sw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(GridData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void saveAsESRIASCIIFile(String aFile) {
        try {
            BufferedWriter sw = new BufferedWriter(new FileWriter(new File(aFile)));
            sw.write("NCOLS " + String.valueOf(this.getXNum()));
            sw.newLine();
            sw.write("NROWS " + String.valueOf(this.getYNum()));
            sw.newLine();
            sw.write("XLLCENTER " + String.valueOf(this.xArray[0]));
            sw.newLine();
            sw.write("YLLCENTER " + String.valueOf(this.yArray[0]));
            sw.newLine();
            sw.write("CELLSIZE " + String.valueOf(this.getXDelt()));
            sw.newLine();
            sw.write("NODATA_VALUE " + String.valueOf(this.missingValue));
            sw.newLine();
            String aLine = "";
            int xn = this.getXNum();
            int yn = this.getYNum();
            for (int i = 0; i < yn; ++i) {
                for (int j = 0; j < xn; ++j) {
                    double value = this.data[yn - i - 1][j];
                    aLine = j == 0 ? String.valueOf(value) : aLine + " " + String.valueOf(value);
                }
                sw.newLine();
                sw.write(aLine);
            }
            sw.flush();
            sw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(GridData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void saveAsBILFile(String fileName) throws IOException {
        try {
            DataOutputStream outs = new DataOutputStream(new FileOutputStream(new File(fileName)));
            int xn = this.getXNum();
            int yn = this.getYNum();
            for (int i = 0; i < yn; ++i) {
                for (int j = 0; j < xn; ++j) {
                    outs.writeFloat((float)this.data[yn - i - 1][j]);
                }
            }
            outs.close();
            String hfn = fileName.replace(".bil", ".hdr");
            BufferedWriter sw = new BufferedWriter(new FileWriter(new File(hfn)));
            sw.write("nrows " + String.valueOf(this.getYNum()));
            sw.newLine();
            sw.write("ncols " + String.valueOf(this.getXNum()));
            sw.newLine();
            sw.write("nbands 1");
            sw.newLine();
            sw.write("nbits 32");
            sw.newLine();
            sw.write("pixeltype float");
            sw.newLine();
            sw.write("byteorder M");
            sw.newLine();
            sw.write("layout bil");
            sw.newLine();
            sw.write("ulxmap " + String.valueOf(this.xArray[0]));
            sw.newLine();
            sw.write("ulymap " + String.valueOf(this.yArray[this.yArray.length - 1]));
            sw.newLine();
            sw.write("xdim " + String.valueOf(this.getXDelt()));
            sw.newLine();
            sw.write("ydim " + String.valueOf(this.getYDelt()));
            sw.newLine();
            sw.flush();
            sw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(GridData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void saveAsStationData(String filePath, String fieldName) {
        try {
            BufferedWriter sw = new BufferedWriter(new FileWriter(new File(filePath)));
            sw.write("Id,X,Y," + fieldName);
            String aLine = "";
            int id = 1;
            for (int i = 0; i < this.getYNum(); ++i) {
                for (int j = 0; j < this.getXNum(); ++j) {
                    if (MIMath.doubleEquals(this.data[i][j], this.missingValue)) continue;
                    aLine = String.valueOf(id) + "," + String.valueOf(this.xArray[j]) + "," + String.valueOf(this.yArray[i]) + "," + String.valueOf(this.data[i][j]);
                    sw.newLine();
                    sw.write(aLine);
                }
            }
            sw.flush();
            sw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(GridData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean getMaxMinValue(double[] maxmin) {
        double max = 0.0;
        double min = 0.0;
        int vdNum = 0;
        boolean hasUndef = false;
        for (int i = 0; i < this.getYNum(); ++i) {
            for (int j = 0; j < this.getXNum(); ++j) {
                if (java.lang.Double.isNaN(this.data[i][j]) || MIMath.doubleEquals(this.data[i][j], this.missingValue)) {
                    hasUndef = true;
                    continue;
                }
                if (vdNum == 0) {
                    max = min = this.data[i][j];
                } else {
                    if (min > this.data[i][j]) {
                        min = this.data[i][j];
                    }
                    if (max < this.data[i][j]) {
                        max = this.data[i][j];
                    }
                }
                ++vdNum;
            }
        }
        maxmin[0] = max;
        maxmin[1] = min;
        return hasUndef;
    }

    public boolean hasMissing() {
        boolean hasNaN = false;
        block0: for (int i = 0; i < this.getYNum(); ++i) {
            for (int j = 0; j < this.getXNum(); ++j) {
                if (!java.lang.Double.isNaN(this.data[i][j]) && !MIMath.doubleEquals(this.data[i][j], this.missingValue)) continue;
                hasNaN = true;
                continue block0;
            }
        }
        return hasNaN;
    }

    public boolean hasNaN() {
        boolean hasNaN = false;
        block0: for (int i = 0; i < this.getYNum(); ++i) {
            for (int j = 0; j < this.getXNum(); ++j) {
                if (!java.lang.Double.isNaN(this.data[i][j])) continue;
                hasNaN = true;
                continue block0;
            }
        }
        return hasNaN;
    }

    public double[] getMaxMinValue() {
        double max = 0.0;
        double min = 0.0;
        int vdNum = 0;
        for (int i = 0; i < this.getYNum(); ++i) {
            for (int j = 0; j < this.getXNum(); ++j) {
                if (java.lang.Double.isNaN(this.data[i][j]) || MIMath.doubleEquals(this.data[i][j], this.missingValue)) continue;
                if (vdNum == 0) {
                    max = min = this.data[i][j];
                } else {
                    if (min > this.data[i][j]) {
                        min = this.data[i][j];
                    }
                    if (max < this.data[i][j]) {
                        max = this.data[i][j];
                    }
                }
                ++vdNum;
            }
        }
        return new double[]{max, min};
    }

    public double getMaxValue() {
        return this.getMaxMinValue()[0];
    }

    public double getMinValue() {
        return this.getMaxMinValue()[1];
    }

    public boolean testUniqueValues() {
        ArrayList<Number> values = new ArrayList<Number>();
        int vdNum = 0;
        for (int i = 0; i < this.getYNum(); ++i) {
            for (int j = 0; j < this.getXNum(); ++j) {
                if (MIMath.doubleEquals(this.getValue(i, j).doubleValue(), this.missingValue)) continue;
                if (vdNum == 0) {
                    values.add(this.getValue(i, j));
                    ++vdNum;
                } else if (!values.contains(this.getValue(i, j))) {
                    values.add(this.getValue(i, j));
                    ++vdNum;
                }
                if (vdNum <= 20) continue;
                return false;
            }
        }
        return true;
    }

    public List<Number> getUniqueValues() {
        ArrayList<Number> values = new ArrayList<Number>();
        int vdNum = 0;
        for (int i = 0; i < this.getYNum(); ++i) {
            for (int j = 0; j < this.getXNum(); ++j) {
                if (MIMath.doubleEquals(this.getValue(i, j).doubleValue(), this.missingValue)) continue;
                if (vdNum == 0) {
                    values.add(this.getValue(i, j));
                } else if (!values.contains(this.getValue(i, j))) {
                    values.add(this.getValue(i, j));
                }
                ++vdNum;
            }
        }
        return values;
    }

    public GridDataSetting getGridDataSetting() {
        GridDataSetting gDataSet = new GridDataSetting();
        gDataSet.dataExtent = (Extent)this.getExtent().clone();
        gDataSet.xNum = this.getXNum();
        gDataSet.yNum = this.getYNum();
        return gDataSet;
    }

    public GridData maskout(PolygonShape aPGS) {
        int xNum = this.getXNum();
        int yNum = this.getYNum();
        GridData cGrid = new GridData(this);
        for (int i = 0; i < yNum; ++i) {
            int j;
            if (this.yArray[i] >= aPGS.getExtent().minY && this.yArray[i] <= aPGS.getExtent().maxY) {
                for (j = 0; j < xNum; ++j) {
                    if (this.xArray[j] >= aPGS.getExtent().minX && this.xArray[j] <= aPGS.getExtent().maxX) {
                        if (GeoComputation.pointInPolygon(aPGS, new PointD(this.xArray[j], this.yArray[i]))) {
                            cGrid.data[i][j] = this.data[i][j];
                            continue;
                        }
                        cGrid.data[i][j] = this.missingValue;
                        continue;
                    }
                    cGrid.data[i][j] = this.missingValue;
                }
                continue;
            }
            for (j = 0; j < xNum; ++j) {
                cGrid.data[i][j] = this.missingValue;
            }
        }
        return cGrid;
    }

    public GridData maskout(List<PolygonShape> polygons) {
        int xNum = this.getXNum();
        int yNum = this.getYNum();
        GridData cGrid = new GridData(this);
        for (int i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                cGrid.data[i][j] = GeoComputation.pointInPolygons(polygons, new PointD(this.xArray[j], this.yArray[i])) ? this.data[i][j] : this.missingValue;
            }
        }
        return cGrid;
    }

    public GridData maskout(VectorLayer maskLayer) {
        if (maskLayer.getShapeType() != ShapeTypes.Polygon) {
            return this;
        }
        int xNum = this.getXNum();
        int yNum = this.getYNum();
        GridData cGrid = new GridData(this);
        for (int i = 0; i < yNum; ++i) {
            int j;
            if (this.yArray[i] >= maskLayer.getExtent().minY && this.yArray[i] <= maskLayer.getExtent().maxY) {
                for (j = 0; j < xNum; ++j) {
                    if (this.xArray[j] >= maskLayer.getExtent().minX && this.xArray[j] <= maskLayer.getExtent().maxX) {
                        if (GeoComputation.pointInPolygonLayer(maskLayer, new PointD(this.xArray[j], this.yArray[i]), false)) {
                            cGrid.data[i][j] = this.data[i][j];
                            continue;
                        }
                        cGrid.data[i][j] = this.missingValue;
                        continue;
                    }
                    cGrid.data[i][j] = this.missingValue;
                }
                continue;
            }
            for (j = 0; j < xNum; ++j) {
                cGrid.data[i][j] = this.missingValue;
            }
        }
        return cGrid;
    }

    public GridData maskout(GridData maskGrid) {
        GridData cGrid = new GridData(this);
        int xnum = this.getXNum();
        int ynum = this.getYNum();
        for (int i = 0; i < ynum; ++i) {
            for (int j = 0; j < xnum; ++j) {
                cGrid.data[i][j] = maskGrid.data[i][j] >= 0.0 ? this.data[i][j] : this.missingValue;
            }
        }
        return cGrid;
    }

    public GridData resample(GridData toGridData, ResampleMethods method) {
        GridData gridData;
        if (this.projInfo.equals(toGridData.projInfo)) {
            switch (method) {
                case NearestNeighbor: {
                    gridData = this.resample_Neighbor(toGridData.xArray, toGridData.yArray);
                    break;
                }
                default: {
                    gridData = this.resample_Bilinear(toGridData.xArray, toGridData.yArray);
                    break;
                }
            }
        } else {
            gridData = this.project(toGridData.projInfo, toGridData.xArray, toGridData.yArray, method);
        }
        gridData.projInfo = toGridData.projInfo;
        return gridData;
    }

    private GridData resample_Neighbor(double[] newX, double[] newY) {
        double[][] newdata = new double[newY.length][newX.length];
        double[][] points = new double[1][];
        for (int i = 0; i < newY.length; ++i) {
            double y = newY[i];
            for (int j = 0; j < newX.length; ++j) {
                points[0] = new double[]{newX[j], newY[i]};
                double x = newX[j];
                if (x < this.xArray[0] || x > this.xArray[this.xArray.length - 1]) {
                    newdata[i][j] = this.missingValue;
                    continue;
                }
                if (y < this.yArray[0] || y > this.yArray[this.yArray.length - 1]) {
                    newdata[i][j] = this.missingValue;
                    continue;
                }
                int xIdx = (int)((x - this.xArray[0]) / this.getXDelt());
                int yIdx = (int)((y - this.yArray[0]) / this.getYDelt());
                newdata[i][j] = this.data[yIdx][xIdx];
            }
        }
        GridData gData = new GridData(this);
        gData.data = newdata;
        gData.xArray = newX;
        gData.yArray = newY;
        return gData;
    }

    private GridData resample_Bilinear(double[] newX, double[] newY) {
        double[][] newdata = new double[newY.length][newX.length];
        double[][] points = new double[1][];
        for (int i = 0; i < newY.length; ++i) {
            double y = newY[i];
            for (int j = 0; j < newX.length; ++j) {
                points[0] = new double[]{newX[j], newY[i]};
                double x = newX[j];
                newdata[i][j] = x < this.xArray[0] || x > this.xArray[this.xArray.length - 1] ? this.missingValue : (y < this.yArray[0] || y > this.yArray[this.yArray.length - 1] ? this.missingValue : this.toStation(x, y));
            }
        }
        GridData gData = new GridData(this);
        gData.data = newdata;
        gData.xArray = newX;
        gData.yArray = newY;
        return gData;
    }

    public GridData interpolate() {
        int i;
        int nxNum = this.xArray.length * 2 - 1;
        int nyNum = this.yArray.length * 2 - 1;
        double[] newX = new double[nxNum];
        double[] newY = new double[nyNum];
        double[][] newData = this.interpolation_Grid(this.data, this.xArray, this.yArray, this.missingValue, newX, newY);
        for (i = 0; i < nxNum; ++i) {
            newX[i] = i % 2 == 0 ? this.xArray[i / 2] : (this.xArray[(i - 1) / 2] + this.xArray[(i - 1) / 2 + 1]) / 2.0;
        }
        for (i = 0; i < nyNum; ++i) {
            newY[i] = i % 2 == 0 ? this.yArray[i / 2] : (this.yArray[(i - 1) / 2] + this.yArray[(i - 1) / 2 + 1]) / 2.0;
        }
        GridData gdata = new GridData();
        gdata.data = newData;
        gdata.xArray = newX;
        gdata.yArray = newY;
        gdata.missingValue = this.missingValue;
        return gdata;
    }

    public double[][] interpolation_Grid(double[][] GridData2, double[] X, double[] Y, double unDefData, double[] nX, double[] nY) {
        int i;
        int nxNum = X.length * 2 - 1;
        int nyNum = Y.length * 2 - 1;
        nX = new double[nxNum];
        nY = new double[nyNum];
        double[][] nGridData = new double[nyNum][nxNum];
        for (i = 0; i < nxNum; ++i) {
            nX[i] = i % 2 == 0 ? X[i / 2] : (X[(i - 1) / 2] + X[(i - 1) / 2 + 1]) / 2.0;
        }
        for (i = 0; i < nyNum; ++i) {
            nY[i] = i % 2 == 0 ? Y[i / 2] : (Y[(i - 1) / 2] + Y[(i - 1) / 2 + 1]) / 2.0;
            for (int j = 0; j < nxNum; ++j) {
                ArrayList<java.lang.Double> dList;
                double b;
                double a;
                if (i % 2 == 0 && j % 2 == 0) {
                    nGridData[i][j] = GridData2[i / 2][j / 2];
                    continue;
                }
                if (i % 2 == 0 && j % 2 != 0) {
                    a = GridData2[i / 2][(j - 1) / 2];
                    b = GridData2[i / 2][(j - 1) / 2 + 1];
                    dList = new ArrayList<java.lang.Double>();
                    if (a != unDefData) {
                        dList.add(a);
                    }
                    if (b != unDefData) {
                        dList.add(b);
                    }
                    if (dList.isEmpty()) {
                        nGridData[i][j] = unDefData;
                        continue;
                    }
                    if (dList.size() == 1) {
                        nGridData[i][j] = (java.lang.Double)dList.get(0);
                        continue;
                    }
                    nGridData[i][j] = (a + b) / 2.0;
                    continue;
                }
                if (i % 2 != 0 && j % 2 == 0) {
                    a = GridData2[(i - 1) / 2][j / 2];
                    b = GridData2[(i - 1) / 2 + 1][j / 2];
                    dList = new ArrayList();
                    if (a != unDefData) {
                        dList.add(a);
                    }
                    if (b != unDefData) {
                        dList.add(b);
                    }
                    if (dList.isEmpty()) {
                        nGridData[i][j] = unDefData;
                        continue;
                    }
                    if (dList.size() == 1) {
                        nGridData[i][j] = (java.lang.Double)dList.get(0);
                        continue;
                    }
                    nGridData[i][j] = (a + b) / 2.0;
                    continue;
                }
                a = GridData2[(i - 1) / 2][(j - 1) / 2];
                b = GridData2[(i - 1) / 2][(j - 1) / 2 + 1];
                double c = GridData2[(i - 1) / 2 + 1][(j - 1) / 2 + 1];
                double d = GridData2[(i - 1) / 2 + 1][(j - 1) / 2];
                dList = new ArrayList();
                if (a != unDefData) {
                    dList.add(a);
                }
                if (b != unDefData) {
                    dList.add(b);
                }
                if (c != unDefData) {
                    dList.add(c);
                }
                if (d != unDefData) {
                    dList.add(d);
                }
                if (dList.isEmpty()) {
                    nGridData[i][j] = unDefData;
                    continue;
                }
                if (dList.size() == 1) {
                    nGridData[i][j] = (java.lang.Double)dList.get(0);
                    continue;
                }
                double aSum = 0.0;
                Iterator iterator = dList.iterator();
                while (iterator.hasNext()) {
                    double dd = (java.lang.Double)iterator.next();
                    aSum += dd;
                }
                nGridData[i][j] = aSum / (double)dList.size();
            }
        }
        return nGridData;
    }

    public GridData interpolate_old() {
        int i;
        int nxNum = this.xArray.length * 2 - 1;
        int nyNum = this.yArray.length * 2 - 1;
        double[] newX = new double[nxNum];
        double[] newY = new double[nyNum];
        for (i = 0; i < nxNum; ++i) {
            newX[i] = i % 2 == 0 ? this.xArray[i / 2] : (this.xArray[(i - 1) / 2] + this.xArray[(i - 1) / 2 + 1]) / 2.0;
        }
        for (i = 0; i < nyNum; ++i) {
            newY[i] = i % 2 == 0 ? this.yArray[i / 2] : (this.yArray[(i - 1) / 2] + this.yArray[(i - 1) / 2 + 1]) / 2.0;
        }
        return this.resample_Bilinear(newX, newY);
    }

    public GridData project(ProjectionInfo toProj) {
        if (this.projInfo == null) {
            return null;
        }
        return this.project(this.projInfo, toProj, ResampleMethods.NearestNeighbor);
    }

    public GridData project(ProjectionInfo fromProj, ProjectionInfo toProj) {
        return this.project(fromProj, toProj, ResampleMethods.NearestNeighbor);
    }

    public GridData project(ProjectionInfo fromProj, ProjectionInfo toProj, ResampleMethods resampleMethod) {
        int i;
        int xnum = this.getXNum();
        int ynum = this.getYNum();
        Extent aExtent = this.isGlobal() || this.xArray[xnum - 1] - this.xArray[0] == 360.0 ? ProjectionUtil.getProjectionGlobalExtent(toProj) : ProjectionUtil.getProjectionExtent(fromProj, toProj, this.xArray, this.yArray);
        double xDelt = (aExtent.maxX - aExtent.minX) / (double)(xnum - 1);
        double yDelt = (aExtent.maxY - aExtent.minY) / (double)(ynum - 1);
        double[] newX = new double[xnum];
        double[] newY = new double[ynum];
        for (i = 0; i < newX.length; ++i) {
            newX[i] = aExtent.minX + (double)i * xDelt;
        }
        for (i = 0; i < newY.length; ++i) {
            newY[i] = aExtent.minY + (double)i * yDelt;
        }
        GridData pGridData = this.project(fromProj, toProj, newX, newY, resampleMethod);
        return pGridData;
    }

    public GridData project(ProjectionInfo toProj, double[] newX, double[] newY) {
        if (this.projInfo == null) {
            return null;
        }
        return this.project_Neighbor(this.projInfo, toProj, newX, newY);
    }

    public GridData project(ProjectionInfo toProj, double[] newX, double[] newY, ResampleMethods resampleMethod) {
        if (this.projInfo == null) {
            return null;
        }
        return this.project(this.projInfo, toProj, newX, newY, resampleMethod);
    }

    public GridData project(ProjectionInfo fromProj, ProjectionInfo toProj, double[] newX, double[] newY, ResampleMethods resampleMethod) {
        switch (resampleMethod) {
            case Bilinear: {
                return this.project_Bilinear(fromProj, toProj, newX, newY);
            }
            case NearestNeighbor: {
                return this.project_Neighbor(fromProj, toProj, newX, newY);
            }
        }
        return this.project_Bilinear(fromProj, toProj, newX, newY);
    }

    public StationData project(ProjectionInfo fromProj, ProjectionInfo toProj, StationData stData, ResampleMethods resampleMethod) {
        switch (resampleMethod) {
            case Bilinear: {
                return this.project_Bilinear(fromProj, toProj, stData);
            }
        }
        return this.project_Bilinear(fromProj, toProj, stData);
    }

    private GridData project_Neighbor(ProjectionInfo fromProj, ProjectionInfo toProj, double[] newX, double[] newY) {
        double[][] newdata = new double[newY.length][newX.length];
        double[][] points = new double[1][];
        for (int i = 0; i < newY.length; ++i) {
            for (int j = 0; j < newX.length; ++j) {
                points[0] = new double[]{newX[j], newY[i]};
                try {
                    Reproject.reprojectPoints(points, toProj, fromProj, 0, 1);
                    double x = points[0][0];
                    double y = points[0][1];
                    if (x < this.xArray[0] || x > this.xArray[this.xArray.length - 1]) {
                        newdata[i][j] = this.missingValue;
                        continue;
                    }
                    if (y < this.yArray[0] || y > this.yArray[this.yArray.length - 1]) {
                        newdata[i][j] = this.missingValue;
                        continue;
                    }
                    int xIdx = (int)((x - this.xArray[0]) / this.getXDelt());
                    int yIdx = (int)((y - this.yArray[0]) / this.getYDelt());
                    newdata[i][j] = this.data[yIdx][xIdx];
                    continue;
                }
                catch (Exception e) {
                    newdata[i][j] = this.missingValue;
                    ++j;
                }
            }
        }
        GridData gData = new GridData(this);
        gData.data = newdata;
        gData.xArray = newX;
        gData.yArray = newY;
        return gData;
    }

    private GridData project_Bilinear(ProjectionInfo fromProj, ProjectionInfo toProj, double[] newX, double[] newY) {
        double[][] newdata = new double[newY.length][newX.length];
        double[][] points = new double[1][];
        for (int i = 0; i < newY.length; ++i) {
            for (int j = 0; j < newX.length; ++j) {
                points[0] = new double[]{newX[j], newY[i]};
                try {
                    Reproject.reprojectPoints(points, toProj, fromProj, 0, 1);
                    double x = points[0][0];
                    double y = points[0][1];
                    if (x < this.xArray[0] || x > this.xArray[this.xArray.length - 1]) {
                        newdata[i][j] = this.missingValue;
                        continue;
                    }
                    if (y < this.yArray[0] || y > this.yArray[this.yArray.length - 1]) {
                        newdata[i][j] = this.missingValue;
                        continue;
                    }
                    newdata[i][j] = this.toStation(x, y);
                    continue;
                }
                catch (Exception e) {
                    newdata[i][j] = this.missingValue;
                    ++j;
                }
            }
        }
        GridData gData = new GridData(this);
        gData.data = newdata;
        gData.xArray = newX;
        gData.yArray = newY;
        return gData;
    }

    private StationData project_Bilinear(ProjectionInfo fromProj, ProjectionInfo toProj, StationData stData) {
        StationData nsData = new StationData(stData);
        nsData.missingValue = this.missingValue;
        double[][] points = new double[1][];
        for (int i = 0; i < stData.getStNum(); ++i) {
            points[0] = new double[]{stData.getX(i), stData.getY(i)};
            try {
                Reproject.reprojectPoints(points, toProj, fromProj, 0, 1);
                double x = points[0][0];
                double y = points[0][1];
                if (x < this.xArray[0] || x > this.xArray[this.xArray.length - 1]) {
                    nsData.setValue(i, this.missingValue);
                    continue;
                }
                if (y < this.yArray[0] || y > this.yArray[this.yArray.length - 1]) {
                    nsData.setValue(i, this.missingValue);
                    continue;
                }
                nsData.setValue(i, this.toStation(x, y));
                continue;
            }
            catch (Exception e) {
                nsData.setValue(i, this.missingValue);
                ++i;
            }
        }
        return nsData;
    }

    public void aggregate(GridData toGridData, boolean isAverage) {
        int yIdx;
        int xIdx;
        double x;
        int j;
        double y;
        int i;
        int xnum = this.getXNum();
        int ynum = this.getYNum();
        int toXnum = toGridData.getXNum();
        int toYnum = toGridData.getYNum();
        int[][] nums = new int[toYnum][toXnum];
        toGridData.setValue(0.0);
        if (this.projInfo.equals(toGridData.projInfo)) {
            for (i = 0; i < ynum; ++i) {
                y = this.yArray[i];
                for (j = 0; j < xnum; ++j) {
                    x = this.xArray[j];
                    int[] ij = toGridData.getIJIndex(x, y);
                    xIdx = ij[0];
                    yIdx = ij[1];
                    if (xIdx < 0 || yIdx < 0) continue;
                    double[] dArray = toGridData.data[yIdx];
                    int n = xIdx;
                    dArray[n] = dArray[n] + this.data[i][j];
                    int[] nArray = nums[yIdx];
                    int n2 = xIdx;
                    nArray[n2] = nArray[n2] + 1;
                }
            }
        } else {
            double[][] points = new double[1][];
            for (i = 0; i < ynum; ++i) {
                double y0 = this.yArray[i];
                for (j = 0; j < xnum; ++j) {
                    x = this.xArray[j];
                    y = y0;
                    points[0] = new double[]{x, y};
                    try {
                        Reproject.reprojectPoints(points, this.projInfo, toGridData.projInfo, 0, 1);
                        x = points[0][0];
                        y = points[0][1];
                        if (java.lang.Double.isNaN(x) || java.lang.Double.isNaN(y)) continue;
                        int[] ij = toGridData.getIJIndex(x, y);
                        xIdx = ij[0];
                        yIdx = ij[1];
                        if (xIdx < 0 || yIdx < 0) continue;
                        double[] dArray = toGridData.data[yIdx];
                        int n = xIdx;
                        dArray[n] = dArray[n] + this.data[i][j];
                        int[] nArray = nums[yIdx];
                        int n3 = xIdx;
                        nArray[n3] = nArray[n3] + 1;
                        continue;
                    }
                    catch (Exception e) {
                        ++j;
                    }
                }
            }
        }
        if (isAverage) {
            for (i = 0; i < toYnum; ++i) {
                for (j = 0; j < toXnum; ++j) {
                    toGridData.data[i][j] = nums[i][j] == 0 ? toGridData.missingValue : toGridData.data[i][j] / (double)nums[i][j];
                }
            }
        }
    }

    public GridData unStagger_X() {
        int xn = this.getXNum();
        int yn = this.getYNum();
        double dx = this.getXDelt();
        int xn_us = xn - 1;
        GridData usData = new GridData(this);
        usData.xArray = new double[xn_us];
        usData.data = new double[yn][xn_us];
        for (int i = 0; i < yn; ++i) {
            for (int j = 0; j < xn_us; ++j) {
                if (i == 0) {
                    usData.xArray[j] = this.xArray[j] + dx;
                }
                usData.data[i][j] = (this.data[i][j] + this.data[i][j + 1]) * 0.5;
            }
        }
        return usData;
    }

    public GridData unStagger_Y() {
        int xn = this.getXNum();
        int yn = this.getYNum();
        double dy = this.getYDelt();
        int yn_us = yn - 1;
        GridData usData = new GridData(this);
        usData.yArray = new double[yn_us];
        usData.data = new double[yn_us][xn];
        for (int i = 0; i < yn_us; ++i) {
            for (int j = 0; j < xn; ++j) {
                if (j == 0) {
                    usData.yArray[i] = this.yArray[i] + dy;
                }
                usData.data[i][j] = (this.data[i][j] + this.data[i + 1][j]) * 0.5;
            }
        }
        return usData;
    }

    public Object clone() {
        GridData newGriddata = new GridData(this);
        newGriddata.data = (double[][])this.data.clone();
        return newGriddata;
    }

    public void yReverse() {
        int xNum = this.getXNum();
        int yNum = this.getYNum();
        double[][] newdata = new double[yNum][xNum];
        for (int i = 0; i < yNum; ++i) {
            System.arraycopy(this.data[i], 0, newdata[yNum - i - 1], 0, xNum);
        }
        this.data = newdata;
    }

    public void xReverse() {
        int xNum = this.getXNum();
        int yNum = this.getYNum();
        double[][] newdata = new double[yNum][xNum];
        for (int i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                newdata[i][j] = this.data[i][xNum - j - 1];
            }
        }
        this.data = newdata;
    }

    public GridArray toGridArray() {
        Array a = Array.factory(DataType.DOUBLE, new int[]{this.getYNum(), this.getXNum()});
        int idx = 0;
        for (int i = 0; i < this.getYNum(); ++i) {
            for (int j = 0; j < this.getXNum(); ++j) {
                a.setDouble(idx, this.getDoubleValue(i, j));
                ++idx;
            }
        }
        GridArray r = new GridArray();
        r.data = a;
        r.xArray = this.xArray;
        r.yArray = this.yArray;
        r.projInfo = this.projInfo;
        r.missingValue = this.missingValue;
        return r;
    }

    public static class Float
    extends GridData {
        private float[][] data;
        private float missingValue;

        public Float(int yNum, int xNum) {
            this.data = new float[yNum][xNum];
            this.missingValue = -9999.0f;
        }

        public float getMissingValue() {
            return this.missingValue;
        }

        public void setMissingValue(float value) {
            this.missingValue = value;
        }

        @Override
        public Number getValue(int i, int j) {
            return java.lang.Float.valueOf(this.data[i][j]);
        }

        public void setValue(int i, int j, float value) {
            this.data[i][j] = value;
        }

        @Override
        public double getDoubleValue(int i, int j) {
            return this.data[i][j];
        }
    }

    public static class Double
    extends GridData {
        private double[][] data;
        private double missingValue;

        public Double(int yNum, int xNum) {
            this.data = new double[yNum][xNum];
            this.missingValue = -9999.0;
        }

        public double getMissingValue() {
            return this.missingValue;
        }

        public void setMissingValue(double value) {
            this.missingValue = value;
        }

        @Override
        public Number getValue(int i, int j) {
            return this.data[i][j];
        }

        public void setValue(int i, int j, double value) {
            this.data[i][j] = value;
        }

        @Override
        public double getDoubleValue(int i, int j) {
            return this.data[i][j];
        }
    }

    public static class Integer
    extends GridData {
        private final int[][] data;
        private int missingValue;

        public Integer(int yNum, int xNum) {
            this.data = new int[yNum][xNum];
            this.missingValue = -9999;
        }

        public int getMissingValue() {
            return this.missingValue;
        }

        public void setMissingValue(int value) {
            this.missingValue = value;
        }

        @Override
        public Number getValue(int i, int j) {
            return this.data[i][j];
        }

        public void setValue(int i, int j, int value) {
            this.data[i][j] = value;
        }

        @Override
        public double getDoubleValue(int i, int j) {
            return this.data[i][j];
        }

        @Override
        public boolean getMaxMinValue(double[] maxmin) {
            double max = 0.0;
            double min = 0.0;
            int vdNum = 0;
            boolean hasUndef = false;
            for (int i = 0; i < this.getYNum(); ++i) {
                for (int j = 0; j < this.getXNum(); ++j) {
                    if (this.data[i][j] == this.missingValue) {
                        hasUndef = true;
                        continue;
                    }
                    if (vdNum == 0) {
                        max = min = (double)this.data[i][j];
                    } else {
                        if (min > (double)this.data[i][j]) {
                            min = this.data[i][j];
                        }
                        if (max < (double)this.data[i][j]) {
                            max = this.data[i][j];
                        }
                    }
                    ++vdNum;
                }
            }
            maxmin[0] = max;
            maxmin[1] = min;
            return hasUndef;
        }
    }

    public static class Byte
    extends GridData {
        private byte[][] data;
        private int missingValue;

        public Byte(int yNum, int xNum) {
            this.data = new byte[yNum][xNum];
            this.missingValue = -9999;
        }

        public int getMissingValue() {
            return this.missingValue;
        }

        public void setMissingValue(int value) {
            this.missingValue = value;
        }

        @Override
        public Number getValue(int i, int j) {
            return DataConvert.byte2Int(this.data[i][j]);
        }

        public void setValue(int i, int j, byte value) {
            this.data[i][j] = value;
        }

        @Override
        public double getDoubleValue(int i, int j) {
            return this.getValue(i, j).doubleValue();
        }

        @Override
        public boolean getMaxMinValue(double[] maxmin) {
            double max = 0.0;
            double min = 0.0;
            int vdNum = 0;
            boolean hasUndef = false;
            for (int i = 0; i < this.getYNum(); ++i) {
                for (int j = 0; j < this.getXNum(); ++j) {
                    int v = this.getValue(i, j).intValue();
                    if (v == this.missingValue) {
                        hasUndef = true;
                        continue;
                    }
                    if (vdNum == 0) {
                        max = min = (double)v;
                    } else {
                        if (min > (double)v) {
                            min = v;
                        }
                        if (max < (double)v) {
                            max = v;
                        }
                    }
                    ++vdNum;
                }
            }
            maxmin[0] = max;
            maxmin[1] = min;
            return hasUndef;
        }

        @Override
        public GridArray toGridArray() {
            Array a = Array.factory(DataType.DOUBLE, new int[]{this.getYNum(), this.getXNum()});
            int idx = 0;
            for (int i = 0; i < this.getYNum(); ++i) {
                for (int j = 0; j < this.getXNum(); ++j) {
                    a.setDouble(idx, (double)this.data[i][j]);
                    ++idx;
                }
            }
            GridArray r = new GridArray();
            r.data = a;
            r.xArray = this.xArray;
            r.yArray = this.yArray;
            r.projInfo = this.projInfo;
            r.missingValue = this.missingValue;
            return r;
        }
    }
}

