/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.dataframe;

import org.joda.time.DateTime;
import org.meteoinfo.data.dataframe.Column;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;

public class DateTimeColumn
extends Column {
    public DateTimeColumn() {
        this("Column");
    }

    public DateTimeColumn(String name) {
        this(name, "yyyy-MM-dd");
    }

    public DateTimeColumn(String name, String format) {
        this.name = name;
        this.dataType = DataType.OBJECT;
        this.format = format;
        this.formatLen = Math.max(this.name.length(), this.format.length());
    }

    @Override
    public void setFormat(String value) {
        this.format = value;
        this.formatLen = Math.max(this.name.length(), this.format.length());
    }

    @Override
    public void setName(String value) {
        this.formatLen = Math.max(this.name.length(), this.format.length());
    }

    @Override
    public String toString(Object o) {
        return this.toString((DateTime)o);
    }

    public String toString(DateTime t) {
        return t.toString(this.format);
    }

    @Override
    public void updateFormat(Array data) {
        int n = Math.min(10, (int)data.getSize());
        String ff = "yyyyMMddHHmmSS";
        int idx = 8;
        for (int i = 0; i < n; ++i) {
            String str = ((DateTime)data.getObject(i)).toString(ff);
            str = DataConvert.removeTail0(str);
            idx = Math.max(idx, str.length());
        }
        switch (idx) {
            case 8: {
                ff = "yyyy-MM-dd";
                break;
            }
            case 9: 
            case 10: {
                ff = "yyyy-MM-dd HH";
                break;
            }
            case 11: 
            case 12: {
                ff = "yyyy-MM-dd HH:mm";
                break;
            }
            case 13: 
            case 14: {
                ff = "yyyy-MM-dd HH:mm:SS";
            }
        }
        this.setFormat(ff);
    }
}

