/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.dataframe;

import org.meteoinfo.data.dataframe.DateTimeIndex;
import org.meteoinfo.data.dataframe.GroupBy;
import org.meteoinfo.data.dataframe.Series;
import org.meteoinfo.data.dataframe.impl.Aggregation;
import org.meteoinfo.data.dataframe.impl.Function;
import org.meteoinfo.data.dataframe.impl.Grouping;

public class SeriesGroupBy
extends GroupBy {
    private final Series series;

    public SeriesGroupBy(Grouping groups, Series series) {
        this.groups = groups;
        this.series = series;
    }

    public <V> Series apply(Function<?, ?> function) {
        Series s = this.groups.apply(this.series, function);
        if (this.series.getIndex() instanceof DateTimeIndex && s.getIndex() instanceof DateTimeIndex) {
            ((DateTimeIndex)s.getIndex()).setPeriod(((DateTimeIndex)this.series.getIndex()).getResamplePeriod());
        }
        return s;
    }

    @Override
    public Series count() {
        Series r = this.apply(new Aggregation.Count());
        return r;
    }

    @Override
    public Series sum() {
        Series r = this.apply(new Aggregation.Sum());
        return r;
    }

    @Override
    public Series mean() {
        Series r = this.apply(new Aggregation.Mean());
        return r;
    }

    @Override
    public Series min() {
        Series r = this.apply(new Aggregation.Min());
        return r;
    }

    @Override
    public Series max() {
        Series r = this.apply(new Aggregation.Max());
        return r;
    }

    @Override
    public Series median() {
        Series r = this.apply(new Aggregation.Median());
        return r;
    }

    @Override
    public Series stdDev() {
        Series r = this.apply(new Aggregation.StdDev());
        return r;
    }

    @Override
    public Series percentile(double quantile) {
        Series r = this.apply(new Aggregation.Percentile(quantile * 100.0));
        return r;
    }
}

