/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.dataframe.impl;

import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Min;
import org.apache.commons.math3.stat.descriptive.summary.Product;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.meteoinfo.data.dataframe.impl.Function;

public class Transforms {

    public static class CumulativeMax<V>
    extends AbstractCumulativeFunction<V> {
        public CumulativeMax() {
            super((StorelessUnivariateStatistic)new Max(), Double.MIN_VALUE);
        }
    }

    public static class CumulativeMin<V>
    extends AbstractCumulativeFunction<V> {
        public CumulativeMin() {
            super((StorelessUnivariateStatistic)new Min(), Double.MAX_VALUE);
        }
    }

    public static class CumulativeProduct<V>
    extends AbstractCumulativeFunction<V> {
        public CumulativeProduct() {
            super((StorelessUnivariateStatistic)new Product(), 1);
        }
    }

    public static class CumulativeSum<V>
    extends AbstractCumulativeFunction<V> {
        public CumulativeSum() {
            super((StorelessUnivariateStatistic)new Sum(), 0);
        }
    }

    private static class AbstractCumulativeFunction<V>
    implements CumulativeFunction<Number, Number> {
        private final StorelessUnivariateStatistic stat;
        private final Number initialValue;

        protected AbstractCumulativeFunction(StorelessUnivariateStatistic stat, Number initialValue) {
            this.stat = stat;
            this.initialValue = initialValue;
            this.reset();
        }

        @Override
        public Number apply(Number value) {
            this.stat.increment(value.doubleValue());
            return this.stat.getResult();
        }

        @Override
        public void reset() {
            this.stat.clear();
            this.stat.increment(this.initialValue.doubleValue());
        }
    }

    public static interface CumulativeFunction<I, O>
    extends Function<I, O> {
        public void reset();
    }
}

