/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.mapdata;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.mapdata.Field;
import org.meteoinfo.data.mapdata.MapDataType;
import org.meteoinfo.data.mapdata.ShapeFileManage;
import org.meteoinfo.data.mapdata.geotiff.GeoTiff;
import org.meteoinfo.data.meteodata.DrawMeteoData;
import org.meteoinfo.data.meteodata.ascii.ASCIIGridDataInfo;
import org.meteoinfo.data.meteodata.ascii.SurferGridDataInfo;
import org.meteoinfo.data.meteodata.bandraster.BILDataInfo;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointD;
import org.meteoinfo.global.util.GlobalUtil;
import org.meteoinfo.layer.ImageLayer;
import org.meteoinfo.layer.LayerDrawType;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.layer.RasterLayer;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.layer.WorldFilePara;
import org.meteoinfo.legend.LegendManage;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.LegendType;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.info.ProjectionInfo;
import org.meteoinfo.shape.PointShape;
import org.meteoinfo.shape.PolygonShape;
import org.meteoinfo.shape.PolylineShape;
import org.meteoinfo.shape.Shape;
import org.meteoinfo.shape.ShapeTypes;

public class MapDataManage {
    public static MapDataType canOpen(String fileName) throws FileNotFoundException, IOException {
        MapDataType mdt = null;
        if (new File(fileName).isFile()) {
            String ext = GlobalUtil.getFileExtension(fileName);
            switch (ext.toLowerCase()) {
                case "shp": {
                    mdt = MapDataType.SHAPE;
                    break;
                }
                case "wmp": {
                    mdt = MapDataType.WMP;
                    break;
                }
                case "bmp": 
                case "gif": 
                case "jpg": 
                case "png": {
                    mdt = MapDataType.IMAGE;
                    break;
                }
                case "tif": {
                    mdt = MapDataType.GEO_TIFF;
                    break;
                }
                case "bil": 
                case "bip": 
                case "bsq": {
                    mdt = MapDataType.BIL;
                    break;
                }
                default: {
                    RandomAccessFile br = new RandomAccessFile(fileName, "r");
                    byte[] bytes = new byte[100];
                    br.read(bytes);
                    String line = new String(bytes).trim().toUpperCase();
                    br.close();
                    mdt = line.contains("NCOLS") ? MapDataType.ESRI_ASCII_GRID : (line.contains("DSAA") ? MapDataType.SURFER_ASCII_GRID : MapDataType.GRADS);
                }
            }
        }
        return mdt;
    }

    public static MapLayer loadLayer(String aFile) throws IOException, FileNotFoundException, Exception {
        MapDataType mdt = MapDataManage.canOpen(aFile);
        if (mdt == null) {
            return null;
        }
        MapLayer aLayer = null;
        switch (mdt) {
            case SHAPE: {
                aLayer = MapDataManage.readMapFile_ShapeFile(aFile);
                break;
            }
            case WMP: {
                aLayer = MapDataManage.readMapFile_WMP(aFile);
                break;
            }
            case IMAGE: {
                aLayer = MapDataManage.readImageFile(aFile);
                break;
            }
            case GEO_TIFF: {
                aLayer = MapDataManage.readGeoTiffFile(aFile);
                break;
            }
            case BIL: {
                aLayer = MapDataManage.readBILFile(aFile);
                break;
            }
            case ESRI_ASCII_GRID: {
                aLayer = MapDataManage.readESRI_ASCII_GRID(aFile);
                break;
            }
            case SURFER_ASCII_GRID: {
                aLayer = MapDataManage.readSurfer_ASCII_GRID(aFile);
                break;
            }
            case GRADS: {
                aLayer = MapDataManage.readMapFile_GrADS(aFile);
            }
        }
        if (aLayer != null) {
            switch (mdt) {
                case BIL: 
                case ESRI_ASCII_GRID: 
                case SURFER_ASCII_GRID: {
                    String projFn = aFile.substring(0, aFile.length() - 4) + ".prj";
                    File pFile = new File(projFn);
                    if (!pFile.isFile()) break;
                    ProjectionInfo projInfo = ShapeFileManage.loadProjFile(pFile);
                    aLayer.setProjInfo(projInfo);
                }
            }
        }
        return aLayer;
    }

    public static MapLayer loadLayer(String aFile, ProjectionInfo projInfo) throws IOException, FileNotFoundException, Exception {
        MapLayer layer = MapDataManage.loadLayer(aFile);
        layer.setProjInfo(projInfo);
        return layer;
    }

    public static VectorLayer readMapFile_ShapeFile(String aFile) throws IOException, FileNotFoundException, Exception {
        VectorLayer aLayer = ShapeFileManage.loadShapeFile(aFile);
        return aLayer;
    }

    public static VectorLayer readMapFile_ShapeFile(String aFile, String encoding) throws IOException, FileNotFoundException, Exception {
        VectorLayer aLayer = ShapeFileManage.loadShapeFile(aFile, encoding);
        return aLayer;
    }

    public static VectorLayer readMapFile_GrADS(String aFile) throws FileNotFoundException, IOException, Exception {
        DataInputStream br = new DataInputStream(new BufferedInputStream(new FileInputStream(new File(aFile))));
        ArrayList<PointD> pList = new ArrayList<PointD>();
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Polyline);
        String columnName = "Value";
        Field aDC = new Field(columnName, DataType.INT);
        aLayer.editAddField(aDC);
        int lineNum = 0;
        do {
            byte b;
            if ("2".equals(Byte.toString(b = br.readByte()))) {
                br.skipBytes(18);
                continue;
            }
            b = br.readByte();
            short lType = (short)DataConvert.byte2Int(b);
            b = br.readByte();
            int N = DataConvert.byte2Int(b);
            for (int i = 0; i < N; ++i) {
                int bb;
                byte[] bytes = new byte[3];
                br.read(bytes);
                int val = 0;
                for (bb = 0; bb < 3; ++bb) {
                    val <<= 8;
                    val |= bytes[bb] & 0xFF;
                }
                double lon = (double)val / 10000.0;
                bytes = new byte[3];
                br.read(bytes);
                val = 0;
                for (bb = 0; bb < 3; ++bb) {
                    val <<= 8;
                    val |= bytes[bb] & 0xFF;
                }
                double lat = (double)val / 10000.0 - 90.0;
                PointD aPoint = new PointD();
                aPoint.X = lon;
                aPoint.Y = lat;
                pList.add(aPoint);
            }
            if (pList.size() > 1) {
                PolylineShape aPolyline = new PolylineShape();
                aPolyline.setValue(lineNum);
                aPolyline.setPoints(pList);
                aPolyline.setExtent(MIMath.getPointsExtent(pList));
                aPolyline.setPartNum(1);
                aPolyline.parts = new int[1];
                aPolyline.parts[0] = 0;
                int shapeNum = aLayer.getShapeNum();
                if (aLayer.editInsertShape(aPolyline, shapeNum)) {
                    aLayer.editCellValue(columnName, shapeNum, (Object)lineNum);
                }
                ++lineNum;
            }
            pList = new ArrayList();
        } while (br.available() > 0);
        br.close();
        aLayer.setLayerName(new File(aFile).getName());
        aLayer.setFileName(aFile);
        aLayer.setLayerDrawType(LayerDrawType.Map);
        aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Polyline, Color.darkGray, 1.0f));
        aLayer.setVisible(true);
        return aLayer;
    }

    public static ImageLayer readImageFile(String aFile) throws IOException {
        String oEx = aFile.substring(aFile.lastIndexOf("."));
        String last = oEx.substring(oEx.length() - 1);
        String sEx = oEx.substring(0, oEx.length() - 2) + last;
        sEx = sEx + "w";
        String wFile = aFile.replace(oEx, sEx);
        BufferedImage aImage = ImageIO.read(new File(aFile));
        ImageLayer aImageLayer = new ImageLayer();
        aImageLayer.setFileName(aFile);
        aImageLayer.setWorldFileName(wFile);
        aImageLayer.setImage(aImage);
        aImageLayer.setLayerName(new File(aFile).getName());
        aImageLayer.setVisible(true);
        if (new File(wFile).exists()) {
            aImageLayer.readImageWorldFile(wFile);
        } else {
            WorldFilePara aWFP = new WorldFilePara();
            aWFP.xUL = 0.0;
            aWFP.yUL = 90.0;
            aWFP.xScale = 0.05;
            aWFP.yScale = -0.05;
            aWFP.xRotate = 0.0;
            aWFP.yRotate = 0.0;
            aImageLayer.setWorldFilePara(aWFP);
            aImageLayer.writeImageWorldFile(wFile, aImageLayer.getWorldFilePara());
        }
        double XBR = (double)aImageLayer.getImage().getWidth() * aImageLayer.getWorldFilePara().xScale + aImageLayer.getWorldFilePara().xUL;
        double YBR = (double)aImageLayer.getImage().getHeight() * aImageLayer.getWorldFilePara().yScale + aImageLayer.getWorldFilePara().yUL;
        Extent aExtent = new Extent();
        aExtent.minX = aImageLayer.getWorldFilePara().xUL;
        aExtent.minY = YBR;
        aExtent.maxX = XBR;
        aExtent.maxY = aImageLayer.getWorldFilePara().yUL;
        aImageLayer.setExtent(aExtent);
        aImageLayer.setLayerDrawType(LayerDrawType.Image);
        aImageLayer.setMaskout(true);
        return aImageLayer;
    }

    public static RasterLayer readGeoTiffFile(String fileName) {
        try {
            GeoTiff geoTiff = new GeoTiff(fileName);
            geoTiff.read();
            GridArray gData = geoTiff.getGridArray();
            RasterLayer aLayer = DrawMeteoData.createRasterLayer(gData, new File(fileName).getName());
            aLayer.setProjInfo(gData.projInfo);
            aLayer.setFileName(fileName);
            return aLayer;
        }
        catch (IOException ex) {
            Logger.getLogger(MapDataManage.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static RasterLayer readBILFile(String fileName) {
        BILDataInfo dataInfo = new BILDataInfo();
        dataInfo.readDataInfo(fileName);
        Array a = dataInfo.read(dataInfo.getVariableNames().get(0));
        GridArray data = new GridArray();
        data.data = a;
        data.xArray = dataInfo.getXDimension().getValues();
        data.yArray = dataInfo.getYDimension().getValues();
        data.missingValue = dataInfo.getMissingValue();
        LegendScheme aLS = LegendManage.createLegendSchemeFromGridData(data, LegendType.GraduatedColor, ShapeTypes.Image);
        RasterLayer aLayer = DrawMeteoData.createRasterLayer(data, new File(fileName).getName(), aLS);
        aLayer.setFileName(fileName);
        return aLayer;
    }

    public static RasterLayer readESRI_ASCII_GRID(String fileName) {
        ASCIIGridDataInfo dataInfo = new ASCIIGridDataInfo();
        dataInfo.readDataInfo(fileName);
        GridArray gData = dataInfo.getGridArray("var");
        RasterLayer aLayer = DrawMeteoData.createRasterLayer(gData, new File(fileName).getName());
        aLayer.setProjInfo(KnownCoordinateSystems.geographic.world.WGS1984);
        aLayer.setFileName(fileName);
        return aLayer;
    }

    public static RasterLayer readSurfer_ASCII_GRID(String fileName) {
        SurferGridDataInfo dataInfo = new SurferGridDataInfo();
        dataInfo.readDataInfo(fileName);
        GridData gData = dataInfo.getGridData_LonLat(0, 0, 0);
        LegendScheme aLS = LegendManage.createLegendSchemeFromGridData(gData, LegendType.GraduatedColor, ShapeTypes.Image);
        RasterLayer aLayer = DrawMeteoData.createRasterLayer(gData, new File(fileName).getName(), aLS);
        aLayer.setFileName(fileName);
        return aLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VectorLayer readMapFile_WMP(String fileName) throws IOException, Exception {
        BufferedReader sr = null;
        try {
            Object object;
            boolean IsTrue;
            File file = new File(fileName);
            sr = new BufferedReader(new FileReader(file));
            ArrayList<PointD> pList = new ArrayList<PointD>();
            String columnName = "Value";
            VectorLayer aLayer = new VectorLayer(ShapeTypes.Point);
            String shapeType = sr.readLine().trim().toLowerCase();
            int shapeNum = Integer.parseInt(sr.readLine());
            switch (shapeType) {
                case "point": {
                    String aLine;
                    aLayer = new VectorLayer(ShapeTypes.Point);
                    aLayer.editAddField(columnName, DataType.INT);
                    for (int i = 0; i < shapeNum; ++i) {
                        aLine = sr.readLine();
                        String[] dataArray = aLine.split(",");
                        PointD aPoint = new PointD();
                        aPoint.X = Double.parseDouble(dataArray[0]);
                        aPoint.Y = Double.parseDouble(dataArray[1]);
                        pList.add(aPoint);
                        PointShape aPS = new PointShape();
                        aPS.setValue(i);
                        aPS.setPoint(aPoint);
                        int sNum = aLayer.getShapeNum();
                        if (!aLayer.editInsertShape(aPS, sNum)) continue;
                        aLayer.editCellValue(columnName, sNum, (Object)i);
                    }
                    aLayer.setLayerName(file.getName());
                    aLayer.setFileName(fileName);
                    aLayer.setLayerDrawType(LayerDrawType.Map);
                    aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Point, Color.black, 5.0f));
                    aLayer.setVisible(true);
                    IsTrue = true;
                    break;
                }
                case "polyline": {
                    String aLine;
                    aLayer = new VectorLayer(ShapeTypes.Polyline);
                    aLayer.editAddField(columnName, DataType.INT);
                    for (int i = 0; i < shapeNum; ++i) {
                        int pNum = Integer.parseInt(sr.readLine());
                        pList = new ArrayList();
                        for (int j = 0; j < pNum; ++j) {
                            aLine = sr.readLine();
                            String[] dataArray = aLine.split(",");
                            PointD aPoint = new PointD();
                            aPoint.X = Double.parseDouble(dataArray[0]);
                            aPoint.Y = Double.parseDouble(dataArray[1]);
                            pList.add(aPoint);
                        }
                        PolylineShape aPLS = new PolylineShape();
                        aPLS.setValue(i);
                        aPLS.setExtent(MIMath.getPointsExtent(pList));
                        aPLS.setPoints(pList);
                        int sNum = aLayer.getShapeNum();
                        if (!aLayer.editInsertShape(aPLS, sNum)) continue;
                        aLayer.editCellValue(columnName, sNum, (Object)i);
                    }
                    aLayer.setLayerName(file.getName());
                    aLayer.setFileName(fileName);
                    aLayer.setLayerDrawType(LayerDrawType.Map);
                    aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Polyline, Color.darkGray, 1.0f));
                    aLayer.setVisible(true);
                    IsTrue = true;
                    break;
                }
                case "polygon": {
                    String aLine;
                    aLayer = new VectorLayer(ShapeTypes.Polygon);
                    aLayer.editAddField(columnName, DataType.INT);
                    for (int i = 0; i < shapeNum; ++i) {
                        int pNum = Integer.parseInt(sr.readLine());
                        pList = new ArrayList();
                        for (int j = 0; j < pNum; ++j) {
                            aLine = sr.readLine();
                            String[] dataArray = aLine.split(",");
                            PointD aPoint = new PointD();
                            aPoint.X = Double.parseDouble(dataArray[0]);
                            aPoint.Y = Double.parseDouble(dataArray[1]);
                            pList.add(aPoint);
                        }
                        PolygonShape aPGS = new PolygonShape();
                        aPGS.lowValue = i;
                        aPGS.highValue = i;
                        aPGS.setExtent(MIMath.getPointsExtent(pList));
                        aPGS.setPoints(pList);
                        int sNum = aLayer.getShapeNum();
                        if (!aLayer.editInsertShape(aPGS, sNum)) continue;
                        aLayer.editCellValue(columnName, sNum, (Object)i);
                    }
                    aLayer.setLayerName(file.getName());
                    aLayer.setFileName(fileName);
                    aLayer.setLayerDrawType(LayerDrawType.Map);
                    aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Polygon, new Color(255, 251, 195), 1.0f));
                    aLayer.setVisible(true);
                    IsTrue = true;
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(null, "Shape type is invalid!" + System.getProperty("line.separator") + shapeType);
                    IsTrue = false;
                }
            }
            sr.close();
            if (IsTrue) {
                object = aLayer;
                return object;
            }
            object = null;
            return object;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MapDataManage.class.getName()).log(Level.SEVERE, null, ex);
            VectorLayer vectorLayer = null;
            return vectorLayer;
        }
        finally {
            try {
                if (sr != null) {
                    sr.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(MapDataManage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMapFile_WMP(String fileName, List<Shape> shapes) {
        BufferedWriter sw = null;
        try {
            File file = new File(fileName);
            sw = new BufferedWriter(new FileWriter(file));
            int shpNum = shapes.size();
            switch (shapes.get(0).getShapeType()) {
                case Point: {
                    sw.write("Point");
                    sw.newLine();
                    sw.write(String.valueOf(shpNum));
                    sw.newLine();
                    for (int i = 0; i < shpNum; ++i) {
                        PointShape aPS = (PointShape)shapes.get(i);
                        if (!aPS.isSelected()) continue;
                        sw.write(String.valueOf(aPS.getPoint().X) + "," + String.valueOf(aPS.getPoint().Y));
                        sw.newLine();
                    }
                    break;
                }
                case Polyline: 
                case PolylineZ: {
                    PolylineShape aPLS;
                    int i;
                    sw.write("Polyline");
                    sw.newLine();
                    int shapeNum = 0;
                    for (i = 0; i < shpNum; ++i) {
                        aPLS = (PolylineShape)shapes.get(i);
                        shapeNum += aPLS.getPartNum();
                    }
                    sw.write(String.valueOf(shapeNum));
                    sw.newLine();
                    shapeNum = 0;
                    for (i = 0; i < shpNum; ++i) {
                        aPLS = (PolylineShape)shapes.get(i);
                        for (int p = 0; p < aPLS.getPartNum(); ++p) {
                            int pp;
                            PointD[] Pointps;
                            if (p == aPLS.getPartNum() - 1) {
                                Pointps = new PointD[aPLS.getPointNum() - aPLS.parts[p]];
                                for (pp = aPLS.parts[p]; pp < aPLS.getPointNum(); ++pp) {
                                    Pointps[pp - aPLS.parts[p]] = aPLS.getPoints().get(pp);
                                }
                            } else {
                                Pointps = new PointD[aPLS.parts[p + 1] - aPLS.parts[p]];
                                for (pp = aPLS.parts[p]; pp < aPLS.parts[p + 1]; ++pp) {
                                    Pointps[pp - aPLS.parts[p]] = aPLS.getPoints().get(pp);
                                }
                            }
                            sw.write(String.valueOf(Pointps.length));
                            sw.newLine();
                            for (PointD aPoint : Pointps) {
                                sw.write(String.valueOf(aPoint.X) + "," + String.valueOf(aPoint.Y));
                                sw.newLine();
                            }
                            ++shapeNum;
                        }
                    }
                    break;
                }
                case Polygon: {
                    PolygonShape aPGS;
                    int i;
                    sw.write("Polygon");
                    sw.newLine();
                    int shapeNum = 0;
                    for (i = 0; i < shpNum; ++i) {
                        aPGS = (PolygonShape)shapes.get(i);
                        shapeNum += aPGS.getPartNum();
                    }
                    sw.write(String.valueOf(shapeNum));
                    sw.newLine();
                    shapeNum = 0;
                    for (i = 0; i < shpNum; ++i) {
                        aPGS = (PolygonShape)shapes.get(i);
                        for (int p = 0; p < aPGS.getPartNum(); ++p) {
                            int pp;
                            PointD[] Pointps;
                            if (p == aPGS.getPartNum() - 1) {
                                Pointps = new PointD[aPGS.getPointNum() - aPGS.parts[p]];
                                for (pp = aPGS.parts[p]; pp < aPGS.getPointNum(); ++pp) {
                                    Pointps[pp - aPGS.parts[p]] = aPGS.getPoints().get(pp);
                                }
                            } else {
                                Pointps = new PointD[aPGS.parts[p + 1] - aPGS.parts[p]];
                                for (pp = aPGS.parts[p]; pp < aPGS.parts[p + 1]; ++pp) {
                                    Pointps[pp - aPGS.parts[p]] = aPGS.getPoints().get(pp);
                                }
                            }
                            sw.write(String.valueOf(Pointps.length));
                            sw.newLine();
                            for (PointD aPoint : Pointps) {
                                sw.write(String.valueOf(aPoint.X) + "," + String.valueOf(aPoint.Y));
                                sw.newLine();
                            }
                            ++shapeNum;
                        }
                    }
                    break;
                }
            }
            sw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(MapDataManage.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (sw != null) {
                    sw.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(MapDataManage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProjFile(String projFilePath, ProjectionInfo projInfo) {
        BufferedWriter sw = null;
        try {
            String esriString = projInfo.toEsriString();
            sw = new BufferedWriter(new FileWriter(new File(projFilePath)));
            sw.write(esriString);
            sw.flush();
            sw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(ShapeFileManage.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (sw != null) {
                    sw.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ShapeFileManage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

