/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.global.util.DateUtil;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.Dimension;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.info.ProjectionInfo;

public abstract class DataInfo {
    private String _fileName;
    private List<Variable> _variables = new ArrayList<Variable>();
    private List<Dimension> _dimensions = new ArrayList<Dimension>();
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private Dimension _tDim = null;
    private Dimension _xDim = null;
    private Dimension _yDim = null;
    private Dimension _zDim = null;
    private boolean _xReverse = false;
    private boolean _yReverse = false;
    private boolean _isGlobal = false;
    private double _missingValue = -9999.0;
    private ProjectionInfo _projInfo;
    protected MeteoDataType dataType;

    public DataInfo() {
        this._projInfo = KnownCoordinateSystems.geographic.world.WGS1984;
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String name) {
        this._fileName = name;
    }

    public List<Variable> getVariables() {
        return this._variables;
    }

    public void setVariables(List<Variable> value) {
        this._variables = value;
    }

    public List<Variable> getPlottableVariables() {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        for (Variable var : this._variables) {
            if (!var.isPlottable()) continue;
            vars.add(var);
        }
        return vars;
    }

    public List<Dimension> getDimensions() {
        return this._dimensions;
    }

    public void setDimensions(List<Dimension> dims) {
        this._dimensions = dims;
    }

    public int getVariableNum() {
        return this._variables.size();
    }

    public List<String> getVariableNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Variable var : this._variables) {
            names.add(var.getName());
        }
        return names;
    }

    public List<Date> getTimes() {
        List<Double> values = this._tDim.getDimValue();
        ArrayList<Date> times = new ArrayList<Date>();
        for (Double v : values) {
            times.add(DateUtil.fromOADate(v));
        }
        return times;
    }

    public Date getTime(int timeIdx) {
        return DateUtil.fromOADate(this._tDim.getDimValue().get(timeIdx));
    }

    public double getTimeValue(int timeIdx) {
        return this._tDim.getDimValue().get(timeIdx);
    }

    public static int getTimeValue(Date time, Date baseDate, String tDelta) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(baseDate);
        long sl = cal.getTimeInMillis();
        int value = 0;
        cal.setTime(time);
        long el = cal.getTimeInMillis();
        long delta = el - sl;
        switch (tDelta.toLowerCase()) {
            case "seconds": {
                value = (int)(delta / 1000L);
                break;
            }
            case "minutes": {
                value = (int)(delta / 60000L);
                break;
            }
            case "hours": {
                value = (int)(delta / 3600000L);
                break;
            }
            case "days": {
                value = (int)(delta / 86400000L);
            }
        }
        return value;
    }

    public List<Integer> getTimeValues(Date baseDate, String tDelta) {
        List<Date> times = this.getTimes();
        ArrayList<Integer> values = new ArrayList<Integer>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(baseDate);
        long sl = cal.getTimeInMillis();
        for (Date time : times) {
            int value;
            cal.setTime(time);
            long el = cal.getTimeInMillis();
            long delta = el - sl;
            if (tDelta.equalsIgnoreCase("hours")) {
                value = (int)(delta / 3600000L);
                values.add(value);
                continue;
            }
            if (!tDelta.equalsIgnoreCase("days")) continue;
            value = (int)(delta / 86400000L);
            values.add(value);
        }
        return values;
    }

    public void setTimes(List<Date> value) {
        List<Date> times = value;
        ArrayList<Double> values = new ArrayList<Double>();
        for (Date t : times) {
            values.add(DateUtil.toOADate(t));
        }
        this._tDim.setValues(values);
    }

    public int getTimeNum() {
        return this._tDim.getLength();
    }

    public Dimension getTimeDimension() {
        return this._tDim;
    }

    public void setTimeDimension(Dimension tDim) {
        this._tDim = tDim;
    }

    public Dimension getXDimension() {
        return this._xDim;
    }

    public void setXDimension(Dimension xDim) {
        this._xDim = xDim;
    }

    public Dimension getYDimension() {
        return this._yDim;
    }

    public void setYDimension(Dimension yDim) {
        this._yDim = yDim;
    }

    public Dimension getZDimension() {
        return this._zDim;
    }

    public void setZDimension(Dimension zDim) {
        this._zDim = zDim;
    }

    public boolean isXReverse() {
        return this._xReverse;
    }

    public void setXReverse(boolean value) {
        this._xReverse = value;
    }

    public boolean isYReverse() {
        return this._yReverse;
    }

    public void setYReverse(boolean value) {
        this._yReverse = value;
    }

    public boolean isGlobal() {
        return this._isGlobal;
    }

    public void setGlobal(boolean value) {
        this._isGlobal = value;
    }

    public double getMissingValue() {
        return this._missingValue;
    }

    public void setMissingValue(double value) {
        this._missingValue = value;
    }

    public ProjectionInfo getProjectionInfo() {
        return this._projInfo;
    }

    public void setProjectionInfo(ProjectionInfo projInfo) {
        this._projInfo = projInfo;
    }

    public MeteoDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(MeteoDataType value) {
        this.dataType = value;
    }

    public abstract void readDataInfo(String var1);

    public void readDataInfo(String fileName, boolean keepOpen) {
    }

    public String generateInfoText() {
        String dataInfo;
        block7: {
            Dimension dim;
            Attribute aAttS;
            Dimension ydim;
            int i;
            dataInfo = "File Name: " + this.getFileName();
            dataInfo = dataInfo + System.getProperty("line.separator") + "Dimensions: " + this._dimensions.size();
            for (i = 0; i < this._dimensions.size(); ++i) {
                dataInfo = dataInfo + System.getProperty("line.separator") + "\t" + this._dimensions.get(i).getShortName() + " = " + String.valueOf(this._dimensions.get(i).getLength()) + ";";
            }
            Dimension xdim = this.getXDimension();
            if (xdim != null) {
                dataInfo = dataInfo + System.getProperty("line.separator") + "X Dimension: Xmin = " + String.valueOf(xdim.getMinValue()) + "; Xmax = " + String.valueOf(xdim.getMaxValue()) + "; Xsize = " + String.valueOf(xdim.getLength()) + "; Xdelta = " + String.valueOf(xdim.getDeltaValue());
            }
            if ((ydim = this.getYDimension()) != null) {
                dataInfo = dataInfo + System.getProperty("line.separator") + "Y Dimension: Ymin = " + String.valueOf(ydim.getMinValue()) + "; Ymax = " + String.valueOf(ydim.getMaxValue()) + "; Ysize = " + String.valueOf(ydim.getLength()) + "; Ydelta = " + String.valueOf(ydim.getDeltaValue());
            }
            dataInfo = dataInfo + System.getProperty("line.separator") + "Global Attributes: ";
            for (i = 0; i < this.attributes.size(); ++i) {
                aAttS = this.attributes.get(i);
                dataInfo = dataInfo + System.getProperty("line.separator") + "\t: " + aAttS.toString();
            }
            dataInfo = dataInfo + System.getProperty("line.separator") + "Variations: " + this._variables.size();
            for (i = 0; i < this._variables.size(); ++i) {
                int j;
                dataInfo = dataInfo + System.getProperty("line.separator") + "\t" + this._variables.get(i).getDataType().toString() + " " + this._variables.get(i).getShortName() + "(";
                List<Dimension> dims = this._variables.get(i).getDimensions();
                for (j = 0; j < dims.size(); ++j) {
                    dataInfo = dataInfo + dims.get(j).getShortName() + ",";
                }
                dataInfo = dataInfo.substring(0, dataInfo.length() - 1);
                dataInfo = dataInfo + ");";
                List<Attribute> atts = this._variables.get(i).getAttributes();
                for (j = 0; j < atts.size(); ++j) {
                    aAttS = atts.get(j);
                    dataInfo = dataInfo + System.getProperty("line.separator") + "\t\t" + this._variables.get(i).getShortName() + ": " + aAttS.toString();
                }
            }
            Iterator<Dimension> iterator = this._dimensions.iterator();
            if (!iterator.hasNext() || !(dim = iterator.next()).isUnlimited()) break block7;
            dataInfo = dataInfo + System.getProperty("line.separator") + "Unlimited dimension: " + dim.getShortName();
        }
        return dataInfo;
    }

    public abstract Array read(String var1);

    public abstract Array read(String var1, int[] var2, int[] var3, int[] var4);

    public abstract List<Attribute> getGlobalAttributes();

    public Variable getVariable(String varName) {
        for (Variable var : this._variables) {
            if (!var.getName().equalsIgnoreCase(varName)) continue;
            return var;
        }
        return null;
    }

    public void addVariable(Variable var) {
        this._variables.add(var);
    }

    public void addDimension(Dimension dim) {
        this._dimensions.add(dim);
    }

    public void addAttribute(Attribute attr) {
        this.attributes.add(attr);
    }
}

