/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.ascii;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IStationDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.StationInfoData;
import org.meteoinfo.data.meteodata.StationModelData;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.util.GlobalUtil;
import org.meteoinfo.io.FileCharsetDetector;
import org.meteoinfo.ndarray.Array;

public class LonLatStationDataInfo
extends DataInfo
implements IStationDataInfo {
    private List<String> _fields = new ArrayList<String>();
    private String delimiter = null;

    public LonLatStationDataInfo() {
        this.setDataType(MeteoDataType.LonLatStation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readDataInfo(String fileName) {
        BufferedReader sr = null;
        try {
            this.setFileName(fileName);
            FileCharsetDetector chardet = new FileCharsetDetector();
            String charset = chardet.guestFileEncoding(this.getFileName());
            sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), charset));
            String aLine = sr.readLine().trim();
            this.delimiter = GlobalUtil.getDelimiter(aLine);
            String[] fieldArray = GlobalUtil.split(aLine, this.delimiter);
            if (fieldArray.length < 4) {
                JOptionPane.showMessageDialog(null, "The data should have at least four fields!");
                return;
            }
            this._fields = Arrays.asList(fieldArray);
            aLine = sr.readLine();
            String[] dataArray = GlobalUtil.split(aLine, this.delimiter);
            ArrayList<Variable> variables = new ArrayList<Variable>();
            for (int i = 3; i < dataArray.length; ++i) {
                if (!MIMath.isNumeric(dataArray[i])) continue;
                Variable var = new Variable();
                var.setName(fieldArray[i]);
                var.setStation(true);
                variables.add(var);
            }
            this.setVariables(variables);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(LonLatStationDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(LonLatStationDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                sr.close();
            }
            catch (IOException ex) {
                Logger.getLogger(LonLatStationDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public String generateInfoText() {
        String dataInfo = "File Name: " + this.getFileName();
        dataInfo = dataInfo + System.getProperty("line.separator") + "Fields: ";
        for (String aField : this._fields) {
            dataInfo = dataInfo + System.getProperty("line.separator") + "  " + aField;
        }
        return dataInfo;
    }

    @Override
    public Array read(String varName) {
        return null;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        return null;
    }

    @Override
    public StationData getStationData(int timeIdx, int varIdx, int levelIdx) {
        try {
            ArrayList<String[]> dataList = new ArrayList<String[]>();
            FileCharsetDetector chardet = new FileCharsetDetector();
            String charset = chardet.guestFileEncoding(this.getFileName());
            BufferedReader sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getFileName()), charset));
            sr.readLine();
            String line = sr.readLine();
            while (line != null) {
                if (line.isEmpty()) {
                    line = sr.readLine();
                    continue;
                }
                line = line.trim();
                dataList.add(GlobalUtil.split(line, this.delimiter));
                line = sr.readLine();
            }
            sr.close();
            StationData stationData = new StationData();
            ArrayList<String> stations = new ArrayList<String>();
            double[][] discreteData = new double[dataList.size()][3];
            double minX = 0.0;
            double maxX = 0.0;
            double minY = 0.0;
            double maxY = 0.0;
            int vIdx = this._fields.indexOf(this.getVariables().get(varIdx).getName());
            for (int i = 0; i < dataList.size(); ++i) {
                String[] dataArray = (String[])dataList.get(i);
                String stName = dataArray[0];
                double lon = Double.parseDouble(dataArray[1]);
                double lat = Double.parseDouble(dataArray[2]);
                double t = dataArray.length <= vIdx ? stationData.missingValue : (dataArray[vIdx].isEmpty() ? stationData.missingValue : Double.parseDouble(dataArray[vIdx]));
                discreteData[i][0] = lon;
                discreteData[i][1] = lat;
                discreteData[i][2] = t;
                stations.add(stName);
                if (i == 0) {
                    maxX = minX = lon;
                    maxY = minY = lat;
                    continue;
                }
                if (minX > lon) {
                    minX = lon;
                } else if (maxX < lon) {
                    maxX = lon;
                }
                if (minY > lat) {
                    minY = lat;
                    continue;
                }
                if (!(maxY < lat)) continue;
                maxY = lat;
            }
            Extent dataExtent = new Extent();
            dataExtent.minX = minX;
            dataExtent.maxX = maxX;
            dataExtent.minY = minY;
            dataExtent.maxY = maxY;
            stationData.data = discreteData;
            stationData.dataExtent = dataExtent;
            stationData.stations = stations;
            return stationData;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(LonLatStationDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(LonLatStationDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StationInfoData getStationInfoData(int timeIdx, int levelIdx) {
        BufferedReader sr = null;
        try {
            FileCharsetDetector chardet = new FileCharsetDetector();
            String charset = chardet.guestFileEncoding(this.getFileName());
            sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getFileName()), charset));
            ArrayList<List<String>> dataList = new ArrayList<List<String>>();
            sr.readLine();
            String line = sr.readLine();
            while (line != null) {
                if (line.isEmpty()) {
                    line = sr.readLine();
                    continue;
                }
                line = line.trim();
                List<String> aList = Arrays.asList(GlobalUtil.split(line, this.delimiter));
                dataList.add(aList);
                line = sr.readLine();
            }
            sr.close();
            StationInfoData stInfoData = new StationInfoData();
            stInfoData.setDataList(dataList);
            stInfoData.setFields(this._fields);
            stInfoData.setVariables(this.getVariableNames());
            StationInfoData stationInfoData = stInfoData;
            return stationInfoData;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(LonLatStationDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(LonLatStationDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                sr.close();
            }
            catch (IOException ex) {
                Logger.getLogger(LonLatStationDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    @Override
    public StationModelData getStationModelData(int timeIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public StationData getNullStationData() throws FileNotFoundException, UnsupportedEncodingException, IOException {
        BufferedReader sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getFileName()), "utf-8"));
        ArrayList<String[]> dataList = new ArrayList<String[]>();
        sr.readLine();
        String line = sr.readLine();
        while (line != null) {
            if (line.isEmpty()) {
                line = sr.readLine();
                continue;
            }
            dataList.add(line.split(","));
            line = sr.readLine();
        }
        sr.close();
        StationData stationData = new StationData();
        ArrayList<String> stations = new ArrayList<String>();
        double t = 0.0;
        double[][] discreteData = new double[dataList.size()][3];
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        for (int i = 0; i < dataList.size(); ++i) {
            String[] dataArray = (String[])dataList.get(i);
            String stName = dataArray[0];
            double lon = Double.parseDouble(dataArray[1]);
            double lat = Double.parseDouble(dataArray[2]);
            t = stationData.missingValue;
            discreteData[i][0] = lon;
            discreteData[i][1] = lat;
            discreteData[i][2] = t;
            stations.add(stName);
            if (i == 0) {
                maxX = minX = lon;
                maxY = minY = lat;
                continue;
            }
            if (minX > lon) {
                minX = lon;
            } else if (maxX < lon) {
                maxX = lon;
            }
            if (minY > lat) {
                minY = lat;
                continue;
            }
            if (!(maxY < lat)) continue;
            maxY = lat;
        }
        Extent dataExtent = new Extent();
        dataExtent.minX = minX;
        dataExtent.maxX = maxX;
        dataExtent.minY = minY;
        dataExtent.maxY = maxY;
        stationData.data = discreteData;
        stationData.dataExtent = dataExtent;
        stationData.stations = stations;
        return stationData;
    }
}

