/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.drawing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.meteoinfo.chart.plot.XAlign;
import org.meteoinfo.chart.plot.YAlign;
import org.meteoinfo.drawing.StringType;
import org.meteoinfo.geoprocess.Spline;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointD;
import org.meteoinfo.global.PointF;
import org.meteoinfo.global.colors.ColorUtil;
import org.meteoinfo.legend.ArrowBreak;
import org.meteoinfo.legend.ArrowLineBreak;
import org.meteoinfo.legend.BreakTypes;
import org.meteoinfo.legend.ChartBreak;
import org.meteoinfo.legend.ColorBreakCollection;
import org.meteoinfo.legend.HatchStyle;
import org.meteoinfo.legend.LabelBreak;
import org.meteoinfo.legend.LineStyles;
import org.meteoinfo.legend.MarkerType;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.legend.PointStyle;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.legend.PolylineBreak;
import org.meteoinfo.shape.EllipseShape;
import org.meteoinfo.shape.Graphic;
import org.meteoinfo.shape.Polygon;
import org.meteoinfo.shape.PolygonShape;
import org.meteoinfo.shape.Polyline;
import org.meteoinfo.shape.StationModelShape;
import org.meteoinfo.shape.WindArrow;
import org.meteoinfo.shape.WindBarb;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

public class Draw {
    public static StringType getStringType(String str) {
        if (str.length() < 2 || !str.contains("$")) {
            return StringType.NORMAL;
        }
        if (str.contains("$")) {
            int n1;
            int n = str.length() - str.replace("$", "").length();
            int n2 = n - (n1 = str.length() - str.replace("\\$", "").length());
            if (n2 < 2) {
                return StringType.NORMAL;
            }
            if (n2 == 2) {
                if (str.startsWith("$") && str.endsWith("$") && !str.endsWith("\\$")) {
                    return StringType.LATEX;
                }
                return StringType.MIXING;
            }
            return StringType.MIXING;
        }
        return StringType.NORMAL;
    }

    public static List<String> splitMixingString(String str) {
        ArrayList<String> strs = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (c == '$') {
                if (sb.length() == 0) {
                    sb.append(c);
                    continue;
                }
                if (sb.substring(sb.length() - 1).equals("\\")) {
                    sb.append(c);
                    continue;
                }
                if (sb.substring(0, 1).equals("$")) {
                    sb.append(c);
                    strs.add(sb.toString());
                    sb = new StringBuilder();
                    continue;
                }
                strs.add(sb.toString());
                sb = new StringBuilder();
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            strs.add(sb.toString());
        }
        return strs;
    }

    public static Dimension getStringDimension(String str, Graphics2D g, boolean isLaTeX) {
        if (isLaTeX) {
            float size = g.getFont().getSize2D();
            TeXFormula formula = new TeXFormula(str);
            TeXIcon icon = formula.createTeXIcon(2, size);
            int width = (int)icon.getTrueIconWidth() + 10;
            int height = (int)icon.getTrueIconHeight();
            return new Dimension(width, height);
        }
        FontMetrics metrics = g.getFontMetrics();
        int height = metrics.getAscent();
        return new Dimension(metrics.stringWidth(str), height);
    }

    public static Dimension getStringDimension(String str, float angle, Graphics2D g, boolean isLaTeX) {
        float height;
        float width;
        if (isLaTeX) {
            float size = g.getFont().getSize2D();
            TeXFormula formula = new TeXFormula(str);
            TeXIcon icon = formula.createTeXIcon(2, size);
            width = (int)icon.getTrueIconWidth() + 10;
            height = (int)icon.getTrueIconHeight();
        } else {
            FontMetrics metrics = g.getFontMetrics();
            width = metrics.stringWidth(str);
            height = metrics.getAscent();
        }
        if (angle == 90.0f || angle == -90.0f) {
            float temp = width;
            width = height;
            height = temp;
        } else {
            width = (float)((double)width * Math.cos(Math.toRadians(angle))) + (float)((double)height * Math.sin(Math.toRadians(angle)));
            height = (float)((double)width * Math.sin(Math.toRadians(angle))) + (float)((double)height * Math.cos(Math.toRadians(angle)));
        }
        return new Dimension((int)width, (int)height);
    }

    public static Dimension getStringDimension(String str, Graphics2D g) {
        Dimension dim;
        AffineTransform at = g.getTransform();
        if (at.getShearX() != 0.0 || at.getShearY() != 0.0) {
            g.setTransform(new AffineTransform());
        }
        switch (Draw.getStringType(str)) {
            case LATEX: {
                dim = Draw.getStringDimension(str, g, true);
                break;
            }
            case MIXING: {
                List<String> strs = Draw.splitMixingString(str);
                dim = new Dimension(0, 0);
                Iterator<String> iterator = strs.iterator();
                while (iterator.hasNext()) {
                    String s;
                    Dimension dim1 = Draw.getStringDimension(s, g, (s = iterator.next()).startsWith("$") && s.endsWith("$"));
                    dim.setSize(dim.getWidth() + dim1.getWidth(), Math.max(dim.getHeight(), dim1.getHeight()));
                }
                break;
            }
            default: {
                dim = Draw.getStringDimension(str, g, false);
            }
        }
        if (at.getShearX() != 0.0 || at.getShearY() != 0.0) {
            g.setTransform(at);
        }
        return dim;
    }

    public static Dimension getStringDimension(String str, float angle, Graphics2D g) {
        if (angle == 0.0f) {
            return Draw.getStringDimension(str, g);
        }
        switch (Draw.getStringType(str)) {
            case LATEX: {
                return Draw.getStringDimension(str, angle, g, true);
            }
            case MIXING: {
                List<String> strs = Draw.splitMixingString(str);
                Dimension dim = new Dimension(0, 0);
                Iterator<String> iterator = strs.iterator();
                while (iterator.hasNext()) {
                    String s;
                    Dimension dim1 = Draw.getStringDimension(s, angle, g, (s = iterator.next()).startsWith("$") && s.endsWith("$"));
                    dim.setSize(dim.getWidth() + dim1.getWidth(), Math.max(dim.getHeight(), dim1.getHeight()));
                }
                return dim;
            }
        }
        return Draw.getStringDimension(str, angle, g, false);
    }

    public static void drawString(Graphics2D g, String str, float x, float y) {
        Draw.drawString(g, str, x, y, true);
    }

    public static void drawString(Graphics2D g, String str, double x, double y) {
        Draw.drawString(g, str, x, y, true);
    }

    public static void drawString(Graphics2D g, String str, float x, float y, boolean useExternalFont) {
        switch (Draw.getStringType(str)) {
            case LATEX: {
                Draw.drawLaTeX(g, str, x, y, useExternalFont);
                break;
            }
            case MIXING: {
                List<String> strs = Draw.splitMixingString(str);
                for (String s : strs) {
                    Dimension dim;
                    if (s.startsWith("$") && s.endsWith("$")) {
                        Draw.drawLaTeX(g, s, x, y, useExternalFont);
                        dim = Draw.getStringDimension(s, g, true);
                        x += (float)dim.width;
                        continue;
                    }
                    dim = Draw.getStringDimension(s, g, false);
                    g.drawString(s, x, y - (float)(dim.getHeight() * 0.2));
                    x += (float)(dim.width - 5);
                }
                break;
            }
            default: {
                FontMetrics fm = g.getFontMetrics();
                g.drawString(str, x, y - (float)fm.getDescent());
            }
        }
    }

    public static void drawString(Graphics2D g, String str, double x, double y, boolean useExternalFont) {
        switch (Draw.getStringType(str)) {
            case LATEX: {
                Draw.drawLaTeX(g, str, (float)x, (float)y, useExternalFont);
                break;
            }
            case MIXING: {
                List<String> strs = Draw.splitMixingString(str);
                for (String s : strs) {
                    Dimension dim;
                    if (s.startsWith("$") && s.endsWith("$")) {
                        Draw.drawLaTeX(g, s, (float)x, (float)y, useExternalFont);
                        dim = Draw.getStringDimension(s, g, true);
                        x += (double)dim.width;
                        continue;
                    }
                    dim = Draw.getStringDimension(s, g, false);
                    g.drawString(s, (float)x, (float)(y - dim.getHeight() * 0.2));
                    x += (double)(dim.width - 5);
                }
                break;
            }
            default: {
                FontMetrics fm = g.getFontMetrics();
                g.drawString(str, (float)x, (float)(y - (double)fm.getDescent()));
            }
        }
    }

    public static void drawLaTeX(Graphics2D g, String str, float x, float y, boolean useExternalFont) {
        float size = g.getFont().getSize2D();
        Draw.drawLaTeX(g, str, size, x, y, useExternalFont);
    }

    public static void drawLaTeX(Graphics2D g, String str, float size, float x, float y, boolean useExternalFont) {
        if (useExternalFont) {
            TeXFormula.registerExternalFont((Character.UnicodeBlock)Character.UnicodeBlock.BASIC_LATIN, (String)g.getFont().getName());
        } else {
            TeXFormula.registerExternalFont((Character.UnicodeBlock)Character.UnicodeBlock.BASIC_LATIN, null, null);
        }
        TeXFormula formula = new TeXFormula(str);
        TeXIcon icon = formula.createTeXIcon(2, size);
        icon.setInsets(new Insets(5, 5, 5, 5));
        icon.setForeground(g.getColor());
        y = y - (float)icon.getIconHeight() + ((float)icon.getIconHeight() - icon.getTrueIconHeight()) * 0.6f;
        Font font = g.getFont();
        icon.paintIcon(null, (Graphics)g, (int)x, (int)y);
        g.setFont(font);
    }

    public static WindBarb calWindBarb(float windDir, float windSpeed, double value, float size, PointD sPoint) {
        WindBarb aWB = new WindBarb();
        aWB.windSpeed = windSpeed += 1.0f;
        aWB.angle = windDir;
        aWB.setValue(value);
        aWB.size = size;
        aWB.setPoint(sPoint);
        aWB.windSpeesLine.W20 = (int)(windSpeed / 20.0f);
        aWB.windSpeesLine.W4 = (int)((windSpeed - (float)(aWB.windSpeesLine.W20 * 20)) / 4.0f);
        aWB.windSpeesLine.W2 = (int)((windSpeed - (float)(aWB.windSpeesLine.W20 * 20) - (float)(aWB.windSpeesLine.W4 * 4)) / 2.0f);
        return aWB;
    }

    public static StationModelShape calStationModel(float windDir, float windSpeed, double value, float size, PointD sPoint, int weather, int temp, int dewPoint, int pressure, int cloudCover) {
        StationModelShape aSM = new StationModelShape();
        aSM.setPoint(sPoint);
        aSM.setValue(value);
        aSM.size = size;
        aSM.temperature = temp;
        aSM.dewPoint = dewPoint;
        aSM.pressure = pressure;
        aSM.windBarb = Draw.calWindBarb(windDir, windSpeed, value, size, sPoint);
        aSM.weatherSymbol.size = size / 4.0f * 3.0f;
        PointD aPoint = new PointD(sPoint.X - (double)(size / 2.0f), sPoint.Y);
        aSM.weatherSymbol.setPoint(aPoint);
        aSM.weatherSymbol.weather = weather;
        aSM.cloudCoverage.cloudCover = cloudCover;
        aSM.cloudCoverage.size = size / 4.0f * 3.0f;
        aSM.cloudCoverage.sPoint = aPoint;
        return aSM;
    }

    public static Rectangle2D getArrawBorder(PointF sP, WindArrow aArraw, Graphics2D g, double zoom) {
        PointF eP = new PointF(0.0f, 0.0f);
        double len = aArraw.length;
        double angle = aArraw.angle + 180.0;
        if (angle >= 360.0) {
            angle -= 360.0;
        }
        eP.X = (int)((double)sP.X + (len *= zoom) * Math.sin(angle * Math.PI / 180.0));
        eP.Y = (int)((double)sP.Y - len * Math.cos(angle * Math.PI / 180.0));
        if (angle == 90.0) {
            eP.Y = sP.Y;
        }
        return new Rectangle2D.Double(Math.min(sP.X, eP.X), Math.min(sP.Y, eP.Y), Math.abs(eP.X - sP.X), Math.abs(eP.Y - sP.Y));
    }

    public static void drawArrow(PointF[] points, PointBreak pb, int arrowSize, Graphics2D g) {
        g.setColor(pb.getColor());
        g.setStroke(new BasicStroke(pb.getOutlineSize()));
        Draw.drawPolyline(points, g);
        int n = points.length;
        PointF aPoint = points[n - 2];
        PointF bPoint = points[n - 1];
        double U = bPoint.X - aPoint.X;
        double V = bPoint.Y - aPoint.Y;
        double angle = Math.atan(V / U) * 180.0 / Math.PI;
        angle += 90.0;
        if (U < 0.0) {
            angle += 180.0;
        }
        if (angle >= 360.0) {
            angle -= 360.0;
        }
        Draw.drawArraw(g, bPoint, angle, arrowSize);
    }

    public static Rectangle2D drawArraw(Color aColor, PointF sP, WindArrow aArraw, Graphics2D g, double zoom) {
        PointF eP = new PointF(0.0f, 0.0f);
        double len = aArraw.length;
        double angle = aArraw.angle + 180.0;
        if (angle >= 360.0) {
            angle -= 360.0;
        }
        eP.X = (int)((double)sP.X + (len *= zoom) * Math.sin(angle * Math.PI / 180.0));
        eP.Y = (int)((double)sP.Y - len * Math.cos(angle * Math.PI / 180.0));
        if (angle == 90.0) {
            eP.Y = sP.Y;
        }
        g.setColor(aColor);
        g.draw(new Line2D.Float(sP.X, sP.Y, eP.X, eP.Y));
        Draw.drawArraw(g, eP, angle);
        return new Rectangle2D.Double(Math.min(sP.X, eP.X), Math.min(sP.Y, eP.Y), Math.abs(eP.X - sP.X), Math.abs(eP.Y - sP.Y));
    }

    public static Rectangle2D drawArraw(PointF sP, WindArrow aArraw, ArrowBreak pb, Graphics2D g, double zoom) {
        PointF eP = new PointF(0.0f, 0.0f);
        double len = aArraw.length;
        double angle = aArraw.angle + 180.0;
        if (angle >= 360.0) {
            angle -= 360.0;
        }
        eP.X = (int)((double)sP.X + (len *= zoom) * Math.sin(angle * Math.PI / 180.0));
        eP.Y = (int)((double)sP.Y - len * Math.cos(angle * Math.PI / 180.0));
        if (angle == 90.0) {
            eP.Y = sP.Y;
        }
        g.setColor(pb.getColor());
        float width = pb.getWidth();
        g.setStroke(new BasicStroke(width));
        g.draw(new Line2D.Float(sP.X, sP.Y, eP.X, eP.Y));
        float headWidth = pb.getHeadWidth();
        float headLength = pb.getHeadLength();
        Draw.drawArraw(g, eP, angle, headLength, headWidth, pb.getOverhang());
        return new Rectangle2D.Double(Math.min(sP.X, eP.X), Math.min(sP.Y, eP.Y), Math.abs(eP.X - sP.X), Math.abs(eP.Y - sP.Y));
    }

    public static void drawArraw(Graphics2D g, PointF sP, double angle) {
        PointF[] pt;
        GeneralPath path = new GeneralPath(0, 5);
        Rectangle2D.Float rect = new Rectangle2D.Float(-4.0f, -4.0f, 8.0f, 8.0f);
        pt = new PointF[]{new PointF(rect.x, rect.y), new PointF(rect.x + rect.width, rect.y + rect.height / 2.0f), new PointF(rect.x, rect.y + rect.height), new PointF(rect.x + rect.width / 2.0f, pt[1].Y), pt[0]};
        path.moveTo(pt[0].X, pt[0].Y);
        for (int i = 1; i < 5; ++i) {
            path.lineTo(pt[i].X, pt[i].Y);
        }
        AffineTransform tempTrans = g.getTransform();
        if (angle != 0.0) {
            AffineTransform myTrans = (AffineTransform)tempTrans.clone();
            myTrans.translate(sP.X, sP.Y);
            double angle1 = angle - 90.0;
            myTrans.rotate(angle1 * Math.PI / 180.0);
            g.setTransform(myTrans);
        }
        path.closePath();
        g.fill(path);
        if (angle != 0.0) {
            g.setTransform(tempTrans);
        }
    }

    public static void drawArraw(Graphics2D g, PointF sP, double angle, int size) {
        PointF[] pt;
        GeneralPath path = new GeneralPath(0, 5);
        Rectangle2D.Float rect = new Rectangle2D.Float(-size, -size, size * 2, size * 2);
        pt = new PointF[]{new PointF(rect.x, rect.y), new PointF(rect.x + rect.width, rect.y + rect.height / 2.0f), new PointF(rect.x, rect.y + rect.height), new PointF(rect.x + rect.width / 2.0f, pt[1].Y), pt[0]};
        path.moveTo(pt[0].X, pt[0].Y);
        for (int i = 1; i < 5; ++i) {
            path.lineTo(pt[i].X, pt[i].Y);
        }
        AffineTransform tempTrans = g.getTransform();
        if (angle != 0.0) {
            AffineTransform myTrans = (AffineTransform)tempTrans.clone();
            myTrans.translate(sP.X, sP.Y);
            double angle1 = angle - 90.0;
            myTrans.rotate(angle1 * Math.PI / 180.0);
            g.setTransform(myTrans);
        }
        path.closePath();
        g.fill(path);
        if (angle != 0.0) {
            g.setTransform(tempTrans);
        }
    }

    public static void drawArraw(Graphics2D g, PointF sP, double angle, float length, float width, float overhang) {
        PointF[] pt;
        float x = -length;
        float y = -width * 0.5f;
        pt = overhang == 1.0f ? new PointF[]{new PointF(x, y), new PointF(x + length, y + width / 2.0f), new PointF(x, y + width)} : new PointF[]{new PointF(x += length * (1.0f - overhang), y), new PointF(x + length, y + width / 2.0f), new PointF(x, y + width), new PointF(x + length * overhang, pt[1].Y), pt[0]};
        GeneralPath path = new GeneralPath(0, pt.length);
        path.moveTo(pt[0].X, pt[0].Y);
        for (int i = 1; i < pt.length; ++i) {
            path.lineTo(pt[i].X, pt[i].Y);
        }
        AffineTransform tempTrans = g.getTransform();
        AffineTransform myTrans = (AffineTransform)tempTrans.clone();
        myTrans.translate(sP.X, sP.Y);
        double angle1 = angle - 90.0;
        if (angle1 != 0.0) {
            myTrans.rotate(angle1 * Math.PI / 180.0);
        }
        g.setTransform(myTrans);
        if (overhang == 1.0f) {
            g.draw(path);
        } else {
            path.closePath();
            g.fill(path);
        }
        g.setTransform(tempTrans);
    }

    public static void drawArraw(Graphics2D g, PointF sP, double angle, float length, float width, float overhang, Color fillColor, Color outlineColor) {
        PointF[] pt;
        float x = -length;
        float y = -width * 0.5f;
        pt = overhang == 1.0f ? new PointF[]{new PointF(x, y), new PointF(x + length, 0.0f), new PointF(x, y + width)} : new PointF[]{new PointF(x, y), new PointF(x + length, 0.0f), new PointF(x, y + width), new PointF(x + length * overhang, pt[1].Y), pt[0]};
        GeneralPath path = new GeneralPath(0, pt.length);
        path.moveTo(pt[0].X, pt[0].Y);
        for (int i = 1; i < pt.length; ++i) {
            path.lineTo(pt[i].X, pt[i].Y);
        }
        AffineTransform tempTrans = g.getTransform();
        AffineTransform myTrans = (AffineTransform)tempTrans.clone();
        myTrans.translate(sP.X, sP.Y);
        double angle1 = angle - 90.0;
        if (angle1 != 0.0) {
            myTrans.rotate(angle1 * Math.PI / 180.0);
        }
        g.setTransform(myTrans);
        if (overhang == 1.0f) {
            g.setColor(fillColor);
            g.draw(path);
        } else {
            if (fillColor != null) {
                path.closePath();
                g.setColor(fillColor);
                g.fill(path);
            }
            if (outlineColor != null) {
                g.setColor(outlineColor);
                g.draw(path);
            }
        }
        g.setTransform(tempTrans);
    }

    public static void drawWindBarb(Color aColor, PointF sP, WindBarb aWB, Graphics2D g, float size) {
        PointF eP1;
        int i;
        double len;
        double aLen = len = (double)(size * 2.0f);
        PointF eP = new PointF();
        eP.X = (float)((double)sP.X + len * Math.sin(aWB.angle * Math.PI / 180.0));
        eP.Y = (float)((double)sP.Y - len * Math.cos(aWB.angle * Math.PI / 180.0));
        g.setColor(aColor);
        g.draw(new Line2D.Float(sP.X, sP.Y, eP.X, eP.Y));
        len /= 2.0;
        if (aWB.windSpeesLine.W20 > 0) {
            for (i = 0; i < aWB.windSpeesLine.W20; ++i) {
                eP1 = new PointF();
                eP1.X = (float)((double)eP.X - len * Math.sin((aWB.angle - 105.0) * Math.PI / 180.0));
                eP1.Y = (float)((double)eP.Y + len * Math.cos((aWB.angle - 105.0) * Math.PI / 180.0));
                g.draw(new Line2D.Float(eP.X, eP.Y, eP1.X, eP1.Y));
                eP.X = (float)((double)eP.X - aLen / 8.0 * Math.sin(aWB.angle * Math.PI / 180.0));
                eP.Y = (float)((double)eP.Y + aLen / 8.0 * Math.cos(aWB.angle * Math.PI / 180.0));
                g.draw(new Line2D.Float(eP.X, eP.Y, eP1.X, eP1.Y));
            }
            eP.X = (float)((double)eP.X - aLen / 8.0 * Math.sin(aWB.angle * Math.PI / 180.0));
            eP.Y = (float)((double)eP.Y + aLen / 8.0 * Math.cos(aWB.angle * Math.PI / 180.0));
        }
        if (aWB.windSpeesLine.W4 > 0) {
            for (i = 0; i < aWB.windSpeesLine.W4; ++i) {
                eP1 = new PointF();
                eP1.X = (float)((double)eP.X - len * Math.sin((aWB.angle - 120.0) * Math.PI / 180.0));
                eP1.Y = (float)((double)eP.Y + len * Math.cos((aWB.angle - 120.0) * Math.PI / 180.0));
                g.draw(new Line2D.Float(eP.X, eP.Y, eP1.X, eP1.Y));
                eP.X = (float)((double)eP.X - aLen / 8.0 * Math.sin(aWB.angle * Math.PI / 180.0));
                eP.Y = (float)((double)eP.Y + aLen / 8.0 * Math.cos(aWB.angle * Math.PI / 180.0));
            }
        }
        if (aWB.windSpeesLine.W2 > 0) {
            eP1 = new PointF();
            eP1.X = (float)((double)eP.X - (len /= 2.0) * Math.sin((aWB.angle - 120.0) * Math.PI / 180.0));
            eP1.Y = (float)((double)eP.Y + len * Math.cos((aWB.angle - 120.0) * Math.PI / 180.0));
            g.draw(new Line2D.Float(eP.X, eP.Y, eP1.X, eP1.Y));
        }
    }

    public static void drawWindBarb(PointF sP, WindBarb aWB, PointBreak pb, Graphics2D g) {
        PointF eP1;
        int i;
        double len;
        double aLen = len = (double)(pb.getSize() * 2.0f);
        PointF eP = new PointF();
        eP.X = (float)((double)sP.X + len * Math.sin(aWB.angle * Math.PI / 180.0));
        eP.Y = (float)((double)sP.Y - len * Math.cos(aWB.angle * Math.PI / 180.0));
        g.setColor(pb.getColor());
        g.setStroke(new BasicStroke(pb.getOutlineSize()));
        g.draw(new Line2D.Float(sP.X, sP.Y, eP.X, eP.Y));
        len /= 2.0;
        if (aWB.windSpeesLine.W20 > 0) {
            for (i = 0; i < aWB.windSpeesLine.W20; ++i) {
                eP1 = new PointF();
                eP1.X = (float)((double)eP.X - len * Math.sin((aWB.angle - 105.0) * Math.PI / 180.0));
                eP1.Y = (float)((double)eP.Y + len * Math.cos((aWB.angle - 105.0) * Math.PI / 180.0));
                g.draw(new Line2D.Float(eP.X, eP.Y, eP1.X, eP1.Y));
                eP.X = (float)((double)eP.X - aLen / 8.0 * Math.sin(aWB.angle * Math.PI / 180.0));
                eP.Y = (float)((double)eP.Y + aLen / 8.0 * Math.cos(aWB.angle * Math.PI / 180.0));
                g.draw(new Line2D.Float(eP.X, eP.Y, eP1.X, eP1.Y));
            }
            eP.X = (float)((double)eP.X - aLen / 8.0 * Math.sin(aWB.angle * Math.PI / 180.0));
            eP.Y = (float)((double)eP.Y + aLen / 8.0 * Math.cos(aWB.angle * Math.PI / 180.0));
        }
        if (aWB.windSpeesLine.W4 > 0) {
            for (i = 0; i < aWB.windSpeesLine.W4; ++i) {
                eP1 = new PointF();
                eP1.X = (float)((double)eP.X - len * Math.sin((aWB.angle - 120.0) * Math.PI / 180.0));
                eP1.Y = (float)((double)eP.Y + len * Math.cos((aWB.angle - 120.0) * Math.PI / 180.0));
                g.draw(new Line2D.Float(eP.X, eP.Y, eP1.X, eP1.Y));
                eP.X = (float)((double)eP.X - aLen / 8.0 * Math.sin(aWB.angle * Math.PI / 180.0));
                eP.Y = (float)((double)eP.Y + aLen / 8.0 * Math.cos(aWB.angle * Math.PI / 180.0));
            }
        }
        if (aWB.windSpeesLine.W2 > 0) {
            eP1 = new PointF();
            eP1.X = (float)((double)eP.X - (len /= 2.0) * Math.sin((aWB.angle - 120.0) * Math.PI / 180.0));
            eP1.Y = (float)((double)eP.Y + len * Math.cos((aWB.angle - 120.0) * Math.PI / 180.0));
            g.draw(new Line2D.Float(eP.X, eP.Y, eP1.X, eP1.Y));
        }
    }

    public static void drawWindBarb(Color aColor, PointF sP, WindBarb aWB, Graphics2D g, float size, float cut) {
        PointF eP1;
        int i;
        double len;
        double aLen = len = (double)(size * 2.0f);
        PointF eP = new PointF();
        eP.X = (float)((double)sP.X + len * Math.sin(aWB.angle * Math.PI / 180.0));
        eP.Y = (float)((double)sP.Y - len * Math.cos(aWB.angle * Math.PI / 180.0));
        PointF cutSP = new PointF(0.0f, 0.0f);
        cutSP.X = (float)((double)sP.X + (double)cut * Math.sin(aWB.angle * Math.PI / 180.0));
        cutSP.Y = (float)((double)sP.Y - (double)cut * Math.cos(aWB.angle * Math.PI / 180.0));
        g.setColor(aColor);
        g.draw(new Line2D.Float(cutSP.X, cutSP.Y, eP.X, eP.Y));
        len /= 2.0;
        if (aWB.windSpeesLine.W20 > 0) {
            for (i = 0; i < aWB.windSpeesLine.W20; ++i) {
                eP1 = new PointF();
                eP1.X = (float)((double)eP.X - len * Math.sin((aWB.angle - 105.0) * Math.PI / 180.0));
                eP1.Y = (float)((double)eP.Y + len * Math.cos((aWB.angle - 105.0) * Math.PI / 180.0));
                g.draw(new Line2D.Float(eP.X, eP.Y, eP1.X, eP1.Y));
                eP.X = (float)((double)eP.X - aLen / 8.0 * Math.sin(aWB.angle * Math.PI / 180.0));
                eP.Y = (float)((double)eP.Y + aLen / 8.0 * Math.cos(aWB.angle * Math.PI / 180.0));
                g.draw(new Line2D.Float(eP.X, eP.Y, eP1.X, eP1.Y));
            }
            eP.X = (float)((double)eP.X - aLen / 8.0 * Math.sin(aWB.angle * Math.PI / 180.0));
            eP.Y = (float)((double)eP.Y + aLen / 8.0 * Math.cos(aWB.angle * Math.PI / 180.0));
        }
        if (aWB.windSpeesLine.W4 > 0) {
            for (i = 0; i < aWB.windSpeesLine.W4; ++i) {
                eP1 = new PointF();
                eP1.X = (float)((double)eP.X - len * Math.sin((aWB.angle - 120.0) * Math.PI / 180.0));
                eP1.Y = (float)((double)eP.Y + len * Math.cos((aWB.angle - 120.0) * Math.PI / 180.0));
                g.draw(new Line2D.Float(eP.X, eP.Y, eP1.X, eP1.Y));
                eP.X = (float)((double)eP.X - aLen / 8.0 * Math.sin(aWB.angle * Math.PI / 180.0));
                eP.Y = (float)((double)eP.Y + aLen / 8.0 * Math.cos(aWB.angle * Math.PI / 180.0));
            }
        }
        if (aWB.windSpeesLine.W2 > 0) {
            eP1 = new PointF();
            eP1.X = (float)((double)eP.X - (len /= 2.0) * Math.sin((aWB.angle - 120.0) * Math.PI / 180.0));
            eP1.Y = (float)((double)eP.Y + len * Math.cos((aWB.angle - 120.0) * Math.PI / 180.0));
            g.draw(new Line2D.Float(eP.X, eP.Y, eP1.X, eP1.Y));
        }
    }

    public static void drawPoint(PointStyle aPS, PointF aP, Color color, Color outlineColor, float aSize, Boolean drawOutline, Boolean drawFill, Graphics2D g) {
        PointBreak aPB = new PointBreak();
        aPB.setMarkerType(MarkerType.Simple);
        aPB.setStyle(aPS);
        aPB.setColor(color);
        aPB.setOutlineColor(outlineColor);
        aPB.setSize(aSize);
        aPB.setDrawOutline(drawOutline);
        aPB.setDrawFill(drawFill);
        Draw.drawPoint(aP, aPB, g);
    }

    public static void drawPoint(PointF aP, PointBreak aPB, Graphics2D g) {
        Rectangle clip = g.getClipBounds();
        if (clip != null) {
            g.setClip(null);
            if (aP.X >= (float)clip.x && aP.X <= (float)(clip.x + clip.width) && aP.Y >= (float)clip.y && aP.Y <= (float)(clip.y + clip.height)) {
                switch (aPB.getMarkerType()) {
                    case Simple: {
                        Draw.drawPoint_Simple(aP, aPB, g);
                        break;
                    }
                    case Character: {
                        Draw.drawPoint_Character(aP, aPB, g);
                        break;
                    }
                    case Image: {
                        Draw.drawPoint_Image(aP, aPB, g);
                    }
                }
            }
            g.setClip(clip);
        } else {
            switch (aPB.getMarkerType()) {
                case Simple: {
                    Draw.drawPoint_Simple(aP, aPB, g);
                    break;
                }
                case Character: {
                    Draw.drawPoint_Character(aP, aPB, g);
                    break;
                }
                case Image: {
                    Draw.drawPoint_Image(aP, aPB, g);
                }
            }
        }
    }

    public static void drawMapPoint(PointF aP, PointBreak aPB, Graphics2D g) {
        switch (aPB.getMarkerType()) {
            case Simple: {
                Draw.drawPoint_Simple(aP, aPB, g);
                break;
            }
            case Character: {
                Draw.drawPoint_Character(aP, aPB, g);
                break;
            }
            case Image: {
                Draw.drawPoint_Image(aP, aPB, g);
            }
        }
    }

    private static void drawPoint_Simple(PointF aP, PointBreak aPB, Graphics2D g) {
        AffineTransform tempTrans = g.getTransform();
        if (aPB.getAngle() != 0.0f) {
            AffineTransform myTrans = (AffineTransform)tempTrans.clone();
            myTrans.translate(aP.X, aP.Y);
            myTrans.rotate((double)aPB.getAngle() * Math.PI / 180.0);
            g.setTransform(myTrans);
            aP.X = 0.0f;
            aP.Y = 0.0f;
        }
        g.setStroke(new BasicStroke(1.0f));
        float aSize = aPB.getSize();
        boolean drawFill = aPB.isDrawFill();
        boolean drawOutline = aPB.isDrawOutline();
        Color color = aPB.getColor();
        Color outlineColor = aPB.getOutlineColor();
        float outlineSize = aPB.getOutlineSize();
        GeneralPath path = new GeneralPath();
        switch (aPB.getStyle()) {
            case Circle: {
                aP.X -= aSize / 2.0f;
                aP.Y -= aSize / 2.0f;
                Ellipse2D.Float ellipse = new Ellipse2D.Float(aP.X, aP.Y, aSize, aSize);
                if (drawFill) {
                    g.setColor(color);
                    g.fill(ellipse);
                }
                if (!drawOutline) break;
                g.setColor(outlineColor);
                g.setStroke(new BasicStroke(outlineSize));
                g.draw(ellipse);
                break;
            }
            case DOUBLE_CIRCLE: {
                float x = aP.X - aSize / 2.0f;
                float y = aP.Y - aSize / 2.0f;
                Ellipse2D.Float ellipse = new Ellipse2D.Float(x, y, aSize, aSize);
                if (drawFill) {
                    g.setColor(color);
                    g.fill(ellipse);
                }
                if (!drawOutline) break;
                g.setColor(outlineColor);
                g.setStroke(new BasicStroke(outlineSize));
                g.draw(ellipse);
                x = aP.X - aSize * 0.3f;
                y = aP.Y - aSize * 0.3f;
                ellipse = new Ellipse2D.Float(x, y, aSize * 0.6f, aSize * 0.6f);
                g.draw(ellipse);
                break;
            }
            case Square: {
                aP.X -= aSize / 2.0f;
                aP.Y -= aSize / 2.0f;
                Rectangle2D.Float rect = new Rectangle2D.Float(aP.X, aP.Y, aSize, aSize);
                if (drawFill) {
                    g.setColor(color);
                    g.fill(rect);
                }
                if (!drawOutline) break;
                g.setColor(outlineColor);
                g.setStroke(new BasicStroke(outlineSize));
                g.draw(rect);
                break;
            }
            case Diamond: {
                int[] xPoints = new int[4];
                int[] yPoints = new int[4];
                xPoints[0] = (int)(aP.X - aSize / 2.0f);
                yPoints[0] = (int)aP.Y;
                xPoints[1] = (int)aP.X;
                yPoints[1] = (int)(aP.Y - aSize / 2.0f);
                xPoints[2] = (int)(aP.X + aSize / 2.0f);
                yPoints[2] = (int)aP.Y;
                xPoints[3] = (int)aP.X;
                yPoints[3] = (int)(aP.Y + aSize / 2.0f);
                if (drawFill) {
                    g.setColor(color);
                    g.fillPolygon(xPoints, yPoints, xPoints.length);
                }
                if (!drawOutline) break;
                g.setColor(outlineColor);
                g.setStroke(new BasicStroke(outlineSize));
                g.drawPolygon(xPoints, yPoints, xPoints.length);
                break;
            }
            case UpTriangle: {
                int[] xPoints = new int[3];
                int[] yPoints = new int[3];
                xPoints[0] = (int)aP.X;
                yPoints[0] = (int)(aP.Y - aSize / 2.0f);
                xPoints[1] = (int)((double)aP.X + (double)(aSize / 4.0f) * Math.sqrt(3.0));
                yPoints[1] = (int)(aP.Y + aSize / 4.0f);
                xPoints[2] = (int)((double)aP.X - (double)(aSize / 4.0f) * Math.sqrt(3.0));
                yPoints[2] = (int)(aP.Y + aSize / 4.0f);
                if (drawFill) {
                    g.setColor(color);
                    g.fillPolygon(xPoints, yPoints, xPoints.length);
                }
                if (!drawOutline) break;
                g.setColor(outlineColor);
                g.setStroke(new BasicStroke(outlineSize));
                g.drawPolygon(xPoints, yPoints, xPoints.length);
                break;
            }
            case DownTriangle: {
                int[] xPoints = new int[3];
                int[] yPoints = new int[3];
                xPoints[0] = (int)aP.X;
                yPoints[0] = (int)(aP.Y + aSize / 2.0f);
                xPoints[1] = (int)((double)aP.X - (double)(aSize / 4.0f) * Math.sqrt(3.0));
                yPoints[1] = (int)(aP.Y - aSize / 4.0f);
                xPoints[2] = (int)((double)aP.X + (double)(aSize / 4.0f) * Math.sqrt(3.0));
                yPoints[2] = (int)(aP.Y - aSize / 4.0f);
                if (drawFill) {
                    g.setColor(color);
                    g.fillPolygon(xPoints, yPoints, xPoints.length);
                }
                if (!drawOutline) break;
                g.setColor(outlineColor);
                g.setStroke(new BasicStroke(outlineSize));
                g.drawPolygon(xPoints, yPoints, xPoints.length);
                break;
            }
            case XCross: {
                path.moveTo(aP.X - aSize / 2.0f, aP.Y - aSize / 2.0f);
                path.lineTo(aP.X + aSize / 2.0f, aP.Y + aSize / 2.0f);
                path.moveTo(aP.X - aSize / 2.0f, aP.Y + aSize / 2.0f);
                path.lineTo(aP.X + aSize / 2.0f, aP.Y - aSize / 2.0f);
                path.closePath();
                if (!drawFill && !drawOutline) break;
                g.setColor(color);
                g.setStroke(new BasicStroke(outlineSize));
                g.draw(path);
                break;
            }
            case Plus: {
                path.moveTo(aP.X, aP.Y - aSize / 2.0f);
                path.lineTo(aP.X, aP.Y + aSize / 2.0f);
                path.moveTo(aP.X - aSize / 2.0f, aP.Y);
                path.lineTo(aP.X + aSize / 2.0f, aP.Y);
                path.closePath();
                if (!drawFill && !drawOutline) break;
                g.setColor(color);
                g.setStroke(new BasicStroke(outlineSize));
                g.draw(path);
                break;
            }
            case Minus: {
                path.moveTo(aP.X - aSize / 2.0f, aP.Y);
                path.lineTo(aP.X + aSize / 2.0f, aP.Y);
                path.closePath();
                if (!drawFill && !drawOutline) break;
                g.setColor(color);
                g.setStroke(new BasicStroke(outlineSize));
                g.draw(path);
                break;
            }
            case StarLines: {
                path.moveTo(aP.X - aSize / 2.0f, aP.Y - aSize / 2.0f);
                path.lineTo(aP.X + aSize / 2.0f, aP.Y + aSize / 2.0f);
                path.moveTo(aP.X - aSize / 2.0f, aP.Y + aSize / 2.0f);
                path.lineTo(aP.X + aSize / 2.0f, aP.Y - aSize / 2.0f);
                path.moveTo(aP.X, aP.Y - aSize / 2.0f);
                path.lineTo(aP.X, aP.Y + aSize / 2.0f);
                path.moveTo(aP.X - aSize / 2.0f, aP.Y);
                path.lineTo(aP.X + aSize / 2.0f, aP.Y);
                path.closePath();
                if (!drawFill && !drawOutline) break;
                g.setColor(color);
                g.setStroke(new BasicStroke(outlineSize));
                g.draw(path);
                break;
            }
            case Star: {
                float vRadius = aSize / 2.0f;
                PointF[] vPoints = new PointF[5];
                double vAngle = 4.71238898038469;
                for (int i = 0; i < vPoints.length; ++i) {
                    vPoints[i] = new PointF((float)(Math.cos(vAngle += Math.PI * 2 / (double)vPoints.length) * (double)vRadius) + aP.X, (float)(Math.sin(vAngle) * (double)vRadius) + aP.Y);
                }
                PointF[] cPoints = new PointF[]{MIMath.getCrossPoint(vPoints[0], vPoints[2], vPoints[1], vPoints[4]), MIMath.getCrossPoint(vPoints[1], vPoints[3], vPoints[0], vPoints[2]), MIMath.getCrossPoint(vPoints[1], vPoints[3], vPoints[2], vPoints[4]), MIMath.getCrossPoint(vPoints[0], vPoints[3], vPoints[2], vPoints[4]), MIMath.getCrossPoint(vPoints[0], vPoints[3], vPoints[1], vPoints[4])};
                int[] xPoints = new int[10];
                int[] yPoints = new int[10];
                for (int i = 0; i < 5; ++i) {
                    xPoints[i * 2] = (int)vPoints[i].X;
                    yPoints[i * 2] = (int)vPoints[i].Y;
                    xPoints[i * 2 + 1] = (int)cPoints[i].X;
                    yPoints[i * 2 + 1] = (int)cPoints[i].Y;
                }
                if (drawFill) {
                    g.setColor(color);
                    g.fillPolygon(xPoints, yPoints, xPoints.length);
                }
                if (!drawOutline) break;
                g.setColor(outlineColor);
                g.setStroke(new BasicStroke(outlineSize));
                g.drawPolygon(xPoints, yPoints, xPoints.length);
                break;
            }
            case CIRCLE_STAR: {
                int i;
                float vRadius = aSize * 0.4f;
                PointF[] vPoints = new PointF[5];
                double vAngle = 4.71238898038469;
                for (i = 0; i < vPoints.length; ++i) {
                    vPoints[i] = new PointF((float)(Math.cos(vAngle += Math.PI * 2 / (double)vPoints.length) * (double)vRadius) + aP.X, (float)(Math.sin(vAngle) * (double)vRadius) + aP.Y);
                }
                PointF[] cPoints = new PointF[]{MIMath.getCrossPoint(vPoints[0], vPoints[2], vPoints[1], vPoints[4]), MIMath.getCrossPoint(vPoints[1], vPoints[3], vPoints[0], vPoints[2]), MIMath.getCrossPoint(vPoints[1], vPoints[3], vPoints[2], vPoints[4]), MIMath.getCrossPoint(vPoints[0], vPoints[3], vPoints[2], vPoints[4]), MIMath.getCrossPoint(vPoints[0], vPoints[3], vPoints[1], vPoints[4])};
                int[] xPoints = new int[10];
                int[] yPoints = new int[10];
                for (i = 0; i < 5; ++i) {
                    xPoints[i * 2] = (int)vPoints[i].X;
                    yPoints[i * 2] = (int)vPoints[i].Y;
                    xPoints[i * 2 + 1] = (int)cPoints[i].X;
                    yPoints[i * 2 + 1] = (int)cPoints[i].Y;
                }
                if (drawFill) {
                    g.setColor(color);
                    g.fillPolygon(xPoints, yPoints, xPoints.length);
                }
                if (!drawOutline) break;
                g.setColor(outlineColor);
                g.setStroke(new BasicStroke(outlineSize));
                float x = aP.X - aSize * 0.5f;
                float y = aP.Y - aSize * 0.5f;
                Ellipse2D.Float ellipse = new Ellipse2D.Float(x, y, aSize, aSize);
                g.draw(ellipse);
                break;
            }
            case Pentagon: {
                float vRadius = aSize / 2.0f;
                int[] xPoints = new int[5];
                int[] yPoints = new int[5];
                double vAngle = 4.71238898038469;
                for (int i = 0; i < 5; ++i) {
                    xPoints[i] = (int)(Math.cos(vAngle += 1.2566370614359172) * (double)vRadius + (double)aP.X);
                    yPoints[i] = (int)(Math.sin(vAngle) * (double)vRadius + (double)aP.Y);
                }
                if (drawFill) {
                    g.setColor(color);
                    g.fillPolygon(xPoints, yPoints, xPoints.length);
                }
                if (!drawOutline) break;
                g.setColor(outlineColor);
                g.setStroke(new BasicStroke(outlineSize));
                g.drawPolygon(xPoints, yPoints, xPoints.length);
                break;
            }
            case UpSemiCircle: {
                aP.X -= aSize / 2.0f;
                aP.Y -= aSize / 2.0f;
                if (drawFill) {
                    g.setColor(color);
                    g.fill(new Arc2D.Float(aP.X, aP.Y, aSize, aSize, 180.0f, 180.0f, 1));
                }
                if (!drawOutline) break;
                g.setColor(outlineColor);
                g.setStroke(new BasicStroke(outlineSize));
                g.draw(new Arc2D.Float(aP.X, aP.Y, aSize, aSize, 180.0f, 180.0f, 1));
                break;
            }
            case DownSemiCircle: {
                aP.X -= aSize / 2.0f;
                aP.Y -= aSize / 2.0f;
                if (drawFill) {
                    g.setColor(color);
                    g.fill(new Arc2D.Float(aP.X, aP.Y, aSize, aSize, 0.0f, 180.0f, 1));
                }
                if (!drawOutline) break;
                g.setColor(outlineColor);
                g.setStroke(new BasicStroke(outlineSize));
                g.draw(new Arc2D.Float(aP.X, aP.Y, aSize, aSize, 0.0f, 180.0f, 1));
            }
        }
        if (aPB.getAngle() != 0.0f) {
            g.setTransform(tempTrans);
        }
    }

    private static void drawPoint_Simple_Up(PointF aP, PointBreak aPB, Graphics2D g) {
        AffineTransform tempTrans = g.getTransform();
        if (aPB.getAngle() != 0.0f) {
            AffineTransform myTrans = (AffineTransform)tempTrans.clone();
            myTrans.translate(aP.X, aP.Y);
            myTrans.rotate((double)aPB.getAngle() * Math.PI / 180.0);
            g.setTransform(myTrans);
            aP.X = 0.0f;
            aP.Y = 0.0f;
        }
        float aSize = aPB.getSize();
        boolean drawFill = aPB.isDrawFill();
        boolean drawOutline = aPB.isDrawOutline();
        Color color = aPB.getColor();
        Color outlineColor = aPB.getOutlineColor();
        float outlineSize = aPB.getOutlineSize();
        GeneralPath path = new GeneralPath();
        switch (aPB.getStyle()) {
            case Circle: {
                aP.X -= aSize / 2.0f;
                aP.Y -= aSize;
                if (drawFill) {
                    g.setColor(color);
                    g.fillOval((int)aP.X, (int)aP.Y, (int)aSize, (int)aSize);
                }
                if (!drawOutline) break;
                g.setColor(outlineColor);
                g.setStroke(new BasicStroke(outlineSize));
                g.drawOval((int)aP.X, (int)aP.Y, (int)aSize, (int)aSize);
                break;
            }
            case Square: {
                aP.X -= aSize / 2.0f;
                aP.Y -= aSize;
                if (drawFill) {
                    g.setColor(color);
                    g.fillRect((int)aP.X, (int)aP.Y, (int)aSize, (int)aSize);
                }
                if (!drawOutline) break;
                g.setColor(outlineColor);
                g.setStroke(new BasicStroke(outlineSize));
                g.drawRect((int)aP.X, (int)aP.Y, (int)aSize, (int)aSize);
                break;
            }
            case Diamond: {
                int[] xPoints = new int[4];
                int[] yPoints = new int[4];
                xPoints[0] = (int)(aP.X - aSize / 2.0f);
                yPoints[0] = (int)aP.Y;
                xPoints[1] = (int)aP.X;
                yPoints[1] = (int)(aP.Y - aSize / 2.0f);
                xPoints[2] = (int)(aP.X + aSize / 2.0f);
                yPoints[2] = (int)aP.Y;
                xPoints[3] = (int)aP.X;
                yPoints[3] = (int)(aP.Y + aSize / 2.0f);
                if (drawFill) {
                    g.setColor(color);
                    g.fillPolygon(xPoints, yPoints, xPoints.length);
                }
                if (drawOutline) {
                    g.setColor(outlineColor);
                    g.setStroke(new BasicStroke(outlineSize));
                    g.drawPolygon(xPoints, yPoints, xPoints.length);
                }
            }
            case UpTriangle: {
                int[] xPoints = new int[3];
                int[] yPoints = new int[3];
                xPoints[0] = (int)aP.X;
                yPoints[0] = (int)(aP.Y - aSize * 3.0f / 4.0f);
                xPoints[1] = (int)((double)aP.X + (double)(aSize / 4.0f) * Math.sqrt(3.0));
                yPoints[1] = (int)aP.Y;
                xPoints[2] = (int)((double)aP.X - (double)(aSize / 4.0f) * Math.sqrt(3.0));
                yPoints[2] = (int)aP.Y;
                if (drawFill) {
                    g.setColor(color);
                    g.fillPolygon(xPoints, yPoints, xPoints.length);
                }
                if (!drawOutline) break;
                g.setColor(outlineColor);
                g.setStroke(new BasicStroke(outlineSize));
                g.drawPolygon(xPoints, yPoints, xPoints.length);
            }
        }
        if (aPB.getAngle() != 0.0f) {
            g.setTransform(tempTrans);
        }
    }

    private static void drawPoint_Character(PointF aP, PointBreak aPB, Graphics2D g) {
        AffineTransform tempTrans = g.getTransform();
        if (aPB.getAngle() != 0.0f) {
            AffineTransform myTrans = (AffineTransform)tempTrans.clone();
            myTrans.translate(aP.X, aP.Y);
            myTrans.rotate((double)aPB.getAngle() * Math.PI / 180.0);
            g.setTransform(myTrans);
            aP.X = 0.0f;
            aP.Y = 0.0f;
        }
        String text = String.valueOf((char)aPB.getCharIndex());
        Font wFont = new Font(aPB.getFontName(), 0, (int)aPB.getSize());
        g.setFont(wFont);
        FontMetrics metrics = g.getFontMetrics();
        PointF sPoint = (PointF)aP.clone();
        sPoint.X -= (float)(metrics.stringWidth(text) / 2);
        sPoint.Y += (float)(metrics.getHeight() / 4);
        g.setColor(aPB.getColor());
        g.drawString(text, sPoint.X, sPoint.Y);
        if (aPB.getAngle() != 0.0f) {
            g.setTransform(tempTrans);
        }
    }

    private static void drawPoint_Image(PointF aP, PointBreak aPB, Graphics2D g) {
        File imgFile;
        AffineTransform tempTrans = g.getTransform();
        if (aPB.getAngle() != 0.0f) {
            AffineTransform myTrans = (AffineTransform)tempTrans.clone();
            myTrans.translate(aP.X, aP.Y);
            myTrans.rotate((double)aPB.getAngle() * Math.PI / 180.0);
            g.setTransform(myTrans);
            aP.X = 0.0f;
            aP.Y = 0.0f;
        }
        if (!(imgFile = new File(aPB.getImagePath())).exists()) {
            File directory = new File(".");
            String path = null;
            try {
                path = directory.getCanonicalPath();
            }
            catch (IOException ex) {
                Logger.getLogger(Draw.class.getName()).log(Level.SEVERE, null, ex);
            }
            path = path + File.separator + "Image";
            aPB.setImagePath(path + File.separator + imgFile.getName());
        }
        if (imgFile.exists()) {
            BufferedImage image = null;
            try {
                image = ImageIO.read(imgFile);
            }
            catch (IOException ex) {
                Logger.getLogger(Draw.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (image != null) {
                int width = (int)aPB.getSize();
                int height = width * ((Image)image).getHeight(null) / ((Image)image).getWidth(null);
                PointF sPoint = aP;
                sPoint.X -= (float)(width / 2);
                sPoint.Y -= (float)(height / 2);
                g.drawImage(image, (int)sPoint.X, (int)sPoint.Y, width, height, null);
            }
        }
        if (aPB.getAngle() != 0.0f) {
            g.setTransform(tempTrans);
        }
    }

    public static void drawString(Graphics2D g, float x, float y, String s, XAlign x_align, YAlign y_align, boolean useExternalFont) {
        Dimension dim = Draw.getStringDimension(s, g);
        switch (y_align) {
            case TOP: {
                y = (float)((double)y + dim.getHeight());
                break;
            }
            case CENTER: {
                y = (float)((double)y + dim.getHeight() / 2.0);
            }
        }
        switch (x_align) {
            case LEFT: {
                Draw.drawString(g, s, x, y, useExternalFont);
                break;
            }
            case RIGHT: {
                Draw.drawString(g, s, x - (float)dim.getWidth(), y, useExternalFont);
                break;
            }
            case CENTER: {
                Draw.drawString(g, s, x - (float)dim.getWidth() / 2.0f, y, useExternalFont);
            }
        }
    }

    public static void drawString(Graphics2D g, double x, double y, String s, XAlign x_align, YAlign y_align, boolean useExternalFont) {
        Dimension dim = Draw.getStringDimension(s, g);
        switch (y_align) {
            case TOP: {
                y += dim.getHeight();
                break;
            }
            case CENTER: {
                y += dim.getHeight() / 2.0;
            }
        }
        switch (x_align) {
            case LEFT: {
                Draw.drawString(g, s, x, y, useExternalFont);
                break;
            }
            case RIGHT: {
                Draw.drawString(g, s, x - (double)((float)dim.getWidth()), y, useExternalFont);
                break;
            }
            case CENTER: {
                Draw.drawString(g, s, x - (double)((float)dim.getWidth() / 2.0f), y, useExternalFont);
            }
        }
    }

    public static void drawString(Graphics2D g, float x, float y, String s, XAlign x_align, YAlign y_align, float angle, boolean useExternalFont) {
        if (angle == 0.0f) {
            Draw.drawString(g, x, y, s, x_align, y_align, useExternalFont);
        } else {
            AffineTransform tempTrans = g.getTransform();
            AffineTransform myTrans = Draw.transform(g, x, y, s, x_align, y_align, angle);
            g.setTransform(myTrans);
            Draw.drawString(g, s, 0.0f, 0.0f, useExternalFont);
            g.setTransform(tempTrans);
        }
    }

    public static void drawString(Graphics2D g, double x, double y, String s, XAlign x_align, YAlign y_align, float angle, boolean useExternalFont) {
        if (angle == 0.0f) {
            Draw.drawString(g, x, y, s, x_align, y_align, useExternalFont);
        } else {
            AffineTransform tempTrans = g.getTransform();
            AffineTransform myTrans = Draw.transform(g, x, y, s, x_align, y_align, angle);
            g.setTransform(myTrans);
            Draw.drawString(g, s, 0.0f, 0.0f, useExternalFont);
            g.setTransform(tempTrans);
        }
    }

    public static AffineTransform transform(Graphics2D g, float x, float y, String s, XAlign x_align, YAlign y_align, float angle) {
        Dimension dim = Draw.getStringDimension(s, g);
        AffineTransform tempTrans = g.getTransform();
        AffineTransform myTrans = (AffineTransform)tempTrans.clone();
        block0 : switch (x_align) {
            case LEFT: {
                switch (y_align) {
                    case CENTER: {
                        if (angle == 90.0f) {
                            x += (float)dim.getHeight();
                            y += (float)(dim.getWidth() * 0.5);
                            break;
                        }
                        if (angle == -90.0f) {
                            y -= (float)(dim.getWidth() * 0.5);
                            break;
                        }
                        if (angle > 0.0f) {
                            x += (float)(dim.getHeight() * Math.abs(Math.sin(Math.toRadians(angle))));
                            y += (float)(dim.getHeight() * Math.cos(Math.toRadians(angle)) * 0.5);
                            break;
                        }
                        y += (float)(dim.getHeight() * Math.cos(Math.toRadians(angle)) * 0.5);
                    }
                }
                break;
            }
            case CENTER: {
                switch (y_align) {
                    case TOP: {
                        if (angle == 90.0f) {
                            x += (float)(dim.getHeight() * 0.5);
                            y += (float)dim.getWidth();
                            break;
                        }
                        if (angle == -90.0f) {
                            x -= (float)(dim.getHeight() * 0.5);
                            break;
                        }
                        if (angle > 0.0f) {
                            x -= (float)(dim.getWidth() * Math.abs(Math.cos(Math.toRadians(angle))));
                            y = (float)((double)y + ((double)((float)(dim.getWidth() * Math.sin(Math.toRadians(angle)))) + dim.getHeight() * 0.5 * Math.cos(Math.toRadians(angle))));
                            break;
                        }
                        y += (float)(dim.getHeight() * Math.abs(Math.cos(Math.toRadians(angle))));
                    }
                }
                break;
            }
            case RIGHT: {
                switch (y_align) {
                    case CENTER: {
                        if (angle == 90.0f) {
                            x -= (float)dim.getHeight();
                            y += (float)(dim.getWidth() * 0.5);
                            break block0;
                        }
                        if (angle == -90.0f) {
                            x -= (float)dim.getHeight();
                            y -= (float)(dim.getWidth() * 0.5);
                            break block0;
                        }
                        if (angle > 0.0f) {
                            x -= (float)(dim.getWidth() * Math.abs(Math.cos(Math.toRadians(angle))));
                            y += (float)(dim.getHeight() * Math.cos(Math.toRadians(angle)) * 0.5);
                            break block0;
                        }
                        y += (float)(dim.getHeight() * Math.cos(Math.toRadians(angle)) * 0.5);
                    }
                }
            }
        }
        myTrans.translate(x, y);
        myTrans.rotate((double)(-angle) * Math.PI / 180.0);
        return myTrans;
    }

    public static AffineTransform transform(Graphics2D g, double x, double y, String s, XAlign x_align, YAlign y_align, float angle) {
        Dimension dim = Draw.getStringDimension(s, g);
        AffineTransform tempTrans = g.getTransform();
        AffineTransform myTrans = (AffineTransform)tempTrans.clone();
        block0 : switch (x_align) {
            case LEFT: {
                switch (y_align) {
                    case CENTER: {
                        if (angle == 90.0f) {
                            x += (double)((float)dim.getHeight());
                            y += (double)((float)(dim.getWidth() * 0.5));
                            break;
                        }
                        if (angle == -90.0f) {
                            y -= (double)((float)(dim.getWidth() * 0.5));
                            break;
                        }
                        if (angle > 0.0f) {
                            x += (double)((float)(dim.getHeight() * Math.abs(Math.sin(Math.toRadians(angle)))));
                            y += (double)((float)(dim.getHeight() * Math.cos(Math.toRadians(angle)) * 0.5));
                            break;
                        }
                        y += (double)((float)(dim.getHeight() * Math.cos(Math.toRadians(angle)) * 0.5));
                    }
                }
                break;
            }
            case CENTER: {
                switch (y_align) {
                    case TOP: {
                        if (angle == 90.0f) {
                            x += (double)((float)(dim.getHeight() * 0.5));
                            y += (double)((float)dim.getWidth());
                            break;
                        }
                        if (angle == -90.0f) {
                            x -= (double)((float)(dim.getHeight() * 0.5));
                            break;
                        }
                        if (angle > 0.0f) {
                            x -= (double)((float)(dim.getWidth() * Math.abs(Math.cos(Math.toRadians(angle)))));
                            y += (double)((float)(dim.getWidth() * Math.sin(Math.toRadians(angle)))) + dim.getHeight();
                            break;
                        }
                        y += (double)((float)(dim.getHeight() * Math.abs(Math.cos(Math.toRadians(angle)))));
                    }
                }
                break;
            }
            case RIGHT: {
                switch (y_align) {
                    case CENTER: {
                        if (angle == 90.0f) {
                            x -= (double)((float)dim.getHeight());
                            y += (double)((float)(dim.getWidth() * 0.5));
                            break block0;
                        }
                        if (angle == -90.0f) {
                            x -= (double)((float)dim.getHeight());
                            y -= (double)((float)(dim.getWidth() * 0.5));
                            break block0;
                        }
                        if (angle > 0.0f) {
                            x -= (double)((float)(dim.getWidth() * Math.abs(Math.cos(Math.toRadians(angle)))));
                            y += (double)((float)(dim.getHeight() * Math.cos(Math.toRadians(angle)) * 0.5));
                            break block0;
                        }
                        y += (double)((float)(dim.getHeight() * Math.cos(Math.toRadians(angle)) * 0.5));
                    }
                }
            }
        }
        myTrans.translate(x, y);
        myTrans.rotate((double)(-angle) * Math.PI / 180.0);
        return myTrans;
    }

    public static void drawLabelPoint(PointF aPoint, LabelBreak aLB, Graphics2D g, Rectangle rect) {
        g.setColor(aLB.getColor());
        g.setFont(aLB.getFont());
        Dimension labSize = Draw.getStringDimension(aLB.getText(), g);
        switch (aLB.getAlignType()) {
            case Center: {
                aPoint.X -= (float)labSize.getWidth() / 2.0f;
                break;
            }
            case Left: {
                aPoint.X -= (float)labSize.getWidth();
            }
        }
        aLB.setYShift((float)labSize.getHeight() / 2.0f);
        aPoint.Y -= aLB.getYShift();
        aPoint.X += aLB.getXShift();
        float inx = aPoint.X;
        float iny = aPoint.Y;
        AffineTransform tempTrans = g.getTransform();
        if (aLB.getAngle() != 0.0f) {
            AffineTransform myTrans = (AffineTransform)tempTrans.clone();
            myTrans.translate(aPoint.X, aPoint.Y);
            myTrans.rotate((double)aLB.getAngle() * Math.PI / 180.0);
            g.setTransform(myTrans);
            aPoint.X = 0.0f;
            aPoint.Y = 0.0f;
        }
        Draw.drawString(g, aLB.getText(), aPoint.X, aPoint.Y + (float)(labSize.height / 2));
        rect.x = (int)aPoint.X;
        rect.y = (int)aPoint.Y - labSize.height / 2;
        rect.width = (int)labSize.getWidth();
        rect.height = (int)labSize.getHeight();
        if (aLB.getAngle() != 0.0f) {
            g.setTransform(tempTrans);
            rect.x = (int)inx;
            rect.y = (int)iny;
        }
    }

    public static void drawLabelPoint(float x, float y, Font font, String text, Color color, float angle, Graphics2D g, Rectangle rect) {
        g.setColor(color);
        g.setFont(font);
        Dimension labSize = Draw.getStringDimension(text, g);
        float inx = x -= (float)labSize.getWidth() / 2.0f;
        float iny = y -= (float)labSize.getHeight() / 2.0f;
        AffineTransform tempTrans = g.getTransform();
        if (angle != 0.0f) {
            AffineTransform myTrans = (AffineTransform)tempTrans.clone();
            myTrans.translate(x, y);
            myTrans.rotate((double)angle * Math.PI / 180.0);
            g.setTransform(myTrans);
            x = 0.0f;
            y = 0.0f;
        }
        Draw.drawString(g, text, x, y + (float)(labSize.height / 2));
        if (rect != null) {
            rect.x = (int)x;
            rect.y = (int)y - labSize.height / 2;
            rect.width = (int)labSize.getWidth();
            rect.height = (int)labSize.getHeight();
        }
        if (angle != 0.0f) {
            g.setTransform(tempTrans);
            if (rect != null) {
                rect.x = (int)inx;
                rect.y = (int)iny;
            }
        }
    }

    public static void drawLabelPoint(float x, float y, Font font, String text, Color color, float angle, Graphics2D g, Rectangle rect, boolean useExternalFont) {
        g.setColor(color);
        g.setFont(font);
        Dimension labSize = Draw.getStringDimension(text, g);
        float inx = x -= (float)labSize.getWidth() / 2.0f;
        float iny = y -= (float)labSize.getHeight() / 2.0f;
        AffineTransform tempTrans = g.getTransform();
        if (angle != 0.0f) {
            AffineTransform myTrans = (AffineTransform)tempTrans.clone();
            myTrans.translate(x, y);
            myTrans.rotate((double)angle * Math.PI / 180.0);
            g.setTransform(myTrans);
            x = 0.0f;
            y = 0.0f;
        }
        Draw.drawString(g, text, x, y + (float)(labSize.height / 2), useExternalFont);
        if (rect != null) {
            rect.x = (int)x;
            rect.y = (int)y - labSize.height / 2;
            rect.width = (int)labSize.getWidth();
            rect.height = (int)labSize.getHeight();
        }
        if (angle != 0.0f) {
            g.setTransform(tempTrans);
            if (rect != null) {
                rect.x = (int)inx;
                rect.y = (int)iny;
            }
        }
    }

    public static void drawTickLabel(float x, float y, Font font, String text, Color color, float angle, Graphics2D g) {
        g.setColor(color);
        g.setFont(font);
        Dimension labSize = Draw.getStringDimension(text, g);
        if (angle == 0.0f) {
            Draw.drawString(g, text, x -= (float)labSize.getWidth() / 2.0f, (y -= (float)labSize.getHeight() / 2.0f) + (float)(labSize.height / 2));
        } else {
            AffineTransform tempTrans = g.getTransform();
            AffineTransform myTrans = (AffineTransform)tempTrans.clone();
            myTrans.translate(x, y);
            myTrans.translate(tempTrans.getTranslateX() + (double)x, tempTrans.getTranslateY() + (double)y);
            myTrans.rotate((double)(-angle) * Math.PI / 180.0);
            g.setTransform(myTrans);
            if (angle == 90.0f) {
                x = -((float)(labSize.getWidth() - 10.0));
                y = (float)(labSize.getHeight() / 3.0);
            } else {
                x = -((float)(labSize.getWidth() - 5.0));
                y = 0.0f;
            }
            Draw.drawString(g, text, x, y);
            g.setTransform(tempTrans);
        }
    }

    public static void drawTickLabel_Y(float x, float y, Font font, String text, Color color, float angle, Graphics2D g) {
        g.setColor(color);
        g.setFont(font);
        Dimension labSize = Draw.getStringDimension(text, g);
        if (angle == 0.0f) {
            Draw.drawString(g, text, x, y);
        } else {
            AffineTransform tempTrans = g.getTransform();
            AffineTransform myTrans = (AffineTransform)tempTrans.clone();
            myTrans.translate(x, y);
            myTrans.translate(tempTrans.getTranslateX() + (double)x, tempTrans.getTranslateY() + (double)y);
            myTrans.rotate((double)(-angle) * Math.PI / 180.0);
            g.setTransform(myTrans);
            if (angle == 90.0f) {
                x = -((float)(labSize.getWidth() - 10.0));
                y = (float)(labSize.getHeight() / 3.0);
            } else {
                x = -((float)(labSize.getWidth() - 5.0));
                y = 0.0f;
            }
            Draw.drawString(g, text, x, y);
            g.setTransform(tempTrans);
        }
    }

    public static void drawTickLabel_YRight(float x, float y, Font font, String text, Color color, float angle, Graphics2D g) {
        g.setColor(color);
        g.setFont(font);
        Dimension labSize = Draw.getStringDimension(text, g);
        if (angle == 0.0f) {
            Draw.drawString(g, text, x, y += (float)labSize.getHeight() * 0.5f);
        } else {
            AffineTransform tempTrans = g.getTransform();
            AffineTransform myTrans = (AffineTransform)tempTrans.clone();
            if (angle == 90.0f) {
                x += (float)labSize.getHeight();
                y += (float)(labSize.getWidth() * 0.5);
            } else if (angle == -90.0f) {
                y -= (float)(labSize.getWidth() * 0.5);
            } else if (angle > 0.0f) {
                x += (float)(labSize.getHeight() * Math.abs(Math.sin(Math.toRadians(angle))));
                y += (float)(labSize.getHeight() * Math.cos(Math.toRadians(angle)) * 0.5);
            } else {
                y += (float)(labSize.getHeight() * Math.cos(Math.toRadians(angle)) * 0.5);
            }
            myTrans.translate(x, y);
            myTrans.rotate((double)(-angle) * Math.PI / 180.0);
            g.setTransform(myTrans);
            Draw.drawString(g, text, 0.0f, 0.0f);
            g.setTransform(tempTrans);
        }
    }

    public static void drawStationModel(Color aColor, Color foreColor, PointF sP, StationModelShape aSM, Graphics2D g, float size, float cut) {
        Dimension textSize;
        FontMetrics metrics;
        Font wFont;
        String text;
        PointF sPoint = new PointF(0.0f, 0.0f);
        g.setColor(aColor);
        if (aSM.cloudCoverage.cloudCover >= 0 && aSM.cloudCoverage.cloudCover <= 9) {
            Draw.drawWindBarb(aColor, sP, aSM.windBarb, g, size, cut);
            text = String.valueOf((char)(aSM.cloudCoverage.cloudCover + 197));
            wFont = new Font("Weather", 0, (int)size);
            metrics = g.getFontMetrics(wFont);
            textSize = new Dimension(metrics.stringWidth(text), metrics.getHeight());
            sPoint.X = sP.X - (float)textSize.getWidth() / 2.0f;
            sPoint.Y = sP.Y - (float)textSize.getHeight() / 2.0f;
            g.setFont(wFont);
            g.drawString(text, sPoint.X, sPoint.Y + (float)(metrics.getHeight() * 3 / 4));
        } else {
            Draw.drawWindBarb(aColor, sP, aSM.windBarb, g, size);
            wFont = new Font("Arial", 0, (int)(size / 4.0f * 3.0f));
            text = "M";
            metrics = g.getFontMetrics(wFont);
            textSize = new Dimension(metrics.stringWidth(text), metrics.getHeight());
            sPoint.X = sP.X - (float)textSize.getWidth() / 2.0f;
            sPoint.Y = sP.Y - (float)textSize.getHeight() / 3.0f * 2.0f;
            g.setFont(wFont);
            g.drawString(text, sPoint.X, sPoint.Y + (float)(metrics.getHeight() * 3 / 4));
            wFont = new Font("Weather", 0, (int)size);
            text = String.valueOf('\u00c5');
            metrics = g.getFontMetrics(wFont);
            textSize = new Dimension(metrics.stringWidth(text), metrics.getHeight());
            sPoint.X = sP.X - (float)textSize.getWidth() / 2.0f;
            sPoint.Y = sP.Y - (float)textSize.getHeight() / 2.0f;
            g.setFont(wFont);
            g.drawString(text, sPoint.X, sPoint.Y + (float)(metrics.getHeight() * 3 / 4));
        }
        if (aSM.weatherSymbol.weather >= 4 && aSM.weatherSymbol.weather <= 99) {
            wFont = new Font("Weather", 0, (int)size);
            text = String.valueOf((char)(aSM.weatherSymbol.weather + 100));
            metrics = g.getFontMetrics(wFont);
            textSize = new Dimension(metrics.stringWidth(text), metrics.getHeight());
            sPoint.X = sP.X - (float)textSize.getHeight() - aSM.size / 2.0f;
            sPoint.Y = sP.Y - (float)textSize.getHeight() / 2.0f;
            text = String.valueOf((char)(aSM.weatherSymbol.weather + 28));
            if (aSM.weatherSymbol.weather == 99) {
                text = String.valueOf((char)(aSM.weatherSymbol.weather + 97));
            }
            g.setFont(wFont);
            g.drawString(text, sPoint.X, sPoint.Y + (float)(metrics.getHeight() * 3 / 4));
        }
        wFont = new Font("Arial", 0, (int)(size / 4.0f * 3.0f));
        g.setFont(wFont);
        metrics = g.getFontMetrics(wFont);
        if (Math.abs(aSM.temperature) < 1000) {
            g.setColor(Color.red);
            text = String.valueOf(aSM.temperature);
            textSize = new Dimension(metrics.stringWidth(text), metrics.getHeight());
            sPoint.X = sP.X - (float)textSize.getWidth() - size / 3.0f;
            sPoint.Y = sP.Y - (float)textSize.getHeight() - size / 3.0f;
            g.drawString(text, sPoint.X, sPoint.Y + (float)(metrics.getHeight() * 3 / 4));
        }
        if (Math.abs(aSM.dewPoint) < 1000) {
            g.setColor(Color.green);
            text = String.valueOf(aSM.dewPoint);
            textSize = new Dimension(metrics.stringWidth(text), metrics.getHeight());
            sPoint.X = sP.X - (float)textSize.getWidth() - size / 3.0f;
            sPoint.Y = sP.Y + size / 3.0f;
            g.drawString(text, sPoint.X, sPoint.Y + (float)(metrics.getHeight() * 3 / 4));
        }
        if (Math.abs(aSM.pressure) < 1000) {
            g.setColor(foreColor);
            text = String.format("%1$03d", aSM.pressure);
            sPoint.X = sP.X + size / 3.0f;
            sPoint.Y = sP.Y - (float)metrics.getHeight() - size / 3.0f;
            g.drawString(text, sPoint.X, sPoint.Y + (float)(metrics.getHeight() * 3 / 4));
        }
    }

    public static void drawGrahpic(PointF[] points, Graphic aGraphic, Graphics2D g, boolean isEditingVertice) {
        Rectangle rect = new Rectangle();
        Extent aExtent = MIMath.getPointFsExtent(points);
        rect.x = (int)aExtent.minX;
        rect.y = (int)aExtent.minY;
        rect.width = (int)aExtent.getWidth();
        rect.height = (int)aExtent.getHeight();
        switch (aGraphic.getShape().getShapeType()) {
            case Point: {
                switch (aGraphic.getLegend().getBreakType()) {
                    case PointBreak: {
                        Draw.drawPoint((PointF)points[0].clone(), (PointBreak)aGraphic.getLegend(), g);
                        int aSize = (int)((PointBreak)aGraphic.getLegend()).getSize() / 2 + 2;
                        rect.x = (int)points[0].X - aSize;
                        rect.y = (int)points[0].Y - aSize;
                        rect.width = aSize * 2;
                        rect.height = aSize * 2;
                        break;
                    }
                    case LabelBreak: {
                        Draw.drawLabelPoint((PointF)points[0].clone(), (LabelBreak)aGraphic.getLegend(), g, rect);
                    }
                }
                break;
            }
            case Polyline: {
                if (aGraphic.getLegend().getBreakType() == BreakTypes.ColorBreakCollection) {
                    Draw.drawPolyline(points, (ColorBreakCollection)aGraphic.getLegend(), g);
                    break;
                }
                Draw.drawPolyline(points, (PolylineBreak)aGraphic.getLegend(), g);
                break;
            }
            case Polygon: {
                PolygonShape pgs = (PolygonShape)aGraphic.getShape().clone();
                pgs.setPoints_keep(points);
                Draw.drawPolygonShape(pgs, (PolygonBreak)aGraphic.getLegend(), g);
                break;
            }
            case Rectangle: {
                Draw.drawPolygon(points, (PolygonBreak)aGraphic.getLegend(), g);
                break;
            }
            case CurveLine: {
                Draw.drawCurveLine(points, (PolylineBreak)aGraphic.getLegend(), g);
                break;
            }
            case CurvePolygon: {
                Draw.drawCurvePolygon(points, (PolygonBreak)aGraphic.getLegend(), g);
                break;
            }
            case Circle: {
                Draw.drawCircle(points, (PolygonBreak)aGraphic.getLegend(), g);
                break;
            }
            case Ellipse: {
                EllipseShape eshape = (EllipseShape)aGraphic.getShape();
                Draw.drawEllipse(points, eshape.getAngle(), (PolygonBreak)aGraphic.getLegend(), g);
            }
        }
        if (aGraphic.getShape().isSelected()) {
            if (isEditingVertice) {
                Draw.drawSelectedVertices(g, points);
            } else {
                float[] dashPattern = new float[]{2.0f, 1.0f};
                g.setColor(Color.cyan);
                g.setStroke(new BasicStroke(1.0f, 1, 0, 10.0f, dashPattern, 0.0f));
                g.draw(rect);
                switch (aGraphic.getShape().getShapeType()) {
                    case Point: {
                        if (aGraphic.getLegend().getBreakType() != BreakTypes.PointBreak) break;
                        Draw.drawSelectedCorners(g, rect);
                        break;
                    }
                    case Polyline: 
                    case Polygon: 
                    case Rectangle: 
                    case CurveLine: 
                    case CurvePolygon: 
                    case Ellipse: {
                        Draw.drawSelectedCorners(g, rect);
                        Draw.drawSelectedEdgeCenters(g, rect);
                        break;
                    }
                    case Circle: {
                        Draw.drawSelectedCorners(g, rect);
                    }
                }
            }
        }
    }

    public static void drawPolyline(List<PointF> points, Graphics2D g) {
        GeneralPath path = new GeneralPath(0, points.size());
        for (int i = 0; i < points.size(); ++i) {
            if (i == 0) {
                path.moveTo(points.get((int)i).X, points.get((int)i).Y);
                continue;
            }
            path.lineTo(points.get((int)i).X, points.get((int)i).Y);
        }
        g.draw(path);
    }

    public static void drawPolyline(PointF[] points, Graphics2D g) {
        GeneralPath path = new GeneralPath(0, points.length);
        for (int i = 0; i < points.length; ++i) {
            if (i == 0) {
                path.moveTo(points[i].X, points[i].Y);
                continue;
            }
            path.lineTo(points[i].X, points[i].Y);
        }
        g.draw(path);
    }

    public static void drawPolyline(PointD[] points, Graphics2D g) {
        GeneralPath path = new GeneralPath(0, points.length);
        for (int i = 0; i < points.length; ++i) {
            if (i == 0) {
                path.moveTo(points[i].X, points[i].Y);
                continue;
            }
            path.lineTo(points[i].X, points[i].Y);
        }
        g.draw(path);
    }

    public static void drawPolyline(PointF[] points, Graphics2D g, List<Integer> mvIdx) {
        GeneralPath path = new GeneralPath(0, points.length - mvIdx.size());
        boolean isNew = true;
        for (int i = 0; i < points.length; ++i) {
            if (mvIdx.contains(i)) {
                isNew = true;
                continue;
            }
            if (isNew) {
                path.moveTo(points[i].X, points[i].Y);
                isNew = false;
                continue;
            }
            path.lineTo(points[i].X, points[i].Y);
        }
        g.draw(path);
    }

    public static void fillPolygon(PointF[] points, Graphics2D g, PolygonBreak aPGB) {
        GeneralPath path = new GeneralPath(0, points.length);
        for (int i = 0; i < points.length; ++i) {
            if (i == 0) {
                path.moveTo(points[i].X, points[i].Y);
                continue;
            }
            path.lineTo(points[i].X, points[i].Y);
        }
        path.closePath();
        if (aPGB != null) {
            if (aPGB.isUsingHatchStyle()) {
                int size = aPGB.getStyleSize();
                BufferedImage bi = Draw.getHatchImage(aPGB.getStyle(), size, aPGB.getColor(), aPGB.getBackColor());
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, size, size);
                g.setPaint(new TexturePaint(bi, rect));
                g.fill(path);
            } else {
                g.fill(path);
            }
        } else {
            g.fill(path);
        }
    }

    public static void fillPolygon(PointD[] points, Graphics2D g, PolygonBreak aPGB) {
        GeneralPath path = new GeneralPath(0, points.length);
        for (int i = 0; i < points.length; ++i) {
            if (i == 0) {
                path.moveTo(points[i].X, points[i].Y);
                continue;
            }
            path.lineTo(points[i].X, points[i].Y);
        }
        path.closePath();
        if (aPGB != null) {
            if (aPGB.isUsingHatchStyle()) {
                int size = aPGB.getStyleSize();
                BufferedImage bi = Draw.getHatchImage(aPGB.getStyle(), size, aPGB.getColor(), aPGB.getBackColor());
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, size, size);
                g.setPaint(new TexturePaint(bi, rect));
                g.fill(path);
            } else {
                g.fill(path);
            }
        } else {
            g.fill(path);
        }
    }

    public static void drawPolygonShape(PolygonShape pgs, PolygonBreak pgb, Graphics2D g) {
        for (Polygon polygon : pgs.getPolygons()) {
            Draw.drawPolygon(polygon, pgb, g);
        }
    }

    public static void drawPolygon(Polygon aPG, PolygonBreak aPGB, Graphics2D g) {
        PointD wPoint;
        int len = aPG.getOutLine().size();
        GeneralPath path = new GeneralPath(0, len);
        path.moveTo(0.0f, 0.0f);
        for (int i = 0; i < aPG.getOutLine().size(); ++i) {
            wPoint = aPG.getOutLine().get(i);
            if (i == 0) {
                path.moveTo(wPoint.X, wPoint.Y);
                continue;
            }
            path.lineTo(wPoint.X, wPoint.Y);
        }
        if (aPG.hasHole()) {
            for (int h = 0; h < aPG.getHoleLines().size(); ++h) {
                List<? extends PointD> newPList = aPG.getHoleLines().get(h);
                for (int j = 0; j < newPList.size(); ++j) {
                    wPoint = newPList.get(j);
                    if (j == 0) {
                        path.moveTo(wPoint.X, wPoint.Y);
                        continue;
                    }
                    path.lineTo(wPoint.X, wPoint.Y);
                }
            }
        }
        path.closePath();
        if (aPGB.isDrawFill()) {
            Color aColor = aPGB.getColor();
            if (aPGB.isUsingHatchStyle()) {
                int size = aPGB.getStyleSize();
                BufferedImage bi = Draw.getHatchImage(aPGB.getStyle(), size, aPGB.getColor(), aPGB.getBackColor());
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, size, size);
                g.setPaint(new TexturePaint(bi, rect));
                g.fill(path);
            } else {
                g.setColor(aColor);
                g.fill(path);
            }
        }
        if (aPGB.isDrawOutline()) {
            BasicStroke pen = new BasicStroke(aPGB.getOutlineSize());
            g.setStroke(pen);
            g.setColor(aPGB.getOutlineColor());
            g.draw(path);
        }
    }

    public static void drawPolygon(PointF[] points, PolygonBreak aPGB, Graphics2D g) {
        if (aPGB.isDrawFill()) {
            g.setColor(aPGB.getColor());
            Draw.fillPolygon(points, g, aPGB);
        }
        if (aPGB.isDrawOutline()) {
            g.setColor(aPGB.getOutlineColor());
            g.setStroke(new BasicStroke(aPGB.getOutlineSize()));
            Draw.drawPolyline(points, g);
        }
    }

    public static void drawPolygon(PointD[] points, PolygonBreak aPGB, Graphics2D g) {
        if (aPGB.isDrawFill()) {
            g.setColor(aPGB.getColor());
            Draw.fillPolygon(points, g, aPGB);
        }
        if (aPGB.isDrawOutline()) {
            g.setColor(aPGB.getOutlineColor());
            g.setStroke(new BasicStroke(aPGB.getOutlineSize()));
            Draw.drawPolyline(points, g);
        }
    }

    public static void drawPolygon(PointF[] points, Color aColor, Color outlineColor, boolean drawFill, boolean drawOutline, Graphics2D g) {
        if (drawFill) {
            g.setColor(aColor);
            Draw.fillPolygon(points, g, null);
        }
        if (drawOutline) {
            g.setColor(outlineColor);
            Draw.drawPolyline(points, g);
        }
    }

    public static void drawPolygon(PointD[] points, Color aColor, Color outlineColor, boolean drawFill, boolean drawOutline, Graphics2D g) {
        if (drawFill) {
            g.setColor(aColor);
            Draw.fillPolygon(points, g, null);
        }
        if (drawOutline) {
            g.setColor(outlineColor);
            Draw.drawPolyline(points, g);
        }
    }

    public static BufferedImage getHatchImage(HatchStyle style, int size, Color stripeColor, Color backColor) {
        BufferedImage bi = new BufferedImage(size, size, 2);
        Graphics2D g2 = bi.createGraphics();
        int alpha = backColor.getAlpha();
        if (alpha > 0) {
            g2.setColor(backColor);
            g2.fillRect(0, 0, size, size);
        }
        g2.setColor(stripeColor);
        switch (style) {
            case HORIZONTAL: {
                g2.drawLine(0, size / 2, size, size / 2);
                break;
            }
            case VERTICAL: {
                g2.drawLine(size / 2, 0, size / 2, size);
                break;
            }
            case FORWARD_DIAGONAL: {
                g2.drawLine(0, 0, size, size);
                break;
            }
            case BACKWARD_DIAGONAL: {
                g2.draw(new Line2D.Float(0.0f, size, size, 0.0f));
                break;
            }
            case CROSS: {
                g2.drawLine(0, size / 2, size, size / 2);
                g2.drawLine(size / 2, 0, size / 2, size);
                break;
            }
            case DIAGONAL_CROSS: {
                g2.drawLine(0, 0, size, size);
                g2.drawLine(0, size, size, 0);
                break;
            }
            case DOT: {
                g2.fill(new Ellipse2D.Float(size / 2, size / 2, 2.0f, 2.0f));
            }
        }
        return bi;
    }

    public static float[] getDashPattern(LineStyles style) {
        float[] dashPattern = new float[]{4.0f};
        switch (style) {
            case SOLID: {
                dashPattern = null;
                break;
            }
            case DASH: {
                dashPattern = new float[]{4.0f};
                break;
            }
            case DOT: {
                dashPattern = new float[]{2.0f};
                break;
            }
            case DASHDOT: {
                dashPattern = new float[]{10.0f, 6.0f, 2.0f, 6.0f};
                break;
            }
            case DASHDOTDOT: {
                dashPattern = new float[]{10.0f, 6.0f, 2.0f, 6.0f, 2.0f, 6.0f};
            }
        }
        return dashPattern;
    }

    public static void drawPolyline(PointF[] points, ArrowLineBreak alb, Graphics2D g) {
        int n = points.length;
        PointF aPoint = points[n - 2];
        PointF bPoint = points[n - 1];
        double U = bPoint.X - aPoint.X;
        double V = bPoint.Y - aPoint.Y;
        double radian = Math.atan(V / U);
        double angle = radian * 180.0 / Math.PI;
        angle += 90.0;
        if (U < 0.0) {
            angle += 180.0;
        }
        if (angle >= 360.0) {
            angle -= 360.0;
        }
        double dx = (double)alb.getArrowHeadLength() * Math.cos(radian) * (double)(1.0f - alb.getArrowOverhang());
        double dy = (double)alb.getArrowHeadLength() * Math.sin(radian) * (double)(1.0f - alb.getArrowOverhang());
        if (angle > 180.0) {
            dx = -dx;
            dy = -dy;
        }
        points[n - 1] = new PointF(bPoint.X - (float)dx, bPoint.Y - (float)dy);
        g.setColor(alb.getColor());
        float[] dashPattern = Draw.getDashPattern(alb.getStyle());
        g.setStroke(new BasicStroke(alb.getWidth(), 0, 0, 10.0f, dashPattern, 0.0f));
        Draw.drawPolyline(points, g);
        if (alb.getDrawSymbol()) {
            Object rend = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Rectangle clip = g.getClipBounds();
            if (clip != null) {
                g.setClip(null);
                for (int i = 0; i < points.length; ++i) {
                    PointF p = new PointF(points[i].X, points[i].Y);
                    if (!(p.X >= (float)clip.x) || !(p.X <= (float)(clip.x + clip.width)) || !(p.Y >= (float)clip.y) || !(p.Y <= (float)(clip.y + clip.height)) || i % alb.getSymbolInterval() != 0) continue;
                    Draw.drawPoint(alb.getSymbolStyle(), p, alb.getSymbolFillColor(), alb.getSymbolColor(), alb.getSymbolSize(), true, alb.isFillSymbol(), g);
                }
                g.setClip(clip);
            } else {
                for (int i = 0; i < points.length; ++i) {
                    if (i % alb.getSymbolInterval() != 0) continue;
                    PointF p = new PointF(points[i].X, points[i].Y);
                    Draw.drawPoint(alb.getSymbolStyle(), p, alb.getSymbolFillColor(), alb.getSymbolColor(), alb.getSymbolSize(), true, alb.isFillSymbol(), g);
                }
            }
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rend);
        }
        Draw.drawArraw(g, bPoint, angle, alb.getArrowHeadLength(), alb.getArrowHeadWidth(), alb.getArrowOverhang(), alb.getArrowFillColor(), alb.getArrowOutlineColor());
    }

    public static void drawPolyline(PointF[] points, PolylineBreak aPLB, Graphics2D g) {
        if (aPLB instanceof ArrowLineBreak) {
            Draw.drawPolyline(points, (ArrowLineBreak)aPLB, g);
            return;
        }
        if (aPLB.isUsingDashStyle()) {
            g.setColor(aPLB.getColor());
            float[] dashPattern = Draw.getDashPattern(aPLB.getStyle());
            g.setStroke(new BasicStroke(aPLB.getWidth(), 0, 0, 10.0f, dashPattern, 0.0f));
            Draw.drawPolyline(points, g);
            if (aPLB.getDrawSymbol()) {
                Object rend = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Rectangle clip = g.getClipBounds();
                if (clip != null) {
                    g.setClip(null);
                    for (int i = 0; i < points.length; ++i) {
                        PointF p = new PointF(points[i].X, points[i].Y);
                        if (!(p.X >= (float)clip.x) || !(p.X <= (float)(clip.x + clip.width)) || !(p.Y >= (float)clip.y) || !(p.Y <= (float)(clip.y + clip.height)) || i % aPLB.getSymbolInterval() != 0) continue;
                        Draw.drawPoint(aPLB.getSymbolStyle(), p, aPLB.getSymbolFillColor(), aPLB.getSymbolColor(), aPLB.getSymbolSize(), true, aPLB.isFillSymbol(), g);
                    }
                    g.setClip(clip);
                } else {
                    for (int i = 0; i < points.length; ++i) {
                        if (i % aPLB.getSymbolInterval() != 0) continue;
                        PointF p = new PointF(points[i].X, points[i].Y);
                        Draw.drawPoint(aPLB.getSymbolStyle(), p, aPLB.getSymbolFillColor(), aPLB.getSymbolColor(), aPLB.getSymbolSize(), true, aPLB.isFillSymbol(), g);
                    }
                }
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rend);
            }
        } else {
            Polyline aPLine = new Polyline();
            aPLine.setPoints(points);
            List<double[]> pos = aPLine.getPositions(30.0);
            float aSize = 16.0f;
            switch (aPLB.getStyle()) {
                case COLDFRONT: {
                    if (pos != null) {
                        PointBreak aPB = new PointBreak();
                        aPB.setSize(aSize);
                        aPB.setColor(Color.blue);
                        aPB.setStyle(PointStyle.UpTriangle);
                        aPB.setOutlineColor(Color.blue);
                        aPB.setDrawFill(true);
                        aPB.setDrawOutline(true);
                        for (int i = 0; i < pos.size(); ++i) {
                            aPB.setAngle((float)pos.get(i)[2]);
                            Draw.drawPoint_Simple_Up(new PointF((float)pos.get(i)[0], (float)pos.get(i)[1]), aPB, g);
                        }
                    }
                    g.setColor(Color.blue);
                    g.setStroke(new BasicStroke(aPLB.getWidth()));
                    Draw.drawPolyline(points, g);
                    break;
                }
                case WARMFRONT: {
                    if (pos != null) {
                        PointBreak aPB = new PointBreak();
                        aPB.setSize(aSize);
                        aPB.setColor(Color.red);
                        aPB.setStyle(PointStyle.UpSemiCircle);
                        aPB.setOutlineColor(Color.red);
                        aPB.setDrawFill(true);
                        aPB.setDrawOutline(true);
                        for (int i = 0; i < pos.size(); ++i) {
                            aPB.setAngle((float)pos.get(i)[2]);
                            Draw.drawPoint_Simple(new PointF((float)pos.get(i)[0], (float)pos.get(i)[1]), aPB, g);
                        }
                    }
                    g.setColor(Color.red);
                    g.setStroke(new BasicStroke(aPLB.getWidth()));
                    Draw.drawPolyline(points, g);
                    break;
                }
                case OCCLUDEDFRONT: {
                    Color aColor = new Color(255, 0, 255);
                    if (pos != null) {
                        int i;
                        PointBreak aPB = new PointBreak();
                        aPB.setSize(aSize);
                        aPB.setColor(aColor);
                        aPB.setStyle(PointStyle.UpTriangle);
                        aPB.setOutlineColor(aColor);
                        aPB.setDrawFill(true);
                        aPB.setDrawOutline(true);
                        for (i = 0; i < pos.size(); i += 2) {
                            aPB.setAngle((float)pos.get(i)[2]);
                            Draw.drawPoint_Simple_Up(new PointF((float)pos.get(i)[0], (float)pos.get(i)[1]), aPB, g);
                        }
                        aPB = new PointBreak();
                        aPB.setSize(aSize);
                        aPB.setColor(aColor);
                        aPB.setStyle(PointStyle.UpSemiCircle);
                        aPB.setOutlineColor(aColor);
                        aPB.setDrawFill(true);
                        aPB.setDrawOutline(true);
                        for (i = 1; i < pos.size(); i += 2) {
                            aPB.setAngle((float)pos.get(i)[2]);
                            Draw.drawPoint_Simple(new PointF((float)pos.get(i)[0], (float)pos.get(i)[1]), aPB, g);
                        }
                    }
                    g.setColor(aColor);
                    g.setStroke(new BasicStroke(aPLB.getWidth()));
                    Draw.drawPolyline(points, g);
                    break;
                }
                case STATIONARYFRONT: {
                    if (pos != null) {
                        int i;
                        PointBreak aPB = new PointBreak();
                        aPB.setSize(aSize);
                        aPB.setColor(Color.blue);
                        aPB.setStyle(PointStyle.UpTriangle);
                        aPB.setOutlineColor(Color.blue);
                        aPB.setDrawFill(true);
                        aPB.setDrawOutline(true);
                        for (i = 0; i < pos.size(); i += 2) {
                            aPB.setAngle((float)pos.get(i)[2]);
                            Draw.drawPoint_Simple_Up(new PointF((float)pos.get(i)[0], (float)pos.get(i)[1]), aPB, g);
                        }
                        aPB = new PointBreak();
                        aPB.setSize(aSize);
                        aPB.setColor(Color.red);
                        aPB.setStyle(PointStyle.DownSemiCircle);
                        aPB.setOutlineColor(Color.red);
                        aPB.setDrawFill(true);
                        aPB.setDrawOutline(true);
                        for (i = 1; i < pos.size(); i += 2) {
                            aPB.setAngle((float)pos.get(i)[2]);
                            Draw.drawPoint_Simple(new PointF((float)pos.get(i)[0], (float)pos.get(i)[1]), aPB, g);
                        }
                    }
                    g.setColor(Color.blue);
                    g.setStroke(new BasicStroke(aPLB.getWidth()));
                    Draw.drawPolyline(points, g);
                    break;
                }
                case ARROWLINE: {
                    g.setColor(aPLB.getColor());
                    g.setStroke(new BasicStroke(aPLB.getWidth()));
                    Draw.drawPolyline(points, g);
                    int n = points.length;
                    PointF aPoint = points[n - 2];
                    PointF bPoint = points[n - 1];
                    double U = bPoint.X - aPoint.X;
                    double V = bPoint.Y - aPoint.Y;
                    double angle = Math.atan(V / U) * 180.0 / Math.PI;
                    angle += 90.0;
                    if (U < 0.0) {
                        angle += 180.0;
                    }
                    if (angle >= 360.0) {
                        angle -= 360.0;
                    }
                    Draw.drawArraw(g, bPoint, angle, 8);
                }
            }
        }
    }

    public static void drawPolyline(PointF[] points, ColorBreakCollection pbc, Graphics2D g) {
        GeneralPath path = new GeneralPath(0, points.length);
        ArrayList<PointF> drawPs = new ArrayList<PointF>();
        for (int i = 0; i < points.length; ++i) {
            PointF p = points[i];
            if (i == 0) {
                path.moveTo(p.X, p.Y);
            } else {
                path.lineTo(p.X, p.Y);
                PolylineBreak aPLB = (PolylineBreak)pbc.get(i);
                Color aColor = aPLB.getColor();
                Float size = Float.valueOf(aPLB.getWidth());
                float[] dashPattern = Draw.getDashPattern(aPLB.getStyle());
                BasicStroke pen = new BasicStroke(size.floatValue(), 0, 0, 10.0f, dashPattern, 0.0f);
                g.setColor(aColor);
                g.setStroke(pen);
                g.draw(path);
                path.reset();
                path.moveTo(p.X, p.Y);
                if (aPLB.getDrawSymbol()) {
                    Object rend = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    for (int j = 0; j < drawPs.size(); ++j) {
                        Draw.drawPoint(aPLB.getSymbolStyle(), p, aPLB.getSymbolFillColor(), aPLB.getSymbolColor(), aPLB.getSymbolSize(), true, aPLB.isFillSymbol(), g);
                    }
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rend);
                }
            }
            drawPs.add(p);
        }
    }

    public static void drawPolyline(PointF[] points, PolylineBreak aPLB, Graphics2D g, List<Integer> mvIdx) {
        if (aPLB.isUsingDashStyle()) {
            g.setColor(aPLB.getColor());
            float[] dashPattern = Draw.getDashPattern(aPLB.getStyle());
            g.setStroke(new BasicStroke(aPLB.getWidth(), 0, 0, 10.0f, dashPattern, 0.0f));
            if (mvIdx.size() > 0) {
                Draw.drawPolyline(points, g, mvIdx);
            } else {
                Draw.drawPolyline(points, g);
            }
            if (aPLB.getDrawSymbol()) {
                Object rend = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Rectangle clip = g.getClipBounds();
                if (clip != null) {
                    g.setClip(null);
                    for (int i = 0; i < points.length; ++i) {
                        PointF p = new PointF(points[i].X, points[i].Y);
                        if (!(p.X >= (float)clip.x) || !(p.X <= (float)(clip.x + clip.width)) || !(p.Y >= (float)clip.y) || !(p.Y <= (float)(clip.y + clip.height)) || mvIdx.contains(i) || i % aPLB.getSymbolInterval() != 0) continue;
                        Draw.drawPoint(aPLB.getSymbolStyle(), p, aPLB.getSymbolFillColor(), aPLB.getSymbolColor(), aPLB.getSymbolSize(), true, aPLB.isFillSymbol(), g);
                    }
                    g.setClip(clip);
                } else {
                    for (int i = 0; i < points.length; ++i) {
                        if (mvIdx.contains(i) || i % aPLB.getSymbolInterval() != 0) continue;
                        PointF p = new PointF(points[i].X, points[i].Y);
                        Draw.drawPoint(aPLB.getSymbolStyle(), p, aPLB.getSymbolFillColor(), aPLB.getSymbolColor(), aPLB.getSymbolSize(), true, aPLB.isFillSymbol(), g);
                    }
                }
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rend);
            }
        } else {
            Polyline aPLine = new Polyline();
            aPLine.setPoints(points);
            List<double[]> pos = aPLine.getPositions(30.0);
            float aSize = 16.0f;
            switch (aPLB.getStyle()) {
                case COLDFRONT: {
                    if (pos != null) {
                        PointBreak aPB = new PointBreak();
                        aPB.setSize(aSize);
                        aPB.setColor(Color.blue);
                        aPB.setStyle(PointStyle.UpTriangle);
                        aPB.setOutlineColor(Color.blue);
                        aPB.setDrawFill(true);
                        aPB.setDrawOutline(true);
                        for (int i = 0; i < pos.size(); ++i) {
                            aPB.setAngle((float)pos.get(i)[2]);
                            Draw.drawPoint_Simple_Up(new PointF((float)pos.get(i)[0], (float)pos.get(i)[1]), aPB, g);
                        }
                    }
                    g.setColor(Color.blue);
                    g.setStroke(new BasicStroke(aPLB.getWidth()));
                    Draw.drawPolyline(points, g);
                    break;
                }
                case WARMFRONT: {
                    if (pos != null) {
                        PointBreak aPB = new PointBreak();
                        aPB.setSize(aSize);
                        aPB.setColor(Color.red);
                        aPB.setStyle(PointStyle.UpSemiCircle);
                        aPB.setOutlineColor(Color.red);
                        aPB.setDrawFill(true);
                        aPB.setDrawOutline(true);
                        for (int i = 0; i < pos.size(); ++i) {
                            aPB.setAngle((float)pos.get(i)[2]);
                            Draw.drawPoint_Simple(new PointF((float)pos.get(i)[0], (float)pos.get(i)[1]), aPB, g);
                        }
                    }
                    g.setColor(Color.red);
                    g.setStroke(new BasicStroke(aPLB.getWidth()));
                    Draw.drawPolyline(points, g);
                    break;
                }
                case OCCLUDEDFRONT: {
                    Color aColor = new Color(255, 0, 255);
                    if (pos != null) {
                        int i;
                        PointBreak aPB = new PointBreak();
                        aPB.setSize(aSize);
                        aPB.setColor(aColor);
                        aPB.setStyle(PointStyle.UpTriangle);
                        aPB.setOutlineColor(aColor);
                        aPB.setDrawFill(true);
                        aPB.setDrawOutline(true);
                        for (i = 0; i < pos.size(); i += 2) {
                            aPB.setAngle((float)pos.get(i)[2]);
                            Draw.drawPoint_Simple_Up(new PointF((float)pos.get(i)[0], (float)pos.get(i)[1]), aPB, g);
                        }
                        aPB = new PointBreak();
                        aPB.setSize(aSize);
                        aPB.setColor(aColor);
                        aPB.setStyle(PointStyle.UpSemiCircle);
                        aPB.setOutlineColor(aColor);
                        aPB.setDrawFill(true);
                        aPB.setDrawOutline(true);
                        for (i = 1; i < pos.size(); i += 2) {
                            aPB.setAngle((float)pos.get(i)[2]);
                            Draw.drawPoint_Simple(new PointF((float)pos.get(i)[0], (float)pos.get(i)[1]), aPB, g);
                        }
                    }
                    g.setColor(aColor);
                    g.setStroke(new BasicStroke(aPLB.getWidth()));
                    Draw.drawPolyline(points, g);
                    break;
                }
                case STATIONARYFRONT: {
                    if (pos != null) {
                        int i;
                        PointBreak aPB = new PointBreak();
                        aPB.setSize(aSize);
                        aPB.setColor(Color.blue);
                        aPB.setStyle(PointStyle.UpTriangle);
                        aPB.setOutlineColor(Color.blue);
                        aPB.setDrawFill(true);
                        aPB.setDrawOutline(true);
                        for (i = 0; i < pos.size(); i += 2) {
                            aPB.setAngle((float)pos.get(i)[2]);
                            Draw.drawPoint_Simple_Up(new PointF((float)pos.get(i)[0], (float)pos.get(i)[1]), aPB, g);
                        }
                        aPB = new PointBreak();
                        aPB.setSize(aSize);
                        aPB.setColor(Color.red);
                        aPB.setStyle(PointStyle.DownSemiCircle);
                        aPB.setOutlineColor(Color.red);
                        aPB.setDrawFill(true);
                        aPB.setDrawOutline(true);
                        for (i = 1; i < pos.size(); i += 2) {
                            aPB.setAngle((float)pos.get(i)[2]);
                            Draw.drawPoint_Simple(new PointF((float)pos.get(i)[0], (float)pos.get(i)[1]), aPB, g);
                        }
                    }
                    g.setColor(Color.blue);
                    g.setStroke(new BasicStroke(aPLB.getWidth()));
                    Draw.drawPolyline(points, g);
                }
            }
        }
    }

    public static void drawPolylineSymbol(PointF aP, float width, float height, PolylineBreak aPLB, Graphics2D g) {
        if (aPLB.isUsingDashStyle()) {
            PointF[] points = new PointF[4];
            PointF aPoint = new PointF(0.0f, 0.0f);
            aPoint.X = aP.X - width / 2.0f;
            aPoint.Y = aP.Y + height / 2.0f;
            points[0] = aPoint;
            aPoint = new PointF();
            aPoint.X = aP.X - width / 6.0f;
            aPoint.Y = aP.Y - height / 2.0f;
            points[1] = aPoint;
            aPoint = new PointF();
            aPoint.X = aP.X + width / 6.0f;
            aPoint.Y = aP.Y + height / 2.0f;
            points[2] = aPoint;
            aPoint = new PointF();
            aPoint.X = aP.X + width / 2.0f;
            aPoint.Y = aP.Y - height / 2.0f;
            points[3] = aPoint;
            g.setColor(aPLB.getColor());
            float[] dashPattern = Draw.getDashPattern(aPLB.getStyle());
            g.setStroke(new BasicStroke(aPLB.getWidth(), 0, 0, 10.0f, dashPattern, 0.0f));
            if (aPLB.getDrawPolyline()) {
                Draw.drawPolyline(points, g);
            }
            g.setStroke(new BasicStroke());
            if (aPLB.getDrawSymbol()) {
                Draw.drawPoint(aPLB.getSymbolStyle(), points[1], aPLB.getSymbolFillColor(), aPLB.getSymbolColor(), aPLB.getSymbolSize(), true, aPLB.isFillSymbol(), g);
                Draw.drawPoint(aPLB.getSymbolStyle(), points[2], aPLB.getSymbolFillColor(), aPLB.getSymbolColor(), aPLB.getSymbolSize(), true, aPLB.isFillSymbol(), g);
            }
        } else {
            PointF[] points = new PointF[2];
            PointF aPoint = new PointF(0.0f, 0.0f);
            aPoint.X = aP.X - width / 2.0f;
            aPoint.Y = aP.Y;
            points[0] = aPoint;
            aPoint = new PointF();
            aPoint.X = aP.X + width / 2.0f;
            aPoint.Y = aP.Y;
            points[1] = aPoint;
            float lineWidth = 2.0f;
            switch (aPLB.getStyle()) {
                case COLDFRONT: {
                    PointBreak aPB = new PointBreak();
                    aPB.setSize(14.0f);
                    aPB.setColor(Color.blue);
                    aPB.setStyle(PointStyle.UpTriangle);
                    aPB.setOutlineColor(Color.blue);
                    aPB.setDrawFill(true);
                    aPB.setDrawOutline(true);
                    Draw.drawPoint_Simple(new PointF(aP.X - aPB.getSize() * 2.0f / 3.0f, aP.Y - aPB.getSize() / 4.0f), aPB, g);
                    Draw.drawPoint_Simple(new PointF(aP.X + aPB.getSize() * 2.0f / 3.0f, aP.Y - aPB.getSize() / 4.0f), aPB, g);
                    g.setColor(Color.blue);
                    g.setStroke(new BasicStroke(lineWidth));
                    Draw.drawPolyline(points, g);
                    break;
                }
                case WARMFRONT: {
                    PointBreak aPB = new PointBreak();
                    aPB.setSize(14.0f);
                    aPB.setColor(Color.red);
                    aPB.setStyle(PointStyle.UpSemiCircle);
                    aPB.setOutlineColor(Color.red);
                    aPB.setDrawFill(true);
                    aPB.setDrawOutline(true);
                    Draw.drawPoint_Simple(new PointF(aP.X - aPB.getSize() * 2.0f / 3.0f, aP.Y), aPB, g);
                    Draw.drawPoint_Simple(new PointF(aP.X + aPB.getSize() * 2.0f / 3.0f, aP.Y), aPB, g);
                    g.setColor(Color.red);
                    g.setStroke(new BasicStroke(lineWidth));
                    Draw.drawPolyline(points, g);
                    break;
                }
                case OCCLUDEDFRONT: {
                    Color aColor = new Color(255, 0, 255);
                    PointBreak aPB = new PointBreak();
                    aPB.setSize(14.0f);
                    aPB.setColor(aColor);
                    aPB.setStyle(PointStyle.UpTriangle);
                    aPB.setOutlineColor(aColor);
                    aPB.setDrawFill(true);
                    aPB.setDrawOutline(true);
                    Draw.drawPoint_Simple(new PointF(aP.X - aPB.getSize() * 2.0f / 3.0f, aP.Y - aPB.getSize() / 4.0f), aPB, g);
                    aPB = new PointBreak();
                    aPB.setSize(14.0f);
                    aPB.setColor(aColor);
                    aPB.setStyle(PointStyle.UpSemiCircle);
                    aPB.setOutlineColor(aColor);
                    aPB.setDrawFill(true);
                    aPB.setDrawOutline(true);
                    Draw.drawPoint_Simple(new PointF(aP.X + aPB.getSize() * 2.0f / 3.0f, aP.Y), aPB, g);
                    g.setColor(aColor);
                    g.setStroke(new BasicStroke(lineWidth));
                    Draw.drawPolyline(points, g);
                    break;
                }
                case STATIONARYFRONT: {
                    PointBreak aPB = new PointBreak();
                    aPB.setSize(14.0f);
                    aPB.setColor(Color.blue);
                    aPB.setStyle(PointStyle.UpTriangle);
                    aPB.setOutlineColor(Color.blue);
                    aPB.setDrawFill(true);
                    aPB.setDrawOutline(true);
                    Draw.drawPoint_Simple(new PointF(aP.X - aPB.getSize() * 2.0f / 3.0f, aP.Y - aPB.getSize() / 4.0f), aPB, g);
                    aPB = new PointBreak();
                    aPB.setSize(14.0f);
                    aPB.setColor(Color.red);
                    aPB.setStyle(PointStyle.DownSemiCircle);
                    aPB.setOutlineColor(Color.red);
                    aPB.setDrawFill(true);
                    aPB.setDrawOutline(true);
                    Draw.drawPoint_Simple(new PointF(aP.X + aPB.getSize() * 2.0f / 3.0f, aP.Y), aPB, g);
                    g.setColor(Color.blue);
                    g.setStroke(new BasicStroke(lineWidth));
                    Draw.drawPolyline(points, g);
                    break;
                }
                case ARROWLINE: {
                    g.setColor(aPLB.getColor());
                    g.setStroke(new BasicStroke(lineWidth));
                    Draw.drawPolyline(points, g);
                    int n = points.length;
                    aPoint = points[n - 2];
                    PointF bPoint = points[n - 1];
                    double U = bPoint.X - aPoint.X;
                    double V = bPoint.Y - aPoint.Y;
                    double angle = Math.atan(V / U) * 180.0 / Math.PI;
                    angle += 90.0;
                    if (U < 0.0) {
                        angle += 180.0;
                    }
                    if (angle >= 360.0) {
                        angle -= 360.0;
                    }
                    Draw.drawArraw(g, bPoint, angle, 8);
                }
            }
        }
    }

    public static void drawPolylineSymbol_S(PointF aP, float width, float height, PolylineBreak aPLB, Graphics2D g) {
        if (aPLB.isUsingDashStyle()) {
            PointF[] points = new PointF[2];
            PointF aPoint = new PointF(0.0f, 0.0f);
            aPoint.X = aP.X - width / 2.0f;
            aPoint.Y = aP.Y;
            points[0] = aPoint;
            aPoint = new PointF();
            aPoint.X = aP.X + width / 2.0f;
            aPoint.Y = aP.Y;
            points[1] = aPoint;
            g.setColor(aPLB.getColor());
            float[] dashPattern = Draw.getDashPattern(aPLB.getStyle());
            g.setStroke(new BasicStroke(aPLB.getWidth(), 0, 0, 10.0f, dashPattern, 0.0f));
            if (aPLB.getDrawPolyline()) {
                Draw.drawPolyline(points, g);
            }
            g.setStroke(new BasicStroke());
            if (aPLB.getDrawSymbol()) {
                Draw.drawPoint(aPLB.getSymbolStyle(), aP, aPLB.getSymbolFillColor(), aPLB.getSymbolColor(), aPLB.getSymbolSize(), true, aPLB.isFillSymbol(), g);
            }
        } else {
            PointF[] points = new PointF[2];
            PointF aPoint = new PointF(0.0f, 0.0f);
            aPoint.X = aP.X - width / 2.0f;
            aPoint.Y = aP.Y;
            points[0] = aPoint;
            aPoint = new PointF();
            aPoint.X = aP.X + width / 2.0f;
            aPoint.Y = aP.Y;
            points[1] = aPoint;
            float lineWidth = 2.0f;
            switch (aPLB.getStyle()) {
                case COLDFRONT: {
                    PointBreak aPB = new PointBreak();
                    aPB.setSize(14.0f);
                    aPB.setColor(Color.blue);
                    aPB.setStyle(PointStyle.UpTriangle);
                    aPB.setOutlineColor(Color.blue);
                    aPB.setDrawFill(true);
                    aPB.setDrawOutline(true);
                    Draw.drawPoint_Simple(new PointF(aP.X - aPB.getSize() * 2.0f / 3.0f, aP.Y - aPB.getSize() / 4.0f), aPB, g);
                    Draw.drawPoint_Simple(new PointF(aP.X + aPB.getSize() * 2.0f / 3.0f, aP.Y - aPB.getSize() / 4.0f), aPB, g);
                    g.setColor(Color.blue);
                    g.setStroke(new BasicStroke(lineWidth));
                    Draw.drawPolyline(points, g);
                    break;
                }
                case WARMFRONT: {
                    PointBreak aPB = new PointBreak();
                    aPB.setSize(14.0f);
                    aPB.setColor(Color.red);
                    aPB.setStyle(PointStyle.UpSemiCircle);
                    aPB.setOutlineColor(Color.red);
                    aPB.setDrawFill(true);
                    aPB.setDrawOutline(true);
                    Draw.drawPoint_Simple(new PointF(aP.X - aPB.getSize() * 2.0f / 3.0f, aP.Y), aPB, g);
                    Draw.drawPoint_Simple(new PointF(aP.X + aPB.getSize() * 2.0f / 3.0f, aP.Y), aPB, g);
                    g.setColor(Color.red);
                    g.setStroke(new BasicStroke(lineWidth));
                    Draw.drawPolyline(points, g);
                    break;
                }
                case OCCLUDEDFRONT: {
                    Color aColor = new Color(255, 0, 255);
                    PointBreak aPB = new PointBreak();
                    aPB.setSize(14.0f);
                    aPB.setColor(aColor);
                    aPB.setStyle(PointStyle.UpTriangle);
                    aPB.setOutlineColor(aColor);
                    aPB.setDrawFill(true);
                    aPB.setDrawOutline(true);
                    Draw.drawPoint_Simple(new PointF(aP.X - aPB.getSize() * 2.0f / 3.0f, aP.Y - aPB.getSize() / 4.0f), aPB, g);
                    aPB = new PointBreak();
                    aPB.setSize(14.0f);
                    aPB.setColor(aColor);
                    aPB.setStyle(PointStyle.UpSemiCircle);
                    aPB.setOutlineColor(aColor);
                    aPB.setDrawFill(true);
                    aPB.setDrawOutline(true);
                    Draw.drawPoint_Simple(new PointF(aP.X + aPB.getSize() * 2.0f / 3.0f, aP.Y), aPB, g);
                    g.setColor(aColor);
                    g.setStroke(new BasicStroke(lineWidth));
                    Draw.drawPolyline(points, g);
                    break;
                }
                case STATIONARYFRONT: {
                    PointBreak aPB = new PointBreak();
                    aPB.setSize(14.0f);
                    aPB.setColor(Color.blue);
                    aPB.setStyle(PointStyle.UpTriangle);
                    aPB.setOutlineColor(Color.blue);
                    aPB.setDrawFill(true);
                    aPB.setDrawOutline(true);
                    Draw.drawPoint_Simple(new PointF(aP.X - aPB.getSize() * 2.0f / 3.0f, aP.Y - aPB.getSize() / 4.0f), aPB, g);
                    aPB = new PointBreak();
                    aPB.setSize(14.0f);
                    aPB.setColor(Color.red);
                    aPB.setStyle(PointStyle.DownSemiCircle);
                    aPB.setOutlineColor(Color.red);
                    aPB.setDrawFill(true);
                    aPB.setDrawOutline(true);
                    Draw.drawPoint_Simple(new PointF(aP.X + aPB.getSize() * 2.0f / 3.0f, aP.Y), aPB, g);
                    g.setColor(Color.blue);
                    g.setStroke(new BasicStroke(lineWidth));
                    Draw.drawPolyline(points, g);
                    break;
                }
                case ARROWLINE: {
                    g.setColor(aPLB.getColor());
                    g.setStroke(new BasicStroke(lineWidth));
                    Draw.drawPolyline(points, g);
                    int n = points.length;
                    aPoint = points[n - 2];
                    PointF bPoint = points[n - 1];
                    double U = bPoint.X - aPoint.X;
                    double V = bPoint.Y - aPoint.Y;
                    double angle = Math.atan(V / U) * 180.0 / Math.PI;
                    angle += 90.0;
                    if (U < 0.0) {
                        angle += 180.0;
                    }
                    if (angle >= 360.0) {
                        angle -= 360.0;
                    }
                    Draw.drawArraw(g, bPoint, angle, 8);
                }
            }
        }
    }

    public static void drawPolygonSymbol(double x, double y, double width, double height, PolygonBreak aPGB, Graphics2D g) {
        if (aPGB.isDrawFill()) {
            if (aPGB.isUsingHatchStyle()) {
                int size = aPGB.getStyleSize();
                BufferedImage bi = Draw.getHatchImage(aPGB.getStyle(), size, aPGB.getColor(), aPGB.getBackColor());
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, size, size);
                g.setPaint(new TexturePaint(bi, rect));
                g.fill(new Rectangle2D.Double(x, y, width, height));
            } else {
                g.setColor(aPGB.getColor());
                g.fill(new Rectangle2D.Double(x, y, width, height));
                g.draw(new Rectangle2D.Double(x, y, width, height));
            }
        }
        if (aPGB.isDrawOutline()) {
            g.setColor(aPGB.getOutlineColor());
            g.setStroke(new BasicStroke(aPGB.getOutlineSize()));
            g.draw(new Rectangle2D.Double(x, y, width, height));
        }
    }

    public static void drawPolygonSymbol(PointF aP, float width, float height, PolygonBreak aPGB, Graphics2D g) {
        aP.X -= width / 2.0f;
        aP.Y -= height / 2.0f;
        if (aPGB.isDrawFill()) {
            if (aPGB.isUsingHatchStyle()) {
                int size = aPGB.getStyleSize();
                BufferedImage bi = Draw.getHatchImage(aPGB.getStyle(), size, aPGB.getColor(), aPGB.getBackColor());
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, size, size);
                g.setPaint(new TexturePaint(bi, rect));
                g.fill(new Rectangle2D.Float(aP.X, aP.Y, width, height));
            } else {
                g.setColor(aPGB.getColor());
                g.fill(new Rectangle2D.Float(aP.X, aP.Y, width, height));
            }
        }
        if (aPGB.isDrawOutline()) {
            g.setColor(aPGB.getOutlineColor());
            g.setStroke(new BasicStroke(aPGB.getOutlineSize()));
            g.draw(new Rectangle2D.Float(aP.X, aP.Y, width, height));
        }
    }

    public static void drawPolygonSymbol(double x, double y, Color aColor, Color outlineColor, double width, double height, Boolean drawFill, Boolean drawOutline, Graphics2D g) {
        if (drawFill.booleanValue()) {
            g.setColor(aColor);
            g.fill(new Rectangle2D.Double(x, y, width, height));
            g.draw(new Rectangle2D.Double(x, y, width, height));
        }
        if (drawOutline.booleanValue()) {
            g.setColor(outlineColor);
            g.draw(new Rectangle2D.Double(x, y, width, height));
        }
    }

    public static void drawPolygonSymbol(PointF aP, Color aColor, Color outlineColor, float width, float height, Boolean drawFill, Boolean drawOutline, Graphics2D g) {
        aP.X -= width / 2.0f;
        aP.Y -= height / 2.0f;
        if (drawFill.booleanValue()) {
            g.setColor(aColor);
            g.fill(new Rectangle2D.Float(aP.X, aP.Y, width, height));
        }
        if (drawOutline.booleanValue()) {
            g.setColor(outlineColor);
            g.draw(new Rectangle2D.Float(aP.X, aP.Y, width, height));
        }
    }

    public static void drawRectangle(PointF aPoint, float width, float height, PolygonBreak aPGB, Graphics2D g) {
        Color aColor = aPGB.getColor();
        if (aPGB.isDrawFill()) {
            if (aPGB.isUsingHatchStyle()) {
                int size = aPGB.getStyleSize();
                BufferedImage bi = Draw.getHatchImage(aPGB.getStyle(), size, aPGB.getColor(), aPGB.getBackColor());
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, size, size);
                g.setPaint(new TexturePaint(bi, rect));
                g.fill(new Rectangle2D.Float(aPoint.X, aPoint.Y, width, height));
            } else {
                g.setColor(aColor);
                g.fill(new Rectangle2D.Float(aPoint.X, aPoint.Y, width, height));
            }
        }
        if (aPGB.isDrawOutline()) {
            g.setColor(aPGB.getOutlineColor());
            g.setStroke(new BasicStroke(aPGB.getOutlineSize()));
            g.draw(new Rectangle2D.Float(aPoint.X, aPoint.Y, width, height));
        }
    }

    public static void drawPie(PointF aPoint, float width, float height, float startAngle, float sweepAngle, PolygonBreak aPGB, Graphics2D g) {
        Color aColor = aPGB.getColor();
        if (aPGB.isDrawFill()) {
            g.setColor(aColor);
            g.fill(new Arc2D.Float(aPoint.X, aPoint.Y, width, height, startAngle, sweepAngle, 2));
        }
        if (aPGB.isDrawOutline()) {
            g.setColor(aPGB.getOutlineColor());
            g.setStroke(new BasicStroke(aPGB.getOutlineSize()));
            g.draw(new Arc2D.Float(aPoint.X, aPoint.Y, width, height, startAngle, sweepAngle, 2));
        }
    }

    public static void drawPie(PointF aPoint, float width, float height, float startAngle, float sweepAngle, PolygonBreak aPGB, float wedgeWidth, Graphics2D g) {
        Color aColor = aPGB.getColor();
        Arc2D.Float arc2D = new Arc2D.Float(aPoint.X, aPoint.Y, width, height, startAngle, sweepAngle, 2);
        Area area1 = new Area(arc2D);
        Ellipse2D.Float e2 = new Ellipse2D.Float(aPoint.X + wedgeWidth, aPoint.Y + wedgeWidth, width - wedgeWidth * 2.0f, height - wedgeWidth * 2.0f);
        Area area2 = new Area(e2);
        area1.subtract(area2);
        if (aPGB.isDrawFill()) {
            g.setColor(aColor);
            g.fill(area1);
        }
        if (aPGB.isDrawOutline()) {
            g.setColor(aPGB.getOutlineColor());
            g.setStroke(new BasicStroke(aPGB.getOutlineSize()));
            g.draw(area1);
        }
    }

    public static void drawCurveLine(PointF[] points, PolylineBreak aPLB, Graphics2D g) {
        int i;
        ArrayList<PointD> opoints = new ArrayList<PointD>();
        for (i = 0; i < points.length; ++i) {
            opoints.add(new PointD(points[i].X, points[i].Y));
        }
        PointD[] rPoints = Spline.cardinalSpline(opoints.toArray(new PointD[opoints.size()]), 5);
        PointF[] dPoints = new PointF[rPoints.length];
        for (i = 0; i < dPoints.length; ++i) {
            dPoints[i] = new PointF((float)rPoints[i].X, (float)rPoints[i].Y);
        }
        Draw.drawPolyline(dPoints, aPLB, g);
    }

    public static void drawCurveLine(List<PointF> points, Graphics2D g) {
        int i;
        PointD[] opoints = new PointD[points.size()];
        for (i = 0; i < points.size(); ++i) {
            opoints[i] = new PointD(points.get((int)i).X, points.get((int)i).Y);
        }
        PointD[] rPoints = Spline.cardinalSpline(opoints, 5);
        PointF[] dPoints = new PointF[rPoints.length];
        for (i = 0; i < dPoints.length; ++i) {
            dPoints[i] = new PointF((float)rPoints[i].X, (float)rPoints[i].Y);
        }
        Draw.drawPolyline(dPoints, g);
    }

    public static void drawCurveLine(PointF[] points, Graphics2D g) {
        int i;
        ArrayList<PointD> opoints = new ArrayList<PointD>();
        for (i = 0; i < points.length; ++i) {
            opoints.add(new PointD(points[i].X, points[i].Y));
        }
        PointD[] rPoints = Spline.cardinalSpline((PointD[])opoints.toArray(), 5);
        PointF[] dPoints = new PointF[rPoints.length];
        for (i = 0; i < dPoints.length; ++i) {
            dPoints[i] = new PointF((float)rPoints[i].X, (float)rPoints[i].Y);
        }
        Draw.drawPolyline(dPoints, g);
    }

    public static void drawCurvePolygon(PointF[] points, PolygonBreak aPGB, Graphics2D g) {
        int i;
        ArrayList<PointD> opoints = new ArrayList<PointD>();
        for (i = 0; i < points.length; ++i) {
            opoints.add(new PointD(points[i].X, points[i].Y));
        }
        PointD[] rPoints = Spline.cardinalSpline(opoints.toArray(new PointD[opoints.size()]), 5);
        PointF[] dPoints = new PointF[rPoints.length];
        for (i = 0; i < dPoints.length; ++i) {
            dPoints[i] = new PointF((float)rPoints[i].X, (float)rPoints[i].Y);
        }
        Draw.drawPolygon(dPoints, aPGB, g);
    }

    public static void drawCircle(PointF[] points, PolygonBreak aPGB, Graphics2D g) {
        float radius = Math.abs(points[1].X - points[0].X);
        if (aPGB.isDrawFill()) {
            g.setColor(aPGB.getColor());
            g.fill(new Ellipse2D.Float(points[0].X, points[0].Y - radius, radius * 2.0f, radius * 2.0f));
        }
        if (aPGB.isDrawOutline()) {
            g.setColor(aPGB.getOutlineColor());
            g.setStroke(new BasicStroke(aPGB.getOutlineSize()));
            g.draw(new Ellipse2D.Float(points[0].X, points[0].Y - radius, radius * 2.0f, radius * 2.0f));
        }
    }

    public static void drawEllipse(PointF[] points, float angle, PolygonBreak aPGB, Graphics2D g) {
        float sx = Math.min(points[0].X, points[2].X);
        float sy = Math.min(points[0].Y, points[2].Y);
        float width = Math.abs(points[2].X - points[0].X);
        float height = Math.abs(points[2].Y - points[0].Y);
        if (angle != 0.0f) {
            AffineTransform tempTrans = g.getTransform();
            AffineTransform myTrans = (AffineTransform)tempTrans.clone();
            myTrans.translate(sx + width / 2.0f, sy + height / 2.0f);
            myTrans.rotate(Math.toRadians(angle));
            g.setTransform(myTrans);
            if (aPGB.isDrawFill()) {
                g.setColor(aPGB.getColor());
                g.fill(new Ellipse2D.Float(-width / 2.0f, -height / 2.0f, width, height));
            }
            if (aPGB.isDrawOutline()) {
                g.setColor(aPGB.getOutlineColor());
                g.setStroke(new BasicStroke(aPGB.getOutlineSize()));
                g.draw(new Ellipse2D.Float(-width / 2.0f, -height / 2.0f, width, height));
            }
            g.setTransform(tempTrans);
        } else {
            if (aPGB.isDrawFill()) {
                g.setColor(aPGB.getColor());
                g.fill(new Ellipse2D.Float(sx, sy, width, height));
            }
            if (aPGB.isDrawOutline()) {
                g.setColor(aPGB.getOutlineColor());
                g.setStroke(new BasicStroke(aPGB.getOutlineSize()));
                g.draw(new Ellipse2D.Float(sx, sy, width, height));
            }
        }
    }

    public static void drawEllipse(PointF[] points, PolygonBreak aPGB, Graphics2D g) {
        float sx = Math.min(points[0].X, points[2].X);
        float sy = Math.min(points[0].Y, points[2].Y);
        float width = Math.abs(points[2].X - points[0].X);
        float height = Math.abs(points[2].Y - points[0].Y);
        if (aPGB.isDrawFill()) {
            g.setColor(aPGB.getColor());
            g.fill(new Ellipse2D.Float(sx, sy, width, height));
        }
        if (aPGB.isDrawOutline()) {
            g.setColor(aPGB.getOutlineColor());
            g.setStroke(new BasicStroke(aPGB.getOutlineSize()));
            g.draw(new Ellipse2D.Float(sx, sy, width, height));
        }
    }

    public static void drawSelectedVertices(Graphics2D g, PointF[] points) {
        Draw.drawSelectedVertices(g, points, 6.0f, Color.black, Color.cyan);
    }

    public static void drawSelectedVertices(Graphics2D g, PointF[] points, float size, Color outlineColor, Color fillColor) {
        Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, size, size);
        for (PointF aPoint : points) {
            rect.x = aPoint.X - size / 2.0f;
            rect.y = aPoint.Y - size / 2.0f;
            g.setColor(fillColor);
            g.fill(rect);
            g.setColor(outlineColor);
            g.setStroke(new BasicStroke(1.0f));
            g.draw(rect);
        }
    }

    public static void drawSelectedVertice(Graphics2D g, PointF point, float size, Color outlineColor, Color fillColor) {
        Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, size, size);
        rect.x = point.X - size / 2.0f;
        rect.y = point.Y - size / 2.0f;
        g.setColor(fillColor);
        g.fill(rect);
        g.setColor(outlineColor);
        g.setStroke(new BasicStroke(1.0f));
        g.draw(rect);
    }

    public static void drawSelectedCorners(Graphics2D g, Rectangle gRect) {
        int size = 6;
        Rectangle rect = new Rectangle(gRect.x - size / 2, gRect.y - size / 2, size, size);
        g.setColor(Color.cyan);
        g.fill(rect);
        g.setColor(Color.black);
        g.draw(rect);
        rect.y = gRect.y + gRect.height - size / 2;
        g.setColor(Color.cyan);
        g.fill(rect);
        g.setColor(Color.black);
        g.draw(rect);
        rect.x = gRect.x + gRect.width - size / 2;
        g.setColor(Color.cyan);
        g.fill(rect);
        g.setColor(Color.black);
        g.draw(rect);
        rect.y = gRect.y - size / 2;
        g.setColor(Color.cyan);
        g.fill(rect);
        g.setColor(Color.black);
        g.draw(rect);
    }

    public static void drawSelectedEdgeCenters(Graphics2D g, Rectangle gRect) {
        int size = 6;
        Rectangle rect = new Rectangle(gRect.x + gRect.width / 2 - size / 2, gRect.y - size / 2, size, size);
        g.setColor(Color.cyan);
        g.fill(rect);
        g.setColor(Color.black);
        g.draw(rect);
        rect.y = gRect.y + gRect.height - size / 2;
        g.setColor(Color.cyan);
        g.fill(rect);
        g.setColor(Color.black);
        g.draw(rect);
        rect.x = gRect.x - size / 2;
        rect.y = gRect.y + gRect.height / 2 - size / 2;
        g.setColor(Color.cyan);
        g.fill(rect);
        g.setColor(Color.black);
        g.draw(rect);
        rect.x = gRect.x + gRect.width - size / 2;
        g.setColor(Color.cyan);
        g.fill(rect);
        g.setColor(Color.black);
        g.draw(rect);
    }

    public static void drawChartPoint(PointF aPoint, ChartBreak aCB, Graphics2D g) {
        switch (aCB.getChartType()) {
            case BarChart: {
                Draw.drawBarChartSymbol(aPoint, aCB, g);
                break;
            }
            case PieChart: {
                ArrayList<String> rStrs = null;
                if (aCB.isDrawLabel()) {
                    List<Float> ratios = aCB.getPieRatios();
                    rStrs = new ArrayList<String>();
                    for (float r : ratios) {
                        rStrs.add(String.valueOf((int)(r * 100.0f)) + "%");
                    }
                }
                Draw.drawPieChartSymbol(aPoint, aCB, g, rStrs);
            }
        }
    }

    public static void drawBarChartSymbol(PointF aPoint, ChartBreak aCB, Graphics2D g) {
        Font font = new Font("Arial", 0, 8);
        Draw.drawBarChartSymbol(aPoint, aCB, g, false, font);
    }

    public static void drawBarChartSymbol(PointF aPoint, ChartBreak aCB, Graphics2D g, boolean drawValue) {
        Draw.drawBarChartSymbol(aPoint, aCB, g, drawValue, g.getFont());
    }

    public static void drawBarChartSymbol(PointF sPoint, ChartBreak aCB, Graphics2D g, boolean drawValue, Font font) {
        PointF aPoint = (PointF)sPoint.clone();
        List<Integer> heights = aCB.getBarHeights();
        float y = aPoint.Y;
        for (int i = 0; i < heights.size(); ++i) {
            if (heights.get(i) <= 0) {
                aPoint.X += (float)aCB.getBarWidth();
                continue;
            }
            aPoint.Y = y - (float)heights.get(i).intValue();
            PolygonBreak aPGB = (PolygonBreak)aCB.getLegendScheme().getLegendBreaks().get(i);
            if (aCB.isView3D()) {
                PointF[] points;
                Color aColor = ColorUtil.modifyBrightness(aPGB.getColor(), 0.5f);
                points = new PointF[]{new PointF(aPoint.X, aPoint.Y), new PointF(aPoint.X + (float)aCB.getBarWidth(), aPoint.Y), new PointF(points[1].X + (float)aCB.getThickness(), points[1].Y - (float)aCB.getThickness()), new PointF(points[0].X + (float)aCB.getThickness(), points[0].Y - (float)aCB.getThickness())};
                g.setColor(aColor);
                Draw.fillPolygon(points, g, aPGB);
                g.setColor(aPGB.getOutlineColor());
                Draw.drawPolyline(points, g);
                points[0] = new PointF(aPoint.X + (float)aCB.getBarWidth(), aPoint.Y);
                points[1] = new PointF(aPoint.X + (float)aCB.getBarWidth(), aPoint.Y + (float)heights.get(i).intValue());
                points[2] = new PointF(points[1].X + (float)aCB.getThickness(), points[1].Y - (float)aCB.getThickness());
                points[3] = new PointF(points[0].X + (float)aCB.getThickness(), points[0].Y - (float)aCB.getThickness());
                g.setColor(aColor);
                Draw.fillPolygon(points, g, aPGB);
                g.setColor(aPGB.getOutlineColor());
                Draw.drawPolyline(points, g);
            }
            Draw.drawRectangle(aPoint, aCB.getBarWidth(), heights.get(i).intValue(), aPGB, g);
            aPoint.X += (float)aCB.getBarWidth();
            if (i != heights.size() - 1 || !drawValue) continue;
            String formatStr = "%1$." + String.valueOf(aCB.getDecimalDigits()) + "f";
            String vstr = String.format(formatStr, aCB.getChartData().get(i));
            FontMetrics metrics = g.getFontMetrics(font);
            Dimension labSize = new Dimension(metrics.stringWidth(vstr), metrics.getHeight());
            aPoint.X += 5.0f;
            aPoint.Y = y - (float)(heights.get(i) / 2);
            g.setColor(Color.black);
            g.setFont(font);
            g.drawString(vstr, aPoint.X, aPoint.Y + (float)(metrics.getHeight() / 2));
        }
    }

    public static void drawBar(PointF aPoint, int width, int height, PolygonBreak aPGB, Graphics2D g, boolean isView3D, int thickness) {
        Draw.drawBar(aPoint, (float)width, (float)height, aPGB, g, isView3D, thickness);
    }

    public static void drawBar(PointF aPoint, float width, float height, PolygonBreak aPGB, Graphics2D g, boolean isView3D, int thickness) {
        float y = aPoint.Y;
        aPoint.Y = y - height;
        if (isView3D) {
            PointF[] points;
            Color aColor = ColorUtil.modifyBrightness(aPGB.getColor(), 0.5f);
            points = new PointF[]{new PointF(aPoint.X, aPoint.Y), new PointF(aPoint.X + width, aPoint.Y), new PointF(points[1].X + (float)thickness, points[1].Y - (float)thickness), new PointF(points[0].X + (float)thickness, points[0].Y - (float)thickness)};
            g.setColor(aColor);
            Draw.fillPolygon(points, g, aPGB);
            g.setColor(aPGB.getOutlineColor());
            Draw.drawPolyline(points, g);
            points[0] = new PointF(aPoint.X + width, aPoint.Y);
            points[1] = new PointF(aPoint.X + width, aPoint.Y + height);
            points[2] = new PointF(points[1].X + (float)thickness, points[1].Y - (float)thickness);
            points[3] = new PointF(points[0].X + (float)thickness, points[0].Y - (float)thickness);
            g.setColor(aColor);
            Draw.fillPolygon(points, g, aPGB);
            g.setColor(aPGB.getOutlineColor());
            Draw.drawPolyline(points, g);
        }
        Draw.drawRectangle(aPoint, width, height, aPGB, g);
    }

    public static void drawPieChartSymbol(PointF aPoint, ChartBreak aCB, Graphics2D g, List<String> labels) {
        block18: {
            float sweepAngle;
            float startAngle;
            int i;
            List<List<Float>> angles;
            PointF sPoint;
            int width;
            block17: {
                PolygonBreak aPGB;
                float sweepAngle2;
                float startAngle2;
                int i2;
                width = aCB.getWidth();
                int height = aCB.getHeight();
                if (width <= 0 || height <= 0) {
                    return;
                }
                sPoint = new PointF(aPoint.X + (float)(width / 2), aPoint.Y - (float)(height / 2));
                aPoint.Y -= (float)height;
                angles = aCB.getPieAngles();
                if (!aCB.isView3D()) break block17;
                aPoint.Y = aPoint.Y + (float)(width / 6) - (float)aCB.getThickness();
                for (i2 = 0; i2 < angles.size(); ++i2) {
                    startAngle2 = angles.get(i2).get(0).floatValue();
                    sweepAngle2 = angles.get(i2).get(1).floatValue();
                    PolygonBreak aPGB2 = (PolygonBreak)aCB.getLegendScheme().getLegendBreaks().get(i2);
                    if (!(startAngle2 + sweepAngle2 > 180.0f)) continue;
                    PointF bPoint = new PointF(aPoint.X, aPoint.Y + (float)aCB.getThickness());
                    Color aColor = ColorUtil.modifyBrightness(aPGB2.getColor(), 0.5f);
                    g.setColor(aColor);
                    g.fill(new Arc2D.Float(bPoint.X, bPoint.Y, width, width * 2 / 3, startAngle2, sweepAngle2, 2));
                    g.setColor(aPGB2.getOutlineColor());
                    g.draw(new Arc2D.Float(bPoint.X, bPoint.Y, width, width * 2 / 3, startAngle2, sweepAngle2, 2));
                }
                float a = (float)width / 2.0f;
                float b = (float)width / 3.0f;
                float x0 = aPoint.X + a;
                float y0 = aPoint.Y + b;
                for (i2 = 0; i2 < angles.size(); ++i2) {
                    startAngle2 = angles.get(i2).get(0).floatValue();
                    if (!(startAngle2 + (sweepAngle2 = angles.get(i2).get(1).floatValue()) > 180.0f)) continue;
                    double sA = (double)((360.0f - startAngle2) / 180.0f) * Math.PI;
                    double eA = (double)((360.0f - (startAngle2 + sweepAngle2)) / 180.0f) * Math.PI;
                    aPGB = (PolygonBreak)aCB.getLegendScheme().getLegendBreaks().get(i2);
                    PointF bPoint = MIMath.calEllipseCoordByAngle(x0, y0, a, b, eA);
                    PointF cPoint = new PointF(x0 - a, y0);
                    if (sA < Math.PI) {
                        cPoint = MIMath.calEllipseCoordByAngle(x0, y0, a, b, sA);
                    }
                    Color aColor = ColorUtil.modifyBrightness(aPGB.getColor(), 0.5f);
                    PointF[] points = new PointF[]{cPoint, new PointF(cPoint.X, cPoint.Y + (float)aCB.getThickness()), new PointF(bPoint.X, bPoint.Y + (float)aCB.getThickness()), bPoint, cPoint};
                    g.setColor(aColor);
                    Draw.fillPolygon(points, g, aPGB);
                    g.setColor(aPGB.getOutlineColor());
                    g.draw(new Line2D.Float(points[0].X, points[0].Y, points[1].X, points[1].Y));
                    g.draw(new Line2D.Float(points[2].X, points[2].Y, points[3].X, points[3].Y));
                }
                for (i2 = 0; i2 < angles.size(); ++i2) {
                    startAngle2 = angles.get(i2).get(0).floatValue();
                    sweepAngle2 = angles.get(i2).get(1).floatValue();
                    aPGB = (PolygonBreak)aCB.getLegendScheme().getLegendBreaks().get(i2);
                    Draw.drawPie(aPoint, width, width * 2 / 3, startAngle2, sweepAngle2, aPGB, g);
                }
                break block18;
            }
            for (i = 0; i < angles.size(); ++i) {
                startAngle = angles.get(i).get(0).floatValue();
                sweepAngle = angles.get(i).get(1).floatValue();
                PolygonBreak aPGB = (PolygonBreak)aCB.getLegendScheme().getLegendBreaks().get(i);
                Draw.drawPie(aPoint, width, width, startAngle, sweepAngle, aPGB, g);
            }
            if (labels == null) break block18;
            FontMetrics metrics = g.getFontMetrics();
            for (i = 0; i < angles.size(); ++i) {
                String label = labels.get(i);
                if (label.equals("0%")) continue;
                startAngle = angles.get(i).get(0).floatValue();
                sweepAngle = angles.get(i).get(1).floatValue();
                float angle = startAngle + sweepAngle / 2.0f;
                PointF lPoint = Draw.getPieLabelPoint(sPoint, width / 2, angle);
                float x = lPoint.X;
                float y = lPoint.Y;
                float h = metrics.getHeight();
                float w = metrics.stringWidth(label);
                if (angle >= 0.0f && angle < 45.0f || angle >= 315.0f && angle <= 360.0f) {
                    x += 3.0f;
                    y += h / 2.0f;
                } else if (angle >= 45.0f && angle < 90.0f) {
                    y -= 3.0f;
                } else if (angle >= 90.0f && angle < 135.0f) {
                    x = x - w - 3.0f;
                    y -= 3.0f;
                } else if (angle >= 135.0f && angle < 225.0f) {
                    x = x - w - 3.0f;
                    y += h / 2.0f;
                } else if (angle >= 225.0f && angle < 270.0f) {
                    x = x - w - 3.0f;
                    y += h / 2.0f;
                } else {
                    y += h;
                }
                g.drawString(label, x, y);
            }
        }
    }

    public static PointF getPieLabelPoint(PointF sPoint, float r, float angle) {
        float x = (float)((double)sPoint.X + (double)r * Math.cos((double)angle * Math.PI / 180.0));
        float y = (float)((double)sPoint.Y - (double)r * Math.sin((double)angle * Math.PI / 180.0));
        return new PointF(x, y);
    }
}

