/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geoprocess;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.meteoinfo.geoprocess.GeoComputation;
import org.meteoinfo.global.PointD;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.shape.PolygonShape;
import org.meteoinfo.shape.Shape;

public class GeometryUtil {
    public static PointD getEllipseXY(double x0, double y0, double a, double b, double angle) {
        double rangle = Math.toRadians(angle);
        double x = a * b / Math.sqrt(b * b + a * a * Math.tan(rangle) * Math.tan(rangle));
        if (angle > 90.0 && angle < 270.0) {
            x = -x;
        }
        double y = Math.tan(rangle) * x;
        if (angle > 0.0 && angle < 180.0) {
            y = -Math.abs(y);
        }
        return new PointD(x + x0, y + y0);
    }

    public static List<PointD> getEllipseCoordinates(double x0, double y0, double a, double b, double deltaAngle) {
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (double angle = 0.0; angle <= 360.0; angle += deltaAngle) {
            points.add(GeometryUtil.getEllipseXY(x0, y0, a, b, angle));
        }
        return points;
    }

    public static List<PointD> getEllipseCoordinates(double x0, double y0, double a, double b) {
        ArrayList<PointD> points = new ArrayList<PointD>();
        double deltaAngle = 1.0;
        for (double angle = 0.0; angle <= 360.0; angle += deltaAngle) {
            points.add(GeometryUtil.getEllipseXY(x0, y0, a, b, angle));
        }
        return points;
    }

    public static PolygonShape convexHull(Array x, Array y) {
        int n = (int)x.getSize();
        Geometry[] geos = new Geometry[n];
        GeometryFactory factory = new GeometryFactory();
        for (int i = 0; i < n; ++i) {
            Coordinate c = new Coordinate(x.getDouble(i), y.getDouble(i));
            geos[i] = factory.createPoint(c);
        }
        GeometryCollection gs = factory.createGeometryCollection(geos);
        Geometry ch = gs.convexHull();
        return new PolygonShape(ch);
    }

    public static Array inPolygon(Array a, List<Number> x, List<Number> y, VectorLayer layer) {
        List<? extends Shape> polygons = layer.getShapes();
        return GeometryUtil.inPolygon(a, x, y, polygons);
    }

    public static Array inPolygon(Array a, List<Number> x, List<Number> y, PolygonShape ps) {
        ArrayList<PolygonShape> polygons = new ArrayList<PolygonShape>();
        polygons.add(ps);
        return GeometryUtil.inPolygon(a, x, y, polygons);
    }

    public static Array inPolygon(Array a, List<Number> x, List<Number> y, List<PolygonShape> polygons) {
        if (a.getRank() == 2) {
            int xNum = x.size();
            int yNum = y.size();
            Array r = Array.factory(DataType.INT, a.getShape());
            for (int i = 0; i < yNum; ++i) {
                for (int j = 0; j < xNum; ++j) {
                    if (GeoComputation.pointInPolygons(polygons, new PointD(x.get(j).doubleValue(), y.get(i).doubleValue()))) {
                        r.setInt(i * xNum + j, 1);
                        continue;
                    }
                    r.setInt(i * xNum + j, -1);
                }
            }
            return r;
        }
        if (a.getRank() == 1) {
            int n = x.size();
            Array r = Array.factory(DataType.INT, a.getShape());
            for (int i = 0; i < n; ++i) {
                if (GeoComputation.pointInPolygons(polygons, new PointD(x.get(i).doubleValue(), y.get(i).doubleValue()))) {
                    r.setInt(i, 1);
                    continue;
                }
                r.setInt(i, -1);
            }
            return r;
        }
        return null;
    }

    public static Array inPolygon(Array x, Array y, List<PolygonShape> polygons) {
        Array r = Array.factory(DataType.BOOLEAN, x.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            if (GeoComputation.pointInPolygons(polygons, new PointD(x.getDouble(i), y.getDouble(i)))) {
                r.setBoolean(i, true);
            } else {
                r.setBoolean(i, false);
            }
            ++i;
        }
        return r;
    }

    public static Array inPolygon(Array a, List<Number> x, List<Number> y, List<Number> x_p, List<Number> y_p) {
        PolygonShape ps = new PolygonShape();
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (int i = 0; i < x_p.size(); ++i) {
            points.add(new PointD(x_p.get(i).doubleValue(), y_p.get(i).doubleValue()));
        }
        ps.setPoints(points);
        ArrayList<PolygonShape> shapes = new ArrayList<PolygonShape>();
        shapes.add(ps);
        return GeometryUtil.inPolygon(a, x, y, shapes);
    }

    public static Array inPolygon(Array x, Array y, Array x_p, Array y_p) {
        PolygonShape ps = new PolygonShape();
        ArrayList<PointD> points = new ArrayList<PointD>();
        int i = 0;
        while ((long)i < x_p.getSize()) {
            points.add(new PointD(x_p.getDouble(i), y_p.getDouble(i)));
            ++i;
        }
        ps.setPoints(points);
        ArrayList<PolygonShape> shapes = new ArrayList<PolygonShape>();
        shapes.add(ps);
        return GeometryUtil.inPolygon(x, y, shapes);
    }

    public static Array maskout(Array a, List<Number> x, List<Number> y, VectorLayer layer, Number missingValue) {
        List<? extends Shape> polygons = layer.getShapes();
        return GeometryUtil.maskout(a, x, y, polygons, missingValue);
    }

    public static Array maskout(Array a, List<Number> x, List<Number> y, PolygonShape polygon, Number missingValue) {
        ArrayList<PolygonShape> polygons = new ArrayList<PolygonShape>();
        polygons.add(polygon);
        return GeometryUtil.maskout(a, x, y, polygons, missingValue);
    }

    public static Array maskout(Array a, Array x, Array y, List<PolygonShape> polygons) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (GeoComputation.pointInPolygons(polygons, new PointD(x.getDouble(i), y.getDouble(i)))) {
                r.setObject(i, a.getObject(i));
            } else {
                r.setObject(i, (Object)Double.NaN);
            }
            ++i;
        }
        return r;
    }

    public static Array maskin(Array a, Array x, Array y, List<PolygonShape> polygons) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (GeoComputation.pointInPolygons(polygons, new PointD(x.getDouble(i), y.getDouble(i)))) {
                r.setObject(i, (Object)Double.NaN);
            } else {
                r.setObject(i, a.getObject(i));
            }
            ++i;
        }
        return r;
    }

    public static Array[] maskout_Remove(Array a, Array x, Array y, List<PolygonShape> polygons) {
        ArrayList<Object> rdata = new ArrayList<Object>();
        ArrayList<Double> rxdata = new ArrayList<Double>();
        ArrayList<Double> rydata = new ArrayList<Double>();
        int i = 0;
        while ((long)i < a.getSize()) {
            if (GeoComputation.pointInPolygons(polygons, new PointD(x.getDouble(i), y.getDouble(i)))) {
                rdata.add(a.getObject(i));
                rxdata.add(x.getDouble(i));
                rydata.add(y.getDouble(i));
            }
            ++i;
        }
        int n = rdata.size();
        int[] shape = new int[]{n};
        Array r = Array.factory(a.getDataType(), shape);
        Array rx = Array.factory(x.getDataType(), shape);
        Array ry = Array.factory(y.getDataType(), shape);
        for (int i2 = 0; i2 < n; ++i2) {
            r.setObject(i2, rdata.get(i2));
            rx.setDouble(i2, (double)((Double)rxdata.get(i2)));
            ry.setDouble(i2, (double)((Double)rydata.get(i2)));
        }
        return new Array[]{r, rx, ry};
    }

    public static Array[] maskin_Remove(Array a, Array x, Array y, List<PolygonShape> polygons) {
        ArrayList<Object> rdata = new ArrayList<Object>();
        ArrayList<Double> rxdata = new ArrayList<Double>();
        ArrayList<Double> rydata = new ArrayList<Double>();
        int i = 0;
        while ((long)i < a.getSize()) {
            if (!GeoComputation.pointInPolygons(polygons, new PointD(x.getDouble(i), y.getDouble(i)))) {
                rdata.add(a.getObject(i));
                rxdata.add(x.getDouble(i));
                rydata.add(y.getDouble(i));
            }
            ++i;
        }
        int n = rdata.size();
        int[] shape = new int[]{n};
        Array r = Array.factory(a.getDataType(), shape);
        Array rx = Array.factory(x.getDataType(), shape);
        Array ry = Array.factory(y.getDataType(), shape);
        for (int i2 = 0; i2 < n; ++i2) {
            r.setObject(i2, rdata.get(i2));
            rx.setDouble(i2, (double)((Double)rxdata.get(i2)));
            ry.setDouble(i2, (double)((Double)rydata.get(i2)));
        }
        return new Array[]{r, rx, ry};
    }

    public static Array maskout(Array a, List<Number> x, List<Number> y, List<PolygonShape> polygons) {
        return GeometryUtil.maskout(a, x, y, polygons, (Number)Double.NaN);
    }

    public static Array maskout(Array a, List<Number> x, List<Number> y, List<PolygonShape> polygons, Number missingValue) {
        Array r;
        block6: {
            int yNum;
            int xNum;
            block5: {
                xNum = x.size();
                yNum = y.size();
                r = Array.factory(a.getDataType(), a.getShape());
                if (a.getRank() != 1) break block5;
                for (int i = 0; i < xNum; ++i) {
                    if (GeoComputation.pointInPolygons(polygons, new PointD(x.get(i).doubleValue(), y.get(i).doubleValue()))) {
                        r.setObject(i, a.getObject(i));
                        continue;
                    }
                    r.setObject(i, (Object)missingValue);
                }
                break block6;
            }
            if (a.getRank() != 2) break block6;
            for (int i = 0; i < yNum; ++i) {
                for (int j = 0; j < xNum; ++j) {
                    int idx = i * xNum + j;
                    if (GeoComputation.pointInPolygons(polygons, new PointD(x.get(j).doubleValue(), y.get(i).doubleValue()))) {
                        r.setObject(idx, a.getObject(idx));
                        continue;
                    }
                    r.setObject(idx, (Object)missingValue);
                }
            }
        }
        return r;
    }

    public static Array maskout(Array a, Array m, Number missingValue) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int n = (int)a.getSize();
        for (int i = 0; i < n; ++i) {
            if (m.getDouble(i) < 0.0) {
                r.setObject(i, (Object)missingValue);
                continue;
            }
            r.setObject(i, a.getObject(i));
        }
        return r;
    }

    public static Array maskout(Array a, Array m) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int n = (int)a.getSize();
        for (int i = 0; i < n; ++i) {
            if (m.getDouble(i) < 0.0) {
                r.setObject(i, (Object)Double.NaN);
                continue;
            }
            r.setObject(i, a.getObject(i));
        }
        return r;
    }

    public static Array maskin(Array a, Array m) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int n = (int)a.getSize();
        for (int i = 0; i < n; ++i) {
            if (m.getDouble(i) < 0.0) {
                r.setObject(i, a.getObject(i));
                continue;
            }
            r.setObject(i, (Object)Double.NaN);
        }
        return r;
    }
}

