/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.global;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class GenericFileFilter
extends FileFilter {
    private static final boolean ONE = true;
    private String fileExt;
    private String[] fileExts;
    private boolean type = false;
    private String description;
    private int length;
    private String extension;

    public GenericFileFilter(String[] filesExtsIn, String description) {
        if (filesExtsIn.length == 1) {
            this.type = true;
            this.fileExt = filesExtsIn[0];
        } else {
            this.fileExts = filesExtsIn;
            this.length = this.fileExts.length;
        }
        this.description = description;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        this.extension = GenericFileFilter.getExtension(f);
        if (this.extension != null) {
            if (this.type) {
                return this.check(this.fileExt);
            }
            for (int i = 0; i < this.length; ++i) {
                if (!this.check(this.fileExts[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean check(String in) {
        return this.extension.equalsIgnoreCase(in);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getFileExtent() {
        return this.fileExt;
    }

    public static String getExtension(File file) {
        String filename = file.getName();
        int length = filename.length();
        int i = filename.lastIndexOf(46);
        if (i > 0 && i < length - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }
}

