/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.layer;

import com.l2fprod.common.beans.BaseBeanInfo;
import com.l2fprod.common.beans.ExtendedPropertyDescriptor;
import com.l2fprod.common.beans.editor.ComboBoxPropertyEditor;
import java.awt.Color;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.util.GlobalUtil;
import org.meteoinfo.layer.LayerDrawType;
import org.meteoinfo.layer.LayerTypes;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.layer.WorldFilePara;
import org.meteoinfo.shape.ShapeTypes;

public class ImageLayer
extends MapLayer {
    private BufferedImage _image;
    private WorldFilePara _worldFilePara = new WorldFilePara();
    private String _worldFileName;
    private boolean _isSetTransColor;
    private Color _transparencyColor;
    protected Object interp;

    public ImageLayer() {
        this.setLayerType(LayerTypes.ImageLayer);
        this.setShapeType(ShapeTypes.Image);
        this._isSetTransColor = false;
        this._transparencyColor = Color.black;
        this.interp = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
    }

    public BufferedImage getImage() {
        return this._image;
    }

    public void setImage(BufferedImage image) {
        this._image = image;
        this._transparencyColor = new Color(image.getRGB(1, 1));
    }

    public String getWorldFileName() {
        return this._worldFileName;
    }

    public void setWorldFileName(String name) {
        this._worldFileName = name;
    }

    public WorldFilePara getWorldFilePara() {
        return this._worldFilePara;
    }

    public void setWorldFilePara(WorldFilePara value) {
        this._worldFilePara = value;
    }

    public boolean isUseTransColor() {
        return this._isSetTransColor;
    }

    public void setUseTransColor(boolean istrue) {
        this._isSetTransColor = istrue;
        if (istrue) {
            Image image = GlobalUtil.makeColorTransparent(this._image, this._transparencyColor);
            this._image = GlobalUtil.imageToBufferedImage(image);
        }
    }

    public Color getTransparencyColor() {
        return this._transparencyColor;
    }

    public void setTransparencyColor(Color color) {
        this._transparencyColor = color;
        if (this._isSetTransColor) {
            Image image = GlobalUtil.makeColorTransparent(this._image, this._transparencyColor);
            this._image = GlobalUtil.imageToBufferedImage(image);
        }
    }

    public double getXUL() {
        return this._worldFilePara.xUL;
    }

    public void setXUL(double value) throws IOException {
        this._worldFilePara.xUL = value;
        Extent aExtent = (Extent)this.getExtent().clone();
        aExtent.minX = this._worldFilePara.xUL;
        aExtent.maxX = this._worldFilePara.xUL + this.getExtent().getWidth();
        this.setExtent(aExtent);
        if (new File(this._worldFileName).exists()) {
            this.writeImageWorldFile(this._worldFileName, this._worldFilePara);
        }
    }

    public double getYUL() {
        return this._worldFilePara.yUL;
    }

    public void setYUL(double value) throws IOException {
        this._worldFilePara.yUL = value;
        Extent aExtent = (Extent)this.getExtent().clone();
        aExtent.maxY = this._worldFilePara.yUL;
        aExtent.minY = this._worldFilePara.yUL - this.getExtent().getHeight();
        this.setExtent(aExtent);
        if (new File(this._worldFileName).exists()) {
            this.writeImageWorldFile(this._worldFileName, this._worldFilePara);
        }
    }

    public double getXScale() {
        return this._worldFilePara.xScale;
    }

    public void setXScale(double value) throws IOException {
        this._worldFilePara.xScale = value;
        Extent aExtent = this.getExtent();
        double width = (double)this._image.getWidth() * this._worldFilePara.xScale;
        aExtent.maxX = this._worldFilePara.xUL + width;
        this.setExtent(aExtent);
        if (new File(this._worldFileName).exists()) {
            this.writeImageWorldFile(this._worldFileName, this._worldFilePara);
        }
    }

    public double getYScale() {
        return this._worldFilePara.yScale;
    }

    public void setYScale(double value) throws IOException {
        this._worldFilePara.yScale = value;
        Extent aExtent = this.getExtent();
        double height = (double)this._image.getHeight() * this._worldFilePara.yScale;
        aExtent.minY = this._worldFilePara.yUL + height;
        this.setExtent(aExtent);
        if (new File(this._worldFileName).exists()) {
            this.writeImageWorldFile(this._worldFileName, this._worldFilePara);
        }
    }

    public double getXRotate() {
        return this._worldFilePara.xRotate;
    }

    public void setXRotate(double value) throws IOException {
        this._worldFilePara.xRotate = value;
        if (new File(this._worldFileName).exists()) {
            this.writeImageWorldFile(this._worldFileName, this._worldFilePara);
        }
    }

    public double getYRotate() {
        return this._worldFilePara.yRotate;
    }

    public void setYRotate(double value) throws IOException {
        this._worldFilePara.yRotate = value;
        if (new File(this._worldFileName).exists()) {
            this.writeImageWorldFile(this._worldFileName, this._worldFilePara);
        }
    }

    public Object getInterpolation() {
        return this.interp;
    }

    public String getInterpolationStr() {
        if (this.interp == RenderingHints.VALUE_INTERPOLATION_BILINEAR) {
            return "bilinear";
        }
        if (this.interp == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
            return "bicubic";
        }
        return "nearest";
    }

    public void setInterpolation(Object value) {
        this.interp = value;
    }

    public void setInterpolation(String value) {
        switch (value) {
            case "nearest": {
                this.interp = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                break;
            }
            case "bilinear": {
                this.interp = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
                break;
            }
            case "bicubic": {
                this.interp = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
            }
        }
    }

    public void readImageWorldFile(String aIFile) throws FileNotFoundException, IOException {
        BufferedReader sr = new BufferedReader(new FileReader(new File(aIFile)));
        this._worldFilePara.xScale = Double.parseDouble(sr.readLine());
        this._worldFilePara.yRotate = Double.parseDouble(sr.readLine());
        this._worldFilePara.xRotate = Double.parseDouble(sr.readLine());
        this._worldFilePara.yScale = Double.parseDouble(sr.readLine());
        this._worldFilePara.xUL = Double.parseDouble(sr.readLine());
        this._worldFilePara.yUL = Double.parseDouble(sr.readLine());
        sr.close();
    }

    public void writeImageWorldFile(String aFile, WorldFilePara aWFP) throws IOException {
        BufferedWriter sw = new BufferedWriter(new FileWriter(new File(aFile)));
        sw.write(String.valueOf(aWFP.xScale));
        sw.newLine();
        sw.write(String.valueOf(aWFP.yRotate));
        sw.newLine();
        sw.write(String.valueOf(aWFP.xRotate));
        sw.newLine();
        sw.write(String.valueOf(aWFP.yScale));
        sw.newLine();
        sw.write(String.valueOf(aWFP.xUL));
        sw.newLine();
        sw.write(String.valueOf(aWFP.yUL));
        sw.close();
    }

    public List<Color> getColorsFromPaletteFile(String pFile) {
        try {
            BufferedReader sr = new BufferedReader(new InputStreamReader(new FileInputStream(pFile)));
            sr.readLine();
            String aLine = sr.readLine();
            ArrayList<Color> colors = new ArrayList<Color>();
            while (aLine != null) {
                if (aLine.isEmpty()) {
                    aLine = sr.readLine();
                    continue;
                }
                aLine = aLine.trim();
                String[] dataArray = aLine.split("\\s+");
                colors.add(new Color(Integer.parseInt(dataArray[3]), Integer.parseInt(dataArray[2]), Integer.parseInt(dataArray[1])));
                aLine = sr.readLine();
            }
            sr.close();
            return colors;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ImageLayer.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(ImageLayer.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void setPalette(List<Color> colors) {
        Raster imageData = this._image.getData();
        for (int i = 0; i < this._image.getWidth(); ++i) {
            for (int j = 0; j < this._image.getHeight(); ++j) {
                this._image.setRGB(i, this._image.getHeight() - j - 1, colors.get(imageData.getSample(i, j, 0)).getRGB());
            }
        }
    }

    public void setPalette(String aFile) {
        List<Color> colors = this.getColorsFromPaletteFile(aFile);
        this.setPalette(colors);
    }

    public static class InterpolationEditor
    extends ComboBoxPropertyEditor {
        public InterpolationEditor() {
            Object[] names = new String[]{"nearest", "bilinear", "bicubic"};
            this.setAvailableValues(names);
        }
    }

    public static class ImageLayerBeanBeanInfo
    extends BaseBeanInfo {
        public ImageLayerBeanBeanInfo() {
            super(ImageLayerBean.class);
            this.addProperty("fileName").setCategory("Read only").setReadOnly().setDisplayName("File name");
            this.addProperty("layerType").setCategory("Read only").setReadOnly().setDisplayName("Layer type");
            this.addProperty("layerDrawType").setCategory("Read only").setReadOnly().setDisplayName("Layer draw type");
            this.addProperty("handle").setCategory("Read only").setReadOnly().setDisplayName("Handle");
            this.addProperty("layerName").setCategory("Editable").setDisplayName("Layer name");
            this.addProperty("visible").setCategory("Editable").setDisplayName("Visible");
            this.addProperty("maskout").setCategory("Editable").setDisplayName("Is maskout");
            this.addProperty("transparency").setCategory("Editable").setDisplayName("Transparency Percent");
            this.addProperty("useTransColor").setCategory("Editable").setDisplayName("If use transparency color");
            this.addProperty("transparencyColor").setCategory("Editable").setDisplayName("Transparency color");
            this.addProperty("xScale").setCategory("Editable").setDisplayName("X scale");
            this.addProperty("yScale").setCategory("Editable").setDisplayName("Y scale");
            this.addProperty("xUL").setCategory("Editable").setDisplayName("X upper left");
            this.addProperty("yUL").setCategory("Editable").setDisplayName("Y upper left");
            this.addProperty("xRotate").setCategory("Editable").setDisplayName("X rotate");
            this.addProperty("yRotate").setCategory("Editable").setDisplayName("Y rotate");
            ExtendedPropertyDescriptor e = this.addProperty("interpolation");
            e.setCategory("Editable").setPropertyEditorClass(InterpolationEditor.class);
            e.setDisplayName("Interpolation");
        }
    }

    public class ImageLayerBean {
        ImageLayerBean() {
        }

        public LayerTypes getLayerType() {
            return ImageLayer.this.getLayerType();
        }

        public void setLayerType(LayerTypes lt) {
            ImageLayer.this.setLayerType(lt);
        }

        public LayerDrawType getLayerDrawType() {
            return ImageLayer.this.getLayerDrawType();
        }

        public void setLayerDrawType(LayerDrawType ldt) {
            ImageLayer.this.setLayerDrawType(ldt);
        }

        public String getFileName() {
            return ImageLayer.this.getFileName();
        }

        public void setFileName(String fn) {
            ImageLayer.this.setFileName(fn);
        }

        public int getHandle() {
            return ImageLayer.this.getHandle();
        }

        public String getLayerName() {
            return ImageLayer.this.getLayerName();
        }

        public void setLayerName(String name) {
            ImageLayer.this.setLayerName(name);
        }

        public boolean isMaskout() {
            return ImageLayer.this.isMaskout();
        }

        public void setMaskout(boolean value) {
            ImageLayer.this.setMaskout(value);
        }

        public boolean isVisible() {
            return ImageLayer.this.isVisible();
        }

        public void setVisible(boolean value) {
            ImageLayer.this.setVisible(value);
        }

        public String getWorldFileName() {
            return ImageLayer.this._worldFileName;
        }

        public boolean isUseTransColor() {
            return ImageLayer.this._isSetTransColor;
        }

        public void setUseTransColor(boolean istrue) {
            ImageLayer.this._isSetTransColor = istrue;
            if (istrue) {
                Image image = GlobalUtil.makeColorTransparent(ImageLayer.this._image, ImageLayer.this._transparencyColor);
                ImageLayer.this._image = GlobalUtil.imageToBufferedImage(image);
            }
        }

        public Color getTransparencyColor() {
            return ImageLayer.this._transparencyColor;
        }

        public void setTransparencyColor(Color color) {
            ImageLayer.this._transparencyColor = color;
            if (ImageLayer.this._isSetTransColor) {
                Image image = GlobalUtil.makeColorTransparent(ImageLayer.this._image, ImageLayer.this._transparencyColor);
                ImageLayer.this._image = GlobalUtil.imageToBufferedImage(image);
            }
        }

        public int getTransparency() {
            return ImageLayer.this.getTransparency();
        }

        public void setTransparency(int value) {
            ImageLayer.this.setTransparency(value);
        }

        public double getXUL() {
            return ((ImageLayer)ImageLayer.this)._worldFilePara.xUL;
        }

        public void setXUL(double value) throws IOException {
            ((ImageLayer)ImageLayer.this)._worldFilePara.xUL = value;
            Extent aExtent = (Extent)ImageLayer.this.getExtent().clone();
            aExtent.minX = ((ImageLayer)ImageLayer.this)._worldFilePara.xUL;
            aExtent.maxX = ((ImageLayer)ImageLayer.this)._worldFilePara.xUL + ImageLayer.this.getExtent().getWidth();
            ImageLayer.this.setExtent(aExtent);
            if (new File(ImageLayer.this._worldFileName).exists()) {
                ImageLayer.this.writeImageWorldFile(ImageLayer.this._worldFileName, ImageLayer.this._worldFilePara);
            }
        }

        public double getYUL() {
            return ((ImageLayer)ImageLayer.this)._worldFilePara.yUL;
        }

        public void setYUL(double value) throws IOException {
            ((ImageLayer)ImageLayer.this)._worldFilePara.yUL = value;
            Extent aExtent = (Extent)ImageLayer.this.getExtent().clone();
            aExtent.maxY = ((ImageLayer)ImageLayer.this)._worldFilePara.yUL;
            aExtent.minY = ((ImageLayer)ImageLayer.this)._worldFilePara.yUL - ImageLayer.this.getExtent().getHeight();
            ImageLayer.this.setExtent(aExtent);
            if (new File(ImageLayer.this._worldFileName).exists()) {
                ImageLayer.this.writeImageWorldFile(ImageLayer.this._worldFileName, ImageLayer.this._worldFilePara);
            }
        }

        public double getXScale() {
            return ((ImageLayer)ImageLayer.this)._worldFilePara.xScale;
        }

        public void setXScale(double value) throws IOException {
            ((ImageLayer)ImageLayer.this)._worldFilePara.xScale = value;
            Extent aExtent = ImageLayer.this.getExtent();
            double width = (double)ImageLayer.this._image.getWidth() * ((ImageLayer)ImageLayer.this)._worldFilePara.xScale;
            aExtent.maxX = ((ImageLayer)ImageLayer.this)._worldFilePara.xUL + width;
            ImageLayer.this.setExtent(aExtent);
            if (new File(ImageLayer.this._worldFileName).exists()) {
                ImageLayer.this.writeImageWorldFile(ImageLayer.this._worldFileName, ImageLayer.this._worldFilePara);
            }
        }

        public double getYScale() {
            return ((ImageLayer)ImageLayer.this)._worldFilePara.yScale;
        }

        public void setYScale(double value) throws IOException {
            ((ImageLayer)ImageLayer.this)._worldFilePara.yScale = value;
            Extent aExtent = ImageLayer.this.getExtent();
            double height = (double)ImageLayer.this._image.getHeight() * ((ImageLayer)ImageLayer.this)._worldFilePara.yScale;
            aExtent.minY = ((ImageLayer)ImageLayer.this)._worldFilePara.yUL + height;
            ImageLayer.this.setExtent(aExtent);
            if (new File(ImageLayer.this._worldFileName).exists()) {
                ImageLayer.this.writeImageWorldFile(ImageLayer.this._worldFileName, ImageLayer.this._worldFilePara);
            }
        }

        public double getXRotate() {
            return ((ImageLayer)ImageLayer.this)._worldFilePara.xRotate;
        }

        public void setXRotate(double value) throws IOException {
            ((ImageLayer)ImageLayer.this)._worldFilePara.xRotate = value;
            if (new File(ImageLayer.this._worldFileName).exists()) {
                ImageLayer.this.writeImageWorldFile(ImageLayer.this._worldFileName, ImageLayer.this._worldFilePara);
            }
        }

        public double getYRotate() {
            return ((ImageLayer)ImageLayer.this)._worldFilePara.yRotate;
        }

        public void setYRotate(double value) throws IOException {
            ((ImageLayer)ImageLayer.this)._worldFilePara.yRotate = value;
            if (new File(ImageLayer.this._worldFileName).exists()) {
                ImageLayer.this.writeImageWorldFile(ImageLayer.this._worldFileName, ImageLayer.this._worldFilePara);
            }
        }

        public String getInterpolation() {
            if (ImageLayer.this.interp == RenderingHints.VALUE_INTERPOLATION_BILINEAR) {
                return "bilinear";
            }
            if (ImageLayer.this.interp == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
                return "bicubic";
            }
            return "nearest";
        }

        public void setInterpolation(String value) {
            switch (value) {
                case "nearest": {
                    ImageLayer.this.interp = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                    break;
                }
                case "bilinear": {
                    ImageLayer.this.interp = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
                    break;
                }
                case "bicubic": {
                    ImageLayer.this.interp = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
                }
            }
        }
    }
}

