/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.layer;

import com.l2fprod.common.beans.BaseBeanInfo;
import com.l2fprod.common.beans.ExtendedPropertyDescriptor;
import com.l2fprod.common.beans.editor.ComboBoxPropertyEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.meteoinfo.data.mapdata.webmap.AHybridMapInfo;
import org.meteoinfo.data.mapdata.webmap.AMapInfo;
import org.meteoinfo.data.mapdata.webmap.ASatelliteMapInfo;
import org.meteoinfo.data.mapdata.webmap.BingHybridMapInfo;
import org.meteoinfo.data.mapdata.webmap.BingMapInfo;
import org.meteoinfo.data.mapdata.webmap.BingSatelliteMapInfo;
import org.meteoinfo.data.mapdata.webmap.DefaultTileFactory;
import org.meteoinfo.data.mapdata.webmap.GeoPosition;
import org.meteoinfo.data.mapdata.webmap.GoogleHybridMapInfo;
import org.meteoinfo.data.mapdata.webmap.GoogleHybridTerrainMapInfo;
import org.meteoinfo.data.mapdata.webmap.GoogleMapInfo;
import org.meteoinfo.data.mapdata.webmap.GoogleSatelliteMapInfo;
import org.meteoinfo.data.mapdata.webmap.GoogleTerrainMapInfo;
import org.meteoinfo.data.mapdata.webmap.OpenStreetMapInfo;
import org.meteoinfo.data.mapdata.webmap.OpenStreetMapQuestSatelliteInfo;
import org.meteoinfo.data.mapdata.webmap.TencentMapInfo;
import org.meteoinfo.data.mapdata.webmap.Tile;
import org.meteoinfo.data.mapdata.webmap.TileFactory;
import org.meteoinfo.data.mapdata.webmap.TileFactoryInfo;
import org.meteoinfo.data.mapdata.webmap.WebMapProvider;
import org.meteoinfo.data.mapdata.webmap.YahooHybridMapInfo;
import org.meteoinfo.data.mapdata.webmap.YahooMapInfo;
import org.meteoinfo.data.mapdata.webmap.YahooSatelliteMapInfo;
import org.meteoinfo.data.mapdata.webmap.empty.EmptyTileFactory;
import org.meteoinfo.global.Extent;
import org.meteoinfo.layer.LayerDrawType;
import org.meteoinfo.layer.LayerTypes;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.shape.ShapeTypes;

public class WebMapLayer
extends MapLayer {
    private final boolean isNegativeYAllowed = true;
    private int zoom = 11;
    private Point2D center = new Point2D.Double(0.0, 0.0);
    private boolean drawTileBorders = false;
    private TileFactory factory;
    private GeoPosition addressLocation;
    private boolean panEnabled = true;
    private boolean zoomEnabled = true;
    private boolean recenterOnClickEnabled = true;
    private boolean designTime;
    private float zoomScale = 1.0f;
    private Image loadingImage;
    private boolean restrictOutsidePanning = false;
    private boolean horizontalWrapped = true;
    private WebMapProvider defaultProvider = WebMapProvider.OpenStreetMap;
    private Graphics2D graphics;
    private int width;
    private int height;
    private List<Double> scales = new ArrayList<Double>();
    private TileLoadListener tileLoadListener = new TileLoadListener();

    public WebMapLayer() {
        this.setLayerType(LayerTypes.WebMapLayer);
        this.setShapeType(ShapeTypes.Image);
        this.setLayerDrawType(LayerDrawType.Image);
        this.setLayerName("OpenStreetMap");
        this.setExtent(new Extent(-2.0037508342789244E7, 2.0037508342789244E7, -1.8375854901481014E7, 1.8375854901481014E7));
        this.factory = new EmptyTileFactory();
        try {
            URL url = this.getClass().getResource("/images/loading.png");
            this.setLoadingImage(ImageIO.read(url));
        }
        catch (Throwable ex) {
            System.out.println("could not load 'loading.png'");
            BufferedImage img = new BufferedImage(16, 16, 2);
            Graphics2D g2 = img.createGraphics();
            g2.setColor(Color.black);
            g2.fillRect(0, 0, 16, 16);
            g2.dispose();
            this.setLoadingImage(img);
        }
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        if (zoom == this.zoom) {
            return;
        }
        TileFactoryInfo info = this.getTileFactory().getInfo();
        if (info != null && (zoom < info.getMinimumZoomLevel() || zoom > info.getMaximumZoomLevel())) {
            return;
        }
        int oldzoom = this.zoom;
        Point2D oldCenter = this.getCenter();
        Dimension oldMapSize = this.getTileFactory().getMapSize(oldzoom);
        this.zoom = zoom;
        Dimension mapSize = this.getTileFactory().getMapSize(zoom);
        this.setCenter(new Point2D.Double(oldCenter.getX() * (mapSize.getWidth() / oldMapSize.getWidth()), oldCenter.getY() * (mapSize.getHeight() / oldMapSize.getHeight())));
    }

    public Point2D getCenter() {
        return this.center;
    }

    public boolean isRestrictOutsidePanning() {
        return this.restrictOutsidePanning;
    }

    public void setRestrictOutsidePanning(boolean restrictOutsidePanning) {
        this.restrictOutsidePanning = restrictOutsidePanning;
    }

    public void setCenter(Point2D center) {
        this.center = center;
    }

    public void setCenterPosition(GeoPosition geoPosition) {
        GeoPosition oldVal = this.getCenterPosition();
        this.setCenter(this.getTileFactory().geoToPixel(geoPosition, this.zoom));
        GeoPosition newVal = this.getCenterPosition();
    }

    public GeoPosition getCenterPosition() {
        return this.getTileFactory().pixelToGeo(this.getCenter(), this.zoom);
    }

    public TileFactory getTileFactory() {
        return this.factory;
    }

    public void setTileFactory(TileFactory factory) {
        this.factory = factory;
        this.setZoom(factory.getInfo().getDefaultZoomLevel());
        this.setCenterPosition(new GeoPosition(0.0, 0.0));
    }

    public Image getLoadingImage() {
        return this.loadingImage;
    }

    public void setLoadingImage(Image loadingImage) {
        this.loadingImage = loadingImage;
    }

    public boolean isDrawTileBorders() {
        return this.drawTileBorders;
    }

    public void setDrawTileBorders(boolean drawTileBorders) {
        this.drawTileBorders = drawTileBorders;
    }

    public void setWebMapProvider(WebMapProvider prov) {
        TileFactoryInfo info = null;
        switch (prov) {
            case OpenStreetMap: {
                info = new OpenStreetMapInfo();
                break;
            }
            case OpenStreetMapQuestSattelite: {
                info = new OpenStreetMapQuestSatelliteInfo();
                break;
            }
            case BingMap: {
                info = new BingMapInfo();
                break;
            }
            case BingSatelliteMap: {
                info = new BingSatelliteMapInfo();
                break;
            }
            case BingHybridMap: {
                info = new BingHybridMapInfo();
                break;
            }
            case YahooMap: {
                info = new YahooMapInfo();
                break;
            }
            case YahooSatelliteMap: {
                info = new YahooSatelliteMapInfo();
                break;
            }
            case YahooHybridMap: {
                info = new YahooHybridMapInfo();
                break;
            }
            case GoogleMap: {
                info = new GoogleMapInfo();
                break;
            }
            case GoogleSatelliteMap: {
                info = new GoogleSatelliteMapInfo();
                break;
            }
            case GoogleTerrainMap: {
                info = new GoogleTerrainMapInfo();
                break;
            }
            case GoogleHybridMap: {
                info = new GoogleHybridMapInfo();
                break;
            }
            case GoogleHybridTerrainMap: {
                info = new GoogleHybridTerrainMapInfo();
                break;
            }
            case AMap: {
                info = new AMapInfo();
                break;
            }
            case ASatelliteMap: {
                info = new ASatelliteMapInfo();
                break;
            }
            case AHybridMap: {
                info = new AHybridMapInfo();
                break;
            }
            case TencentMap: {
                info = new TencentMapInfo();
            }
        }
        if (info != null) {
            this.defaultProvider = prov;
            this.setLayerName("WebMap_" + info.getName());
            DefaultTileFactory tf = new DefaultTileFactory(info);
            this.setTileFactory(tf);
            this.setAddressLocation(new GeoPosition(51.5, 0.0));
        }
    }

    public WebMapProvider getWebMapProvider() {
        return this.defaultProvider;
    }

    public GeoPosition getAddressLocation() {
        return this.addressLocation;
    }

    public void setAddressLocation(GeoPosition pos, int zoom) {
        this.addressLocation = pos;
        this.setCenter(this.getTileFactory().geoToPixel(pos, zoom));
    }

    public void setAddressLocation(GeoPosition pos) {
        this.addressLocation = pos;
        this.setCenter(this.getTileFactory().geoToPixel(this.addressLocation, this.getZoom()));
    }

    public void repaint() {
        Rectangle rect = this.calculateViewportBounds(this.graphics, this.width, this.height);
        this.drawMapTiles(this.graphics, this.zoom, rect);
    }

    public void drawMapTiles(Graphics2D g, int zoom, int width, int height) {
        this.graphics = g;
        this.zoom = zoom;
        this.width = width;
        this.height = height;
        Rectangle rect = this.calculateViewportBounds(g, width, height);
        this.drawMapTiles(g, zoom, rect);
    }

    public void drawMapTiles(Graphics2D g, int zoom, Rectangle viewportBounds) {
        int size = this.getTileFactory().getTileSize(zoom);
        Dimension mapSize = this.getTileFactory().getMapSize(zoom);
        int numWide = viewportBounds.width / size + 2;
        int numHigh = viewportBounds.height / size + 2;
        TileFactoryInfo info = this.getTileFactory().getInfo();
        int tpx = (int)Math.floor(viewportBounds.getX() / (double)info.getTileSize(0));
        int tpy = (int)Math.floor(viewportBounds.getY() / (double)info.getTileSize(0));
        for (int x = 0; x <= numWide; ++x) {
            for (int y = 0; y <= numHigh; ++y) {
                int itpx = x + tpx;
                int itpy = y + tpy;
                Tile tile = this.getTileFactory().getTile(itpx, itpy, zoom);
                int ox = itpx * this.getTileFactory().getTileSize(zoom) - viewportBounds.x;
                int oy = itpy * this.getTileFactory().getTileSize(zoom) - viewportBounds.y;
                if (!this.isTileOnMap(itpx, itpy, mapSize) && tile.isLoaded()) {
                    g.drawImage((Image)tile.getImage(), ox, oy, null);
                }
                if (!this.isDrawTileBorders()) continue;
                g.setColor(Color.black);
                g.drawRect(ox, oy, size, size);
                g.drawRect(ox + size / 2 - 5, oy + size / 2 - 5, 10, 10);
                g.setColor(Color.white);
                g.drawRect(ox + 1, oy + 1, size, size);
                String text = itpx + ", " + itpy + ", " + this.getZoom();
                g.setColor(Color.BLACK);
                g.drawString(text, ox + 10, oy + 30);
                g.drawString(text, ox + 10 + 2, oy + 30 + 2);
                g.setColor(Color.WHITE);
                g.drawString(text, ox + 10 + 1, oy + 30 + 1);
            }
        }
    }

    public boolean isTileOnMap(int x, int y, Dimension mapSize) {
        return (double)y >= mapSize.getHeight();
    }

    public Rectangle calculateViewportBounds(Graphics2D g, int width, int height) {
        double viewportX = this.center.getX() - (double)(width / 2);
        double viewportY = this.center.getY() - (double)(height / 2);
        return new Rectangle((int)viewportX, (int)viewportY, width, height);
    }

    @Override
    public String getLayerInfo() {
        String str = "Layer name: " + this.getLayerName();
        str = str + System.getProperty("line.separator") + "Layer file: " + this.getFileName();
        str = str + System.getProperty("line.separator") + "Layer type: " + (Object)((Object)this.getLayerType());
        str = str + System.getProperty("line.separator") + "Data provider: " + (Object)((Object)this.defaultProvider);
        return str;
    }

    public static class LanguageEditor
    extends ComboBoxPropertyEditor {
        public LanguageEditor() {
            Object[] langs = new String[]{"en-us", "zh-cn"};
            this.setAvailableValues(langs);
        }
    }

    public static class WebMapProviderEditor
    extends ComboBoxPropertyEditor {
        public WebMapProviderEditor() {
            WebMapProvider[] providers = WebMapProvider.values();
            Object[] types = new String[providers.length];
            int i = 0;
            for (WebMapProvider prov : providers) {
                types[i] = prov.toString();
                ++i;
            }
            this.setAvailableValues(types);
        }
    }

    public static class WebMapLayerBeanBeanInfo
    extends BaseBeanInfo {
        public WebMapLayerBeanBeanInfo() {
            super(WebMapLayerBean.class);
            this.addProperty("layerType").setCategory("Read only").setReadOnly().setDisplayName("Layer type");
            this.addProperty("layerDrawType").setCategory("Read only").setReadOnly().setDisplayName("Layer draw type");
            this.addProperty("handle").setCategory("Read only").setReadOnly().setDisplayName("Handle");
            ExtendedPropertyDescriptor e = this.addProperty("webMapProvider");
            e.setCategory("Editable").setDisplayName("Web Map Provider");
            e.setPropertyEditorClass(WebMapProviderEditor.class);
            e = this.addProperty("language");
            e.setCategory("Editable").setDisplayName("Language");
            e.setPropertyEditorClass(LanguageEditor.class);
            this.addProperty("visible").setCategory("Editable").setDisplayName("Visible");
            this.addProperty("maskout").setCategory("Editable").setDisplayName("Is maskout");
        }
    }

    public class WebMapLayerBean {
        public LayerTypes getLayerType() {
            return WebMapLayer.this.getLayerType();
        }

        public LayerDrawType getLayerDrawType() {
            return WebMapLayer.this.getLayerDrawType();
        }

        public int getHandle() {
            return WebMapLayer.this.getHandle();
        }

        public String getLayerName() {
            return WebMapLayer.this.getLayerName();
        }

        public void setLayerName(String name) {
            WebMapLayer.this.setLayerName(name);
        }

        public String getWebMapProvider() {
            return WebMapLayer.this.defaultProvider.toString();
        }

        public void setWebMapProvider(String provider) {
            WebMapLayer.this.setWebMapProvider(WebMapProvider.valueOf(provider));
        }

        public boolean isMaskout() {
            return WebMapLayer.this.isMaskout();
        }

        public void setMaskout(boolean value) {
            WebMapLayer.this.setMaskout(value);
        }

        public boolean isVisible() {
            return WebMapLayer.this.isVisible();
        }

        public void setVisible(boolean value) {
            WebMapLayer.this.setVisible(value);
        }

        public String getLanguage() {
            return WebMapLayer.this.getTileFactory().getInfo().getLanguage();
        }

        public void setLanguage(String value) {
            WebMapLayer.this.getTileFactory().getInfo().setLanguage(value);
        }
    }

    private final class TileLoadListener
    implements PropertyChangeListener {
        private TileLoadListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Tile t;
            if ("loaded".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue()) && (t = (Tile)evt.getSource()).getZoom() == WebMapLayer.this.getZoom()) {
                WebMapLayer.this.repaint();
            }
        }
    }
}

