/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.legend;

import com.l2fprod.common.beans.BaseBeanInfo;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import org.meteoinfo.global.colors.ColorUtil;
import org.meteoinfo.global.event.ILayersUpdatedListener;
import org.meteoinfo.global.event.ILayoutBoundsChangedListener;
import org.meteoinfo.global.event.IMapViewUpdatedListener;
import org.meteoinfo.global.event.IViewExtentChangedListener;
import org.meteoinfo.global.event.LayersUpdatedEvent;
import org.meteoinfo.global.event.LayoutBoundsChangedEvent;
import org.meteoinfo.global.event.MapViewUpdatedEvent;
import org.meteoinfo.global.event.ViewExtentChangedEvent;
import org.meteoinfo.layer.ImageLayer;
import org.meteoinfo.layer.LayerTypes;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.layer.RasterLayer;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.layer.WebMapLayer;
import org.meteoinfo.legend.Constants;
import org.meteoinfo.legend.GridLabelPosition;
import org.meteoinfo.legend.GroupNode;
import org.meteoinfo.legend.ItemNode;
import org.meteoinfo.legend.LayerNode;
import org.meteoinfo.legend.LayersLegend;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.LineStyles;
import org.meteoinfo.legend.NodeTypes;
import org.meteoinfo.map.MapView;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapFrame
extends ItemNode {
    private EventListenerList _listeners = new EventListenerList();
    private MapView _mapView = new MapView();
    private List<ItemNode> _nodes = new ArrayList<ItemNode>();
    private int _selectedLayerHandle;
    private LayersLegend _legend;
    private boolean _active = false;
    private int _order;
    private boolean _drawNeatLine = true;
    private boolean _insideTickLine = false;
    private int _tickLineLength = 5;
    private int _gridLabelShift = 2;
    private Color _neatLineColor = Color.black;
    private float _neatLineSize = 1.0f;
    private boolean _drawGridLabel = true;
    private GridLabelPosition _gridLabelPosition = GridLabelPosition.LEFT_BOTTOM;
    private Font _gridFont = new Font("Arial", 0, 12);
    private Rectangle _layoutBounds;

    public void addLayersUpdatedListener(ILayersUpdatedListener lul) {
        this._listeners.add(ILayersUpdatedListener.class, lul);
    }

    public void removeLayersUpdatedListener(ILayersUpdatedListener lul) {
        this._listeners.remove(ILayersUpdatedListener.class, lul);
    }

    public void fireLayersUpdatedEvent() {
        this.fireLayersUpdatedEvent(new LayersUpdatedEvent(this));
    }

    private void fireLayersUpdatedEvent(LayersUpdatedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ILayersUpdatedListener.class) continue;
            ((ILayersUpdatedListener)listeners[i + 1]).layersUpdatedEvent(event);
        }
    }

    public void addMapViewUpdatedListener(IMapViewUpdatedListener listener) {
        this._listeners.add(IMapViewUpdatedListener.class, listener);
    }

    public void removeMapViewUpdatedListener(IMapViewUpdatedListener listener) {
        this._listeners.remove(IMapViewUpdatedListener.class, listener);
    }

    public void fireMapViewUpdatedEvent() {
        this.fireMapViewUpdatedEvent(new MapViewUpdatedEvent(this));
    }

    private void fireMapViewUpdatedEvent(MapViewUpdatedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IMapViewUpdatedListener.class) continue;
            ((IMapViewUpdatedListener)listeners[i + 1]).mapViewUpdatedEvent(event);
        }
    }

    public void addLayoutBoundsChangedListener(ILayoutBoundsChangedListener listener) {
        this._listeners.add(ILayoutBoundsChangedListener.class, listener);
    }

    public void removeLayoutBoundsChangedListener(ILayoutBoundsChangedListener listener) {
        this._listeners.remove(ILayoutBoundsChangedListener.class, listener);
    }

    public void fireLayoutBoundsChangedEvent() {
        this.fireLayoutBoundsChangedEvent(new LayoutBoundsChangedEvent(this));
    }

    private void fireLayoutBoundsChangedEvent(LayoutBoundsChangedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ILayoutBoundsChangedListener.class) continue;
            ((ILayoutBoundsChangedListener)listeners[i + 1]).layoutBoundsChangedEvent(event);
        }
    }

    public MapFrame() {
        this.setText("New Map Frame");
        this.setNodeType(NodeTypes.MapFrameNode);
        this.expand();
        this._layoutBounds = new Rectangle(100, 100, 300, 200);
        this._mapView.addViewExtentChangedListener(new IViewExtentChangedListener(){

            @Override
            public void viewExtentChangedEvent(ViewExtentChangedEvent event) {
                MapFrame.this.fireMapViewUpdatedEvent();
            }
        });
    }

    public MapFrame(LayersLegend legend) {
        this();
        this._legend = legend;
    }

    public MapView getMapView() {
        return this._mapView;
    }

    public void setMapView(MapView mapView) {
        this._mapView = mapView;
        this._mapView.addViewExtentChangedListener(new IViewExtentChangedListener(){

            @Override
            public void viewExtentChangedEvent(ViewExtentChangedEvent even) {
                MapFrame.this.fireMapViewUpdatedEvent();
            }
        });
    }

    public List<ItemNode> getNodes() {
        return this._nodes;
    }

    public void setNodes(List<ItemNode> nodes) {
        this._nodes = nodes;
    }

    public int getSelectedLayer() {
        return this._selectedLayerHandle;
    }

    public void setSelectedLayer(int handle) {
        this._selectedLayerHandle = handle;
    }

    public LayersLegend getLegend() {
        return this._legend;
    }

    public void setLegend(LayersLegend legend) {
        this._legend = legend;
    }

    public boolean isActive() {
        return this._active;
    }

    public void setActive(boolean istrue) {
        this._active = istrue;
    }

    public int getOrder() {
        return this._order;
    }

    public void setOrder(int order) {
        this._order = order;
    }

    public boolean isDrawNeatLine() {
        return this._drawNeatLine;
    }

    public void setDrawNeatLine(boolean istrue) {
        this._drawNeatLine = istrue;
    }

    public Color getNeatLineColor() {
        return this._neatLineColor;
    }

    public void setNeatLineColor(Color color) {
        this._neatLineColor = color;
    }

    public float getNeatLineSize() {
        return this._neatLineSize;
    }

    public void setNeatLineSize(float size) {
        this._neatLineSize = size;
    }

    public boolean isDrawGridLabel() {
        return this._drawGridLabel;
    }

    public void setDrawGridLabel(boolean istrue) {
        this._drawGridLabel = istrue;
    }

    public boolean isInsideTickLine() {
        return this._insideTickLine;
    }

    public void setInsideTickLine(boolean istrue) {
        this._insideTickLine = istrue;
    }

    public int getTickLineLength() {
        return this._tickLineLength;
    }

    public void setTickLineLength(int len) {
        this._tickLineLength = len;
    }

    public int getGridLabelShift() {
        return this._gridLabelShift;
    }

    public void setGridLabelShift(int shift) {
        this._gridLabelShift = shift;
    }

    public GridLabelPosition getGridLabelPosition() {
        return this._gridLabelPosition;
    }

    public void setGridLabelPosition(GridLabelPosition pos) {
        this._gridLabelPosition = pos;
    }

    public void setGridLabelPosition(String pos) {
        GridLabelPosition glp;
        this._gridLabelPosition = glp = GridLabelPosition.valueOf(pos.toUpperCase());
    }

    public Font getGridFont() {
        return this._gridFont;
    }

    public void setGridFont(Font font) {
        this._gridFont = font;
    }

    public String getMapFrameName() {
        return this.getText();
    }

    public void setMapFrameName(String name) {
        this.setText(name);
    }

    @Override
    public Color getBackColor() {
        return this._mapView.getBackground();
    }

    @Override
    public void setBackColor(Color color) {
        this._mapView.setBackground(color);
    }

    @Override
    public Color getForeColor() {
        return this._mapView.getForeground();
    }

    @Override
    public void setForeColor(Color color) {
        this._mapView.setForeground(color);
    }

    public Color getGridLineColor() {
        return this._mapView.getGridLineColor();
    }

    public void setGridLineColor(Color color) {
        this._mapView.setGridLineColor(color);
    }

    public float getGridLineSize() {
        return this._mapView.getGridLineSize();
    }

    public void setGridLineSize(float size) {
        this._mapView.setGridLineSize(size);
    }

    public LineStyles getGridLineStyle() {
        return this._mapView.getGridLineStyle();
    }

    public void setGridLineStyle(LineStyles style) {
        this._mapView.setGridLineStyle(style);
    }

    public boolean isDrawGridLine() {
        return this._mapView.isDrawGridLine();
    }

    public void setDrawGridLine(boolean istrue) {
        this._mapView.setDrawGridLine(istrue);
    }

    public boolean isDrawGridTickLine() {
        return this._mapView.isDrawGridTickLine();
    }

    public void setDrawGridTickLine(boolean istrue) {
        this._mapView.setDrawGridTickLine(istrue);
    }

    public double getGridXDelt() {
        return this._mapView.getGridXDelt();
    }

    public void setGridXDelt(double delta) {
        this._mapView.setGridXDelt(delta);
    }

    public double getGridYDelt() {
        return this._mapView.getGridYDelt();
    }

    public void setGridYDelt(double value) {
        this._mapView.setGridYDelt(value);
    }

    public float getGridXOrigin() {
        return this._mapView.getGridXOrigin();
    }

    public void setGridXOrigin(float value) {
        this._mapView.setGridXOrigin(value);
    }

    public float getGridYOrigin() {
        return this._mapView.getGridYOrigin();
    }

    public void setGridYOrigin(float value) {
        this._mapView.setGridYOrigin(value);
    }

    public Rectangle getLayoutBounds() {
        return this._layoutBounds;
    }

    public void setLayoutBounds(Rectangle lb) {
        this._layoutBounds = lb;
        this.fireLayoutBoundsChangedEvent();
    }

    public int addGroup(GroupNode aGroup) {
        this.addNode(aGroup);
        return aGroup.getGroupHandle();
    }

    public int addNewGroup(String name) {
        GroupNode aGroup = new GroupNode(name);
        return this.addGroup(aGroup);
    }

    public void removeGroup(GroupNode aGroup) {
        MapFrame mapFrame = aGroup.getMapFrame();
        if (aGroup.getLayers().size() > 0) {
            if (JOptionPane.showConfirmDialog(null, "All layers of the group will be removed! Will you continue?", "Confirm", 0) == 0) {
                int lNum = aGroup.getLayers().size();
                for (int i = 0; i < lNum; ++i) {
                    LayerNode aLN = aGroup.getLayers().get(0);
                    this.removeLayer(aLN);
                }
                mapFrame.removeNode(aGroup);
            }
        } else {
            mapFrame.removeNode(aGroup);
        }
    }

    public int addLayer(MapLayer aLayer) {
        LayerNode aLN = new LayerNode(aLayer);
        this.selectLayer(aLN);
        return this.addLayerNode(aLN);
    }

    public int addLayer(int index, MapLayer layer) {
        LayerNode ln = new LayerNode(layer);
        this.selectLayer(ln);
        return this.addLayerNode(index, ln);
    }

    public int addWindLayer(VectorLayer aLayer, boolean earthWind) {
        LayerNode aLN = new LayerNode(aLayer);
        this.selectLayer(aLN);
        return this.addLayerNode(aLN, earthWind);
    }

    public int addLayer(MapLayer aLayer, int groupHandle) {
        LayerNode aLN = new LayerNode(aLayer);
        this.selectLayer(aLN);
        GroupNode aGroup = this.getGroupByHandle(groupHandle);
        if (aGroup == null) {
            return this.addLayerNode(aLN);
        }
        return this.addLayerNode(aLN, aGroup);
    }

    public int insertPolygonLayer(MapLayer aLayer) {
        int lIdx = this._mapView.getImageLayerIdx() + 1;
        int handle = this.addLayer(aLayer);
        if (lIdx < 0) {
            lIdx = 0;
        }
        this.moveLayer(handle, lIdx);
        this._mapView.setLockViewUpdate(false);
        this._mapView.paintLayers();
        return handle;
    }

    public int insertPolylineLayer(VectorLayer aLayer) {
        int lIdx = this._mapView.getLineLayerIdx() + 1;
        int handle = this.addLayer(aLayer);
        if (lIdx < 0) {
            lIdx = 0;
        }
        this.moveLayer(handle, lIdx);
        this._mapView.setLockViewUpdate(false);
        this._mapView.paintLayers();
        return handle;
    }

    public int insertImageLayer(MapLayer aLayer) {
        int lIdx = this._mapView.getImageLayerIdx() + 1;
        int handle = this.addLayer(aLayer);
        if (lIdx < 0) {
            lIdx = 0;
        }
        this.moveLayer(handle, lIdx);
        this._mapView.setLockViewUpdate(false);
        this._mapView.paintLayers();
        return handle;
    }

    public void moveLayer(int handle, int lNewIdx) {
        int lPreIdx = this._mapView.getLayerIdxFromHandle(handle);
        if (lPreIdx == lNewIdx) {
            return;
        }
        this.moveLayerNode(lPreIdx, lNewIdx);
        this._mapView.moveLayer(lPreIdx, lNewIdx);
        this._mapView.paintLayers();
        this.fireLayersUpdatedEvent();
    }

    public void moveLayer(MapLayer layer, int lNewIdx) {
        this.moveLayer(layer.getHandle(), lNewIdx);
    }

    public List<LayerNode> getLayerNodes() {
        ArrayList<LayerNode> layerNodes = new ArrayList<LayerNode>();
        for (ItemNode aIN : this._nodes) {
            if (aIN.getNodeType() == NodeTypes.GroupNode) {
                for (LayerNode aLN : ((GroupNode)aIN).getLayers()) {
                    layerNodes.add(aLN);
                }
                continue;
            }
            layerNodes.add((LayerNode)aIN);
        }
        return layerNodes;
    }

    public void moveLayerNode(int lPreIdx, int lNewIdx) {
        List<LayerNode> layerNodes = this.getLayerNodes();
        LayerNode aTN = layerNodes.get(lPreIdx);
        this._nodes.remove(aTN);
        LayerNode toLN = layerNodes.get(lNewIdx);
        if (toLN.getGroupHandle() >= 0) {
            GroupNode gNode = this.getGroupByHandle(toLN.getGroupHandle());
            gNode.insertLayer(aTN, gNode.getLayerIndex(toLN));
        } else {
            this._nodes.add(this._nodes.indexOf(toLN), aTN);
        }
    }

    public int addLayerNode(LayerNode aLN) {
        aLN.setMapFrame(this);
        int handle = this._mapView.addLayer(aLN.getMapLayer());
        this.addNode(aLN);
        if (aLN.getMapLayer().isVisible()) {
            aLN.setChecked(true);
        }
        aLN.updateLegendScheme(aLN.getLegendScheme());
        this.selectLayer(aLN);
        if (aLN.getMapLayer().isExpanded()) {
            aLN.expand();
        }
        this.fireLayersUpdatedEvent(new LayersUpdatedEvent(this));
        return handle;
    }

    public int addLayerNode(LayerNode aLN, GroupNode aGN) {
        aLN.setMapFrame(this);
        int handle = this._mapView.addLayer(aLN.getMapLayer());
        aLN.setMapLayer(this._mapView.getLayerByHandle(handle));
        aGN.addLayer(aLN);
        if (aLN.getMapLayer().isVisible()) {
            aLN.setChecked(true);
        }
        aLN.updateLegendScheme(aLN.getLegendScheme());
        this.selectLayer(aLN);
        if (aLN.getMapLayer().isExpanded()) {
            aLN.expand();
        }
        this.reOrderMapViewLayers();
        this.fireLayersUpdatedEvent();
        return handle;
    }

    private int addLayerNode(LayerNode aLN, boolean earthWind) {
        aLN.setMapFrame(this);
        int handle = this._mapView.addWindLayer((VectorLayer)aLN.getMapLayer(), earthWind);
        this.addNode(aLN);
        if (aLN.getMapLayer().isVisible()) {
            aLN.setChecked(true);
        }
        aLN.updateLegendScheme(aLN.getLegendScheme());
        this.selectLayer(aLN);
        if (aLN.getMapLayer().isExpanded()) {
            aLN.expand();
        }
        this.fireLayersUpdatedEvent();
        return handle;
    }

    public int addLayerNode(int index, LayerNode aLN) {
        aLN.setMapFrame(this);
        int handle = this._mapView.addLayer(aLN.getMapLayer());
        aLN.setMapLayer(this._mapView.getLayerByHandle(handle));
        this.addNode(index, aLN);
        if (aLN.getMapLayer().isVisible()) {
            aLN.setChecked(true);
        }
        aLN.updateLegendScheme(aLN.getLegendScheme());
        this.selectLayer(aLN);
        if (aLN.getMapLayer().isExpanded()) {
            aLN.expand();
        }
        this.reOrderMapViewLayers();
        this.fireLayersUpdatedEvent();
        return handle;
    }

    public int addLayerNode(int index, LayerNode aLN, GroupNode aGN) {
        aLN.setMapFrame(this);
        int handle = this._mapView.addLayer(aLN.getMapLayer());
        aLN.setMapLayer(this._mapView.getLayerByHandle(handle));
        aGN.addLayer(index, aLN);
        if (aLN.getMapLayer().isVisible()) {
            aLN.setChecked(true);
        }
        aLN.updateLegendScheme(aLN.getLegendScheme());
        this.selectLayer(aLN);
        if (aLN.getMapLayer().isExpanded()) {
            aLN.expand();
        }
        this.reOrderMapViewLayers();
        this.fireLayersUpdatedEvent();
        return handle;
    }

    public void addGroupNode(GroupNode aGN) {
        this.addNode(aGN);
        for (LayerNode aLN : aGN.getLayers()) {
            this._mapView.addLayer(aLN.getMapLayer());
        }
        this.reOrderMapViewLayers();
        this.fireLayersUpdatedEvent();
    }

    public void addGroupNode(int index, GroupNode aGN) {
        this.addNode(index, aGN);
        for (LayerNode aLN : aGN.getLayers()) {
            this._mapView.addLayer(aLN.getMapLayer());
        }
        this.reOrderMapViewLayers();
        this.fireLayersUpdatedEvent();
    }

    public void addNode(ItemNode aNode) {
        if (aNode.getNodeType() == NodeTypes.GroupNode) {
            ((GroupNode)aNode).setGroupHandle(this.getNewGroupHandle());
            ((GroupNode)aNode).setMapFrame(this);
        } else if (aNode.getNodeType() == NodeTypes.LayerNode) {
            ((LayerNode)aNode).setMapFrame(this);
        }
        this._nodes.add(aNode);
    }

    public void addNode(int idx, ItemNode aNode) {
        if (idx == -1) {
            return;
        }
        if (aNode.getNodeType() == NodeTypes.GroupNode) {
            ((GroupNode)aNode).setGroupHandle(this.getNewGroupHandle());
            ((GroupNode)aNode).setMapFrame(this);
        } else if (aNode.getNodeType() == NodeTypes.LayerNode) {
            ((LayerNode)aNode).setMapFrame(this);
        }
        this._nodes.add(idx, aNode);
    }

    public void removeNode(ItemNode aNode) {
        this._nodes.remove(aNode);
    }

    public void removeLayer(int lIdx) {
        MapLayer aLayer = (MapLayer)this._mapView.getLayers().get(lIdx);
        this.removeLayer(aLayer);
    }

    public void removeLayerByHandle(int handle) {
        int lIdx = this._mapView.getLayerIdxFromHandle(handle);
        if (lIdx > -1) {
            LayerNode aLN = this.getLayerNodeByHandle(handle);
            if (aLN == null) {
                this._mapView.removeLayer(lIdx);
                return;
            }
            if (aLN.getGroupHandle() >= 0) {
                GroupNode gNode = this.getGroupByHandle(aLN.getGroupHandle());
                gNode.removeLayer(aLN);
            } else {
                this.removeNode(aLN);
            }
            this._mapView.removeLayer(lIdx);
            if (lIdx > 0) {
                int newHandle = this._mapView.getLayerHandleFromIdx(lIdx - 1);
                this.selectLayerByHandle(newHandle);
            }
            this._mapView.paintLayers();
            this.fireLayersUpdatedEvent();
        }
    }

    public void removeLayer(MapLayer aLayer) {
        int handle = aLayer.getHandle();
        this.removeLayerByHandle(handle);
    }

    public void removeLayer(LayerNode aLN) {
        this._mapView.removeLayerHandle(aLN.getLayerHandle());
        if (aLN.getGroupHandle() >= 0) {
            GroupNode gNode = this.getGroupByHandle(aLN.getGroupHandle());
            gNode.removeLayer(aLN);
        } else {
            this.removeNode(aLN);
        }
        this._mapView.paintLayers();
        this.fireLayersUpdatedEvent();
    }

    public void removeMeteoLayers() {
        for (int i = 0; i < this._mapView.getLayerNum() && i != this._mapView.getLayerNum(); ++i) {
            MapLayer aLayer = (MapLayer)this._mapView.getLayers().get(i);
            if (!aLayer.getFileName().isEmpty()) continue;
            this.removeLayer(aLayer);
            --i;
        }
    }

    public void removeAllLayers() {
        int lNum = this._mapView.getLayerNum();
        for (int i = 0; i < lNum; ++i) {
            this.removeLayer(0);
        }
    }

    private int getNewGroupHandle() {
        int handle = 0;
        for (ItemNode aTN : this._nodes) {
            if (aTN.getNodeType() != NodeTypes.GroupNode || ((GroupNode)aTN).getGroupHandle() <= handle) continue;
            handle = ((GroupNode)aTN).getGroupHandle();
        }
        return ++handle;
    }

    public GroupNode getGroupByHandle(int handle) {
        GroupNode aGroup = null;
        for (ItemNode aNode : this._nodes) {
            if (aNode.getNodeType() != NodeTypes.GroupNode || ((GroupNode)aNode).getGroupHandle() != handle) continue;
            aGroup = (GroupNode)aNode;
            break;
        }
        return aGroup;
    }

    public GroupNode getGroupByName(String name) {
        GroupNode aGroup = null;
        for (ItemNode aTN : this._nodes) {
            if (aTN.getNodeType() != NodeTypes.GroupNode || !((GroupNode)aTN).getText().equals(name)) continue;
            aGroup = (GroupNode)aTN;
            break;
        }
        return aGroup;
    }

    public void selectLayerByHandle(int handle) {
        LayerNode aLN = this.getLayerNodeByHandle(handle);
        this.selectLayer(aLN);
    }

    private void selectLayer(LayerNode aLN) {
        this.unSelectNodes();
        aLN.setSelected(true);
        this.setSelectedLayer(aLN.getLayerHandle());
        this._mapView.setSelectedLayerHandle(this._selectedLayerHandle);
        if (this._legend != null) {
            this._legend.setSelectedNode(aLN);
        }
    }

    public void unSelectNodes() {
        for (ItemNode aNode : this._nodes) {
            aNode.setSelected(false);
            if (aNode.getNodeType() != NodeTypes.GroupNode) continue;
            for (LayerNode lNode : ((GroupNode)aNode).getLayers()) {
                lNode.setSelected(false);
            }
        }
    }

    public LayerNode getLayerNodeByHandle(int handle) {
        LayerNode aLN = null;
        for (ItemNode aTN : this._nodes) {
            if (aTN.getNodeType() == NodeTypes.LayerNode) {
                if (((LayerNode)aTN).getLayerHandle() != handle) continue;
                aLN = (LayerNode)aTN;
                break;
            }
            boolean find = false;
            for (LayerNode bLN : ((GroupNode)aTN).getLayers()) {
                if (bLN.getLayerHandle() != handle) continue;
                aLN = bLN;
                find = true;
                break;
            }
            if (!find) continue;
            break;
        }
        return aLN;
    }

    public LayerNode getLayerNodeByName(String lName) {
        LayerNode aLN = null;
        for (ItemNode aTN : this._nodes) {
            if (aTN.getNodeType() == NodeTypes.LayerNode) {
                if (!((LayerNode)aTN).getText().equals(lName)) continue;
                aLN = (LayerNode)aTN;
                break;
            }
            boolean find = false;
            for (LayerNode bLN : ((GroupNode)aTN).getLayers()) {
                if (!bLN.getText().equals(lName)) continue;
                aLN = bLN;
                find = true;
                break;
            }
            if (!find) continue;
            break;
        }
        return aLN;
    }

    public void updateLayerNode(MapLayer aLayer) {
        this.updateLayerNode(aLayer.getHandle());
    }

    public void updateLayerNode(int handle) {
        LayerNode aLN = this.getLayerNodeByHandle(handle);
        aLN.update();
        this.fireLayersUpdatedEvent(new LayersUpdatedEvent(this));
    }

    public void UpdateLayerNodeLegendScheme(int handle, LegendScheme aLS) {
        LayerNode aLN = this.getLayerNodeByHandle(handle);
        aLN.updateLegendScheme(aLS);
    }

    public void reOrderMapViewLayers() {
        block0: for (int i = this._nodes.size() - 1; i >= 0; --i) {
            ItemNode aTN = this._nodes.get(i);
            if (aTN.getNodeType() == NodeTypes.LayerNode) {
                for (int j = 0; j < this._mapView.getLayerNum(); ++j) {
                    if (((MapLayer)this._mapView.getLayers().get(j)).getHandle() != ((LayerNode)aTN).getLayerHandle()) continue;
                    if (j <= 0) continue block0;
                    this._mapView.moveLayer(j, 0);
                    continue block0;
                }
                continue;
            }
            block2: for (int l = ((GroupNode)aTN).getLayers().size() - 1; l >= 0; --l) {
                LayerNode aLN = ((GroupNode)aTN).getLayers().get(l);
                for (int j = 0; j < this._mapView.getLayerNum(); ++j) {
                    if (((MapLayer)this._mapView.getLayers().get(j)).getHandle() != aLN.getLayerHandle()) continue;
                    if (j <= 0) continue block2;
                    this._mapView.moveLayer(j, 0);
                    continue block2;
                }
            }
        }
        this._mapView.paintLayers();
        this.fireMapViewUpdatedEvent();
    }

    @Override
    public int getExpandedHeight() {
        int height = this.getHeight();
        for (ItemNode aNode : this._nodes) {
            height += aNode.getDrawHeight() + Constants.ITEM_PAD;
        }
        return height;
    }

    @Override
    public int getDrawHeight() {
        if (this.isExpanded()) {
            return this.getExpandedHeight();
        }
        return this.getHeight();
    }

    public void exportProjectXML(Document m_Doc, Element parent, String projectFilePath) {
        this.addMapFrameElement(m_Doc, parent, projectFilePath);
    }

    private void addMapFrameElement(Document m_Doc, Element parent, String projectFilePath) {
        Element mapFrame = m_Doc.createElement("MapFrame");
        Attr name = m_Doc.createAttribute("Name");
        Attr active = m_Doc.createAttribute("Active");
        Attr expanded = m_Doc.createAttribute("Expanded");
        Attr order = m_Doc.createAttribute("Order");
        Attr Left = m_Doc.createAttribute("Left");
        Attr Top = m_Doc.createAttribute("Top");
        Attr Width = m_Doc.createAttribute("Width");
        Attr Height = m_Doc.createAttribute("Height");
        Attr DrawMapNeatLine = m_Doc.createAttribute("DrawNeatLine");
        Attr MapNeatLineColor = m_Doc.createAttribute("NeatLineColor");
        Attr MapNeatLineSize = m_Doc.createAttribute("NeatLineSize");
        Attr GridLineColor = m_Doc.createAttribute("GridLineColor");
        Attr GridLineSize = m_Doc.createAttribute("GridLineSize");
        Attr GridLineStyle = m_Doc.createAttribute("GridLineStyle");
        Attr DrawGridLine = m_Doc.createAttribute("DrawGridLine");
        Attr DrawGridLabel = m_Doc.createAttribute("DrawGridLabel");
        Attr GridFontName = m_Doc.createAttribute("GridFontName");
        Attr GridFontSize = m_Doc.createAttribute("GridFontSize");
        Attr GridXDelt = m_Doc.createAttribute("GridXDelt");
        Attr GridYDelt = m_Doc.createAttribute("GridYDelt");
        Attr GridXOrigin = m_Doc.createAttribute("GridXOrigin");
        Attr GridYOrigin = m_Doc.createAttribute("GridYOrigin");
        name.setValue(this.getText());
        active.setValue(String.valueOf(this.isActive()));
        expanded.setValue(String.valueOf(this.isExpanded()));
        order.setValue(String.valueOf(this._order));
        Left.setValue(String.valueOf(this._layoutBounds.x));
        Top.setValue(String.valueOf(this._layoutBounds.y));
        Width.setValue(String.valueOf(this._layoutBounds.width));
        Height.setValue(String.valueOf(this._layoutBounds.height));
        DrawMapNeatLine.setValue(String.valueOf(this._drawNeatLine));
        MapNeatLineColor.setValue(ColorUtil.toHexEncoding(this._neatLineColor));
        MapNeatLineSize.setValue(String.valueOf(this._neatLineSize));
        GridLineColor.setValue(ColorUtil.toHexEncoding(this.getGridLineColor()));
        GridLineSize.setValue(String.valueOf(this.getGridLineSize()));
        GridLineStyle.setValue(this.getGridLineStyle().toString());
        DrawGridLine.setValue(String.valueOf(this.isDrawGridLine()));
        DrawGridLabel.setValue(String.valueOf(this.isDrawGridLabel()));
        GridFontName.setValue(this.getGridFont().getFontName());
        GridFontSize.setValue(String.valueOf(this.getGridFont().getSize()));
        GridXDelt.setValue(String.valueOf(this.getGridXDelt()));
        GridYDelt.setValue(String.valueOf(this.getGridYDelt()));
        GridXOrigin.setValue(String.valueOf(this.getGridXOrigin()));
        GridYOrigin.setValue(String.valueOf(this.getGridYOrigin()));
        mapFrame.setAttributeNode(name);
        mapFrame.setAttributeNode(active);
        mapFrame.setAttributeNode(expanded);
        mapFrame.setAttributeNode(order);
        mapFrame.setAttributeNode(Left);
        mapFrame.setAttributeNode(Top);
        mapFrame.setAttributeNode(Width);
        mapFrame.setAttributeNode(Height);
        mapFrame.setAttributeNode(DrawMapNeatLine);
        mapFrame.setAttributeNode(MapNeatLineColor);
        mapFrame.setAttributeNode(MapNeatLineSize);
        mapFrame.setAttributeNode(GridLineColor);
        mapFrame.setAttributeNode(GridLineSize);
        mapFrame.setAttributeNode(GridLineStyle);
        mapFrame.setAttributeNode(DrawGridLine);
        mapFrame.setAttributeNode(DrawGridLabel);
        mapFrame.setAttributeNode(GridFontName);
        mapFrame.setAttributeNode(GridFontSize);
        mapFrame.setAttributeNode(GridXDelt);
        mapFrame.setAttributeNode(GridYDelt);
        mapFrame.setAttributeNode(GridXOrigin);
        mapFrame.setAttributeNode(GridYOrigin);
        this._mapView.exportExtentsElement(m_Doc, mapFrame);
        this._mapView.exportMapPropElement(m_Doc, mapFrame);
        this._mapView.exportGridLineElement(m_Doc, mapFrame);
        this._mapView.exportMaskOutElement(m_Doc, mapFrame);
        this._mapView.exportProjectionElement(m_Doc, mapFrame);
        this.addGroupLayerElement(m_Doc, mapFrame, projectFilePath);
        this._mapView.exportGraphics(m_Doc, mapFrame, this._mapView.getGraphicCollection().getGraphics());
        parent.appendChild(mapFrame);
    }

    private void addGroupLayerElement(Document m_Doc, Element parent, String projectFilePath) {
        Element GroupLayer = m_Doc.createElement("GroupLayer");
        for (int i = 0; i < this._nodes.size(); ++i) {
            ItemNode aTN = this.getNodes().get(i);
            if (aTN.getNodeType() == NodeTypes.LayerNode) {
                MapLayer aLayer = this._mapView.getLayerByHandle(((LayerNode)aTN).getLayerHandle());
                this.addLayerElement(m_Doc, GroupLayer, aLayer, projectFilePath);
                continue;
            }
            this.addGroupElement(m_Doc, GroupLayer, (GroupNode)aTN, projectFilePath);
        }
        parent.appendChild(GroupLayer);
    }

    private void addGroupElement(Document m_Doc, Element parent, GroupNode aGN, String projectFilePath) {
        Element Group2 = m_Doc.createElement("Group");
        Attr GroupHandle = m_Doc.createAttribute("GroupHandle");
        Attr GroupName = m_Doc.createAttribute("GroupName");
        Attr Expanded = m_Doc.createAttribute("Expanded");
        GroupHandle.setValue(String.valueOf(aGN.getGroupHandle()));
        GroupName.setValue(aGN.getText());
        Expanded.setValue(String.valueOf(aGN.isExpanded()));
        Group2.setAttributeNode(GroupHandle);
        Group2.setAttributeNode(GroupName);
        Group2.setAttributeNode(Expanded);
        for (LayerNode aLN : aGN.getLayers()) {
            MapLayer aLayer = this._mapView.getLayerByHandle(aLN.getLayerHandle());
            this.addLayerElement(m_Doc, Group2, aLayer, projectFilePath);
        }
        parent.appendChild(Group2);
    }

    private void addLayerElement(Document m_Doc, Element parent, MapLayer aLayer, String projectFilePath) {
        File aFile = new File(aLayer.getFileName());
        if (aFile.isFile()) {
            switch (aLayer.getLayerType()) {
                case VectorLayer: {
                    VectorLayer aVLayer = (VectorLayer)aLayer;
                    this._mapView.exportVectorLayerElement(m_Doc, parent, aVLayer, projectFilePath);
                    break;
                }
                case ImageLayer: {
                    ImageLayer aILayer = (ImageLayer)aLayer;
                    this._mapView.exportImageLayer(m_Doc, parent, aILayer, projectFilePath);
                    break;
                }
                case RasterLayer: {
                    RasterLayer aRLayer = (RasterLayer)aLayer;
                    this._mapView.exportRasterLayer(m_Doc, parent, aRLayer, projectFilePath);
                }
            }
        } else if (aLayer.getLayerType() == LayerTypes.WebMapLayer) {
            WebMapLayer wmLayer = (WebMapLayer)aLayer;
            this._mapView.exportWebMapLayer(m_Doc, parent, wmLayer, projectFilePath);
        }
    }

    public void importProjectXML(String pPath, Element parent) {
        this.getNodes().clear();
        this.getMapView().removeAllLayers();
        try {
            this.setText(parent.getAttributes().getNamedItem("Name").getNodeValue());
            this.setActive(Boolean.parseBoolean(parent.getAttributes().getNamedItem("Active").getNodeValue()));
            boolean expanded = Boolean.parseBoolean(parent.getAttributes().getNamedItem("Expanded").getNodeValue());
            if (expanded) {
                this.expand();
            } else {
                this.collapse();
            }
        }
        catch (Exception expanded) {
            // empty catch block
        }
        try {
            this._order = Integer.parseInt(parent.getAttributes().getNamedItem("Order").getNodeValue());
            int left = Integer.parseInt(parent.getAttributes().getNamedItem("Left").getNodeValue());
            int top = Integer.parseInt(parent.getAttributes().getNamedItem("Top").getNodeValue());
            int width = Integer.parseInt(parent.getAttributes().getNamedItem("Width").getNodeValue());
            int height = Integer.parseInt(parent.getAttributes().getNamedItem("Height").getNodeValue());
            this._layoutBounds = new Rectangle(left, top, width, height);
            this._drawNeatLine = Boolean.parseBoolean(parent.getAttributes().getNamedItem("DrawNeatLine").getNodeValue());
            this._neatLineColor = ColorUtil.parseToColor(parent.getAttributes().getNamedItem("NeatLineColor").getNodeValue());
            this._neatLineSize = Float.parseFloat(parent.getAttributes().getNamedItem("NeatLineSize").getNodeValue());
            this.setGridLineColor(ColorUtil.parseToColor(parent.getAttributes().getNamedItem("GridLineColor").getNodeValue()));
            this.setGridLineSize(Float.parseFloat(parent.getAttributes().getNamedItem("GridLineSize").getNodeValue()));
            this.setGridLineStyle(LineStyles.valueOf(parent.getAttributes().getNamedItem("GridLineStyle").getNodeValue()));
            this.setDrawGridLine(Boolean.parseBoolean(parent.getAttributes().getNamedItem("DrawGridLine").getNodeValue()));
            this.setDrawGridLabel(Boolean.parseBoolean(parent.getAttributes().getNamedItem("DrawGridLabel").getNodeValue()));
            String fontName = parent.getAttributes().getNamedItem("GridFontName").getNodeValue();
            float fontSize = Float.parseFloat(parent.getAttributes().getNamedItem("GridFontSize").getNodeValue());
            this.setGridFont(new Font(fontName, 0, (int)fontSize));
            this.setGridXDelt(Float.parseFloat(parent.getAttributes().getNamedItem("GridXDelt").getNodeValue()));
            this.setGridYDelt(Float.parseFloat(parent.getAttributes().getNamedItem("GridYDelt").getNodeValue()));
            this.setGridXOrigin(Float.parseFloat(parent.getAttributes().getNamedItem("GridXOrigin").getNodeValue()));
            this.setGridYOrigin(Float.parseFloat(parent.getAttributes().getNamedItem("GridYOrigin").getNodeValue()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._mapView.setLockViewUpdate(true);
        this._mapView.loadMapPropElement(parent);
        this._mapView.loadGridLineElement(parent);
        this._mapView.loadMaskOutElement(parent);
        this._mapView.loadProjectionElement(parent);
        this.loadGroupLayer(pPath, parent);
        this._mapView.loadGraphics(parent);
        this._mapView.loadExtentsElement(parent);
        this._mapView.setLockViewUpdate(false);
    }

    private void loadGroupLayer(String pPath, Element parent) {
        Node theNode = parent.getElementsByTagName("GroupLayer").getLength() > 0 ? parent.getElementsByTagName("GroupLayer").item(0) : parent.getElementsByTagName("Layers").item(0);
        for (int i = 0; i < theNode.getChildNodes().getLength(); ++i) {
            Node aGL = theNode.getChildNodes().item(i);
            if ("Group".equals(aGL.getNodeName())) {
                this.loadGroup(pPath, aGL);
                continue;
            }
            if (!"Layer".equals(aGL.getNodeName())) continue;
            this.loadLayer(pPath, aGL, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGroup(String pPath, Node aGroup) {
        GroupNode aGN = new GroupNode(aGroup.getAttributes().getNamedItem("GroupName").getNodeValue());
        try {
            boolean expanded = Boolean.parseBoolean(aGroup.getAttributes().getNamedItem("Expanded").getNodeValue());
            if (expanded) {
                aGN.expand();
            } else {
                aGN.collapse();
            }
        }
        catch (Exception layerNodes) {
        }
        finally {
            this.addGroup(aGN);
            NodeList layerNodes = ((Element)aGroup).getElementsByTagName("Layer");
            for (int i = 0; i < layerNodes.getLength(); ++i) {
                Node aLayerNode = layerNodes.item(i);
                this.loadLayer(pPath, aLayerNode, aGN.getGroupHandle());
            }
            aGN.updateCheckStatus();
        }
    }

    private void loadLayer(String pPath, Node aLayer, int groupHnd) {
        try {
            LayerTypes aLayerType = LayerTypes.valueOf(aLayer.getAttributes().getNamedItem("LayerType").getNodeValue());
            switch (aLayerType) {
                case VectorLayer: {
                    VectorLayer aVLayer = this._mapView.loadVectorLayer(pPath, aLayer);
                    if (aVLayer == null) break;
                    this.addLayer(aVLayer, groupHnd);
                    break;
                }
                case ImageLayer: {
                    ImageLayer aILayer = this._mapView.loadImageLayer(aLayer);
                    if (aILayer == null) break;
                    this.addLayer(aILayer, groupHnd);
                    break;
                }
                case RasterLayer: {
                    RasterLayer aRLayer = this._mapView.loadRasterLayer(aLayer);
                    if (aRLayer == null) break;
                    this.addLayer(aRLayer, groupHnd);
                    break;
                }
                case WebMapLayer: {
                    WebMapLayer wmLayer = this._mapView.loadWebMapLayer(aLayer);
                    if (wmLayer == null) break;
                    this.addLayer(wmLayer, groupHnd);
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(MapFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static class MapFrameBeanBeanInfo
    extends BaseBeanInfo {
        public MapFrameBeanBeanInfo() {
            super(MapFrameBean.class);
            this.addProperty("text").setCategory("General").setDisplayName("Text");
        }
    }

    public class MapFrameBean {
        public String getText() {
            return MapFrame.this.getText();
        }

        public void setText(String value) {
            MapFrame.this.setText(value);
            MapFrame.this.getLegend().paintGraphics();
        }
    }
}

