/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.fitting;

import java.util.ArrayList;
import org.meteoinfo.math.ArrayMath;
import org.meteoinfo.math.fitting.ExpTrendLine;
import org.meteoinfo.math.fitting.OLSTrendLine;
import org.meteoinfo.math.fitting.PolyTrendLine;
import org.meteoinfo.math.fitting.PowerTrendLine;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;

public class FittingUtil {
    public static Object[] powerFit(Array x, Array y) {
        PowerTrendLine t = new PowerTrendLine();
        t.setValues(y, x);
        double y_mean = ArrayMath.mean(y);
        double sum1 = 0.0;
        double sum2 = 0.0;
        int i = 0;
        while ((long)i < y.getSize()) {
            double py = t.predict(x.getDouble(i));
            sum1 += Math.pow(y.getDouble(i) - py, 2.0);
            sum2 += Math.pow(y.getDouble(i) - y_mean, 2.0);
            ++i;
        }
        double r = 1.0 - sum1 / sum2;
        return new Object[]{Math.exp(t.coef.getEntry(0, 0)), t.coef.getEntry(1, 0), r, t};
    }

    public static Object[] expFit(Array x, Array y) {
        ExpTrendLine t = new ExpTrendLine();
        t.setValues(y, x);
        double y_mean = ArrayMath.mean(y);
        double sum1 = 0.0;
        double sum2 = 0.0;
        int i = 0;
        while ((long)i < y.getSize()) {
            double py = t.predict(x.getDouble(i));
            sum1 += Math.pow(y.getDouble(i) - py, 2.0);
            sum2 += Math.pow(y.getDouble(i) - y_mean, 2.0);
            ++i;
        }
        double r = 1.0 - sum1 / sum2;
        return new Object[]{Math.exp(t.coef.getEntry(0, 0)), t.coef.getEntry(1, 0), r, t};
    }

    public static Object[] polyFit(Array x, Array y, int degree) {
        PolyTrendLine t = new PolyTrendLine(degree);
        t.setValues(y, x);
        double y_mean = ArrayMath.mean(y);
        double sum1 = 0.0;
        double sum2 = 0.0;
        int i = 0;
        while ((long)i < y.getSize()) {
            double py = t.predict(x.getDouble(i));
            sum1 += Math.pow(y.getDouble(i) - py, 2.0);
            sum2 += Math.pow(y.getDouble(i) - y_mean, 2.0);
            ++i;
        }
        double r = 1.0 - sum1 / sum2;
        ArrayList<Double> para = new ArrayList<Double>();
        int n = t.coef.getRowDimension();
        for (int i2 = 0; i2 < n; ++i2) {
            para.add(t.coef.getEntry(n - i2 - 1, 0));
        }
        return new Object[]{para, r, t};
    }

    public static double predict(double x, OLSTrendLine tl) {
        return tl.predict(x);
    }

    public static Array predict(Array x, OLSTrendLine tl) {
        Array y = Array.factory(DataType.DOUBLE, x.getShape());
        int i = 0;
        while ((long)i < y.getSize()) {
            y.setDouble(i, tl.predict(x.getDouble(i)));
            ++i;
        }
        return y;
    }
}

