/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.interpolate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.analysis.BivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.AkimaSplineInterpolator;
import org.apache.commons.math3.analysis.interpolation.BicubicInterpolator;
import org.apache.commons.math3.analysis.interpolation.DividedDifferenceInterpolator;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.interpolation.LoessInterpolator;
import org.apache.commons.math3.analysis.interpolation.NevilleInterpolator;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.meteoinfo.math.ArrayUtil;
import org.meteoinfo.math.spatial.KDTree;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;

public class InterpUtil {
    public static PolynomialSplineFunction linearInterpFunc(Array x, Array y) {
        double[] xd = (double[])ArrayUtil.copyToNDJavaArray(x);
        double[] yd = (double[])ArrayUtil.copyToNDJavaArray(y);
        LinearInterpolator li = new LinearInterpolator();
        PolynomialSplineFunction psf = li.interpolate(xd, yd);
        return psf;
    }

    public static UnivariateFunction getInterpFunc(Array x, Array y, String kind) {
        SplineInterpolator li;
        double[] xd = (double[])ArrayUtil.copyToNDJavaArray(x);
        double[] yd = (double[])ArrayUtil.copyToNDJavaArray(y);
        switch (kind) {
            case "spline": 
            case "cubic": {
                li = new SplineInterpolator();
                break;
            }
            case "akima": {
                li = new AkimaSplineInterpolator();
                break;
            }
            case "divided": {
                li = new DividedDifferenceInterpolator();
                break;
            }
            case "loess": {
                li = new LoessInterpolator();
                break;
            }
            case "neville": {
                li = new NevilleInterpolator();
                break;
            }
            default: {
                li = new LinearInterpolator();
            }
        }
        UnivariateFunction psf = li.interpolate(xd, yd);
        return psf;
    }

    public static BivariateFunction getBiInterpFunc(Array x, Array y, Array z) {
        double[] xd = (double[])ArrayUtil.copyToNDJavaArray(x);
        double[] yd = (double[])ArrayUtil.copyToNDJavaArray(y);
        double[][] zd = (double[][])ArrayUtil.copyToNDJavaArray(z);
        BicubicInterpolator li = new BicubicInterpolator();
        BivariateFunction func = li.interpolate(xd, yd, zd);
        return func;
    }

    public static Array evaluate(UnivariateFunction func, Array x) {
        Array r = Array.factory(DataType.DOUBLE, x.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, func.value(x.getDouble(i)));
            ++i;
        }
        return r;
    }

    public static double evaluate(UnivariateFunction func, Number x) {
        return func.value(x.doubleValue());
    }

    public static Array evaluate(BivariateFunction func, Array x, Array y) {
        Array r = Array.factory(DataType.DOUBLE, x.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, func.value(x.getDouble(i), y.getDouble(i)));
            ++i;
        }
        return r;
    }

    public static double evaluate(BivariateFunction func, Number x, Number y) {
        return func.value(x.doubleValue(), y.doubleValue());
    }

    public static Array cressman(List<Number> x_s, List<Number> y_s, Array v_s, List<Number> X, List<Number> Y, List<Number> radList) {
        double val;
        double sum;
        int j;
        double y;
        double x;
        int i;
        int xNum = X.size();
        int yNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory(DataType.DOUBLE, new int[]{yNum, xNum});
        int irad = radList.size();
        double xMin = X.get(0).doubleValue();
        double yMin = Y.get(0).doubleValue();
        double xDelt = X.get(1).doubleValue() - X.get(0).doubleValue();
        double yDelt = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        double[][] stationData = new double[pNum][5];
        for (i = 0; i < pNum; ++i) {
            x = x_s.get(i).doubleValue();
            y = y_s.get(i).doubleValue();
            stationData[i][0] = x;
            stationData[i][1] = y;
            stationData[i][2] = v_s.getDouble(i);
            stationData[i][3] = (x - xMin) / xDelt;
            stationData[i][4] = (y - yMin) / yDelt;
        }
        KDTree.Euclidean<double[]> kdTree = new KDTree.Euclidean<double[]>(2);
        for (i = 0; i < pNum; ++i) {
            if (Double.isNaN(stationData[i][2])) continue;
            kdTree.addPoint(new double[]{stationData[i][0], stationData[i][1]}, stationData[i]);
        }
        double HITOP = -9.999E20;
        double HIBOT = 9.999E20;
        double[][] TOP = new double[yNum][xNum];
        double[][] BOT = new double[yNum][xNum];
        for (i = 0; i < yNum; ++i) {
            for (j = 0; j < xNum; ++j) {
                TOP[i][j] = HITOP;
                BOT[i][j] = HIBOT;
            }
        }
        double rad = radList.size() > 0 ? radList.get(0).doubleValue() : 4.0;
        for (i = 0; i < yNum; ++i) {
            y = Y.get(i).doubleValue();
            for (j = 0; j < xNum; ++j) {
                x = X.get(j).doubleValue();
                int stNum = 0;
                sum = 0.0;
                ArrayList neighbours = kdTree.ballSearch(new double[]{x, y}, rad * rad);
                for (double[] station : neighbours) {
                    val = station[2];
                    sum += val;
                    ++stNum;
                    if (TOP[i][j] < val) {
                        TOP[i][j] = val;
                    }
                    if (!(BOT[i][j] > val)) continue;
                    BOT[i][j] = val;
                }
                if (stNum == 0) {
                    r.setDouble(i * xNum + j, Double.NaN);
                    continue;
                }
                r.setDouble(i * xNum + j, sum / (double)stNum);
            }
        }
        for (int p = 0; p < irad; ++p) {
            rad = radList.get(p).doubleValue();
            for (i = 0; i < yNum; ++i) {
                y = Y.get(i).doubleValue();
                for (j = 0; j < xNum; ++j) {
                    if (Double.isNaN(r.getDouble(i * xNum + j))) continue;
                    x = X.get(j).doubleValue();
                    sum = 0.0;
                    double wSum = 0.0;
                    ArrayList neighbours = kdTree.ballSearch(new double[]{x, y}, rad * rad);
                    for (double[] station : neighbours) {
                        double calVal;
                        val = station[2];
                        double sx = station[0];
                        double sy = station[1];
                        double sxi = station[3];
                        double syi = station[4];
                        if (sxi < 0.0 || sxi >= (double)(xNum - 1) || syi < 0.0 || syi >= (double)(yNum - 1)) continue;
                        double dis = Math.sqrt(Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0));
                        int i1 = (int)syi;
                        int j1 = (int)sxi;
                        int i2 = i1 + 1;
                        int j2 = j1 + 1;
                        double a = r.getDouble(i1 * xNum + j1);
                        double b = r.getDouble(i1 * xNum + j2);
                        double c = r.getDouble(i2 * xNum + j1);
                        double d = r.getDouble(i2 * xNum + j2);
                        ArrayList<Double> dList = new ArrayList<Double>();
                        if (!Double.isNaN(a)) {
                            dList.add(a);
                        }
                        if (!Double.isNaN(b)) {
                            dList.add(b);
                        }
                        if (!Double.isNaN(c)) {
                            dList.add(c);
                        }
                        if (Double.isNaN(d)) {
                            dList.add(d);
                        }
                        if (dList.isEmpty()) continue;
                        if (dList.size() == 1) {
                            calVal = (Double)dList.get(0);
                        } else if (dList.size() <= 3) {
                            double aSum = 0.0;
                            Iterator iterator = dList.iterator();
                            while (iterator.hasNext()) {
                                double dd = (Double)iterator.next();
                                aSum += dd;
                            }
                            calVal = aSum / (double)dList.size();
                        } else {
                            double x1val = a + (c - a) * (syi - (double)i1);
                            double x2val = b + (d - b) * (syi - (double)i1);
                            calVal = x1val + (x2val - x1val) * (sxi - (double)j1);
                        }
                        double eVal = val - calVal;
                        double w = (rad * rad - dis * dis) / (rad * rad + dis * dis);
                        sum += eVal * w;
                        wSum += w;
                    }
                    if (!(wSum >= 1.0E-6)) continue;
                    double aData = r.getDouble(i * xNum + j) + sum / wSum;
                    r.setDouble(i * xNum + j, Math.max(BOT[i][j], Math.min(TOP[i][j], aData)));
                }
            }
        }
        return r;
    }

    public static Array barnes(List<Number> x_s, List<Number> y_s, Array v_s, List<Number> X, List<Number> Y, List<Number> radList, double kappa, double gamma) {
        double w;
        double sy;
        double sx;
        double val;
        double wSum;
        double sum;
        int j;
        double y;
        double x;
        int i;
        int xNum = X.size();
        int yNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory(DataType.DOUBLE, new int[]{yNum, xNum});
        int irad = radList.size();
        double xMin = X.get(0).doubleValue();
        double yMin = Y.get(0).doubleValue();
        double xDelt = X.get(1).doubleValue() - X.get(0).doubleValue();
        double yDelt = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        double[][] stationData = new double[pNum][5];
        for (i = 0; i < pNum; ++i) {
            x = x_s.get(i).doubleValue();
            y = y_s.get(i).doubleValue();
            stationData[i][0] = x;
            stationData[i][1] = y;
            stationData[i][2] = v_s.getDouble(i);
            stationData[i][3] = (x - xMin) / xDelt;
            stationData[i][4] = (y - yMin) / yDelt;
        }
        KDTree.Euclidean<double[]> kdTree = new KDTree.Euclidean<double[]>(2);
        for (i = 0; i < pNum; ++i) {
            if (Double.isNaN(stationData[i][2])) continue;
            kdTree.addPoint(new double[]{stationData[i][0], stationData[i][1]}, stationData[i]);
        }
        double HITOP = -9.999E20;
        double HIBOT = 9.999E20;
        double[][] TOP = new double[yNum][xNum];
        double[][] BOT = new double[yNum][xNum];
        for (i = 0; i < yNum; ++i) {
            for (j = 0; j < xNum; ++j) {
                TOP[i][j] = HITOP;
                BOT[i][j] = HIBOT;
            }
        }
        double rad = radList.size() > 0 ? radList.get(0).doubleValue() : 4.0;
        for (i = 0; i < yNum; ++i) {
            y = Y.get(i).doubleValue();
            for (j = 0; j < xNum; ++j) {
                x = X.get(j).doubleValue();
                int stNum = 0;
                sum = 0.0;
                wSum = 0.0;
                ArrayList neighbours = kdTree.ballSearch(new double[]{x, y}, rad * rad);
                for (double[] station : neighbours) {
                    val = station[2];
                    sx = station[0];
                    sy = station[1];
                    double dis = Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0);
                    w = Math.exp(-dis / (4.0 * kappa));
                    wSum += w;
                    sum += w * val;
                    ++stNum;
                    if (TOP[i][j] < val) {
                        TOP[i][j] = val;
                    }
                    if (!(BOT[i][j] > val)) continue;
                    BOT[i][j] = val;
                }
                if (stNum == 0) {
                    r.setDouble(i * xNum + j, Double.NaN);
                    continue;
                }
                r.setDouble(i * xNum + j, sum / (double)stNum);
            }
        }
        for (int p = 0; p < irad; ++p) {
            rad = radList.get(p).doubleValue();
            for (i = 0; i < yNum; ++i) {
                y = Y.get(i).doubleValue();
                for (j = 0; j < xNum; ++j) {
                    if (Double.isNaN(r.getDouble(i * xNum + j))) continue;
                    x = X.get(j).doubleValue();
                    sum = 0.0;
                    wSum = 0.0;
                    ArrayList neighbours = kdTree.ballSearch(new double[]{x, y}, rad * rad);
                    for (double[] station : neighbours) {
                        double calVal;
                        val = station[2];
                        sx = station[0];
                        sy = station[1];
                        double sxi = station[3];
                        double syi = station[4];
                        if (sxi < 0.0 || sxi >= (double)(xNum - 1) || syi < 0.0 || syi >= (double)(yNum - 1)) continue;
                        double dis = Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0);
                        int i1 = (int)syi;
                        int j1 = (int)sxi;
                        int i2 = i1 + 1;
                        int j2 = j1 + 1;
                        double a = r.getDouble(i1 * xNum + j1);
                        double b = r.getDouble(i1 * xNum + j2);
                        double c = r.getDouble(i2 * xNum + j1);
                        double d = r.getDouble(i2 * xNum + j2);
                        ArrayList<Double> dList = new ArrayList<Double>();
                        if (!Double.isNaN(a)) {
                            dList.add(a);
                        }
                        if (!Double.isNaN(b)) {
                            dList.add(b);
                        }
                        if (!Double.isNaN(c)) {
                            dList.add(c);
                        }
                        if (Double.isNaN(d)) {
                            dList.add(d);
                        }
                        if (dList.isEmpty()) continue;
                        if (dList.size() == 1) {
                            calVal = (Double)dList.get(0);
                        } else if (dList.size() <= 3) {
                            double aSum = 0.0;
                            Iterator iterator = dList.iterator();
                            while (iterator.hasNext()) {
                                double dd = (Double)iterator.next();
                                aSum += dd;
                            }
                            calVal = aSum / (double)dList.size();
                        } else {
                            double x1val = a + (c - a) * (syi - (double)i1);
                            double x2val = b + (d - b) * (syi - (double)i1);
                            calVal = x1val + (x2val - x1val) * (sxi - (double)j1);
                        }
                        double eVal = val - calVal;
                        w = Math.exp(-dis / (4.0 * kappa * gamma));
                        sum += eVal * w;
                        wSum += w;
                    }
                    if (!(wSum >= 1.0E-6)) continue;
                    double aData = r.getDouble(i * xNum + j) + sum / wSum;
                    r.setDouble(i * xNum + j, Math.max(BOT[i][j], Math.min(TOP[i][j], aData)));
                }
            }
        }
        return r;
    }

    public static Array barnes(List<Number> x_s, List<Number> y_s, Array v_s, List<Number> X, List<Number> Y, double kappa, double gamma) {
        double w;
        double sy;
        double sx;
        double val;
        double wSum;
        double sum;
        int j;
        double y;
        double x;
        int i;
        int xNum = X.size();
        int yNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory(DataType.DOUBLE, new int[]{yNum, xNum});
        double xMin = X.get(0).doubleValue();
        double xMax = X.get(xNum - 1).doubleValue();
        double yMin = Y.get(0).doubleValue();
        double yMax = Y.get(yNum - 1).doubleValue();
        double xDelt = X.get(1).doubleValue() - X.get(0).doubleValue();
        double yDelt = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        double[][] stationData = new double[pNum][5];
        for (i = 0; i < pNum; ++i) {
            x = x_s.get(i).doubleValue();
            y = y_s.get(i).doubleValue();
            stationData[i][0] = x;
            stationData[i][1] = y;
            stationData[i][2] = v_s.getDouble(i);
            stationData[i][3] = (x - xMin) / xDelt;
            stationData[i][4] = (y - yMin) / yDelt;
        }
        for (i = 0; i < yNum; ++i) {
            y = Y.get(i).doubleValue();
            for (j = 0; j < xNum; ++j) {
                x = X.get(j).doubleValue();
                sum = 0.0;
                wSum = 0.0;
                for (double[] station : stationData) {
                    val = station[2];
                    sx = station[0];
                    sy = station[1];
                    if (Double.isNaN(val) || sx < xMin || sx > xMax || sy < yMin || sy > yMax) continue;
                    double dis = Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0);
                    w = Math.exp(-dis / (4.0 * kappa));
                    wSum += w;
                    sum += w * val;
                }
                r.setDouble(i * xNum + j, sum / wSum);
            }
        }
        for (i = 0; i < yNum; ++i) {
            y = Y.get(i).doubleValue();
            for (j = 0; j < xNum; ++j) {
                x = X.get(j).doubleValue();
                sum = 0.0;
                wSum = 0.0;
                for (double[] station : stationData) {
                    double calVal;
                    val = station[2];
                    sx = station[0];
                    sy = station[1];
                    double sxi = station[3];
                    double syi = station[4];
                    if (Double.isNaN(val) || sx < xMin || sx > xMax || sy < yMin || sy > yMax) continue;
                    int i1 = (int)syi;
                    int j1 = (int)sxi;
                    int i2 = i1 + 1;
                    int j2 = j1 + 1;
                    double a = r.getDouble(i1 * xNum + j1);
                    double b = r.getDouble(i1 * xNum + j2);
                    double c = r.getDouble(i2 * xNum + j1);
                    double d = r.getDouble(i2 * xNum + j2);
                    ArrayList<Double> dList = new ArrayList<Double>();
                    if (!Double.isNaN(a)) {
                        dList.add(a);
                    }
                    if (!Double.isNaN(b)) {
                        dList.add(b);
                    }
                    if (!Double.isNaN(c)) {
                        dList.add(c);
                    }
                    if (Double.isNaN(d)) {
                        dList.add(d);
                    }
                    if (dList.isEmpty()) continue;
                    if (dList.size() == 1) {
                        calVal = (Double)dList.get(0);
                    } else if (dList.size() <= 3) {
                        double aSum = 0.0;
                        Iterator iterator = dList.iterator();
                        while (iterator.hasNext()) {
                            double dd = (Double)iterator.next();
                            aSum += dd;
                        }
                        calVal = aSum / (double)dList.size();
                    } else {
                        double x1val = a + (c - a) * (syi - (double)i1);
                        double x2val = b + (d - b) * (syi - (double)i1);
                        calVal = x1val + (x2val - x1val) * (sxi - (double)j1);
                    }
                    double eVal = val - calVal;
                    double dis = Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0);
                    w = Math.exp(-dis / (4.0 * kappa * gamma));
                    wSum += w;
                    sum += w * eVal;
                }
                r.setDouble(i * xNum + j, r.getDouble(i * xNum + j) + sum / wSum);
            }
        }
        return r;
    }
}

