/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray;

import java.util.Formatter;
import java.util.List;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.ArraySequence;
import org.meteoinfo.ndarray.ArrayStructureBak;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.StructureDataScalar;
import org.meteoinfo.ndarray.StructureMembers;
import org.meteoinfo.util.Indent;

public abstract class StructureData {
    public static final StructureData EMPTY = new StructureDataScalar("empty");
    protected StructureMembers members;

    protected StructureData(StructureMembers members) {
        this.members = members;
    }

    public String getName() {
        return this.members.getName();
    }

    public StructureMembers getStructureMembers() {
        return this.members;
    }

    public List<StructureMembers.Member> getMembers() {
        return this.members.getMembers();
    }

    public StructureMembers.Member findMember(String memberName) {
        return this.members.findMember(memberName);
    }

    public abstract Array getArray(StructureMembers.Member var1);

    public Array getArray(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getArray(m);
    }

    public Object getScalarObject(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getScalarObject(m);
    }

    public Object getScalarObject(StructureMembers.Member m) {
        DataType dataType = m.getDataType();
        if (dataType == DataType.DOUBLE) {
            return this.getScalarDouble(m);
        }
        if (dataType == DataType.FLOAT) {
            return Float.valueOf(this.getScalarFloat(m));
        }
        if (dataType == DataType.BYTE || dataType == DataType.ENUM1) {
            return this.getScalarByte(m);
        }
        if (dataType == DataType.SHORT || dataType == DataType.ENUM2) {
            return this.getScalarShort(m);
        }
        if (dataType == DataType.INT || dataType == DataType.ENUM4) {
            return this.getScalarInt(m);
        }
        if (dataType == DataType.LONG) {
            return this.getScalarLong(m);
        }
        if (dataType == DataType.CHAR) {
            return this.getScalarString(m);
        }
        if (dataType == DataType.STRING) {
            return this.getScalarString(m);
        }
        if (dataType == DataType.STRUCTURE) {
            return this.getScalarStructure(m);
        }
        if (dataType == DataType.SEQUENCE) {
            return this.getArraySequence(m);
        }
        throw new RuntimeException("Dont have implemenation for " + (Object)((Object)dataType));
    }

    public float convertScalarFloat(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.convertScalarFloat(m);
    }

    public abstract float convertScalarFloat(StructureMembers.Member var1);

    public double convertScalarDouble(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.convertScalarDouble(m);
    }

    public abstract double convertScalarDouble(StructureMembers.Member var1);

    public int convertScalarInt(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.convertScalarInt(m);
    }

    public abstract int convertScalarInt(StructureMembers.Member var1);

    public long convertScalarLong(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.convertScalarLong(m);
    }

    public abstract long convertScalarLong(StructureMembers.Member var1);

    public double getScalarDouble(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getScalarDouble(m);
    }

    public abstract double getScalarDouble(StructureMembers.Member var1);

    public double[] getJavaArrayDouble(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getJavaArrayDouble(m);
    }

    public abstract double[] getJavaArrayDouble(StructureMembers.Member var1);

    public float getScalarFloat(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getScalarFloat(m);
    }

    public abstract float getScalarFloat(StructureMembers.Member var1);

    public float[] getJavaArrayFloat(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getJavaArrayFloat(m);
    }

    public abstract float[] getJavaArrayFloat(StructureMembers.Member var1);

    public byte getScalarByte(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getScalarByte(m);
    }

    public abstract byte getScalarByte(StructureMembers.Member var1);

    public byte[] getJavaArrayByte(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getJavaArrayByte(m);
    }

    public abstract byte[] getJavaArrayByte(StructureMembers.Member var1);

    public int getScalarInt(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getScalarInt(m);
    }

    public abstract int getScalarInt(StructureMembers.Member var1);

    public int[] getJavaArrayInt(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getJavaArrayInt(m);
    }

    public abstract int[] getJavaArrayInt(StructureMembers.Member var1);

    public short getScalarShort(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getScalarShort(m);
    }

    public abstract short getScalarShort(StructureMembers.Member var1);

    public short[] getJavaArrayShort(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getJavaArrayShort(m);
    }

    public abstract short[] getJavaArrayShort(StructureMembers.Member var1);

    public long getScalarLong(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getScalarLong(m);
    }

    public abstract long getScalarLong(StructureMembers.Member var1);

    public long[] getJavaArrayLong(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getJavaArrayLong(m);
    }

    public abstract long[] getJavaArrayLong(StructureMembers.Member var1);

    public char getScalarChar(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getScalarChar(m);
    }

    public abstract char getScalarChar(StructureMembers.Member var1);

    public char[] getJavaArrayChar(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getJavaArrayChar(m);
    }

    public abstract char[] getJavaArrayChar(StructureMembers.Member var1);

    public String getScalarString(String memberName) {
        StructureMembers.Member m = this.findMember(memberName);
        if (null == m) {
            throw new IllegalArgumentException("Member not found= " + memberName);
        }
        return this.getScalarString(m);
    }

    public abstract String getScalarString(StructureMembers.Member var1);

    public String[] getJavaArrayString(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getJavaArrayString(m);
    }

    public abstract String[] getJavaArrayString(StructureMembers.Member var1);

    public StructureData getScalarStructure(String memberName) {
        StructureMembers.Member m = this.findMember(memberName);
        if (null == m) {
            throw new IllegalArgumentException("Member not found= " + memberName);
        }
        return this.getScalarStructure(m);
    }

    public abstract StructureData getScalarStructure(StructureMembers.Member var1);

    public ArrayStructureBak getArrayStructure(String memberName) {
        StructureMembers.Member m = this.findMember(memberName);
        if (null == m) {
            throw new IllegalArgumentException("Member not found= " + memberName);
        }
        return this.getArrayStructure(m);
    }

    public abstract ArrayStructureBak getArrayStructure(StructureMembers.Member var1);

    public ArraySequence getArraySequence(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getArraySequence(m);
    }

    public abstract ArraySequence getArraySequence(StructureMembers.Member var1);

    public void showInternal(Formatter f, Indent indent) {
        f.format("%sStructureData %s class=%s hash=0x%x%n", indent, this.members.getName(), this.getClass().getName(), this.hashCode());
    }

    public void showInternalMembers(Formatter f, Indent indent) {
        f.format("%sStructureData %s class=%s hash=0x%x%n", indent, this.members.getName(), this.getClass().getName(), this.hashCode());
        indent.incr();
        for (StructureMembers.Member m : this.getMembers()) {
            m.showInternal(f, indent);
        }
        indent.incr();
    }

    public String toString() {
        return this.members.toString();
    }
}

