/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.info;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.global.PointD;
import org.meteoinfo.math.ArrayUtil;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.info.Albers;
import org.meteoinfo.projection.info.Common;
import org.meteoinfo.projection.info.GeostationarySatellite;
import org.meteoinfo.projection.info.Hammer;
import org.meteoinfo.projection.info.LambertAzimuthalEqualArea;
import org.meteoinfo.projection.info.LambertConformalConic;
import org.meteoinfo.projection.info.LambertEqualAreaConic;
import org.meteoinfo.projection.info.LongLat;
import org.meteoinfo.projection.info.Mercator;
import org.meteoinfo.projection.info.Molleweide;
import org.meteoinfo.projection.info.OrthographicAzimuthal;
import org.meteoinfo.projection.info.Robinson;
import org.meteoinfo.projection.info.Sinusoidal;
import org.meteoinfo.projection.info.StereographicAzimuthal;
import org.meteoinfo.projection.info.TransverseMercator;
import org.meteoinfo.projection.info.Wagner3;
import org.meteoinfo.projection.proj4j.CRSFactory;
import org.meteoinfo.projection.proj4j.CoordinateReferenceSystem;
import org.meteoinfo.projection.proj4j.proj.Projection;
import org.meteoinfo.shape.PolygonShape;

public abstract class ProjectionInfo {
    protected CoordinateReferenceSystem crs;
    protected PolygonShape boundary;
    protected float cutoff = Float.NaN;

    public static ProjectionInfo factory(CoordinateReferenceSystem crs) {
        ProjectionInfo projInfo;
        Projection proj = crs.getProjection();
        switch (proj.toString()) {
            case "LongLat": {
                projInfo = new LongLat(crs);
                break;
            }
            case "Albers Equal Area": {
                projInfo = new Albers(crs);
                break;
            }
            case "Lambert Conformal Conic": {
                projInfo = new LambertConformalConic(crs);
                break;
            }
            case "Lambert Equal Area Conic": {
                projInfo = new LambertEqualAreaConic(crs);
                break;
            }
            case "Lambert Azimuthal Equal Area": {
                projInfo = new LambertAzimuthalEqualArea(crs);
                break;
            }
            case "Stereographic Azimuthal": {
                projInfo = new StereographicAzimuthal(crs);
                break;
            }
            case "Mercator": {
                projInfo = new Mercator(crs);
                break;
            }
            case "Robinson": {
                projInfo = new Robinson(crs);
                break;
            }
            case "Molleweide": {
                projInfo = new Molleweide(crs);
                break;
            }
            case "Geostationary Satellite": {
                projInfo = new GeostationarySatellite(crs);
                break;
            }
            case "Sinusoidal": {
                projInfo = new Sinusoidal(crs);
                break;
            }
            case "Orthographic Azimuthal": {
                projInfo = new OrthographicAzimuthal(crs);
                break;
            }
            case "Hammer Eckert": {
                projInfo = new Hammer(crs);
                break;
            }
            case "Universal Tranverse Mercator": 
            case "Transverse Mercator": {
                projInfo = new TransverseMercator(crs);
                break;
            }
            case "Wagner III": {
                projInfo = new Wagner3(crs);
                break;
            }
            default: {
                projInfo = new Common(crs);
            }
        }
        projInfo.updateBoundary();
        return projInfo;
    }

    public static ProjectionInfo factory(String proj4Str) {
        CRSFactory crsFactory = new CRSFactory();
        proj4Str = proj4Str.replace("+", " +");
        proj4Str = proj4Str.trim();
        return ProjectionInfo.factory(crsFactory.createFromParameters("custom", proj4Str));
    }

    public static ProjectionInfo factory(ProjectionNames name) {
        CRSFactory crsFactory = new CRSFactory();
        String proj4Str = "+proj=" + name.getProj4Name();
        return ProjectionInfo.factory(crsFactory.createFromParameters("custom", proj4Str));
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public abstract ProjectionNames getProjectionName();

    public boolean isLonLat() {
        return this.getProjectionName() == ProjectionNames.LongLat;
    }

    public double getCenterLon() {
        return this.crs.getProjection().getProjectionLongitudeDegrees();
    }

    public double getCenterLat() {
        return this.crs.getProjection().getProjectionLatitudeDegrees();
    }

    public PolygonShape getBoundary() {
        return this.boundary;
    }

    public void setBoundary(PolygonShape value) {
        this.boundary = value;
    }

    public float getCutoff() {
        return this.cutoff;
    }

    public void setCutoff(float value) {
    }

    public void setCutoff_bak(float value) {
        this.cutoff = value;
        this.updateBoundary();
    }

    public List<String> getValidParas() {
        return new ArrayList<String>();
    }

    void updateBoundary() {
    }

    protected List<PointD> ellipse_boundary(double semimajor, double semiminor, double easting, double northing, int n) {
        Array t = ArrayUtil.lineSpace(0, Math.PI * -2, n, true);
        ArrayList<PointD> r = new ArrayList<PointD>();
        int i = 0;
        while ((long)i < t.getSize()) {
            double x = semimajor * Math.cos(t.getDouble(i)) + easting;
            double y = semiminor * Math.sin(t.getDouble(i)) + northing;
            r.add(new PointD(x, y));
            ++i;
        }
        return r;
    }

    public double getRefCutLon() {
        double refLon = this.getCoordinateReferenceSystem().getProjection().getProjectionLongitudeDegrees();
        if ((refLon += 180.0) > 180.0) {
            refLon -= 360.0;
        } else if (refLon < -180.0) {
            refLon += 360.0;
        }
        return refLon;
    }

    public String toProj4String() {
        return this.crs.getParameterString();
    }

    public String toEsriString() {
        return this.crs.toEsriString();
    }

    public String toString() {
        return this.crs.getParameterString();
    }

    public boolean equals(ProjectionInfo projInfo) {
        String proj4Str2;
        if (this.getProjectionName() == ProjectionNames.LongLat && projInfo.getProjectionName() == ProjectionNames.LongLat) {
            return true;
        }
        String proj4Str1 = this.toProj4String();
        if (proj4Str1.equals(proj4Str2 = projInfo.toProj4String())) {
            return true;
        }
        if (!this.crs.getDatum().isEqual(projInfo.crs.getDatum())) {
            return false;
        }
        return this.crs.getProjection().isEqual(projInfo.crs.getProjection());
    }

    public static double calScaleFactorFromStandardParallel(double stP) {
        double e = 0.081819191;
        double tF = (stP = Math.PI * stP / 180.0) > 0.0 ? Math.tan(0.7853981633974483 - stP / 2.0) * Math.pow((1.0 + e * Math.sin(stP)) / (1.0 - e * Math.sin(stP)), e / 2.0) : Math.tan(0.7853981633974483 + stP / 2.0) / Math.pow((1.0 + e * Math.sin(stP)) / (1.0 - e * Math.sin(stP)), e / 2.0);
        double mF = Math.cos(stP) / Math.pow(1.0 - e * e * Math.pow(Math.sin(stP), 2.0), 0.5);
        double k0 = mF * Math.pow(Math.pow(1.0 + e, 1.0 + e) * Math.pow(1.0 - e, 1.0 - e), 0.5) / (2.0 * tF);
        return k0;
    }
}

