/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.proj4j;

import org.meteoinfo.projection.proj4j.CoordinateReferenceSystem;
import org.meteoinfo.projection.proj4j.InvalidValueException;
import org.meteoinfo.projection.proj4j.Registry;
import org.meteoinfo.projection.proj4j.UnknownAuthorityCodeException;
import org.meteoinfo.projection.proj4j.UnsupportedParameterException;
import org.meteoinfo.projection.proj4j.io.Proj4FileReader;
import org.meteoinfo.projection.proj4j.parser.Proj4Parser;

public class CRSFactory {
    private static Proj4FileReader csReader = new Proj4FileReader();
    private static Registry registry = new Registry();

    public Registry getRegistry() {
        return registry;
    }

    public CoordinateReferenceSystem createFromName(String name) throws UnsupportedParameterException, InvalidValueException, UnknownAuthorityCodeException {
        String[] params = csReader.getParameters(name);
        if (params == null) {
            throw new UnknownAuthorityCodeException(name);
        }
        return this.createFromParameters(name, params);
    }

    public CoordinateReferenceSystem createFromParameters(String name, String paramStr) throws UnsupportedParameterException, InvalidValueException {
        return this.createFromParameters(name, CRSFactory.splitParameters(paramStr));
    }

    public CoordinateReferenceSystem createFromParameters(String name, String[] params) throws UnsupportedParameterException, InvalidValueException {
        if (params == null) {
            return null;
        }
        Proj4Parser parser = new Proj4Parser(registry);
        return parser.parse(name, params);
    }

    private static String[] splitParameters(String paramStr) {
        String[] params = paramStr.split("\\s+");
        return params;
    }

    public CoordinateReferenceSystem createFromEsriString(String esriString) {
        Proj4Parser parser = new Proj4Parser(registry);
        return parser.parseEsri(esriString);
    }
}

