/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.shape;

import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Geometry;
import org.meteoinfo.global.Extent3D;
import org.meteoinfo.global.PointD;
import org.meteoinfo.shape.PointShape;
import org.meteoinfo.shape.PointZ;
import org.meteoinfo.shape.ShapeTypes;

public class PointZShape
extends PointShape {
    public PointZShape() {
        this.point = new PointZ();
        this.updateExtent((PointZ)this.point);
    }

    public PointZShape(Geometry geometry) {
        CoordinateXYZM c = (CoordinateXYZM)geometry.getCoordinate();
        this.setPoint(new PointZ(c.x, c.y, c.getZ(), c.getM()));
    }

    @Override
    public ShapeTypes getShapeType() {
        return ShapeTypes.PointZ;
    }

    @Override
    public void setPoint(PointD aPoint) {
        if (aPoint instanceof PointZ) {
            this.point = aPoint;
        } else {
            this.point.X = aPoint.X;
            this.point.Y = aPoint.Y;
        }
        this.updateExtent((PointZ)this.point);
    }

    public void setPoint(PointZ p) {
        this.point = p;
        this.updateExtent(p);
    }

    public void updateExtent(PointZ p) {
        Extent3D aExtent = new Extent3D();
        aExtent.minX = p.X;
        aExtent.maxX = p.X;
        aExtent.minY = p.Y;
        aExtent.maxY = p.Y;
        aExtent.minZ = p.Z;
        aExtent.maxZ = p.Z;
        this.setExtent(aExtent);
    }

    public double getM() {
        return ((PointZ)this.getPoint()).M;
    }

    public double getZ() {
        return ((PointZ)this.getPoint()).Z;
    }

    @Override
    public Object clone() {
        PointZShape aPS = new PointZShape();
        aPS.setPoint((PointZ)this.getPoint().clone());
        aPS.setValue(this.getValue());
        aPS.setVisible(this.isVisible());
        aPS.setSelected(this.isSelected());
        aPS.setLegendIndex(this.getLegendIndex());
        return aPS;
    }
}

