/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.jogl;

import com.jogamp.opengl.GL2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.chart.jogl.IsosurfaceGraphics;
import org.meteoinfo.chart.jogl.SurfaceGraphics;
import org.meteoinfo.chart.jogl.TextureShape;
import org.meteoinfo.chart.jogl.mc.CallbackMC;
import org.meteoinfo.chart.jogl.mc.MarchingCubes;
import org.meteoinfo.chart.plot3d.GraphicCollection3D;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.Extent3D;
import org.meteoinfo.layer.ImageLayer;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.shape.Graphic;
import org.meteoinfo.shape.GraphicCollection;
import org.meteoinfo.shape.ImageShape;
import org.meteoinfo.shape.PointZ;

public class JOGLUtil {
    public static float[] getRGBA(ColorBreak cb) {
        return cb.getColor().getRGBComponents(null);
    }

    public static GraphicCollection createTexture(GL2 gl, ImageLayer layer, double offset, double xshift, String interpolation) throws IOException {
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZDir("z");
        graphics.setZValue(offset);
        TextureShape ishape = new TextureShape();
        ishape.setFileName(layer.getFileName());
        Extent extent = layer.getExtent();
        Extent3D ex3 = new Extent3D(extent.minX + xshift, extent.maxX + xshift, extent.minY, extent.maxY, offset, offset);
        ArrayList<PointZ> coords = new ArrayList<PointZ>();
        coords.add(new PointZ(extent.minX + xshift, extent.minY, offset));
        coords.add(new PointZ(extent.maxX + xshift, extent.minY, offset));
        coords.add(new PointZ(extent.maxX + xshift, extent.maxY, offset));
        coords.add(new PointZ(extent.minX + xshift, extent.maxY, offset));
        ishape.setExtent(ex3);
        ishape.setCoords(coords);
        Graphic gg = new Graphic(ishape, new ColorBreak());
        if (interpolation != null) {
            ((ImageShape)gg.getShape()).setInterpolation(interpolation);
        }
        graphics.add(gg);
        return graphics;
    }

    public static SurfaceGraphics surface(Array xa, Array ya, Array za, LegendScheme ls) {
        SurfaceGraphics graphics = new SurfaceGraphics();
        int[] shape = xa.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        PointZ[][] vertices = new PointZ[rowNum][colNum];
        for (int i = 0; i < rowNum; ++i) {
            for (int j = 0; j < colNum; ++j) {
                int idx = i * colNum + j;
                vertices[i][j] = new PointZ(xa.getDouble(idx), ya.getDouble(idx), za.getDouble(idx), za.getDouble(idx));
            }
        }
        graphics.setVertices(vertices);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection isosurface(Array data, Array x, Array y, Array z, float isoLevel, PolygonBreak pb) {
        ArrayList<float[]> vertices = MarchingCubes.marchingCubes(data, x, y, z, isoLevel);
        IsosurfaceGraphics graphics = new IsosurfaceGraphics();
        graphics.setLegendBreak(pb);
        for (int i = 0; i < vertices.size(); i += 3) {
            PointZ[] points = new PointZ[3];
            float[] v1 = (float[])vertices.get(i);
            float[] v2 = (float[])vertices.get(i + 1);
            float[] v3 = (float[])vertices.get(i + 2);
            points[0] = new PointZ(v1[0], v1[1], v1[2]);
            points[1] = new PointZ(v2[0], v2[1], v2[2]);
            points[2] = new PointZ(v3[0], v3[1], v3[2]);
            graphics.addTriangle(points);
        }
        return graphics;
    }

    public static GraphicCollection isosurface(final Array data, final Array x, final Array y, final Array z, final float isoLevel, PolygonBreak pb, int nThreads) {
        int i;
        ArrayList<2> threads = new ArrayList<2>();
        final ArrayList results = new ArrayList();
        int nz = (int)z.getSize();
        int remainder = nz % nThreads;
        int segment = nz / nThreads;
        int zAxisOffset = 0;
        for (i = 0; i < nThreads; ++i) {
            int segmentSize = remainder-- > 0 ? segment + 1 : segment;
            final int paddedSegmentSize = i != nThreads - 1 ? segmentSize + 1 : segmentSize;
            final CallbackMC callback = new CallbackMC(){

                @Override
                public void run() {
                    results.add(this.getVertices());
                }
            };
            final int finalZAxisOffset = zAxisOffset;
            Thread t = new Thread(){

                @Override
                public void run() {
                    MarchingCubes.marchingCubes(data, x, y, z, isoLevel, paddedSegmentSize, finalZAxisOffset, callback);
                }
            };
            threads.add(t);
            t.start();
            zAxisOffset += segmentSize;
        }
        for (i = 0; i < threads.size(); ++i) {
            try {
                ((Thread)threads.get(i)).join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        IsosurfaceGraphics graphics = new IsosurfaceGraphics();
        graphics.setLegendBreak(pb);
        for (List vertices : results) {
            for (int i2 = 0; i2 < vertices.size(); i2 += 3) {
                PointZ[] points = new PointZ[3];
                float[] v1 = (float[])vertices.get(i2);
                float[] v2 = (float[])vertices.get(i2 + 1);
                float[] v3 = (float[])vertices.get(i2 + 2);
                points[0] = new PointZ(v1[0], v1[1], v1[2]);
                points[1] = new PointZ(v2[0], v2[1], v2[2]);
                points[2] = new PointZ(v3[0], v3[1], v3[2]);
                graphics.addTriangle(points);
            }
        }
        return graphics;
    }
}

