/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.jogl;

import org.meteoinfo.chart.plot3d.GraphicCollection3D;
import org.meteoinfo.global.Extent3D;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.shape.PointZ;

public class SurfaceGraphics
extends GraphicCollection3D {
    private PointZ[][] vertices;
    private int[][] legendIndex;

    public SurfaceGraphics() {
        this.allQuads = true;
        this.singleLegend = false;
    }

    public PointZ[][] getVertices() {
        return this.vertices;
    }

    public void setVertices(PointZ[][] value) {
        this.vertices = value;
        double zmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double xmin = Double.MAX_VALUE;
        double zmax = Double.MIN_VALUE;
        double ymax = Double.MIN_VALUE;
        double xmax = Double.MIN_VALUE;
        for (int i = 0; i < value.length; ++i) {
            for (int j = 0; j < value[0].length; ++j) {
                PointZ p = value[i][j];
                xmin = xmin > p.X ? p.X : xmin;
                ymin = ymin > p.Y ? p.Y : ymin;
                zmin = zmin > p.Z ? p.Z : zmin;
                xmax = xmax < p.X ? p.X : xmax;
                ymax = ymax < p.Y ? p.Y : ymax;
                zmax = zmax < p.Z ? p.Z : zmax;
            }
        }
        Extent3D extent = new Extent3D(xmin, xmax, ymin, ymax, zmin, zmax);
        this.setExtent(extent);
    }

    public PointZ getVertex(int i, int j) {
        return this.vertices[i][j];
    }

    public int getDim1() {
        return this.vertices.length;
    }

    public int getDim2() {
        return this.vertices[0].length;
    }

    @Override
    public void setLegendScheme(LegendScheme value) {
        this.legendScheme = value;
        this.updateLegendIndex();
    }

    public void updateLegendIndex() {
        int dim1 = this.getDim1();
        int dim2 = this.getDim2();
        this.legendIndex = new int[dim1][dim2];
        for (int i = 0; i < dim1; ++i) {
            for (int j = 0; j < dim2; ++j) {
                this.legendIndex[i][j] = this.legendScheme.legendBreakIndex(this.vertices[i][j].M);
            }
        }
    }

    public ColorBreak getLegendBreak(int i, int j) {
        return this.legendScheme.getLegendBreak(this.legendIndex[i][j]);
    }

    public float[] getRGBA(int i, int j) {
        return this.legendScheme.getLegendBreak(this.legendIndex[i][j]).getColor().getRGBComponents(null);
    }
}

