/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.meteoinfo.chart.ChartLegend;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.ChartWindArrow;
import org.meteoinfo.chart.LegendPosition;
import org.meteoinfo.chart.Location;
import org.meteoinfo.chart.Margin;
import org.meteoinfo.chart.axis.Axis;
import org.meteoinfo.chart.axis.LogAxis;
import org.meteoinfo.chart.plot.GridLine;
import org.meteoinfo.chart.plot.Plot;
import org.meteoinfo.chart.plot.PlotOrientation;
import org.meteoinfo.chart.plot.PlotType;
import org.meteoinfo.chart.plot.PolarPlot;
import org.meteoinfo.drawing.Draw;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.PointF;

public abstract class AbstractPlot2D
extends Plot {
    protected Color background = null;
    private Color selectColor = Color.yellow;
    private Extent extent;
    private Extent drawExtent = new Extent(0.0, 1.0, 0.0, 1.0);
    private final Map<Location, Axis> axis = new HashMap<Location, Axis>();
    private Location xAxisLocation;
    private Location yAxisLocation;
    private PlotOrientation orientation;
    private final GridLine gridLine;
    private boolean drawTopAxis;
    private boolean drawRightAxis;
    private boolean drawNeatLine;
    private ChartText title;
    private ChartText leftTitle;
    private ChartText rightTitle;
    private List<ChartLegend> legends;
    private List<ChartText> texts;
    private ChartWindArrow windArrow;
    private boolean autoAspect = true;
    private double aspect = 1.0;

    public AbstractPlot2D() {
        this.axis.put(Location.BOTTOM, new Axis("X", true, Location.BOTTOM));
        this.axis.put(Location.LEFT, new Axis("Y", false, Location.LEFT));
        this.axis.put(Location.TOP, new Axis("X", true, Location.TOP, false));
        this.axis.put(Location.RIGHT, new Axis("Y", false, Location.RIGHT, false));
        this.xAxisLocation = Location.BOTTOM;
        this.yAxisLocation = Location.RIGHT;
        this.orientation = PlotOrientation.VERTICAL;
        this.gridLine = new GridLine();
        this.drawTopAxis = true;
        this.drawRightAxis = true;
        this.drawNeatLine = false;
        this.legends = new ArrayList<ChartLegend>();
        this.texts = new ArrayList<ChartText>();
    }

    public ChartText getTitle() {
        return this.title;
    }

    public void setTitle(ChartText value) {
        this.title = value;
    }

    public void setTitle(String text) {
        if (this.title == null) {
            this.title = new ChartText(text);
        } else {
            this.title.setText(text);
        }
    }

    public Color getSelectedColor() {
        return this.selectColor;
    }

    public void setSelectedColor(Color value) {
        this.selectColor = value;
    }

    public ChartText getLeftTitle() {
        return this.leftTitle;
    }

    public void setLeftTitle(ChartText value) {
        this.leftTitle = value;
    }

    public void setLeftTitle(String text) {
        if (this.leftTitle == null) {
            this.leftTitle = new ChartText(text);
        } else {
            this.leftTitle.setText(text);
        }
    }

    public ChartText getRightTitle() {
        return this.rightTitle;
    }

    public void setRightTitle(ChartText value) {
        this.rightTitle = value;
    }

    public void setRightTitle(String text) {
        if (this.rightTitle == null) {
            this.rightTitle = new ChartText(text);
        } else {
            this.rightTitle.setText(text);
        }
    }

    public List<ChartLegend> getLegends() {
        return this.legends;
    }

    public ChartLegend getLegend(int idx) {
        if (this.legends.isEmpty()) {
            return null;
        }
        return this.legends.get(idx);
    }

    public ChartLegend getLegend() {
        if (this.legends.isEmpty()) {
            return null;
        }
        return this.legends.get(this.legends.size() - 1);
    }

    public void setLegend(ChartLegend value) {
        this.legends.clear();
        this.legends.add(value);
    }

    public void setLegends(List<ChartLegend> value) {
        this.legends = value;
    }

    public void setDrawLegend(boolean value) {
    }

    public Extent getDrawExtent() {
        return this.drawExtent;
    }

    public void setDrawExtent(Extent extent) {
        this.drawExtent = extent;
        this.getAxis(Location.BOTTOM).setMinMaxValue(extent.minX, extent.maxX);
        this.getAxis(Location.TOP).setMinMaxValue(extent.minX, extent.maxX);
        this.getAxis(Location.LEFT).setMinMaxValue(extent.minY, extent.maxY);
        this.getAxis(Location.RIGHT).setMinMaxValue(extent.minY, extent.maxY);
    }

    public void setDrawExtent1(Extent extent) {
        this.drawExtent = extent;
    }

    public Extent getExtent() {
        return this.extent;
    }

    public void setExtent(Extent extent) {
        this.extent = extent;
    }

    public void updateDrawExtent() {
        this.getAxis(Location.BOTTOM).setMinMaxValue(this.drawExtent.minX, this.drawExtent.maxX);
        this.getAxis(Location.TOP).setMinMaxValue(this.drawExtent.minX, this.drawExtent.maxX);
        this.getAxis(Location.LEFT).setMinMaxValue(this.drawExtent.minY, this.drawExtent.maxY);
        this.getAxis(Location.RIGHT).setMinMaxValue(this.drawExtent.minY, this.drawExtent.maxY);
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color value) {
        this.background = value;
    }

    @Override
    public PlotType getPlotType() {
        return PlotType.XY;
    }

    public Axis getXAxis() {
        return this.axis.get((Object)Location.BOTTOM);
    }

    public void setXAxis(Axis axis) throws CloneNotSupportedException {
        axis.setLocation(Location.BOTTOM);
        this.axis.put(Location.BOTTOM, axis);
        Axis topAxis = (Axis)axis.clone();
        topAxis.setLocation(Location.TOP);
        this.axis.put(Location.TOP, topAxis);
    }

    public Axis getYAxis() {
        return this.axis.get((Object)Location.LEFT);
    }

    public void setYAxis(Axis axis) throws CloneNotSupportedException {
        axis.setLocation(Location.LEFT);
        this.axis.put(Location.LEFT, axis);
        Axis rightAxis = (Axis)axis.clone();
        rightAxis.setLocation(Location.RIGHT);
        this.axis.put(Location.RIGHT, rightAxis);
    }

    public Axis getAxis(Location loc) {
        return this.axis.get((Object)loc);
    }

    public Location getXAxisLocation() {
        return this.xAxisLocation;
    }

    public void setXAxisLocation(Location value) {
        this.xAxisLocation = value;
    }

    public Location getYAxisLocation() {
        return this.yAxisLocation;
    }

    public void setYAxisLocation(Location value) {
        this.yAxisLocation = value;
    }

    public PlotOrientation getPlotOrientation() {
        return this.orientation;
    }

    public void setPlotOrientation(PlotOrientation value) {
        this.orientation = value;
    }

    public GridLine getGridLine() {
        return this.gridLine;
    }

    public boolean isDrawTopAxis() {
        return this.drawTopAxis;
    }

    public void setDrawTopAxis(boolean value) {
        this.drawTopAxis = value;
    }

    public boolean isDrawRightAxis() {
        return this.drawRightAxis;
    }

    public void setDrawRightAxis(boolean value) {
        this.drawRightAxis = value;
    }

    public boolean isDrawNeatLine() {
        return this.drawNeatLine;
    }

    public void setDrawNeatLine(boolean value) {
        this.drawNeatLine = value;
    }

    public List<ChartText> getTexts() {
        return this.texts;
    }

    public void setTexts(List<ChartText> value) {
        this.texts = value;
    }

    public ChartWindArrow getWindArrow() {
        return this.windArrow;
    }

    public void setWindArrow(ChartWindArrow value) {
        this.windArrow = value;
    }

    public boolean isLogX() {
        Axis xAxis = this.getXAxis();
        return xAxis instanceof LogAxis;
    }

    public boolean isLogY() {
        Axis yAxis = this.getYAxis();
        return yAxis instanceof LogAxis;
    }

    public boolean isAutoAspect() {
        return this.autoAspect;
    }

    public void setAutoAspect(boolean value) {
        this.autoAspect = value;
    }

    public double getAspect() {
        return this.aspect;
    }

    public void setAspect(double value) {
        this.aspect = value;
    }

    public boolean isYReverse() {
        return this.getYAxis().isInverse();
    }

    public boolean isXReverse() {
        return this.getXAxis().isInverse();
    }

    public void addLegend(ChartLegend legend) {
        this.legends.add(legend);
    }

    public void removeLegend(ChartLegend legend) {
        this.legends.remove(legend);
    }

    public void removeLegend(int idx) {
        this.legends.remove(idx);
    }

    public void setAxis(Axis axis, Location loc) {
        this.axis.put(loc, axis);
    }

    public void setAxisLabelFont(Font font) {
        for (Axis ax : this.axis.values()) {
            ax.setTickLabelFont(font);
        }
    }

    public void setAxisOn(boolean value) {
        for (Axis ax : this.axis.values()) {
            ax.setVisible(value);
        }
    }

    public void setInsideTick(boolean isInside) {
        this.getAxis(Location.LEFT).setInsideTick(isInside);
        this.getAxis(Location.RIGHT).setInsideTick(isInside);
        this.getAxis(Location.TOP).setInsideTick(isInside);
        this.getAxis(Location.BOTTOM).setInsideTick(isInside);
    }

    public boolean isInsideTick() {
        return this.getAxis(Location.BOTTOM).isInsideTick();
    }

    @Override
    public void draw(Graphics2D g, Rectangle2D area) {
        boolean b2;
        boolean b1 = area.getWidth() <= 10.0;
        boolean bl = b2 = area.getHeight() <= 10.0;
        if (b1 || b2) {
            return;
        }
        Rectangle2D graphArea = this.getPositionArea();
        this.setGraphArea(graphArea);
        this.drawTitle(g, graphArea);
        if (graphArea.getWidth() < 10.0 || graphArea.getHeight() < 10.0) {
            return;
        }
        if (this.getGridLine().isTop()) {
            this.drawGraph(g, graphArea);
            this.drawGridLine(g, graphArea);
        } else {
            this.drawGridLine(g, graphArea);
            this.drawGraph(g, graphArea);
        }
        if (this.drawNeatLine) {
            g.setStroke(new BasicStroke(1.0f));
            g.setColor(Color.black);
            g.draw(graphArea);
        }
        this.drawAxis(g, graphArea);
        this.drawText(g, graphArea);
        this.drawLegend(g, area, graphArea);
        if (this.getWindArrow() != null) {
            ChartWindArrow wa = this.getWindArrow();
            float x = (float)(area.getWidth() * (double)wa.getX());
            float y = (float)(area.getHeight() * (double)(1.0f - wa.getY()));
            wa.draw(g, x, y);
        }
    }

    @Override
    public Margin getTightInset(Graphics2D g, Rectangle2D positionArea) {
        int left = 2;
        int bottom = 2;
        int right = 2;
        int top = 10;
        top += this.getAxis(Location.TOP).getXAxisHeight(g);
        if (this.title != null) {
            top += this.title.getTrueDimension((Graphics2D)g).height + 10;
        }
        if (this.leftTitle != null) {
            top += this.leftTitle.getDimension((Graphics2D)g).height + 5;
        } else if (this.rightTitle != null) {
            top += this.rightTitle.getDimension((Graphics2D)g).height + 5;
        }
        if (!this.legends.isEmpty()) {
            ChartLegend legend = this.getLegend();
            Dimension dim = legend.getLegendDimension(g, new Dimension((int)positionArea.getWidth(), (int)positionArea.getHeight()));
            switch (legend.getPosition()) {
                case UPPER_CENTER_OUTSIDE: {
                    top += dim.height + 10;
                    break;
                }
                case LOWER_CENTER_OUTSIDE: {
                    bottom += dim.height + 10;
                    break;
                }
                case LEFT_OUTSIDE: {
                    left += dim.width + 10;
                    break;
                }
                case RIGHT_OUTSIDE: {
                    right += dim.width + 10;
                }
            }
        }
        bottom += this.getXAxisHeight(g) + 5;
        left += this.getYAxisWidth(g) + 5;
        int radd = this.getAxis(Location.RIGHT).getYAxisWidth(g);
        if (this.getXAxis().isVisible() && this.getXAxis().isDrawTickLabel()) {
            radd = Math.max(radd, this.getXAxis().getMaxLabelLength(g) / 2);
        }
        return new Margin(left, right += radd, top, bottom);
    }

    public Rectangle2D getTightInsetArea(Graphics2D g, Rectangle2D positionArea) {
        int left = 0;
        int bottom = 0;
        int right = 5;
        int top = 5;
        boolean space = true;
        if (this.title != null) {
            g.setFont(this.title.getFont());
            Dimension dim = Draw.getStringDimension(this.title.getText(), g);
            top = (int)((double)top + (dim.getHeight() + 10.0));
        }
        if (!this.legends.isEmpty()) {
            ChartLegend legend = this.getLegend();
            Dimension dim = legend.getLegendDimension(g, new Dimension((int)positionArea.getWidth(), (int)positionArea.getHeight()));
            switch (legend.getPosition()) {
                case UPPER_CENTER_OUTSIDE: {
                    top += dim.height + 10;
                    break;
                }
                case LOWER_CENTER_OUTSIDE: {
                    bottom += dim.height + 10;
                    break;
                }
                case LEFT_OUTSIDE: {
                    left += dim.width + 10;
                    break;
                }
                case RIGHT_OUTSIDE: {
                    right += dim.width + 10;
                }
            }
        }
        bottom += this.getXAxisHeight(g);
        left += this.getYAxisWidth(g);
        if (this.getXAxis().isVisible() && this.getXAxis().isDrawTickLabel()) {
            right += this.getXAxis().getMaxLabelLength(g) / 2;
        }
        double x = positionArea.getX() - (double)left;
        double y = positionArea.getY() - (double)top;
        double w = positionArea.getWidth() + (double)left + (double)right;
        double h = positionArea.getHeight() + (double)top + (double)bottom;
        return new Rectangle2D.Double(x, y, w, h);
    }

    @Override
    public Rectangle2D getPositionArea() {
        double height;
        if (this.autoAspect) {
            return super.getPositionArea();
        }
        Rectangle2D plotArea = super.getPositionArea();
        double width = this.drawExtent.getWidth();
        if (width / (height = this.drawExtent.getHeight()) / this.aspect > plotArea.getWidth() / plotArea.getHeight()) {
            double h = plotArea.getWidth() * height * this.aspect / width;
            double delta = plotArea.getHeight() - h;
            plotArea.setRect(plotArea.getX(), plotArea.getY() + delta / 2.0, plotArea.getWidth(), h);
        } else {
            double w = width * plotArea.getHeight() / height / this.aspect;
            double delta = plotArea.getWidth() - w;
            plotArea.setRect(plotArea.getX() + delta / 2.0, plotArea.getY(), w, plotArea.getHeight());
        }
        return plotArea;
    }

    @Override
    public Rectangle2D getOuterPositionArea(Rectangle2D area) {
        Rectangle2D rect = this.getOuterPosition();
        double x = area.getWidth() * rect.getX() + area.getX();
        double y = area.getHeight() * (1.0 - rect.getHeight() - rect.getY()) + area.getY();
        double w = area.getWidth() * rect.getWidth();
        double h = area.getHeight() * rect.getHeight();
        return new Rectangle2D.Double(x, y, w, h);
    }

    public Rectangle2D getGraphArea(Graphics2D g, Rectangle2D area) {
        int left = 5;
        int bottom = 5;
        int right = 5;
        int top = 5;
        int space = 5;
        if (this.title != null) {
            top += this.title.getTrueDimension((Graphics2D)g).height + 10;
        }
        if (!this.legends.isEmpty()) {
            ChartLegend legend = this.getLegend();
            Dimension dim = legend.getLegendDimension(g, new Dimension((int)area.getWidth(), (int)area.getHeight()));
            switch (legend.getPosition()) {
                case UPPER_CENTER_OUTSIDE: {
                    top += dim.height + 10;
                    break;
                }
                case LOWER_CENTER_OUTSIDE: {
                    bottom += dim.height + 10;
                    break;
                }
                case LEFT_OUTSIDE: {
                    left += dim.width + 10;
                    break;
                }
                case RIGHT_OUTSIDE: {
                    right += dim.width + 10;
                }
            }
        }
        bottom += this.getXAxisHeight(g);
        left += this.getYAxisWidth(g);
        if (this.getXAxis().isVisible() && this.getXAxis().isDrawTickLabel()) {
            right += this.getXAxis().getMaxLabelLength(g) / 2;
        }
        Rectangle2D.Double plotArea = new Rectangle2D.Double(left, top, area.getWidth() - (double)left - (double)right, area.getHeight() - (double)top - (double)bottom);
        return plotArea;
    }

    int getXAxisHeight(Graphics2D g) {
        return this.getXAxis().getXAxisHeight(g);
    }

    int getYAxisWidth(Graphics2D g) {
        return this.getYAxis().getYAxisWidth(g);
    }

    int getTopAxisHeight(Graphics2D g) {
        int height = this.getAxis(Location.TOP).getXAxisHeight(g);
        return height;
    }

    void drawTitle(Graphics2D g, Rectangle2D graphArea) {
        float x;
        float y = (float)graphArea.getY() - (float)this.getTopAxisHeight(g);
        int sh = 0;
        if (this.leftTitle != null) {
            x = (float)graphArea.getX();
            this.leftTitle.draw(g, x, y -= 5.0f);
            y += 5.0f;
            sh = this.leftTitle.getDimension((Graphics2D)g).height + 5;
        }
        if (this.rightTitle != null) {
            x = (float)(graphArea.getX() + graphArea.getWidth());
            this.rightTitle.draw(g, x, y -= 5.0f);
            y += 5.0f;
            sh = this.rightTitle.getDimension((Graphics2D)g).height + 5;
        }
        if (this.title != null) {
            y -= (float)sh;
            x = (float)(graphArea.getX() + graphArea.getWidth() / 2.0);
            this.title.draw(g, x, y -= 8.0f);
        }
    }

    void drawGridLine(Graphics2D g, Rectangle2D area) {
        double[] xy;
        double value;
        int n;
        if (!this.gridLine.isDrawXLine() && !this.gridLine.isDrawYLine()) {
            return;
        }
        double miny = area.getY();
        double minx = area.getX();
        double maxx = area.getX() + area.getWidth();
        double maxy = area.getY() + area.getHeight();
        float[] dashPattern = Draw.getDashPattern(this.gridLine.getStyle());
        g.setColor(this.gridLine.getColor());
        g.setStroke(new BasicStroke(this.gridLine.getSize(), 0, 0, 10.0f, dashPattern, 0.0f));
        if (this.gridLine.isDrawXLine()) {
            this.getXAxis().updateTickLabels();
            n = 0;
            while (n < this.getXAxis().getTickValues().length) {
                value = this.getXAxis().getTickValues()[n];
                if (value <= this.getXAxis().getMinValue() || value >= this.getXAxis().getMaxValue()) {
                    n += this.getXAxis().getTickLabelGap();
                    continue;
                }
                xy = this.projToScreen(value, this.drawExtent.minY, area);
                double x = xy[0];
                if (x > 0.0 && x < area.getWidth()) {
                    if (this.getXAxis().isInverse()) {
                        x = area.getWidth() - x;
                    }
                    g.draw(new Line2D.Double(x += minx, maxy, x, miny));
                }
                n += this.getXAxis().getTickLabelGap();
            }
        }
        if (this.gridLine.isDrawYLine()) {
            this.getYAxis().updateTickLabels();
            n = 0;
            while (n < this.getYAxis().getTickValues().length) {
                value = this.getYAxis().getTickValues()[n];
                if (value <= this.getYAxis().getMinValue() || value >= this.getYAxis().getMaxValue()) {
                    n += this.getYAxis().getTickLabelGap();
                    continue;
                }
                xy = this.projToScreen(this.drawExtent.minX, value, area);
                double y = xy[1];
                if (y > 0.0 && y < area.getHeight()) {
                    if (this.getYAxis().isInverse()) {
                        y = area.getHeight() - y;
                    }
                    g.draw(new Line2D.Double(minx, y += miny, maxx, y));
                }
                n += this.getYAxis().getTickLabelGap();
            }
        }
    }

    abstract void drawGraph(Graphics2D var1, Rectangle2D var2);

    void drawAxis(Graphics2D g, Rectangle2D area) {
        for (Location loc : this.axis.keySet()) {
            Axis ax = this.axis.get((Object)loc);
            if (!ax.isVisible()) continue;
            ax.updateLabelGap(g, area);
            ax.draw(g, area, this);
        }
    }

    void drawText(Graphics2D g, Rectangle2D area) {
        for (int i = 0; i < this.getTexts().size(); ++i) {
            this.drawPlotText(this.getTexts().get(i), g, area);
        }
    }

    void drawPlotText(ChartText text, Graphics2D g, Rectangle2D area) {
        switch (text.getCoordinates()) {
            case AXES: {
                AffineTransform oldMatrix = g.getTransform();
                Rectangle oldRegion = g.getClipBounds();
                g.setClip(area);
                g.translate(area.getX(), area.getY());
                float x = (float)(area.getWidth() * text.getX());
                float y = (float)(area.getHeight() * (1.0 - text.getY()));
                this.drawText(text, g, x, y);
                g.setTransform(oldMatrix);
                g.setClip(oldRegion);
                break;
            }
            case FIGURE: {
                float x = (float)(area.getWidth() * text.getX());
                float y = (float)(area.getHeight() * (1.0 - text.getY()));
                this.drawText(text, g, x, y);
                break;
            }
            case DATA: {
                AffineTransform oldMatrix = g.getTransform();
                Rectangle oldRegion = g.getClipBounds();
                g.setClip(area);
                g.translate(area.getX(), area.getY());
                double[] xy = this.projToScreen(text.getX(), text.getY(), area);
                float x = (float)xy[0];
                float y = (float)xy[1];
                this.drawText(text, g, x, y);
                g.setTransform(oldMatrix);
                g.setClip(oldRegion);
            }
        }
    }

    void drawText(ChartText text, Graphics2D g, float x, float y) {
        g.setFont(text.getFont());
        text.draw(g, x, y);
    }

    void drawLegend(Graphics2D g, Rectangle2D area, Rectangle2D graphArea) {
        if (!this.legends.isEmpty()) {
            Object rendering = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (ChartLegend legend : this.legends) {
                if (legend.isColorbar()) {
                    if (legend.getPlotOrientation() == PlotOrientation.VERTICAL) {
                        legend.setHeight((int)(graphArea.getHeight() * (double)legend.getShrink()));
                        legend.setLegendHeight(legend.getHeight());
                    } else {
                        legend.setWidth((int)(graphArea.getWidth() * (double)legend.getShrink()));
                        legend.setLegendWidth(legend.getWidth());
                    }
                }
                if (legend.getPosition() == LegendPosition.CUSTOM) {
                    legend.getLegendDimension(g, new Dimension((int)area.getWidth(), (int)area.getHeight()));
                    float x = (float)(area.getWidth() * (double)legend.getX());
                    float y = (float)(area.getHeight() * (1.0 - (double)this.getLegend().getHeight() / area.getHeight() - (double)this.getLegend().getY()));
                    legend.draw(g, new PointF(x, y));
                    continue;
                }
                this.drawLegendScheme(legend, g, graphArea);
            }
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rendering);
        }
    }

    void drawLegendScheme(ChartLegend legend, Graphics2D g, Rectangle2D area) {
        g.setFont(legend.getTickLabelFont());
        Dimension dim = legend.getLegendDimension(g, new Dimension((int)area.getWidth(), (int)area.getHeight()));
        float x = 0.0f;
        float y = 0.0f;
        switch (legend.getPosition()) {
            case UPPER_CENTER_OUTSIDE: {
                x = (float)(area.getX() + area.getWidth() / 2.0 - (double)(dim.width / 2));
                y = (float)(area.getY() - (double)this.getAxis(Location.TOP).getXAxisHeight(g) - (double)dim.height - 5.0);
                break;
            }
            case LOWER_CENTER_OUTSIDE: {
                x = (float)(area.getX() + area.getWidth() / 2.0 - (double)(dim.width / 2));
                y = (float)(area.getY() + area.getHeight() + (double)this.getXAxisHeight(g) + 10.0);
                break;
            }
            case LEFT_OUTSIDE: {
                x = 10.0f;
                y = (float)area.getHeight() / 2.0f - (float)(dim.height / 2);
                break;
            }
            case RIGHT_OUTSIDE: {
                if (this.getAxis(Location.RIGHT).isDrawTickLabel() || this instanceof PolarPlot) {
                    x = (float)area.getX() + (float)area.getWidth() + (float)this.getTightInset().getRight();
                    x -= (float)dim.width;
                } else {
                    x = (float)area.getX() + (float)area.getWidth() + 10.0f;
                }
                y = (float)area.getY() + (float)area.getHeight() / 2.0f - (float)(dim.height / 2);
                break;
            }
            case UPPER_CENTER: {
                x = (float)(area.getX() + area.getWidth() / 2.0 - (double)(dim.width / 2));
                y = (float)area.getY() + 10.0f;
                break;
            }
            case UPPER_RIGHT: {
                x = (float)(area.getX() + area.getWidth()) - (float)dim.width - 10.0f;
                y = (float)area.getY() + 10.0f;
                break;
            }
            case LOWER_CENTER: {
                x = (float)(area.getX() + area.getWidth() / 2.0 - (double)(dim.width / 2));
                y = (float)(area.getY() + area.getHeight()) - (float)dim.height - 10.0f;
                break;
            }
            case LOWER_RIGHT: {
                x = (float)(area.getX() + area.getWidth()) - (float)dim.width - 10.0f;
                y = (float)(area.getY() + area.getHeight()) - (float)dim.height - 10.0f;
                break;
            }
            case UPPER_LEFT: {
                x = (float)area.getX() + 10.0f;
                y = (float)area.getY() + 10.0f;
                break;
            }
            case LOWER_LEFT: {
                x = (float)area.getX() + 10.0f;
                y = (float)(area.getY() + area.getHeight()) - (float)dim.height - 10.0f;
            }
        }
        legend.draw(g, new PointF(x, y));
    }

    public double[] projToScreen(double projX, double projY, Rectangle2D area) {
        double width = this.drawExtent.getWidth();
        double height = this.drawExtent.getHeight();
        if (this.isLogY()) {
            height = Math.log10(this.drawExtent.maxY) - Math.log10(this.drawExtent.minY);
        }
        if (this.isLogX()) {
            width = Math.log10(this.drawExtent.maxX) - Math.log10(this.drawExtent.minX);
        }
        double scaleX = area.getWidth() / width;
        double scaleY = area.getHeight() / height;
        double screenX = (projX - this.drawExtent.minX) * scaleX;
        double screenY = (this.drawExtent.maxY - projY) * scaleY;
        if (this.isLogY()) {
            screenY = (Math.log10(this.drawExtent.maxY) - Math.log10(projY)) * scaleY;
        }
        if (this.isLogX()) {
            screenX = (Math.log10(projX) - Math.log10(this.drawExtent.minX)) * scaleX;
        }
        if (this.isYReverse()) {
            screenY = area.getHeight() - screenY;
        }
        if (this.isXReverse()) {
            screenX = area.getWidth() - screenX;
        }
        return new double[]{screenX, screenY};
    }

    public double projXLength(double len, Rectangle2D area) {
        double scaleX = area.getWidth() / this.drawExtent.getWidth();
        return len * scaleX;
    }

    public double projYLength(double len, Rectangle2D area) {
        double scaleY = area.getHeight() / this.drawExtent.getHeight();
        return len * scaleY;
    }

    public double[] screenToProj(double screenX, double screenY, Rectangle2D area) {
        double width = this.drawExtent.getWidth();
        double height = this.drawExtent.getHeight();
        if (this.isLogY()) {
            height = Math.log10(this.drawExtent.maxY) - Math.log10(this.drawExtent.minY);
        }
        if (this.isLogX()) {
            width = Math.log10(this.drawExtent.maxX) - Math.log10(this.drawExtent.minX);
        }
        if (this.isYReverse()) {
            screenY = area.getHeight() - screenY;
        }
        if (this.isXReverse()) {
            screenX = area.getWidth() - screenX;
        }
        double scaleX = area.getWidth() / width;
        double scaleY = area.getHeight() / height;
        double projX = screenX / scaleX + this.drawExtent.minX;
        double projY = this.drawExtent.maxY - screenY / scaleY;
        if (this.isLogY()) {
            projY = Math.pow(10.0, Math.log10(this.drawExtent.maxY) - screenY / scaleY);
        }
        if (this.isLogX()) {
            projX = Math.pow(10.0, screenX / scaleX + Math.log10(this.drawExtent.minX));
        }
        return new double[]{projX, projY};
    }

    abstract Extent getAutoExtent();

    public abstract void setAutoExtent();

    public abstract void updateLegendScheme();

    public void zoomToExtentScreen(double minX, double maxX, double minY, double maxY) {
        double[] pMin = this.screenToProj(minX, maxY, this.getGraphArea());
        double[] pMax = this.screenToProj(maxX, minY, this.getGraphArea());
        this.setDrawExtent(new Extent(pMin[0], pMax[0], pMin[1], pMax[1]));
    }

    public void addText(ChartText text) {
        this.getTexts().add(text);
    }
}

