/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.plot;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.plot.XAlign;
import org.meteoinfo.chart.plot.YAlign;
import org.meteoinfo.chart.plot3d.GraphicCollection3D;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.XYListDataset;
import org.meteoinfo.data.analysis.Statistics;
import org.meteoinfo.drawing.ContourDraw;
import org.meteoinfo.drawing.Draw;
import org.meteoinfo.geoprocess.GeoComputation;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.Extent3D;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.util.BigDecimalUtil;
import org.meteoinfo.layer.ImageLayer;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.legend.ArrowLineBreak;
import org.meteoinfo.legend.ArrowPolygonBreak;
import org.meteoinfo.legend.BarBreak;
import org.meteoinfo.legend.BreakTypes;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.ColorBreakCollection;
import org.meteoinfo.legend.LegendManage;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.LegendType;
import org.meteoinfo.legend.LineStyles;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.legend.PointStyle;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.legend.PolylineBreak;
import org.meteoinfo.math.ArrayMath;
import org.meteoinfo.math.ArrayUtil;
import org.meteoinfo.math.meteo.MeteoMath;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.shape.ArcShape;
import org.meteoinfo.shape.BarShape;
import org.meteoinfo.shape.CapPolylineShape;
import org.meteoinfo.shape.CurveLineShape;
import org.meteoinfo.shape.Graphic;
import org.meteoinfo.shape.GraphicCollection;
import org.meteoinfo.shape.ImageShape;
import org.meteoinfo.shape.PointShape;
import org.meteoinfo.shape.PointZ;
import org.meteoinfo.shape.PointZShape;
import org.meteoinfo.shape.PolygonShape;
import org.meteoinfo.shape.PolygonZShape;
import org.meteoinfo.shape.Polyline;
import org.meteoinfo.shape.PolylineErrorShape;
import org.meteoinfo.shape.PolylineShape;
import org.meteoinfo.shape.PolylineZ;
import org.meteoinfo.shape.PolylineZShape;
import org.meteoinfo.shape.RectangleShape;
import org.meteoinfo.shape.Shape;
import org.meteoinfo.shape.ShapeTypes;
import org.meteoinfo.shape.WindArrow;
import org.meteoinfo.shape.WindArrow3D;
import org.meteoinfo.shape.WindBarb;
import wcontour.Contour;
import wcontour.global.PointD;
import wcontour.global.PolyLine;
import wcontour.global.Polygon;

public class GraphicFactory {
    public static GraphicCollection createLineString(Array xdata, Array ydata, ColorBreak cb) {
        PolylineShape pls;
        GraphicCollection gc = new GraphicCollection();
        ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
        int i = 0;
        while ((long)i < xdata.getSize()) {
            double x = xdata.getDouble(i);
            double y = ydata.getDouble(i);
            if (Double.isNaN(y) || Double.isNaN(x)) {
                if (!points.isEmpty()) {
                    if (points.size() == 1) {
                        points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                    }
                    pls = new PolylineShape();
                    pls.setPoints(points);
                    gc.add(new Graphic(pls, cb));
                    points = new ArrayList();
                }
            } else {
                points.add(new org.meteoinfo.global.PointD(x, y));
            }
            ++i;
        }
        if (!points.isEmpty()) {
            if (points.size() == 1) {
                points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
            }
            pls = new PolylineShape();
            pls.setPoints(points);
            gc.add(new Graphic(pls, cb));
        }
        return gc;
    }

    public static GraphicCollection createLineString(Array xdata, Array ydata, ColorBreak cb, boolean iscurve) {
        GraphicCollection gc = new GraphicCollection();
        ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
        if (xdata.getRank() == 1) {
            PolylineShape pls;
            int i = 0;
            while ((long)i < xdata.getSize()) {
                double x = xdata.getDouble(i);
                double y = ydata.getDouble(i);
                if (Double.isNaN(y) || Double.isNaN(x)) {
                    if (!points.isEmpty()) {
                        if (points.size() == 1) {
                            points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                        }
                        pls = iscurve ? new CurveLineShape() : new PolylineShape();
                        pls.setPoints(points);
                        gc.add(new Graphic(pls, cb));
                        points = new ArrayList();
                    }
                } else {
                    points.add(new org.meteoinfo.global.PointD(x, y));
                }
                ++i;
            }
            if (!points.isEmpty()) {
                if (points.size() == 1) {
                    points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                }
                pls = iscurve ? new CurveLineShape() : new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic(pls, cb));
            }
        } else {
            int[] shape = xdata.getShape();
            int yn = shape[0];
            int xn = shape[1];
            for (int j = 0; j < yn; ++j) {
                PolylineShape pls;
                points = new ArrayList();
                for (int i = 0; i < xn; ++i) {
                    double x = xdata.getDouble(j * xn + i);
                    double y = ydata.getDouble(j * xn + i);
                    if (Double.isNaN(y) || Double.isNaN(x)) {
                        if (points.isEmpty()) continue;
                        if (points.size() == 1) {
                            points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                        }
                        pls = iscurve ? new CurveLineShape() : new PolylineShape();
                        pls.setPoints(points);
                        gc.add(new Graphic(pls, cb));
                        points = new ArrayList();
                        continue;
                    }
                    points.add(new org.meteoinfo.global.PointD(x, y));
                }
                if (points.size() <= 1) continue;
                pls = iscurve ? new CurveLineShape() : new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic(pls, cb));
            }
        }
        return gc;
    }

    public static GraphicCollection createLineString(Array xdata, Array ydata, List<ColorBreak> cbs, boolean iscurve) {
        GraphicCollection gc = new GraphicCollection();
        ColorBreak cb = cbs.get(0);
        if (xdata.getRank() == 1) {
            PolylineShape pls;
            ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
            ColorBreakCollection cbc = new ColorBreakCollection();
            int i = 0;
            while ((long)i < xdata.getSize()) {
                double x = xdata.getDouble(i);
                double y = ydata.getDouble(i);
                if (cbs.size() > i) {
                    cb = cbs.get(i);
                }
                if (Double.isNaN(y) || Double.isNaN(x)) {
                    if (!points.isEmpty()) {
                        if (points.size() == 1) {
                            points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                        }
                        pls = iscurve ? new CurveLineShape() : new PolylineShape();
                        pls.setPoints(points);
                        gc.add(new Graphic(pls, cbc));
                        points = new ArrayList();
                        cbc = new ColorBreakCollection();
                    }
                } else {
                    points.add(new org.meteoinfo.global.PointD(x, y));
                    cbc.add(cb);
                }
                ++i;
            }
            if (points.size() > 1) {
                pls = iscurve ? new CurveLineShape() : new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic(pls, cbc));
            }
        } else {
            int[] shape = xdata.getShape();
            int yn = shape[0];
            int xn = shape[1];
            for (int j = 0; j < yn; ++j) {
                PolylineShape pls;
                ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
                cb = cbs.get(j);
                for (int i = 0; i < xn; ++i) {
                    double x = xdata.getDouble(j * xn + i);
                    double y = ydata.getDouble(j * xn + i);
                    if (Double.isNaN(y) || Double.isNaN(x)) {
                        if (points.isEmpty()) continue;
                        if (points.size() == 1) {
                            points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                        }
                        pls = iscurve ? new CurveLineShape() : new PolylineShape();
                        pls.setPoints(points);
                        gc.add(new Graphic(pls, cb));
                        points = new ArrayList();
                        continue;
                    }
                    points.add(new org.meteoinfo.global.PointD(x, y));
                }
                if (points.size() <= 1) continue;
                pls = iscurve ? new CurveLineShape() : new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic(pls, cb));
            }
            gc.setSingleLegend(false);
        }
        return gc;
    }

    public static GraphicCollection createLineString(Array xdata, Array ydata, Array zdata, LegendScheme ls, boolean iscurve) {
        GraphicCollection gc = new GraphicCollection();
        if (xdata.getRank() == 1) {
            PolylineShape pls;
            ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
            ColorBreakCollection cbc = new ColorBreakCollection();
            int i = 0;
            while ((long)i < xdata.getSize()) {
                double x = xdata.getDouble(i);
                double y = ydata.getDouble(i);
                double z = zdata.getDouble(i);
                ColorBreak cb = ls.findLegendBreak(z);
                if (Double.isNaN(y) || Double.isNaN(x)) {
                    if (!points.isEmpty()) {
                        if (points.size() == 1) {
                            points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                        }
                        pls = iscurve ? new CurveLineShape() : new PolylineShape();
                        pls.setPoints(points);
                        gc.add(new Graphic(pls, cbc));
                        points = new ArrayList();
                        cbc = new ColorBreakCollection();
                    }
                } else {
                    points.add(new org.meteoinfo.global.PointD(x, y));
                    cbc.add(cb);
                }
                ++i;
            }
            if (points.size() > 1) {
                pls = iscurve ? new CurveLineShape() : new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic(pls, cbc));
            }
            gc.setLegendScheme(ls);
        } else {
            int[] shape = xdata.getShape();
            int yn = shape[0];
            int xn = shape[1];
            for (int j = 0; j < yn; ++j) {
                PolylineShape pls;
                ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
                ColorBreakCollection cbc = new ColorBreakCollection();
                for (int i = 0; i < xn; ++i) {
                    double x = xdata.getDouble(j * xn + i);
                    double y = ydata.getDouble(j * xn + i);
                    double z = zdata.getDouble(j * xn + i);
                    ColorBreak cb = ls.findLegendBreak(z);
                    if (Double.isNaN(y) || Double.isNaN(x)) {
                        if (points.isEmpty()) continue;
                        if (points.size() == 1) {
                            points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                        }
                        pls = iscurve ? new CurveLineShape() : new PolylineShape();
                        pls.setPoints(points);
                        gc.add(new Graphic(pls, cbc));
                        points = new ArrayList();
                        cbc = new ColorBreakCollection();
                        continue;
                    }
                    points.add(new org.meteoinfo.global.PointD(x, y));
                    cbc.add(cb);
                }
                if (points.size() <= 1) continue;
                pls = iscurve ? new CurveLineShape() : new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic(pls, cbc));
            }
            gc.setLegendScheme(ls);
            gc.setSingleLegend(false);
        }
        return gc;
    }

    public static GraphicCollection createLineString(XYListDataset data, List<ColorBreak> cbs) {
        GraphicCollection gc = new GraphicCollection();
        for (int i = 0; i < data.getSeriesCount(); ++i) {
            ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
            for (int j = 0; j < data.getItemCount(i); ++j) {
                double x = data.getX(i, j);
                double y = data.getY(i, j);
                points.add(new org.meteoinfo.global.PointD(x, y));
            }
            PolylineShape pls = new PolylineShape();
            pls.setPoints(points);
            gc.add(new Graphic(pls, cbs.get(i)));
        }
        gc.setSingleLegend(false);
        return gc;
    }

    public static GraphicCollection createLineString3D(Array xdata, Array ydata, Array zdata, ColorBreak cb) {
        GraphicCollection3D gc = new GraphicCollection3D();
        ArrayList<PointZ> points = new ArrayList<PointZ>();
        double z = 0.0;
        boolean fixZ = false;
        if (zdata.getSize() == 1L && xdata.getSize() > 1L) {
            fixZ = true;
            z = zdata.getDouble(0);
        }
        if (xdata.getRank() == 1) {
            PolylineZShape pls;
            int i = 0;
            while ((long)i < xdata.getSize()) {
                double x = xdata.getDouble(i);
                double y = ydata.getDouble(i);
                if (!fixZ) {
                    z = zdata.getDouble(i);
                }
                if (Double.isNaN(y) || Double.isNaN(x)) {
                    if (!points.isEmpty()) {
                        if (points.size() == 1) {
                            points.add((PointZ)((PointZ)points.get(0)).clone());
                        }
                        pls = new PolylineZShape();
                        pls.setPoints(points);
                        gc.add(new Graphic(pls, cb));
                        points = new ArrayList();
                    }
                } else {
                    points.add(new PointZ(x, y, z));
                }
                ++i;
            }
            if (points.size() > 1) {
                pls = new PolylineZShape();
                pls.setPoints(points);
                gc.add(new Graphic(pls, cb));
            }
        } else {
            int[] shape = xdata.getShape();
            int yn = shape[0];
            int xn = shape[1];
            for (int j = 0; j < yn; ++j) {
                PolylineZShape pls;
                for (int i = 0; i < xn; ++i) {
                    double x = xdata.getDouble(j * xn + i);
                    double y = ydata.getDouble(j * xn + i);
                    if (!fixZ) {
                        z = zdata.getDouble(j * xn + i);
                    }
                    if (Double.isNaN(y) || Double.isNaN(x)) {
                        if (points.isEmpty()) continue;
                        if (points.size() == 1) {
                            points.add((PointZ)((PointZ)points.get(0)).clone());
                        }
                        pls = new PolylineZShape();
                        pls.setPoints(points);
                        gc.add(new Graphic(pls, cb));
                        points = new ArrayList();
                        continue;
                    }
                    points.add(new PointZ(x, y, z));
                }
                if (points.size() <= 1) continue;
                pls = new PolylineZShape();
                pls.setPoints(points);
                gc.add(new Graphic(pls, cb));
                points = new ArrayList();
            }
        }
        return gc;
    }

    public static GraphicCollection createLineString3D(Array xdata, Array ydata, Array zdata, List<ColorBreak> cbs) {
        GraphicCollection3D gc = new GraphicCollection3D();
        ArrayList<PointZ> points = new ArrayList<PointZ>();
        double z = 0.0;
        boolean fixZ = false;
        if (zdata.getSize() == 1L && xdata.getSize() > 1L) {
            fixZ = true;
            z = zdata.getDouble(0);
        }
        if (xdata.getRank() == 1) {
            PolylineZShape pls;
            ColorBreak cb = cbs.get(0);
            int i = 0;
            while ((long)i < xdata.getSize()) {
                double x = xdata.getDouble(i);
                double y = ydata.getDouble(i);
                if (!fixZ) {
                    z = zdata.getDouble(i);
                }
                if (Double.isNaN(y) || Double.isNaN(x)) {
                    if (!points.isEmpty()) {
                        if (points.size() == 1) {
                            points.add((PointZ)((PointZ)points.get(0)).clone());
                        }
                        pls = new PolylineZShape();
                        pls.setPoints(points);
                        gc.add(new Graphic(pls, cb));
                        points = new ArrayList();
                    }
                } else {
                    points.add(new PointZ(x, y, z));
                }
                ++i;
            }
            if (points.size() > 1) {
                pls = new PolylineZShape();
                pls.setPoints(points);
                gc.add(new Graphic(pls, cb));
            }
        } else {
            int[] shape = xdata.getShape();
            int yn = shape[0];
            int xn = shape[1];
            for (int j = 0; j < yn; ++j) {
                PolylineZShape pls;
                ColorBreak cb = cbs.get(j);
                for (int i = 0; i < xn; ++i) {
                    double x = xdata.getDouble(j * xn + i);
                    double y = ydata.getDouble(j * xn + i);
                    if (!fixZ) {
                        z = zdata.getDouble(j * xn + i);
                    }
                    if (Double.isNaN(y) || Double.isNaN(x)) {
                        if (points.isEmpty()) continue;
                        if (points.size() == 1) {
                            points.add((PointZ)((PointZ)points.get(0)).clone());
                        }
                        pls = new PolylineZShape();
                        pls.setPoints(points);
                        gc.add(new Graphic(pls, cb));
                        points = new ArrayList();
                        continue;
                    }
                    points.add(new PointZ(x, y, z));
                }
                if (points.size() <= 1) continue;
                pls = new PolylineZShape();
                pls.setPoints(points);
                gc.add(new Graphic(pls, cb));
                points = new ArrayList();
            }
        }
        return gc;
    }

    public static GraphicCollection createLineString3D(Array xdata, Array ydata, Array zdata, Array mdata, LegendScheme ls) {
        GraphicCollection3D gc = new GraphicCollection3D();
        ArrayList<PointZ> points = new ArrayList<PointZ>();
        double z = 0.0;
        boolean fixZ = false;
        if (zdata.getSize() == 1L && xdata.getSize() > 1L) {
            fixZ = true;
            z = zdata.getDouble(0);
        }
        if (xdata.getRank() == 1) {
            PolylineZShape pls;
            ColorBreakCollection cbs = new ColorBreakCollection();
            int i = 0;
            while ((long)i < xdata.getSize()) {
                double x = xdata.getDouble(i);
                double y = ydata.getDouble(i);
                if (!fixZ) {
                    z = zdata.getDouble(i);
                }
                double m = mdata.getDouble(i);
                ColorBreak cb = ls.findLegendBreak(m);
                if (Double.isNaN(y) || Double.isNaN(x)) {
                    if (!points.isEmpty()) {
                        if (points.size() == 1) {
                            points.add((PointZ)((PointZ)points.get(0)).clone());
                        }
                        pls = new PolylineZShape();
                        pls.setPoints(points);
                        gc.add(new Graphic(pls, cbs));
                        points = new ArrayList();
                        cbs = new ColorBreakCollection();
                    }
                } else {
                    points.add(new PointZ(x, y, z));
                    cbs.add(cb);
                }
                ++i;
            }
            if (points.size() > 1) {
                pls = new PolylineZShape();
                pls.setPoints(points);
                gc.add(new Graphic(pls, cbs));
            }
        } else {
            int[] shape = xdata.getShape();
            int yn = shape[0];
            int xn = shape[1];
            for (int j = 0; j < yn; ++j) {
                PolylineZShape pls;
                ColorBreakCollection cbs = new ColorBreakCollection();
                for (int i = 0; i < xn; ++i) {
                    double x = xdata.getDouble(j * xn + i);
                    double y = ydata.getDouble(j * xn + i);
                    if (!fixZ) {
                        z = zdata.getDouble(j * xn + i);
                    }
                    double m = mdata.getDouble(j * xn + i);
                    ColorBreak cb = ls.findLegendBreak(m);
                    if (Double.isNaN(y) || Double.isNaN(x)) {
                        if (points.isEmpty()) continue;
                        if (points.size() == 1) {
                            points.add((PointZ)((PointZ)points.get(0)).clone());
                        }
                        pls = new PolylineZShape();
                        pls.setPoints(points);
                        gc.add(new Graphic(pls, cbs));
                        points = new ArrayList();
                        cbs = new ColorBreakCollection();
                        continue;
                    }
                    points.add(new PointZ(x, y, z));
                    cbs.add(cb);
                }
                if (points.size() <= 1) continue;
                pls = new PolylineZShape();
                pls.setPoints(points);
                gc.add(new Graphic(pls, cbs));
                points = new ArrayList();
            }
        }
        gc.setLegendScheme(ls);
        return gc;
    }

    public static GraphicCollection createErrorLineString(Array xdata, Array ydata, Array xErrorLeft, Array xErrorRight, Array yErrorBottom, Array yErrorUp, PolylineBreak cb, PolylineBreak ecb, float capSize) {
        PolylineShape pls;
        GraphicCollection gc = new GraphicCollection();
        ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
        int i = 0;
        while ((long)i < xdata.getSize()) {
            double x = xdata.getDouble(i);
            double y = ydata.getDouble(i);
            if (Double.isNaN(y) || Double.isNaN(x)) {
                if (!points.isEmpty()) {
                    if (points.size() == 1) {
                        points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                    }
                    pls = new PolylineShape();
                    pls.setPoints(points);
                    gc.add(new Graphic(pls, cb));
                    points = new ArrayList();
                }
            } else {
                CapPolylineShape epls;
                ArrayList<org.meteoinfo.global.PointD> eps;
                points.add(new org.meteoinfo.global.PointD(x, y));
                if (yErrorBottom != null) {
                    double yerrB = yErrorBottom.getDouble(i);
                    double yerrU = yErrorUp.getDouble(i);
                    eps = new ArrayList<org.meteoinfo.global.PointD>();
                    eps.add(new org.meteoinfo.global.PointD(x, y + yerrU));
                    eps.add(new org.meteoinfo.global.PointD(x, y - yerrB));
                    epls = new CapPolylineShape();
                    epls.setCapLen(capSize);
                    epls.setPoints(eps);
                    gc.add(new Graphic(epls, ecb));
                }
                if (xErrorLeft != null) {
                    double xerrL = xErrorLeft.getDouble(i);
                    double xerrR = xErrorRight.getDouble(i);
                    eps = new ArrayList();
                    eps.add(new org.meteoinfo.global.PointD(x - xerrL, y));
                    eps.add(new org.meteoinfo.global.PointD(x + xerrR, y));
                    epls = new CapPolylineShape();
                    epls.setCapLen(capSize);
                    epls.setCapAngle(90.0f);
                    epls.setPoints(eps);
                    gc.add(new Graphic(epls, ecb));
                }
            }
            ++i;
        }
        if (!points.isEmpty()) {
            if (points.size() == 1) {
                points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
            }
            pls = new PolylineShape();
            pls.setPoints(points);
            gc.add(new Graphic(pls, cb));
        }
        gc.setSingleLegend(false);
        PolylineBreak lb = (PolylineBreak)ecb.clone();
        lb.setDrawSymbol(cb.getDrawSymbol());
        gc.setLegendBreak(lb);
        return gc;
    }

    public static GraphicCollection createErrorLineString_bak1(Array xdata, Array ydata, Array xErrorLeft, Array xErrorRight, Array yErrorBottom, Array yErrorUp, ColorBreak cb, ColorBreak ecb, Double capSize) {
        PolylineShape pls;
        GraphicCollection gc = new GraphicCollection();
        ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
        double width = capSize == null ? (ArrayMath.getMaximum(xdata) - ArrayMath.getMinimum(xdata)) / (double)xdata.getSize() * 0.1 : capSize * 0.5;
        int i = 0;
        while ((long)i < xdata.getSize()) {
            double x = xdata.getDouble(i);
            double y = ydata.getDouble(i);
            if (Double.isNaN(y) || Double.isNaN(x)) {
                if (!points.isEmpty()) {
                    if (points.size() == 1) {
                        points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                    }
                    pls = new PolylineShape();
                    pls.setPoints(points);
                    gc.add(new Graphic(pls, cb));
                    points = new ArrayList();
                }
            } else {
                PolylineShape epls;
                ArrayList<org.meteoinfo.global.PointD> eps;
                points.add(new org.meteoinfo.global.PointD(x, y));
                if (yErrorBottom != null) {
                    double yerrB = yErrorBottom.getDouble(i);
                    double yerrU = yErrorUp.getDouble(i);
                    eps = new ArrayList<org.meteoinfo.global.PointD>();
                    eps.add(new org.meteoinfo.global.PointD(x, y + yerrU));
                    eps.add(new org.meteoinfo.global.PointD(x, y - yerrB));
                    epls = new PolylineShape();
                    epls.setPoints(eps);
                    gc.add(new Graphic(epls, ecb));
                    eps = new ArrayList();
                    eps.add(new org.meteoinfo.global.PointD(x - width, y + yerrU));
                    eps.add(new org.meteoinfo.global.PointD(x + width, y + yerrU));
                    epls = new PolylineShape();
                    epls.setPoints(eps);
                    gc.add(new Graphic(epls, ecb));
                    eps = new ArrayList();
                    eps.add(new org.meteoinfo.global.PointD(x - width, y - yerrB));
                    eps.add(new org.meteoinfo.global.PointD(x + width, y - yerrB));
                    epls = new PolylineShape();
                    epls.setPoints(eps);
                    gc.add(new Graphic(epls, ecb));
                }
                if (xErrorLeft != null) {
                    double xerrL = xErrorLeft.getDouble(i);
                    double xerrR = xErrorRight.getDouble(i);
                    eps = new ArrayList();
                    eps.add(new org.meteoinfo.global.PointD(x - xerrL, y));
                    eps.add(new org.meteoinfo.global.PointD(x + xerrR, y));
                    epls = new PolylineShape();
                    epls.setPoints(eps);
                    gc.add(new Graphic(epls, ecb));
                    eps = new ArrayList();
                    eps.add(new org.meteoinfo.global.PointD(x - xerrL, y - width));
                    eps.add(new org.meteoinfo.global.PointD(x - xerrL, y + width));
                    epls = new PolylineShape();
                    epls.setPoints(eps);
                    gc.add(new Graphic(epls, ecb));
                    eps = new ArrayList();
                    eps.add(new org.meteoinfo.global.PointD(x + xerrR, y - width));
                    eps.add(new org.meteoinfo.global.PointD(x + xerrR, y + width));
                    epls = new PolylineShape();
                    epls.setPoints(eps);
                    gc.add(new Graphic(epls, ecb));
                }
            }
            ++i;
        }
        if (!points.isEmpty()) {
            if (points.size() == 1) {
                points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
            }
            pls = new PolylineShape();
            pls.setPoints(points);
            gc.add(new Graphic(pls, cb));
        }
        gc.setSingleLegend(false);
        return gc;
    }

    public static GraphicCollection createErrorLineString_bak(Array xdata, Array ydata, Array xError, Array yError, ColorBreak cb) {
        PolylineErrorShape pls;
        GraphicCollection gc = new GraphicCollection();
        ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
        ArrayList<Number> xerrors = new ArrayList<Number>();
        ArrayList<Number> yerrors = new ArrayList<Number>();
        int i = 0;
        while ((long)i < xdata.getSize()) {
            double x = xdata.getDouble(i);
            double y = ydata.getDouble(i);
            if (Double.isNaN(y) || Double.isNaN(x)) {
                if (!points.isEmpty()) {
                    if (points.size() == 1) {
                        points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                    }
                    pls = new PolylineErrorShape();
                    pls.setPoints(points);
                    if (xError != null) {
                        pls.setXerror(xerrors);
                    }
                    if (yError != null) {
                        pls.setYerror(yerrors);
                    }
                    pls.updateExtent();
                    gc.add(new Graphic(pls, cb));
                    points = new ArrayList();
                    xerrors = new ArrayList();
                    yerrors = new ArrayList();
                }
            } else {
                points.add(new org.meteoinfo.global.PointD(x, y));
                if (xError != null) {
                    xerrors.add(xError.getDouble(i));
                }
                if (yError != null) {
                    yerrors.add(yError.getDouble(i));
                }
            }
            ++i;
        }
        if (points.size() == 1) {
            points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
        }
        pls = new PolylineErrorShape();
        pls.setPoints(points);
        if (xError != null) {
            pls.setXerror(xerrors);
        }
        if (yError != null) {
            pls.setYerror(yerrors);
        }
        pls.updateExtent();
        gc.add(new Graphic(pls, cb));
        return gc;
    }

    public static GraphicCollection createStepLineString(Array xdata, Array ydata, ColorBreak cb, String where) {
        GraphicCollection gc = new GraphicCollection();
        ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
        switch (where) {
            case "mid": {
                PolylineShape pls;
                int i = 0;
                while ((long)i < xdata.getSize() - 1L) {
                    double x1 = xdata.getDouble(i);
                    double x2 = xdata.getDouble(i + 1);
                    double y1 = ydata.getDouble(i);
                    double y2 = ydata.getDouble(i + 1);
                    if (Double.isNaN(y1) || Double.isNaN(x1) || Double.isNaN(x2)) {
                        if (!points.isEmpty() && points.size() > 1) {
                            pls = new PolylineShape();
                            pls.setPoints(points);
                            gc.add(new Graphic(pls, cb));
                            points = new ArrayList();
                        }
                    } else {
                        double x = x1 + (x2 - x1) * 0.5;
                        if (i == 0) {
                            points.add(new org.meteoinfo.global.PointD(x1, y1));
                            points.add(new org.meteoinfo.global.PointD(x, y1));
                            points.add(new org.meteoinfo.global.PointD(x, y2));
                        } else if ((long)i == xdata.getSize() - 2L) {
                            points.add(new org.meteoinfo.global.PointD(x, y1));
                            points.add(new org.meteoinfo.global.PointD(x, y2));
                            points.add(new org.meteoinfo.global.PointD(x2, y2));
                        } else {
                            points.add(new org.meteoinfo.global.PointD(x, y1));
                            points.add(new org.meteoinfo.global.PointD(x, y2));
                        }
                    }
                    ++i;
                }
                if (points.size() <= 1) break;
                pls = new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic(pls, cb));
                break;
            }
            case "post": {
                PolylineShape pls;
                int i = 0;
                while ((long)i < xdata.getSize() - 1L) {
                    double x1 = xdata.getDouble(i);
                    double x2 = xdata.getDouble(i + 1);
                    double y = ydata.getDouble(i);
                    if (Double.isNaN(y) || Double.isNaN(x1) || Double.isNaN(x2)) {
                        if (!points.isEmpty() && points.size() > 1) {
                            pls = new PolylineShape();
                            pls.setPoints(points);
                            gc.add(new Graphic(pls, cb));
                            points = new ArrayList();
                        }
                    } else {
                        points.add(new org.meteoinfo.global.PointD(x1, y));
                        points.add(new org.meteoinfo.global.PointD(x2, y));
                        if ((long)i == xdata.getSize() - 2L) {
                            points.add(new org.meteoinfo.global.PointD(x2, ydata.getDouble(i + 1)));
                        }
                    }
                    ++i;
                }
                if (points.size() <= 1) break;
                pls = new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic(pls, cb));
                break;
            }
            default: {
                PolylineShape pls;
                int i = 0;
                while ((long)i < xdata.getSize() - 1L) {
                    double x1 = xdata.getDouble(i);
                    double x2 = xdata.getDouble(i + 1);
                    double y = ydata.getDouble(i + 1);
                    if (Double.isNaN(y) || Double.isNaN(x1) || Double.isNaN(x2)) {
                        if (!points.isEmpty() && points.size() > 1) {
                            pls = new PolylineShape();
                            pls.setPoints(points);
                            gc.add(new Graphic(pls, cb));
                            points = new ArrayList();
                        }
                    } else {
                        if (i == 0) {
                            points.add(new org.meteoinfo.global.PointD(x1, ydata.getDouble(i)));
                        }
                        points.add(new org.meteoinfo.global.PointD(x1, y));
                        points.add(new org.meteoinfo.global.PointD(x2, y));
                    }
                    ++i;
                }
                if (points.size() <= 1) break;
                pls = new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic(pls, cb));
            }
        }
        return gc;
    }

    public static GraphicCollection createGraphics(Array xdata, Array ydata, ColorBreak cb) {
        GraphicCollection graphics = new GraphicCollection();
        if (cb instanceof PolylineBreak) {
            graphics.add(GraphicFactory.createLineString(xdata, ydata, cb));
        } else {
            int i = 0;
            while ((long)i < xdata.getSize()) {
                PointShape ps = new PointShape();
                ps.setPoint(new org.meteoinfo.global.PointD(xdata.getDouble(i), ydata.getDouble(i)));
                graphics.add(new Graphic(ps, cb));
                ++i;
            }
        }
        return graphics;
    }

    public static GraphicCollection createPoints(Array xdata, Array ydata, List<ColorBreak> cbs) {
        GraphicCollection graphics = new GraphicCollection();
        if ((long)cbs.size() == xdata.getSize()) {
            int i = 0;
            while ((long)i < xdata.getSize()) {
                PointShape ps = new PointShape();
                ps.setPoint(new org.meteoinfo.global.PointD(xdata.getDouble(i), ydata.getDouble(i)));
                graphics.add(new Graphic(ps, cbs.get(i)));
                ++i;
            }
            graphics.setSingleLegend(false);
            LegendScheme ls = new LegendScheme();
            ls.setLegendBreaks(cbs);
            ls.setLegendType(LegendType.UniqueValue);
            ls.setShapeType(ShapeTypes.Point);
            graphics.setLegendScheme(ls);
        } else {
            int i = 0;
            while ((long)i < xdata.getSize()) {
                PointShape ps = new PointShape();
                ps.setPoint(new org.meteoinfo.global.PointD(xdata.getDouble(i), ydata.getDouble(i)));
                graphics.add(new Graphic(ps, cbs.get(0)));
                LegendScheme ls = new LegendScheme();
                ls.setLegendBreaks(cbs);
                ls.setLegendType(LegendType.SingleSymbol);
                ls.setShapeType(ShapeTypes.Point);
                graphics.setLegendScheme(ls);
                ++i;
            }
        }
        return graphics;
    }

    public static GraphicCollection createPoints(Array xdata, Array ydata, Array zdata, LegendScheme ls) {
        GraphicCollection graphics = new GraphicCollection();
        int i = 0;
        while ((long)i < xdata.getSize()) {
            PointShape ps = new PointShape();
            ps.setPoint(new org.meteoinfo.global.PointD(xdata.getDouble(i), ydata.getDouble(i)));
            double z = zdata.getDouble(i);
            ColorBreak cb = ls.findLegendBreak(z);
            graphics.add(new Graphic(ps, cb));
            ++i;
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createPoints3D(Array xdata, Array ydata, Array zdata, ColorBreak cb) {
        ArrayList<ColorBreak> cbs = new ArrayList<ColorBreak>();
        cbs.add(cb);
        return GraphicFactory.createPoints3D(xdata, ydata, zdata, cbs);
    }

    public static GraphicCollection createPoints3D(Array xdata, Array ydata, Array zdata, List<ColorBreak> cbs) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        boolean fixZ = false;
        double z = 0.0;
        if (zdata.getSize() == 1L && xdata.getSize() > 1L) {
            fixZ = true;
            z = zdata.getDouble(0);
        }
        if ((long)cbs.size() == xdata.getSize()) {
            int i = 0;
            while ((long)i < xdata.getSize()) {
                PointZShape ps = new PointZShape();
                if (fixZ) {
                    ((PointShape)ps).setPoint(new PointZ(xdata.getDouble(i), ydata.getDouble(i), z));
                } else {
                    ((PointShape)ps).setPoint(new PointZ(xdata.getDouble(i), ydata.getDouble(i), zdata.getDouble(i)));
                }
                graphics.add(new Graphic(ps, cbs.get(i)));
                ++i;
            }
            graphics.setSingleLegend(false);
            LegendScheme ls = new LegendScheme();
            ls.setLegendBreaks(cbs);
            ls.setLegendType(LegendType.UniqueValue);
            ls.setShapeType(ShapeTypes.Point);
            graphics.setLegendScheme(ls);
        } else {
            int i = 0;
            while ((long)i < xdata.getSize()) {
                PointZShape ps = new PointZShape();
                if (fixZ) {
                    ((PointShape)ps).setPoint(new PointZ(xdata.getDouble(i), ydata.getDouble(i), z));
                } else {
                    ((PointShape)ps).setPoint(new PointZ(xdata.getDouble(i), ydata.getDouble(i), zdata.getDouble(i)));
                }
                graphics.add(new Graphic(ps, cbs.get(0)));
                LegendScheme ls = new LegendScheme();
                ls.setLegendBreaks(cbs);
                ls.setLegendType(LegendType.SingleSymbol);
                ls.setShapeType(ShapeTypes.Point);
                graphics.setLegendScheme(ls);
                ++i;
            }
        }
        return graphics;
    }

    public static GraphicCollection createPoints3D(Array xdata, Array ydata, Array zdata, Array cdata, LegendScheme ls) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        boolean fixZ = false;
        double z = 0.0;
        if (zdata.getSize() == 1L && xdata.getSize() > 1L) {
            fixZ = true;
            z = zdata.getDouble(0);
        }
        int i = 0;
        while ((long)i < xdata.getSize()) {
            PointZShape ps = new PointZShape();
            if (fixZ) {
                ((PointShape)ps).setPoint(new PointZ(xdata.getDouble(i), ydata.getDouble(i), z));
            } else {
                ((PointShape)ps).setPoint(new PointZ(xdata.getDouble(i), ydata.getDouble(i), zdata.getDouble(i)));
            }
            double c = cdata.getDouble(i);
            ColorBreak cb = ls.findLegendBreak(c);
            graphics.add(new Graphic(ps, cb));
            ++i;
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection[] createStems3D(Array xdata, Array ydata, Array zdata, List<ColorBreak> cbs, PolylineBreak plb, double bottom, boolean sameStemColor) {
        GraphicCollection3D stemlines;
        GraphicCollection3D graphics;
        block16: {
            double z0;
            boolean fixZ;
            block12: {
                graphics = new GraphicCollection3D();
                stemlines = new GraphicCollection3D();
                fixZ = false;
                z0 = 0.0;
                if (zdata.getSize() == 1L && xdata.getSize() > 1L) {
                    fixZ = true;
                    z0 = zdata.getDouble(0);
                }
                if ((long)cbs.size() != xdata.getSize()) break block12;
                int i = 0;
                while ((long)i < xdata.getSize()) {
                    block13: {
                        ArrayList<PointZ> pzs;
                        PointZShape ps;
                        block15: {
                            double y;
                            double x;
                            block14: {
                                x = xdata.getDouble(i);
                                y = ydata.getDouble(i);
                                if (Double.isNaN(x) || Double.isNaN(y)) break block13;
                                ps = new PointZShape();
                                pzs = new ArrayList<PointZ>();
                                if (!fixZ) break block14;
                                ((PointShape)ps).setPoint(new PointZ(x, y, z0));
                                pzs.add(new PointZ(x, y, bottom));
                                pzs.add(new PointZ(x, y, z0));
                                break block15;
                            }
                            double z = zdata.getDouble(i);
                            if (Double.isNaN(z)) break block13;
                            ((PointShape)ps).setPoint(new PointZ(x, y, z));
                            pzs.add(new PointZ(x, y, bottom));
                            pzs.add(new PointZ(x, y, z));
                        }
                        graphics.add(new Graphic(ps, cbs.get(i)));
                        PolylineZShape pls = new PolylineZShape();
                        pls.setPoints(pzs);
                        if (sameStemColor) {
                            PolylineBreak nplb = (PolylineBreak)plb.clone();
                            nplb.setColor(cbs.get(i).getColor());
                            stemlines.add(new Graphic(pls, nplb));
                        } else {
                            stemlines.add(new Graphic(pls, plb));
                        }
                    }
                    ++i;
                }
                graphics.setSingleLegend(false);
                LegendScheme ls = new LegendScheme();
                ls.setLegendBreaks(cbs);
                ls.setLegendType(LegendType.UniqueValue);
                ls.setShapeType(ShapeTypes.Point);
                graphics.setLegendScheme(ls);
                break block16;
            }
            int i = 0;
            while ((long)i < xdata.getSize()) {
                PointZShape ps = new PointZShape();
                ArrayList<PointZ> pzs = new ArrayList<PointZ>();
                if (fixZ) {
                    ((PointShape)ps).setPoint(new PointZ(xdata.getDouble(i), ydata.getDouble(i), z0));
                    pzs.add(new PointZ(xdata.getDouble(i), ydata.getDouble(i), bottom));
                    pzs.add(new PointZ(xdata.getDouble(i), ydata.getDouble(i), z0));
                } else {
                    ((PointShape)ps).setPoint(new PointZ(xdata.getDouble(i), ydata.getDouble(i), zdata.getDouble(i)));
                    pzs.add(new PointZ(xdata.getDouble(i), ydata.getDouble(i), bottom));
                    pzs.add(new PointZ(xdata.getDouble(i), ydata.getDouble(i), zdata.getDouble(i)));
                }
                graphics.add(new Graphic(ps, cbs.get(0)));
                PolylineZShape pls = new PolylineZShape();
                pls.setPoints(pzs);
                if (sameStemColor) {
                    PolylineBreak nplb = (PolylineBreak)plb.clone();
                    nplb.setColor(cbs.get(0).getColor());
                    stemlines.add(new Graphic(pls, nplb));
                } else {
                    stemlines.add(new Graphic(pls, plb));
                }
                ++i;
            }
            LegendScheme ls = new LegendScheme();
            ls.setLegendBreaks(cbs);
            ls.setLegendType(LegendType.SingleSymbol);
            ls.setShapeType(ShapeTypes.Point);
            graphics.setLegendScheme(ls);
        }
        return new GraphicCollection[]{stemlines, graphics};
    }

    public static GraphicCollection[] createStems3D(Array xdata, Array ydata, Array zdata, Array cdata, LegendScheme ls, PolylineBreak plb, double bottom, boolean sameStemColor) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        GraphicCollection3D stemlines = new GraphicCollection3D();
        boolean fixZ = false;
        double z0 = 0.0;
        if (zdata.getSize() == 1L && xdata.getSize() > 1L) {
            fixZ = true;
            z0 = zdata.getDouble(0);
        }
        int i = 0;
        while ((long)i < xdata.getSize()) {
            block7: {
                ArrayList<PointZ> pzs;
                PointZShape ps;
                block9: {
                    double y;
                    double x;
                    block8: {
                        x = xdata.getDouble(i);
                        y = ydata.getDouble(i);
                        if (Double.isNaN(x) || Double.isNaN(y)) break block7;
                        ps = new PointZShape();
                        pzs = new ArrayList<PointZ>();
                        if (!fixZ) break block8;
                        ((PointShape)ps).setPoint(new PointZ(x, y, z0));
                        pzs.add(new PointZ(x, y, bottom));
                        pzs.add(new PointZ(x, y, z0));
                        break block9;
                    }
                    double z = zdata.getDouble(i);
                    if (Double.isNaN(z)) break block7;
                    ((PointShape)ps).setPoint(new PointZ(x, y, z));
                    pzs.add(new PointZ(x, y, bottom));
                    pzs.add(new PointZ(x, y, z));
                }
                double c = cdata.getDouble(i);
                ColorBreak cb = ls.findLegendBreak(c);
                graphics.add(new Graphic(ps, cb));
                PolylineZShape pls = new PolylineZShape();
                pls.setPoints(pzs);
                if (sameStemColor) {
                    PolylineBreak nplb = (PolylineBreak)plb.clone();
                    nplb.setColor(cb.getColor());
                    stemlines.add(new Graphic(pls, nplb));
                } else {
                    stemlines.add(new Graphic(pls, plb));
                }
            }
            ++i;
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return new GraphicCollection[]{stemlines, graphics};
    }

    public static GraphicCollection createPolygons(Array xa, Array ya, PolygonBreak pgb) {
        PolygonShape pgs;
        GraphicCollection graphics = new GraphicCollection();
        int n = (int)xa.getSize();
        ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
        for (int i = 0; i < n; ++i) {
            double x = xa.getDouble(i);
            double y = ya.getDouble(i);
            if (Double.isNaN(x)) {
                if (points.size() > 2) {
                    pgs = new PolygonShape();
                    pgs.setPoints(points);
                    Graphic aGraphic = new Graphic(pgs, pgb);
                    graphics.add(aGraphic);
                }
                points = new ArrayList();
                continue;
            }
            org.meteoinfo.global.PointD p = new org.meteoinfo.global.PointD(x, y);
            points.add(p);
        }
        if (points.size() > 2) {
            pgs = new PolygonShape();
            pgs.setPoints(points);
            Graphic aGraphic = new Graphic(pgs, pgb);
            graphics.add(aGraphic);
        }
        return graphics;
    }

    public static GraphicCollection createWireframe(Array xa, Array ya, Array za, PolylineBreak pb) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        int[] shape = xa.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        for (int i = 0; i < rowNum - 1; ++i) {
            for (int j = 0; j < colNum - 1; ++j) {
                int idx1 = i * colNum + j;
                int idx2 = i * colNum + j + 1;
                int idx3 = (i + 1) * colNum + j;
                int idx4 = (i + 1) * colNum + j + 1;
                double z1 = za.getDouble(idx1);
                double z2 = za.getDouble(idx2);
                double z3 = za.getDouble(idx3);
                double z4 = za.getDouble(idx4);
                double z = (z1 + z2 + z3 + z4) / 4.0;
                PolylineZShape ps = new PolylineZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                points.add(new PointZ(xa.getDouble(idx1), ya.getDouble(idx1), z1));
                points.add(new PointZ(xa.getDouble(idx3), ya.getDouble(idx3), z3));
                points.add(new PointZ(xa.getDouble(idx4), ya.getDouble(idx4), z4));
                points.add(new PointZ(xa.getDouble(idx2), ya.getDouble(idx2), z2));
                points.add((PointZ)((PointZ)points.get(0)).clone());
                ps.setPoints(points);
                Graphic graphic = new Graphic(ps, pb);
                graphics.add(graphic);
            }
        }
        return graphics;
    }

    public static GraphicCollection createWireframe(Array xa, Array ya, Array za, LegendScheme ls) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        int[] shape = xa.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        for (int i = 0; i < rowNum - 1; ++i) {
            for (int j = 0; j < colNum - 1; ++j) {
                int idx1 = i * colNum + j;
                int idx2 = i * colNum + j + 1;
                int idx3 = (i + 1) * colNum + j;
                int idx4 = (i + 1) * colNum + j + 1;
                double z1 = za.getDouble(idx1);
                double z2 = za.getDouble(idx2);
                double z3 = za.getDouble(idx3);
                double z4 = za.getDouble(idx4);
                PolylineZShape ps = new PolylineZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                points.add(new PointZ(xa.getDouble(idx1), ya.getDouble(idx1), z1));
                points.add(new PointZ(xa.getDouble(idx3), ya.getDouble(idx3), z3));
                ps.setPoints(points);
                double z = (z1 + z3) * 0.5;
                ps.setValue(z);
                PolylineBreak pb = (PolylineBreak)ls.findLegendBreak(z);
                Graphic graphic = new Graphic(ps, pb);
                graphics.add(graphic);
                ps = new PolylineZShape();
                points = new ArrayList();
                points.add(new PointZ(xa.getDouble(idx3), ya.getDouble(idx3), z3));
                points.add(new PointZ(xa.getDouble(idx4), ya.getDouble(idx4), z4));
                ps.setPoints(points);
                z = (z3 + z4) * 0.5;
                ps.setValue(z);
                pb = (PolylineBreak)ls.findLegendBreak(z);
                graphic = new Graphic(ps, pb);
                graphics.add(graphic);
                ps = new PolylineZShape();
                points = new ArrayList();
                points.add(new PointZ(xa.getDouble(idx4), ya.getDouble(idx4), z4));
                points.add(new PointZ(xa.getDouble(idx2), ya.getDouble(idx2), z2));
                ps.setPoints(points);
                z = (z4 + z2) * 0.5;
                ps.setValue(z);
                pb = (PolylineBreak)ls.findLegendBreak(z);
                graphic = new Graphic(ps, pb);
                graphics.add(graphic);
                ps = new PolylineZShape();
                points = new ArrayList();
                points.add(new PointZ(xa.getDouble(idx2), ya.getDouble(idx2), z2));
                points.add(new PointZ(xa.getDouble(idx1), ya.getDouble(idx1), z1));
                ps.setPoints(points);
                z = (z1 + z2) * 0.5;
                ps.setValue(z);
                pb = (PolylineBreak)ls.findLegendBreak(z);
                graphic = new Graphic(ps, pb);
                graphics.add(graphic);
            }
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createMeshPolygons(Array xa, Array ya, Array za, LegendScheme ls) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        int[] shape = xa.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        for (int i = 0; i < rowNum - 1; ++i) {
            for (int j = 0; j < colNum - 1; ++j) {
                int idx1 = i * colNum + j;
                int idx2 = i * colNum + j + 1;
                int idx3 = (i + 1) * colNum + j;
                int idx4 = (i + 1) * colNum + j + 1;
                double z1 = za.getDouble(idx1);
                double z2 = za.getDouble(idx2);
                double z3 = za.getDouble(idx3);
                double z4 = za.getDouble(idx4);
                double z = (z1 + z2 + z3 + z4) / 4.0;
                PolygonZShape ps = new PolygonZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                points.add(new PointZ(xa.getDouble(idx1), ya.getDouble(idx1), z1));
                points.add(new PointZ(xa.getDouble(idx3), ya.getDouble(idx3), z3));
                points.add(new PointZ(xa.getDouble(idx4), ya.getDouble(idx4), z4));
                points.add(new PointZ(xa.getDouble(idx2), ya.getDouble(idx2), z2));
                points.add((PointZ)((PointZ)points.get(0)).clone());
                ps.setPoints(points);
                ps.highValue = ps.lowValue = z;
                PolygonBreak pb = (PolygonBreak)ls.findLegendBreak(z);
                Graphic graphic = new Graphic(ps, pb);
                graphics.add(graphic);
            }
        }
        graphics.setAllQuads(true);
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createGraphicsFromLayer(VectorLayer layer, double offset, double xshift) {
        LegendScheme ls;
        GraphicCollection3D graphics;
        block25: {
            graphics = new GraphicCollection3D();
            graphics.setFixZ(true);
            graphics.setZValue(offset);
            ShapeTypes shapeType = layer.getShapeType();
            ls = layer.getLegendScheme();
            switch (shapeType) {
                case Point: {
                    for (PointShape pointShape : layer.getShapes()) {
                        PointZShape s = new PointZShape();
                        org.meteoinfo.global.PointD pointD = pointShape.getPoint();
                        PointZ pz = new PointZ(pointD.X + xshift, pointD.Y, offset);
                        s.setPoint(pz);
                        ColorBreak cb = ls.getLegendBreaks().get(pointShape.getLegendIndex());
                        graphics.add(new Graphic(s, cb));
                    }
                    break;
                }
                case Polyline: {
                    for (PolylineShape polylineShape : layer.getShapes()) {
                        ColorBreak cb = ls.getLegendBreaks().get(polylineShape.getLegendIndex());
                        for (Polyline polyline : polylineShape.getPolylines()) {
                            PolylineZShape s = new PolylineZShape();
                            ArrayList<PointZ> arrayList = new ArrayList<PointZ>();
                            for (org.meteoinfo.global.PointD pointD : polyline.getPointList()) {
                                PointZ pz = new PointZ(pointD.X + xshift, pointD.Y, offset);
                                arrayList.add(pz);
                            }
                            s.setPoints(arrayList);
                            graphics.add(new Graphic(s, cb));
                        }
                    }
                    break;
                }
                case Polygon: {
                    for (PolygonShape polygonShape : layer.getShapes()) {
                        PolygonZShape s = new PolygonZShape();
                        ArrayList<PointZ> arrayList = new ArrayList<PointZ>();
                        for (org.meteoinfo.global.PointD pointD : polygonShape.getPoints()) {
                            PointZ pz = new PointZ(pointD.X + xshift, pointD.Y, offset);
                            arrayList.add(pz);
                        }
                        s.setPartNum(polygonShape.getPartNum());
                        s.setParts(polygonShape.getParts());
                        s.setPoints(arrayList);
                        ColorBreak cb = ls.getLegendBreaks().get(polygonShape.getLegendIndex());
                        graphics.add(new Graphic(s, cb));
                    }
                    break;
                }
                case PointZ: 
                case PolylineZ: 
                case PolygonZ: {
                    graphics.setFixZ(false);
                    if (xshift == 0.0) {
                        for (Shape shape : layer.getShapes()) {
                            ColorBreak cb = ls.getLegendBreaks().get(shape.getLegendIndex());
                            graphics.add(new Graphic(shape, cb));
                        }
                        break;
                    }
                    switch (shapeType) {
                        case PointZ: {
                            for (PointZShape pointZShape : layer.getShapes()) {
                                PointZShape s = new PointZShape();
                                PointZ pointZ = (PointZ)pointZShape.getPoint();
                                PointZ pz = new PointZ(pointZ.X + xshift, pointZ.Y, pointZ.Z, pointZ.M);
                                s.setPoint(pz);
                                ColorBreak cb = ls.getLegendBreaks().get(pointZShape.getLegendIndex());
                                graphics.add(new Graphic(s, cb));
                            }
                            break block25;
                        }
                        case PolylineZ: {
                            for (PolylineZShape polylineZShape : layer.getShapes()) {
                                ColorBreak cb = ls.getLegendBreaks().get(polylineZShape.getLegendIndex());
                                for (PolylineZ polylineZ : polylineZShape.getPolylines()) {
                                    PolylineZShape s = new PolylineZShape();
                                    ArrayList<PointZ> arrayList = new ArrayList<PointZ>();
                                    for (PointZ pointZ : polylineZ.getPointList()) {
                                        PointZ pz = new PointZ(pointZ.X + xshift, pointZ.Y, pointZ.Z, pointZ.M);
                                        arrayList.add(pz);
                                    }
                                    s.setPoints(arrayList);
                                    graphics.add(new Graphic(s, cb));
                                }
                            }
                            break block25;
                        }
                        case PolygonZ: {
                            for (PolygonZShape polygonZShape : layer.getShapes()) {
                                PolygonZShape s = new PolygonZShape();
                                ArrayList<PointZ> arrayList = new ArrayList<PointZ>();
                                for (PointZ pointZ : polygonZShape.getPoints()) {
                                    PointZ pz = new PointZ(pointZ.X + xshift, pointZ.Y, pointZ.Z, pointZ.M);
                                    arrayList.add(pz);
                                }
                                s.setPartNum(polygonZShape.getPartNum());
                                s.setParts(polygonZShape.getParts());
                                s.setPoints(arrayList);
                                ColorBreak cb = ls.getLegendBreaks().get(polygonZShape.getLegendIndex());
                                graphics.add(new Graphic(s, cb));
                            }
                        }
                    }
                }
            }
        }
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static Graphic createRectangle(List<Number> pos, List<Number> curvature, PolygonBreak pgb) {
        RectangleShape rect = new RectangleShape(pos.get(0).doubleValue(), pos.get(1).doubleValue(), pos.get(2).doubleValue(), pos.get(3).doubleValue());
        if (curvature != null) {
            rect.setRoundX(curvature.get(0).doubleValue());
            rect.setRoundY(curvature.get(1).doubleValue());
        }
        Graphic graphic = new Graphic(rect, pgb);
        return graphic;
    }

    public static GraphicCollection createBars(Array xdata, Array ydata, boolean autoWidth, Array widths, boolean drawError, Array error, boolean drawBottom, Array bottom, List<BarBreak> bbs) {
        PolylineShape pls;
        GraphicCollection graphics = new GraphicCollection();
        int n = (int)xdata.getSize();
        BarBreak bb = bbs.get(0);
        PolylineBreak ebreak = new PolylineBreak();
        ebreak.setColor(bb.getErrorColor());
        ebreak.setWidth(bb.getErrorSize());
        double width = widths.getDouble(0);
        if (autoWidth && xdata.getSize() > 1L) {
            width = (xdata.getDouble(1) - xdata.getDouble(0)) * width;
        }
        double bot = 0.0;
        if (drawBottom) {
            bot = bottom.getDouble(0);
        }
        double miny = 0.0;
        boolean baseLine = false;
        for (int i = 0; i < n; ++i) {
            double x = xdata.getDouble(i);
            double y = ydata.getDouble(i);
            if (drawBottom) {
                if (bottom.getSize() > (long)i) {
                    bot = bottom.getDouble(i);
                }
                miny = bot;
                y += miny;
            }
            if (y < miny) {
                baseLine = true;
            }
            if (widths.getSize() > 1L && widths.getSize() > (long)i) {
                width = widths.getDouble(i);
            }
            ArrayList<org.meteoinfo.global.PointD> pList = new ArrayList<org.meteoinfo.global.PointD>();
            pList.add(new org.meteoinfo.global.PointD(x, miny));
            pList.add(new org.meteoinfo.global.PointD(x, y));
            pList.add(new org.meteoinfo.global.PointD(x + width, y));
            pList.add(new org.meteoinfo.global.PointD(x + width, miny));
            pList.add(new org.meteoinfo.global.PointD(x, miny));
            PolygonShape pgs = new PolygonShape();
            pgs.setPoints(pList);
            if (bbs.size() > i) {
                bb = bbs.get(i);
            }
            graphics.add(new Graphic(pgs, bb));
            if (!drawError) continue;
            double e = error.getDouble(i);
            pList = new ArrayList();
            pList.add(new org.meteoinfo.global.PointD(x + width * 0.5, y - e));
            pList.add(new org.meteoinfo.global.PointD(x + width * 0.5, y + e));
            pls = new PolylineShape();
            pls.setPoints(pList);
            graphics.add(new Graphic(pls, ebreak));
            pList = new ArrayList();
            pList.add(new org.meteoinfo.global.PointD(x + width * 0.25, y - e));
            pList.add(new org.meteoinfo.global.PointD(x + width * 0.75, y - e));
            pls = new PolylineShape();
            pls.setPoints(pList);
            graphics.add(new Graphic(pls, ebreak));
            pList = new ArrayList();
            pList.add(new org.meteoinfo.global.PointD(x + width * 0.25, y + e));
            pList.add(new org.meteoinfo.global.PointD(x + width * 0.75, y + e));
            pls = new PolylineShape();
            pls.setPoints(pList);
            graphics.add(new Graphic(pls, ebreak));
        }
        if (baseLine) {
            ArrayList<org.meteoinfo.global.PointD> pList = new ArrayList<org.meteoinfo.global.PointD>();
            double x1 = xdata.getDouble(0);
            double x2 = xdata.getDouble((int)xdata.getSize() - 1);
            x1 -= x2 - x1;
            x2 += x2 - x1;
            pList.add(new org.meteoinfo.global.PointD(x1, miny));
            pList.add(new org.meteoinfo.global.PointD(x2, miny));
            pls = new PolylineShape();
            pls.setPoints(pList);
            ebreak = new PolylineBreak();
            ebreak.setColor(Color.black);
            graphics.add(new Graphic(pls, ebreak));
        }
        graphics.setSingleLegend(false);
        return graphics;
    }

    public static GraphicCollection createHBars(Array ydata, Array xdata, boolean autoHeight, Array heights, boolean drawError, Array error, boolean drawLeft, Array left, List<BarBreak> bbs) {
        PolylineShape pls;
        GraphicCollection graphics = new GraphicCollection();
        int n = (int)ydata.getSize();
        BarBreak bb = bbs.get(0);
        PolylineBreak ebreak = new PolylineBreak();
        ebreak.setColor(bb.getErrorColor());
        ebreak.setWidth(bb.getErrorSize());
        double height = heights.getDouble(0);
        if (autoHeight && ydata.getSize() > 1L) {
            height = (ydata.getDouble(1) - ydata.getDouble(0)) * height;
        }
        double bot = 0.0;
        if (drawLeft) {
            bot = left.getDouble(0);
        }
        double minx = 0.0;
        boolean baseLine = false;
        for (int i = 0; i < n; ++i) {
            double x = xdata.getDouble(i);
            double y = ydata.getDouble(i);
            if (drawLeft) {
                if (left.getSize() > (long)i) {
                    bot = left.getDouble(i);
                }
                minx = bot;
                x += minx;
            }
            if (x < minx) {
                baseLine = true;
            }
            if (heights.getSize() > 1L && heights.getSize() > (long)i) {
                height = heights.getDouble(i);
            }
            ArrayList<org.meteoinfo.global.PointD> pList = new ArrayList<org.meteoinfo.global.PointD>();
            pList.add(new org.meteoinfo.global.PointD(minx, y));
            pList.add(new org.meteoinfo.global.PointD(x, y));
            pList.add(new org.meteoinfo.global.PointD(x, y + height));
            pList.add(new org.meteoinfo.global.PointD(minx, y + height));
            pList.add(new org.meteoinfo.global.PointD(minx, y));
            PolygonShape pgs = new PolygonShape();
            pgs.setPoints(pList);
            if (bbs.size() > i) {
                bb = bbs.get(i);
            }
            graphics.add(new Graphic(pgs, bb));
            if (!drawError) continue;
            double e = error.getDouble(i);
            pList = new ArrayList();
            pList.add(new org.meteoinfo.global.PointD(x - e, y + height * 0.5));
            pList.add(new org.meteoinfo.global.PointD(x + e, y + height * 0.5));
            pls = new PolylineShape();
            pls.setPoints(pList);
            graphics.add(new Graphic(pls, ebreak));
            pList = new ArrayList();
            pList.add(new org.meteoinfo.global.PointD(x - e, y + height * 0.25));
            pList.add(new org.meteoinfo.global.PointD(x - e, y + height * 0.75));
            pls = new PolylineShape();
            pls.setPoints(pList);
            graphics.add(new Graphic(pls, ebreak));
            pList = new ArrayList();
            pList.add(new org.meteoinfo.global.PointD(x + e, y + height * 0.25));
            pList.add(new org.meteoinfo.global.PointD(x + e, y + height * 0.75));
            pls = new PolylineShape();
            pls.setPoints(pList);
            graphics.add(new Graphic(pls, ebreak));
        }
        if (baseLine) {
            ArrayList<org.meteoinfo.global.PointD> pList = new ArrayList<org.meteoinfo.global.PointD>();
            double y1 = ydata.getDouble(0);
            double y2 = ydata.getDouble((int)ydata.getSize() - 1);
            y1 -= y2 - y1;
            y2 += y2 - y1;
            pList.add(new org.meteoinfo.global.PointD(minx, y1));
            pList.add(new org.meteoinfo.global.PointD(minx, y2));
            pls = new PolylineShape();
            pls.setPoints(pList);
            ebreak = new PolylineBreak();
            ebreak.setColor(Color.black);
            graphics.add(new Graphic(pls, ebreak));
        }
        graphics.setSingleLegend(false);
        return graphics;
    }

    public static GraphicCollection createBars1(Array xdata, Array ydata, boolean autoWidth, Array widths, boolean drawError, Array error, boolean drawBottom, Array bottom, List<BarBreak> bbs) {
        PolylineShape pls;
        GraphicCollection graphics = new GraphicCollection();
        int n = (int)xdata.getSize();
        BarBreak bb = bbs.get(0);
        PolylineBreak ebreak = new PolylineBreak();
        ebreak.setColor(bb.getErrorColor());
        ebreak.setWidth(bb.getErrorSize());
        double width = widths.getDouble(0);
        if (autoWidth && xdata.getSize() > 1L) {
            width = (xdata.getDouble(1) - xdata.getDouble(0)) * width;
        }
        double bot = 0.0;
        if (drawBottom) {
            bot = bottom.getDouble(0);
        }
        double miny = 0.0;
        boolean baseLine = false;
        for (int i = 0; i < n; ++i) {
            double x1;
            double x = xdata.getDouble(i);
            double y = ydata.getDouble(i);
            if (drawBottom) {
                if (bottom.getSize() > (long)i) {
                    bot = bottom.getDouble(i);
                }
                miny = bot;
                y += miny;
            }
            if (y < miny) {
                baseLine = true;
            }
            if (widths.getSize() > 1L && widths.getSize() > (long)i) {
                width = widths.getDouble(i);
            }
            ArrayList<org.meteoinfo.global.PointD> pList = new ArrayList<org.meteoinfo.global.PointD>();
            pList.add(new org.meteoinfo.global.PointD(x, miny));
            for (x1 = x; x1 < x + width; x1 += width / 100.0) {
                pList.add(new org.meteoinfo.global.PointD(x1, y));
            }
            pList.add(new org.meteoinfo.global.PointD(x + width, y));
            for (x1 = x + width; x1 > x; x1 -= width / 20.0) {
                pList.add(new org.meteoinfo.global.PointD(x1, miny));
            }
            pList.add(new org.meteoinfo.global.PointD(x, miny));
            PolygonShape pgs = new PolygonShape();
            pgs.setPoints(pList);
            if (bbs.size() > i) {
                bb = bbs.get(i);
            }
            graphics.add(new Graphic(pgs, bb));
            if (!drawError) continue;
            double e = error.getDouble(i);
            pList = new ArrayList();
            pList.add(new org.meteoinfo.global.PointD(x + width * 0.5, y - e));
            pList.add(new org.meteoinfo.global.PointD(x + width * 0.5, y + e));
            pls = new PolylineShape();
            pls.setPoints(pList);
            graphics.add(new Graphic(pls, ebreak));
            pList = new ArrayList();
            pList.add(new org.meteoinfo.global.PointD(x + width * 0.25, y - e));
            pList.add(new org.meteoinfo.global.PointD(x + width * 0.75, y - e));
            pls = new PolylineShape();
            pls.setPoints(pList);
            graphics.add(new Graphic(pls, ebreak));
            pList = new ArrayList();
            pList.add(new org.meteoinfo.global.PointD(x + width * 0.25, y + e));
            pList.add(new org.meteoinfo.global.PointD(x + width * 0.75, y + e));
            pls = new PolylineShape();
            pls.setPoints(pList);
            graphics.add(new Graphic(pls, ebreak));
        }
        if (baseLine) {
            ArrayList<org.meteoinfo.global.PointD> pList = new ArrayList<org.meteoinfo.global.PointD>();
            double x1 = xdata.getDouble(0);
            double x2 = xdata.getDouble((int)xdata.getSize() - 1);
            x1 -= x2 - x1;
            x2 += x2 - x1;
            pList.add(new org.meteoinfo.global.PointD(x1, miny));
            pList.add(new org.meteoinfo.global.PointD(x2, miny));
            pls = new PolylineShape();
            pls.setPoints(pList);
            ebreak = new PolylineBreak();
            ebreak.setColor(Color.black);
            graphics.add(new Graphic(pls, ebreak));
        }
        graphics.setSingleLegend(false);
        return graphics;
    }

    public static GraphicCollection createBars_bak(Array xdata, Array ydata, boolean autoWidth, double width, boolean drawError, Array error, boolean drawBottom, Array bottom, List<BarBreak> bbs) {
        GraphicCollection graphics = new GraphicCollection();
        int n = (int)xdata.getSize();
        BarBreak bb = bbs.get(0);
        for (int i = 0; i < n; ++i) {
            double x = xdata.getDouble(i);
            double y = ydata.getDouble(i);
            BarShape bs = new BarShape();
            bs.setPoint(new org.meteoinfo.global.PointD(x, y));
            bs.setAutoWidth(autoWidth);
            bs.setWidth(width);
            bs.setDrawError(drawError);
            if (drawError) {
                bs.setError(error.getDouble(i));
            }
            bs.setDrawBottom(drawBottom);
            if (drawBottom) {
                bs.setBottom(bottom.getDouble(i));
            }
            if (bbs.size() > i) {
                bb = bbs.get(i);
            }
            graphics.add(new Graphic(bs, bb));
        }
        if (bbs.size() == 1) {
            graphics.setSingleLegend(true);
        } else {
            graphics.setSingleLegend(false);
        }
        return graphics;
    }

    public static GraphicCollection createHistBars(Array data, int bins, List<BarBreak> bbs) {
        List<Array> r = ArrayUtil.histogram(data, bins);
        Array xdata = r.get(1);
        Array ydata = r.get(0);
        return GraphicFactory.createHistBars(data, xdata, ydata, bbs);
    }

    public static GraphicCollection createHistBars(Array data, Array bins, List<BarBreak> bbs) {
        List<Array> r = ArrayUtil.histogram(data, bins);
        Array xdata = r.get(1);
        Array ydata = r.get(0);
        return GraphicFactory.createHistBars(data, xdata, ydata, bbs);
    }

    public static GraphicCollection createHistBars(Array data, Array xdata, Array ydata, List<BarBreak> bbs) {
        GraphicCollection graphics = new GraphicCollection();
        int n = (int)ydata.getSize();
        BarBreak bb = bbs.get(0);
        for (int i = 0; i < n; ++i) {
            double x = (xdata.getDouble(i + 1) + xdata.getDouble(i)) * 0.5;
            double width = xdata.getDouble(i + 1) - xdata.getDouble(i);
            double y = ydata.getDouble(i);
            BarShape bs = new BarShape();
            bs.setPoint(new org.meteoinfo.global.PointD(x, y));
            bs.setAutoWidth(false);
            bs.setWidth(width);
            bs.setDrawBottom(false);
            if (bbs.size() > i) {
                bb = bbs.get(i);
            }
            graphics.add(new Graphic(bs, bb));
        }
        if (bbs.size() == 1) {
            graphics.setSingleLegend(true);
        } else {
            graphics.setSingleLegend(false);
        }
        return graphics;
    }

    public static GraphicCollection createStems(Array xdata, Array ydata, PolylineBreak plb, PointBreak pb, PolylineBreak bplb, double bottom) {
        GraphicCollection graphics = new GraphicCollection();
        int n = (int)xdata.getSize();
        double miny = bottom;
        boolean baseLine = false;
        for (int i = 0; i < n; ++i) {
            double x = xdata.getDouble(i);
            double y = ydata.getDouble(i);
            if (Double.isNaN(x) || Double.isNaN(y)) continue;
            if (y < miny) {
                baseLine = true;
            }
            ArrayList<org.meteoinfo.global.PointD> pList = new ArrayList<org.meteoinfo.global.PointD>();
            pList.add(new org.meteoinfo.global.PointD(x, miny));
            pList.add(new org.meteoinfo.global.PointD(x, y));
            PolylineShape pls = new PolylineShape();
            pls.setPoints(pList);
            graphics.add(new Graphic(pls, plb));
            PointShape ps = new PointShape();
            ps.setPoint(new org.meteoinfo.global.PointD(x, y));
            graphics.add(new Graphic(ps, pb));
        }
        if (baseLine) {
            ArrayList<org.meteoinfo.global.PointD> pList = new ArrayList<org.meteoinfo.global.PointD>();
            double x1 = xdata.getDouble(0);
            double x2 = xdata.getDouble((int)xdata.getSize() - 1);
            pList.add(new org.meteoinfo.global.PointD(x1, miny));
            pList.add(new org.meteoinfo.global.PointD(x2, miny));
            PolylineShape pls = new PolylineShape();
            pls.setPoints(pList);
            graphics.add(new Graphic(pls, bplb));
        }
        graphics.setSingleLegend(false);
        return graphics;
    }

    public static Graphic createImage(BufferedImage image) {
        ImageShape ishape = new ImageShape();
        ishape.setPoint(new org.meteoinfo.global.PointD(0.0, 0.0));
        ishape.setImage(image);
        ishape.setExtent(new Extent(0.0, image.getWidth(), 0.0, image.getHeight()));
        return new Graphic(ishape, new ColorBreak());
    }

    public static Graphic createImage(Array gdata, List<Number> extent) {
        double maxy;
        double miny;
        double maxx;
        double minx;
        int j;
        boolean isAlpha;
        int width = gdata.getShape()[1];
        int height = gdata.getShape()[0];
        Color undefColor = Color.white;
        BufferedImage aImage = new BufferedImage(width, height, 2);
        Index index = gdata.getIndex();
        boolean bl = isAlpha = gdata.getShape()[2] == 4;
        if (gdata.getDataType() == DataType.FLOAT || gdata.getDataType() == DataType.DOUBLE) {
            if (isAlpha) {
                for (int i = 0; i < height; ++i) {
                    for (j = 0; j < width; ++j) {
                        float r = gdata.getFloat(index.set(i, j, 0));
                        float g = gdata.getFloat(index.set(i, j, 1));
                        float b = gdata.getFloat(index.set(i, j, 2));
                        float a = gdata.getFloat(index.set(i, j, 3));
                        Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) || Double.isNaN(a) ? undefColor : new Color(r, g, b, a);
                        aImage.setRGB(j, height - i - 1, color.getRGB());
                    }
                }
            } else {
                for (int i = 0; i < height; ++i) {
                    for (int j2 = 0; j2 < width; ++j2) {
                        float r = gdata.getFloat(index.set(i, j2, 0));
                        float g = gdata.getFloat(index.set(i, j2, 1));
                        float b = gdata.getFloat(index.set(i, j2, 2));
                        Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) ? undefColor : new Color(r, g, b);
                        aImage.setRGB(j2, height - i - 1, color.getRGB());
                    }
                }
            }
        } else if (isAlpha) {
            for (int i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    int r = gdata.getInt(index.set(i, j, 0));
                    int g = gdata.getInt(index.set(i, j, 1));
                    int b = gdata.getInt(index.set(i, j, 2));
                    int a = gdata.getInt(index.set(i, j, 3));
                    Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) || Double.isNaN(a) ? undefColor : new Color(r, g, b, a);
                    aImage.setRGB(j, height - i - 1, color.getRGB());
                }
            }
        } else {
            for (int i = 0; i < height; ++i) {
                for (int j3 = 0; j3 < width; ++j3) {
                    int r = gdata.getInt(index.set(i, j3, 0));
                    int g = gdata.getInt(index.set(i, j3, 1));
                    int b = gdata.getInt(index.set(i, j3, 2));
                    Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) ? undefColor : new Color(r, g, b);
                    aImage.setRGB(j3, height - i - 1, color.getRGB());
                }
            }
        }
        ImageShape ishape = new ImageShape();
        if (extent == null) {
            minx = 0.0;
            maxx = width;
            miny = 0.0;
            maxy = height;
        } else {
            minx = extent.get(0).doubleValue();
            maxx = extent.get(1).doubleValue();
            miny = extent.get(2).doubleValue();
            maxy = extent.get(3).doubleValue();
        }
        ishape.setPoint(new org.meteoinfo.global.PointD(minx, miny));
        ishape.setImage(aImage);
        ishape.setExtent(new Extent(minx, maxx, miny, maxy));
        return new Graphic(ishape, new ColorBreak());
    }

    public static Graphic createImage(List<Array> data, List<Number> extent) {
        double maxy;
        double miny;
        double maxx;
        double minx;
        int j;
        Index aindex;
        int width = data.get(0).getShape()[1];
        int height = data.get(0).getShape()[0];
        Color undefColor = Color.white;
        BufferedImage aImage = new BufferedImage(width, height, 2);
        boolean isAlpha = data.size() == 4;
        Array rdata = data.get(0);
        Array gdata = data.get(1);
        Array bdata = data.get(2);
        Index rindex = rdata.getIndex();
        Index gindex = gdata.getIndex();
        Index bindex = bdata.getIndex();
        if (rdata.getDataType() == DataType.FLOAT || rdata.getDataType() == DataType.DOUBLE) {
            if (isAlpha) {
                Array adata = data.get(3);
                aindex = adata.getIndex();
                for (int i = 0; i < height; ++i) {
                    for (j = 0; j < width; ++j) {
                        float r = rdata.getFloat(rindex.set(i, j));
                        float g = gdata.getFloat(gindex.set(i, j));
                        float b = bdata.getFloat(bindex.set(i, j));
                        float a = adata.getFloat(aindex.set(i, j));
                        Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) || Double.isNaN(a) ? undefColor : new Color(r, g, b, a);
                        aImage.setRGB(j, height - i - 1, color.getRGB());
                    }
                }
            } else {
                for (int i = 0; i < height; ++i) {
                    for (int j2 = 0; j2 < width; ++j2) {
                        float r = rdata.getFloat(rindex.set(i, j2));
                        float g = gdata.getFloat(gindex.set(i, j2));
                        float b = bdata.getFloat(bindex.set(i, j2));
                        Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) ? undefColor : new Color(r, g, b);
                        aImage.setRGB(j2, height - i - 1, color.getRGB());
                    }
                }
            }
        } else if (isAlpha) {
            Array adata = data.get(3);
            aindex = adata.getIndex();
            for (int i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    int r = rdata.getInt(rindex.set(i, j));
                    int g = gdata.getInt(gindex.set(i, j));
                    int b = bdata.getInt(bindex.set(i, j));
                    int a = adata.getInt(aindex.set(i, j));
                    Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) || Double.isNaN(a) ? undefColor : new Color(r, g, b, a);
                    aImage.setRGB(j, height - i - 1, color.getRGB());
                }
            }
        } else {
            for (int i = 0; i < height; ++i) {
                for (int j3 = 0; j3 < width; ++j3) {
                    int r = rdata.getInt(rindex.set(i, j3));
                    int g = gdata.getInt(gindex.set(i, j3));
                    int b = bdata.getInt(bindex.set(i, j3));
                    Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) ? undefColor : new Color(r, g, b);
                    aImage.setRGB(j3, height - i - 1, color.getRGB());
                }
            }
        }
        ImageShape ishape = new ImageShape();
        if (extent == null) {
            minx = 0.0;
            maxx = width;
            miny = 0.0;
            maxy = height;
        } else {
            minx = extent.get(0).doubleValue();
            maxx = extent.get(1).doubleValue();
            miny = extent.get(2).doubleValue();
            maxy = extent.get(3).doubleValue();
        }
        ishape.setPoint(new org.meteoinfo.global.PointD(minx, miny));
        ishape.setImage(aImage);
        ishape.setExtent(new Extent(minx, maxx, miny, maxy));
        return new Graphic(ishape, new ColorBreak());
    }

    public static GraphicCollection createImage(Array x, Array y, List<Array> data, double offset, String zdir, String interpolation) {
        Graphic gg = GraphicFactory.createImage(data, null);
        if (interpolation != null) {
            ((ImageShape)gg.getShape()).setInterpolation(interpolation);
        }
        ImageShape shape = (ImageShape)gg.getShape();
        Extent extent = shape.getExtent();
        Extent3D ex3 = new Extent3D();
        ArrayList<PointZ> coords = new ArrayList<PointZ>();
        switch (zdir.toLowerCase()) {
            case "x": {
                ex3 = new Extent3D(offset, offset, extent.minX, extent.maxX, extent.minY, extent.maxY);
                coords.add(new PointZ(offset, extent.minX, extent.minY));
                coords.add(new PointZ(offset, extent.maxX, extent.minY));
                coords.add(new PointZ(offset, extent.maxX, extent.maxY));
                coords.add(new PointZ(offset, extent.minX, extent.maxY));
                break;
            }
            case "y": {
                ex3 = new Extent3D(extent.minX, extent.maxX, offset, offset, extent.minY, extent.maxY);
                coords.add(new PointZ(extent.minX, offset, extent.minY));
                coords.add(new PointZ(extent.maxX, offset, extent.minY));
                coords.add(new PointZ(extent.maxX, offset, extent.maxY));
                coords.add(new PointZ(extent.minX, offset, extent.maxY));
                break;
            }
            case "z": {
                ex3 = new Extent3D(extent.minX, extent.maxX, extent.minY, extent.maxY, offset, offset);
                coords.add(new PointZ(extent.minX, extent.minY, offset));
                coords.add(new PointZ(extent.maxX, extent.minY, offset));
                coords.add(new PointZ(extent.maxX, extent.maxY, offset));
                coords.add(new PointZ(extent.minX, extent.maxY, offset));
            }
        }
        shape.setExtent(ex3);
        shape.setCoords(coords);
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZDir(zdir);
        graphics.setZValue(offset);
        graphics.add(gg);
        return graphics;
    }

    public static Graphic createImage(Array gdata, LegendScheme ls, List<Number> extent) {
        double maxy;
        double miny;
        double maxx;
        double minx;
        int width = gdata.getShape()[1];
        int height = gdata.getShape()[0];
        int breakNum = ls.getBreakNum();
        double[] breakValue = new double[breakNum];
        Color[] breakColor = new Color[breakNum];
        Color undefColor = Color.white;
        for (int i = 0; i < breakNum; ++i) {
            breakValue[i] = Double.parseDouble(ls.getLegendBreaks().get(i).getEndValue().toString());
            breakColor[i] = ls.getLegendBreaks().get(i).getColor();
            if (!ls.getLegendBreaks().get(i).isNoData()) continue;
            undefColor = ls.getLegendBreaks().get(i).getColor();
        }
        Color defaultColor = breakColor[breakNum - 1];
        BufferedImage aImage = new BufferedImage(width, height, 2);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                Color oneColor;
                double oneValue = gdata.getDouble(i * width + j);
                if (Double.isNaN(oneValue)) {
                    oneColor = undefColor;
                } else {
                    int k;
                    oneColor = defaultColor;
                    if (ls.getLegendType() == LegendType.GraduatedColor) {
                        for (k = 0; k < breakNum - 1; ++k) {
                            if (!(oneValue < breakValue[k])) continue;
                            oneColor = breakColor[k];
                            break;
                        }
                    } else {
                        for (k = 0; k < breakNum - 1; ++k) {
                            if (oneValue != breakValue[k]) continue;
                            oneColor = breakColor[k];
                            break;
                        }
                    }
                }
                aImage.setRGB(j, height - i - 1, oneColor.getRGB());
            }
        }
        ImageShape ishape = new ImageShape();
        if (extent == null) {
            minx = 0.0;
            maxx = width;
            miny = 0.0;
            maxy = height;
        } else {
            minx = extent.get(0).doubleValue();
            maxx = extent.get(1).doubleValue();
            miny = extent.get(2).doubleValue();
            maxy = extent.get(3).doubleValue();
        }
        ishape.setPoint(new org.meteoinfo.global.PointD(minx, miny));
        ishape.setImage(aImage);
        ishape.setExtent(new Extent(minx, maxx, miny, maxy));
        return new Graphic(ishape, new ColorBreak());
    }

    public static Graphic createImage(GridArray gdata, LegendScheme ls) {
        int width = gdata.getXNum();
        int height = gdata.getYNum();
        int breakNum = ls.getBreakNum();
        double[] breakValue = new double[breakNum];
        Color[] breakColor = new Color[breakNum];
        Color undefColor = Color.white;
        for (int i = 0; i < breakNum; ++i) {
            breakValue[i] = Double.parseDouble(ls.getLegendBreaks().get(i).getEndValue().toString());
            breakColor[i] = ls.getLegendBreaks().get(i).getColor();
            if (!ls.getLegendBreaks().get(i).isNoData()) continue;
            undefColor = ls.getLegendBreaks().get(i).getColor();
        }
        Color defaultColor = breakColor[breakNum - 1];
        BufferedImage aImage = new BufferedImage(width, height, 2);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                Color oneColor;
                double oneValue = gdata.getDoubleValue(i, j);
                if (Double.isNaN(oneValue) || MIMath.doubleEquals(oneValue, gdata.missingValue)) {
                    oneColor = undefColor;
                } else {
                    int k;
                    oneColor = defaultColor;
                    if (ls.getLegendType() == LegendType.GraduatedColor) {
                        for (k = 0; k < breakNum - 1; ++k) {
                            if (!(oneValue < breakValue[k])) continue;
                            oneColor = breakColor[k];
                            break;
                        }
                    } else {
                        for (k = 0; k < breakNum - 1; ++k) {
                            if (oneValue != breakValue[k]) continue;
                            oneColor = breakColor[k];
                            break;
                        }
                    }
                }
                aImage.setRGB(j, height - i - 1, oneColor.getRGB());
            }
        }
        ImageShape ishape = new ImageShape();
        double xdelta = BigDecimalUtil.mul(gdata.getXDelt(), 0.5);
        double xmin = BigDecimalUtil.sub(gdata.xArray[0], xdelta);
        double xmax = BigDecimalUtil.add(gdata.getXMax(), xdelta);
        double ydelta = BigDecimalUtil.mul(gdata.getYDelt(), 0.5);
        double ymin = BigDecimalUtil.sub(gdata.yArray[0], ydelta);
        double ymax = BigDecimalUtil.add(gdata.getYMax(), ydelta);
        ishape.setPoint(new org.meteoinfo.global.PointD(xmin, ymin));
        ishape.setImage(aImage);
        ishape.setExtent(new Extent(xmin, xmax, ymin, ymax));
        return new Graphic(ishape, new ColorBreak());
    }

    public static Graphic createImage(GridArray gdata, LegendScheme ls, List<Number> extent) {
        double ymax;
        double ymin;
        double xmax;
        double xmin;
        int width = gdata.getXNum();
        int height = gdata.getYNum();
        int breakNum = ls.getBreakNum();
        double[] breakValue = new double[breakNum];
        Color[] breakColor = new Color[breakNum];
        Color undefColor = Color.white;
        for (int i = 0; i < breakNum; ++i) {
            breakValue[i] = Double.parseDouble(ls.getLegendBreaks().get(i).getEndValue().toString());
            breakColor[i] = ls.getLegendBreaks().get(i).getColor();
            if (!ls.getLegendBreaks().get(i).isNoData()) continue;
            undefColor = ls.getLegendBreaks().get(i).getColor();
        }
        Color defaultColor = breakColor[breakNum - 1];
        BufferedImage aImage = new BufferedImage(width, height, 2);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                Color oneColor;
                double oneValue = gdata.getDoubleValue(i, j);
                if (Double.isNaN(oneValue) || MIMath.doubleEquals(oneValue, gdata.missingValue)) {
                    oneColor = undefColor;
                } else {
                    int k;
                    oneColor = defaultColor;
                    if (ls.getLegendType() == LegendType.GraduatedColor) {
                        for (k = 0; k < breakNum - 1; ++k) {
                            if (!(oneValue < breakValue[k])) continue;
                            oneColor = breakColor[k];
                            break;
                        }
                    } else {
                        for (k = 0; k < breakNum - 1; ++k) {
                            if (oneValue != breakValue[k]) continue;
                            oneColor = breakColor[k];
                            break;
                        }
                    }
                }
                aImage.setRGB(j, height - i - 1, oneColor.getRGB());
            }
        }
        ImageShape ishape = new ImageShape();
        if (extent == null) {
            double xdelta = BigDecimalUtil.mul(gdata.getXDelt(), 0.5);
            xmin = BigDecimalUtil.sub(gdata.xArray[0], xdelta);
            xmax = BigDecimalUtil.add(gdata.getXMax(), xdelta);
            double ydelta = BigDecimalUtil.mul(gdata.getYDelt(), 0.5);
            ymin = BigDecimalUtil.sub(gdata.yArray[0], ydelta);
            ymax = BigDecimalUtil.add(gdata.getYMax(), ydelta);
        } else {
            xmin = extent.get(0).doubleValue();
            xmax = extent.get(1).doubleValue();
            ymin = extent.get(2).doubleValue();
            ymax = extent.get(3).doubleValue();
        }
        ishape.setPoint(new org.meteoinfo.global.PointD(xmin, ymin));
        ishape.setImage(aImage);
        ishape.setExtent(new Extent(xmin, xmax, ymin, ymax));
        return new Graphic(ishape, new ColorBreak());
    }

    public static GraphicCollection createImage(GridArray gdata, LegendScheme ls, double offset, String zdir, List<Number> sePoint, String interpolation) {
        Graphic gg = GraphicFactory.createImage(gdata, ls);
        if (interpolation != null) {
            ((ImageShape)gg.getShape()).setInterpolation(interpolation);
        }
        ImageShape shape = (ImageShape)gg.getShape();
        Extent extent = shape.getExtent();
        Extent3D ex3 = new Extent3D();
        ArrayList<PointZ> coords = new ArrayList<PointZ>();
        switch (zdir.toLowerCase()) {
            case "x": {
                ex3 = new Extent3D(offset, offset, extent.minX, extent.maxX, extent.minY, extent.maxY);
                coords.add(new PointZ(offset, extent.minX, extent.minY));
                coords.add(new PointZ(offset, extent.maxX, extent.minY));
                coords.add(new PointZ(offset, extent.maxX, extent.maxY));
                coords.add(new PointZ(offset, extent.minX, extent.maxY));
                break;
            }
            case "y": {
                ex3 = new Extent3D(extent.minX, extent.maxX, offset, offset, extent.minY, extent.maxY);
                coords.add(new PointZ(extent.minX, offset, extent.minY));
                coords.add(new PointZ(extent.maxX, offset, extent.minY));
                coords.add(new PointZ(extent.maxX, offset, extent.maxY));
                coords.add(new PointZ(extent.minX, offset, extent.maxY));
                break;
            }
            case "xy": {
                ex3 = new Extent3D(sePoint.get(0).doubleValue(), sePoint.get(2).doubleValue(), sePoint.get(1).doubleValue(), sePoint.get(3).doubleValue(), extent.minY, extent.maxY);
                coords.add(new PointZ(sePoint.get(0).doubleValue(), sePoint.get(1).doubleValue(), extent.minY));
                coords.add(new PointZ(sePoint.get(2).doubleValue(), sePoint.get(1).doubleValue(), extent.minY));
                coords.add(new PointZ(sePoint.get(2).doubleValue(), sePoint.get(3).doubleValue(), extent.maxY));
                coords.add(new PointZ(sePoint.get(0).doubleValue(), sePoint.get(3).doubleValue(), extent.maxY));
                break;
            }
            case "z": {
                ex3 = new Extent3D(extent.minX, extent.maxX, extent.minY, extent.maxY, offset, offset);
                coords.add(new PointZ(extent.minX, extent.minY, offset));
                coords.add(new PointZ(extent.maxX, extent.minY, offset));
                coords.add(new PointZ(extent.maxX, extent.maxY, offset));
                coords.add(new PointZ(extent.minX, extent.maxY, offset));
            }
        }
        shape.setExtent(ex3);
        shape.setCoords(coords);
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZDir(zdir);
        graphics.setZValue(offset);
        graphics.setSEPoint(sePoint);
        graphics.add(gg);
        graphics.setLegendScheme(ls);
        graphics.setSingleLegend(false);
        return graphics;
    }

    public static GraphicCollection createImage(ImageLayer layer, double offset, double xshift, String interpolation) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZDir("z");
        graphics.setZValue(offset);
        ImageShape ishape = new ImageShape();
        ishape.setImage(layer.getImage());
        Extent extent = layer.getExtent();
        Extent3D ex3 = new Extent3D(extent.minX + xshift, extent.maxX + xshift, extent.minY, extent.maxY, offset, offset);
        ArrayList<PointZ> coords = new ArrayList<PointZ>();
        coords.add(new PointZ(extent.minX + xshift, extent.minY, offset));
        coords.add(new PointZ(extent.maxX + xshift, extent.minY, offset));
        coords.add(new PointZ(extent.maxX + xshift, extent.maxY, offset));
        coords.add(new PointZ(extent.minX + xshift, extent.maxY, offset));
        ishape.setExtent(ex3);
        ishape.setCoords(coords);
        Graphic gg = new Graphic(ishape, new ColorBreak());
        if (interpolation != null) {
            ((ImageShape)gg.getShape()).setInterpolation(interpolation);
        }
        graphics.add(gg);
        return graphics;
    }

    public static GraphicCollection createContourLines(GridData gridData, LegendScheme ls, boolean isSmooth) {
        int[][] S1;
        Object[] ccs = LegendManage.getContoursAndColors(ls = ls.convertTo(ShapeTypes.Polyline));
        double[] cValues = (double[])ccs[0];
        Object[] cbs = ContourDraw.tracingContourLines(gridData.data, cValues, gridData.xArray, gridData.yArray, gridData.missingValue, S1 = new int[gridData.data.length][gridData.data[0].length]);
        List ContourLines = (List)cbs[0];
        if (ContourLines.isEmpty()) {
            return null;
        }
        if (isSmooth) {
            ContourLines = Contour.smoothLines((List)ContourLines);
        }
        ColorBreak cbb = ls.findLegendBreak(0.0);
        GraphicCollection graphics = new GraphicCollection();
        for (int i = 0; i < ContourLines.size(); ++i) {
            int j;
            PolyLine aLine = (PolyLine)ContourLines.get(i);
            double v = aLine.Value;
            PolylineShape aPolyline = new PolylineShape();
            ArrayList<org.meteoinfo.global.PointD> pList = new ArrayList<org.meteoinfo.global.PointD>();
            for (j = 0; j < aLine.PointList.size(); ++j) {
                org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
                aPoint.X = ((PointD)aLine.PointList.get((int)j)).X;
                aPoint.Y = ((PointD)aLine.PointList.get((int)j)).Y;
                pList.add(aPoint);
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue(v);
            aPolyline.setExtent(MIMath.getPointsExtent(pList));
            block0 : switch (ls.getLegendType()) {
                case UniqueValue: {
                    for (j = 0; j < ls.getBreakNum(); ++j) {
                        ColorBreak cb = ls.getLegendBreaks().get(j);
                        if (!MIMath.doubleEquals(v, Double.parseDouble(cb.getStartValue().toString()))) continue;
                        cbb = cb;
                        break block0;
                    }
                    break;
                }
                case GraduatedColor: {
                    int blNum = 0;
                    for (int j2 = 0; j2 < ls.getBreakNum(); ++j2) {
                        ColorBreak cb = ls.getLegendBreaks().get(j2);
                        if (!(MIMath.doubleEquals(v, Double.parseDouble(cb.getStartValue().toString())) || v > Double.parseDouble(cb.getStartValue().toString()) && v < Double.parseDouble(cb.getEndValue().toString())) && (++blNum != ls.getBreakNum() || v != Double.parseDouble(cb.getEndValue().toString()))) continue;
                        cbb = cb;
                        break block0;
                    }
                    break;
                }
            }
            graphics.add(new Graphic(aPolyline, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourLines(GridData gridData, double offset, String zdir, LegendScheme ls, boolean isSmooth) {
        int[][] S1;
        Object[] ccs = LegendManage.getContoursAndColors(ls = ls.convertTo(ShapeTypes.Polyline));
        double[] cValues = (double[])ccs[0];
        Object[] cbs = ContourDraw.tracingContourLines(gridData.data, cValues, gridData.xArray, gridData.yArray, gridData.missingValue, S1 = new int[gridData.data.length][gridData.data[0].length]);
        List ContourLines = (List)cbs[0];
        if (ContourLines.isEmpty()) {
            return null;
        }
        if (isSmooth) {
            ContourLines = Contour.smoothLines((List)ContourLines);
        }
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZValue(offset);
        zdir = zdir.toLowerCase();
        graphics.setZDir(zdir);
        for (int i = 0; i < ContourLines.size(); ++i) {
            PolyLine aLine = (PolyLine)ContourLines.get(i);
            double v = aLine.Value;
            PolylineZShape aPolyline = new PolylineZShape();
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.X = offset;
                        aPoint.Y = ((PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Z = ((PointD)aLine.PointList.get((int)j)).Y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "y": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.Y = offset;
                        aPoint.X = ((PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Z = ((PointD)aLine.PointList.get((int)j)).Y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "z": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.X = ((PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Y = ((PointD)aLine.PointList.get((int)j)).Y;
                        aPoint.Z = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue(v);
            aPolyline.setExtent(MIMath.getPointsExtent(pList));
            ColorBreak cbb = ls.findLegendBreak(v);
            graphics.add(new Graphic(aPolyline, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourLines(GridData gridData, double offset, String zdir, LegendScheme ls, boolean isSmooth, List<Number> sePoint) {
        int[][] S1;
        Object[] ccs = LegendManage.getContoursAndColors(ls = ls.convertTo(ShapeTypes.Polyline));
        double[] cValues = (double[])ccs[0];
        Object[] cbs = ContourDraw.tracingContourLines(gridData.data, cValues, gridData.xArray, gridData.yArray, gridData.missingValue, S1 = new int[gridData.data.length][gridData.data[0].length]);
        List ContourLines = (List)cbs[0];
        if (ContourLines.isEmpty()) {
            return null;
        }
        if (isSmooth) {
            ContourLines = Contour.smoothLines((List)ContourLines);
        }
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZValue(offset);
        graphics.setSEPoint(sePoint);
        zdir = zdir.toLowerCase();
        graphics.setZDir(zdir);
        double xs = sePoint.get(0).doubleValue();
        double ys = sePoint.get(1).doubleValue();
        double xe = sePoint.get(2).doubleValue();
        double ye = sePoint.get(3).doubleValue();
        for (int i = 0; i < ContourLines.size(); ++i) {
            PolyLine aLine = (PolyLine)ContourLines.get(i);
            double v = aLine.Value;
            PolylineZShape aPolyline = new PolylineZShape();
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.X = offset;
                        aPoint.Y = ((PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Z = ((PointD)aLine.PointList.get((int)j)).Y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "y": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.Y = offset;
                        aPoint.X = ((PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Z = ((PointD)aLine.PointList.get((int)j)).Y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "xy": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        double x = ((PointD)aLine.PointList.get((int)j)).X;
                        double y = ((PointD)aLine.PointList.get((int)j)).Y;
                        aPoint = new PointZ();
                        aPoint.X = x;
                        aPoint.Y = ys + (ye - ys) * (x - xs) / (xe - xs);
                        aPoint.Z = y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "z": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.X = ((PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Y = ((PointD)aLine.PointList.get((int)j)).Y;
                        aPoint.Z = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue(v);
            aPolyline.setExtent(MIMath.getPointsExtent(pList));
            ColorBreak cbb = ls.findLegendBreak(v);
            graphics.add(new Graphic(aPolyline, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourPolygons(GridData gridData, LegendScheme ls, boolean isSmooth) {
        ls = ls.convertTo(ShapeTypes.Polygon);
        Object[] ccs = LegendManage.getContoursAndColors(ls);
        double[] cValues = (double[])ccs[0];
        double[] maxmin = new double[2];
        gridData.getMaxMinValue(maxmin);
        double maxData = maxmin[0];
        double minData = maxmin[1];
        int[][] S1 = new int[gridData.data.length][gridData.data[0].length];
        Object[] cbs = ContourDraw.tracingContourLines(gridData.data, cValues, gridData.xArray, gridData.yArray, gridData.missingValue, S1);
        List contourLines = (List)cbs[0];
        List borders = (List)cbs[1];
        if (isSmooth) {
            contourLines = Contour.smoothLines((List)contourLines);
        }
        List<Polygon> contourPolygons = ContourDraw.tracingPolygons(gridData.data, contourLines, borders, cValues);
        ColorBreak cbb = ls.findLegendBreak(0.0);
        GraphicCollection graphics = new GraphicCollection();
        for (int i = 0; i < contourPolygons.size(); ++i) {
            int valueIdx;
            org.meteoinfo.global.PointD aPoint;
            Polygon poly = contourPolygons.get(i);
            double v = poly.LowValue;
            ArrayList<org.meteoinfo.global.PointD> pList = new ArrayList<org.meteoinfo.global.PointD>();
            for (Object pointList : poly.OutLine.PointList) {
                aPoint = new org.meteoinfo.global.PointD();
                aPoint.X = ((PointD)pointList).X;
                aPoint.Y = ((PointD)pointList).Y;
                pList.add(aPoint);
            }
            if (!GeoComputation.isClockwise(pList)) {
                Collections.reverse(pList);
            }
            PolygonShape aPolygonShape = new PolygonShape();
            aPolygonShape.setPoints(pList);
            aPolygonShape.setExtent(MIMath.getPointsExtent(pList));
            aPolygonShape.lowValue = v;
            if (poly.HasHoles()) {
                for (PolyLine holeLine : poly.HoleLines) {
                    pList = new ArrayList();
                    for (PointD pointList : holeLine.PointList) {
                        aPoint = new org.meteoinfo.global.PointD();
                        aPoint.X = pointList.X;
                        aPoint.Y = pointList.Y;
                        pList.add(aPoint);
                    }
                    aPolygonShape.addHole(pList, 0);
                }
            }
            if ((valueIdx = Arrays.binarySearch(cValues, v)) < 0) {
                valueIdx = -valueIdx;
            }
            aPolygonShape.highValue = valueIdx == cValues.length - 1 ? maxData : cValues[valueIdx + 1];
            if (!poly.IsHighCenter && poly.HighValue == poly.LowValue) {
                aPolygonShape.highValue = v;
                aPolygonShape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
            }
            v = aPolygonShape.lowValue;
            block0 : switch (ls.getLegendType()) {
                case UniqueValue: {
                    for (int j = 0; j < ls.getBreakNum(); ++j) {
                        ColorBreak cb = ls.getLegendBreaks().get(j);
                        if (!MIMath.doubleEquals(v, Double.parseDouble(cb.getStartValue().toString()))) continue;
                        cbb = cb;
                        break block0;
                    }
                    break;
                }
                case GraduatedColor: {
                    int blNum = 0;
                    for (int j = 0; j < ls.getBreakNum(); ++j) {
                        ColorBreak cb = ls.getLegendBreaks().get(j);
                        if (!(MIMath.doubleEquals(v, Double.parseDouble(cb.getStartValue().toString())) || v > Double.parseDouble(cb.getStartValue().toString()) && v < Double.parseDouble(cb.getEndValue().toString())) && (++blNum != ls.getBreakNum() || v != Double.parseDouble(cb.getEndValue().toString()))) continue;
                        cbb = cb;
                        break block0;
                    }
                    break;
                }
            }
            graphics.add(new Graphic(aPolygonShape, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourPolygons(GridData gridData, double offset, String zdir, LegendScheme ls, boolean isSmooth) {
        ls = ls.convertTo(ShapeTypes.Polygon);
        Object[] ccs = LegendManage.getContoursAndColors(ls);
        double[] cValues = (double[])ccs[0];
        double[] maxmin = new double[2];
        gridData.getMaxMinValue(maxmin);
        double maxData = maxmin[0];
        double minData = maxmin[1];
        int[][] S1 = new int[gridData.data.length][gridData.data[0].length];
        Object[] cbs = ContourDraw.tracingContourLines(gridData.data, cValues, gridData.xArray, gridData.yArray, gridData.missingValue, S1);
        List contourLines = (List)cbs[0];
        List borders = (List)cbs[1];
        if (isSmooth) {
            contourLines = Contour.smoothLines((List)contourLines);
        }
        List<Polygon> contourPolygons = ContourDraw.tracingPolygons(gridData.data, contourLines, borders, cValues);
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZValue(offset);
        zdir = zdir.toLowerCase();
        graphics.setZDir(zdir);
        for (int i = 0; i < contourPolygons.size(); ++i) {
            int valueIdx;
            PointZ aPoint;
            Polygon poly = contourPolygons.get(i);
            double v = poly.LowValue;
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    for (PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.Y = pointList.X;
                        aPoint.Z = pointList.Y;
                        aPoint.X = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "y": {
                    for (PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.X = pointList.X;
                        aPoint.Z = pointList.Y;
                        aPoint.Y = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "z": {
                    for (PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.X = pointList.X;
                        aPoint.Y = pointList.Y;
                        aPoint.Z = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
            }
            if (!GeoComputation.isClockwise(pList)) {
                Collections.reverse(pList);
            }
            PolygonZShape aPolygonShape = new PolygonZShape();
            aPolygonShape.setPoints(pList);
            aPolygonShape.setExtent(MIMath.getPointsExtent(pList));
            aPolygonShape.lowValue = v;
            if (poly.HasHoles()) {
                switch (zdir) {
                    case "x": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.Y = pointList.X;
                                aPoint.Z = pointList.Y;
                                aPoint.X = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                    case "y": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.X = pointList.X;
                                aPoint.Z = pointList.Y;
                                aPoint.Y = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                    case "z": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.X = pointList.X;
                                aPoint.Y = pointList.Y;
                                aPoint.Z = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                }
            }
            if ((valueIdx = Arrays.binarySearch(cValues, v)) < 0) {
                valueIdx = -valueIdx;
            }
            aPolygonShape.highValue = valueIdx == cValues.length - 1 ? maxData : cValues[valueIdx + 1];
            if (!poly.IsHighCenter && poly.HighValue == poly.LowValue) {
                aPolygonShape.highValue = v;
                aPolygonShape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
            }
            v = aPolygonShape.lowValue;
            ColorBreak cbb = ls.findLegendBreak(v);
            graphics.add(new Graphic(aPolygonShape, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourPolygons(GridData gridData, double offset, String zdir, LegendScheme ls, boolean isSmooth, List<Number> sePoint) {
        ls = ls.convertTo(ShapeTypes.Polygon);
        Object[] ccs = LegendManage.getContoursAndColors(ls);
        double[] cValues = (double[])ccs[0];
        double[] maxmin = new double[2];
        gridData.getMaxMinValue(maxmin);
        double maxData = maxmin[0];
        double minData = maxmin[1];
        int[][] S1 = new int[gridData.data.length][gridData.data[0].length];
        Object[] cbs = ContourDraw.tracingContourLines(gridData.data, cValues, gridData.xArray, gridData.yArray, gridData.missingValue, S1);
        List contourLines = (List)cbs[0];
        List borders = (List)cbs[1];
        if (isSmooth) {
            contourLines = Contour.smoothLines((List)contourLines);
        }
        List<Polygon> contourPolygons = ContourDraw.tracingPolygons(gridData.data, contourLines, borders, cValues);
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZValue(offset);
        graphics.setSEPoint(sePoint);
        zdir = zdir.toLowerCase();
        graphics.setZDir(zdir);
        double xs = sePoint.get(0).doubleValue();
        double ys = sePoint.get(1).doubleValue();
        double xe = sePoint.get(2).doubleValue();
        double ye = sePoint.get(3).doubleValue();
        for (int i = 0; i < contourPolygons.size(); ++i) {
            int valueIdx;
            PointZ aPoint;
            Polygon poly = contourPolygons.get(i);
            double v = poly.LowValue;
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    for (PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.Y = pointList.X;
                        aPoint.Z = pointList.Y;
                        aPoint.X = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "y": {
                    for (PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.X = pointList.X;
                        aPoint.Z = pointList.Y;
                        aPoint.Y = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "xy": {
                    for (PointD pointList : poly.OutLine.PointList) {
                        double x = pointList.X;
                        double y = pointList.Y;
                        aPoint = new PointZ();
                        aPoint.X = x;
                        aPoint.Y = ys + (ye - ys) * (x - xs) / (xe - xs);
                        aPoint.Z = y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "z": {
                    for (PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.X = pointList.X;
                        aPoint.Y = pointList.Y;
                        aPoint.Z = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
            }
            if (!GeoComputation.isClockwise(pList)) {
                Collections.reverse(pList);
            }
            PolygonZShape aPolygonShape = new PolygonZShape();
            aPolygonShape.setPoints(pList);
            aPolygonShape.setExtent(MIMath.getPointsExtent(pList));
            aPolygonShape.lowValue = v;
            if (poly.HasHoles()) {
                switch (zdir) {
                    case "x": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.Y = pointList.X;
                                aPoint.Z = pointList.Y;
                                aPoint.X = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                    case "y": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.X = pointList.X;
                                aPoint.Z = pointList.Y;
                                aPoint.Y = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                    case "z": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.X = pointList.X;
                                aPoint.Y = pointList.Y;
                                aPoint.Z = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                }
            }
            if ((valueIdx = Arrays.binarySearch(cValues, v)) < 0) {
                valueIdx = -valueIdx;
            }
            aPolygonShape.highValue = valueIdx == cValues.length - 1 ? maxData : cValues[valueIdx + 1];
            if (!poly.IsHighCenter && poly.HighValue == poly.LowValue) {
                aPolygonShape.highValue = v;
                aPolygonShape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
            }
            v = aPolygonShape.lowValue;
            ColorBreak cbb = ls.findLegendBreak(v);
            graphics.add(new Graphic(aPolygonShape, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createPColorPolygons(Array x_s, Array y_s, Array a, LegendScheme ls) {
        GraphicCollection gc = new GraphicCollection();
        int[] shape = x_s.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        for (int i = 0; i < rowNum - 1; ++i) {
            for (int j = 0; j < colNum - 1; ++j) {
                double x1 = x_s.getDouble(i * colNum + j);
                double x2 = x_s.getDouble(i * colNum + j + 1);
                double x3 = x_s.getDouble((i + 1) * colNum + j);
                double x4 = x_s.getDouble((i + 1) * colNum + j + 1);
                PolygonShape ps = new PolygonShape();
                ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
                points.add(new org.meteoinfo.global.PointD(x1, y_s.getDouble(i * colNum + j)));
                points.add(new org.meteoinfo.global.PointD(x3, y_s.getDouble((i + 1) * colNum + j)));
                points.add(new org.meteoinfo.global.PointD(x4, y_s.getDouble((i + 1) * colNum + j + 1)));
                points.add(new org.meteoinfo.global.PointD(x2, y_s.getDouble(i * colNum + j + 1)));
                points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                ps.setPoints(points);
                double v = a.getDouble(i * colNum + j);
                PolygonBreak pb = (PolygonBreak)ls.findLegendBreak(v);
                Graphic graphic = new Graphic(ps, pb);
                gc.add(graphic);
            }
        }
        gc.setSingleLegend(false);
        gc.setLegendScheme(ls);
        return gc;
    }

    public static GraphicCollection createGridPolygons(Array x_s, Array y_s, Array a, LegendScheme ls) {
        GraphicCollection gc = new GraphicCollection();
        int colNum = (int)x_s.getSize();
        int rowNum = (int)y_s.getSize();
        double x1 = 0.0;
        double y1 = 0.0;
        for (int i = 0; i < rowNum; ++i) {
            double yd;
            double y2;
            if (i == 0) {
                y1 = y_s.getDouble(i);
            }
            double y = y_s.getDouble(i);
            if (i < rowNum - 1) {
                y2 = y_s.getDouble(i + 1);
                yd = y2 - y;
            } else {
                y2 = y_s.getDouble(i - 1);
                yd = y - y2;
            }
            if (i == 0) {
                y1 -= yd * 0.5;
            }
            y2 = y + yd * 0.5;
            for (int j = 0; j < colNum; ++j) {
                double xd;
                double x2;
                if (j == 0) {
                    x1 = x_s.getDouble(j);
                }
                double x = x_s.getDouble(j);
                if (j < colNum - 1) {
                    x2 = x_s.getDouble(j + 1);
                    xd = x2 - x;
                } else {
                    x2 = x_s.getDouble(j - 1);
                    xd = x - x2;
                }
                if (j == 0) {
                    x1 -= xd * 0.5;
                }
                x2 = x + xd * 0.5;
                PolygonShape ps = new PolygonShape();
                ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
                points.add(new org.meteoinfo.global.PointD(x1, y1));
                points.add(new org.meteoinfo.global.PointD(x1, y2));
                points.add(new org.meteoinfo.global.PointD(x2, y2));
                points.add(new org.meteoinfo.global.PointD(x2, y1));
                points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                ps.setPoints(points);
                double v = a.getDouble(i * colNum + j);
                PolygonBreak pb = (PolygonBreak)ls.findLegendBreak(v);
                Graphic graphic = new Graphic(ps, pb);
                gc.add(graphic);
                x1 = x2;
            }
            y1 = y2;
        }
        gc.setSingleLegend(false);
        gc.setLegendScheme(ls);
        return gc;
    }

    /*
     * WARNING - void declaration
     */
    public static GraphicCollection createFillBetweenPolygons(Array xdata, Array y1data, Array y2data, Array where, PolygonBreak pb) {
        GraphicCollection gc = new GraphicCollection();
        int len = (int)xdata.getSize();
        if (where == null && (ArrayMath.containsNaN(y1data) || ArrayMath.containsNaN(y2data))) {
            void var11_8;
            where = Array.factory(DataType.BOOLEAN, new int[]{len});
            boolean bl = false;
            while (var11_8 < len) {
                double v1 = y1data.getDouble((int)var11_8);
                double v2 = y2data.getDouble((int)var11_8);
                if (Double.isNaN(v1) || Double.isNaN(v2)) {
                    where.setBoolean((int)var11_8, false);
                } else {
                    where.setBoolean((int)var11_8, true);
                }
                ++var11_8;
            }
        }
        if (where == null) {
            int i;
            PolygonShape pgs = new PolygonShape();
            ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
            for (i = 0; i < len; ++i) {
                points.add(new org.meteoinfo.global.PointD(xdata.getDouble(i), y1data.getDouble(i)));
            }
            for (i = len - 1; i >= 0; --i) {
                points.add(new org.meteoinfo.global.PointD(xdata.getDouble(i), y2data.getDouble(i)));
            }
            pgs.setPoints(points);
            Graphic graphic = new Graphic(pgs, pb);
            gc.add(graphic);
        } else {
            boolean ob = false;
            ArrayList idxs = new ArrayList();
            ArrayList<Integer> idx = new ArrayList<Integer>();
            for (int j = 0; j < len; ++j) {
                if (where.getInt(j) == 1) {
                    idx.add(j);
                } else if (ob) {
                    idxs.add(idx);
                    idx = new ArrayList();
                }
                ob = where.getInt(j) == 1;
            }
            if (!idx.isEmpty()) {
                idxs.add(idx);
            }
            for (List list : idxs) {
                int ii;
                int j;
                int nn = list.size();
                if (nn < 2) continue;
                PolygonShape pgs = new PolygonShape();
                ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
                for (j = 0; j < nn; ++j) {
                    ii = (Integer)list.get(j);
                    points.add(new org.meteoinfo.global.PointD(xdata.getDouble(ii), y1data.getDouble(ii)));
                }
                for (j = 0; j < nn; ++j) {
                    ii = (Integer)list.get(nn - j - 1);
                    points.add(new org.meteoinfo.global.PointD(xdata.getDouble(ii), y2data.getDouble(ii)));
                }
                pgs.setPoints(points);
                Graphic graphic = new Graphic(pgs, pb);
                gc.add(graphic);
            }
        }
        return gc;
    }

    /*
     * WARNING - void declaration
     */
    public static GraphicCollection createFillBetweenPolygonsX(Array ydata, Array x1data, Array x2data, Array where, PolygonBreak pb) {
        GraphicCollection gc = new GraphicCollection();
        int len = (int)ydata.getSize();
        if (where == null && (ArrayMath.containsNaN(x1data) || ArrayMath.containsNaN(x2data))) {
            void var11_8;
            where = Array.factory(DataType.BOOLEAN, new int[]{len});
            boolean bl = false;
            while (var11_8 < len) {
                double v1 = x1data.getDouble((int)var11_8);
                double v2 = x2data.getDouble((int)var11_8);
                if (Double.isNaN(v1) || Double.isNaN(v2)) {
                    where.setBoolean((int)var11_8, false);
                } else {
                    where.setBoolean((int)var11_8, true);
                }
                ++var11_8;
            }
        }
        if (where == null) {
            int i;
            PolygonShape pgs = new PolygonShape();
            ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
            for (i = 0; i < len; ++i) {
                points.add(new org.meteoinfo.global.PointD(x1data.getDouble(i), ydata.getDouble(i)));
            }
            for (i = len - 1; i >= 0; --i) {
                points.add(new org.meteoinfo.global.PointD(x2data.getDouble(i), ydata.getDouble(i)));
            }
            pgs.setPoints(points);
            Graphic graphic = new Graphic(pgs, pb);
            gc.add(graphic);
        } else {
            boolean ob = false;
            ArrayList idxs = new ArrayList();
            ArrayList<Integer> idx = new ArrayList<Integer>();
            for (int j = 0; j < len; ++j) {
                if (where.getInt(j) == 1) {
                    idx.add(j);
                } else if (ob) {
                    idxs.add(idx);
                    idx = new ArrayList();
                }
                ob = where.getInt(j) == 1;
            }
            if (!idx.isEmpty()) {
                idxs.add(idx);
            }
            for (List list : idxs) {
                int ii;
                int j;
                int nn = list.size();
                if (nn < 2) continue;
                PolygonShape pgs = new PolygonShape();
                ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
                for (j = 0; j < nn; ++j) {
                    ii = (Integer)list.get(j);
                    points.add(new org.meteoinfo.global.PointD(x1data.getDouble(ii), ydata.getDouble(ii)));
                }
                for (j = 0; j < nn; ++j) {
                    ii = (Integer)list.get(nn - j - 1);
                    points.add(new org.meteoinfo.global.PointD(x2data.getDouble(ii), ydata.getDouble(ii)));
                }
                pgs.setPoints(points);
                Graphic graphic = new Graphic(pgs, pb);
                gc.add(graphic);
            }
        }
        return gc;
    }

    /*
     * WARNING - void declaration
     */
    public static GraphicCollection createFillBetweenPolygons(Array xdata, Array y1data, Array y2data, Array where, PolygonBreak pb, double offset, String zdir) {
        GraphicCollection3D gc = new GraphicCollection3D();
        gc.setFixZ(true);
        gc.setZValue(offset);
        gc.setZDir(zdir);
        int len = (int)xdata.getSize();
        if (where == null && (ArrayMath.containsNaN(y1data) || ArrayMath.containsNaN(y2data))) {
            void var14_10;
            where = Array.factory(DataType.BOOLEAN, new int[]{len});
            boolean bl = false;
            while (var14_10 < len) {
                double v1 = y1data.getDouble((int)var14_10);
                double v2 = y2data.getDouble((int)var14_10);
                if (Double.isNaN(v1) || Double.isNaN(v2)) {
                    where.setBoolean((int)var14_10, false);
                } else {
                    where.setBoolean((int)var14_10, true);
                }
                ++var14_10;
            }
        }
        if (where == null) {
            PolygonZShape pgs = new PolygonZShape();
            ArrayList<PointZ> points = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    void var14_14;
                    void var14_12;
                    boolean bl = false;
                    while (var14_12 < len) {
                        points.add(new PointZ(offset, xdata.getDouble((int)var14_12), y1data.getDouble((int)var14_12)));
                        ++var14_12;
                    }
                    int n = len - 1;
                    while (var14_14 >= 0) {
                        points.add(new PointZ(offset, xdata.getDouble((int)var14_14), y2data.getDouble((int)var14_14)));
                        --var14_14;
                    }
                    break;
                }
                case "y": {
                    void var14_18;
                    void var14_16;
                    boolean bl = false;
                    while (var14_16 < len) {
                        points.add(new PointZ(xdata.getDouble((int)var14_16), offset, y1data.getDouble((int)var14_16)));
                        ++var14_16;
                    }
                    int n = len - 1;
                    while (var14_18 >= 0) {
                        points.add(new PointZ(xdata.getDouble((int)var14_18), offset, y2data.getDouble((int)var14_18)));
                        --var14_18;
                    }
                    break;
                }
                case "z": {
                    void var14_22;
                    void var14_20;
                    boolean bl = false;
                    while (var14_20 < len) {
                        points.add(new PointZ(xdata.getDouble((int)var14_20), y1data.getDouble((int)var14_20), offset));
                        ++var14_20;
                    }
                    int n = len - 1;
                    while (var14_22 >= 0) {
                        points.add(new PointZ(xdata.getDouble((int)var14_22), y2data.getDouble((int)var14_22), offset));
                        --var14_22;
                    }
                    break;
                }
            }
            pgs.setPoints(points);
            Graphic graphic = new Graphic(pgs, pb);
            gc.add(graphic);
        } else {
            boolean ob = false;
            ArrayList idxs = new ArrayList();
            ArrayList<Integer> idx = new ArrayList<Integer>();
            for (int j = 0; j < len; ++j) {
                if (where.getInt(j) == 1) {
                    idx.add(j);
                } else if (ob) {
                    idxs.add(idx);
                    idx = new ArrayList();
                }
                ob = where.getInt(j) == 1;
            }
            if (!idx.isEmpty()) {
                idxs.add(idx);
            }
            for (List list : idxs) {
                int nn = list.size();
                if (nn < 2) continue;
                PolygonZShape pgs = new PolygonZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                switch (zdir) {
                    case "x": {
                        int ii;
                        int j;
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(j);
                            points.add(new PointZ(offset, xdata.getDouble(ii), y1data.getDouble(ii)));
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(nn - j - 1);
                            points.add(new PointZ(offset, xdata.getDouble(ii), y2data.getDouble(ii)));
                        }
                        break;
                    }
                    case "y": {
                        int ii;
                        int j;
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(j);
                            points.add(new PointZ(xdata.getDouble(ii), offset, y1data.getDouble(ii)));
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(nn - j - 1);
                            points.add(new PointZ(xdata.getDouble(ii), offset, y2data.getDouble(ii)));
                        }
                        break;
                    }
                    case "z": {
                        int ii;
                        int j;
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(j);
                            points.add(new PointZ(xdata.getDouble(ii), y1data.getDouble(ii), offset));
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(nn - j - 1);
                            points.add(new PointZ(xdata.getDouble(ii), y2data.getDouble(ii), offset));
                        }
                        break;
                    }
                }
                pgs.setPoints(points);
                Graphic graphic = new Graphic(pgs, pb);
                gc.add(graphic);
            }
        }
        return gc;
    }

    /*
     * WARNING - void declaration
     */
    public static GraphicCollection createFillBetweenPolygons(Array xdata, Array ydata, Array y1data, Array y2data, Array where, PolygonBreak pb, double offset, String zdir) {
        GraphicCollection3D gc = new GraphicCollection3D();
        gc.setFixZ(true);
        gc.setZValue(offset);
        gc.setZDir(zdir);
        int len = (int)xdata.getSize();
        if (where == null) {
            PolygonZShape pgs = new PolygonZShape();
            ArrayList<PointZ> points = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    void var15_22;
                    void var15_20;
                    boolean bl = false;
                    while (var15_20 < len) {
                        points.add(new PointZ(offset, xdata.getDouble((int)var15_20), y1data.getDouble((int)var15_20)));
                        ++var15_20;
                    }
                    int n = len - 1;
                    while (var15_22 >= 0) {
                        points.add(new PointZ(offset, xdata.getDouble((int)var15_22), y2data.getDouble((int)var15_22)));
                        --var15_22;
                    }
                    break;
                }
                case "y": {
                    void var15_26;
                    void var15_24;
                    boolean bl = false;
                    while (var15_24 < len) {
                        points.add(new PointZ(xdata.getDouble((int)var15_24), offset, y1data.getDouble((int)var15_24)));
                        ++var15_24;
                    }
                    int n = len - 1;
                    while (var15_26 >= 0) {
                        points.add(new PointZ(xdata.getDouble((int)var15_26), offset, y2data.getDouble((int)var15_26)));
                        --var15_26;
                    }
                    break;
                }
                case "xy": {
                    void var15_30;
                    void var15_28;
                    boolean bl = false;
                    while (var15_28 < len) {
                        points.add(new PointZ(xdata.getDouble((int)var15_28), ydata.getDouble((int)var15_28), y1data.getDouble((int)var15_28)));
                        ++var15_28;
                    }
                    int n = len - 1;
                    while (var15_30 >= 0) {
                        points.add(new PointZ(xdata.getDouble((int)var15_30), ydata.getDouble((int)var15_30), y2data.getDouble((int)var15_30)));
                        --var15_30;
                    }
                    break;
                }
                case "z": {
                    void var15_34;
                    void var15_32;
                    boolean bl = false;
                    while (var15_32 < len) {
                        points.add(new PointZ(xdata.getDouble((int)var15_32), y1data.getDouble((int)var15_32), offset));
                        ++var15_32;
                    }
                    int n = len - 1;
                    while (var15_34 >= 0) {
                        points.add(new PointZ(xdata.getDouble((int)var15_34), y2data.getDouble((int)var15_34), offset));
                        --var15_34;
                    }
                    break;
                }
            }
            pgs.setPoints(points);
            Graphic graphic = new Graphic(pgs, pb);
            gc.add(graphic);
        } else {
            boolean ob = false;
            ArrayList idxs = new ArrayList();
            ArrayList<Integer> idx = new ArrayList<Integer>();
            for (int j = 0; j < len; ++j) {
                if (where.getInt(j) == 1) {
                    if (!ob) {
                        idx = new ArrayList();
                    }
                    idx.add(j);
                } else if (ob) {
                    idxs.add(idx);
                }
                ob = where.getInt(j) == 1;
            }
            for (List list : idxs) {
                int nn = list.size();
                if (nn < 2) continue;
                PolygonZShape pgs = new PolygonZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                switch (zdir) {
                    case "x": {
                        int ii;
                        int j;
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(j);
                            points.add(new PointZ(offset, xdata.getDouble(ii), y1data.getDouble(ii)));
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(nn - j - 1);
                            points.add(new PointZ(offset, xdata.getDouble(ii), y2data.getDouble(ii)));
                        }
                        break;
                    }
                    case "y": {
                        int ii;
                        int j;
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(j);
                            points.add(new PointZ(xdata.getDouble(ii), offset, y1data.getDouble(ii)));
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(nn - j - 1);
                            points.add(new PointZ(xdata.getDouble(ii), offset, y2data.getDouble(ii)));
                        }
                        break;
                    }
                    case "xy": {
                        int ii;
                        int j;
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(j);
                            points.add(new PointZ(xdata.getDouble(ii), ydata.getDouble(ii), y1data.getDouble(ii)));
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(nn - j - 1);
                            points.add(new PointZ(xdata.getDouble(ii), ydata.getDouble(ii), y2data.getDouble(ii)));
                        }
                        break;
                    }
                    case "z": {
                        int ii;
                        int j;
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(j);
                            points.add(new PointZ(xdata.getDouble(ii), y1data.getDouble(ii), offset));
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(nn - j - 1);
                            points.add(new PointZ(xdata.getDouble(ii), y2data.getDouble(ii), offset));
                        }
                        break;
                    }
                }
                pgs.setPoints(points);
                Graphic graphic = new Graphic(pgs, pb);
                gc.add(graphic);
            }
        }
        return gc;
    }

    public static GraphicCollection createBarbs(Array xdata, Array ydata, Array udata, Array vdata, Array cdata, LegendScheme ls, boolean isUV) {
        int i;
        Array windSpeedData;
        Array windDirData;
        GraphicCollection gc = new GraphicCollection();
        if (isUV) {
            Array[] wwData = MeteoMath.uv2ds(udata, vdata);
            windDirData = wwData[0];
            windSpeedData = wwData[1];
        } else {
            windDirData = udata;
            windSpeedData = vdata;
        }
        ShapeTypes sts = ls.getShapeType();
        ls = ls.convertTo(ShapeTypes.Point);
        if (sts != ShapeTypes.Point) {
            for (i = 0; i < ls.getBreakNum(); ++i) {
                ((PointBreak)ls.getLegendBreaks().get(i)).setSize(10.0f);
            }
        }
        int dn = (int)xdata.getSize();
        for (i = 0; i < dn; ++i) {
            ColorBreak cb;
            double windDir = windDirData.getDouble(i);
            double windSpeed = windSpeedData.getDouble(i);
            if (Double.isNaN(windDir) || Double.isNaN(windSpeed)) continue;
            org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
            aPoint.X = xdata.getDouble(i);
            aPoint.Y = ydata.getDouble(i);
            WindBarb aWB = Draw.calWindBarb((float)windDir, (float)windSpeed, 0.0, 10.0f, aPoint);
            if (cdata == null) {
                cb = ls.getLegendBreaks().get(0);
            } else {
                double v = cdata.getDouble(i);
                aWB.setValue(v);
                cb = ls.findLegendBreak(v);
            }
            Graphic graphic = new Graphic(aWB, cb);
            gc.add(graphic);
        }
        gc.setLegendScheme(ls);
        if (cdata != null) {
            gc.setSingleLegend(false);
        }
        return gc;
    }

    public static Graphic createArrow(double x, double y, double dx, double dy, ArrowPolygonBreak ab) {
        double[] r = MeteoMath.uv2ds(dx, dy);
        double length = r[1];
        if (ab.isLengthIncludesHead()) {
            length -= (double)ab.getHeadLength();
        }
        AffineTransform atf = new AffineTransform();
        atf.translate(x, y);
        atf.rotate(dx, dy);
        float width = ab.getWidth();
        float headLength = ab.getHeadLength();
        float overhang = ab.getOverhang();
        float lenShift = headLength * overhang;
        double[] srcPts = new double[]{0.0, (double)(-width) * 0.5, 0.0, (double)width * 0.5, length + (double)lenShift, (double)width * 0.5, length, (double)ab.getHeadWidth() * 0.5, length + (double)ab.getHeadLength(), 0.0, length, (double)(-ab.getHeadWidth()) * 0.5, length + (double)lenShift, (double)(-width) * 0.5, 0.0, (double)(-width) * 0.5};
        atf.transform(srcPts, 0, srcPts, 0, 8);
        ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
        for (int i = 0; i < srcPts.length; i += 2) {
            points.add(new org.meteoinfo.global.PointD(srcPts[i], srcPts[i + 1]));
        }
        PolygonShape pgs = new PolygonShape();
        pgs.setPoints(points);
        return new Graphic(pgs, ab);
    }

    public static Graphic createArrowLine(double x, double y, double dx, double dy, ArrowLineBreak ab) {
        ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
        points.add(new org.meteoinfo.global.PointD(x, y));
        points.add(new org.meteoinfo.global.PointD(x + dx, y + dy));
        PolylineShape pls = new PolylineShape();
        pls.setPoints(points);
        return new Graphic(pls, ab);
    }

    public static Graphic createArrowLine(Array x, Array y, ArrowLineBreak ab, boolean iscurve) {
        ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
        int i = 0;
        while ((long)i < x.getSize()) {
            points.add(new org.meteoinfo.global.PointD(x.getDouble(i), y.getDouble(i)));
            ++i;
        }
        PolylineShape pls = iscurve ? new CurveLineShape() : new PolylineShape();
        pls.setPoints(points);
        return new Graphic(pls, ab);
    }

    public static GraphicCollection createArrows(Array xdata, Array ydata, Array udata, Array vdata, Array cdata, LegendScheme ls, boolean isUV) {
        int i;
        Array windSpeedData;
        Array windDirData;
        GraphicCollection gc = new GraphicCollection();
        if (isUV) {
            Array[] wwData = MeteoMath.uv2ds(udata, vdata);
            windDirData = wwData[0];
            windSpeedData = wwData[1];
        } else {
            windDirData = udata;
            windSpeedData = vdata;
        }
        ShapeTypes sts = ls.getShapeType();
        ls = ls.convertTo(ShapeTypes.Point);
        if (sts != ShapeTypes.Point) {
            for (i = 0; i < ls.getBreakNum(); ++i) {
                ((PointBreak)ls.getLegendBreaks().get(i)).setSize(10.0f);
            }
        }
        int dn = (int)xdata.getSize();
        float size = 6.0f;
        for (i = 0; i < dn; ++i) {
            ColorBreak cb;
            double windDir = windDirData.getDouble(i);
            double windSpeed = windSpeedData.getDouble(i);
            if (Double.isNaN(windDir) || Double.isNaN(windSpeed)) continue;
            org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
            aPoint.X = xdata.getDouble(i);
            aPoint.Y = ydata.getDouble(i);
            WindArrow wa = new WindArrow();
            wa.angle = windDir;
            wa.length = (float)windSpeed;
            wa.size = size;
            wa.setPoint(aPoint);
            if (cdata == null) {
                cb = ls.getLegendBreaks().get(0);
            } else {
                double v = cdata.getDouble(i);
                wa.setValue(v);
                cb = ls.findLegendBreak(v);
            }
            Graphic graphic = new Graphic(wa, cb);
            gc.add(graphic);
        }
        gc.setLegendScheme(ls);
        if (cdata != null) {
            gc.setSingleLegend(false);
        }
        return gc;
    }

    public static GraphicCollection createArrows3D(Array xdata, Array ydata, Array zdata, Array udata, Array vdata, Array wdata, float length, Array cdata, LegendScheme ls) {
        int i;
        GraphicCollection gc = new GraphicCollection();
        ShapeTypes sts = ls.getShapeType();
        ls = ls.convertTo(ShapeTypes.Point);
        if (sts != ShapeTypes.Point) {
            for (i = 0; i < ls.getBreakNum(); ++i) {
                ((PointBreak)ls.getLegendBreaks().get(i)).setSize(10.0f);
            }
        }
        int dn = (int)xdata.getSize();
        for (i = 0; i < dn; ++i) {
            ColorBreak cb;
            double u = udata.getDouble(i);
            double v = vdata.getDouble(i);
            double w = wdata.getDouble(i);
            if (Double.isNaN(u) || Double.isNaN(v) || Double.isNaN(w)) continue;
            PointZ aPoint = new PointZ();
            aPoint.X = xdata.getDouble(i);
            aPoint.Y = ydata.getDouble(i);
            aPoint.Z = zdata.getDouble(i);
            WindArrow3D wa = new WindArrow3D();
            wa.u = u;
            wa.v = v;
            wa.w = w;
            wa.length = length;
            wa.setPoint(aPoint);
            if (cdata == null) {
                cb = ls.getLegendBreaks().get(0);
            } else {
                double value = cdata.getDouble(i);
                wa.setValue(value);
                cb = ls.findLegendBreak(value);
            }
            Graphic graphic = new Graphic(wa, cb);
            gc.add(graphic);
        }
        gc.setLegendScheme(ls);
        if (cdata != null) {
            gc.setSingleLegend(false);
        }
        return gc;
    }

    public static GraphicCollection[] createPieArcs(Array xdata, List<Color> colors, List<String> labels, float startAngle, List<Number> explode, Font labelFont, Color labelColor, float labelDis, String autopct, float pctDis, float radius, HashMap wedgeprops) {
        double dx;
        GraphicCollection gc = new GraphicCollection();
        GraphicCollection lgc = new GraphicCollection();
        GraphicCollection pgc = new GraphicCollection();
        double sum = ArrayMath.sum(xdata);
        int n = (int)xdata.getSize();
        String pct = null;
        LegendScheme ls = new LegendScheme(ShapeTypes.Polygon);
        Boolean drawEdge = wedgeprops.get("drawedge") == null ? null : (Boolean)wedgeprops.get("drawedge");
        Color edgeColor = wedgeprops.get("edgecolor") == null ? null : (Color)wedgeprops.get("edgecolor");
        Float lineWidth = wedgeprops.get("linewidth") == null ? null : Float.valueOf(Float.parseFloat(String.valueOf(wedgeprops.get("linewidth"))));
        Float wedgeWidth = wedgeprops.get("width") == null ? null : Float.valueOf(Float.parseFloat(String.valueOf(wedgeprops.get("width"))));
        for (int i = 0; i < n; ++i) {
            double ldy;
            double ldx;
            ChartText ps;
            String label;
            double dy;
            double v = xdata.getDouble(i);
            if (Double.isNaN(v)) continue;
            if (sum > 1.0) {
                v /= sum;
            }
            float sweepAngle = (float)(360.0 * v);
            ArcShape aShape = new ArcShape();
            aShape.setStartAngle(startAngle);
            aShape.setSweepAngle(sweepAngle);
            float angle = startAngle + sweepAngle / 2.0f;
            if (explode == null) {
                dx = 0.0;
                dy = 0.0;
            } else {
                float ex = explode.get(i).floatValue();
                aShape.setExplode(ex);
                dx = (double)(radius * ex) * Math.cos((double)angle * Math.PI / 180.0);
                dy = (double)(radius * ex) * Math.sin((double)angle * Math.PI / 180.0);
            }
            ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
            points.add(new org.meteoinfo.global.PointD((double)(-radius) + dx, (double)(-radius) + dy));
            points.add(new org.meteoinfo.global.PointD((double)(-radius) + dx, (double)radius + dy));
            points.add(new org.meteoinfo.global.PointD((double)radius + dx, (double)radius + dy));
            points.add(new org.meteoinfo.global.PointD((double)radius + dx, (double)(-radius) + dy));
            points.add(new org.meteoinfo.global.PointD(dx, dy));
            aShape.setPoints(points);
            if (wedgeWidth != null) {
                aShape.setWedgeWidth(wedgeWidth);
            }
            PolygonBreak pgb = new PolygonBreak();
            pgb.setColor(colors.get(i));
            if (drawEdge != null) {
                pgb.setDrawOutline(drawEdge);
            }
            if (edgeColor != null) {
                pgb.setOutlineColor(edgeColor);
            }
            if (lineWidth != null) {
                pgb.setOutlineSize(lineWidth.floatValue());
            }
            if (labels == null) {
                label = autopct == null ? "" : String.format(autopct, v * 100.0);
            } else {
                label = labels.get(i);
                if (autopct != null) {
                    pct = String.format(autopct, v * 100.0);
                }
            }
            pgb.setCaption(label);
            Graphic graphic = new Graphic(aShape, pgb);
            gc.add(graphic);
            ls.addLegendBreak(pgb);
            if (!label.isEmpty()) {
                ps = new ChartText();
                ldx = dx + (double)(radius * labelDis) * Math.cos((double)angle * Math.PI / 180.0);
                ldy = dy + (double)(radius * labelDis) * Math.sin((double)angle * Math.PI / 180.0);
                ps.setPoint(ldx, ldy);
                ps.setText(label);
                ps.setFont(labelFont);
                ps.setColor(labelColor);
                if (angle > 90.0f && angle < 270.0f) {
                    ps.setXAlign(XAlign.RIGHT);
                }
                if (angle > 180.0f && angle < 360.0f) {
                    ps.setYAlign(YAlign.TOP);
                }
                if (angle == 0.0f || angle == 180.0f) {
                    ps.setYAlign(YAlign.CENTER);
                } else if (angle == 90.0f || angle == 270.0f) {
                    ps.setXAlign(XAlign.CENTER);
                }
                lgc.add(new Graphic(ps, new ColorBreak()));
            }
            if (pct != null) {
                ps = new ChartText();
                ldx = dx + (double)(radius * pctDis) * Math.cos((double)angle * Math.PI / 180.0);
                ldy = dy + (double)(radius * pctDis) * Math.sin((double)angle * Math.PI / 180.0);
                ps.setPoint(ldx, ldy);
                ps.setText(pct);
                ps.setFont(labelFont);
                ps.setColor(labelColor);
                ps.setXAlign(XAlign.CENTER);
                ps.setYAlign(YAlign.CENTER);
                pgc.add(new Graphic(ps, new ColorBreak()));
            }
            startAngle += sweepAngle;
        }
        gc.setSingleLegend(false);
        gc.setLegendScheme(ls);
        gc.getLabelSet().setLabelFont(labelFont);
        gc.getLabelSet().setLabelColor(labelColor);
        dx = (double)radius * 0.1;
        if (labels != null || autopct != null) {
            Extent ext = gc.getExtent().extend(dx, dx);
            gc.setExtent(ext);
        }
        if (pct == null) {
            if (lgc.isEmpty()) {
                return new GraphicCollection[]{gc};
            }
            return new GraphicCollection[]{gc, lgc};
        }
        if (lgc.isEmpty()) {
            return new GraphicCollection[]{gc, pgc};
        }
        return new GraphicCollection[]{gc, lgc, pgc};
    }

    public static GraphicCollection createBox(List<Array> xdata, List<Number> positions, List<Number> widths, boolean showcaps, boolean showfliers, boolean showmeans, boolean showmedians, PolygonBreak boxBreak, ColorBreak medianBreak, PolylineBreak whiskerBreak, PolylineBreak capBreak, ColorBreak meanBreak, PointBreak flierBreak) {
        int i;
        GraphicCollection gc = new GraphicCollection();
        int n = xdata.size();
        if (positions == null) {
            positions = new ArrayList<Number>();
            for (i = 0; i < n; ++i) {
                positions.add(i + 1);
            }
        }
        if (widths == null) {
            widths = new ArrayList<Number>();
            for (i = 0; i < n; ++i) {
                widths.add(0.5);
            }
        }
        if (boxBreak == null) {
            boxBreak = new PolygonBreak();
            boxBreak.setDrawFill(false);
            boxBreak.setOutlineColor(Color.blue);
        }
        if (medianBreak == null) {
            medianBreak = new PolylineBreak();
            medianBreak.setColor(Color.red);
        }
        if (whiskerBreak == null) {
            whiskerBreak = new PolylineBreak();
            whiskerBreak.setColor(Color.black);
            whiskerBreak.setStyle(LineStyles.DASH);
        }
        if (capBreak == null) {
            capBreak = new PolylineBreak();
            capBreak.setColor(Color.black);
        }
        if (flierBreak == null) {
            flierBreak = new PointBreak();
            flierBreak.setStyle(PointStyle.Plus);
        }
        if (meanBreak == null) {
            meanBreak = new PointBreak();
            ((PointBreak)meanBreak).setStyle(PointStyle.Square);
            ((PointBreak)meanBreak).setColor(Color.red);
            ((PointBreak)meanBreak).setOutlineColor(Color.black);
        }
        for (int i2 = 0; i2 < n; ++i2) {
            Array a = xdata.get(i2);
            if (Double.isNaN(ArrayMath.min(a))) continue;
            double v = positions.get(i2).doubleValue();
            double width = widths.get(i2).doubleValue();
            double q1 = Statistics.quantile(a, 1);
            double q3 = Statistics.quantile(a, 3);
            double median = Statistics.quantile(a, 2);
            double mind = ArrayMath.getMinimum(a);
            double maxd = ArrayMath.getMaximum(a);
            double mino = q1 - (q3 - q1) * 1.5;
            double maxo = q3 + (q3 - q1) * 1.5;
            ArrayList<org.meteoinfo.global.PointD> pList = new ArrayList<org.meteoinfo.global.PointD>();
            pList.add(new org.meteoinfo.global.PointD(v - width * 0.5, q1));
            pList.add(new org.meteoinfo.global.PointD(v - width * 0.5, q3));
            pList.add(new org.meteoinfo.global.PointD(v + width * 0.5, q3));
            pList.add(new org.meteoinfo.global.PointD(v + width * 0.5, q1));
            pList.add(new org.meteoinfo.global.PointD(v - width * 0.5, q1));
            PolygonShape pgs = new PolygonShape();
            pgs.setPoints(pList);
            gc.add(new Graphic(pgs, boxBreak));
            if (showmedians) {
                if (medianBreak.getBreakType() == BreakTypes.PolylineBreak) {
                    pList = new ArrayList();
                    pList.add(new org.meteoinfo.global.PointD(v - width * 0.5, median));
                    pList.add(new org.meteoinfo.global.PointD(v + width * 0.5, median));
                    PolylineShape pls = new PolylineShape();
                    pls.setPoints(pList);
                    gc.add(new Graphic(pls, medianBreak));
                } else {
                    PointShape ps = new PointShape();
                    ps.setPoint(new org.meteoinfo.global.PointD(v, median));
                    gc.add(new Graphic(ps, medianBreak));
                }
            }
            double min = Math.max(mino, mind);
            pList = new ArrayList();
            pList.add(new org.meteoinfo.global.PointD(v, q1));
            pList.add(new org.meteoinfo.global.PointD(v, min));
            PolylineShape pls = new PolylineShape();
            pls.setPoints(pList);
            gc.add(new Graphic(pls, whiskerBreak));
            if (showcaps) {
                pList = new ArrayList();
                pList.add(new org.meteoinfo.global.PointD(v - width * 0.25, min));
                pList.add(new org.meteoinfo.global.PointD(v + width * 0.25, min));
                pls = new PolylineShape();
                pls.setPoints(pList);
                gc.add(new Graphic(pls, capBreak));
            }
            if (showfliers && mino > mind) {
                int j = 0;
                while ((long)j < a.getSize()) {
                    if (a.getDouble(j) < mino) {
                        PointShape ps = new PointShape();
                        ps.setPoint(new org.meteoinfo.global.PointD(v, a.getDouble(j)));
                        gc.add(new Graphic(ps, flierBreak));
                    }
                    ++j;
                }
            }
            double max = Math.min(maxo, maxd);
            pList = new ArrayList();
            pList.add(new org.meteoinfo.global.PointD(v, q3));
            pList.add(new org.meteoinfo.global.PointD(v, max));
            pls = new PolylineShape();
            pls.setPoints(pList);
            gc.add(new Graphic(pls, whiskerBreak));
            if (showcaps) {
                pList = new ArrayList();
                pList.add(new org.meteoinfo.global.PointD(v - width * 0.25, max));
                pList.add(new org.meteoinfo.global.PointD(v + width * 0.25, max));
                pls = new PolylineShape();
                pls.setPoints(pList);
                gc.add(new Graphic(pls, capBreak));
            }
            if (showfliers && maxo < maxd) {
                int j = 0;
                while ((long)j < a.getSize()) {
                    if (a.getDouble(j) > maxo) {
                        PointShape ps = new PointShape();
                        ps.setPoint(new org.meteoinfo.global.PointD(v, a.getDouble(j)));
                        gc.add(new Graphic(ps, flierBreak));
                    }
                    ++j;
                }
            }
            if (!showmeans) continue;
            double mean = ArrayMath.mean(a);
            if (meanBreak.getBreakType() == BreakTypes.PointBreak) {
                PointShape ps = new PointShape();
                ps.setPoint(new org.meteoinfo.global.PointD(v, mean));
                gc.add(new Graphic(ps, meanBreak));
                continue;
            }
            pList = new ArrayList();
            pList.add(new org.meteoinfo.global.PointD(v - width * 0.5, mean));
            pList.add(new org.meteoinfo.global.PointD(v + width * 0.5, mean));
            pls = new PolylineShape();
            pls.setPoints(pList);
            gc.add(new Graphic(pls, meanBreak));
        }
        gc.setSingleLegend(false);
        return gc;
    }

    public static void polarToCartesian(GraphicCollection graphics) {
        for (int m = 0; m < graphics.getNumGraphics(); ++m) {
            Graphic graphic = graphics.get(m);
            for (int i = 0; i < graphic.getNumGraphics(); ++i) {
                Graphic gg = graphic.getGraphicN(i);
                Shape shape = gg.getShape();
                ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
                for (org.meteoinfo.global.PointD pointD : shape.getPoints()) {
                    double[] xy = MIMath.polarToCartesian(pointD.X, pointD.Y);
                    points.add(new org.meteoinfo.global.PointD(xy[0], xy[1]));
                }
                shape.setPoints(points);
            }
        }
        graphics.updateExtent();
    }

    private static int findIndex(double[] values, double v) {
        int idx = -1;
        for (int i = 0; i < values.length; ++i) {
            if (i == values.length - 1) {
                if (v != values[i]) continue;
                idx = i;
                break;
            }
            if (v != values[i] && !(v < values[i + 1])) continue;
            idx = i;
            break;
        }
        return idx;
    }
}

