/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.dataframe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.meteoinfo.data.dataframe.Column;
import org.meteoinfo.data.dataframe.Index;
import org.meteoinfo.ndarray.DataType;

public class ColumnIndex
extends Index<Column> {
    public List<String> getNames() {
        ArrayList<String> colNames = new ArrayList<String>();
        for (Column col : this.getValues()) {
            colNames.add(col.getName());
        }
        return colNames;
    }

    public List<DataType> getDataTypes() {
        ArrayList<DataType> dTypes = new ArrayList<DataType>();
        for (Column col : this.getValues()) {
            dTypes.add(col.getDataType());
        }
        return dTypes;
    }

    public List<String> getFormats() {
        ArrayList<String> formats = new ArrayList<String>();
        for (Column col : this.getValues()) {
            formats.add(col.getFormat());
        }
        return formats;
    }

    public int indexOfName(String colName) {
        return this.getNames().indexOf(colName);
    }

    public List<Integer> indexOfName(List<String> colNames) {
        ArrayList<Integer> r = new ArrayList<Integer>();
        for (String colName : colNames) {
            r.add(this.indexOfName(colName));
        }
        return r;
    }

    @Override
    public Integer[] indices(Object[] names) {
        return this.indices(Arrays.asList(names));
    }

    @Override
    public Integer[] indices(List<Object> names) {
        int size = names.size();
        Integer[] indices = new Integer[size];
        for (int i = 0; i < size; ++i) {
            indices[i] = this.indexOfName(names.get(i).toString());
        }
        return indices;
    }

    public boolean isSameDataType() {
        if (this.data.size() == 1) {
            return true;
        }
        DataType dt = ((Column)this.data.get((int)0)).dataType;
        for (int i = 1; i < this.data.size(); ++i) {
            if (dt == ((Column)this.data.get((int)i)).dataType) continue;
            return false;
        }
        return true;
    }

    public Index asIndex() {
        return Index.factory(this.getNames());
    }

    @Override
    public Object clone() {
        ColumnIndex r = new ColumnIndex();
        for (Column col : this.data) {
            r.add((Column)col.clone());
        }
        r.format = this.format;
        return r;
    }
}

